// services/media_session/public/mojom/media_session_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/media_session/public/mojom/media_session_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/media_session/public/mojom/media_session_service.mojom-params-data.h"
#include "services/media_session/public/mojom/media_session_service.mojom-shared-message-ids.h"

#include "services/media_session/public/mojom/media_session_service.mojom-import-headers.h"


#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_SERVICE_MOJOM_JUMBO_H_
#endif
namespace media_session {
namespace mojom {
const char MediaSessionService::Name_[] = "media_session.mojom.MediaSessionService";

MediaSessionServiceProxy::MediaSessionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionServiceProxy::BindAudioFocusManager(
    ::mojo::PendingReceiver<::media_session::mojom::AudioFocusManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSessionService::BindAudioFocusManager", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionService_BindAudioFocusManager_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media_session::mojom::internal::MediaSessionService_BindAudioFocusManager_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::AudioFocusManagerInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in MediaSessionService.BindAudioFocusManager request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("BindAudioFocusManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::BindAudioFocusManagerDebug(
    ::mojo::PendingReceiver<::media_session::mojom::AudioFocusManagerDebug> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSessionService::BindAudioFocusManagerDebug", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionService_BindAudioFocusManagerDebug_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media_session::mojom::internal::MediaSessionService_BindAudioFocusManagerDebug_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::AudioFocusManagerDebugInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in MediaSessionService.BindAudioFocusManagerDebug request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("BindAudioFocusManagerDebug");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::BindMediaControllerManager(
    ::mojo::PendingReceiver<::media_session::mojom::MediaControllerManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSessionService::BindMediaControllerManager", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionService_BindMediaControllerManager_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media_session::mojom::internal::MediaSessionService_BindMediaControllerManager_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::MediaControllerManagerInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in MediaSessionService.BindMediaControllerManager request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("BindMediaControllerManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaSessionServiceStubDispatch::Accept(
    MediaSessionService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kMediaSessionService_BindAudioFocusManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSessionService::BindAudioFocusManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSessionService::BindAudioFocusManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_BindAudioFocusManager_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_BindAudioFocusManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media_session::mojom::AudioFocusManager> p_receiver{};
      MediaSessionService_BindAudioFocusManager_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAudioFocusManager(
std::move(p_receiver));
      return true;
    }
    case internal::kMediaSessionService_BindAudioFocusManagerDebug_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSessionService::BindAudioFocusManagerDebug",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSessionService::BindAudioFocusManagerDebug");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_BindAudioFocusManagerDebug_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_BindAudioFocusManagerDebug_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media_session::mojom::AudioFocusManagerDebug> p_receiver{};
      MediaSessionService_BindAudioFocusManagerDebug_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAudioFocusManagerDebug(
std::move(p_receiver));
      return true;
    }
    case internal::kMediaSessionService_BindMediaControllerManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSessionService::BindMediaControllerManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSessionService::BindMediaControllerManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_BindMediaControllerManager_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_BindMediaControllerManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media_session::mojom::MediaControllerManager> p_receiver{};
      MediaSessionService_BindMediaControllerManager_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindMediaControllerManager(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool MediaSessionServiceStubDispatch::AcceptWithResponder(
    MediaSessionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaSessionService_BindAudioFocusManager_Name: {
      break;
    }
    case internal::kMediaSessionService_BindAudioFocusManagerDebug_Name: {
      break;
    }
    case internal::kMediaSessionService_BindMediaControllerManager_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaSessionServiceValidationInfo[] = {
    {internal::kMediaSessionService_BindAudioFocusManager_Name,
     {&internal::MediaSessionService_BindAudioFocusManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaSessionService_BindAudioFocusManagerDebug_Name,
     {&internal::MediaSessionService_BindAudioFocusManagerDebug_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaSessionService_BindMediaControllerManager_Name,
     {&internal::MediaSessionService_BindMediaControllerManager_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaSessionServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::MediaSessionService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaSessionServiceValidationInfo);
}

}  // namespace mojom
}  // namespace media_session

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif