// services/device/public/mojom/hid.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/device/public/mojom/hid.mojom-shared.h"
#include "services/device/public/mojom/hid.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace device {
namespace mojom {

class HidManagerClientProxy;

template <typename ImplRefTraits>
class HidManagerClientStub;

class HidManagerClientRequestValidator;


class  HidManagerClient
    : public HidManagerClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = HidManagerClientInterfaceBase;
  using Proxy_ = HidManagerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidManagerClientStub<ImplRefTraits>;

  using RequestValidator_ = HidManagerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDeviceAddedMinVersion = 0,
    kDeviceRemovedMinVersion = 0,
  };
  virtual ~HidManagerClient() {}

  
  virtual void DeviceAdded(HidDeviceInfoPtr device_info) = 0;

  
  virtual void DeviceRemoved(HidDeviceInfoPtr device_info) = 0;
};

class HidManagerProxy;

template <typename ImplRefTraits>
class HidManagerStub;

class HidManagerRequestValidator;
class HidManagerResponseValidator;


class  HidManager
    : public HidManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = HidManagerInterfaceBase;
  using Proxy_ = HidManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidManagerStub<ImplRefTraits>;

  using RequestValidator_ = HidManagerRequestValidator;
  using ResponseValidator_ = HidManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDevicesAndSetClientMinVersion = 0,
    kGetDevicesMinVersion = 0,
    kConnectMinVersion = 0,
    kAddReceiverMinVersion = 0,
  };
  virtual ~HidManager() {}


  using GetDevicesAndSetClientCallback = base::OnceCallback<void(std::vector<HidDeviceInfoPtr>)>;
  
  virtual void GetDevicesAndSetClient(::mojo::PendingAssociatedRemote<HidManagerClient> client, GetDevicesAndSetClientCallback callback) = 0;


  using GetDevicesCallback = base::OnceCallback<void(std::vector<HidDeviceInfoPtr>)>;
  
  virtual void GetDevices(GetDevicesCallback callback) = 0;


  using ConnectCallback = base::OnceCallback<void(::mojo::PendingRemote<HidConnection>)>;
  
  virtual void Connect(const std::string& device_guid, ::mojo::PendingRemote<HidConnectionClient> connection_client, ::mojo::PendingRemote<HidConnectionWatcher> watcher, ConnectCallback callback) = 0;

  
  virtual void AddReceiver(::mojo::PendingReceiver<HidManager> receiver) = 0;
};

class HidConnectionProxy;

template <typename ImplRefTraits>
class HidConnectionStub;

class HidConnectionRequestValidator;
class HidConnectionResponseValidator;


class  HidConnection
    : public HidConnectionInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = HidConnectionInterfaceBase;
  using Proxy_ = HidConnectionProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidConnectionStub<ImplRefTraits>;

  using RequestValidator_ = HidConnectionRequestValidator;
  using ResponseValidator_ = HidConnectionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
    kWriteMinVersion = 0,
    kGetFeatureReportMinVersion = 0,
    kSendFeatureReportMinVersion = 0,
  };
  virtual ~HidConnection() {}


  using ReadCallback = base::OnceCallback<void(bool, uint8_t, const base::Optional<std::vector<uint8_t>>&)>;
  
  virtual void Read(ReadCallback callback) = 0;


  using WriteCallback = base::OnceCallback<void(bool)>;
  
  virtual void Write(uint8_t report_id, const std::vector<uint8_t>& buffer, WriteCallback callback) = 0;


  using GetFeatureReportCallback = base::OnceCallback<void(bool, const base::Optional<std::vector<uint8_t>>&)>;
  
  virtual void GetFeatureReport(uint8_t report_id, GetFeatureReportCallback callback) = 0;


  using SendFeatureReportCallback = base::OnceCallback<void(bool)>;
  
  virtual void SendFeatureReport(uint8_t report_id, const std::vector<uint8_t>& buffer, SendFeatureReportCallback callback) = 0;
};

class HidConnectionClientProxy;

template <typename ImplRefTraits>
class HidConnectionClientStub;

class HidConnectionClientRequestValidator;


class  HidConnectionClient
    : public HidConnectionClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = HidConnectionClientInterfaceBase;
  using Proxy_ = HidConnectionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidConnectionClientStub<ImplRefTraits>;

  using RequestValidator_ = HidConnectionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnInputReportMinVersion = 0,
  };
  virtual ~HidConnectionClient() {}

  
  virtual void OnInputReport(uint8_t report_id, const std::vector<uint8_t>& buffer) = 0;
};

class HidConnectionWatcherProxy;

template <typename ImplRefTraits>
class HidConnectionWatcherStub;

class HidConnectionWatcherRequestValidator;


class  HidConnectionWatcher
    : public HidConnectionWatcherInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = HidConnectionWatcherInterfaceBase;
  using Proxy_ = HidConnectionWatcherProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidConnectionWatcherStub<ImplRefTraits>;

  using RequestValidator_ = HidConnectionWatcherRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };
  virtual ~HidConnectionWatcher() {}
};



class  HidManagerClientProxy
    : public HidManagerClient {
 public:
  using InterfaceType = HidManagerClient;

  explicit HidManagerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DeviceAdded(HidDeviceInfoPtr device_info) final;
  
  void DeviceRemoved(HidDeviceInfoPtr device_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HidManagerProxy
    : public HidManager {
 public:
  using InterfaceType = HidManager;

  explicit HidManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDevicesAndSetClient(::mojo::PendingAssociatedRemote<HidManagerClient> client, GetDevicesAndSetClientCallback callback) final;
  
  void GetDevices(GetDevicesCallback callback) final;
  
  void Connect(const std::string& device_guid, ::mojo::PendingRemote<HidConnectionClient> connection_client, ::mojo::PendingRemote<HidConnectionWatcher> watcher, ConnectCallback callback) final;
  
  void AddReceiver(::mojo::PendingReceiver<HidManager> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HidConnectionProxy
    : public HidConnection {
 public:
  using InterfaceType = HidConnection;

  explicit HidConnectionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Read(ReadCallback callback) final;
  
  void Write(uint8_t report_id, const std::vector<uint8_t>& buffer, WriteCallback callback) final;
  
  void GetFeatureReport(uint8_t report_id, GetFeatureReportCallback callback) final;
  
  void SendFeatureReport(uint8_t report_id, const std::vector<uint8_t>& buffer, SendFeatureReportCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HidConnectionClientProxy
    : public HidConnectionClient {
 public:
  using InterfaceType = HidConnectionClient;

  explicit HidConnectionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnInputReport(uint8_t report_id, const std::vector<uint8_t>& buffer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HidConnectionWatcherProxy
    : public HidConnectionWatcher {
 public:
  using InterfaceType = HidConnectionWatcher;

  explicit HidConnectionWatcherProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  HidManagerClientStubDispatch {
 public:
  static bool Accept(HidManagerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidManagerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidManagerClient>>
class HidManagerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidManagerClientStub() {}
  ~HidManagerClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidManagerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidManagerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HidManagerStubDispatch {
 public:
  static bool Accept(HidManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidManager>>
class HidManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidManagerStub() {}
  ~HidManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HidConnectionStubDispatch {
 public:
  static bool Accept(HidConnection* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidConnection* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidConnection>>
class HidConnectionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidConnectionStub() {}
  ~HidConnectionStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HidConnectionClientStubDispatch {
 public:
  static bool Accept(HidConnectionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidConnectionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidConnectionClient>>
class HidConnectionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidConnectionClientStub() {}
  ~HidConnectionClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HidConnectionWatcherStubDispatch {
 public:
  static bool Accept(HidConnectionWatcher* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidConnectionWatcher* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidConnectionWatcher>>
class HidConnectionWatcherStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidConnectionWatcherStub() {}
  ~HidConnectionWatcherStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionWatcherStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionWatcherStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HidManagerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HidManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HidConnectionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HidConnectionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HidConnectionWatcherRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HidManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HidConnectionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  HidUsageAndPage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidUsageAndPage, T>::value>;
  using DataView = HidUsageAndPageDataView;
  using Data_ = internal::HidUsageAndPage_Data;

  template <typename... Args>
  static HidUsageAndPagePtr New(Args&&... args) {
    return HidUsageAndPagePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidUsageAndPagePtr From(const U& u) {
    return mojo::TypeConverter<HidUsageAndPagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidUsageAndPage>::Convert(*this);
  }


  HidUsageAndPage();

  HidUsageAndPage(
      uint16_t usage,
      uint16_t usage_page);

  ~HidUsageAndPage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidUsageAndPagePtr>
  HidUsageAndPagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidUsageAndPage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidUsageAndPage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidUsageAndPage_UnserializedMessageContext<
            UserType, HidUsageAndPage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HidUsageAndPage::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return HidUsageAndPage::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidUsageAndPage_UnserializedMessageContext<
            UserType, HidUsageAndPage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidUsageAndPage::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint16_t usage;
  
  uint16_t usage_page;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class  HidReportItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidReportItem, T>::value>;
  using DataView = HidReportItemDataView;
  using Data_ = internal::HidReportItem_Data;

  template <typename... Args>
  static HidReportItemPtr New(Args&&... args) {
    return HidReportItemPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidReportItemPtr From(const U& u) {
    return mojo::TypeConverter<HidReportItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidReportItem>::Convert(*this);
  }


  HidReportItem();

  HidReportItem(
      bool is_range,
      bool is_constant,
      bool is_variable,
      bool is_relative,
      bool wrap,
      bool is_non_linear,
      bool no_preferred_state,
      bool has_null_position,
      bool is_volatile,
      bool is_buffered_bytes,
      std::vector<HidUsageAndPagePtr> usages,
      HidUsageAndPagePtr usage_minimum,
      HidUsageAndPagePtr usage_maximum,
      uint32_t designator_minimum,
      uint32_t designator_maximum,
      uint32_t string_minimum,
      uint32_t string_maximum,
      int32_t logical_minimum,
      int32_t logical_maximum,
      int32_t physical_minimum,
      int32_t physical_maximum,
      uint32_t unit_exponent,
      uint32_t unit,
      uint32_t report_size,
      uint32_t report_count);

  ~HidReportItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidReportItemPtr>
  HidReportItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidReportItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidReportItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidReportItem_UnserializedMessageContext<
            UserType, HidReportItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HidReportItem::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return HidReportItem::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidReportItem_UnserializedMessageContext<
            UserType, HidReportItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidReportItem::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool is_range;
  
  bool is_constant;
  
  bool is_variable;
  
  bool is_relative;
  
  bool wrap;
  
  bool is_non_linear;
  
  bool no_preferred_state;
  
  bool has_null_position;
  
  bool is_volatile;
  
  bool is_buffered_bytes;
  
  std::vector<HidUsageAndPagePtr> usages;
  
  HidUsageAndPagePtr usage_minimum;
  
  HidUsageAndPagePtr usage_maximum;
  
  uint32_t designator_minimum;
  
  uint32_t designator_maximum;
  
  uint32_t string_minimum;
  
  uint32_t string_maximum;
  
  int32_t logical_minimum;
  
  int32_t logical_maximum;
  
  int32_t physical_minimum;
  
  int32_t physical_maximum;
  
  uint32_t unit_exponent;
  
  uint32_t unit;
  
  uint32_t report_size;
  
  uint32_t report_count;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(HidReportItem);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HidReportDescription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidReportDescription, T>::value>;
  using DataView = HidReportDescriptionDataView;
  using Data_ = internal::HidReportDescription_Data;

  template <typename... Args>
  static HidReportDescriptionPtr New(Args&&... args) {
    return HidReportDescriptionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidReportDescriptionPtr From(const U& u) {
    return mojo::TypeConverter<HidReportDescriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidReportDescription>::Convert(*this);
  }


  HidReportDescription();

  HidReportDescription(
      uint8_t report_id,
      std::vector<HidReportItemPtr> items);

  ~HidReportDescription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidReportDescriptionPtr>
  HidReportDescriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidReportDescription::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidReportDescription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidReportDescription_UnserializedMessageContext<
            UserType, HidReportDescription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HidReportDescription::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return HidReportDescription::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidReportDescription_UnserializedMessageContext<
            UserType, HidReportDescription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidReportDescription::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint8_t report_id;
  
  std::vector<HidReportItemPtr> items;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(HidReportDescription);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HidCollectionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidCollectionInfo, T>::value>;
  using DataView = HidCollectionInfoDataView;
  using Data_ = internal::HidCollectionInfo_Data;

  template <typename... Args>
  static HidCollectionInfoPtr New(Args&&... args) {
    return HidCollectionInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidCollectionInfoPtr From(const U& u) {
    return mojo::TypeConverter<HidCollectionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidCollectionInfo>::Convert(*this);
  }


  HidCollectionInfo();

  HidCollectionInfo(
      HidUsageAndPagePtr usage,
      std::vector<uint8_t> report_ids,
      uint32_t collection_type,
      std::vector<HidReportDescriptionPtr> input_reports,
      std::vector<HidReportDescriptionPtr> output_reports,
      std::vector<HidReportDescriptionPtr> feature_reports,
      std::vector<HidCollectionInfoPtr> children);

  ~HidCollectionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidCollectionInfoPtr>
  HidCollectionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidCollectionInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidCollectionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidCollectionInfo_UnserializedMessageContext<
            UserType, HidCollectionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HidCollectionInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return HidCollectionInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidCollectionInfo_UnserializedMessageContext<
            UserType, HidCollectionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidCollectionInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  HidUsageAndPagePtr usage;
  
  std::vector<uint8_t> report_ids;
  
  uint32_t collection_type;
  
  std::vector<HidReportDescriptionPtr> input_reports;
  
  std::vector<HidReportDescriptionPtr> output_reports;
  
  std::vector<HidReportDescriptionPtr> feature_reports;
  
  std::vector<HidCollectionInfoPtr> children;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(HidCollectionInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HidDeviceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidDeviceInfo, T>::value>;
  using DataView = HidDeviceInfoDataView;
  using Data_ = internal::HidDeviceInfo_Data;

  template <typename... Args>
  static HidDeviceInfoPtr New(Args&&... args) {
    return HidDeviceInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidDeviceInfoPtr From(const U& u) {
    return mojo::TypeConverter<HidDeviceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidDeviceInfo>::Convert(*this);
  }


  HidDeviceInfo();

  HidDeviceInfo(
      const std::string& guid,
      const std::string& physical_device_id,
      uint16_t vendor_id,
      uint16_t product_id,
      const std::string& product_name,
      const std::string& serial_number,
      HidBusType bus_type,
      std::vector<uint8_t> report_descriptor,
      std::vector<HidCollectionInfoPtr> collections,
      bool has_report_id,
      uint64_t max_input_report_size,
      uint64_t max_output_report_size,
      uint64_t max_feature_report_size,
      const std::string& device_node);

  ~HidDeviceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidDeviceInfoPtr>
  HidDeviceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidDeviceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidDeviceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidDeviceInfo_UnserializedMessageContext<
            UserType, HidDeviceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HidDeviceInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return HidDeviceInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidDeviceInfo_UnserializedMessageContext<
            UserType, HidDeviceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidDeviceInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string guid;
  
  std::string physical_device_id;
  
  uint16_t vendor_id;
  
  uint16_t product_id;
  
  std::string product_name;
  
  std::string serial_number;
  
  HidBusType bus_type;
  
  std::vector<uint8_t> report_descriptor;
  
  std::vector<HidCollectionInfoPtr> collections;
  
  bool has_report_id;
  
  uint64_t max_input_report_size;
  
  uint64_t max_output_report_size;
  
  uint64_t max_feature_report_size;
  
  std::string device_node;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(HidDeviceInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HidUsageAndPagePtr HidUsageAndPage::Clone() const {
  return New(
      mojo::Clone(usage),
      mojo::Clone(usage_page)
  );
}

template <typename T, HidUsageAndPage::EnableIfSame<T>*>
bool HidUsageAndPage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->usage, other_struct.usage))
    return false;
  if (!mojo::Equals(this->usage_page, other_struct.usage_page))
    return false;
  return true;
}

template <typename T, HidUsageAndPage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.usage, rhs.usage))
    return true;
  if (std::less<>{}(rhs.usage, lhs.usage))
    return false;
  if (std::less<>{}(lhs.usage_page, rhs.usage_page))
    return true;
  if (std::less<>{}(rhs.usage_page, lhs.usage_page))
    return false;
  return false;
}
template <typename StructPtrType>
HidReportItemPtr HidReportItem::Clone() const {
  return New(
      mojo::Clone(is_range),
      mojo::Clone(is_constant),
      mojo::Clone(is_variable),
      mojo::Clone(is_relative),
      mojo::Clone(wrap),
      mojo::Clone(is_non_linear),
      mojo::Clone(no_preferred_state),
      mojo::Clone(has_null_position),
      mojo::Clone(is_volatile),
      mojo::Clone(is_buffered_bytes),
      mojo::Clone(usages),
      mojo::Clone(usage_minimum),
      mojo::Clone(usage_maximum),
      mojo::Clone(designator_minimum),
      mojo::Clone(designator_maximum),
      mojo::Clone(string_minimum),
      mojo::Clone(string_maximum),
      mojo::Clone(logical_minimum),
      mojo::Clone(logical_maximum),
      mojo::Clone(physical_minimum),
      mojo::Clone(physical_maximum),
      mojo::Clone(unit_exponent),
      mojo::Clone(unit),
      mojo::Clone(report_size),
      mojo::Clone(report_count)
  );
}

template <typename T, HidReportItem::EnableIfSame<T>*>
bool HidReportItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_range, other_struct.is_range))
    return false;
  if (!mojo::Equals(this->is_constant, other_struct.is_constant))
    return false;
  if (!mojo::Equals(this->is_variable, other_struct.is_variable))
    return false;
  if (!mojo::Equals(this->is_relative, other_struct.is_relative))
    return false;
  if (!mojo::Equals(this->wrap, other_struct.wrap))
    return false;
  if (!mojo::Equals(this->is_non_linear, other_struct.is_non_linear))
    return false;
  if (!mojo::Equals(this->no_preferred_state, other_struct.no_preferred_state))
    return false;
  if (!mojo::Equals(this->has_null_position, other_struct.has_null_position))
    return false;
  if (!mojo::Equals(this->is_volatile, other_struct.is_volatile))
    return false;
  if (!mojo::Equals(this->is_buffered_bytes, other_struct.is_buffered_bytes))
    return false;
  if (!mojo::Equals(this->usages, other_struct.usages))
    return false;
  if (!mojo::Equals(this->usage_minimum, other_struct.usage_minimum))
    return false;
  if (!mojo::Equals(this->usage_maximum, other_struct.usage_maximum))
    return false;
  if (!mojo::Equals(this->designator_minimum, other_struct.designator_minimum))
    return false;
  if (!mojo::Equals(this->designator_maximum, other_struct.designator_maximum))
    return false;
  if (!mojo::Equals(this->string_minimum, other_struct.string_minimum))
    return false;
  if (!mojo::Equals(this->string_maximum, other_struct.string_maximum))
    return false;
  if (!mojo::Equals(this->logical_minimum, other_struct.logical_minimum))
    return false;
  if (!mojo::Equals(this->logical_maximum, other_struct.logical_maximum))
    return false;
  if (!mojo::Equals(this->physical_minimum, other_struct.physical_minimum))
    return false;
  if (!mojo::Equals(this->physical_maximum, other_struct.physical_maximum))
    return false;
  if (!mojo::Equals(this->unit_exponent, other_struct.unit_exponent))
    return false;
  if (!mojo::Equals(this->unit, other_struct.unit))
    return false;
  if (!mojo::Equals(this->report_size, other_struct.report_size))
    return false;
  if (!mojo::Equals(this->report_count, other_struct.report_count))
    return false;
  return true;
}

template <typename T, HidReportItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.is_range, rhs.is_range))
    return true;
  if (std::less<>{}(rhs.is_range, lhs.is_range))
    return false;
  if (std::less<>{}(lhs.is_constant, rhs.is_constant))
    return true;
  if (std::less<>{}(rhs.is_constant, lhs.is_constant))
    return false;
  if (std::less<>{}(lhs.is_variable, rhs.is_variable))
    return true;
  if (std::less<>{}(rhs.is_variable, lhs.is_variable))
    return false;
  if (std::less<>{}(lhs.is_relative, rhs.is_relative))
    return true;
  if (std::less<>{}(rhs.is_relative, lhs.is_relative))
    return false;
  if (std::less<>{}(lhs.wrap, rhs.wrap))
    return true;
  if (std::less<>{}(rhs.wrap, lhs.wrap))
    return false;
  if (std::less<>{}(lhs.is_non_linear, rhs.is_non_linear))
    return true;
  if (std::less<>{}(rhs.is_non_linear, lhs.is_non_linear))
    return false;
  if (std::less<>{}(lhs.no_preferred_state, rhs.no_preferred_state))
    return true;
  if (std::less<>{}(rhs.no_preferred_state, lhs.no_preferred_state))
    return false;
  if (std::less<>{}(lhs.has_null_position, rhs.has_null_position))
    return true;
  if (std::less<>{}(rhs.has_null_position, lhs.has_null_position))
    return false;
  if (std::less<>{}(lhs.is_volatile, rhs.is_volatile))
    return true;
  if (std::less<>{}(rhs.is_volatile, lhs.is_volatile))
    return false;
  if (std::less<>{}(lhs.is_buffered_bytes, rhs.is_buffered_bytes))
    return true;
  if (std::less<>{}(rhs.is_buffered_bytes, lhs.is_buffered_bytes))
    return false;
  if (std::less<>{}(lhs.usages, rhs.usages))
    return true;
  if (std::less<>{}(rhs.usages, lhs.usages))
    return false;
  if (std::less<>{}(lhs.usage_minimum, rhs.usage_minimum))
    return true;
  if (std::less<>{}(rhs.usage_minimum, lhs.usage_minimum))
    return false;
  if (std::less<>{}(lhs.usage_maximum, rhs.usage_maximum))
    return true;
  if (std::less<>{}(rhs.usage_maximum, lhs.usage_maximum))
    return false;
  if (std::less<>{}(lhs.designator_minimum, rhs.designator_minimum))
    return true;
  if (std::less<>{}(rhs.designator_minimum, lhs.designator_minimum))
    return false;
  if (std::less<>{}(lhs.designator_maximum, rhs.designator_maximum))
    return true;
  if (std::less<>{}(rhs.designator_maximum, lhs.designator_maximum))
    return false;
  if (std::less<>{}(lhs.string_minimum, rhs.string_minimum))
    return true;
  if (std::less<>{}(rhs.string_minimum, lhs.string_minimum))
    return false;
  if (std::less<>{}(lhs.string_maximum, rhs.string_maximum))
    return true;
  if (std::less<>{}(rhs.string_maximum, lhs.string_maximum))
    return false;
  if (std::less<>{}(lhs.logical_minimum, rhs.logical_minimum))
    return true;
  if (std::less<>{}(rhs.logical_minimum, lhs.logical_minimum))
    return false;
  if (std::less<>{}(lhs.logical_maximum, rhs.logical_maximum))
    return true;
  if (std::less<>{}(rhs.logical_maximum, lhs.logical_maximum))
    return false;
  if (std::less<>{}(lhs.physical_minimum, rhs.physical_minimum))
    return true;
  if (std::less<>{}(rhs.physical_minimum, lhs.physical_minimum))
    return false;
  if (std::less<>{}(lhs.physical_maximum, rhs.physical_maximum))
    return true;
  if (std::less<>{}(rhs.physical_maximum, lhs.physical_maximum))
    return false;
  if (std::less<>{}(lhs.unit_exponent, rhs.unit_exponent))
    return true;
  if (std::less<>{}(rhs.unit_exponent, lhs.unit_exponent))
    return false;
  if (std::less<>{}(lhs.unit, rhs.unit))
    return true;
  if (std::less<>{}(rhs.unit, lhs.unit))
    return false;
  if (std::less<>{}(lhs.report_size, rhs.report_size))
    return true;
  if (std::less<>{}(rhs.report_size, lhs.report_size))
    return false;
  if (std::less<>{}(lhs.report_count, rhs.report_count))
    return true;
  if (std::less<>{}(rhs.report_count, lhs.report_count))
    return false;
  return false;
}
template <typename StructPtrType>
HidReportDescriptionPtr HidReportDescription::Clone() const {
  return New(
      mojo::Clone(report_id),
      mojo::Clone(items)
  );
}

template <typename T, HidReportDescription::EnableIfSame<T>*>
bool HidReportDescription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->report_id, other_struct.report_id))
    return false;
  if (!mojo::Equals(this->items, other_struct.items))
    return false;
  return true;
}

template <typename T, HidReportDescription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.report_id, rhs.report_id))
    return true;
  if (std::less<>{}(rhs.report_id, lhs.report_id))
    return false;
  if (std::less<>{}(lhs.items, rhs.items))
    return true;
  if (std::less<>{}(rhs.items, lhs.items))
    return false;
  return false;
}
template <typename StructPtrType>
HidCollectionInfoPtr HidCollectionInfo::Clone() const {
  return New(
      mojo::Clone(usage),
      mojo::Clone(report_ids),
      mojo::Clone(collection_type),
      mojo::Clone(input_reports),
      mojo::Clone(output_reports),
      mojo::Clone(feature_reports),
      mojo::Clone(children)
  );
}

template <typename T, HidCollectionInfo::EnableIfSame<T>*>
bool HidCollectionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->usage, other_struct.usage))
    return false;
  if (!mojo::Equals(this->report_ids, other_struct.report_ids))
    return false;
  if (!mojo::Equals(this->collection_type, other_struct.collection_type))
    return false;
  if (!mojo::Equals(this->input_reports, other_struct.input_reports))
    return false;
  if (!mojo::Equals(this->output_reports, other_struct.output_reports))
    return false;
  if (!mojo::Equals(this->feature_reports, other_struct.feature_reports))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  return true;
}

template <typename T, HidCollectionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.usage, rhs.usage))
    return true;
  if (std::less<>{}(rhs.usage, lhs.usage))
    return false;
  if (std::less<>{}(lhs.report_ids, rhs.report_ids))
    return true;
  if (std::less<>{}(rhs.report_ids, lhs.report_ids))
    return false;
  if (std::less<>{}(lhs.collection_type, rhs.collection_type))
    return true;
  if (std::less<>{}(rhs.collection_type, lhs.collection_type))
    return false;
  if (std::less<>{}(lhs.input_reports, rhs.input_reports))
    return true;
  if (std::less<>{}(rhs.input_reports, lhs.input_reports))
    return false;
  if (std::less<>{}(lhs.output_reports, rhs.output_reports))
    return true;
  if (std::less<>{}(rhs.output_reports, lhs.output_reports))
    return false;
  if (std::less<>{}(lhs.feature_reports, rhs.feature_reports))
    return true;
  if (std::less<>{}(rhs.feature_reports, lhs.feature_reports))
    return false;
  if (std::less<>{}(lhs.children, rhs.children))
    return true;
  if (std::less<>{}(rhs.children, lhs.children))
    return false;
  return false;
}
template <typename StructPtrType>
HidDeviceInfoPtr HidDeviceInfo::Clone() const {
  return New(
      mojo::Clone(guid),
      mojo::Clone(physical_device_id),
      mojo::Clone(vendor_id),
      mojo::Clone(product_id),
      mojo::Clone(product_name),
      mojo::Clone(serial_number),
      mojo::Clone(bus_type),
      mojo::Clone(report_descriptor),
      mojo::Clone(collections),
      mojo::Clone(has_report_id),
      mojo::Clone(max_input_report_size),
      mojo::Clone(max_output_report_size),
      mojo::Clone(max_feature_report_size),
      mojo::Clone(device_node)
  );
}

template <typename T, HidDeviceInfo::EnableIfSame<T>*>
bool HidDeviceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->guid, other_struct.guid))
    return false;
  if (!mojo::Equals(this->physical_device_id, other_struct.physical_device_id))
    return false;
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  if (!mojo::Equals(this->product_id, other_struct.product_id))
    return false;
  if (!mojo::Equals(this->product_name, other_struct.product_name))
    return false;
  if (!mojo::Equals(this->serial_number, other_struct.serial_number))
    return false;
  if (!mojo::Equals(this->bus_type, other_struct.bus_type))
    return false;
  if (!mojo::Equals(this->report_descriptor, other_struct.report_descriptor))
    return false;
  if (!mojo::Equals(this->collections, other_struct.collections))
    return false;
  if (!mojo::Equals(this->has_report_id, other_struct.has_report_id))
    return false;
  if (!mojo::Equals(this->max_input_report_size, other_struct.max_input_report_size))
    return false;
  if (!mojo::Equals(this->max_output_report_size, other_struct.max_output_report_size))
    return false;
  if (!mojo::Equals(this->max_feature_report_size, other_struct.max_feature_report_size))
    return false;
  if (!mojo::Equals(this->device_node, other_struct.device_node))
    return false;
  return true;
}

template <typename T, HidDeviceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.guid, rhs.guid))
    return true;
  if (std::less<>{}(rhs.guid, lhs.guid))
    return false;
  if (std::less<>{}(lhs.physical_device_id, rhs.physical_device_id))
    return true;
  if (std::less<>{}(rhs.physical_device_id, lhs.physical_device_id))
    return false;
  if (std::less<>{}(lhs.vendor_id, rhs.vendor_id))
    return true;
  if (std::less<>{}(rhs.vendor_id, lhs.vendor_id))
    return false;
  if (std::less<>{}(lhs.product_id, rhs.product_id))
    return true;
  if (std::less<>{}(rhs.product_id, lhs.product_id))
    return false;
  if (std::less<>{}(lhs.product_name, rhs.product_name))
    return true;
  if (std::less<>{}(rhs.product_name, lhs.product_name))
    return false;
  if (std::less<>{}(lhs.serial_number, rhs.serial_number))
    return true;
  if (std::less<>{}(rhs.serial_number, lhs.serial_number))
    return false;
  if (std::less<>{}(lhs.bus_type, rhs.bus_type))
    return true;
  if (std::less<>{}(rhs.bus_type, lhs.bus_type))
    return false;
  if (std::less<>{}(lhs.report_descriptor, rhs.report_descriptor))
    return true;
  if (std::less<>{}(rhs.report_descriptor, lhs.report_descriptor))
    return false;
  if (std::less<>{}(lhs.collections, rhs.collections))
    return true;
  if (std::less<>{}(rhs.collections, lhs.collections))
    return false;
  if (std::less<>{}(lhs.has_report_id, rhs.has_report_id))
    return true;
  if (std::less<>{}(rhs.has_report_id, lhs.has_report_id))
    return false;
  if (std::less<>{}(lhs.max_input_report_size, rhs.max_input_report_size))
    return true;
  if (std::less<>{}(rhs.max_input_report_size, lhs.max_input_report_size))
    return false;
  if (std::less<>{}(lhs.max_output_report_size, rhs.max_output_report_size))
    return true;
  if (std::less<>{}(rhs.max_output_report_size, lhs.max_output_report_size))
    return false;
  if (std::less<>{}(lhs.max_feature_report_size, rhs.max_feature_report_size))
    return true;
  if (std::less<>{}(rhs.max_feature_report_size, lhs.max_feature_report_size))
    return false;
  if (std::less<>{}(lhs.device_node, rhs.device_node))
    return true;
  if (std::less<>{}(rhs.device_node, lhs.device_node))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace device

namespace mojo {


template <>
struct  StructTraits<::device::mojom::HidUsageAndPage::DataView,
                                         ::device::mojom::HidUsageAndPagePtr> {
  static bool IsNull(const ::device::mojom::HidUsageAndPagePtr& input) { return !input; }
  static void SetToNull(::device::mojom::HidUsageAndPagePtr* output) { output->reset(); }

  static decltype(::device::mojom::HidUsageAndPage::usage) usage(
      const ::device::mojom::HidUsageAndPagePtr& input) {
    return input->usage;
  }

  static decltype(::device::mojom::HidUsageAndPage::usage_page) usage_page(
      const ::device::mojom::HidUsageAndPagePtr& input) {
    return input->usage_page;
  }

  static bool Read(::device::mojom::HidUsageAndPage::DataView input, ::device::mojom::HidUsageAndPagePtr* output);
};


template <>
struct  StructTraits<::device::mojom::HidReportItem::DataView,
                                         ::device::mojom::HidReportItemPtr> {
  static bool IsNull(const ::device::mojom::HidReportItemPtr& input) { return !input; }
  static void SetToNull(::device::mojom::HidReportItemPtr* output) { output->reset(); }

  static decltype(::device::mojom::HidReportItem::is_range) is_range(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->is_range;
  }

  static decltype(::device::mojom::HidReportItem::is_constant) is_constant(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->is_constant;
  }

  static decltype(::device::mojom::HidReportItem::is_variable) is_variable(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->is_variable;
  }

  static decltype(::device::mojom::HidReportItem::is_relative) is_relative(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->is_relative;
  }

  static decltype(::device::mojom::HidReportItem::wrap) wrap(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->wrap;
  }

  static decltype(::device::mojom::HidReportItem::is_non_linear) is_non_linear(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->is_non_linear;
  }

  static decltype(::device::mojom::HidReportItem::no_preferred_state) no_preferred_state(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->no_preferred_state;
  }

  static decltype(::device::mojom::HidReportItem::has_null_position) has_null_position(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->has_null_position;
  }

  static decltype(::device::mojom::HidReportItem::is_volatile) is_volatile(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->is_volatile;
  }

  static decltype(::device::mojom::HidReportItem::is_buffered_bytes) is_buffered_bytes(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->is_buffered_bytes;
  }

  static const decltype(::device::mojom::HidReportItem::usages)& usages(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->usages;
  }

  static const decltype(::device::mojom::HidReportItem::usage_minimum)& usage_minimum(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->usage_minimum;
  }

  static const decltype(::device::mojom::HidReportItem::usage_maximum)& usage_maximum(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->usage_maximum;
  }

  static decltype(::device::mojom::HidReportItem::designator_minimum) designator_minimum(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->designator_minimum;
  }

  static decltype(::device::mojom::HidReportItem::designator_maximum) designator_maximum(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->designator_maximum;
  }

  static decltype(::device::mojom::HidReportItem::string_minimum) string_minimum(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->string_minimum;
  }

  static decltype(::device::mojom::HidReportItem::string_maximum) string_maximum(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->string_maximum;
  }

  static decltype(::device::mojom::HidReportItem::logical_minimum) logical_minimum(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->logical_minimum;
  }

  static decltype(::device::mojom::HidReportItem::logical_maximum) logical_maximum(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->logical_maximum;
  }

  static decltype(::device::mojom::HidReportItem::physical_minimum) physical_minimum(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->physical_minimum;
  }

  static decltype(::device::mojom::HidReportItem::physical_maximum) physical_maximum(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->physical_maximum;
  }

  static decltype(::device::mojom::HidReportItem::unit_exponent) unit_exponent(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->unit_exponent;
  }

  static decltype(::device::mojom::HidReportItem::unit) unit(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->unit;
  }

  static decltype(::device::mojom::HidReportItem::report_size) report_size(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->report_size;
  }

  static decltype(::device::mojom::HidReportItem::report_count) report_count(
      const ::device::mojom::HidReportItemPtr& input) {
    return input->report_count;
  }

  static bool Read(::device::mojom::HidReportItem::DataView input, ::device::mojom::HidReportItemPtr* output);
};


template <>
struct  StructTraits<::device::mojom::HidReportDescription::DataView,
                                         ::device::mojom::HidReportDescriptionPtr> {
  static bool IsNull(const ::device::mojom::HidReportDescriptionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::HidReportDescriptionPtr* output) { output->reset(); }

  static decltype(::device::mojom::HidReportDescription::report_id) report_id(
      const ::device::mojom::HidReportDescriptionPtr& input) {
    return input->report_id;
  }

  static const decltype(::device::mojom::HidReportDescription::items)& items(
      const ::device::mojom::HidReportDescriptionPtr& input) {
    return input->items;
  }

  static bool Read(::device::mojom::HidReportDescription::DataView input, ::device::mojom::HidReportDescriptionPtr* output);
};


template <>
struct  StructTraits<::device::mojom::HidCollectionInfo::DataView,
                                         ::device::mojom::HidCollectionInfoPtr> {
  static bool IsNull(const ::device::mojom::HidCollectionInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::HidCollectionInfoPtr* output) { output->reset(); }

  static const decltype(::device::mojom::HidCollectionInfo::usage)& usage(
      const ::device::mojom::HidCollectionInfoPtr& input) {
    return input->usage;
  }

  static const decltype(::device::mojom::HidCollectionInfo::report_ids)& report_ids(
      const ::device::mojom::HidCollectionInfoPtr& input) {
    return input->report_ids;
  }

  static decltype(::device::mojom::HidCollectionInfo::collection_type) collection_type(
      const ::device::mojom::HidCollectionInfoPtr& input) {
    return input->collection_type;
  }

  static const decltype(::device::mojom::HidCollectionInfo::input_reports)& input_reports(
      const ::device::mojom::HidCollectionInfoPtr& input) {
    return input->input_reports;
  }

  static const decltype(::device::mojom::HidCollectionInfo::output_reports)& output_reports(
      const ::device::mojom::HidCollectionInfoPtr& input) {
    return input->output_reports;
  }

  static const decltype(::device::mojom::HidCollectionInfo::feature_reports)& feature_reports(
      const ::device::mojom::HidCollectionInfoPtr& input) {
    return input->feature_reports;
  }

  static const decltype(::device::mojom::HidCollectionInfo::children)& children(
      const ::device::mojom::HidCollectionInfoPtr& input) {
    return input->children;
  }

  static bool Read(::device::mojom::HidCollectionInfo::DataView input, ::device::mojom::HidCollectionInfoPtr* output);
};


template <>
struct  StructTraits<::device::mojom::HidDeviceInfo::DataView,
                                         ::device::mojom::HidDeviceInfoPtr> {
  static bool IsNull(const ::device::mojom::HidDeviceInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::HidDeviceInfoPtr* output) { output->reset(); }

  static const decltype(::device::mojom::HidDeviceInfo::guid)& guid(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->guid;
  }

  static const decltype(::device::mojom::HidDeviceInfo::physical_device_id)& physical_device_id(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->physical_device_id;
  }

  static decltype(::device::mojom::HidDeviceInfo::vendor_id) vendor_id(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->vendor_id;
  }

  static decltype(::device::mojom::HidDeviceInfo::product_id) product_id(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->product_id;
  }

  static const decltype(::device::mojom::HidDeviceInfo::product_name)& product_name(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->product_name;
  }

  static const decltype(::device::mojom::HidDeviceInfo::serial_number)& serial_number(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->serial_number;
  }

  static decltype(::device::mojom::HidDeviceInfo::bus_type) bus_type(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->bus_type;
  }

  static const decltype(::device::mojom::HidDeviceInfo::report_descriptor)& report_descriptor(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->report_descriptor;
  }

  static const decltype(::device::mojom::HidDeviceInfo::collections)& collections(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->collections;
  }

  static decltype(::device::mojom::HidDeviceInfo::has_report_id) has_report_id(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->has_report_id;
  }

  static decltype(::device::mojom::HidDeviceInfo::max_input_report_size) max_input_report_size(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->max_input_report_size;
  }

  static decltype(::device::mojom::HidDeviceInfo::max_output_report_size) max_output_report_size(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->max_output_report_size;
  }

  static decltype(::device::mojom::HidDeviceInfo::max_feature_report_size) max_feature_report_size(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->max_feature_report_size;
  }

  static const decltype(::device::mojom::HidDeviceInfo::device_node)& device_node(
      const ::device::mojom::HidDeviceInfoPtr& input) {
    return input->device_node;
  }

  static bool Read(::device::mojom::HidDeviceInfo::DataView input, ::device::mojom::HidDeviceInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_H_