// services/content/public/mojom/navigable_contents_factory.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_FACTORY_MOJOM_SHARED_H_
#define SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_FACTORY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/content/public/mojom/navigable_contents_factory.mojom-shared-internal.h"
#include "services/content/public/mojom/navigable_contents.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace content {
namespace mojom {
class NavigableContentsParamsDataView;



}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::NavigableContentsParamsDataView> {
  using Data = ::content::mojom::internal::NavigableContentsParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {
// Interface base classes. They are used for type safety check.
class NavigableContentsFactoryInterfaceBase {};

using NavigableContentsFactoryPtrDataView =
    mojo::InterfacePtrDataView<NavigableContentsFactoryInterfaceBase>;
using NavigableContentsFactoryRequestDataView =
    mojo::InterfaceRequestDataView<NavigableContentsFactoryInterfaceBase>;
using NavigableContentsFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NavigableContentsFactoryInterfaceBase>;
using NavigableContentsFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NavigableContentsFactoryInterfaceBase>;


class NavigableContentsParamsDataView {
 public:
  NavigableContentsParamsDataView() {}

  NavigableContentsParamsDataView(
      internal::NavigableContentsParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool enable_view_auto_resize() const {
    return data_->enable_view_auto_resize;
  }
  inline void GetAutoResizeMinSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAutoResizeMinSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `auto_resize_min_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAutoResizeMinSize` instead "
    "of `ReadAutoResizeMinSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auto_resize_min_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetAutoResizeMaxSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAutoResizeMaxSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `auto_resize_max_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAutoResizeMaxSize` instead "
    "of `ReadAutoResizeMaxSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auto_resize_max_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  bool suppress_navigations() const {
    return data_->suppress_navigations;
  }
  bool override_background_color() const {
    return data_->override_background_color;
  }
  uint32_t background_color() const {
    return data_->background_color;
  }
 private:
  internal::NavigableContentsParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::NavigableContentsParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::NavigableContentsParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::NavigableContentsParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->enable_view_auto_resize = Traits::enable_view_auto_resize(input);
    decltype(Traits::auto_resize_min_size(input)) in_auto_resize_min_size = Traits::auto_resize_min_size(input);
    typename decltype((*output)->auto_resize_min_size)::BaseType::BufferWriter
        auto_resize_min_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_auto_resize_min_size, buffer, &auto_resize_min_size_writer, context);
    (*output)->auto_resize_min_size.Set(
        auto_resize_min_size_writer.is_null() ? nullptr : auto_resize_min_size_writer.data());
    decltype(Traits::auto_resize_max_size(input)) in_auto_resize_max_size = Traits::auto_resize_max_size(input);
    typename decltype((*output)->auto_resize_max_size)::BaseType::BufferWriter
        auto_resize_max_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_auto_resize_max_size, buffer, &auto_resize_max_size_writer, context);
    (*output)->auto_resize_max_size.Set(
        auto_resize_max_size_writer.is_null() ? nullptr : auto_resize_max_size_writer.data());
    (*output)->suppress_navigations = Traits::suppress_navigations(input);
    (*output)->override_background_color = Traits::override_background_color(input);
    (*output)->background_color = Traits::background_color(input);
  }

  static bool Deserialize(::content::mojom::internal::NavigableContentsParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::NavigableContentsParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {

inline void NavigableContentsParamsDataView::GetAutoResizeMinSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->auto_resize_min_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void NavigableContentsParamsDataView::GetAutoResizeMaxSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->auto_resize_max_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace content

#endif  // SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_FACTORY_MOJOM_SHARED_H_