// media/mojo/mojom/video_encode_accelerator.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom-shared.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom-forward.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "media/mojo/mojom/video_encoder_info.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "media/mojo/mojom/video_encode_accelerator_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {

class VideoEncodeAcceleratorProviderProxy;

template <typename ImplRefTraits>
class VideoEncodeAcceleratorProviderStub;

class VideoEncodeAcceleratorProviderRequestValidator;
class VideoEncodeAcceleratorProviderResponseValidator;


class  VideoEncodeAcceleratorProvider
    : public VideoEncodeAcceleratorProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = VideoEncodeAcceleratorProviderInterfaceBase;
  using Proxy_ = VideoEncodeAcceleratorProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEncodeAcceleratorProviderStub<ImplRefTraits>;

  using RequestValidator_ = VideoEncodeAcceleratorProviderRequestValidator;
  using ResponseValidator_ = VideoEncodeAcceleratorProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateVideoEncodeAcceleratorMinVersion = 0,
    kGetVideoEncodeAcceleratorSupportedProfilesMinVersion = 0,
  };
  virtual ~VideoEncodeAcceleratorProvider() {}

  
  virtual void CreateVideoEncodeAccelerator(::mojo::PendingReceiver<VideoEncodeAccelerator> receiver) = 0;


  using GetVideoEncodeAcceleratorSupportedProfilesCallback = base::OnceCallback<void(const std::vector<::media::VideoEncodeAccelerator::SupportedProfile>&)>;
  
  virtual void GetVideoEncodeAcceleratorSupportedProfiles(GetVideoEncodeAcceleratorSupportedProfilesCallback callback) = 0;
};

class VideoEncodeAcceleratorProxy;

template <typename ImplRefTraits>
class VideoEncodeAcceleratorStub;

class VideoEncodeAcceleratorRequestValidator;
class VideoEncodeAcceleratorResponseValidator;


class  VideoEncodeAccelerator
    : public VideoEncodeAcceleratorInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = VideoEncodeAcceleratorInterfaceBase;
  using Proxy_ = VideoEncodeAcceleratorProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEncodeAcceleratorStub<ImplRefTraits>;

  using RequestValidator_ = VideoEncodeAcceleratorRequestValidator;
  using ResponseValidator_ = VideoEncodeAcceleratorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kEncodeMinVersion = 0,
    kUseOutputBitstreamBufferMinVersion = 0,
    kRequestEncodingParametersChangeMinVersion = 0,
    kIsFlushSupportedMinVersion = 0,
    kFlushMinVersion = 0,
  };
  
  using Error = VideoEncodeAccelerator_Error;
  virtual ~VideoEncodeAccelerator() {}

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Initialize(const ::media::VideoEncodeAccelerator::Config& config, ::mojo::PendingRemote<VideoEncodeAcceleratorClient> client, bool* out_result);

  using InitializeCallback = base::OnceCallback<void(bool)>;
  
  virtual void Initialize(const ::media::VideoEncodeAccelerator::Config& config, ::mojo::PendingRemote<VideoEncodeAcceleratorClient> client, InitializeCallback callback) = 0;


  using EncodeCallback = base::OnceCallback<void()>;
  
  virtual void Encode(const ::scoped_refptr<::media::VideoFrame>& frame, bool force_keyframe, EncodeCallback callback) = 0;

  
  virtual void UseOutputBitstreamBuffer(int32_t bitstream_buffer_id, ::mojo::ScopedSharedBufferHandle buffer) = 0;

  
  virtual void RequestEncodingParametersChange(const ::media::VideoBitrateAllocation& bitrate_allocation, uint32_t framerate) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsFlushSupported(bool* out_result);

  using IsFlushSupportedCallback = base::OnceCallback<void(bool)>;
  
  virtual void IsFlushSupported(IsFlushSupportedCallback callback) = 0;


  using FlushCallback = base::OnceCallback<void(bool)>;
  
  virtual void Flush(FlushCallback callback) = 0;
};

class VideoEncodeAcceleratorClientProxy;

template <typename ImplRefTraits>
class VideoEncodeAcceleratorClientStub;

class VideoEncodeAcceleratorClientRequestValidator;


class  VideoEncodeAcceleratorClient
    : public VideoEncodeAcceleratorClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = VideoEncodeAcceleratorClientInterfaceBase;
  using Proxy_ = VideoEncodeAcceleratorClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEncodeAcceleratorClientStub<ImplRefTraits>;

  using RequestValidator_ = VideoEncodeAcceleratorClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequireBitstreamBuffersMinVersion = 0,
    kBitstreamBufferReadyMinVersion = 0,
    kNotifyErrorMinVersion = 0,
    kNotifyEncoderInfoChangeMinVersion = 0,
  };
  virtual ~VideoEncodeAcceleratorClient() {}

  
  virtual void RequireBitstreamBuffers(uint32_t input_count, const ::gfx::Size& input_coded_size, uint32_t output_buffer_size) = 0;

  
  virtual void BitstreamBufferReady(int32_t bitstream_buffer_id, const ::media::BitstreamBufferMetadata& metadata) = 0;

  
  virtual void NotifyError(::media::VideoEncodeAccelerator::Error error) = 0;

  
  virtual void NotifyEncoderInfoChange(const ::media::VideoEncoderInfo& info) = 0;
};



class  VideoEncodeAcceleratorProviderProxy
    : public VideoEncodeAcceleratorProvider {
 public:
  using InterfaceType = VideoEncodeAcceleratorProvider;

  explicit VideoEncodeAcceleratorProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateVideoEncodeAccelerator(::mojo::PendingReceiver<VideoEncodeAccelerator> receiver) final;
  
  void GetVideoEncodeAcceleratorSupportedProfiles(GetVideoEncodeAcceleratorSupportedProfilesCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  VideoEncodeAcceleratorProxy
    : public VideoEncodeAccelerator {
 public:
  using InterfaceType = VideoEncodeAccelerator;

  explicit VideoEncodeAcceleratorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Initialize(const ::media::VideoEncodeAccelerator::Config& config, ::mojo::PendingRemote<VideoEncodeAcceleratorClient> client, bool* out_result) final;
  
  void Initialize(const ::media::VideoEncodeAccelerator::Config& config, ::mojo::PendingRemote<VideoEncodeAcceleratorClient> client, InitializeCallback callback) final;
  
  void Encode(const ::scoped_refptr<::media::VideoFrame>& frame, bool force_keyframe, EncodeCallback callback) final;
  
  void UseOutputBitstreamBuffer(int32_t bitstream_buffer_id, ::mojo::ScopedSharedBufferHandle buffer) final;
  
  void RequestEncodingParametersChange(const ::media::VideoBitrateAllocation& bitrate_allocation, uint32_t framerate) final;
  
  bool IsFlushSupported(bool* out_result) final;
  
  void IsFlushSupported(IsFlushSupportedCallback callback) final;
  
  void Flush(FlushCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  VideoEncodeAcceleratorClientProxy
    : public VideoEncodeAcceleratorClient {
 public:
  using InterfaceType = VideoEncodeAcceleratorClient;

  explicit VideoEncodeAcceleratorClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequireBitstreamBuffers(uint32_t input_count, const ::gfx::Size& input_coded_size, uint32_t output_buffer_size) final;
  
  void BitstreamBufferReady(int32_t bitstream_buffer_id, const ::media::BitstreamBufferMetadata& metadata) final;
  
  void NotifyError(::media::VideoEncodeAccelerator::Error error) final;
  
  void NotifyEncoderInfoChange(const ::media::VideoEncoderInfo& info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoEncodeAcceleratorProviderStubDispatch {
 public:
  static bool Accept(VideoEncodeAcceleratorProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEncodeAcceleratorProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEncodeAcceleratorProvider>>
class VideoEncodeAcceleratorProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEncodeAcceleratorProviderStub() {}
  ~VideoEncodeAcceleratorProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoEncodeAcceleratorStubDispatch {
 public:
  static bool Accept(VideoEncodeAccelerator* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEncodeAccelerator* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEncodeAccelerator>>
class VideoEncodeAcceleratorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEncodeAcceleratorStub() {}
  ~VideoEncodeAcceleratorStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoEncodeAcceleratorClientStubDispatch {
 public:
  static bool Accept(VideoEncodeAcceleratorClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEncodeAcceleratorClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEncodeAcceleratorClient>>
class VideoEncodeAcceleratorClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEncodeAcceleratorClientStub() {}
  ~VideoEncodeAcceleratorClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncodeAcceleratorClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoEncodeAcceleratorProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoEncodeAcceleratorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoEncodeAcceleratorClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoEncodeAcceleratorProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoEncodeAcceleratorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  Vp8Metadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Vp8Metadata, T>::value>;
  using DataView = Vp8MetadataDataView;
  using Data_ = internal::Vp8Metadata_Data;

  template <typename... Args>
  static Vp8MetadataPtr New(Args&&... args) {
    return Vp8MetadataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Vp8MetadataPtr From(const U& u) {
    return mojo::TypeConverter<Vp8MetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Vp8Metadata>::Convert(*this);
  }


  Vp8Metadata();

  Vp8Metadata(
      bool non_reference,
      uint8_t temporal_idx,
      bool layer_sync);

  ~Vp8Metadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Vp8MetadataPtr>
  Vp8MetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vp8Metadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Vp8Metadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Vp8Metadata_UnserializedMessageContext<
            UserType, Vp8Metadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<Vp8Metadata::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return Vp8Metadata::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Vp8Metadata_UnserializedMessageContext<
            UserType, Vp8Metadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Vp8Metadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool non_reference;
  
  uint8_t temporal_idx;
  
  bool layer_sync;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Vp8Metadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  CodecMetadata {
 public:
  using DataView = CodecMetadataDataView;
  using Data_ = internal::CodecMetadata_Data;
  using Tag = Data_::CodecMetadata_Tag;

  static CodecMetadataPtr New() {
    return CodecMetadataPtr(base::in_place);
  }
  // Construct an instance holding |vp8|.
  static CodecMetadataPtr
  NewVp8(
      const ::media::Vp8Metadata& vp8) {
    auto result = CodecMetadataPtr(base::in_place);
    result->set_vp8(std::move(vp8));
    return result;
  }
  // Construct an instance holding |vp9|.
  static CodecMetadataPtr
  NewVp9(
      const ::media::Vp9Metadata& vp9) {
    auto result = CodecMetadataPtr(base::in_place);
    result->set_vp9(std::move(vp9));
    return result;
  }

  template <typename U>
  static CodecMetadataPtr From(const U& u) {
    return mojo::TypeConverter<CodecMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CodecMetadata>::Convert(*this);
  }

  CodecMetadata();
  ~CodecMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CodecMetadataPtr>
  CodecMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CodecMetadata>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_vp8() const { return tag_ == Tag::VP8; }

  
  ::media::Vp8Metadata& get_vp8() const {
    DCHECK(tag_ == Tag::VP8);
    return *(data_.vp8);
  }

  
  void set_vp8(
      const ::media::Vp8Metadata& vp8);
  
  bool is_vp9() const { return tag_ == Tag::VP9; }

  
  ::media::Vp9Metadata& get_vp9() const {
    DCHECK(tag_ == Tag::VP9);
    return *(data_.vp9);
  }

  
  void set_vp9(
      const ::media::Vp9Metadata& vp9);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CodecMetadata::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CodecMetadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    ::media::Vp8Metadata* vp8;
    ::media::Vp9Metadata* vp9;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  VideoEncodeAcceleratorSupportedProfile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoEncodeAcceleratorSupportedProfile, T>::value>;
  using DataView = VideoEncodeAcceleratorSupportedProfileDataView;
  using Data_ = internal::VideoEncodeAcceleratorSupportedProfile_Data;

  template <typename... Args>
  static VideoEncodeAcceleratorSupportedProfilePtr New(Args&&... args) {
    return VideoEncodeAcceleratorSupportedProfilePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoEncodeAcceleratorSupportedProfilePtr From(const U& u) {
    return mojo::TypeConverter<VideoEncodeAcceleratorSupportedProfilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoEncodeAcceleratorSupportedProfile>::Convert(*this);
  }


  VideoEncodeAcceleratorSupportedProfile();

  VideoEncodeAcceleratorSupportedProfile(
      ::media::VideoCodecProfile profile,
      const ::gfx::Size& min_resolution,
      const ::gfx::Size& max_resolution,
      uint32_t max_framerate_numerator,
      uint32_t max_framerate_denominator);

  ~VideoEncodeAcceleratorSupportedProfile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoEncodeAcceleratorSupportedProfilePtr>
  VideoEncodeAcceleratorSupportedProfilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoEncodeAcceleratorSupportedProfile::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoEncodeAcceleratorSupportedProfile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoEncodeAcceleratorSupportedProfile_UnserializedMessageContext<
            UserType, VideoEncodeAcceleratorSupportedProfile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoEncodeAcceleratorSupportedProfile::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoEncodeAcceleratorSupportedProfile::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoEncodeAcceleratorSupportedProfile_UnserializedMessageContext<
            UserType, VideoEncodeAcceleratorSupportedProfile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoEncodeAcceleratorSupportedProfile::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::media::VideoCodecProfile profile;
  
  ::gfx::Size min_resolution;
  
  ::gfx::Size max_resolution;
  
  uint32_t max_framerate_numerator;
  
  uint32_t max_framerate_denominator;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoBitrateAllocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoBitrateAllocation, T>::value>;
  using DataView = VideoBitrateAllocationDataView;
  using Data_ = internal::VideoBitrateAllocation_Data;

  template <typename... Args>
  static VideoBitrateAllocationPtr New(Args&&... args) {
    return VideoBitrateAllocationPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoBitrateAllocationPtr From(const U& u) {
    return mojo::TypeConverter<VideoBitrateAllocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoBitrateAllocation>::Convert(*this);
  }


  VideoBitrateAllocation();

  explicit VideoBitrateAllocation(
      std::vector<int32_t> bitrates);

  ~VideoBitrateAllocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoBitrateAllocationPtr>
  VideoBitrateAllocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoBitrateAllocation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoBitrateAllocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoBitrateAllocation_UnserializedMessageContext<
            UserType, VideoBitrateAllocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoBitrateAllocation::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoBitrateAllocation::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoBitrateAllocation_UnserializedMessageContext<
            UserType, VideoBitrateAllocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoBitrateAllocation::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<int32_t> bitrates;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoBitrateAllocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SpatialLayer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpatialLayer, T>::value>;
  using DataView = SpatialLayerDataView;
  using Data_ = internal::SpatialLayer_Data;

  template <typename... Args>
  static SpatialLayerPtr New(Args&&... args) {
    return SpatialLayerPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpatialLayerPtr From(const U& u) {
    return mojo::TypeConverter<SpatialLayerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpatialLayer>::Convert(*this);
  }


  SpatialLayer();

  SpatialLayer(
      int32_t width,
      int32_t height,
      uint32_t bitrate_bps,
      uint32_t framerate,
      uint8_t max_qp,
      uint8_t num_of_temporal_layers);

  ~SpatialLayer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpatialLayerPtr>
  SpatialLayerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpatialLayer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpatialLayer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpatialLayer_UnserializedMessageContext<
            UserType, SpatialLayer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SpatialLayer::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SpatialLayer::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpatialLayer_UnserializedMessageContext<
            UserType, SpatialLayer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpatialLayer::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t width;
  
  int32_t height;
  
  uint32_t bitrate_bps;
  
  uint32_t framerate;
  
  uint8_t max_qp;
  
  uint8_t num_of_temporal_layers;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpatialLayer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoEncodeAcceleratorConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoEncodeAcceleratorConfig, T>::value>;
  using DataView = VideoEncodeAcceleratorConfigDataView;
  using Data_ = internal::VideoEncodeAcceleratorConfig_Data;
  using ContentType = VideoEncodeAcceleratorConfig_ContentType;
  using StorageType = VideoEncodeAcceleratorConfig_StorageType;

  template <typename... Args>
  static VideoEncodeAcceleratorConfigPtr New(Args&&... args) {
    return VideoEncodeAcceleratorConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoEncodeAcceleratorConfigPtr From(const U& u) {
    return mojo::TypeConverter<VideoEncodeAcceleratorConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoEncodeAcceleratorConfig>::Convert(*this);
  }


  VideoEncodeAcceleratorConfig();

  VideoEncodeAcceleratorConfig(
      ::media::VideoPixelFormat input_format,
      const ::gfx::Size& input_visible_size,
      ::media::VideoCodecProfile output_profile,
      uint32_t initial_bitrate,
      uint32_t initial_framerate,
      bool has_initial_framerate,
      uint32_t gop_length,
      bool has_gop_length,
      uint8_t h264_output_level,
      bool has_h264_output_level,
      bool is_constrained_h264,
      VideoEncodeAcceleratorConfig::StorageType storage_type,
      bool has_storage_type,
      VideoEncodeAcceleratorConfig::ContentType content_type,
      std::vector<::media::VideoEncodeAccelerator::Config::SpatialLayer> spatial_layers);

  ~VideoEncodeAcceleratorConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoEncodeAcceleratorConfigPtr>
  VideoEncodeAcceleratorConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoEncodeAcceleratorConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoEncodeAcceleratorConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoEncodeAcceleratorConfig_UnserializedMessageContext<
            UserType, VideoEncodeAcceleratorConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoEncodeAcceleratorConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoEncodeAcceleratorConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoEncodeAcceleratorConfig_UnserializedMessageContext<
            UserType, VideoEncodeAcceleratorConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoEncodeAcceleratorConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::media::VideoPixelFormat input_format;
  
  ::gfx::Size input_visible_size;
  
  ::media::VideoCodecProfile output_profile;
  
  uint32_t initial_bitrate;
  
  uint32_t initial_framerate;
  
  bool has_initial_framerate;
  
  uint32_t gop_length;
  
  bool has_gop_length;
  
  uint8_t h264_output_level;
  
  bool has_h264_output_level;
  
  bool is_constrained_h264;
  
  VideoEncodeAcceleratorConfig::StorageType storage_type;
  
  bool has_storage_type;
  
  VideoEncodeAcceleratorConfig::ContentType content_type;
  
  std::vector<::media::VideoEncodeAccelerator::Config::SpatialLayer> spatial_layers;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  Vp9Metadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Vp9Metadata, T>::value>;
  using DataView = Vp9MetadataDataView;
  using Data_ = internal::Vp9Metadata_Data;

  template <typename... Args>
  static Vp9MetadataPtr New(Args&&... args) {
    return Vp9MetadataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Vp9MetadataPtr From(const U& u) {
    return mojo::TypeConverter<Vp9MetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Vp9Metadata>::Convert(*this);
  }


  Vp9Metadata();

  Vp9Metadata(
      bool has_reference,
      bool temporal_up_switch,
      uint8_t temporal_idx,
      std::vector<uint8_t> p_diffs);

  ~Vp9Metadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Vp9MetadataPtr>
  Vp9MetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vp9Metadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Vp9Metadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Vp9Metadata_UnserializedMessageContext<
            UserType, Vp9Metadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<Vp9Metadata::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return Vp9Metadata::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Vp9Metadata_UnserializedMessageContext<
            UserType, Vp9Metadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Vp9Metadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool has_reference;
  
  bool temporal_up_switch;
  
  uint8_t temporal_idx;
  
  std::vector<uint8_t> p_diffs;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Vp9Metadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BitstreamBufferMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BitstreamBufferMetadata, T>::value>;
  using DataView = BitstreamBufferMetadataDataView;
  using Data_ = internal::BitstreamBufferMetadata_Data;

  template <typename... Args>
  static BitstreamBufferMetadataPtr New(Args&&... args) {
    return BitstreamBufferMetadataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BitstreamBufferMetadataPtr From(const U& u) {
    return mojo::TypeConverter<BitstreamBufferMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BitstreamBufferMetadata>::Convert(*this);
  }


  BitstreamBufferMetadata();

  BitstreamBufferMetadata(
      uint32_t payload_size_bytes,
      bool key_frame,
      ::base::TimeDelta timestamp,
      CodecMetadataPtr codec_metadata);

  ~BitstreamBufferMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BitstreamBufferMetadataPtr>
  BitstreamBufferMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BitstreamBufferMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BitstreamBufferMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BitstreamBufferMetadata_UnserializedMessageContext<
            UserType, BitstreamBufferMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BitstreamBufferMetadata::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BitstreamBufferMetadata::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BitstreamBufferMetadata_UnserializedMessageContext<
            UserType, BitstreamBufferMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BitstreamBufferMetadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t payload_size_bytes;
  
  bool key_frame;
  
  ::base::TimeDelta timestamp;
  
  CodecMetadataPtr codec_metadata;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(BitstreamBufferMetadata);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BitstreamBufferMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
CodecMetadataPtr CodecMetadata::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::VP8:
      rv->set_vp8(mojo::Clone(*data_.vp8));
      break;
    case Tag::VP9:
      rv->set_vp9(mojo::Clone(*data_.vp9));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CodecMetadata>::value>::type*>
bool CodecMetadata::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::VP8:
      return mojo::Equals(*(data_.vp8), *(other.data_.vp8));
    case Tag::VP9:
      return mojo::Equals(*(data_.vp9), *(other.data_.vp9));
  }

  return false;
}
template <typename StructPtrType>
VideoEncodeAcceleratorSupportedProfilePtr VideoEncodeAcceleratorSupportedProfile::Clone() const {
  return New(
      mojo::Clone(profile),
      mojo::Clone(min_resolution),
      mojo::Clone(max_resolution),
      mojo::Clone(max_framerate_numerator),
      mojo::Clone(max_framerate_denominator)
  );
}

template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>*>
bool VideoEncodeAcceleratorSupportedProfile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->min_resolution, other_struct.min_resolution))
    return false;
  if (!mojo::Equals(this->max_resolution, other_struct.max_resolution))
    return false;
  if (!mojo::Equals(this->max_framerate_numerator, other_struct.max_framerate_numerator))
    return false;
  if (!mojo::Equals(this->max_framerate_denominator, other_struct.max_framerate_denominator))
    return false;
  return true;
}

template <typename T, VideoEncodeAcceleratorSupportedProfile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.profile, rhs.profile))
    return true;
  if (std::less<>{}(rhs.profile, lhs.profile))
    return false;
  if (std::less<>{}(lhs.min_resolution, rhs.min_resolution))
    return true;
  if (std::less<>{}(rhs.min_resolution, lhs.min_resolution))
    return false;
  if (std::less<>{}(lhs.max_resolution, rhs.max_resolution))
    return true;
  if (std::less<>{}(rhs.max_resolution, lhs.max_resolution))
    return false;
  if (std::less<>{}(lhs.max_framerate_numerator, rhs.max_framerate_numerator))
    return true;
  if (std::less<>{}(rhs.max_framerate_numerator, lhs.max_framerate_numerator))
    return false;
  if (std::less<>{}(lhs.max_framerate_denominator, rhs.max_framerate_denominator))
    return true;
  if (std::less<>{}(rhs.max_framerate_denominator, lhs.max_framerate_denominator))
    return false;
  return false;
}
template <typename StructPtrType>
VideoBitrateAllocationPtr VideoBitrateAllocation::Clone() const {
  return New(
      mojo::Clone(bitrates)
  );
}

template <typename T, VideoBitrateAllocation::EnableIfSame<T>*>
bool VideoBitrateAllocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bitrates, other_struct.bitrates))
    return false;
  return true;
}

template <typename T, VideoBitrateAllocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.bitrates, rhs.bitrates))
    return true;
  if (std::less<>{}(rhs.bitrates, lhs.bitrates))
    return false;
  return false;
}
template <typename StructPtrType>
SpatialLayerPtr SpatialLayer::Clone() const {
  return New(
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(bitrate_bps),
      mojo::Clone(framerate),
      mojo::Clone(max_qp),
      mojo::Clone(num_of_temporal_layers)
  );
}

template <typename T, SpatialLayer::EnableIfSame<T>*>
bool SpatialLayer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->bitrate_bps, other_struct.bitrate_bps))
    return false;
  if (!mojo::Equals(this->framerate, other_struct.framerate))
    return false;
  if (!mojo::Equals(this->max_qp, other_struct.max_qp))
    return false;
  if (!mojo::Equals(this->num_of_temporal_layers, other_struct.num_of_temporal_layers))
    return false;
  return true;
}

template <typename T, SpatialLayer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.width, rhs.width))
    return true;
  if (std::less<>{}(rhs.width, lhs.width))
    return false;
  if (std::less<>{}(lhs.height, rhs.height))
    return true;
  if (std::less<>{}(rhs.height, lhs.height))
    return false;
  if (std::less<>{}(lhs.bitrate_bps, rhs.bitrate_bps))
    return true;
  if (std::less<>{}(rhs.bitrate_bps, lhs.bitrate_bps))
    return false;
  if (std::less<>{}(lhs.framerate, rhs.framerate))
    return true;
  if (std::less<>{}(rhs.framerate, lhs.framerate))
    return false;
  if (std::less<>{}(lhs.max_qp, rhs.max_qp))
    return true;
  if (std::less<>{}(rhs.max_qp, lhs.max_qp))
    return false;
  if (std::less<>{}(lhs.num_of_temporal_layers, rhs.num_of_temporal_layers))
    return true;
  if (std::less<>{}(rhs.num_of_temporal_layers, lhs.num_of_temporal_layers))
    return false;
  return false;
}
template <typename StructPtrType>
VideoEncodeAcceleratorConfigPtr VideoEncodeAcceleratorConfig::Clone() const {
  return New(
      mojo::Clone(input_format),
      mojo::Clone(input_visible_size),
      mojo::Clone(output_profile),
      mojo::Clone(initial_bitrate),
      mojo::Clone(initial_framerate),
      mojo::Clone(has_initial_framerate),
      mojo::Clone(gop_length),
      mojo::Clone(has_gop_length),
      mojo::Clone(h264_output_level),
      mojo::Clone(has_h264_output_level),
      mojo::Clone(is_constrained_h264),
      mojo::Clone(storage_type),
      mojo::Clone(has_storage_type),
      mojo::Clone(content_type),
      mojo::Clone(spatial_layers)
  );
}

template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>*>
bool VideoEncodeAcceleratorConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_format, other_struct.input_format))
    return false;
  if (!mojo::Equals(this->input_visible_size, other_struct.input_visible_size))
    return false;
  if (!mojo::Equals(this->output_profile, other_struct.output_profile))
    return false;
  if (!mojo::Equals(this->initial_bitrate, other_struct.initial_bitrate))
    return false;
  if (!mojo::Equals(this->initial_framerate, other_struct.initial_framerate))
    return false;
  if (!mojo::Equals(this->has_initial_framerate, other_struct.has_initial_framerate))
    return false;
  if (!mojo::Equals(this->gop_length, other_struct.gop_length))
    return false;
  if (!mojo::Equals(this->has_gop_length, other_struct.has_gop_length))
    return false;
  if (!mojo::Equals(this->h264_output_level, other_struct.h264_output_level))
    return false;
  if (!mojo::Equals(this->has_h264_output_level, other_struct.has_h264_output_level))
    return false;
  if (!mojo::Equals(this->is_constrained_h264, other_struct.is_constrained_h264))
    return false;
  if (!mojo::Equals(this->storage_type, other_struct.storage_type))
    return false;
  if (!mojo::Equals(this->has_storage_type, other_struct.has_storage_type))
    return false;
  if (!mojo::Equals(this->content_type, other_struct.content_type))
    return false;
  if (!mojo::Equals(this->spatial_layers, other_struct.spatial_layers))
    return false;
  return true;
}

template <typename T, VideoEncodeAcceleratorConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.input_format, rhs.input_format))
    return true;
  if (std::less<>{}(rhs.input_format, lhs.input_format))
    return false;
  if (std::less<>{}(lhs.input_visible_size, rhs.input_visible_size))
    return true;
  if (std::less<>{}(rhs.input_visible_size, lhs.input_visible_size))
    return false;
  if (std::less<>{}(lhs.output_profile, rhs.output_profile))
    return true;
  if (std::less<>{}(rhs.output_profile, lhs.output_profile))
    return false;
  if (std::less<>{}(lhs.initial_bitrate, rhs.initial_bitrate))
    return true;
  if (std::less<>{}(rhs.initial_bitrate, lhs.initial_bitrate))
    return false;
  if (std::less<>{}(lhs.initial_framerate, rhs.initial_framerate))
    return true;
  if (std::less<>{}(rhs.initial_framerate, lhs.initial_framerate))
    return false;
  if (std::less<>{}(lhs.has_initial_framerate, rhs.has_initial_framerate))
    return true;
  if (std::less<>{}(rhs.has_initial_framerate, lhs.has_initial_framerate))
    return false;
  if (std::less<>{}(lhs.gop_length, rhs.gop_length))
    return true;
  if (std::less<>{}(rhs.gop_length, lhs.gop_length))
    return false;
  if (std::less<>{}(lhs.has_gop_length, rhs.has_gop_length))
    return true;
  if (std::less<>{}(rhs.has_gop_length, lhs.has_gop_length))
    return false;
  if (std::less<>{}(lhs.h264_output_level, rhs.h264_output_level))
    return true;
  if (std::less<>{}(rhs.h264_output_level, lhs.h264_output_level))
    return false;
  if (std::less<>{}(lhs.has_h264_output_level, rhs.has_h264_output_level))
    return true;
  if (std::less<>{}(rhs.has_h264_output_level, lhs.has_h264_output_level))
    return false;
  if (std::less<>{}(lhs.is_constrained_h264, rhs.is_constrained_h264))
    return true;
  if (std::less<>{}(rhs.is_constrained_h264, lhs.is_constrained_h264))
    return false;
  if (std::less<>{}(lhs.storage_type, rhs.storage_type))
    return true;
  if (std::less<>{}(rhs.storage_type, lhs.storage_type))
    return false;
  if (std::less<>{}(lhs.has_storage_type, rhs.has_storage_type))
    return true;
  if (std::less<>{}(rhs.has_storage_type, lhs.has_storage_type))
    return false;
  if (std::less<>{}(lhs.content_type, rhs.content_type))
    return true;
  if (std::less<>{}(rhs.content_type, lhs.content_type))
    return false;
  if (std::less<>{}(lhs.spatial_layers, rhs.spatial_layers))
    return true;
  if (std::less<>{}(rhs.spatial_layers, lhs.spatial_layers))
    return false;
  return false;
}
template <typename StructPtrType>
Vp8MetadataPtr Vp8Metadata::Clone() const {
  return New(
      mojo::Clone(non_reference),
      mojo::Clone(temporal_idx),
      mojo::Clone(layer_sync)
  );
}

template <typename T, Vp8Metadata::EnableIfSame<T>*>
bool Vp8Metadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->non_reference, other_struct.non_reference))
    return false;
  if (!mojo::Equals(this->temporal_idx, other_struct.temporal_idx))
    return false;
  if (!mojo::Equals(this->layer_sync, other_struct.layer_sync))
    return false;
  return true;
}

template <typename T, Vp8Metadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.non_reference, rhs.non_reference))
    return true;
  if (std::less<>{}(rhs.non_reference, lhs.non_reference))
    return false;
  if (std::less<>{}(lhs.temporal_idx, rhs.temporal_idx))
    return true;
  if (std::less<>{}(rhs.temporal_idx, lhs.temporal_idx))
    return false;
  if (std::less<>{}(lhs.layer_sync, rhs.layer_sync))
    return true;
  if (std::less<>{}(rhs.layer_sync, lhs.layer_sync))
    return false;
  return false;
}
template <typename StructPtrType>
Vp9MetadataPtr Vp9Metadata::Clone() const {
  return New(
      mojo::Clone(has_reference),
      mojo::Clone(temporal_up_switch),
      mojo::Clone(temporal_idx),
      mojo::Clone(p_diffs)
  );
}

template <typename T, Vp9Metadata::EnableIfSame<T>*>
bool Vp9Metadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_reference, other_struct.has_reference))
    return false;
  if (!mojo::Equals(this->temporal_up_switch, other_struct.temporal_up_switch))
    return false;
  if (!mojo::Equals(this->temporal_idx, other_struct.temporal_idx))
    return false;
  if (!mojo::Equals(this->p_diffs, other_struct.p_diffs))
    return false;
  return true;
}

template <typename T, Vp9Metadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.has_reference, rhs.has_reference))
    return true;
  if (std::less<>{}(rhs.has_reference, lhs.has_reference))
    return false;
  if (std::less<>{}(lhs.temporal_up_switch, rhs.temporal_up_switch))
    return true;
  if (std::less<>{}(rhs.temporal_up_switch, lhs.temporal_up_switch))
    return false;
  if (std::less<>{}(lhs.temporal_idx, rhs.temporal_idx))
    return true;
  if (std::less<>{}(rhs.temporal_idx, lhs.temporal_idx))
    return false;
  if (std::less<>{}(lhs.p_diffs, rhs.p_diffs))
    return true;
  if (std::less<>{}(rhs.p_diffs, lhs.p_diffs))
    return false;
  return false;
}
template <typename StructPtrType>
BitstreamBufferMetadataPtr BitstreamBufferMetadata::Clone() const {
  return New(
      mojo::Clone(payload_size_bytes),
      mojo::Clone(key_frame),
      mojo::Clone(timestamp),
      mojo::Clone(codec_metadata)
  );
}

template <typename T, BitstreamBufferMetadata::EnableIfSame<T>*>
bool BitstreamBufferMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->payload_size_bytes, other_struct.payload_size_bytes))
    return false;
  if (!mojo::Equals(this->key_frame, other_struct.key_frame))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->codec_metadata, other_struct.codec_metadata))
    return false;
  return true;
}

template <typename T, BitstreamBufferMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.payload_size_bytes, rhs.payload_size_bytes))
    return true;
  if (std::less<>{}(rhs.payload_size_bytes, lhs.payload_size_bytes))
    return false;
  if (std::less<>{}(lhs.key_frame, rhs.key_frame))
    return true;
  if (std::less<>{}(rhs.key_frame, lhs.key_frame))
    return false;
  if (std::less<>{}(lhs.timestamp, rhs.timestamp))
    return true;
  if (std::less<>{}(rhs.timestamp, lhs.timestamp))
    return false;
  if (std::less<>{}(lhs.codec_metadata, rhs.codec_metadata))
    return true;
  if (std::less<>{}(rhs.codec_metadata, lhs.codec_metadata))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct  StructTraits<::media::mojom::VideoEncodeAcceleratorSupportedProfile::DataView,
                                         ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr> {
  static bool IsNull(const ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoEncodeAcceleratorSupportedProfile::profile) profile(
      const ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->profile;
  }

  static const decltype(::media::mojom::VideoEncodeAcceleratorSupportedProfile::min_resolution)& min_resolution(
      const ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->min_resolution;
  }

  static const decltype(::media::mojom::VideoEncodeAcceleratorSupportedProfile::max_resolution)& max_resolution(
      const ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->max_resolution;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorSupportedProfile::max_framerate_numerator) max_framerate_numerator(
      const ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->max_framerate_numerator;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorSupportedProfile::max_framerate_denominator) max_framerate_denominator(
      const ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr& input) {
    return input->max_framerate_denominator;
  }

  static bool Read(::media::mojom::VideoEncodeAcceleratorSupportedProfile::DataView input, ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoBitrateAllocation::DataView,
                                         ::media::mojom::VideoBitrateAllocationPtr> {
  static bool IsNull(const ::media::mojom::VideoBitrateAllocationPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoBitrateAllocationPtr* output) { output->reset(); }

  static const decltype(::media::mojom::VideoBitrateAllocation::bitrates)& bitrates(
      const ::media::mojom::VideoBitrateAllocationPtr& input) {
    return input->bitrates;
  }

  static bool Read(::media::mojom::VideoBitrateAllocation::DataView input, ::media::mojom::VideoBitrateAllocationPtr* output);
};


template <>
struct  StructTraits<::media::mojom::SpatialLayer::DataView,
                                         ::media::mojom::SpatialLayerPtr> {
  static bool IsNull(const ::media::mojom::SpatialLayerPtr& input) { return !input; }
  static void SetToNull(::media::mojom::SpatialLayerPtr* output) { output->reset(); }

  static decltype(::media::mojom::SpatialLayer::width) width(
      const ::media::mojom::SpatialLayerPtr& input) {
    return input->width;
  }

  static decltype(::media::mojom::SpatialLayer::height) height(
      const ::media::mojom::SpatialLayerPtr& input) {
    return input->height;
  }

  static decltype(::media::mojom::SpatialLayer::bitrate_bps) bitrate_bps(
      const ::media::mojom::SpatialLayerPtr& input) {
    return input->bitrate_bps;
  }

  static decltype(::media::mojom::SpatialLayer::framerate) framerate(
      const ::media::mojom::SpatialLayerPtr& input) {
    return input->framerate;
  }

  static decltype(::media::mojom::SpatialLayer::max_qp) max_qp(
      const ::media::mojom::SpatialLayerPtr& input) {
    return input->max_qp;
  }

  static decltype(::media::mojom::SpatialLayer::num_of_temporal_layers) num_of_temporal_layers(
      const ::media::mojom::SpatialLayerPtr& input) {
    return input->num_of_temporal_layers;
  }

  static bool Read(::media::mojom::SpatialLayer::DataView input, ::media::mojom::SpatialLayerPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoEncodeAcceleratorConfig::DataView,
                                         ::media::mojom::VideoEncodeAcceleratorConfigPtr> {
  static bool IsNull(const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoEncodeAcceleratorConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::input_format) input_format(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->input_format;
  }

  static const decltype(::media::mojom::VideoEncodeAcceleratorConfig::input_visible_size)& input_visible_size(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->input_visible_size;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::output_profile) output_profile(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->output_profile;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::initial_bitrate) initial_bitrate(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->initial_bitrate;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::initial_framerate) initial_framerate(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->initial_framerate;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::has_initial_framerate) has_initial_framerate(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->has_initial_framerate;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::gop_length) gop_length(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->gop_length;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::has_gop_length) has_gop_length(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->has_gop_length;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::h264_output_level) h264_output_level(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->h264_output_level;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::has_h264_output_level) has_h264_output_level(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->has_h264_output_level;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::is_constrained_h264) is_constrained_h264(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->is_constrained_h264;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::storage_type) storage_type(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->storage_type;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::has_storage_type) has_storage_type(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->has_storage_type;
  }

  static decltype(::media::mojom::VideoEncodeAcceleratorConfig::content_type) content_type(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->content_type;
  }

  static const decltype(::media::mojom::VideoEncodeAcceleratorConfig::spatial_layers)& spatial_layers(
      const ::media::mojom::VideoEncodeAcceleratorConfigPtr& input) {
    return input->spatial_layers;
  }

  static bool Read(::media::mojom::VideoEncodeAcceleratorConfig::DataView input, ::media::mojom::VideoEncodeAcceleratorConfigPtr* output);
};


template <>
struct  StructTraits<::media::mojom::Vp8Metadata::DataView,
                                         ::media::mojom::Vp8MetadataPtr> {
  static bool IsNull(const ::media::mojom::Vp8MetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::Vp8MetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::Vp8Metadata::non_reference) non_reference(
      const ::media::mojom::Vp8MetadataPtr& input) {
    return input->non_reference;
  }

  static decltype(::media::mojom::Vp8Metadata::temporal_idx) temporal_idx(
      const ::media::mojom::Vp8MetadataPtr& input) {
    return input->temporal_idx;
  }

  static decltype(::media::mojom::Vp8Metadata::layer_sync) layer_sync(
      const ::media::mojom::Vp8MetadataPtr& input) {
    return input->layer_sync;
  }

  static bool Read(::media::mojom::Vp8Metadata::DataView input, ::media::mojom::Vp8MetadataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::Vp9Metadata::DataView,
                                         ::media::mojom::Vp9MetadataPtr> {
  static bool IsNull(const ::media::mojom::Vp9MetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::Vp9MetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::Vp9Metadata::has_reference) has_reference(
      const ::media::mojom::Vp9MetadataPtr& input) {
    return input->has_reference;
  }

  static decltype(::media::mojom::Vp9Metadata::temporal_up_switch) temporal_up_switch(
      const ::media::mojom::Vp9MetadataPtr& input) {
    return input->temporal_up_switch;
  }

  static decltype(::media::mojom::Vp9Metadata::temporal_idx) temporal_idx(
      const ::media::mojom::Vp9MetadataPtr& input) {
    return input->temporal_idx;
  }

  static const decltype(::media::mojom::Vp9Metadata::p_diffs)& p_diffs(
      const ::media::mojom::Vp9MetadataPtr& input) {
    return input->p_diffs;
  }

  static bool Read(::media::mojom::Vp9Metadata::DataView input, ::media::mojom::Vp9MetadataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::BitstreamBufferMetadata::DataView,
                                         ::media::mojom::BitstreamBufferMetadataPtr> {
  static bool IsNull(const ::media::mojom::BitstreamBufferMetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::BitstreamBufferMetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::BitstreamBufferMetadata::payload_size_bytes) payload_size_bytes(
      const ::media::mojom::BitstreamBufferMetadataPtr& input) {
    return input->payload_size_bytes;
  }

  static decltype(::media::mojom::BitstreamBufferMetadata::key_frame) key_frame(
      const ::media::mojom::BitstreamBufferMetadataPtr& input) {
    return input->key_frame;
  }

  static const decltype(::media::mojom::BitstreamBufferMetadata::timestamp)& timestamp(
      const ::media::mojom::BitstreamBufferMetadataPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::mojom::BitstreamBufferMetadata::codec_metadata)& codec_metadata(
      const ::media::mojom::BitstreamBufferMetadataPtr& input) {
    return input->codec_metadata;
  }

  static bool Read(::media::mojom::BitstreamBufferMetadata::DataView input, ::media::mojom::BitstreamBufferMetadataPtr* output);
};


template <>
struct  UnionTraits<::media::mojom::CodecMetadata::DataView,
                                        ::media::mojom::CodecMetadataPtr> {
  static bool IsNull(const ::media::mojom::CodecMetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::CodecMetadataPtr* output) { output->reset(); }

  static ::media::mojom::CodecMetadata::Tag GetTag(const ::media::mojom::CodecMetadataPtr& input) {
    return input->which();
  }

  static const ::media::Vp8Metadata& vp8(const ::media::mojom::CodecMetadataPtr& input) {
    return input->get_vp8();
  }

  static const ::media::Vp9Metadata& vp9(const ::media::mojom::CodecMetadataPtr& input) {
    return input->get_vp9();
  }

  static bool Read(::media::mojom::CodecMetadata::DataView input, ::media::mojom::CodecMetadataPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_H_