// media/mojo/mojom/cdm_storage.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CDM_STORAGE_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_CDM_STORAGE_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace media {
namespace mojom {
namespace internal {
class  CdmStorage_Open_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CdmStorage_Open_Params_Data));
      new (data()) CdmStorage_Open_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CdmStorage_Open_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CdmStorage_Open_Params_Data>(index_);
    }
    CdmStorage_Open_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> file_name;

 private:
  CdmStorage_Open_Params_Data();
  ~CdmStorage_Open_Params_Data() = delete;
};
static_assert(sizeof(CdmStorage_Open_Params_Data) == 16,
              "Bad sizeof(CdmStorage_Open_Params_Data)");
class  CdmStorage_Open_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CdmStorage_Open_ResponseParams_Data));
      new (data()) CdmStorage_Open_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CdmStorage_Open_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CdmStorage_Open_ResponseParams_Data>(index_);
    }
    CdmStorage_Open_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  mojo::internal::AssociatedInterface_Data cdm_file;
  uint8_t padfinal_[4];

 private:
  CdmStorage_Open_ResponseParams_Data();
  ~CdmStorage_Open_ResponseParams_Data() = delete;
};
static_assert(sizeof(CdmStorage_Open_ResponseParams_Data) == 24,
              "Bad sizeof(CdmStorage_Open_ResponseParams_Data)");
class  CdmFile_Read_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CdmFile_Read_Params_Data));
      new (data()) CdmFile_Read_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CdmFile_Read_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CdmFile_Read_Params_Data>(index_);
    }
    CdmFile_Read_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  CdmFile_Read_Params_Data();
  ~CdmFile_Read_Params_Data() = delete;
};
static_assert(sizeof(CdmFile_Read_Params_Data) == 8,
              "Bad sizeof(CdmFile_Read_Params_Data)");
class  CdmFile_Read_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CdmFile_Read_ResponseParams_Data));
      new (data()) CdmFile_Read_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CdmFile_Read_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CdmFile_Read_ResponseParams_Data>(index_);
    }
    CdmFile_Read_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  CdmFile_Read_ResponseParams_Data();
  ~CdmFile_Read_ResponseParams_Data() = delete;
};
static_assert(sizeof(CdmFile_Read_ResponseParams_Data) == 24,
              "Bad sizeof(CdmFile_Read_ResponseParams_Data)");
class  CdmFile_Write_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CdmFile_Write_Params_Data));
      new (data()) CdmFile_Write_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CdmFile_Write_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CdmFile_Write_Params_Data>(index_);
    }
    CdmFile_Write_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  CdmFile_Write_Params_Data();
  ~CdmFile_Write_Params_Data() = delete;
};
static_assert(sizeof(CdmFile_Write_Params_Data) == 16,
              "Bad sizeof(CdmFile_Write_Params_Data)");
class  CdmFile_Write_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CdmFile_Write_ResponseParams_Data));
      new (data()) CdmFile_Write_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CdmFile_Write_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CdmFile_Write_ResponseParams_Data>(index_);
    }
    CdmFile_Write_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t padfinal_[4];

 private:
  CdmFile_Write_ResponseParams_Data();
  ~CdmFile_Write_ResponseParams_Data() = delete;
};
static_assert(sizeof(CdmFile_Write_ResponseParams_Data) == 16,
              "Bad sizeof(CdmFile_Write_ResponseParams_Data)");

}  // namespace internal


class CdmStorage_Open_ParamsDataView {
 public:
  CdmStorage_Open_ParamsDataView() {}

  CdmStorage_Open_ParamsDataView(
      internal::CdmStorage_Open_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetFileNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFileName(UserType* output) {
    
    auto* pointer = data_->file_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::CdmStorage_Open_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CdmStorage_Open_ResponseParamsDataView {
 public:
  CdmStorage_Open_ResponseParamsDataView() {}

  CdmStorage_Open_ResponseParamsDataView(
      internal::CdmStorage_Open_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::mojom::CdmStorage_Status>(
        data_value, output);
  }

  CdmStorage_Status status() const {
    return static_cast<CdmStorage_Status>(data_->status);
  }
  template <typename UserType>
  UserType TakeCdmFile() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::mojom::CdmFileAssociatedPtrInfoDataView>(
            &data_->cdm_file, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CdmStorage_Open_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CdmFile_Read_ParamsDataView {
 public:
  CdmFile_Read_ParamsDataView() {}

  CdmFile_Read_ParamsDataView(
      internal::CdmFile_Read_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::CdmFile_Read_Params_Data* data_ = nullptr;
};



class CdmFile_Read_ResponseParamsDataView {
 public:
  CdmFile_Read_ResponseParamsDataView() {}

  CdmFile_Read_ResponseParamsDataView(
      internal::CdmFile_Read_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::mojom::CdmFile_Status>(
        data_value, output);
  }

  CdmFile_Status status() const {
    return static_cast<CdmFile_Status>(data_->status);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
 private:
  internal::CdmFile_Read_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CdmFile_Write_ParamsDataView {
 public:
  CdmFile_Write_ParamsDataView() {}

  CdmFile_Write_ParamsDataView(
      internal::CdmFile_Write_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
 private:
  internal::CdmFile_Write_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CdmFile_Write_ResponseParamsDataView {
 public:
  CdmFile_Write_ResponseParamsDataView() {}

  CdmFile_Write_ResponseParamsDataView(
      internal::CdmFile_Write_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::mojom::CdmFile_Status>(
        data_value, output);
  }

  CdmFile_Status status() const {
    return static_cast<CdmFile_Status>(data_->status);
  }
 private:
  internal::CdmFile_Write_ResponseParams_Data* data_ = nullptr;
};


inline void CdmStorage_Open_ParamsDataView::GetFileNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_name.Get();
  *output = mojo::StringDataView(pointer, context_);
}






inline void CdmFile_Read_ResponseParamsDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}


inline void CdmFile_Write_ParamsDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}



}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_CDM_STORAGE_MOJOM_PARAMS_DATA_H_