// gpu/ipc/common/vulkan_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_INFO_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_VULKAN_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "gpu/ipc/common/vulkan_info.mojom-shared-internal.h"
#include "gpu/ipc/common/vulkan_types.mojom-shared.h"







namespace gpu {
namespace mojom {
class VulkanPhysicalDeviceInfoDataView;

class VulkanInfoDataView;



}  // namespace mojom
}  // namespace gpu

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::VulkanPhysicalDeviceInfoDataView> {
  using Data = ::gpu::mojom::internal::VulkanPhysicalDeviceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VulkanInfoDataView> {
  using Data = ::gpu::mojom::internal::VulkanInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu {
namespace mojom {


class VulkanPhysicalDeviceInfoDataView {
 public:
  VulkanPhysicalDeviceInfoDataView() {}

  VulkanPhysicalDeviceInfoDataView(
      internal::VulkanPhysicalDeviceInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPropertiesDataView(
      ::gpu::mojom::VkPhysicalDevicePropertiesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadProperties(UserType* output) {
    
    auto* pointer = data_->properties.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDevicePropertiesDataView>(
        pointer, output, context_);
  }
  inline void GetExtensionsDataView(
      mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExtensions(UserType* output) {
    
    auto* pointer = data_->extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>>(
        pointer, output, context_);
  }
  inline void GetFeaturesDataView(
      ::gpu::mojom::VkPhysicalDeviceFeaturesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFeatures(UserType* output) {
    
    auto* pointer = data_->features.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceFeaturesDataView>(
        pointer, output, context_);
  }
  bool feature_sampler_ycbcr_conversion() const {
    return data_->feature_sampler_ycbcr_conversion;
  }
  bool feature_protected_memory() const {
    return data_->feature_protected_memory;
  }
  inline void GetQueueFamiliesDataView(
      mojo::ArrayDataView<::gpu::mojom::VkQueueFamilyPropertiesDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadQueueFamilies(UserType* output) {
    
    auto* pointer = data_->queue_families.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VkQueueFamilyPropertiesDataView>>(
        pointer, output, context_);
  }
 private:
  internal::VulkanPhysicalDeviceInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VulkanInfoDataView {
 public:
  VulkanInfoDataView() {}

  VulkanInfoDataView(
      internal::VulkanInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t api_version() const {
    return data_->api_version;
  }
  uint32_t used_api_version() const {
    return data_->used_api_version;
  }
  inline void GetInstanceExtensionsDataView(
      mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInstanceExtensions(UserType* output) {
    
    auto* pointer = data_->instance_extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>>(
        pointer, output, context_);
  }
  inline void GetEnabledInstanceExtensionsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEnabledInstanceExtensions(UserType* output) {
    
    auto* pointer = data_->enabled_instance_extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetInstanceLayersDataView(
      mojo::ArrayDataView<::gpu::mojom::VkLayerPropertiesDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInstanceLayers(UserType* output) {
    
    auto* pointer = data_->instance_layers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VkLayerPropertiesDataView>>(
        pointer, output, context_);
  }
  inline void GetPhysicalDevicesDataView(
      mojo::ArrayDataView<VulkanPhysicalDeviceInfoDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPhysicalDevices(UserType* output) {
    
    auto* pointer = data_->physical_devices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VulkanPhysicalDeviceInfoDataView>>(
        pointer, output, context_);
  }
 private:
  internal::VulkanInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace gpu

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VulkanPhysicalDeviceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VulkanPhysicalDeviceInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::VulkanPhysicalDeviceInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::properties(input)) in_properties = Traits::properties(input);
    typename decltype((*output)->properties)::BaseType::BufferWriter
        properties_writer;
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDevicePropertiesDataView>(
        in_properties, buffer, &properties_writer, context);
    (*output)->properties.Set(
        properties_writer.is_null() ? nullptr : properties_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->properties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null properties in VulkanPhysicalDeviceInfo struct");
    decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
    typename decltype((*output)->extensions)::BaseType::BufferWriter
        extensions_writer;
    const mojo::internal::ContainerValidateParams extensions_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>>(
        in_extensions, buffer, &extensions_writer, &extensions_validate_params,
        context);
    (*output)->extensions.Set(
        extensions_writer.is_null() ? nullptr : extensions_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->extensions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extensions in VulkanPhysicalDeviceInfo struct");
    decltype(Traits::features(input)) in_features = Traits::features(input);
    typename decltype((*output)->features)::BaseType::BufferWriter
        features_writer;
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceFeaturesDataView>(
        in_features, buffer, &features_writer, context);
    (*output)->features.Set(
        features_writer.is_null() ? nullptr : features_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null features in VulkanPhysicalDeviceInfo struct");
    (*output)->feature_sampler_ycbcr_conversion = Traits::feature_sampler_ycbcr_conversion(input);
    (*output)->feature_protected_memory = Traits::feature_protected_memory(input);
    decltype(Traits::queue_families(input)) in_queue_families = Traits::queue_families(input);
    typename decltype((*output)->queue_families)::BaseType::BufferWriter
        queue_families_writer;
    const mojo::internal::ContainerValidateParams queue_families_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VkQueueFamilyPropertiesDataView>>(
        in_queue_families, buffer, &queue_families_writer, &queue_families_validate_params,
        context);
    (*output)->queue_families.Set(
        queue_families_writer.is_null() ? nullptr : queue_families_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->queue_families.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null queue_families in VulkanPhysicalDeviceInfo struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VulkanPhysicalDeviceInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VulkanPhysicalDeviceInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VulkanInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VulkanInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::VulkanInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->api_version = Traits::api_version(input);
    (*output)->used_api_version = Traits::used_api_version(input);
    decltype(Traits::instance_extensions(input)) in_instance_extensions = Traits::instance_extensions(input);
    typename decltype((*output)->instance_extensions)::BaseType::BufferWriter
        instance_extensions_writer;
    const mojo::internal::ContainerValidateParams instance_extensions_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>>(
        in_instance_extensions, buffer, &instance_extensions_writer, &instance_extensions_validate_params,
        context);
    (*output)->instance_extensions.Set(
        instance_extensions_writer.is_null() ? nullptr : instance_extensions_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->instance_extensions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null instance_extensions in VulkanInfo struct");
    decltype(Traits::enabled_instance_extensions(input)) in_enabled_instance_extensions = Traits::enabled_instance_extensions(input);
    typename decltype((*output)->enabled_instance_extensions)::BaseType::BufferWriter
        enabled_instance_extensions_writer;
    const mojo::internal::ContainerValidateParams enabled_instance_extensions_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_enabled_instance_extensions, buffer, &enabled_instance_extensions_writer, &enabled_instance_extensions_validate_params,
        context);
    (*output)->enabled_instance_extensions.Set(
        enabled_instance_extensions_writer.is_null() ? nullptr : enabled_instance_extensions_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->enabled_instance_extensions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null enabled_instance_extensions in VulkanInfo struct");
    decltype(Traits::instance_layers(input)) in_instance_layers = Traits::instance_layers(input);
    typename decltype((*output)->instance_layers)::BaseType::BufferWriter
        instance_layers_writer;
    const mojo::internal::ContainerValidateParams instance_layers_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VkLayerPropertiesDataView>>(
        in_instance_layers, buffer, &instance_layers_writer, &instance_layers_validate_params,
        context);
    (*output)->instance_layers.Set(
        instance_layers_writer.is_null() ? nullptr : instance_layers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->instance_layers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null instance_layers in VulkanInfo struct");
    decltype(Traits::physical_devices(input)) in_physical_devices = Traits::physical_devices(input);
    typename decltype((*output)->physical_devices)::BaseType::BufferWriter
        physical_devices_writer;
    const mojo::internal::ContainerValidateParams physical_devices_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VulkanPhysicalDeviceInfoDataView>>(
        in_physical_devices, buffer, &physical_devices_writer, &physical_devices_validate_params,
        context);
    (*output)->physical_devices.Set(
        physical_devices_writer.is_null() ? nullptr : physical_devices_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->physical_devices.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null physical_devices in VulkanInfo struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VulkanInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VulkanInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu {
namespace mojom {

inline void VulkanPhysicalDeviceInfoDataView::GetPropertiesDataView(
    ::gpu::mojom::VkPhysicalDevicePropertiesDataView* output) {
  auto pointer = data_->properties.Get();
  *output = ::gpu::mojom::VkPhysicalDevicePropertiesDataView(pointer, context_);
}
inline void VulkanPhysicalDeviceInfoDataView::GetExtensionsDataView(
    mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>* output) {
  auto pointer = data_->extensions.Get();
  *output = mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>(pointer, context_);
}
inline void VulkanPhysicalDeviceInfoDataView::GetFeaturesDataView(
    ::gpu::mojom::VkPhysicalDeviceFeaturesDataView* output) {
  auto pointer = data_->features.Get();
  *output = ::gpu::mojom::VkPhysicalDeviceFeaturesDataView(pointer, context_);
}
inline void VulkanPhysicalDeviceInfoDataView::GetQueueFamiliesDataView(
    mojo::ArrayDataView<::gpu::mojom::VkQueueFamilyPropertiesDataView>* output) {
  auto pointer = data_->queue_families.Get();
  *output = mojo::ArrayDataView<::gpu::mojom::VkQueueFamilyPropertiesDataView>(pointer, context_);
}


inline void VulkanInfoDataView::GetInstanceExtensionsDataView(
    mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>* output) {
  auto pointer = data_->instance_extensions.Get();
  *output = mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>(pointer, context_);
}
inline void VulkanInfoDataView::GetEnabledInstanceExtensionsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->enabled_instance_extensions.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void VulkanInfoDataView::GetInstanceLayersDataView(
    mojo::ArrayDataView<::gpu::mojom::VkLayerPropertiesDataView>* output) {
  auto pointer = data_->instance_layers.Get();
  *output = mojo::ArrayDataView<::gpu::mojom::VkLayerPropertiesDataView>(pointer, context_);
}
inline void VulkanInfoDataView::GetPhysicalDevicesDataView(
    mojo::ArrayDataView<VulkanPhysicalDeviceInfoDataView>* output) {
  auto pointer = data_->physical_devices.Get();
  *output = mojo::ArrayDataView<VulkanPhysicalDeviceInfoDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace gpu

#endif  // GPU_IPC_COMMON_VULKAN_INFO_MOJOM_SHARED_H_