// gpu/ipc/common/gpu_extra_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_EXTRA_INFO_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_GPU_EXTRA_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "gpu/ipc/common/gpu_extra_info.mojom-shared-internal.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"







namespace gpu {
namespace mojom {
class ANGLEFeatureDataView;

class GpuExtraInfoDataView;



}  // namespace mojom
}  // namespace gpu

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::ANGLEFeatureDataView> {
  using Data = ::gpu::mojom::internal::ANGLEFeature_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::GpuExtraInfoDataView> {
  using Data = ::gpu::mojom::internal::GpuExtraInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu {
namespace mojom {


class ANGLEFeatureDataView {
 public:
  ANGLEFeatureDataView() {}

  ANGLEFeatureDataView(
      internal::ANGLEFeature_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetCategoryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCategory(UserType* output) {
    
    auto* pointer = data_->category.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetBugDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBug(UserType* output) {
    
    auto* pointer = data_->bug.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetStatusDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetConditionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCondition(UserType* output) {
    
    auto* pointer = data_->condition.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::ANGLEFeature_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuExtraInfoDataView {
 public:
  GpuExtraInfoDataView() {}

  GpuExtraInfoDataView(
      internal::GpuExtraInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetAngleFeaturesDataView(
      mojo::ArrayDataView<ANGLEFeatureDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAngleFeatures(UserType* output) {
    
    auto* pointer = data_->angle_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::ANGLEFeatureDataView>>(
        pointer, output, context_);
  }
 private:
  internal::GpuExtraInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace gpu

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::ANGLEFeatureDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::ANGLEFeatureDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::ANGLEFeature_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ANGLEFeature struct");
    decltype(Traits::category(input)) in_category = Traits::category(input);
    typename decltype((*output)->category)::BaseType::BufferWriter
        category_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_category, buffer, &category_writer, context);
    (*output)->category.Set(
        category_writer.is_null() ? nullptr : category_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->category.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null category in ANGLEFeature struct");
    decltype(Traits::description(input)) in_description = Traits::description(input);
    typename decltype((*output)->description)::BaseType::BufferWriter
        description_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_description, buffer, &description_writer, context);
    (*output)->description.Set(
        description_writer.is_null() ? nullptr : description_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->description.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in ANGLEFeature struct");
    decltype(Traits::bug(input)) in_bug = Traits::bug(input);
    typename decltype((*output)->bug)::BaseType::BufferWriter
        bug_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_bug, buffer, &bug_writer, context);
    (*output)->bug.Set(
        bug_writer.is_null() ? nullptr : bug_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->bug.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bug in ANGLEFeature struct");
    decltype(Traits::status(input)) in_status = Traits::status(input);
    typename decltype((*output)->status)::BaseType::BufferWriter
        status_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_status, buffer, &status_writer, context);
    (*output)->status.Set(
        status_writer.is_null() ? nullptr : status_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->status.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null status in ANGLEFeature struct");
    decltype(Traits::condition(input)) in_condition = Traits::condition(input);
    typename decltype((*output)->condition)::BaseType::BufferWriter
        condition_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_condition, buffer, &condition_writer, context);
    (*output)->condition.Set(
        condition_writer.is_null() ? nullptr : condition_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->condition.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null condition in ANGLEFeature struct");
  }

  static bool Deserialize(::gpu::mojom::internal::ANGLEFeature_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::ANGLEFeatureDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuExtraInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GpuExtraInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gpu::mojom::internal::GpuExtraInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::angle_features(input)) in_angle_features = Traits::angle_features(input);
    typename decltype((*output)->angle_features)::BaseType::BufferWriter
        angle_features_writer;
    const mojo::internal::ContainerValidateParams angle_features_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::ANGLEFeatureDataView>>(
        in_angle_features, buffer, &angle_features_writer, &angle_features_validate_params,
        context);
    (*output)->angle_features.Set(
        angle_features_writer.is_null() ? nullptr : angle_features_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->angle_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null angle_features in GpuExtraInfo struct");
  }

  static bool Deserialize(::gpu::mojom::internal::GpuExtraInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::GpuExtraInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu {
namespace mojom {

inline void ANGLEFeatureDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ANGLEFeatureDataView::GetCategoryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->category.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ANGLEFeatureDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ANGLEFeatureDataView::GetBugDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->bug.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ANGLEFeatureDataView::GetStatusDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->status.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ANGLEFeatureDataView::GetConditionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->condition.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void GpuExtraInfoDataView::GetAngleFeaturesDataView(
    mojo::ArrayDataView<ANGLEFeatureDataView>* output) {
  auto pointer = data_->angle_features.Get();
  *output = mojo::ArrayDataView<ANGLEFeatureDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace gpu

#endif  // GPU_IPC_COMMON_GPU_EXTRA_INFO_MOJOM_SHARED_H_