// device/vr/public/mojom/isolated_xr_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_H_
#define DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "device/vr/public/mojom/isolated_xr_service.mojom-shared.h"
#include "device/vr/public/mojom/isolated_xr_service.mojom-forward.h"
#include "device/vr/public/mojom/browser_test_interfaces.mojom.h"
#include "device/vr/public/mojom/vr_service.mojom.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace device {
namespace mojom {

class XRSessionControllerProxy;

template <typename ImplRefTraits>
class XRSessionControllerStub;

class XRSessionControllerRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRSessionController
    : public XRSessionControllerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRSessionControllerInterfaceBase;
  using Proxy_ = XRSessionControllerProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRSessionControllerStub<ImplRefTraits>;

  using RequestValidator_ = XRSessionControllerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetFrameDataRestrictedMinVersion = 0,
  };
  virtual ~XRSessionController() {}

  
  virtual void SetFrameDataRestricted(bool restricted) = 0;
};

class XRRuntimeEventListenerProxy;

template <typename ImplRefTraits>
class XRRuntimeEventListenerStub;

class XRRuntimeEventListenerRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRuntimeEventListener
    : public XRRuntimeEventListenerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRRuntimeEventListenerInterfaceBase;
  using Proxy_ = XRRuntimeEventListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRRuntimeEventListenerStub<ImplRefTraits>;

  using RequestValidator_ = XRRuntimeEventListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDisplayInfoChangedMinVersion = 0,
    kOnVisibilityStateChangedMinVersion = 0,
    kOnExitPresentMinVersion = 0,
  };
  virtual ~XRRuntimeEventListener() {}

  
  virtual void OnDisplayInfoChanged(::device::mojom::VRDisplayInfoPtr display_info) = 0;

  
  virtual void OnVisibilityStateChanged(::device::mojom::XRVisibilityState visibility_state) = 0;

  
  virtual void OnExitPresent() = 0;
};

class XRRuntimeProxy;

template <typename ImplRefTraits>
class XRRuntimeStub;

class XRRuntimeRequestValidator;
class XRRuntimeResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRuntime
    : public XRRuntimeInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRRuntimeInterfaceBase;
  using Proxy_ = XRRuntimeProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRRuntimeStub<ImplRefTraits>;

  using RequestValidator_ = XRRuntimeRequestValidator;
  using ResponseValidator_ = XRRuntimeResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestSessionMinVersion = 0,
    kShutdownSessionMinVersion = 0,
    kListenToDeviceChangesMinVersion = 0,
  };
  virtual ~XRRuntime() {}


  using RequestSessionCallback = base::OnceCallback<void(::device::mojom::XRSessionPtr, ::mojo::PendingRemote<XRSessionController>)>;
  
  virtual void RequestSession(XRRuntimeSessionOptionsPtr options, RequestSessionCallback callback) = 0;


  using ShutdownSessionCallback = base::OnceCallback<void()>;
  
  virtual void ShutdownSession(ShutdownSessionCallback callback) = 0;


  using ListenToDeviceChangesCallback = base::OnceCallback<void(::device::mojom::VRDisplayInfoPtr)>;
  
  virtual void ListenToDeviceChanges(::mojo::PendingAssociatedRemote<XRRuntimeEventListener> listener, ListenToDeviceChangesCallback callback) = 0;
};

class ImmersiveOverlayProxy;

template <typename ImplRefTraits>
class ImmersiveOverlayStub;

class ImmersiveOverlayRequestValidator;
class ImmersiveOverlayResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) ImmersiveOverlay
    : public ImmersiveOverlayInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ImmersiveOverlayInterfaceBase;
  using Proxy_ = ImmersiveOverlayProxy;

  template <typename ImplRefTraits>
  using Stub_ = ImmersiveOverlayStub<ImplRefTraits>;

  using RequestValidator_ = ImmersiveOverlayRequestValidator;
  using ResponseValidator_ = ImmersiveOverlayResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestNextOverlayPoseMinVersion = 0,
    kSubmitOverlayTextureMinVersion = 0,
    kSetOverlayAndWebXRVisibilityMinVersion = 0,
    kRequestNotificationOnWebXrSubmittedMinVersion = 0,
  };
  virtual ~ImmersiveOverlay() {}


  using RequestNextOverlayPoseCallback = base::OnceCallback<void(XRRenderInfoPtr)>;
  
  virtual void RequestNextOverlayPose(RequestNextOverlayPoseCallback callback) = 0;


  using SubmitOverlayTextureCallback = base::OnceCallback<void(bool)>;
  
  virtual void SubmitOverlayTexture(int16_t frame_id, ::mojo::PlatformHandle texture, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, SubmitOverlayTextureCallback callback) = 0;

  
  virtual void SetOverlayAndWebXRVisibility(bool overlay_visible, bool webxr_visible) = 0;


  using RequestNotificationOnWebXrSubmittedCallback = base::OnceCallback<void()>;
  
  virtual void RequestNotificationOnWebXrSubmitted(RequestNotificationOnWebXrSubmittedCallback callback) = 0;
};

class XRCompositorHostProxy;

template <typename ImplRefTraits>
class XRCompositorHostStub;

class XRCompositorHostRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRCompositorHost
    : public XRCompositorHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRCompositorHostInterfaceBase;
  using Proxy_ = XRCompositorHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRCompositorHostStub<ImplRefTraits>;

  using RequestValidator_ = XRCompositorHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateImmersiveOverlayMinVersion = 0,
  };
  virtual ~XRCompositorHost() {}

  
  virtual void CreateImmersiveOverlay(::mojo::PendingReceiver<ImmersiveOverlay> overlay) = 0;
};

class IsolatedXRRuntimeProviderClientProxy;

template <typename ImplRefTraits>
class IsolatedXRRuntimeProviderClientStub;

class IsolatedXRRuntimeProviderClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) IsolatedXRRuntimeProviderClient
    : public IsolatedXRRuntimeProviderClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = IsolatedXRRuntimeProviderClientInterfaceBase;
  using Proxy_ = IsolatedXRRuntimeProviderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = IsolatedXRRuntimeProviderClientStub<ImplRefTraits>;

  using RequestValidator_ = IsolatedXRRuntimeProviderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDeviceAddedMinVersion = 0,
    kOnDeviceRemovedMinVersion = 0,
    kOnDevicesEnumeratedMinVersion = 0,
  };
  virtual ~IsolatedXRRuntimeProviderClient() {}

  
  virtual void OnDeviceAdded(::mojo::PendingRemote<XRRuntime> runtime, ::mojo::PendingRemote<XRCompositorHost> compositor_host, XRDeviceDataPtr device_data, ::device::mojom::XRDeviceId device_id) = 0;

  
  virtual void OnDeviceRemoved(::device::mojom::XRDeviceId device_index) = 0;

  
  virtual void OnDevicesEnumerated() = 0;
};

class IsolatedXRRuntimeProviderProxy;

template <typename ImplRefTraits>
class IsolatedXRRuntimeProviderStub;

class IsolatedXRRuntimeProviderRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) IsolatedXRRuntimeProvider
    : public IsolatedXRRuntimeProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = IsolatedXRRuntimeProviderInterfaceBase;
  using Proxy_ = IsolatedXRRuntimeProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = IsolatedXRRuntimeProviderStub<ImplRefTraits>;

  using RequestValidator_ = IsolatedXRRuntimeProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequestDevicesMinVersion = 0,
  };
  virtual ~IsolatedXRRuntimeProvider() {}

  
  virtual void RequestDevices(::mojo::PendingRemote<IsolatedXRRuntimeProviderClient> client) = 0;
};

class XRDeviceServiceProxy;

template <typename ImplRefTraits>
class XRDeviceServiceStub;

class XRDeviceServiceRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRDeviceService
    : public XRDeviceServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRDeviceServiceInterfaceBase;
  using Proxy_ = XRDeviceServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRDeviceServiceStub<ImplRefTraits>;

  using RequestValidator_ = XRDeviceServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindRuntimeProviderMinVersion = 0,
    kBindTestHookMinVersion = 0,
  };
  virtual ~XRDeviceService() {}

  
  virtual void BindRuntimeProvider(::mojo::PendingReceiver<IsolatedXRRuntimeProvider> receiver) = 0;

  
  virtual void BindTestHook(::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook> receiver) = 0;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRSessionControllerProxy
    : public XRSessionController {
 public:
  using InterfaceType = XRSessionController;

  explicit XRSessionControllerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetFrameDataRestricted(bool restricted) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRuntimeEventListenerProxy
    : public XRRuntimeEventListener {
 public:
  using InterfaceType = XRRuntimeEventListener;

  explicit XRRuntimeEventListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDisplayInfoChanged(::device::mojom::VRDisplayInfoPtr display_info) final;
  
  void OnVisibilityStateChanged(::device::mojom::XRVisibilityState visibility_state) final;
  
  void OnExitPresent() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRuntimeProxy
    : public XRRuntime {
 public:
  using InterfaceType = XRRuntime;

  explicit XRRuntimeProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestSession(XRRuntimeSessionOptionsPtr options, RequestSessionCallback callback) final;
  
  void ShutdownSession(ShutdownSessionCallback callback) final;
  
  void ListenToDeviceChanges(::mojo::PendingAssociatedRemote<XRRuntimeEventListener> listener, ListenToDeviceChangesCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) ImmersiveOverlayProxy
    : public ImmersiveOverlay {
 public:
  using InterfaceType = ImmersiveOverlay;

  explicit ImmersiveOverlayProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestNextOverlayPose(RequestNextOverlayPoseCallback callback) final;
  
  void SubmitOverlayTexture(int16_t frame_id, ::mojo::PlatformHandle texture, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, SubmitOverlayTextureCallback callback) final;
  
  void SetOverlayAndWebXRVisibility(bool overlay_visible, bool webxr_visible) final;
  
  void RequestNotificationOnWebXrSubmitted(RequestNotificationOnWebXrSubmittedCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRCompositorHostProxy
    : public XRCompositorHost {
 public:
  using InterfaceType = XRCompositorHost;

  explicit XRCompositorHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateImmersiveOverlay(::mojo::PendingReceiver<ImmersiveOverlay> overlay) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) IsolatedXRRuntimeProviderClientProxy
    : public IsolatedXRRuntimeProviderClient {
 public:
  using InterfaceType = IsolatedXRRuntimeProviderClient;

  explicit IsolatedXRRuntimeProviderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDeviceAdded(::mojo::PendingRemote<XRRuntime> runtime, ::mojo::PendingRemote<XRCompositorHost> compositor_host, XRDeviceDataPtr device_data, ::device::mojom::XRDeviceId device_id) final;
  
  void OnDeviceRemoved(::device::mojom::XRDeviceId device_index) final;
  
  void OnDevicesEnumerated() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) IsolatedXRRuntimeProviderProxy
    : public IsolatedXRRuntimeProvider {
 public:
  using InterfaceType = IsolatedXRRuntimeProvider;

  explicit IsolatedXRRuntimeProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestDevices(::mojo::PendingRemote<IsolatedXRRuntimeProviderClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRDeviceServiceProxy
    : public XRDeviceService {
 public:
  using InterfaceType = XRDeviceService;

  explicit XRDeviceServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindRuntimeProvider(::mojo::PendingReceiver<IsolatedXRRuntimeProvider> receiver) final;
  
  void BindTestHook(::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRSessionControllerStubDispatch {
 public:
  static bool Accept(XRSessionController* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRSessionController* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRSessionController>>
class XRSessionControllerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRSessionControllerStub() {}
  ~XRSessionControllerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionControllerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionControllerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRuntimeEventListenerStubDispatch {
 public:
  static bool Accept(XRRuntimeEventListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRRuntimeEventListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRRuntimeEventListener>>
class XRRuntimeEventListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRRuntimeEventListenerStub() {}
  ~XRRuntimeEventListenerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRRuntimeEventListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRRuntimeEventListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRuntimeStubDispatch {
 public:
  static bool Accept(XRRuntime* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRRuntime* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRRuntime>>
class XRRuntimeStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRRuntimeStub() {}
  ~XRRuntimeStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRRuntimeStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRRuntimeStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) ImmersiveOverlayStubDispatch {
 public:
  static bool Accept(ImmersiveOverlay* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ImmersiveOverlay* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ImmersiveOverlay>>
class ImmersiveOverlayStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ImmersiveOverlayStub() {}
  ~ImmersiveOverlayStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImmersiveOverlayStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImmersiveOverlayStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRCompositorHostStubDispatch {
 public:
  static bool Accept(XRCompositorHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRCompositorHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRCompositorHost>>
class XRCompositorHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRCompositorHostStub() {}
  ~XRCompositorHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRCompositorHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRCompositorHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) IsolatedXRRuntimeProviderClientStubDispatch {
 public:
  static bool Accept(IsolatedXRRuntimeProviderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IsolatedXRRuntimeProviderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IsolatedXRRuntimeProviderClient>>
class IsolatedXRRuntimeProviderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IsolatedXRRuntimeProviderClientStub() {}
  ~IsolatedXRRuntimeProviderClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IsolatedXRRuntimeProviderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IsolatedXRRuntimeProviderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) IsolatedXRRuntimeProviderStubDispatch {
 public:
  static bool Accept(IsolatedXRRuntimeProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IsolatedXRRuntimeProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IsolatedXRRuntimeProvider>>
class IsolatedXRRuntimeProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IsolatedXRRuntimeProviderStub() {}
  ~IsolatedXRRuntimeProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IsolatedXRRuntimeProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IsolatedXRRuntimeProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRDeviceServiceStubDispatch {
 public:
  static bool Accept(XRDeviceService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRDeviceService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRDeviceService>>
class XRDeviceServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRDeviceServiceStub() {}
  ~XRDeviceServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRDeviceServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRDeviceServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRSessionControllerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRuntimeEventListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRuntimeRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) ImmersiveOverlayRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRCompositorHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) IsolatedXRRuntimeProviderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) IsolatedXRRuntimeProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRDeviceServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRuntimeResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) ImmersiveOverlayResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRDeviceData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDeviceData, T>::value>;
  using DataView = XRDeviceDataDataView;
  using Data_ = internal::XRDeviceData_Data;

  template <typename... Args>
  static XRDeviceDataPtr New(Args&&... args) {
    return XRDeviceDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDeviceDataPtr From(const U& u) {
    return mojo::TypeConverter<XRDeviceDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDeviceData>::Convert(*this);
  }


  XRDeviceData();

  ~XRDeviceData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDeviceDataPtr>
  XRDeviceDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDeviceData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDeviceData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDeviceData_UnserializedMessageContext<
            UserType, XRDeviceData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRDeviceData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return XRDeviceData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDeviceData_UnserializedMessageContext<
            UserType, XRDeviceData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDeviceData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }


  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRuntimeSessionOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRRuntimeSessionOptions, T>::value>;
  using DataView = XRRuntimeSessionOptionsDataView;
  using Data_ = internal::XRRuntimeSessionOptions_Data;

  template <typename... Args>
  static XRRuntimeSessionOptionsPtr New(Args&&... args) {
    return XRRuntimeSessionOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRRuntimeSessionOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRRuntimeSessionOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRRuntimeSessionOptions>::Convert(*this);
  }


  XRRuntimeSessionOptions();

  XRRuntimeSessionOptions(
      ::device::mojom::XRSessionMode mode,
      std::vector<::device::mojom::XRSessionFeature> enabled_features,
      int32_t render_process_id,
      int32_t render_frame_id);

  ~XRRuntimeSessionOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRRuntimeSessionOptionsPtr>
  XRRuntimeSessionOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRRuntimeSessionOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRRuntimeSessionOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRRuntimeSessionOptions_UnserializedMessageContext<
            UserType, XRRuntimeSessionOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRRuntimeSessionOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return XRRuntimeSessionOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRRuntimeSessionOptions_UnserializedMessageContext<
            UserType, XRRuntimeSessionOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRRuntimeSessionOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::device::mojom::XRSessionMode mode;
  
  std::vector<::device::mojom::XRSessionFeature> enabled_features;
  
  int32_t render_process_id;
  
  int32_t render_frame_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) XRRenderInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRRenderInfo, T>::value>;
  using DataView = XRRenderInfoDataView;
  using Data_ = internal::XRRenderInfo_Data;

  template <typename... Args>
  static XRRenderInfoPtr New(Args&&... args) {
    return XRRenderInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRRenderInfoPtr From(const U& u) {
    return mojo::TypeConverter<XRRenderInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRRenderInfo>::Convert(*this);
  }


  XRRenderInfo();

  XRRenderInfo(
      int16_t frame_id,
      ::device::mojom::VRPosePtr pose);

  ~XRRenderInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRRenderInfoPtr>
  XRRenderInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRRenderInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRRenderInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRRenderInfo_UnserializedMessageContext<
            UserType, XRRenderInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRRenderInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return XRRenderInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRRenderInfo_UnserializedMessageContext<
            UserType, XRRenderInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRRenderInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int16_t frame_id;
  
  ::device::mojom::VRPosePtr pose;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRRenderInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
XRRuntimeSessionOptionsPtr XRRuntimeSessionOptions::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(enabled_features),
      mojo::Clone(render_process_id),
      mojo::Clone(render_frame_id)
  );
}

template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>*>
bool XRRuntimeSessionOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->enabled_features, other_struct.enabled_features))
    return false;
  if (!mojo::Equals(this->render_process_id, other_struct.render_process_id))
    return false;
  if (!mojo::Equals(this->render_frame_id, other_struct.render_frame_id))
    return false;
  return true;
}

template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mode, rhs.mode))
    return true;
  if (std::less<>{}(rhs.mode, lhs.mode))
    return false;
  if (std::less<>{}(lhs.enabled_features, rhs.enabled_features))
    return true;
  if (std::less<>{}(rhs.enabled_features, lhs.enabled_features))
    return false;
  if (std::less<>{}(lhs.render_process_id, rhs.render_process_id))
    return true;
  if (std::less<>{}(rhs.render_process_id, lhs.render_process_id))
    return false;
  if (std::less<>{}(lhs.render_frame_id, rhs.render_frame_id))
    return true;
  if (std::less<>{}(rhs.render_frame_id, lhs.render_frame_id))
    return false;
  return false;
}
template <typename StructPtrType>
XRRenderInfoPtr XRRenderInfo::Clone() const {
  return New(
      mojo::Clone(frame_id),
      mojo::Clone(pose)
  );
}

template <typename T, XRRenderInfo::EnableIfSame<T>*>
bool XRRenderInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_id, other_struct.frame_id))
    return false;
  if (!mojo::Equals(this->pose, other_struct.pose))
    return false;
  return true;
}

template <typename T, XRRenderInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.frame_id, rhs.frame_id))
    return true;
  if (std::less<>{}(rhs.frame_id, lhs.frame_id))
    return false;
  if (std::less<>{}(lhs.pose, rhs.pose))
    return true;
  if (std::less<>{}(rhs.pose, lhs.pose))
    return false;
  return false;
}
template <typename StructPtrType>
XRDeviceDataPtr XRDeviceData::Clone() const {
  return New(
  );
}

template <typename T, XRDeviceData::EnableIfSame<T>*>
bool XRDeviceData::Equals(const T& other_struct) const {
  return true;
}

template <typename T, XRDeviceData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}


}  // namespace mojom
}  // namespace device

namespace mojo {


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) StructTraits<::device::mojom::XRRuntimeSessionOptions::DataView,
                                         ::device::mojom::XRRuntimeSessionOptionsPtr> {
  static bool IsNull(const ::device::mojom::XRRuntimeSessionOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRRuntimeSessionOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRRuntimeSessionOptions::mode) mode(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->mode;
  }

  static const decltype(::device::mojom::XRRuntimeSessionOptions::enabled_features)& enabled_features(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->enabled_features;
  }

  static decltype(::device::mojom::XRRuntimeSessionOptions::render_process_id) render_process_id(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->render_process_id;
  }

  static decltype(::device::mojom::XRRuntimeSessionOptions::render_frame_id) render_frame_id(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->render_frame_id;
  }

  static bool Read(::device::mojom::XRRuntimeSessionOptions::DataView input, ::device::mojom::XRRuntimeSessionOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) StructTraits<::device::mojom::XRRenderInfo::DataView,
                                         ::device::mojom::XRRenderInfoPtr> {
  static bool IsNull(const ::device::mojom::XRRenderInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRRenderInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRRenderInfo::frame_id) frame_id(
      const ::device::mojom::XRRenderInfoPtr& input) {
    return input->frame_id;
  }

  static const decltype(::device::mojom::XRRenderInfo::pose)& pose(
      const ::device::mojom::XRRenderInfoPtr& input) {
    return input->pose;
  }

  static bool Read(::device::mojom::XRRenderInfo::DataView input, ::device::mojom::XRRenderInfoPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS) StructTraits<::device::mojom::XRDeviceData::DataView,
                                         ::device::mojom::XRDeviceDataPtr> {
  static bool IsNull(const ::device::mojom::XRDeviceDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRDeviceDataPtr* output) { output->reset(); }

  static bool Read(::device::mojom::XRDeviceData::DataView input, ::device::mojom::XRDeviceDataPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_H_