// device/vr/public/mojom/isolated_xr_service.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_PARAMS_DATA_H_
#define DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace device {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRSessionController_SetFrameDataRestricted_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRSessionController_SetFrameDataRestricted_Params_Data));
      new (data()) XRSessionController_SetFrameDataRestricted_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRSessionController_SetFrameDataRestricted_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRSessionController_SetFrameDataRestricted_Params_Data>(index_);
    }
    XRSessionController_SetFrameDataRestricted_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t restricted : 1;
  uint8_t padfinal_[7];

 private:
  XRSessionController_SetFrameDataRestricted_Params_Data();
  ~XRSessionController_SetFrameDataRestricted_Params_Data() = delete;
};
static_assert(sizeof(XRSessionController_SetFrameDataRestricted_Params_Data) == 16,
              "Bad sizeof(XRSessionController_SetFrameDataRestricted_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data));
      new (data()) XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data>(index_);
    }
    XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::device::mojom::internal::VRDisplayInfo_Data> display_info;

 private:
  XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data();
  ~XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data() = delete;
};
static_assert(sizeof(XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data) == 16,
              "Bad sizeof(XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data));
      new (data()) XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data>(index_);
    }
    XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t visibility_state;
  uint8_t padfinal_[4];

 private:
  XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data();
  ~XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data() = delete;
};
static_assert(sizeof(XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data) == 16,
              "Bad sizeof(XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRRuntimeEventListener_OnExitPresent_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRRuntimeEventListener_OnExitPresent_Params_Data));
      new (data()) XRRuntimeEventListener_OnExitPresent_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRRuntimeEventListener_OnExitPresent_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRRuntimeEventListener_OnExitPresent_Params_Data>(index_);
    }
    XRRuntimeEventListener_OnExitPresent_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  XRRuntimeEventListener_OnExitPresent_Params_Data();
  ~XRRuntimeEventListener_OnExitPresent_Params_Data() = delete;
};
static_assert(sizeof(XRRuntimeEventListener_OnExitPresent_Params_Data) == 8,
              "Bad sizeof(XRRuntimeEventListener_OnExitPresent_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRRuntime_RequestSession_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRRuntime_RequestSession_Params_Data));
      new (data()) XRRuntime_RequestSession_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRRuntime_RequestSession_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRRuntime_RequestSession_Params_Data>(index_);
    }
    XRRuntime_RequestSession_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::XRRuntimeSessionOptions_Data> options;

 private:
  XRRuntime_RequestSession_Params_Data();
  ~XRRuntime_RequestSession_Params_Data() = delete;
};
static_assert(sizeof(XRRuntime_RequestSession_Params_Data) == 16,
              "Bad sizeof(XRRuntime_RequestSession_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRRuntime_RequestSession_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRRuntime_RequestSession_ResponseParams_Data));
      new (data()) XRRuntime_RequestSession_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRRuntime_RequestSession_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRRuntime_RequestSession_ResponseParams_Data>(index_);
    }
    XRRuntime_RequestSession_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::device::mojom::internal::XRSession_Data> session;
  mojo::internal::Interface_Data controller;

 private:
  XRRuntime_RequestSession_ResponseParams_Data();
  ~XRRuntime_RequestSession_ResponseParams_Data() = delete;
};
static_assert(sizeof(XRRuntime_RequestSession_ResponseParams_Data) == 24,
              "Bad sizeof(XRRuntime_RequestSession_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRRuntime_ShutdownSession_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRRuntime_ShutdownSession_Params_Data));
      new (data()) XRRuntime_ShutdownSession_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRRuntime_ShutdownSession_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRRuntime_ShutdownSession_Params_Data>(index_);
    }
    XRRuntime_ShutdownSession_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  XRRuntime_ShutdownSession_Params_Data();
  ~XRRuntime_ShutdownSession_Params_Data() = delete;
};
static_assert(sizeof(XRRuntime_ShutdownSession_Params_Data) == 8,
              "Bad sizeof(XRRuntime_ShutdownSession_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRRuntime_ShutdownSession_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRRuntime_ShutdownSession_ResponseParams_Data));
      new (data()) XRRuntime_ShutdownSession_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRRuntime_ShutdownSession_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRRuntime_ShutdownSession_ResponseParams_Data>(index_);
    }
    XRRuntime_ShutdownSession_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  XRRuntime_ShutdownSession_ResponseParams_Data();
  ~XRRuntime_ShutdownSession_ResponseParams_Data() = delete;
};
static_assert(sizeof(XRRuntime_ShutdownSession_ResponseParams_Data) == 8,
              "Bad sizeof(XRRuntime_ShutdownSession_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRRuntime_ListenToDeviceChanges_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRRuntime_ListenToDeviceChanges_Params_Data));
      new (data()) XRRuntime_ListenToDeviceChanges_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRRuntime_ListenToDeviceChanges_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRRuntime_ListenToDeviceChanges_Params_Data>(index_);
    }
    XRRuntime_ListenToDeviceChanges_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data listener;

 private:
  XRRuntime_ListenToDeviceChanges_Params_Data();
  ~XRRuntime_ListenToDeviceChanges_Params_Data() = delete;
};
static_assert(sizeof(XRRuntime_ListenToDeviceChanges_Params_Data) == 16,
              "Bad sizeof(XRRuntime_ListenToDeviceChanges_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRRuntime_ListenToDeviceChanges_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRRuntime_ListenToDeviceChanges_ResponseParams_Data));
      new (data()) XRRuntime_ListenToDeviceChanges_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRRuntime_ListenToDeviceChanges_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRRuntime_ListenToDeviceChanges_ResponseParams_Data>(index_);
    }
    XRRuntime_ListenToDeviceChanges_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::device::mojom::internal::VRDisplayInfo_Data> display_info;

 private:
  XRRuntime_ListenToDeviceChanges_ResponseParams_Data();
  ~XRRuntime_ListenToDeviceChanges_ResponseParams_Data() = delete;
};
static_assert(sizeof(XRRuntime_ListenToDeviceChanges_ResponseParams_Data) == 16,
              "Bad sizeof(XRRuntime_ListenToDeviceChanges_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) ImmersiveOverlay_RequestNextOverlayPose_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImmersiveOverlay_RequestNextOverlayPose_Params_Data));
      new (data()) ImmersiveOverlay_RequestNextOverlayPose_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImmersiveOverlay_RequestNextOverlayPose_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImmersiveOverlay_RequestNextOverlayPose_Params_Data>(index_);
    }
    ImmersiveOverlay_RequestNextOverlayPose_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  ImmersiveOverlay_RequestNextOverlayPose_Params_Data();
  ~ImmersiveOverlay_RequestNextOverlayPose_Params_Data() = delete;
};
static_assert(sizeof(ImmersiveOverlay_RequestNextOverlayPose_Params_Data) == 8,
              "Bad sizeof(ImmersiveOverlay_RequestNextOverlayPose_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data));
      new (data()) ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data>(index_);
    }
    ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::XRRenderInfo_Data> render_info;

 private:
  ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data();
  ~ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data() = delete;
};
static_assert(sizeof(ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data) == 16,
              "Bad sizeof(ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) ImmersiveOverlay_SubmitOverlayTexture_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImmersiveOverlay_SubmitOverlayTexture_Params_Data));
      new (data()) ImmersiveOverlay_SubmitOverlayTexture_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImmersiveOverlay_SubmitOverlayTexture_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImmersiveOverlay_SubmitOverlayTexture_Params_Data>(index_);
    }
    ImmersiveOverlay_SubmitOverlayTexture_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int16_t frame_id;
  uint8_t pad0_[2];
  mojo::internal::Handle_Data texture;
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> left_bounds;
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> right_bounds;

 private:
  ImmersiveOverlay_SubmitOverlayTexture_Params_Data();
  ~ImmersiveOverlay_SubmitOverlayTexture_Params_Data() = delete;
};
static_assert(sizeof(ImmersiveOverlay_SubmitOverlayTexture_Params_Data) == 32,
              "Bad sizeof(ImmersiveOverlay_SubmitOverlayTexture_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data));
      new (data()) ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data>(index_);
    }
    ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data();
  ~ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data() = delete;
};
static_assert(sizeof(ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data) == 16,
              "Bad sizeof(ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data));
      new (data()) ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data>(index_);
    }
    ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t overlay_visible : 1;
  uint8_t webxr_visible : 1;
  uint8_t padfinal_[7];

 private:
  ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data();
  ~ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data() = delete;
};
static_assert(sizeof(ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data) == 16,
              "Bad sizeof(ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data));
      new (data()) ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data>(index_);
    }
    ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data();
  ~ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data() = delete;
};
static_assert(sizeof(ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data) == 8,
              "Bad sizeof(ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data));
      new (data()) ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data>(index_);
    }
    ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data();
  ~ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data() = delete;
};
static_assert(sizeof(ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data) == 8,
              "Bad sizeof(ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRCompositorHost_CreateImmersiveOverlay_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRCompositorHost_CreateImmersiveOverlay_Params_Data));
      new (data()) XRCompositorHost_CreateImmersiveOverlay_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRCompositorHost_CreateImmersiveOverlay_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRCompositorHost_CreateImmersiveOverlay_Params_Data>(index_);
    }
    XRCompositorHost_CreateImmersiveOverlay_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data overlay;
  uint8_t padfinal_[4];

 private:
  XRCompositorHost_CreateImmersiveOverlay_Params_Data();
  ~XRCompositorHost_CreateImmersiveOverlay_Params_Data() = delete;
};
static_assert(sizeof(XRCompositorHost_CreateImmersiveOverlay_Params_Data) == 16,
              "Bad sizeof(XRCompositorHost_CreateImmersiveOverlay_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data));
      new (data()) IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data>(index_);
    }
    IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data runtime;
  mojo::internal::Interface_Data compositor_host;
  mojo::internal::Pointer<internal::XRDeviceData_Data> device_data;
  int32_t device_id;
  uint8_t padfinal_[4];

 private:
  IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data();
  ~IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data() = delete;
};
static_assert(sizeof(IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data) == 40,
              "Bad sizeof(IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data));
      new (data()) IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data>(index_);
    }
    IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t device_index;
  uint8_t padfinal_[4];

 private:
  IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data();
  ~IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data() = delete;
};
static_assert(sizeof(IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data) == 16,
              "Bad sizeof(IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data));
      new (data()) IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data>(index_);
    }
    IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data();
  ~IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data() = delete;
};
static_assert(sizeof(IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data) == 8,
              "Bad sizeof(IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) IsolatedXRRuntimeProvider_RequestDevices_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(IsolatedXRRuntimeProvider_RequestDevices_Params_Data));
      new (data()) IsolatedXRRuntimeProvider_RequestDevices_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    IsolatedXRRuntimeProvider_RequestDevices_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<IsolatedXRRuntimeProvider_RequestDevices_Params_Data>(index_);
    }
    IsolatedXRRuntimeProvider_RequestDevices_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data client;

 private:
  IsolatedXRRuntimeProvider_RequestDevices_Params_Data();
  ~IsolatedXRRuntimeProvider_RequestDevices_Params_Data() = delete;
};
static_assert(sizeof(IsolatedXRRuntimeProvider_RequestDevices_Params_Data) == 16,
              "Bad sizeof(IsolatedXRRuntimeProvider_RequestDevices_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRDeviceService_BindRuntimeProvider_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRDeviceService_BindRuntimeProvider_Params_Data));
      new (data()) XRDeviceService_BindRuntimeProvider_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRDeviceService_BindRuntimeProvider_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRDeviceService_BindRuntimeProvider_Params_Data>(index_);
    }
    XRDeviceService_BindRuntimeProvider_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  XRDeviceService_BindRuntimeProvider_Params_Data();
  ~XRDeviceService_BindRuntimeProvider_Params_Data() = delete;
};
static_assert(sizeof(XRDeviceService_BindRuntimeProvider_Params_Data) == 16,
              "Bad sizeof(XRDeviceService_BindRuntimeProvider_Params_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRDeviceService_BindTestHook_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRDeviceService_BindTestHook_Params_Data));
      new (data()) XRDeviceService_BindTestHook_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRDeviceService_BindTestHook_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRDeviceService_BindTestHook_Params_Data>(index_);
    }
    XRDeviceService_BindTestHook_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  XRDeviceService_BindTestHook_Params_Data();
  ~XRDeviceService_BindTestHook_Params_Data() = delete;
};
static_assert(sizeof(XRDeviceService_BindTestHook_Params_Data) == 16,
              "Bad sizeof(XRDeviceService_BindTestHook_Params_Data)");

}  // namespace internal


class XRSessionController_SetFrameDataRestricted_ParamsDataView {
 public:
  XRSessionController_SetFrameDataRestricted_ParamsDataView() {}

  XRSessionController_SetFrameDataRestricted_ParamsDataView(
      internal::XRSessionController_SetFrameDataRestricted_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool restricted() const {
    return data_->restricted;
  }
 private:
  internal::XRSessionController_SetFrameDataRestricted_Params_Data* data_ = nullptr;
};



class XRRuntimeEventListener_OnDisplayInfoChanged_ParamsDataView {
 public:
  XRRuntimeEventListener_OnDisplayInfoChanged_ParamsDataView() {}

  XRRuntimeEventListener_OnDisplayInfoChanged_ParamsDataView(
      internal::XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDisplayInfoDataView(
      ::device::mojom::VRDisplayInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDisplayInfo(UserType* output) {
    
    auto* pointer = data_->display_info.Get();
    return mojo::internal::Deserialize<::device::mojom::VRDisplayInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRRuntimeEventListener_OnVisibilityStateChanged_ParamsDataView {
 public:
  XRRuntimeEventListener_OnVisibilityStateChanged_ParamsDataView() {}

  XRRuntimeEventListener_OnVisibilityStateChanged_ParamsDataView(
      internal::XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVisibilityState(UserType* output) const {
    auto data_value = data_->visibility_state;
    return mojo::internal::Deserialize<::device::mojom::XRVisibilityState>(
        data_value, output);
  }

  ::device::mojom::XRVisibilityState visibility_state() const {
    return static_cast<::device::mojom::XRVisibilityState>(data_->visibility_state);
  }
 private:
  internal::XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data* data_ = nullptr;
};



class XRRuntimeEventListener_OnExitPresent_ParamsDataView {
 public:
  XRRuntimeEventListener_OnExitPresent_ParamsDataView() {}

  XRRuntimeEventListener_OnExitPresent_ParamsDataView(
      internal::XRRuntimeEventListener_OnExitPresent_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::XRRuntimeEventListener_OnExitPresent_Params_Data* data_ = nullptr;
};



class XRRuntime_RequestSession_ParamsDataView {
 public:
  XRRuntime_RequestSession_ParamsDataView() {}

  XRRuntime_RequestSession_ParamsDataView(
      internal::XRRuntime_RequestSession_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOptionsDataView(
      XRRuntimeSessionOptionsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::device::mojom::XRRuntimeSessionOptionsDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRRuntime_RequestSession_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRRuntime_RequestSession_ResponseParamsDataView {
 public:
  XRRuntime_RequestSession_ResponseParamsDataView() {}

  XRRuntime_RequestSession_ResponseParamsDataView(
      internal::XRRuntime_RequestSession_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSessionDataView(
      ::device::mojom::XRSessionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSession(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRSessionDataView, UserType>(),
    "Attempting to read the optional `session` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSession` instead "
    "of `ReadSession if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->session.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSessionDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeController() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionControllerInterfaceBase>>(
            &data_->controller, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::XRRuntime_RequestSession_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRRuntime_ShutdownSession_ParamsDataView {
 public:
  XRRuntime_ShutdownSession_ParamsDataView() {}

  XRRuntime_ShutdownSession_ParamsDataView(
      internal::XRRuntime_ShutdownSession_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::XRRuntime_ShutdownSession_Params_Data* data_ = nullptr;
};



class XRRuntime_ShutdownSession_ResponseParamsDataView {
 public:
  XRRuntime_ShutdownSession_ResponseParamsDataView() {}

  XRRuntime_ShutdownSession_ResponseParamsDataView(
      internal::XRRuntime_ShutdownSession_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::XRRuntime_ShutdownSession_ResponseParams_Data* data_ = nullptr;
};



class XRRuntime_ListenToDeviceChanges_ParamsDataView {
 public:
  XRRuntime_ListenToDeviceChanges_ParamsDataView() {}

  XRRuntime_ListenToDeviceChanges_ParamsDataView(
      internal::XRRuntime_ListenToDeviceChanges_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::device::mojom::XRRuntimeEventListenerAssociatedPtrInfoDataView>(
            &data_->listener, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::XRRuntime_ListenToDeviceChanges_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRRuntime_ListenToDeviceChanges_ResponseParamsDataView {
 public:
  XRRuntime_ListenToDeviceChanges_ResponseParamsDataView() {}

  XRRuntime_ListenToDeviceChanges_ResponseParamsDataView(
      internal::XRRuntime_ListenToDeviceChanges_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDisplayInfoDataView(
      ::device::mojom::VRDisplayInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDisplayInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VRDisplayInfoDataView, UserType>(),
    "Attempting to read the optional `display_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDisplayInfo` instead "
    "of `ReadDisplayInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->display_info.Get();
    return mojo::internal::Deserialize<::device::mojom::VRDisplayInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRRuntime_ListenToDeviceChanges_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ImmersiveOverlay_RequestNextOverlayPose_ParamsDataView {
 public:
  ImmersiveOverlay_RequestNextOverlayPose_ParamsDataView() {}

  ImmersiveOverlay_RequestNextOverlayPose_ParamsDataView(
      internal::ImmersiveOverlay_RequestNextOverlayPose_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ImmersiveOverlay_RequestNextOverlayPose_Params_Data* data_ = nullptr;
};



class ImmersiveOverlay_RequestNextOverlayPose_ResponseParamsDataView {
 public:
  ImmersiveOverlay_RequestNextOverlayPose_ResponseParamsDataView() {}

  ImmersiveOverlay_RequestNextOverlayPose_ResponseParamsDataView(
      internal::ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetRenderInfoDataView(
      XRRenderInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRenderInfo(UserType* output) {
    
    auto* pointer = data_->render_info.Get();
    return mojo::internal::Deserialize<::device::mojom::XRRenderInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ImmersiveOverlay_SubmitOverlayTexture_ParamsDataView {
 public:
  ImmersiveOverlay_SubmitOverlayTexture_ParamsDataView() {}

  ImmersiveOverlay_SubmitOverlayTexture_ParamsDataView(
      internal::ImmersiveOverlay_SubmitOverlayTexture_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int16_t frame_id() const {
    return data_->frame_id;
  }
  mojo::PlatformHandle TakeTexture() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->texture, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetLeftBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLeftBounds(UserType* output) {
    
    auto* pointer = data_->left_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, context_);
  }
  inline void GetRightBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRightBounds(UserType* output) {
    
    auto* pointer = data_->right_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, context_);
  }
 private:
  internal::ImmersiveOverlay_SubmitOverlayTexture_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ImmersiveOverlay_SubmitOverlayTexture_ResponseParamsDataView {
 public:
  ImmersiveOverlay_SubmitOverlayTexture_ResponseParamsDataView() {}

  ImmersiveOverlay_SubmitOverlayTexture_ResponseParamsDataView(
      internal::ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data* data_ = nullptr;
};



class ImmersiveOverlay_SetOverlayAndWebXRVisibility_ParamsDataView {
 public:
  ImmersiveOverlay_SetOverlayAndWebXRVisibility_ParamsDataView() {}

  ImmersiveOverlay_SetOverlayAndWebXRVisibility_ParamsDataView(
      internal::ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool overlay_visible() const {
    return data_->overlay_visible;
  }
  bool webxr_visible() const {
    return data_->webxr_visible;
  }
 private:
  internal::ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data* data_ = nullptr;
};



class ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ParamsDataView {
 public:
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ParamsDataView() {}

  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ParamsDataView(
      internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data* data_ = nullptr;
};



class ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParamsDataView {
 public:
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParamsDataView() {}

  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParamsDataView(
      internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data* data_ = nullptr;
};



class XRCompositorHost_CreateImmersiveOverlay_ParamsDataView {
 public:
  XRCompositorHost_CreateImmersiveOverlay_ParamsDataView() {}

  XRCompositorHost_CreateImmersiveOverlay_ParamsDataView(
      internal::XRCompositorHost_CreateImmersiveOverlay_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeOverlay() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::ImmersiveOverlayInterfaceBase>>(
            &data_->overlay, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::XRCompositorHost_CreateImmersiveOverlay_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class IsolatedXRRuntimeProviderClient_OnDeviceAdded_ParamsDataView {
 public:
  IsolatedXRRuntimeProviderClient_OnDeviceAdded_ParamsDataView() {}

  IsolatedXRRuntimeProviderClient_OnDeviceAdded_ParamsDataView(
      internal::IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeRuntime() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRRuntimeInterfaceBase>>(
            &data_->runtime, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCompositorHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRCompositorHostInterfaceBase>>(
            &data_->compositor_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetDeviceDataDataView(
      XRDeviceDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDeviceData(UserType* output) {
    
    auto* pointer = data_->device_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRDeviceDataDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDeviceId(UserType* output) const {
    auto data_value = data_->device_id;
    return mojo::internal::Deserialize<::device::mojom::XRDeviceId>(
        data_value, output);
  }

  ::device::mojom::XRDeviceId device_id() const {
    return static_cast<::device::mojom::XRDeviceId>(data_->device_id);
  }
 private:
  internal::IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class IsolatedXRRuntimeProviderClient_OnDeviceRemoved_ParamsDataView {
 public:
  IsolatedXRRuntimeProviderClient_OnDeviceRemoved_ParamsDataView() {}

  IsolatedXRRuntimeProviderClient_OnDeviceRemoved_ParamsDataView(
      internal::IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDeviceIndex(UserType* output) const {
    auto data_value = data_->device_index;
    return mojo::internal::Deserialize<::device::mojom::XRDeviceId>(
        data_value, output);
  }

  ::device::mojom::XRDeviceId device_index() const {
    return static_cast<::device::mojom::XRDeviceId>(data_->device_index);
  }
 private:
  internal::IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data* data_ = nullptr;
};



class IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_ParamsDataView {
 public:
  IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_ParamsDataView() {}

  IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_ParamsDataView(
      internal::IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data* data_ = nullptr;
};



class IsolatedXRRuntimeProvider_RequestDevices_ParamsDataView {
 public:
  IsolatedXRRuntimeProvider_RequestDevices_ParamsDataView() {}

  IsolatedXRRuntimeProvider_RequestDevices_ParamsDataView(
      internal::IsolatedXRRuntimeProvider_RequestDevices_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::IsolatedXRRuntimeProviderClientInterfaceBase>>(
            &data_->client, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::IsolatedXRRuntimeProvider_RequestDevices_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRDeviceService_BindRuntimeProvider_ParamsDataView {
 public:
  XRDeviceService_BindRuntimeProvider_ParamsDataView() {}

  XRDeviceService_BindRuntimeProvider_ParamsDataView(
      internal::XRDeviceService_BindRuntimeProvider_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::IsolatedXRRuntimeProviderInterfaceBase>>(
            &data_->receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::XRDeviceService_BindRuntimeProvider_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRDeviceService_BindTestHook_ParamsDataView {
 public:
  XRDeviceService_BindTestHook_ParamsDataView() {}

  XRDeviceService_BindTestHook_ParamsDataView(
      internal::XRDeviceService_BindTestHook_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device_test::mojom::XRServiceTestHookInterfaceBase>>(
            &data_->receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::XRDeviceService_BindTestHook_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};




inline void XRRuntimeEventListener_OnDisplayInfoChanged_ParamsDataView::GetDisplayInfoDataView(
    ::device::mojom::VRDisplayInfoDataView* output) {
  auto pointer = data_->display_info.Get();
  *output = ::device::mojom::VRDisplayInfoDataView(pointer, context_);
}






inline void XRRuntime_RequestSession_ParamsDataView::GetOptionsDataView(
    XRRuntimeSessionOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = XRRuntimeSessionOptionsDataView(pointer, context_);
}


inline void XRRuntime_RequestSession_ResponseParamsDataView::GetSessionDataView(
    ::device::mojom::XRSessionDataView* output) {
  auto pointer = data_->session.Get();
  *output = ::device::mojom::XRSessionDataView(pointer, context_);
}








inline void XRRuntime_ListenToDeviceChanges_ResponseParamsDataView::GetDisplayInfoDataView(
    ::device::mojom::VRDisplayInfoDataView* output) {
  auto pointer = data_->display_info.Get();
  *output = ::device::mojom::VRDisplayInfoDataView(pointer, context_);
}




inline void ImmersiveOverlay_RequestNextOverlayPose_ResponseParamsDataView::GetRenderInfoDataView(
    XRRenderInfoDataView* output) {
  auto pointer = data_->render_info.Get();
  *output = XRRenderInfoDataView(pointer, context_);
}


inline void ImmersiveOverlay_SubmitOverlayTexture_ParamsDataView::GetLeftBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->left_bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, context_);
}
inline void ImmersiveOverlay_SubmitOverlayTexture_ParamsDataView::GetRightBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->right_bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, context_);
}












inline void IsolatedXRRuntimeProviderClient_OnDeviceAdded_ParamsDataView::GetDeviceDataDataView(
    XRDeviceDataDataView* output) {
  auto pointer = data_->device_data.Get();
  *output = XRDeviceDataDataView(pointer, context_);
}











}  // namespace mojom
}  // namespace device

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_PARAMS_DATA_H_