// content/common/renderer.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_MOJOM_PARAMS_DATA_H_
#define CONTENT_COMMON_RENDERER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace content {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_CreateAgentSchedulingGroup_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_CreateAgentSchedulingGroup_Params_Data));
      new (data()) Renderer_CreateAgentSchedulingGroup_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_CreateAgentSchedulingGroup_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_CreateAgentSchedulingGroup_Params_Data>(index_);
    }
    Renderer_CreateAgentSchedulingGroup_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data agent_scheduling_group_host;
  mojo::internal::Handle_Data agent_scheduling_group;
  uint8_t padfinal_[4];

 private:
  Renderer_CreateAgentSchedulingGroup_Params_Data();
  ~Renderer_CreateAgentSchedulingGroup_Params_Data() = delete;
};
static_assert(sizeof(Renderer_CreateAgentSchedulingGroup_Params_Data) == 24,
              "Bad sizeof(Renderer_CreateAgentSchedulingGroup_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data));
      new (data()) Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data>(index_);
    }
    Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data agent_scheduling_group_host;
  mojo::internal::AssociatedEndpointHandle_Data agent_scheduling_group;
  uint8_t padfinal_[4];

 private:
  Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data();
  ~Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data() = delete;
};
static_assert(sizeof(Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data) == 24,
              "Bad sizeof(Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_OnNetworkConnectionChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_OnNetworkConnectionChanged_Params_Data));
      new (data()) Renderer_OnNetworkConnectionChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_OnNetworkConnectionChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_OnNetworkConnectionChanged_Params_Data>(index_);
    }
    Renderer_OnNetworkConnectionChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t connection_type;
  uint8_t pad0_[4];
  double max_bandwidth_mbps;

 private:
  Renderer_OnNetworkConnectionChanged_Params_Data();
  ~Renderer_OnNetworkConnectionChanged_Params_Data() = delete;
};
static_assert(sizeof(Renderer_OnNetworkConnectionChanged_Params_Data) == 24,
              "Bad sizeof(Renderer_OnNetworkConnectionChanged_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_OnNetworkQualityChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_OnNetworkQualityChanged_Params_Data));
      new (data()) Renderer_OnNetworkQualityChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_OnNetworkQualityChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_OnNetworkQualityChanged_Params_Data>(index_);
    }
    Renderer_OnNetworkQualityChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t effective_connection_type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> http_rtt;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> transport_rtt;
  double bandwidth_kbps;

 private:
  Renderer_OnNetworkQualityChanged_Params_Data();
  ~Renderer_OnNetworkQualityChanged_Params_Data() = delete;
};
static_assert(sizeof(Renderer_OnNetworkQualityChanged_Params_Data) == 40,
              "Bad sizeof(Renderer_OnNetworkQualityChanged_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetWebKitSharedTimersSuspended_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_SetWebKitSharedTimersSuspended_Params_Data));
      new (data()) Renderer_SetWebKitSharedTimersSuspended_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_SetWebKitSharedTimersSuspended_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_SetWebKitSharedTimersSuspended_Params_Data>(index_);
    }
    Renderer_SetWebKitSharedTimersSuspended_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t suspend : 1;
  uint8_t padfinal_[7];

 private:
  Renderer_SetWebKitSharedTimersSuspended_Params_Data();
  ~Renderer_SetWebKitSharedTimersSuspended_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetWebKitSharedTimersSuspended_Params_Data) == 16,
              "Bad sizeof(Renderer_SetWebKitSharedTimersSuspended_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetUserAgent_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_SetUserAgent_Params_Data));
      new (data()) Renderer_SetUserAgent_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_SetUserAgent_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_SetUserAgent_Params_Data>(index_);
    }
    Renderer_SetUserAgent_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> user_agent;

 private:
  Renderer_SetUserAgent_Params_Data();
  ~Renderer_SetUserAgent_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetUserAgent_Params_Data) == 16,
              "Bad sizeof(Renderer_SetUserAgent_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetUserAgentMetadata_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_SetUserAgentMetadata_Params_Data));
      new (data()) Renderer_SetUserAgentMetadata_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_SetUserAgentMetadata_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_SetUserAgentMetadata_Params_Data>(index_);
    }
    Renderer_SetUserAgentMetadata_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::UserAgentMetadata_Data> metadata;

 private:
  Renderer_SetUserAgentMetadata_Params_Data();
  ~Renderer_SetUserAgentMetadata_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetUserAgentMetadata_Params_Data) == 16,
              "Bad sizeof(Renderer_SetUserAgentMetadata_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetCorsExemptHeaderList_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_SetCorsExemptHeaderList_Params_Data));
      new (data()) Renderer_SetCorsExemptHeaderList_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_SetCorsExemptHeaderList_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_SetCorsExemptHeaderList_Params_Data>(index_);
    }
    Renderer_SetCorsExemptHeaderList_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> list;

 private:
  Renderer_SetCorsExemptHeaderList_Params_Data();
  ~Renderer_SetCorsExemptHeaderList_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetCorsExemptHeaderList_Params_Data) == 16,
              "Bad sizeof(Renderer_SetCorsExemptHeaderList_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_UpdateScrollbarTheme_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_UpdateScrollbarTheme_Params_Data));
      new (data()) Renderer_UpdateScrollbarTheme_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_UpdateScrollbarTheme_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_UpdateScrollbarTheme_Params_Data>(index_);
    }
    Renderer_UpdateScrollbarTheme_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::UpdateScrollbarThemeParams_Data> params;

 private:
  Renderer_UpdateScrollbarTheme_Params_Data();
  ~Renderer_UpdateScrollbarTheme_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UpdateScrollbarTheme_Params_Data) == 16,
              "Bad sizeof(Renderer_UpdateScrollbarTheme_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_OnSystemColorsChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_OnSystemColorsChanged_Params_Data));
      new (data()) Renderer_OnSystemColorsChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_OnSystemColorsChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_OnSystemColorsChanged_Params_Data>(index_);
    }
    Renderer_OnSystemColorsChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t aqua_color_variant;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> highlight_text_color;
  mojo::internal::Pointer<mojo::internal::String_Data> highlight_color;

 private:
  Renderer_OnSystemColorsChanged_Params_Data();
  ~Renderer_OnSystemColorsChanged_Params_Data() = delete;
};
static_assert(sizeof(Renderer_OnSystemColorsChanged_Params_Data) == 32,
              "Bad sizeof(Renderer_OnSystemColorsChanged_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_UpdateSystemColorInfo_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_UpdateSystemColorInfo_Params_Data));
      new (data()) Renderer_UpdateSystemColorInfo_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_UpdateSystemColorInfo_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_UpdateSystemColorInfo_Params_Data>(index_);
    }
    Renderer_UpdateSystemColorInfo_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::UpdateSystemColorInfoParams_Data> params;

 private:
  Renderer_UpdateSystemColorInfo_Params_Data();
  ~Renderer_UpdateSystemColorInfo_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UpdateSystemColorInfo_Params_Data) == 16,
              "Bad sizeof(Renderer_UpdateSystemColorInfo_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_PurgePluginListCache_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_PurgePluginListCache_Params_Data));
      new (data()) Renderer_PurgePluginListCache_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_PurgePluginListCache_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_PurgePluginListCache_Params_Data>(index_);
    }
    Renderer_PurgePluginListCache_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t reload_pages : 1;
  uint8_t padfinal_[7];

 private:
  Renderer_PurgePluginListCache_Params_Data();
  ~Renderer_PurgePluginListCache_Params_Data() = delete;
};
static_assert(sizeof(Renderer_PurgePluginListCache_Params_Data) == 16,
              "Bad sizeof(Renderer_PurgePluginListCache_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetProcessState_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_SetProcessState_Params_Data));
      new (data()) Renderer_SetProcessState_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_SetProcessState_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_SetProcessState_Params_Data>(index_);
    }
    Renderer_SetProcessState_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t background_state;
  int32_t visible_state;

 private:
  Renderer_SetProcessState_Params_Data();
  ~Renderer_SetProcessState_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetProcessState_Params_Data) == 16,
              "Bad sizeof(Renderer_SetProcessState_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetSchedulerKeepActive_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_SetSchedulerKeepActive_Params_Data));
      new (data()) Renderer_SetSchedulerKeepActive_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_SetSchedulerKeepActive_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_SetSchedulerKeepActive_Params_Data>(index_);
    }
    Renderer_SetSchedulerKeepActive_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t keep_active : 1;
  uint8_t padfinal_[7];

 private:
  Renderer_SetSchedulerKeepActive_Params_Data();
  ~Renderer_SetSchedulerKeepActive_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetSchedulerKeepActive_Params_Data) == 16,
              "Bad sizeof(Renderer_SetSchedulerKeepActive_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetIsLockedToSite_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_SetIsLockedToSite_Params_Data));
      new (data()) Renderer_SetIsLockedToSite_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_SetIsLockedToSite_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_SetIsLockedToSite_Params_Data>(index_);
    }
    Renderer_SetIsLockedToSite_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  Renderer_SetIsLockedToSite_Params_Data();
  ~Renderer_SetIsLockedToSite_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetIsLockedToSite_Params_Data) == 8,
              "Bad sizeof(Renderer_SetIsLockedToSite_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetIsCrossOriginIsolated_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Renderer_SetIsCrossOriginIsolated_Params_Data));
      new (data()) Renderer_SetIsCrossOriginIsolated_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Renderer_SetIsCrossOriginIsolated_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Renderer_SetIsCrossOriginIsolated_Params_Data>(index_);
    }
    Renderer_SetIsCrossOriginIsolated_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t value : 1;
  uint8_t padfinal_[7];

 private:
  Renderer_SetIsCrossOriginIsolated_Params_Data();
  ~Renderer_SetIsCrossOriginIsolated_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetIsCrossOriginIsolated_Params_Data) == 16,
              "Bad sizeof(Renderer_SetIsCrossOriginIsolated_Params_Data)");

}  // namespace internal


class Renderer_CreateAgentSchedulingGroup_ParamsDataView {
 public:
  Renderer_CreateAgentSchedulingGroup_ParamsDataView() {}

  Renderer_CreateAgentSchedulingGroup_ParamsDataView(
      internal::Renderer_CreateAgentSchedulingGroup_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeAgentSchedulingGroupHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::content::mojom::AgentSchedulingGroupHostInterfaceBase>>(
            &data_->agent_scheduling_group_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAgentSchedulingGroup() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::content::mojom::AgentSchedulingGroupInterfaceBase>>(
            &data_->agent_scheduling_group, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Renderer_CreateAgentSchedulingGroup_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Renderer_CreateAssociatedAgentSchedulingGroup_ParamsDataView {
 public:
  Renderer_CreateAssociatedAgentSchedulingGroup_ParamsDataView() {}

  Renderer_CreateAssociatedAgentSchedulingGroup_ParamsDataView(
      internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeAgentSchedulingGroupHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::content::mojom::AgentSchedulingGroupHostAssociatedPtrInfoDataView>(
            &data_->agent_scheduling_group_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAgentSchedulingGroup() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::content::mojom::AgentSchedulingGroupAssociatedRequestDataView>(
            &data_->agent_scheduling_group, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Renderer_OnNetworkConnectionChanged_ParamsDataView {
 public:
  Renderer_OnNetworkConnectionChanged_ParamsDataView() {}

  Renderer_OnNetworkConnectionChanged_ParamsDataView(
      internal::Renderer_OnNetworkConnectionChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConnectionType(UserType* output) const {
    auto data_value = data_->connection_type;
    return mojo::internal::Deserialize<::content::mojom::NetworkConnectionType>(
        data_value, output);
  }

  ::content::mojom::NetworkConnectionType connection_type() const {
    return static_cast<::content::mojom::NetworkConnectionType>(data_->connection_type);
  }
  double max_bandwidth_mbps() const {
    return data_->max_bandwidth_mbps;
  }
 private:
  internal::Renderer_OnNetworkConnectionChanged_Params_Data* data_ = nullptr;
};



class Renderer_OnNetworkQualityChanged_ParamsDataView {
 public:
  Renderer_OnNetworkQualityChanged_ParamsDataView() {}

  Renderer_OnNetworkQualityChanged_ParamsDataView(
      internal::Renderer_OnNetworkQualityChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEffectiveConnectionType(UserType* output) const {
    auto data_value = data_->effective_connection_type;
    return mojo::internal::Deserialize<::network::mojom::EffectiveConnectionType>(
        data_value, output);
  }

  ::network::mojom::EffectiveConnectionType effective_connection_type() const {
    return static_cast<::network::mojom::EffectiveConnectionType>(data_->effective_connection_type);
  }
  inline void GetHttpRttDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHttpRtt(UserType* output) {
    
    auto* pointer = data_->http_rtt.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
  inline void GetTransportRttDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTransportRtt(UserType* output) {
    
    auto* pointer = data_->transport_rtt.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
  double bandwidth_kbps() const {
    return data_->bandwidth_kbps;
  }
 private:
  internal::Renderer_OnNetworkQualityChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Renderer_SetWebKitSharedTimersSuspended_ParamsDataView {
 public:
  Renderer_SetWebKitSharedTimersSuspended_ParamsDataView() {}

  Renderer_SetWebKitSharedTimersSuspended_ParamsDataView(
      internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool suspend() const {
    return data_->suspend;
  }
 private:
  internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data* data_ = nullptr;
};



class Renderer_SetUserAgent_ParamsDataView {
 public:
  Renderer_SetUserAgent_ParamsDataView() {}

  Renderer_SetUserAgent_ParamsDataView(
      internal::Renderer_SetUserAgent_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUserAgentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUserAgent(UserType* output) {
    
    auto* pointer = data_->user_agent.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::Renderer_SetUserAgent_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Renderer_SetUserAgentMetadata_ParamsDataView {
 public:
  Renderer_SetUserAgentMetadata_ParamsDataView() {}

  Renderer_SetUserAgentMetadata_ParamsDataView(
      internal::Renderer_SetUserAgentMetadata_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMetadataDataView(
      ::blink::mojom::UserAgentMetadataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::blink::mojom::UserAgentMetadataDataView>(
        pointer, output, context_);
  }
 private:
  internal::Renderer_SetUserAgentMetadata_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Renderer_SetCorsExemptHeaderList_ParamsDataView {
 public:
  Renderer_SetCorsExemptHeaderList_ParamsDataView() {}

  Renderer_SetCorsExemptHeaderList_ParamsDataView(
      internal::Renderer_SetCorsExemptHeaderList_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadList(UserType* output) {
    
    auto* pointer = data_->list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
 private:
  internal::Renderer_SetCorsExemptHeaderList_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Renderer_UpdateScrollbarTheme_ParamsDataView {
 public:
  Renderer_UpdateScrollbarTheme_ParamsDataView() {}

  Renderer_UpdateScrollbarTheme_ParamsDataView(
      internal::Renderer_UpdateScrollbarTheme_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      UpdateScrollbarThemeParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::content::mojom::UpdateScrollbarThemeParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::Renderer_UpdateScrollbarTheme_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Renderer_OnSystemColorsChanged_ParamsDataView {
 public:
  Renderer_OnSystemColorsChanged_ParamsDataView() {}

  Renderer_OnSystemColorsChanged_ParamsDataView(
      internal::Renderer_OnSystemColorsChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t aqua_color_variant() const {
    return data_->aqua_color_variant;
  }
  inline void GetHighlightTextColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHighlightTextColor(UserType* output) {
    
    auto* pointer = data_->highlight_text_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetHighlightColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHighlightColor(UserType* output) {
    
    auto* pointer = data_->highlight_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::Renderer_OnSystemColorsChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Renderer_UpdateSystemColorInfo_ParamsDataView {
 public:
  Renderer_UpdateSystemColorInfo_ParamsDataView() {}

  Renderer_UpdateSystemColorInfo_ParamsDataView(
      internal::Renderer_UpdateSystemColorInfo_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      UpdateSystemColorInfoParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::content::mojom::UpdateSystemColorInfoParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::Renderer_UpdateSystemColorInfo_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Renderer_PurgePluginListCache_ParamsDataView {
 public:
  Renderer_PurgePluginListCache_ParamsDataView() {}

  Renderer_PurgePluginListCache_ParamsDataView(
      internal::Renderer_PurgePluginListCache_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool reload_pages() const {
    return data_->reload_pages;
  }
 private:
  internal::Renderer_PurgePluginListCache_Params_Data* data_ = nullptr;
};



class Renderer_SetProcessState_ParamsDataView {
 public:
  Renderer_SetProcessState_ParamsDataView() {}

  Renderer_SetProcessState_ParamsDataView(
      internal::Renderer_SetProcessState_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBackgroundState(UserType* output) const {
    auto data_value = data_->background_state;
    return mojo::internal::Deserialize<::content::mojom::RenderProcessBackgroundState>(
        data_value, output);
  }

  RenderProcessBackgroundState background_state() const {
    return static_cast<RenderProcessBackgroundState>(data_->background_state);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVisibleState(UserType* output) const {
    auto data_value = data_->visible_state;
    return mojo::internal::Deserialize<::content::mojom::RenderProcessVisibleState>(
        data_value, output);
  }

  RenderProcessVisibleState visible_state() const {
    return static_cast<RenderProcessVisibleState>(data_->visible_state);
  }
 private:
  internal::Renderer_SetProcessState_Params_Data* data_ = nullptr;
};



class Renderer_SetSchedulerKeepActive_ParamsDataView {
 public:
  Renderer_SetSchedulerKeepActive_ParamsDataView() {}

  Renderer_SetSchedulerKeepActive_ParamsDataView(
      internal::Renderer_SetSchedulerKeepActive_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool keep_active() const {
    return data_->keep_active;
  }
 private:
  internal::Renderer_SetSchedulerKeepActive_Params_Data* data_ = nullptr;
};



class Renderer_SetIsLockedToSite_ParamsDataView {
 public:
  Renderer_SetIsLockedToSite_ParamsDataView() {}

  Renderer_SetIsLockedToSite_ParamsDataView(
      internal::Renderer_SetIsLockedToSite_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_SetIsLockedToSite_Params_Data* data_ = nullptr;
};



class Renderer_SetIsCrossOriginIsolated_ParamsDataView {
 public:
  Renderer_SetIsCrossOriginIsolated_ParamsDataView() {}

  Renderer_SetIsCrossOriginIsolated_ParamsDataView(
      internal::Renderer_SetIsCrossOriginIsolated_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool value() const {
    return data_->value;
  }
 private:
  internal::Renderer_SetIsCrossOriginIsolated_Params_Data* data_ = nullptr;
};








inline void Renderer_OnNetworkQualityChanged_ParamsDataView::GetHttpRttDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->http_rtt.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}
inline void Renderer_OnNetworkQualityChanged_ParamsDataView::GetTransportRttDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->transport_rtt.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}




inline void Renderer_SetUserAgent_ParamsDataView::GetUserAgentDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_agent.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void Renderer_SetUserAgentMetadata_ParamsDataView::GetMetadataDataView(
    ::blink::mojom::UserAgentMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = ::blink::mojom::UserAgentMetadataDataView(pointer, context_);
}


inline void Renderer_SetCorsExemptHeaderList_ParamsDataView::GetListDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->list.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}


inline void Renderer_UpdateScrollbarTheme_ParamsDataView::GetParamsDataView(
    UpdateScrollbarThemeParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = UpdateScrollbarThemeParamsDataView(pointer, context_);
}


inline void Renderer_OnSystemColorsChanged_ParamsDataView::GetHighlightTextColorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->highlight_text_color.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void Renderer_OnSystemColorsChanged_ParamsDataView::GetHighlightColorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->highlight_color.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void Renderer_UpdateSystemColorInfo_ParamsDataView::GetParamsDataView(
    UpdateSystemColorInfoParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = UpdateSystemColorInfoParamsDataView(pointer, context_);
}











}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_COMMON_RENDERER_MOJOM_PARAMS_DATA_H_