// content/common/frame.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_MOJOM_SHARED_H_
#define CONTENT_COMMON_FRAME_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/common/frame.mojom-shared-internal.h"
#include "content/common/document_scoped_interface_bundle.mojom-shared.h"
#include "content/common/frame_messages.mojom-shared.h"
#include "content/common/native_types.mojom-shared.h"
#include "content/common/navigation_client.mojom-shared.h"
#include "content/common/navigation_params.mojom-shared.h"
#include "content/common/web_ui.mojom-shared.h"
#include "content/public/common/browser_controls_state.mojom-shared.h"
#include "content/public/common/window_container_type.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/document_policy_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/policy_value.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/navigation_initiator.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared.h"
#include "third_party/blink/public/mojom/portal/portal.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace content {
namespace mojom {
class CreateNewWindowParamsDataView;

class CreateNewWindowReplyDataView;

class OpenURLParamsDataView;



}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::CreateNewWindowParamsDataView> {
  using Data = ::content::mojom::internal::CreateNewWindowParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateNewWindowReplyDataView> {
  using Data = ::content::mojom::internal::CreateNewWindowReply_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::OpenURLParamsDataView> {
  using Data = ::content::mojom::internal::OpenURLParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {


enum class CreateNewWindowStatus : int32_t {
  
  kIgnore = 0,
  
  kReuse = 1,
  
  kSuccess = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, CreateNewWindowStatus value);
inline bool IsKnownEnumValue(CreateNewWindowStatus value) {
  return internal::CreateNewWindowStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
using TriggeringEventInfo = mojo::NativeEnum;
// Interface base classes. They are used for type safety check.
class FrameHTMLSerializerHandlerInterfaceBase {};

using FrameHTMLSerializerHandlerPtrDataView =
    mojo::InterfacePtrDataView<FrameHTMLSerializerHandlerInterfaceBase>;
using FrameHTMLSerializerHandlerRequestDataView =
    mojo::InterfaceRequestDataView<FrameHTMLSerializerHandlerInterfaceBase>;
using FrameHTMLSerializerHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameHTMLSerializerHandlerInterfaceBase>;
using FrameHTMLSerializerHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameHTMLSerializerHandlerInterfaceBase>;
class FrameInterfaceBase {};

using FramePtrDataView =
    mojo::InterfacePtrDataView<FrameInterfaceBase>;
using FrameRequestDataView =
    mojo::InterfaceRequestDataView<FrameInterfaceBase>;
using FrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameInterfaceBase>;
using FrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameInterfaceBase>;
class FrameNavigationControlInterfaceBase {};

using FrameNavigationControlPtrDataView =
    mojo::InterfacePtrDataView<FrameNavigationControlInterfaceBase>;
using FrameNavigationControlRequestDataView =
    mojo::InterfaceRequestDataView<FrameNavigationControlInterfaceBase>;
using FrameNavigationControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameNavigationControlInterfaceBase>;
using FrameNavigationControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameNavigationControlInterfaceBase>;
class FrameBindingsControlInterfaceBase {};

using FrameBindingsControlPtrDataView =
    mojo::InterfacePtrDataView<FrameBindingsControlInterfaceBase>;
using FrameBindingsControlRequestDataView =
    mojo::InterfaceRequestDataView<FrameBindingsControlInterfaceBase>;
using FrameBindingsControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameBindingsControlInterfaceBase>;
using FrameBindingsControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameBindingsControlInterfaceBase>;
class FrameFactoryInterfaceBase {};

using FrameFactoryPtrDataView =
    mojo::InterfacePtrDataView<FrameFactoryInterfaceBase>;
using FrameFactoryRequestDataView =
    mojo::InterfaceRequestDataView<FrameFactoryInterfaceBase>;
using FrameFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameFactoryInterfaceBase>;
using FrameFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameFactoryInterfaceBase>;
class KeepAliveHandleInterfaceBase {};

using KeepAliveHandlePtrDataView =
    mojo::InterfacePtrDataView<KeepAliveHandleInterfaceBase>;
using KeepAliveHandleRequestDataView =
    mojo::InterfaceRequestDataView<KeepAliveHandleInterfaceBase>;
using KeepAliveHandleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<KeepAliveHandleInterfaceBase>;
using KeepAliveHandleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<KeepAliveHandleInterfaceBase>;
class FrameHostInterfaceBase {};

using FrameHostPtrDataView =
    mojo::InterfacePtrDataView<FrameHostInterfaceBase>;
using FrameHostRequestDataView =
    mojo::InterfaceRequestDataView<FrameHostInterfaceBase>;
using FrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameHostInterfaceBase>;
using FrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameHostInterfaceBase>;


class CreateNewWindowParamsDataView {
 public:
  CreateNewWindowParamsDataView() {}

  CreateNewWindowParamsDataView(
      internal::CreateNewWindowParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool allow_popup() const {
    return data_->allow_popup;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWindowContainerType(UserType* output) const {
    auto data_value = data_->window_container_type;
    return mojo::internal::Deserialize<::content::mojom::WindowContainerType>(
        data_value, output);
  }

  ::content::mojom::WindowContainerType window_container_type() const {
    return static_cast<::content::mojom::WindowContainerType>(data_->window_container_type);
  }
  inline void GetSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetCloneFromSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCloneFromSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->clone_from_session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetFrameNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameName(UserType* output) {
    
    auto* pointer = data_->frame_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool opener_suppressed() const {
    return data_->opener_suppressed;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDisposition(UserType* output) const {
    auto data_value = data_->disposition;
    return mojo::internal::Deserialize<::ui::mojom::WindowOpenDisposition>(
        data_value, output);
  }

  ::ui::mojom::WindowOpenDisposition disposition() const {
    return static_cast<::ui::mojom::WindowOpenDisposition>(data_->disposition);
  }
  inline void GetTargetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTargetUrl(UserType* output) {
    
    auto* pointer = data_->target_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, context_);
  }
  inline void GetFeaturesDataView(
      ::blink::mojom::WindowFeaturesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFeatures(UserType* output) {
    
    auto* pointer = data_->features.Get();
    return mojo::internal::Deserialize<::blink::mojom::WindowFeaturesDataView>(
        pointer, output, context_);
  }
 private:
  internal::CreateNewWindowParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CreateNewWindowReplyDataView {
 public:
  CreateNewWindowReplyDataView() {}

  CreateNewWindowReplyDataView(
      internal::CreateNewWindowReply_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t route_id() const {
    return data_->route_id;
  }
  int32_t main_frame_route_id() const {
    return data_->main_frame_route_id;
  }
  inline void GetMainFrameFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMainFrameFrameToken(UserType* output) {
    
    auto* pointer = data_->main_frame_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  int32_t main_frame_widget_route_id() const {
    return data_->main_frame_widget_route_id;
  }
  inline void GetVisualPropertiesDataView(
      ::blink::mojom::VisualPropertiesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVisualProperties(UserType* output) {
    
    auto* pointer = data_->visual_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::VisualPropertiesDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeFrameWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetHostAssociatedPtrInfoDataView>(
            &data_->frame_widget_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetAssociatedRequestDataView>(
            &data_->frame_widget, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetHostAssociatedPtrInfoDataView>(
            &data_->widget_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetAssociatedRequestDataView>(
            &data_->widget, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakePageBroadcast() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::PageBroadcastAssociatedRequestDataView>(
            &data_->page_broadcast, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetMainFrameInterfaceBundleDataView(
      ::content::mojom::DocumentScopedInterfaceBundleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMainFrameInterfaceBundle(UserType* output) {
    
    auto* pointer = data_->main_frame_interface_bundle.Get();
    return mojo::internal::Deserialize<::content::mojom::DocumentScopedInterfaceBundleDataView>(
        pointer, output, context_);
  }
  inline void GetClonedSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadClonedSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->cloned_session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetDevtoolsMainFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDevtoolsMainFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_main_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  bool wait_for_debugger() const {
    return data_->wait_for_debugger;
  }
 private:
  internal::CreateNewWindowReply_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class OpenURLParamsDataView {
 public:
  OpenURLParamsDataView() {}

  OpenURLParamsDataView(
      internal::OpenURLParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetInitiatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInitiatorOrigin(UserType* output) {
    
    auto* pointer = data_->initiator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  int32_t initiator_routing_id() const {
    return data_->initiator_routing_id;
  }
  inline void GetPostBodyDataView(
      ::network::mojom::URLRequestBodyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPostBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLRequestBodyDataView, UserType>(),
    "Attempting to read the optional `post_body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPostBody` instead "
    "of `ReadPostBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->post_body.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestBodyDataView>(
        pointer, output, context_);
  }
  inline void GetExtraHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExtraHeaders(UserType* output) {
    
    auto* pointer = data_->extra_headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDisposition(UserType* output) const {
    auto data_value = data_->disposition;
    return mojo::internal::Deserialize<::ui::mojom::WindowOpenDisposition>(
        data_value, output);
  }

  ::ui::mojom::WindowOpenDisposition disposition() const {
    return static_cast<::ui::mojom::WindowOpenDisposition>(data_->disposition);
  }
  bool should_replace_current_entry() const {
    return data_->should_replace_current_entry;
  }
  bool user_gesture() const {
    return data_->user_gesture;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTriggeringEventInfo(UserType* output) const {
    auto data_value = data_->triggering_event_info;
    return mojo::internal::Deserialize<::content::mojom::TriggeringEventInfo>(
        data_value, output);
  }

  TriggeringEventInfo triggering_event_info() const {
    return static_cast<TriggeringEventInfo>(data_->triggering_event_info);
  }
  mojo::ScopedMessagePipeHandle TakeBlobUrlToken() {
    mojo::ScopedMessagePipeHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedMessagePipeHandle>(
            &data_->blob_url_token, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetHrefTranslateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHrefTranslate(UserType* output) {
    
    auto* pointer = data_->href_translate.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetImpressionDataView(
      ::content::mojom::ImpressionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImpression(UserType* output) {
    
    auto* pointer = data_->impression.Get();
    return mojo::internal::Deserialize<::content::mojom::ImpressionDataView>(
        pointer, output, context_);
  }
  inline void GetDownloadPolicyDataView(
      ::content::mojom::NavigationDownloadPolicyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDownloadPolicy(UserType* output) {
    
    auto* pointer = data_->download_policy.Get();
    return mojo::internal::Deserialize<::content::mojom::NavigationDownloadPolicyDataView>(
        pointer, output, context_);
  }
 private:
  internal::OpenURLParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

template <>
struct hash<::content::mojom::CreateNewWindowStatus>
    : public mojo::internal::EnumHashImpl<::content::mojom::CreateNewWindowStatus> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::content::mojom::CreateNewWindowStatus, ::content::mojom::CreateNewWindowStatus> {
  static ::content::mojom::CreateNewWindowStatus ToMojom(::content::mojom::CreateNewWindowStatus input) { return input; }
  static bool FromMojom(::content::mojom::CreateNewWindowStatus input, ::content::mojom::CreateNewWindowStatus* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateNewWindowStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::CreateNewWindowStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::content::mojom::CreateNewWindowStatus>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateNewWindowParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateNewWindowParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::CreateNewWindowParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->allow_popup = Traits::allow_popup(input);
    mojo::internal::Serialize<::content::mojom::WindowContainerType>(
        Traits::window_container_type(input), &(*output)->window_container_type);
    decltype(Traits::session_storage_namespace_id(input)) in_session_storage_namespace_id = Traits::session_storage_namespace_id(input);
    typename decltype((*output)->session_storage_namespace_id)::BaseType::BufferWriter
        session_storage_namespace_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_session_storage_namespace_id, buffer, &session_storage_namespace_id_writer, context);
    (*output)->session_storage_namespace_id.Set(
        session_storage_namespace_id_writer.is_null() ? nullptr : session_storage_namespace_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->session_storage_namespace_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_storage_namespace_id in CreateNewWindowParams struct");
    decltype(Traits::clone_from_session_storage_namespace_id(input)) in_clone_from_session_storage_namespace_id = Traits::clone_from_session_storage_namespace_id(input);
    typename decltype((*output)->clone_from_session_storage_namespace_id)::BaseType::BufferWriter
        clone_from_session_storage_namespace_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_clone_from_session_storage_namespace_id, buffer, &clone_from_session_storage_namespace_id_writer, context);
    (*output)->clone_from_session_storage_namespace_id.Set(
        clone_from_session_storage_namespace_id_writer.is_null() ? nullptr : clone_from_session_storage_namespace_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->clone_from_session_storage_namespace_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null clone_from_session_storage_namespace_id in CreateNewWindowParams struct");
    decltype(Traits::frame_name(input)) in_frame_name = Traits::frame_name(input);
    typename decltype((*output)->frame_name)::BaseType::BufferWriter
        frame_name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_frame_name, buffer, &frame_name_writer, context);
    (*output)->frame_name.Set(
        frame_name_writer.is_null() ? nullptr : frame_name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->frame_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_name in CreateNewWindowParams struct");
    (*output)->opener_suppressed = Traits::opener_suppressed(input);
    mojo::internal::Serialize<::ui::mojom::WindowOpenDisposition>(
        Traits::disposition(input), &(*output)->disposition);
    decltype(Traits::target_url(input)) in_target_url = Traits::target_url(input);
    typename decltype((*output)->target_url)::BaseType::BufferWriter
        target_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_target_url, buffer, &target_url_writer, context);
    (*output)->target_url.Set(
        target_url_writer.is_null() ? nullptr : target_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->target_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_url in CreateNewWindowParams struct");
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    typename decltype((*output)->referrer)::BaseType::BufferWriter
        referrer_writer;
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, buffer, &referrer_writer, context);
    (*output)->referrer.Set(
        referrer_writer.is_null() ? nullptr : referrer_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in CreateNewWindowParams struct");
    decltype(Traits::features(input)) in_features = Traits::features(input);
    typename decltype((*output)->features)::BaseType::BufferWriter
        features_writer;
    mojo::internal::Serialize<::blink::mojom::WindowFeaturesDataView>(
        in_features, buffer, &features_writer, context);
    (*output)->features.Set(
        features_writer.is_null() ? nullptr : features_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null features in CreateNewWindowParams struct");
  }

  static bool Deserialize(::content::mojom::internal::CreateNewWindowParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateNewWindowParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateNewWindowReplyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateNewWindowReplyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::CreateNewWindowReply_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->route_id = Traits::route_id(input);
    (*output)->main_frame_route_id = Traits::main_frame_route_id(input);
    decltype(Traits::main_frame_frame_token(input)) in_main_frame_frame_token = Traits::main_frame_frame_token(input);
    typename decltype((*output)->main_frame_frame_token)::BaseType::BufferWriter
        main_frame_frame_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_main_frame_frame_token, buffer, &main_frame_frame_token_writer, context);
    (*output)->main_frame_frame_token.Set(
        main_frame_frame_token_writer.is_null() ? nullptr : main_frame_frame_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->main_frame_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_frame_frame_token in CreateNewWindowReply struct");
    (*output)->main_frame_widget_route_id = Traits::main_frame_widget_route_id(input);
    decltype(Traits::visual_properties(input)) in_visual_properties = Traits::visual_properties(input);
    typename decltype((*output)->visual_properties)::BaseType::BufferWriter
        visual_properties_writer;
    mojo::internal::Serialize<::blink::mojom::VisualPropertiesDataView>(
        in_visual_properties, buffer, &visual_properties_writer, context);
    (*output)->visual_properties.Set(
        visual_properties_writer.is_null() ? nullptr : visual_properties_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->visual_properties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visual_properties in CreateNewWindowReply struct");
    decltype(Traits::frame_widget_host(input)) in_frame_widget_host = Traits::frame_widget_host(input);
    mojo::internal::Serialize<::blink::mojom::FrameWidgetHostAssociatedPtrInfoDataView>(
        in_frame_widget_host, &(*output)->frame_widget_host, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->frame_widget_host),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame_widget_host in CreateNewWindowReply struct");
    decltype(Traits::frame_widget(input)) in_frame_widget = Traits::frame_widget(input);
    mojo::internal::Serialize<::blink::mojom::FrameWidgetAssociatedRequestDataView>(
        in_frame_widget, &(*output)->frame_widget, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->frame_widget),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame_widget in CreateNewWindowReply struct");
    decltype(Traits::widget_host(input)) in_widget_host = Traits::widget_host(input);
    mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedPtrInfoDataView>(
        in_widget_host, &(*output)->widget_host, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->widget_host),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid widget_host in CreateNewWindowReply struct");
    decltype(Traits::widget(input)) in_widget = Traits::widget(input);
    mojo::internal::Serialize<::blink::mojom::WidgetAssociatedRequestDataView>(
        in_widget, &(*output)->widget, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->widget),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid widget in CreateNewWindowReply struct");
    decltype(Traits::page_broadcast(input)) in_page_broadcast = Traits::page_broadcast(input);
    mojo::internal::Serialize<::blink::mojom::PageBroadcastAssociatedRequestDataView>(
        in_page_broadcast, &(*output)->page_broadcast, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->page_broadcast),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid page_broadcast in CreateNewWindowReply struct");
    decltype(Traits::main_frame_interface_bundle(input)) in_main_frame_interface_bundle = Traits::main_frame_interface_bundle(input);
    typename decltype((*output)->main_frame_interface_bundle)::BaseType::BufferWriter
        main_frame_interface_bundle_writer;
    mojo::internal::Serialize<::content::mojom::DocumentScopedInterfaceBundleDataView>(
        in_main_frame_interface_bundle, buffer, &main_frame_interface_bundle_writer, context);
    (*output)->main_frame_interface_bundle.Set(
        main_frame_interface_bundle_writer.is_null() ? nullptr : main_frame_interface_bundle_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->main_frame_interface_bundle.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_frame_interface_bundle in CreateNewWindowReply struct");
    decltype(Traits::cloned_session_storage_namespace_id(input)) in_cloned_session_storage_namespace_id = Traits::cloned_session_storage_namespace_id(input);
    typename decltype((*output)->cloned_session_storage_namespace_id)::BaseType::BufferWriter
        cloned_session_storage_namespace_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_cloned_session_storage_namespace_id, buffer, &cloned_session_storage_namespace_id_writer, context);
    (*output)->cloned_session_storage_namespace_id.Set(
        cloned_session_storage_namespace_id_writer.is_null() ? nullptr : cloned_session_storage_namespace_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cloned_session_storage_namespace_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cloned_session_storage_namespace_id in CreateNewWindowReply struct");
    decltype(Traits::devtools_main_frame_token(input)) in_devtools_main_frame_token = Traits::devtools_main_frame_token(input);
    typename decltype((*output)->devtools_main_frame_token)::BaseType::BufferWriter
        devtools_main_frame_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_devtools_main_frame_token, buffer, &devtools_main_frame_token_writer, context);
    (*output)->devtools_main_frame_token.Set(
        devtools_main_frame_token_writer.is_null() ? nullptr : devtools_main_frame_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->devtools_main_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_main_frame_token in CreateNewWindowReply struct");
    (*output)->wait_for_debugger = Traits::wait_for_debugger(input);
  }

  static bool Deserialize(::content::mojom::internal::CreateNewWindowReply_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateNewWindowReplyDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::OpenURLParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::OpenURLParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::OpenURLParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in OpenURLParams struct");
    decltype(Traits::initiator_origin(input)) in_initiator_origin = Traits::initiator_origin(input);
    typename decltype((*output)->initiator_origin)::BaseType::BufferWriter
        initiator_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_initiator_origin, buffer, &initiator_origin_writer, context);
    (*output)->initiator_origin.Set(
        initiator_origin_writer.is_null() ? nullptr : initiator_origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->initiator_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null initiator_origin in OpenURLParams struct");
    (*output)->initiator_routing_id = Traits::initiator_routing_id(input);
    decltype(Traits::post_body(input)) in_post_body = Traits::post_body(input);
    typename decltype((*output)->post_body)::BaseType::BufferWriter
        post_body_writer;
    mojo::internal::Serialize<::network::mojom::URLRequestBodyDataView>(
        in_post_body, buffer, &post_body_writer, context);
    (*output)->post_body.Set(
        post_body_writer.is_null() ? nullptr : post_body_writer.data());
    decltype(Traits::extra_headers(input)) in_extra_headers = Traits::extra_headers(input);
    typename decltype((*output)->extra_headers)::BaseType::BufferWriter
        extra_headers_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_extra_headers, buffer, &extra_headers_writer, context);
    (*output)->extra_headers.Set(
        extra_headers_writer.is_null() ? nullptr : extra_headers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->extra_headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extra_headers in OpenURLParams struct");
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    typename decltype((*output)->referrer)::BaseType::BufferWriter
        referrer_writer;
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, buffer, &referrer_writer, context);
    (*output)->referrer.Set(
        referrer_writer.is_null() ? nullptr : referrer_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in OpenURLParams struct");
    mojo::internal::Serialize<::ui::mojom::WindowOpenDisposition>(
        Traits::disposition(input), &(*output)->disposition);
    (*output)->should_replace_current_entry = Traits::should_replace_current_entry(input);
    (*output)->user_gesture = Traits::user_gesture(input);
    mojo::internal::Serialize<::content::mojom::TriggeringEventInfo>(
        Traits::triggering_event_info(input), &(*output)->triggering_event_info);
    decltype(Traits::blob_url_token(input)) in_blob_url_token = Traits::blob_url_token(input);
    mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
        in_blob_url_token, &(*output)->blob_url_token, context);
    decltype(Traits::href_translate(input)) in_href_translate = Traits::href_translate(input);
    typename decltype((*output)->href_translate)::BaseType::BufferWriter
        href_translate_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_href_translate, buffer, &href_translate_writer, context);
    (*output)->href_translate.Set(
        href_translate_writer.is_null() ? nullptr : href_translate_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->href_translate.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null href_translate in OpenURLParams struct");
    decltype(Traits::impression(input)) in_impression = Traits::impression(input);
    typename decltype((*output)->impression)::BaseType::BufferWriter
        impression_writer;
    mojo::internal::Serialize<::content::mojom::ImpressionDataView>(
        in_impression, buffer, &impression_writer, context);
    (*output)->impression.Set(
        impression_writer.is_null() ? nullptr : impression_writer.data());
    decltype(Traits::download_policy(input)) in_download_policy = Traits::download_policy(input);
    typename decltype((*output)->download_policy)::BaseType::BufferWriter
        download_policy_writer;
    mojo::internal::Serialize<::content::mojom::NavigationDownloadPolicyDataView>(
        in_download_policy, buffer, &download_policy_writer, context);
    (*output)->download_policy.Set(
        download_policy_writer.is_null() ? nullptr : download_policy_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->download_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null download_policy in OpenURLParams struct");
  }

  static bool Deserialize(::content::mojom::internal::OpenURLParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::OpenURLParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {

inline void CreateNewWindowParamsDataView::GetSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CreateNewWindowParamsDataView::GetCloneFromSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->clone_from_session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CreateNewWindowParamsDataView::GetFrameNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->frame_name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CreateNewWindowParamsDataView::GetTargetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->target_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void CreateNewWindowParamsDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, context_);
}
inline void CreateNewWindowParamsDataView::GetFeaturesDataView(
    ::blink::mojom::WindowFeaturesDataView* output) {
  auto pointer = data_->features.Get();
  *output = ::blink::mojom::WindowFeaturesDataView(pointer, context_);
}


inline void CreateNewWindowReplyDataView::GetMainFrameFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->main_frame_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void CreateNewWindowReplyDataView::GetVisualPropertiesDataView(
    ::blink::mojom::VisualPropertiesDataView* output) {
  auto pointer = data_->visual_properties.Get();
  *output = ::blink::mojom::VisualPropertiesDataView(pointer, context_);
}
inline void CreateNewWindowReplyDataView::GetMainFrameInterfaceBundleDataView(
    ::content::mojom::DocumentScopedInterfaceBundleDataView* output) {
  auto pointer = data_->main_frame_interface_bundle.Get();
  *output = ::content::mojom::DocumentScopedInterfaceBundleDataView(pointer, context_);
}
inline void CreateNewWindowReplyDataView::GetClonedSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cloned_session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CreateNewWindowReplyDataView::GetDevtoolsMainFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_main_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void OpenURLParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void OpenURLParamsDataView::GetInitiatorOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->initiator_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void OpenURLParamsDataView::GetPostBodyDataView(
    ::network::mojom::URLRequestBodyDataView* output) {
  auto pointer = data_->post_body.Get();
  *output = ::network::mojom::URLRequestBodyDataView(pointer, context_);
}
inline void OpenURLParamsDataView::GetExtraHeadersDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->extra_headers.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void OpenURLParamsDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, context_);
}
inline void OpenURLParamsDataView::GetHrefTranslateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->href_translate.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void OpenURLParamsDataView::GetImpressionDataView(
    ::content::mojom::ImpressionDataView* output) {
  auto pointer = data_->impression.Get();
  *output = ::content::mojom::ImpressionDataView(pointer, context_);
}
inline void OpenURLParamsDataView::GetDownloadPolicyDataView(
    ::content::mojom::NavigationDownloadPolicyDataView* output) {
  auto pointer = data_->download_policy.Get();
  *output = ::content::mojom::NavigationDownloadPolicyDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_FRAME_MOJOM_SHARED_H_