// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Security_h
#define content_protocol_Security_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace Security {
using CertificateId = int;
using MixedContentType = String;
using SecurityState = String;
class CertificateSecurityState;
using SafetyTipStatus = String;
class SafetyTipInfo;
class VisibleSecurityState;
class SecurityStateExplanation;
class InsecureContentStatus;
using CertificateErrorAction = String;

// ------------- Forward and enum declarations.

namespace MixedContentTypeEnum {
CONTENT_EXPORT extern const char Blockable[];
CONTENT_EXPORT extern const char OptionallyBlockable[];
CONTENT_EXPORT extern const char None[];
} // namespace MixedContentTypeEnum

namespace SecurityStateEnum {
CONTENT_EXPORT extern const char Unknown[];
CONTENT_EXPORT extern const char Neutral[];
CONTENT_EXPORT extern const char Insecure[];
CONTENT_EXPORT extern const char Secure[];
CONTENT_EXPORT extern const char Info[];
CONTENT_EXPORT extern const char InsecureBroken[];
} // namespace SecurityStateEnum

namespace SafetyTipStatusEnum {
CONTENT_EXPORT extern const char BadReputation[];
CONTENT_EXPORT extern const char Lookalike[];
} // namespace SafetyTipStatusEnum

namespace CertificateErrorActionEnum {
CONTENT_EXPORT extern const char Continue[];
CONTENT_EXPORT extern const char Cancel[];
} // namespace CertificateErrorActionEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT CertificateSecurityState : public ::crdtp::ProtocolObject<CertificateSecurityState> {
public:
    ~CertificateSecurityState() override { }

    String GetProtocol() { return m_protocol; }
    void SetProtocol(const String& value) { m_protocol = value; }

    String GetKeyExchange() { return m_keyExchange; }
    void SetKeyExchange(const String& value) { m_keyExchange = value; }

    bool HasKeyExchangeGroup() { return m_keyExchangeGroup.isJust(); }
    String GetKeyExchangeGroup(const String& defaultValue) { return m_keyExchangeGroup.isJust() ? m_keyExchangeGroup.fromJust() : defaultValue; }
    void SetKeyExchangeGroup(const String& value) { m_keyExchangeGroup = value; }

    String GetCipher() { return m_cipher; }
    void SetCipher(const String& value) { m_cipher = value; }

    bool HasMac() { return m_mac.isJust(); }
    String GetMac(const String& defaultValue) { return m_mac.isJust() ? m_mac.fromJust() : defaultValue; }
    void SetMac(const String& value) { m_mac = value; }

    protocol::Array<String>* GetCertificate() { return m_certificate.get(); }
    void SetCertificate(std::unique_ptr<protocol::Array<String>> value) { m_certificate = std::move(value); }

    String GetSubjectName() { return m_subjectName; }
    void SetSubjectName(const String& value) { m_subjectName = value; }

    String GetIssuer() { return m_issuer; }
    void SetIssuer(const String& value) { m_issuer = value; }

    double GetValidFrom() { return m_validFrom; }
    void SetValidFrom(double value) { m_validFrom = value; }

    double GetValidTo() { return m_validTo; }
    void SetValidTo(double value) { m_validTo = value; }

    bool HasCertificateNetworkError() { return m_certificateNetworkError.isJust(); }
    String GetCertificateNetworkError(const String& defaultValue) { return m_certificateNetworkError.isJust() ? m_certificateNetworkError.fromJust() : defaultValue; }
    void SetCertificateNetworkError(const String& value) { m_certificateNetworkError = value; }

    bool GetCertificateHasWeakSignature() { return m_certificateHasWeakSignature; }
    void SetCertificateHasWeakSignature(bool value) { m_certificateHasWeakSignature = value; }

    bool GetCertificateHasSha1Signature() { return m_certificateHasSha1Signature; }
    void SetCertificateHasSha1Signature(bool value) { m_certificateHasSha1Signature = value; }

    bool GetModernSSL() { return m_modernSSL; }
    void SetModernSSL(bool value) { m_modernSSL = value; }

    bool GetObsoleteSslProtocol() { return m_obsoleteSslProtocol; }
    void SetObsoleteSslProtocol(bool value) { m_obsoleteSslProtocol = value; }

    bool GetObsoleteSslKeyExchange() { return m_obsoleteSslKeyExchange; }
    void SetObsoleteSslKeyExchange(bool value) { m_obsoleteSslKeyExchange = value; }

    bool GetObsoleteSslCipher() { return m_obsoleteSslCipher; }
    void SetObsoleteSslCipher(bool value) { m_obsoleteSslCipher = value; }

    bool GetObsoleteSslSignature() { return m_obsoleteSslSignature; }
    void SetObsoleteSslSignature(bool value) { m_obsoleteSslSignature = value; }

    template<int STATE>
    class CertificateSecurityStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProtocolSet = 1 << 1,
            KeyExchangeSet = 1 << 2,
            CipherSet = 1 << 3,
            CertificateSet = 1 << 4,
            SubjectNameSet = 1 << 5,
            IssuerSet = 1 << 6,
            ValidFromSet = 1 << 7,
            ValidToSet = 1 << 8,
            CertificateHasWeakSignatureSet = 1 << 9,
            CertificateHasSha1SignatureSet = 1 << 10,
            ModernSSLSet = 1 << 11,
            ObsoleteSslProtocolSet = 1 << 12,
            ObsoleteSslKeyExchangeSet = 1 << 13,
            ObsoleteSslCipherSet = 1 << 14,
            ObsoleteSslSignatureSet = 1 << 15,
            AllFieldsSet = (ProtocolSet | KeyExchangeSet | CipherSet | CertificateSet | SubjectNameSet | IssuerSet | ValidFromSet | ValidToSet | CertificateHasWeakSignatureSet | CertificateHasSha1SignatureSet | ModernSSLSet | ObsoleteSslProtocolSet | ObsoleteSslKeyExchangeSet | ObsoleteSslCipherSet | ObsoleteSslSignatureSet | 0)};


        CertificateSecurityStateBuilder<STATE | ProtocolSet>& SetProtocol(const String& value)
        {
            static_assert(!(STATE & ProtocolSet), "property protocol should not be set yet");
            m_result->SetProtocol(value);
            return castState<ProtocolSet>();
        }

        CertificateSecurityStateBuilder<STATE | KeyExchangeSet>& SetKeyExchange(const String& value)
        {
            static_assert(!(STATE & KeyExchangeSet), "property keyExchange should not be set yet");
            m_result->SetKeyExchange(value);
            return castState<KeyExchangeSet>();
        }

        CertificateSecurityStateBuilder<STATE>& SetKeyExchangeGroup(const String& value)
        {
            m_result->SetKeyExchangeGroup(value);
            return *this;
        }

        CertificateSecurityStateBuilder<STATE | CipherSet>& SetCipher(const String& value)
        {
            static_assert(!(STATE & CipherSet), "property cipher should not be set yet");
            m_result->SetCipher(value);
            return castState<CipherSet>();
        }

        CertificateSecurityStateBuilder<STATE>& SetMac(const String& value)
        {
            m_result->SetMac(value);
            return *this;
        }

        CertificateSecurityStateBuilder<STATE | CertificateSet>& SetCertificate(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & CertificateSet), "property certificate should not be set yet");
            m_result->SetCertificate(std::move(value));
            return castState<CertificateSet>();
        }

        CertificateSecurityStateBuilder<STATE | SubjectNameSet>& SetSubjectName(const String& value)
        {
            static_assert(!(STATE & SubjectNameSet), "property subjectName should not be set yet");
            m_result->SetSubjectName(value);
            return castState<SubjectNameSet>();
        }

        CertificateSecurityStateBuilder<STATE | IssuerSet>& SetIssuer(const String& value)
        {
            static_assert(!(STATE & IssuerSet), "property issuer should not be set yet");
            m_result->SetIssuer(value);
            return castState<IssuerSet>();
        }

        CertificateSecurityStateBuilder<STATE | ValidFromSet>& SetValidFrom(double value)
        {
            static_assert(!(STATE & ValidFromSet), "property validFrom should not be set yet");
            m_result->SetValidFrom(value);
            return castState<ValidFromSet>();
        }

        CertificateSecurityStateBuilder<STATE | ValidToSet>& SetValidTo(double value)
        {
            static_assert(!(STATE & ValidToSet), "property validTo should not be set yet");
            m_result->SetValidTo(value);
            return castState<ValidToSet>();
        }

        CertificateSecurityStateBuilder<STATE>& SetCertificateNetworkError(const String& value)
        {
            m_result->SetCertificateNetworkError(value);
            return *this;
        }

        CertificateSecurityStateBuilder<STATE | CertificateHasWeakSignatureSet>& SetCertificateHasWeakSignature(bool value)
        {
            static_assert(!(STATE & CertificateHasWeakSignatureSet), "property certificateHasWeakSignature should not be set yet");
            m_result->SetCertificateHasWeakSignature(value);
            return castState<CertificateHasWeakSignatureSet>();
        }

        CertificateSecurityStateBuilder<STATE | CertificateHasSha1SignatureSet>& SetCertificateHasSha1Signature(bool value)
        {
            static_assert(!(STATE & CertificateHasSha1SignatureSet), "property certificateHasSha1Signature should not be set yet");
            m_result->SetCertificateHasSha1Signature(value);
            return castState<CertificateHasSha1SignatureSet>();
        }

        CertificateSecurityStateBuilder<STATE | ModernSSLSet>& SetModernSSL(bool value)
        {
            static_assert(!(STATE & ModernSSLSet), "property modernSSL should not be set yet");
            m_result->SetModernSSL(value);
            return castState<ModernSSLSet>();
        }

        CertificateSecurityStateBuilder<STATE | ObsoleteSslProtocolSet>& SetObsoleteSslProtocol(bool value)
        {
            static_assert(!(STATE & ObsoleteSslProtocolSet), "property obsoleteSslProtocol should not be set yet");
            m_result->SetObsoleteSslProtocol(value);
            return castState<ObsoleteSslProtocolSet>();
        }

        CertificateSecurityStateBuilder<STATE | ObsoleteSslKeyExchangeSet>& SetObsoleteSslKeyExchange(bool value)
        {
            static_assert(!(STATE & ObsoleteSslKeyExchangeSet), "property obsoleteSslKeyExchange should not be set yet");
            m_result->SetObsoleteSslKeyExchange(value);
            return castState<ObsoleteSslKeyExchangeSet>();
        }

        CertificateSecurityStateBuilder<STATE | ObsoleteSslCipherSet>& SetObsoleteSslCipher(bool value)
        {
            static_assert(!(STATE & ObsoleteSslCipherSet), "property obsoleteSslCipher should not be set yet");
            m_result->SetObsoleteSslCipher(value);
            return castState<ObsoleteSslCipherSet>();
        }

        CertificateSecurityStateBuilder<STATE | ObsoleteSslSignatureSet>& SetObsoleteSslSignature(bool value)
        {
            static_assert(!(STATE & ObsoleteSslSignatureSet), "property obsoleteSslSignature should not be set yet");
            m_result->SetObsoleteSslSignature(value);
            return castState<ObsoleteSslSignatureSet>();
        }

        std::unique_ptr<CertificateSecurityState> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CertificateSecurityState;
        CertificateSecurityStateBuilder() : m_result(new CertificateSecurityState()) { }

        template<int STEP> CertificateSecurityStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CertificateSecurityStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::CertificateSecurityState> m_result;
    };

    static CertificateSecurityStateBuilder<0> Create()
    {
        return CertificateSecurityStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CertificateSecurityState()
    {
          m_validFrom = 0;
          m_validTo = 0;
          m_certificateHasWeakSignature = false;
          m_certificateHasSha1Signature = false;
          m_modernSSL = false;
          m_obsoleteSslProtocol = false;
          m_obsoleteSslKeyExchange = false;
          m_obsoleteSslCipher = false;
          m_obsoleteSslSignature = false;
    }

    String m_protocol;
    String m_keyExchange;
    Maybe<String> m_keyExchangeGroup;
    String m_cipher;
    Maybe<String> m_mac;
    std::unique_ptr<protocol::Array<String>> m_certificate;
    String m_subjectName;
    String m_issuer;
    double m_validFrom;
    double m_validTo;
    Maybe<String> m_certificateNetworkError;
    bool m_certificateHasWeakSignature;
    bool m_certificateHasSha1Signature;
    bool m_modernSSL;
    bool m_obsoleteSslProtocol;
    bool m_obsoleteSslKeyExchange;
    bool m_obsoleteSslCipher;
    bool m_obsoleteSslSignature;
};


class CONTENT_EXPORT SafetyTipInfo : public ::crdtp::ProtocolObject<SafetyTipInfo> {
public:
    ~SafetyTipInfo() override { }

    String GetSafetyTipStatus() { return m_safetyTipStatus; }
    void SetSafetyTipStatus(const String& value) { m_safetyTipStatus = value; }

    bool HasSafeUrl() { return m_safeUrl.isJust(); }
    String GetSafeUrl(const String& defaultValue) { return m_safeUrl.isJust() ? m_safeUrl.fromJust() : defaultValue; }
    void SetSafeUrl(const String& value) { m_safeUrl = value; }

    template<int STATE>
    class SafetyTipInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SafetyTipStatusSet = 1 << 1,
            AllFieldsSet = (SafetyTipStatusSet | 0)};


        SafetyTipInfoBuilder<STATE | SafetyTipStatusSet>& SetSafetyTipStatus(const String& value)
        {
            static_assert(!(STATE & SafetyTipStatusSet), "property safetyTipStatus should not be set yet");
            m_result->SetSafetyTipStatus(value);
            return castState<SafetyTipStatusSet>();
        }

        SafetyTipInfoBuilder<STATE>& SetSafeUrl(const String& value)
        {
            m_result->SetSafeUrl(value);
            return *this;
        }

        std::unique_ptr<SafetyTipInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SafetyTipInfo;
        SafetyTipInfoBuilder() : m_result(new SafetyTipInfo()) { }

        template<int STEP> SafetyTipInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SafetyTipInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::SafetyTipInfo> m_result;
    };

    static SafetyTipInfoBuilder<0> Create()
    {
        return SafetyTipInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SafetyTipInfo()
    {
    }

    String m_safetyTipStatus;
    Maybe<String> m_safeUrl;
};


class CONTENT_EXPORT VisibleSecurityState : public ::crdtp::ProtocolObject<VisibleSecurityState> {
public:
    ~VisibleSecurityState() override { }

    String GetSecurityState() { return m_securityState; }
    void SetSecurityState(const String& value) { m_securityState = value; }

    bool HasCertificateSecurityState() { return m_certificateSecurityState.isJust(); }
    protocol::Security::CertificateSecurityState* GetCertificateSecurityState(protocol::Security::CertificateSecurityState* defaultValue) { return m_certificateSecurityState.isJust() ? m_certificateSecurityState.fromJust() : defaultValue; }
    void SetCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value) { m_certificateSecurityState = std::move(value); }

    bool HasSafetyTipInfo() { return m_safetyTipInfo.isJust(); }
    protocol::Security::SafetyTipInfo* GetSafetyTipInfo(protocol::Security::SafetyTipInfo* defaultValue) { return m_safetyTipInfo.isJust() ? m_safetyTipInfo.fromJust() : defaultValue; }
    void SetSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value) { m_safetyTipInfo = std::move(value); }

    protocol::Array<String>* GetSecurityStateIssueIds() { return m_securityStateIssueIds.get(); }
    void SetSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value) { m_securityStateIssueIds = std::move(value); }

    template<int STATE>
    class VisibleSecurityStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SecurityStateSet = 1 << 1,
            SecurityStateIssueIdsSet = 1 << 2,
            AllFieldsSet = (SecurityStateSet | SecurityStateIssueIdsSet | 0)};


        VisibleSecurityStateBuilder<STATE | SecurityStateSet>& SetSecurityState(const String& value)
        {
            static_assert(!(STATE & SecurityStateSet), "property securityState should not be set yet");
            m_result->SetSecurityState(value);
            return castState<SecurityStateSet>();
        }

        VisibleSecurityStateBuilder<STATE>& SetCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value)
        {
            m_result->SetCertificateSecurityState(std::move(value));
            return *this;
        }

        VisibleSecurityStateBuilder<STATE>& SetSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value)
        {
            m_result->SetSafetyTipInfo(std::move(value));
            return *this;
        }

        VisibleSecurityStateBuilder<STATE | SecurityStateIssueIdsSet>& SetSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & SecurityStateIssueIdsSet), "property securityStateIssueIds should not be set yet");
            m_result->SetSecurityStateIssueIds(std::move(value));
            return castState<SecurityStateIssueIdsSet>();
        }

        std::unique_ptr<VisibleSecurityState> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VisibleSecurityState;
        VisibleSecurityStateBuilder() : m_result(new VisibleSecurityState()) { }

        template<int STEP> VisibleSecurityStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VisibleSecurityStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::VisibleSecurityState> m_result;
    };

    static VisibleSecurityStateBuilder<0> Create()
    {
        return VisibleSecurityStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VisibleSecurityState()
    {
    }

    String m_securityState;
    Maybe<protocol::Security::CertificateSecurityState> m_certificateSecurityState;
    Maybe<protocol::Security::SafetyTipInfo> m_safetyTipInfo;
    std::unique_ptr<protocol::Array<String>> m_securityStateIssueIds;
};


class CONTENT_EXPORT SecurityStateExplanation : public ::crdtp::ProtocolObject<SecurityStateExplanation> {
public:
    ~SecurityStateExplanation() override { }

    String GetSecurityState() { return m_securityState; }
    void SetSecurityState(const String& value) { m_securityState = value; }

    String GetTitle() { return m_title; }
    void SetTitle(const String& value) { m_title = value; }

    String GetSummary() { return m_summary; }
    void SetSummary(const String& value) { m_summary = value; }

    String GetDescription() { return m_description; }
    void SetDescription(const String& value) { m_description = value; }

    String GetMixedContentType() { return m_mixedContentType; }
    void SetMixedContentType(const String& value) { m_mixedContentType = value; }

    protocol::Array<String>* GetCertificate() { return m_certificate.get(); }
    void SetCertificate(std::unique_ptr<protocol::Array<String>> value) { m_certificate = std::move(value); }

    bool HasRecommendations() { return m_recommendations.isJust(); }
    protocol::Array<String>* GetRecommendations(protocol::Array<String>* defaultValue) { return m_recommendations.isJust() ? m_recommendations.fromJust() : defaultValue; }
    void SetRecommendations(std::unique_ptr<protocol::Array<String>> value) { m_recommendations = std::move(value); }

    template<int STATE>
    class SecurityStateExplanationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SecurityStateSet = 1 << 1,
            TitleSet = 1 << 2,
            SummarySet = 1 << 3,
            DescriptionSet = 1 << 4,
            MixedContentTypeSet = 1 << 5,
            CertificateSet = 1 << 6,
            AllFieldsSet = (SecurityStateSet | TitleSet | SummarySet | DescriptionSet | MixedContentTypeSet | CertificateSet | 0)};


        SecurityStateExplanationBuilder<STATE | SecurityStateSet>& SetSecurityState(const String& value)
        {
            static_assert(!(STATE & SecurityStateSet), "property securityState should not be set yet");
            m_result->SetSecurityState(value);
            return castState<SecurityStateSet>();
        }

        SecurityStateExplanationBuilder<STATE | TitleSet>& SetTitle(const String& value)
        {
            static_assert(!(STATE & TitleSet), "property title should not be set yet");
            m_result->SetTitle(value);
            return castState<TitleSet>();
        }

        SecurityStateExplanationBuilder<STATE | SummarySet>& SetSummary(const String& value)
        {
            static_assert(!(STATE & SummarySet), "property summary should not be set yet");
            m_result->SetSummary(value);
            return castState<SummarySet>();
        }

        SecurityStateExplanationBuilder<STATE | DescriptionSet>& SetDescription(const String& value)
        {
            static_assert(!(STATE & DescriptionSet), "property description should not be set yet");
            m_result->SetDescription(value);
            return castState<DescriptionSet>();
        }

        SecurityStateExplanationBuilder<STATE | MixedContentTypeSet>& SetMixedContentType(const String& value)
        {
            static_assert(!(STATE & MixedContentTypeSet), "property mixedContentType should not be set yet");
            m_result->SetMixedContentType(value);
            return castState<MixedContentTypeSet>();
        }

        SecurityStateExplanationBuilder<STATE | CertificateSet>& SetCertificate(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & CertificateSet), "property certificate should not be set yet");
            m_result->SetCertificate(std::move(value));
            return castState<CertificateSet>();
        }

        SecurityStateExplanationBuilder<STATE>& SetRecommendations(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->SetRecommendations(std::move(value));
            return *this;
        }

        std::unique_ptr<SecurityStateExplanation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SecurityStateExplanation;
        SecurityStateExplanationBuilder() : m_result(new SecurityStateExplanation()) { }

        template<int STEP> SecurityStateExplanationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SecurityStateExplanationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::SecurityStateExplanation> m_result;
    };

    static SecurityStateExplanationBuilder<0> Create()
    {
        return SecurityStateExplanationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SecurityStateExplanation()
    {
    }

    String m_securityState;
    String m_title;
    String m_summary;
    String m_description;
    String m_mixedContentType;
    std::unique_ptr<protocol::Array<String>> m_certificate;
    Maybe<protocol::Array<String>> m_recommendations;
};


class CONTENT_EXPORT InsecureContentStatus : public ::crdtp::ProtocolObject<InsecureContentStatus> {
public:
    ~InsecureContentStatus() override { }

    bool GetRanMixedContent() { return m_ranMixedContent; }
    void SetRanMixedContent(bool value) { m_ranMixedContent = value; }

    bool GetDisplayedMixedContent() { return m_displayedMixedContent; }
    void SetDisplayedMixedContent(bool value) { m_displayedMixedContent = value; }

    bool GetContainedMixedForm() { return m_containedMixedForm; }
    void SetContainedMixedForm(bool value) { m_containedMixedForm = value; }

    bool GetRanContentWithCertErrors() { return m_ranContentWithCertErrors; }
    void SetRanContentWithCertErrors(bool value) { m_ranContentWithCertErrors = value; }

    bool GetDisplayedContentWithCertErrors() { return m_displayedContentWithCertErrors; }
    void SetDisplayedContentWithCertErrors(bool value) { m_displayedContentWithCertErrors = value; }

    String GetRanInsecureContentStyle() { return m_ranInsecureContentStyle; }
    void SetRanInsecureContentStyle(const String& value) { m_ranInsecureContentStyle = value; }

    String GetDisplayedInsecureContentStyle() { return m_displayedInsecureContentStyle; }
    void SetDisplayedInsecureContentStyle(const String& value) { m_displayedInsecureContentStyle = value; }

    template<int STATE>
    class InsecureContentStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RanMixedContentSet = 1 << 1,
            DisplayedMixedContentSet = 1 << 2,
            ContainedMixedFormSet = 1 << 3,
            RanContentWithCertErrorsSet = 1 << 4,
            DisplayedContentWithCertErrorsSet = 1 << 5,
            RanInsecureContentStyleSet = 1 << 6,
            DisplayedInsecureContentStyleSet = 1 << 7,
            AllFieldsSet = (RanMixedContentSet | DisplayedMixedContentSet | ContainedMixedFormSet | RanContentWithCertErrorsSet | DisplayedContentWithCertErrorsSet | RanInsecureContentStyleSet | DisplayedInsecureContentStyleSet | 0)};


        InsecureContentStatusBuilder<STATE | RanMixedContentSet>& SetRanMixedContent(bool value)
        {
            static_assert(!(STATE & RanMixedContentSet), "property ranMixedContent should not be set yet");
            m_result->SetRanMixedContent(value);
            return castState<RanMixedContentSet>();
        }

        InsecureContentStatusBuilder<STATE | DisplayedMixedContentSet>& SetDisplayedMixedContent(bool value)
        {
            static_assert(!(STATE & DisplayedMixedContentSet), "property displayedMixedContent should not be set yet");
            m_result->SetDisplayedMixedContent(value);
            return castState<DisplayedMixedContentSet>();
        }

        InsecureContentStatusBuilder<STATE | ContainedMixedFormSet>& SetContainedMixedForm(bool value)
        {
            static_assert(!(STATE & ContainedMixedFormSet), "property containedMixedForm should not be set yet");
            m_result->SetContainedMixedForm(value);
            return castState<ContainedMixedFormSet>();
        }

        InsecureContentStatusBuilder<STATE | RanContentWithCertErrorsSet>& SetRanContentWithCertErrors(bool value)
        {
            static_assert(!(STATE & RanContentWithCertErrorsSet), "property ranContentWithCertErrors should not be set yet");
            m_result->SetRanContentWithCertErrors(value);
            return castState<RanContentWithCertErrorsSet>();
        }

        InsecureContentStatusBuilder<STATE | DisplayedContentWithCertErrorsSet>& SetDisplayedContentWithCertErrors(bool value)
        {
            static_assert(!(STATE & DisplayedContentWithCertErrorsSet), "property displayedContentWithCertErrors should not be set yet");
            m_result->SetDisplayedContentWithCertErrors(value);
            return castState<DisplayedContentWithCertErrorsSet>();
        }

        InsecureContentStatusBuilder<STATE | RanInsecureContentStyleSet>& SetRanInsecureContentStyle(const String& value)
        {
            static_assert(!(STATE & RanInsecureContentStyleSet), "property ranInsecureContentStyle should not be set yet");
            m_result->SetRanInsecureContentStyle(value);
            return castState<RanInsecureContentStyleSet>();
        }

        InsecureContentStatusBuilder<STATE | DisplayedInsecureContentStyleSet>& SetDisplayedInsecureContentStyle(const String& value)
        {
            static_assert(!(STATE & DisplayedInsecureContentStyleSet), "property displayedInsecureContentStyle should not be set yet");
            m_result->SetDisplayedInsecureContentStyle(value);
            return castState<DisplayedInsecureContentStyleSet>();
        }

        std::unique_ptr<InsecureContentStatus> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InsecureContentStatus;
        InsecureContentStatusBuilder() : m_result(new InsecureContentStatus()) { }

        template<int STEP> InsecureContentStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InsecureContentStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::InsecureContentStatus> m_result;
    };

    static InsecureContentStatusBuilder<0> Create()
    {
        return InsecureContentStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InsecureContentStatus()
    {
          m_ranMixedContent = false;
          m_displayedMixedContent = false;
          m_containedMixedForm = false;
          m_ranContentWithCertErrors = false;
          m_displayedContentWithCertErrors = false;
    }

    bool m_ranMixedContent;
    bool m_displayedMixedContent;
    bool m_containedMixedForm;
    bool m_ranContentWithCertErrors;
    bool m_displayedContentWithCertErrors;
    String m_ranInsecureContentStyle;
    String m_displayedInsecureContentStyle;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable() = 0;
    virtual DispatchResponse SetIgnoreCertificateErrors(bool in_ignore) = 0;
    virtual DispatchResponse HandleCertificateError(int in_eventId, const String& in_action) = 0;
    virtual DispatchResponse SetOverrideCertificateErrors(bool in_override) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void CertificateError(int eventId, const String& errorType, const String& requestURL);
    void VisibleSecurityStateChanged(std::unique_ptr<protocol::Security::VisibleSecurityState> visibleSecurityState);
    void SecurityStateChanged(const String& securityState, bool schemeIsCryptographic, std::unique_ptr<protocol::Array<protocol::Security::SecurityStateExplanation>> explanations, std::unique_ptr<protocol::Security::InsecureContentStatus> insecureContentStatus, Maybe<String> summary = Maybe<String>());

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Security
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Security_h)
