// components/spellcheck/common/spellcheck.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/spellcheck/common/spellcheck.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/spellcheck/common/spellcheck.mojom-params-data.h"
#include "components/spellcheck/common/spellcheck.mojom-shared-message-ids.h"

#include "components/spellcheck/common/spellcheck.mojom-import-headers.h"


#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_JUMBO_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_JUMBO_H_
#endif
namespace spellcheck {
namespace mojom {
SpellCheckBDictLanguage::SpellCheckBDictLanguage()
    : file(),
      language() {}

SpellCheckBDictLanguage::SpellCheckBDictLanguage(
    ::base::File file_in,
    const std::string& language_in)
    : file(std::move(file_in)),
      language(std::move(language_in)) {}

SpellCheckBDictLanguage::~SpellCheckBDictLanguage() = default;

void SpellCheckBDictLanguage::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("file", base::trace_event::ValueToString(this->file, "<value of type ::base::File>"));
  value->SetString("language", this->language);
}

bool SpellCheckBDictLanguage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpellCheckResult::SpellCheckResult()
    : decoration(),
      location(),
      length(),
      replacements() {}

SpellCheckResult::SpellCheckResult(
    ::SpellCheckResult::Decoration decoration_in,
    int32_t location_in,
    int32_t length_in,
    std::vector<::base::string16> replacements_in)
    : decoration(std::move(decoration_in)),
      location(std::move(location_in)),
      length(std::move(length_in)),
      replacements(std::move(replacements_in)) {}

SpellCheckResult::~SpellCheckResult() = default;

void SpellCheckResult::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("decoration", static_cast<int>(this->decoration));
  value->SetInteger("location", this->location);
  value->SetInteger("length", this->length);
  value->BeginArray("replacements");
  for (const auto& item0 : this->replacements) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::base::string16&>"));
  }
  value->EndArray();
}

bool SpellCheckResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SpellChecker::Name_[] = "spellcheck.mojom.SpellChecker";

SpellCheckerProxy::SpellCheckerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpellCheckerProxy::Initialize(
    std::vector<SpellCheckBDictLanguagePtr> in_dictionaries, const std::vector<std::string>& in_custom_words, bool in_enable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "spellcheck::mojom::SpellChecker::Initialize", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("dictionaries");
      for (const auto& item0 : in_dictionaries) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      raw_value->BeginArray("custom_words");
      for (const auto& item0 : in_custom_words) {
        raw_value->AppendString(item0);
      }
      raw_value->EndArray();
      raw_value->SetBoolean("enable", in_enable);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpellChecker_Initialize_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::spellcheck::mojom::internal::SpellChecker_Initialize_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->dictionaries)::BaseType::BufferWriter
      dictionaries_writer;
  const mojo::internal::ContainerValidateParams dictionaries_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::spellcheck::mojom::SpellCheckBDictLanguageDataView>>(
      in_dictionaries, buffer, &dictionaries_writer, &dictionaries_validate_params,
      &serialization_context);
  params->dictionaries.Set(
      dictionaries_writer.is_null() ? nullptr : dictionaries_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->dictionaries.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dictionaries in SpellChecker.Initialize request");
  typename decltype(params->custom_words)::BaseType::BufferWriter
      custom_words_writer;
  const mojo::internal::ContainerValidateParams custom_words_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_custom_words, buffer, &custom_words_writer, &custom_words_validate_params,
      &serialization_context);
  params->custom_words.Set(
      custom_words_writer.is_null() ? nullptr : custom_words_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->custom_words.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null custom_words in SpellChecker.Initialize request");
  params->enable = in_enable;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellChecker::Name_);
  message.set_method_name("Initialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpellCheckerProxy::CustomDictionaryChanged(
    const std::vector<std::string>& in_words_added, const std::vector<std::string>& in_words_removed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "spellcheck::mojom::SpellChecker::CustomDictionaryChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("words_added");
      for (const auto& item0 : in_words_added) {
        raw_value->AppendString(item0);
      }
      raw_value->EndArray();
      raw_value->BeginArray("words_removed");
      for (const auto& item0 : in_words_removed) {
        raw_value->AppendString(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpellChecker_CustomDictionaryChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::spellcheck::mojom::internal::SpellChecker_CustomDictionaryChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->words_added)::BaseType::BufferWriter
      words_added_writer;
  const mojo::internal::ContainerValidateParams words_added_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_words_added, buffer, &words_added_writer, &words_added_validate_params,
      &serialization_context);
  params->words_added.Set(
      words_added_writer.is_null() ? nullptr : words_added_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->words_added.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null words_added in SpellChecker.CustomDictionaryChanged request");
  typename decltype(params->words_removed)::BaseType::BufferWriter
      words_removed_writer;
  const mojo::internal::ContainerValidateParams words_removed_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_words_removed, buffer, &words_removed_writer, &words_removed_validate_params,
      &serialization_context);
  params->words_removed.Set(
      words_removed_writer.is_null() ? nullptr : words_removed_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->words_removed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null words_removed in SpellChecker.CustomDictionaryChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellChecker::Name_);
  message.set_method_name("CustomDictionaryChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpellCheckerStubDispatch::Accept(
    SpellChecker* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSpellChecker_Initialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)spellcheck::mojom::SpellChecker::Initialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)spellcheck::mojom::SpellChecker::Initialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpellChecker_Initialize_Params_Data* params =
          reinterpret_cast<internal::SpellChecker_Initialize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<SpellCheckBDictLanguagePtr> p_dictionaries{};
      std::vector<std::string> p_custom_words{};
      bool p_enable{};
      SpellChecker_Initialize_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDictionaries(&p_dictionaries))
        success = false;
      if (success && !input_data_view.ReadCustomWords(&p_custom_words))
        success = false;
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellChecker::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(
std::move(p_dictionaries), 
std::move(p_custom_words), 
std::move(p_enable));
      return true;
    }
    case internal::kSpellChecker_CustomDictionaryChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)spellcheck::mojom::SpellChecker::CustomDictionaryChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)spellcheck::mojom::SpellChecker::CustomDictionaryChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpellChecker_CustomDictionaryChanged_Params_Data* params =
          reinterpret_cast<internal::SpellChecker_CustomDictionaryChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_words_added{};
      std::vector<std::string> p_words_removed{};
      SpellChecker_CustomDictionaryChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadWordsAdded(&p_words_added))
        success = false;
      if (success && !input_data_view.ReadWordsRemoved(&p_words_removed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellChecker::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CustomDictionaryChanged(
std::move(p_words_added), 
std::move(p_words_removed));
      return true;
    }
  }
  return false;
}

// static
bool SpellCheckerStubDispatch::AcceptWithResponder(
    SpellChecker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpellChecker_Initialize_Name: {
      break;
    }
    case internal::kSpellChecker_CustomDictionaryChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpellCheckerValidationInfo[] = {
    {internal::kSpellChecker_Initialize_Name,
     {&internal::SpellChecker_Initialize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpellChecker_CustomDictionaryChanged_Name,
     {&internal::SpellChecker_CustomDictionaryChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpellCheckerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::spellcheck::mojom::SpellChecker::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpellCheckerValidationInfo);
}

const char SpellCheckHost::Name_[] = "spellcheck.mojom.SpellCheckHost";

class SpellCheckHost_CallSpellingService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SpellCheckHost_CallSpellingService_ForwardToCallback(
      SpellCheckHost::CallSpellingServiceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SpellCheckHost::CallSpellingServiceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SpellCheckHost_CallSpellingService_ForwardToCallback);
};

SpellCheckHostProxy::SpellCheckHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpellCheckHostProxy::RequestDictionary(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "spellcheck::mojom::SpellCheckHost::RequestDictionary");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpellCheckHost_RequestDictionary_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::spellcheck::mojom::internal::SpellCheckHost_RequestDictionary_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckHost::Name_);
  message.set_method_name("RequestDictionary");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpellCheckHostProxy::NotifyChecked(
    const ::base::string16& in_word, bool in_misspelled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "spellcheck::mojom::SpellCheckHost::NotifyChecked", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("word", base::trace_event::ValueToString(in_word, "<value of type const ::base::string16&>"));
      raw_value->SetBoolean("misspelled", in_misspelled);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpellCheckHost_NotifyChecked_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::spellcheck::mojom::internal::SpellCheckHost_NotifyChecked_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->word)::BaseType::BufferWriter
      word_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_word, buffer, &word_writer, &serialization_context);
  params->word.Set(
      word_writer.is_null() ? nullptr : word_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->word.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null word in SpellCheckHost.NotifyChecked request");
  params->misspelled = in_misspelled;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckHost::Name_);
  message.set_method_name("NotifyChecked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpellCheckHostProxy::CallSpellingService(
    const ::base::string16& in_text, CallSpellingServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "spellcheck::mojom::SpellCheckHost::CallSpellingService", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("text", base::trace_event::ValueToString(in_text, "<value of type const ::base::string16&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpellCheckHost_CallSpellingService_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::spellcheck::mojom::internal::SpellCheckHost_CallSpellingService_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->text)::BaseType::BufferWriter
      text_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text, buffer, &text_writer, &serialization_context);
  params->text.Set(
      text_writer.is_null() ? nullptr : text_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in SpellCheckHost.CallSpellingService request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckHost::Name_);
  message.set_method_name("CallSpellingService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SpellCheckHost_CallSpellingService_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SpellCheckHost_CallSpellingService_ProxyToResponder {
 public:
  static SpellCheckHost::CallSpellingServiceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SpellCheckHost_CallSpellingService_ProxyToResponder> proxy(
        new SpellCheckHost_CallSpellingService_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SpellCheckHost_CallSpellingService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SpellCheckHost_CallSpellingService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SpellCheckHost_CallSpellingService_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SpellCheckHost::CallSpellingServiceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::vector<::SpellCheckResult>& in_results);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SpellCheckHost_CallSpellingService_ProxyToResponder);
};

bool SpellCheckHost_CallSpellingService_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "spellcheck::mojom::SpellCheckHost::CallSpellingServiceCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::SpellCheckHost_CallSpellingService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SpellCheckHost_CallSpellingService_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  std::vector<::SpellCheckResult> p_results{};
  SpellCheckHost_CallSpellingService_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SpellCheckHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_results));
  return true;
}

void SpellCheckHost_CallSpellingService_ProxyToResponder::Run(
    bool in_success, const std::vector<::SpellCheckResult>& in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)spellcheck::mojom::SpellCheckHost::CallSpellingServiceCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      raw_value->BeginArray("results");
      for (const auto& item0 : in_results) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::SpellCheckResult&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpellCheckHost_CallSpellingService_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::spellcheck::mojom::internal::SpellCheckHost_CallSpellingService_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  typename decltype(params->results)::BaseType::BufferWriter
      results_writer;
  const mojo::internal::ContainerValidateParams results_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::spellcheck::mojom::SpellCheckResultDataView>>(
      in_results, buffer, &results_writer, &results_validate_params,
      &serialization_context);
  params->results.Set(
      results_writer.is_null() ? nullptr : results_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)spellcheck::mojom::SpellCheckHost::CallSpellingServiceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpellCheckHost::Name_);
  message.set_method_name("CallSpellingService");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SpellCheckHostStubDispatch::Accept(
    SpellCheckHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSpellCheckHost_RequestDictionary_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)spellcheck::mojom::SpellCheckHost::RequestDictionary",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)spellcheck::mojom::SpellCheckHost::RequestDictionary");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpellCheckHost_RequestDictionary_Params_Data* params =
          reinterpret_cast<internal::SpellCheckHost_RequestDictionary_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpellCheckHost_RequestDictionary_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellCheckHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestDictionary();
      return true;
    }
    case internal::kSpellCheckHost_NotifyChecked_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)spellcheck::mojom::SpellCheckHost::NotifyChecked",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)spellcheck::mojom::SpellCheckHost::NotifyChecked");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpellCheckHost_NotifyChecked_Params_Data* params =
          reinterpret_cast<internal::SpellCheckHost_NotifyChecked_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_word{};
      bool p_misspelled{};
      SpellCheckHost_NotifyChecked_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadWord(&p_word))
        success = false;
      if (success)
        p_misspelled = input_data_view.misspelled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellCheckHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyChecked(
std::move(p_word), 
std::move(p_misspelled));
      return true;
    }
    case internal::kSpellCheckHost_CallSpellingService_Name: {
      break;
    }
  }
  return false;
}

// static
bool SpellCheckHostStubDispatch::AcceptWithResponder(
    SpellCheckHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpellCheckHost_RequestDictionary_Name: {
      break;
    }
    case internal::kSpellCheckHost_NotifyChecked_Name: {
      break;
    }
    case internal::kSpellCheckHost_CallSpellingService_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)spellcheck::mojom::SpellCheckHost::CallSpellingService",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)spellcheck::mojom::SpellCheckHost::CallSpellingService");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SpellCheckHost_CallSpellingService_Params_Data* params =
          reinterpret_cast<
              internal::SpellCheckHost_CallSpellingService_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_text{};
      SpellCheckHost_CallSpellingService_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpellCheckHost::Name_, 2, false);
        return false;
      }
      SpellCheckHost::CallSpellingServiceCallback callback =
          SpellCheckHost_CallSpellingService_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CallSpellingService(
std::move(p_text), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpellCheckHostValidationInfo[] = {
    {internal::kSpellCheckHost_RequestDictionary_Name,
     {&internal::SpellCheckHost_RequestDictionary_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpellCheckHost_NotifyChecked_Name,
     {&internal::SpellCheckHost_NotifyChecked_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpellCheckHost_CallSpellingService_Name,
     {&internal::SpellCheckHost_CallSpellingService_Params_Data::Validate,
      &internal::SpellCheckHost_CallSpellingService_ResponseParams_Data::Validate}},
};

bool SpellCheckHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::spellcheck::mojom::SpellCheckHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpellCheckHostValidationInfo);
}

bool SpellCheckHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::spellcheck::mojom::SpellCheckHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSpellCheckHostValidationInfo);

}
}  // namespace mojom
}  // namespace spellcheck

namespace mojo {


// static
bool StructTraits<::spellcheck::mojom::SpellCheckBDictLanguage::DataView, ::spellcheck::mojom::SpellCheckBDictLanguagePtr>::Read(
    ::spellcheck::mojom::SpellCheckBDictLanguage::DataView input,
    ::spellcheck::mojom::SpellCheckBDictLanguagePtr* output) {
  bool success = true;
  ::spellcheck::mojom::SpellCheckBDictLanguagePtr result(::spellcheck::mojom::SpellCheckBDictLanguage::New());
  
      if (success && !input.ReadFile(&result->file))
        success = false;
      if (success && !input.ReadLanguage(&result->language))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::spellcheck::mojom::SpellCheckResult::DataView, ::spellcheck::mojom::SpellCheckResultPtr>::Read(
    ::spellcheck::mojom::SpellCheckResult::DataView input,
    ::spellcheck::mojom::SpellCheckResultPtr* output) {
  bool success = true;
  ::spellcheck::mojom::SpellCheckResultPtr result(::spellcheck::mojom::SpellCheckResult::New());
  
      if (success && !input.ReadDecoration(&result->decoration))
        success = false;
      if (success)
        result->location = input.location();
      if (success)
        result->length = input.length();
      if (success && !input.ReadReplacements(&result->replacements))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif