// components/spellcheck/common/spellcheck.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace spellcheck {
namespace mojom {
namespace internal {
class  SpellChecker_Initialize_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SpellChecker_Initialize_Params_Data));
      new (data()) SpellChecker_Initialize_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SpellChecker_Initialize_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SpellChecker_Initialize_Params_Data>(index_);
    }
    SpellChecker_Initialize_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::SpellCheckBDictLanguage_Data>>> dictionaries;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> custom_words;
  uint8_t enable : 1;
  uint8_t padfinal_[7];

 private:
  SpellChecker_Initialize_Params_Data();
  ~SpellChecker_Initialize_Params_Data() = delete;
};
static_assert(sizeof(SpellChecker_Initialize_Params_Data) == 32,
              "Bad sizeof(SpellChecker_Initialize_Params_Data)");
class  SpellChecker_CustomDictionaryChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SpellChecker_CustomDictionaryChanged_Params_Data));
      new (data()) SpellChecker_CustomDictionaryChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SpellChecker_CustomDictionaryChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SpellChecker_CustomDictionaryChanged_Params_Data>(index_);
    }
    SpellChecker_CustomDictionaryChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> words_added;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> words_removed;

 private:
  SpellChecker_CustomDictionaryChanged_Params_Data();
  ~SpellChecker_CustomDictionaryChanged_Params_Data() = delete;
};
static_assert(sizeof(SpellChecker_CustomDictionaryChanged_Params_Data) == 24,
              "Bad sizeof(SpellChecker_CustomDictionaryChanged_Params_Data)");
class  SpellCheckHost_RequestDictionary_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SpellCheckHost_RequestDictionary_Params_Data));
      new (data()) SpellCheckHost_RequestDictionary_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SpellCheckHost_RequestDictionary_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SpellCheckHost_RequestDictionary_Params_Data>(index_);
    }
    SpellCheckHost_RequestDictionary_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  SpellCheckHost_RequestDictionary_Params_Data();
  ~SpellCheckHost_RequestDictionary_Params_Data() = delete;
};
static_assert(sizeof(SpellCheckHost_RequestDictionary_Params_Data) == 8,
              "Bad sizeof(SpellCheckHost_RequestDictionary_Params_Data)");
class  SpellCheckHost_NotifyChecked_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SpellCheckHost_NotifyChecked_Params_Data));
      new (data()) SpellCheckHost_NotifyChecked_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SpellCheckHost_NotifyChecked_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SpellCheckHost_NotifyChecked_Params_Data>(index_);
    }
    SpellCheckHost_NotifyChecked_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> word;
  uint8_t misspelled : 1;
  uint8_t padfinal_[7];

 private:
  SpellCheckHost_NotifyChecked_Params_Data();
  ~SpellCheckHost_NotifyChecked_Params_Data() = delete;
};
static_assert(sizeof(SpellCheckHost_NotifyChecked_Params_Data) == 24,
              "Bad sizeof(SpellCheckHost_NotifyChecked_Params_Data)");
class  SpellCheckHost_CallSpellingService_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SpellCheckHost_CallSpellingService_Params_Data));
      new (data()) SpellCheckHost_CallSpellingService_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SpellCheckHost_CallSpellingService_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SpellCheckHost_CallSpellingService_Params_Data>(index_);
    }
    SpellCheckHost_CallSpellingService_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> text;

 private:
  SpellCheckHost_CallSpellingService_Params_Data();
  ~SpellCheckHost_CallSpellingService_Params_Data() = delete;
};
static_assert(sizeof(SpellCheckHost_CallSpellingService_Params_Data) == 16,
              "Bad sizeof(SpellCheckHost_CallSpellingService_Params_Data)");
class  SpellCheckHost_CallSpellingService_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SpellCheckHost_CallSpellingService_ResponseParams_Data));
      new (data()) SpellCheckHost_CallSpellingService_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SpellCheckHost_CallSpellingService_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SpellCheckHost_CallSpellingService_ResponseParams_Data>(index_);
    }
    SpellCheckHost_CallSpellingService_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::SpellCheckResult_Data>>> results;

 private:
  SpellCheckHost_CallSpellingService_ResponseParams_Data();
  ~SpellCheckHost_CallSpellingService_ResponseParams_Data() = delete;
};
static_assert(sizeof(SpellCheckHost_CallSpellingService_ResponseParams_Data) == 24,
              "Bad sizeof(SpellCheckHost_CallSpellingService_ResponseParams_Data)");

}  // namespace internal


class SpellChecker_Initialize_ParamsDataView {
 public:
  SpellChecker_Initialize_ParamsDataView() {}

  SpellChecker_Initialize_ParamsDataView(
      internal::SpellChecker_Initialize_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDictionariesDataView(
      mojo::ArrayDataView<SpellCheckBDictLanguageDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDictionaries(UserType* output) {
    
    auto* pointer = data_->dictionaries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::spellcheck::mojom::SpellCheckBDictLanguageDataView>>(
        pointer, output, context_);
  }
  inline void GetCustomWordsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCustomWords(UserType* output) {
    
    auto* pointer = data_->custom_words.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  bool enable() const {
    return data_->enable;
  }
 private:
  internal::SpellChecker_Initialize_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SpellChecker_CustomDictionaryChanged_ParamsDataView {
 public:
  SpellChecker_CustomDictionaryChanged_ParamsDataView() {}

  SpellChecker_CustomDictionaryChanged_ParamsDataView(
      internal::SpellChecker_CustomDictionaryChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetWordsAddedDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWordsAdded(UserType* output) {
    
    auto* pointer = data_->words_added.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetWordsRemovedDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWordsRemoved(UserType* output) {
    
    auto* pointer = data_->words_removed.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
 private:
  internal::SpellChecker_CustomDictionaryChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SpellCheckHost_RequestDictionary_ParamsDataView {
 public:
  SpellCheckHost_RequestDictionary_ParamsDataView() {}

  SpellCheckHost_RequestDictionary_ParamsDataView(
      internal::SpellCheckHost_RequestDictionary_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::SpellCheckHost_RequestDictionary_Params_Data* data_ = nullptr;
};



class SpellCheckHost_NotifyChecked_ParamsDataView {
 public:
  SpellCheckHost_NotifyChecked_ParamsDataView() {}

  SpellCheckHost_NotifyChecked_ParamsDataView(
      internal::SpellCheckHost_NotifyChecked_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetWordDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWord(UserType* output) {
    
    auto* pointer = data_->word.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  bool misspelled() const {
    return data_->misspelled;
  }
 private:
  internal::SpellCheckHost_NotifyChecked_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SpellCheckHost_CallSpellingService_ParamsDataView {
 public:
  SpellCheckHost_CallSpellingService_ParamsDataView() {}

  SpellCheckHost_CallSpellingService_ParamsDataView(
      internal::SpellCheckHost_CallSpellingService_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
 private:
  internal::SpellCheckHost_CallSpellingService_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SpellCheckHost_CallSpellingService_ResponseParamsDataView {
 public:
  SpellCheckHost_CallSpellingService_ResponseParamsDataView() {}

  SpellCheckHost_CallSpellingService_ResponseParamsDataView(
      internal::SpellCheckHost_CallSpellingService_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  inline void GetResultsDataView(
      mojo::ArrayDataView<SpellCheckResultDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResults(UserType* output) {
    
    auto* pointer = data_->results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::spellcheck::mojom::SpellCheckResultDataView>>(
        pointer, output, context_);
  }
 private:
  internal::SpellCheckHost_CallSpellingService_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void SpellChecker_Initialize_ParamsDataView::GetDictionariesDataView(
    mojo::ArrayDataView<SpellCheckBDictLanguageDataView>* output) {
  auto pointer = data_->dictionaries.Get();
  *output = mojo::ArrayDataView<SpellCheckBDictLanguageDataView>(pointer, context_);
}
inline void SpellChecker_Initialize_ParamsDataView::GetCustomWordsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->custom_words.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}


inline void SpellChecker_CustomDictionaryChanged_ParamsDataView::GetWordsAddedDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->words_added.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void SpellChecker_CustomDictionaryChanged_ParamsDataView::GetWordsRemovedDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->words_removed.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}




inline void SpellCheckHost_NotifyChecked_ParamsDataView::GetWordDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->word.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}


inline void SpellCheckHost_CallSpellingService_ParamsDataView::GetTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}


inline void SpellCheckHost_CallSpellingService_ResponseParamsDataView::GetResultsDataView(
    mojo::ArrayDataView<SpellCheckResultDataView>* output) {
  auto pointer = data_->results.Get();
  *output = mojo::ArrayDataView<SpellCheckResultDataView>(pointer, context_);
}

}  // namespace mojom
}  // namespace spellcheck

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_PARAMS_DATA_H_