// components/services/storage/public/mojom/service_worker_database.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/service_worker/navigation_preload_state.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/web_feature/web_feature.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace storage {
namespace mojom {
namespace internal {
class ServiceWorkerRegistrationData_Data;
class ServiceWorkerResourceRecord_Data;

struct ServiceWorkerDatabaseStatus_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  ServiceWorkerRegistrationData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ServiceWorkerRegistrationData_Data));
      new (data()) ServiceWorkerRegistrationData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ServiceWorkerRegistrationData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ServiceWorkerRegistrationData_Data>(index_);
    }
    ServiceWorkerRegistrationData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t registration_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> scope;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> script;
  int32_t script_type;
  int32_t update_via_cache;
  int64_t version_id;
  uint8_t is_active : 1;
  uint8_t has_fetch_handler : 1;
  uint8_t pad7_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> last_update_check;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> script_response_time;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>>>> origin_trial_tokens;
  mojo::internal::Pointer<::blink::mojom::internal::NavigationPreloadState_Data> navigation_preload_state;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> used_features;
  int64_t resources_total_size_bytes;
  mojo::internal::Pointer<::network::mojom::internal::CrossOriginEmbedderPolicy_Data> cross_origin_embedder_policy;

 private:
  ServiceWorkerRegistrationData_Data();
  ~ServiceWorkerRegistrationData_Data() = delete;
};
static_assert(sizeof(ServiceWorkerRegistrationData_Data) == 112,
              "Bad sizeof(ServiceWorkerRegistrationData_Data)");
// Used by ServiceWorkerRegistrationData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ServiceWorkerRegistrationData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ServiceWorkerRegistrationData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ServiceWorkerRegistrationData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    ServiceWorkerRegistrationData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ServiceWorkerRegistrationData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ServiceWorkerResourceRecord_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ServiceWorkerResourceRecord_Data));
      new (data()) ServiceWorkerResourceRecord_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ServiceWorkerResourceRecord_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ServiceWorkerResourceRecord_Data>(index_);
    }
    ServiceWorkerResourceRecord_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t resource_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  int64_t size_bytes;

 private:
  ServiceWorkerResourceRecord_Data();
  ~ServiceWorkerResourceRecord_Data() = delete;
};
static_assert(sizeof(ServiceWorkerResourceRecord_Data) == 32,
              "Bad sizeof(ServiceWorkerResourceRecord_Data)");
// Used by ServiceWorkerResourceRecord::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ServiceWorkerResourceRecord_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ServiceWorkerResourceRecord_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ServiceWorkerResourceRecord_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    ServiceWorkerResourceRecord_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ServiceWorkerResourceRecord_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace storage

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SHARED_INTERNAL_H_