// components/services/storage/public/mojom/local_storage_control.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/local_storage_control.mojom-shared.h"
#include "components/services/storage/public/mojom/local_storage_control.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {

class LocalStorageControlProxy;

template <typename ImplRefTraits>
class LocalStorageControlStub;

class LocalStorageControlRequestValidator;
class LocalStorageControlResponseValidator;


class  LocalStorageControl
    : public LocalStorageControlInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = LocalStorageControlInterfaceBase;
  using Proxy_ = LocalStorageControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalStorageControlStub<ImplRefTraits>;

  using RequestValidator_ = LocalStorageControlRequestValidator;
  using ResponseValidator_ = LocalStorageControlResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindStorageAreaMinVersion = 0,
    kGetUsageMinVersion = 0,
    kDeleteStorageMinVersion = 0,
    kCleanUpStorageMinVersion = 0,
    kFlushMinVersion = 0,
    kPurgeMemoryMinVersion = 0,
    kApplyPolicyUpdatesMinVersion = 0,
    kForceKeepSessionStateMinVersion = 0,
  };
  virtual ~LocalStorageControl() {}

  
  virtual void BindStorageArea(const ::url::Origin& origin, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver) = 0;


  using GetUsageCallback = base::OnceCallback<void(std::vector<LocalStorageUsageInfoPtr>)>;
  
  virtual void GetUsage(GetUsageCallback callback) = 0;


  using DeleteStorageCallback = base::OnceCallback<void()>;
  
  virtual void DeleteStorage(const ::url::Origin& origin, DeleteStorageCallback callback) = 0;


  using CleanUpStorageCallback = base::OnceCallback<void()>;
  
  virtual void CleanUpStorage(CleanUpStorageCallback callback) = 0;


  using FlushCallback = base::OnceCallback<void()>;
  
  virtual void Flush(FlushCallback callback) = 0;

  
  virtual void PurgeMemory() = 0;

  
  virtual void ApplyPolicyUpdates(std::vector<LocalStoragePolicyUpdatePtr> policy_updates) = 0;

  
  virtual void ForceKeepSessionState() = 0;
};



class  LocalStorageControlProxy
    : public LocalStorageControl {
 public:
  using InterfaceType = LocalStorageControl;

  explicit LocalStorageControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindStorageArea(const ::url::Origin& origin, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver) final;
  
  void GetUsage(GetUsageCallback callback) final;
  
  void DeleteStorage(const ::url::Origin& origin, DeleteStorageCallback callback) final;
  
  void CleanUpStorage(CleanUpStorageCallback callback) final;
  
  void Flush(FlushCallback callback) final;
  
  void PurgeMemory() final;
  
  void ApplyPolicyUpdates(std::vector<LocalStoragePolicyUpdatePtr> policy_updates) final;
  
  void ForceKeepSessionState() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LocalStorageControlStubDispatch {
 public:
  static bool Accept(LocalStorageControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalStorageControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalStorageControl>>
class LocalStorageControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalStorageControlStub() {}
  ~LocalStorageControlStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalStorageControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalStorageControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LocalStorageControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LocalStorageControlResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  LocalStorageUsageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LocalStorageUsageInfo, T>::value>;
  using DataView = LocalStorageUsageInfoDataView;
  using Data_ = internal::LocalStorageUsageInfo_Data;

  template <typename... Args>
  static LocalStorageUsageInfoPtr New(Args&&... args) {
    return LocalStorageUsageInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocalStorageUsageInfoPtr From(const U& u) {
    return mojo::TypeConverter<LocalStorageUsageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocalStorageUsageInfo>::Convert(*this);
  }


  LocalStorageUsageInfo();

  LocalStorageUsageInfo(
      const ::url::Origin& origin,
      uint64_t size_in_bytes,
      ::base::Time last_modified_time);

  ~LocalStorageUsageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocalStorageUsageInfoPtr>
  LocalStorageUsageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LocalStorageUsageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalStorageUsageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocalStorageUsageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LocalStorageUsageInfo_UnserializedMessageContext<
            UserType, LocalStorageUsageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<LocalStorageUsageInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return LocalStorageUsageInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LocalStorageUsageInfo_UnserializedMessageContext<
            UserType, LocalStorageUsageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LocalStorageUsageInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::url::Origin origin;
  
  uint64_t size_in_bytes;
  
  ::base::Time last_modified_time;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LocalStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LocalStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LocalStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LocalStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LocalStoragePolicyUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LocalStoragePolicyUpdate, T>::value>;
  using DataView = LocalStoragePolicyUpdateDataView;
  using Data_ = internal::LocalStoragePolicyUpdate_Data;

  template <typename... Args>
  static LocalStoragePolicyUpdatePtr New(Args&&... args) {
    return LocalStoragePolicyUpdatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocalStoragePolicyUpdatePtr From(const U& u) {
    return mojo::TypeConverter<LocalStoragePolicyUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocalStoragePolicyUpdate>::Convert(*this);
  }


  LocalStoragePolicyUpdate();

  LocalStoragePolicyUpdate(
      const ::url::Origin& origin,
      bool purge_on_shutdown);

  ~LocalStoragePolicyUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocalStoragePolicyUpdatePtr>
  LocalStoragePolicyUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LocalStoragePolicyUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalStoragePolicyUpdate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocalStoragePolicyUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LocalStoragePolicyUpdate_UnserializedMessageContext<
            UserType, LocalStoragePolicyUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<LocalStoragePolicyUpdate::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return LocalStoragePolicyUpdate::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LocalStoragePolicyUpdate_UnserializedMessageContext<
            UserType, LocalStoragePolicyUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LocalStoragePolicyUpdate::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::url::Origin origin;
  
  bool purge_on_shutdown;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LocalStoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LocalStoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LocalStoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LocalStoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LocalStorageUsageInfoPtr LocalStorageUsageInfo::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(size_in_bytes),
      mojo::Clone(last_modified_time)
  );
}

template <typename T, LocalStorageUsageInfo::EnableIfSame<T>*>
bool LocalStorageUsageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->size_in_bytes, other_struct.size_in_bytes))
    return false;
  if (!mojo::Equals(this->last_modified_time, other_struct.last_modified_time))
    return false;
  return true;
}

template <typename T, LocalStorageUsageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.origin, rhs.origin))
    return true;
  if (std::less<>{}(rhs.origin, lhs.origin))
    return false;
  if (std::less<>{}(lhs.size_in_bytes, rhs.size_in_bytes))
    return true;
  if (std::less<>{}(rhs.size_in_bytes, lhs.size_in_bytes))
    return false;
  if (std::less<>{}(lhs.last_modified_time, rhs.last_modified_time))
    return true;
  if (std::less<>{}(rhs.last_modified_time, lhs.last_modified_time))
    return false;
  return false;
}
template <typename StructPtrType>
LocalStoragePolicyUpdatePtr LocalStoragePolicyUpdate::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(purge_on_shutdown)
  );
}

template <typename T, LocalStoragePolicyUpdate::EnableIfSame<T>*>
bool LocalStoragePolicyUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->purge_on_shutdown, other_struct.purge_on_shutdown))
    return false;
  return true;
}

template <typename T, LocalStoragePolicyUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.origin, rhs.origin))
    return true;
  if (std::less<>{}(rhs.origin, lhs.origin))
    return false;
  if (std::less<>{}(lhs.purge_on_shutdown, rhs.purge_on_shutdown))
    return true;
  if (std::less<>{}(rhs.purge_on_shutdown, lhs.purge_on_shutdown))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace storage

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::LocalStorageUsageInfo::DataView,
                                         ::storage::mojom::LocalStorageUsageInfoPtr> {
  static bool IsNull(const ::storage::mojom::LocalStorageUsageInfoPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::LocalStorageUsageInfoPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::LocalStorageUsageInfo::origin)& origin(
      const ::storage::mojom::LocalStorageUsageInfoPtr& input) {
    return input->origin;
  }

  static decltype(::storage::mojom::LocalStorageUsageInfo::size_in_bytes) size_in_bytes(
      const ::storage::mojom::LocalStorageUsageInfoPtr& input) {
    return input->size_in_bytes;
  }

  static const decltype(::storage::mojom::LocalStorageUsageInfo::last_modified_time)& last_modified_time(
      const ::storage::mojom::LocalStorageUsageInfoPtr& input) {
    return input->last_modified_time;
  }

  static bool Read(::storage::mojom::LocalStorageUsageInfo::DataView input, ::storage::mojom::LocalStorageUsageInfoPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::LocalStoragePolicyUpdate::DataView,
                                         ::storage::mojom::LocalStoragePolicyUpdatePtr> {
  static bool IsNull(const ::storage::mojom::LocalStoragePolicyUpdatePtr& input) { return !input; }
  static void SetToNull(::storage::mojom::LocalStoragePolicyUpdatePtr* output) { output->reset(); }

  static const decltype(::storage::mojom::LocalStoragePolicyUpdate::origin)& origin(
      const ::storage::mojom::LocalStoragePolicyUpdatePtr& input) {
    return input->origin;
  }

  static decltype(::storage::mojom::LocalStoragePolicyUpdate::purge_on_shutdown) purge_on_shutdown(
      const ::storage::mojom::LocalStoragePolicyUpdatePtr& input) {
    return input->purge_on_shutdown;
  }

  static bool Read(::storage::mojom::LocalStoragePolicyUpdate::DataView input, ::storage::mojom::LocalStoragePolicyUpdatePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_H_