// components/services/storage/public/mojom/filesystem/directory.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace storage {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) FileLock_Release_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FileLock_Release_Params_Data));
      new (data()) FileLock_Release_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FileLock_Release_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FileLock_Release_Params_Data>(index_);
    }
    FileLock_Release_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  FileLock_Release_Params_Data();
  ~FileLock_Release_Params_Data() = delete;
};
static_assert(sizeof(FileLock_Release_Params_Data) == 8,
              "Bad sizeof(FileLock_Release_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) FileLock_Release_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FileLock_Release_ResponseParams_Data));
      new (data()) FileLock_Release_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FileLock_Release_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FileLock_Release_ResponseParams_Data>(index_);
    }
    FileLock_Release_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  FileLock_Release_ResponseParams_Data();
  ~FileLock_Release_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileLock_Release_ResponseParams_Data) == 16,
              "Bad sizeof(FileLock_Release_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_Clone_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_Clone_Params_Data));
      new (data()) Directory_Clone_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_Clone_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_Clone_Params_Data>(index_);
    }
    Directory_Clone_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  Directory_Clone_Params_Data();
  ~Directory_Clone_Params_Data() = delete;
};
static_assert(sizeof(Directory_Clone_Params_Data) == 16,
              "Bad sizeof(Directory_Clone_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_PathExists_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_PathExists_Params_Data));
      new (data()) Directory_PathExists_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_PathExists_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_PathExists_Params_Data>(index_);
    }
    Directory_PathExists_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  Directory_PathExists_Params_Data();
  ~Directory_PathExists_Params_Data() = delete;
};
static_assert(sizeof(Directory_PathExists_Params_Data) == 16,
              "Bad sizeof(Directory_PathExists_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_PathExists_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_PathExists_ResponseParams_Data));
      new (data()) Directory_PathExists_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_PathExists_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_PathExists_ResponseParams_Data>(index_);
    }
    Directory_PathExists_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t exists : 1;
  uint8_t padfinal_[7];

 private:
  Directory_PathExists_ResponseParams_Data();
  ~Directory_PathExists_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_PathExists_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_PathExists_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetEntries_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_GetEntries_Params_Data));
      new (data()) Directory_GetEntries_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_GetEntries_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_GetEntries_Params_Data>(index_);
    }
    Directory_GetEntries_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;
  int32_t mode;
  uint8_t padfinal_[4];

 private:
  Directory_GetEntries_Params_Data();
  ~Directory_GetEntries_Params_Data() = delete;
};
static_assert(sizeof(Directory_GetEntries_Params_Data) == 24,
              "Bad sizeof(Directory_GetEntries_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetEntries_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_GetEntries_ResponseParams_Data));
      new (data()) Directory_GetEntries_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_GetEntries_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_GetEntries_ResponseParams_Data>(index_);
    }
    Directory_GetEntries_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data>>> entries;

 private:
  Directory_GetEntries_ResponseParams_Data();
  ~Directory_GetEntries_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_GetEntries_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_GetEntries_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_OpenFile_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_OpenFile_Params_Data));
      new (data()) Directory_OpenFile_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_OpenFile_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_OpenFile_Params_Data>(index_);
    }
    Directory_OpenFile_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;
  int32_t mode;
  int32_t read_access;
  int32_t write_access;
  uint8_t padfinal_[4];

 private:
  Directory_OpenFile_Params_Data();
  ~Directory_OpenFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_OpenFile_Params_Data) == 32,
              "Bad sizeof(Directory_OpenFile_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_OpenFile_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_OpenFile_ResponseParams_Data));
      new (data()) Directory_OpenFile_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_OpenFile_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_OpenFile_ResponseParams_Data>(index_);
    }
    Directory_OpenFile_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> file;

 private:
  Directory_OpenFile_ResponseParams_Data();
  ~Directory_OpenFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_OpenFile_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_OpenFile_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_WriteFileAtomically_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_WriteFileAtomically_Params_Data));
      new (data()) Directory_WriteFileAtomically_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_WriteFileAtomically_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_WriteFileAtomically_Params_Data>(index_);
    }
    Directory_WriteFileAtomically_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;
  mojo::internal::Pointer<::mojo_base::mojom::internal::BigString_Data> contents;

 private:
  Directory_WriteFileAtomically_Params_Data();
  ~Directory_WriteFileAtomically_Params_Data() = delete;
};
static_assert(sizeof(Directory_WriteFileAtomically_Params_Data) == 24,
              "Bad sizeof(Directory_WriteFileAtomically_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_WriteFileAtomically_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_WriteFileAtomically_ResponseParams_Data));
      new (data()) Directory_WriteFileAtomically_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_WriteFileAtomically_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_WriteFileAtomically_ResponseParams_Data>(index_);
    }
    Directory_WriteFileAtomically_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  Directory_WriteFileAtomically_ResponseParams_Data();
  ~Directory_WriteFileAtomically_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_WriteFileAtomically_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_WriteFileAtomically_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_CreateDirectory_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_CreateDirectory_Params_Data));
      new (data()) Directory_CreateDirectory_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_CreateDirectory_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_CreateDirectory_Params_Data>(index_);
    }
    Directory_CreateDirectory_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  Directory_CreateDirectory_Params_Data();
  ~Directory_CreateDirectory_Params_Data() = delete;
};
static_assert(sizeof(Directory_CreateDirectory_Params_Data) == 16,
              "Bad sizeof(Directory_CreateDirectory_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_CreateDirectory_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_CreateDirectory_ResponseParams_Data));
      new (data()) Directory_CreateDirectory_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_CreateDirectory_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_CreateDirectory_ResponseParams_Data>(index_);
    }
    Directory_CreateDirectory_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  Directory_CreateDirectory_ResponseParams_Data();
  ~Directory_CreateDirectory_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_CreateDirectory_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_CreateDirectory_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_DeleteFile_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_DeleteFile_Params_Data));
      new (data()) Directory_DeleteFile_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_DeleteFile_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_DeleteFile_Params_Data>(index_);
    }
    Directory_DeleteFile_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  Directory_DeleteFile_Params_Data();
  ~Directory_DeleteFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_DeleteFile_Params_Data) == 16,
              "Bad sizeof(Directory_DeleteFile_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_DeleteFile_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_DeleteFile_ResponseParams_Data));
      new (data()) Directory_DeleteFile_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_DeleteFile_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_DeleteFile_ResponseParams_Data>(index_);
    }
    Directory_DeleteFile_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  Directory_DeleteFile_ResponseParams_Data();
  ~Directory_DeleteFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_DeleteFile_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_DeleteFile_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_DeletePathRecursively_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_DeletePathRecursively_Params_Data));
      new (data()) Directory_DeletePathRecursively_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_DeletePathRecursively_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_DeletePathRecursively_Params_Data>(index_);
    }
    Directory_DeletePathRecursively_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  Directory_DeletePathRecursively_Params_Data();
  ~Directory_DeletePathRecursively_Params_Data() = delete;
};
static_assert(sizeof(Directory_DeletePathRecursively_Params_Data) == 16,
              "Bad sizeof(Directory_DeletePathRecursively_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_DeletePathRecursively_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_DeletePathRecursively_ResponseParams_Data));
      new (data()) Directory_DeletePathRecursively_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_DeletePathRecursively_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_DeletePathRecursively_ResponseParams_Data>(index_);
    }
    Directory_DeletePathRecursively_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  Directory_DeletePathRecursively_ResponseParams_Data();
  ~Directory_DeletePathRecursively_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_DeletePathRecursively_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_DeletePathRecursively_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetFileInfo_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_GetFileInfo_Params_Data));
      new (data()) Directory_GetFileInfo_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_GetFileInfo_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_GetFileInfo_Params_Data>(index_);
    }
    Directory_GetFileInfo_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  Directory_GetFileInfo_Params_Data();
  ~Directory_GetFileInfo_Params_Data() = delete;
};
static_assert(sizeof(Directory_GetFileInfo_Params_Data) == 16,
              "Bad sizeof(Directory_GetFileInfo_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetFileInfo_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_GetFileInfo_ResponseParams_Data));
      new (data()) Directory_GetFileInfo_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_GetFileInfo_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_GetFileInfo_ResponseParams_Data>(index_);
    }
    Directory_GetFileInfo_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FileInfo_Data> info;

 private:
  Directory_GetFileInfo_ResponseParams_Data();
  ~Directory_GetFileInfo_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_GetFileInfo_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_GetFileInfo_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetPathAccess_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_GetPathAccess_Params_Data));
      new (data()) Directory_GetPathAccess_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_GetPathAccess_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_GetPathAccess_Params_Data>(index_);
    }
    Directory_GetPathAccess_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  Directory_GetPathAccess_Params_Data();
  ~Directory_GetPathAccess_Params_Data() = delete;
};
static_assert(sizeof(Directory_GetPathAccess_Params_Data) == 16,
              "Bad sizeof(Directory_GetPathAccess_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetPathAccess_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_GetPathAccess_ResponseParams_Data));
      new (data()) Directory_GetPathAccess_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_GetPathAccess_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_GetPathAccess_ResponseParams_Data>(index_);
    }
    Directory_GetPathAccess_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PathAccessInfo_Data> info;

 private:
  Directory_GetPathAccess_ResponseParams_Data();
  ~Directory_GetPathAccess_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_GetPathAccess_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_GetPathAccess_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetMaximumPathComponentLength_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_GetMaximumPathComponentLength_Params_Data));
      new (data()) Directory_GetMaximumPathComponentLength_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_GetMaximumPathComponentLength_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_GetMaximumPathComponentLength_Params_Data>(index_);
    }
    Directory_GetMaximumPathComponentLength_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  Directory_GetMaximumPathComponentLength_Params_Data();
  ~Directory_GetMaximumPathComponentLength_Params_Data() = delete;
};
static_assert(sizeof(Directory_GetMaximumPathComponentLength_Params_Data) == 16,
              "Bad sizeof(Directory_GetMaximumPathComponentLength_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetMaximumPathComponentLength_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_GetMaximumPathComponentLength_ResponseParams_Data));
      new (data()) Directory_GetMaximumPathComponentLength_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_GetMaximumPathComponentLength_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_GetMaximumPathComponentLength_ResponseParams_Data>(index_);
    }
    Directory_GetMaximumPathComponentLength_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t pad0_[3];
  int32_t length;

 private:
  Directory_GetMaximumPathComponentLength_ResponseParams_Data();
  ~Directory_GetMaximumPathComponentLength_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_GetMaximumPathComponentLength_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_GetMaximumPathComponentLength_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_RenameFile_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_RenameFile_Params_Data));
      new (data()) Directory_RenameFile_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_RenameFile_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_RenameFile_Params_Data>(index_);
    }
    Directory_RenameFile_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> old_path;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> new_path;

 private:
  Directory_RenameFile_Params_Data();
  ~Directory_RenameFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_RenameFile_Params_Data) == 24,
              "Bad sizeof(Directory_RenameFile_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_RenameFile_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_RenameFile_ResponseParams_Data));
      new (data()) Directory_RenameFile_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_RenameFile_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_RenameFile_ResponseParams_Data>(index_);
    }
    Directory_RenameFile_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  Directory_RenameFile_ResponseParams_Data();
  ~Directory_RenameFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_RenameFile_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_RenameFile_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_LockFile_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_LockFile_Params_Data));
      new (data()) Directory_LockFile_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_LockFile_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_LockFile_Params_Data>(index_);
    }
    Directory_LockFile_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  Directory_LockFile_Params_Data();
  ~Directory_LockFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_LockFile_Params_Data) == 16,
              "Bad sizeof(Directory_LockFile_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_LockFile_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_LockFile_ResponseParams_Data));
      new (data()) Directory_LockFile_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_LockFile_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_LockFile_ResponseParams_Data>(index_);
    }
    Directory_LockFile_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  mojo::internal::Interface_Data lock;
  uint8_t padfinal_[4];

 private:
  Directory_LockFile_ResponseParams_Data();
  ~Directory_LockFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_LockFile_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_LockFile_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_SetOpenedFileLength_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_SetOpenedFileLength_Params_Data));
      new (data()) Directory_SetOpenedFileLength_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_SetOpenedFileLength_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_SetOpenedFileLength_Params_Data>(index_);
    }
    Directory_SetOpenedFileLength_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> file;
  uint64_t size;

 private:
  Directory_SetOpenedFileLength_Params_Data();
  ~Directory_SetOpenedFileLength_Params_Data() = delete;
};
static_assert(sizeof(Directory_SetOpenedFileLength_Params_Data) == 24,
              "Bad sizeof(Directory_SetOpenedFileLength_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_SetOpenedFileLength_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Directory_SetOpenedFileLength_ResponseParams_Data));
      new (data()) Directory_SetOpenedFileLength_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Directory_SetOpenedFileLength_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Directory_SetOpenedFileLength_ResponseParams_Data>(index_);
    }
    Directory_SetOpenedFileLength_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> file;

 private:
  Directory_SetOpenedFileLength_ResponseParams_Data();
  ~Directory_SetOpenedFileLength_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_SetOpenedFileLength_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_SetOpenedFileLength_ResponseParams_Data)");

}  // namespace internal


class FileLock_Release_ParamsDataView {
 public:
  FileLock_Release_ParamsDataView() {}

  FileLock_Release_ParamsDataView(
      internal::FileLock_Release_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::FileLock_Release_Params_Data* data_ = nullptr;
};



class FileLock_Release_ResponseParamsDataView {
 public:
  FileLock_Release_ResponseParamsDataView() {}

  FileLock_Release_ResponseParamsDataView(
      internal::FileLock_Release_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }

  ::mojo_base::mojom::FileError error() const {
    return static_cast<::mojo_base::mojom::FileError>(data_->error);
  }
 private:
  internal::FileLock_Release_ResponseParams_Data* data_ = nullptr;
};



class Directory_Clone_ParamsDataView {
 public:
  Directory_Clone_ParamsDataView() {}

  Directory_Clone_ParamsDataView(
      internal::Directory_Clone_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::storage::mojom::DirectoryInterfaceBase>>(
            &data_->receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Directory_Clone_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_PathExists_ParamsDataView {
 public:
  Directory_PathExists_ParamsDataView() {}

  Directory_PathExists_ParamsDataView(
      internal::Directory_PathExists_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_PathExists_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_PathExists_ResponseParamsDataView {
 public:
  Directory_PathExists_ResponseParamsDataView() {}

  Directory_PathExists_ResponseParamsDataView(
      internal::Directory_PathExists_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool exists() const {
    return data_->exists;
  }
 private:
  internal::Directory_PathExists_ResponseParams_Data* data_ = nullptr;
};



class Directory_GetEntries_ParamsDataView {
 public:
  Directory_GetEntries_ParamsDataView() {}

  Directory_GetEntries_ParamsDataView(
      internal::Directory_GetEntries_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::storage::mojom::GetEntriesMode>(
        data_value, output);
  }

  GetEntriesMode mode() const {
    return static_cast<GetEntriesMode>(data_->mode);
  }
 private:
  internal::Directory_GetEntries_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_GetEntries_ResponseParamsDataView {
 public:
  Directory_GetEntries_ResponseParamsDataView() {}

  Directory_GetEntries_ResponseParamsDataView(
      internal::Directory_GetEntries_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }

  ::mojo_base::mojom::FileError error() const {
    return static_cast<::mojo_base::mojom::FileError>(data_->error);
  }
  inline void GetEntriesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEntries(UserType* output) {
    
    auto* pointer = data_->entries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
        pointer, output, context_);
  }
 private:
  internal::Directory_GetEntries_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_OpenFile_ParamsDataView {
 public:
  Directory_OpenFile_ParamsDataView() {}

  Directory_OpenFile_ParamsDataView(
      internal::Directory_OpenFile_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::storage::mojom::FileOpenMode>(
        data_value, output);
  }

  FileOpenMode mode() const {
    return static_cast<FileOpenMode>(data_->mode);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReadAccess(UserType* output) const {
    auto data_value = data_->read_access;
    return mojo::internal::Deserialize<::storage::mojom::FileReadAccess>(
        data_value, output);
  }

  FileReadAccess read_access() const {
    return static_cast<FileReadAccess>(data_->read_access);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWriteAccess(UserType* output) const {
    auto data_value = data_->write_access;
    return mojo::internal::Deserialize<::storage::mojom::FileWriteAccess>(
        data_value, output);
  }

  FileWriteAccess write_access() const {
    return static_cast<FileWriteAccess>(data_->write_access);
  }
 private:
  internal::Directory_OpenFile_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_OpenFile_ResponseParamsDataView {
 public:
  Directory_OpenFile_ResponseParamsDataView() {}

  Directory_OpenFile_ResponseParamsDataView(
      internal::Directory_OpenFile_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }

  ::mojo_base::mojom::FileError error() const {
    return static_cast<::mojo_base::mojom::FileError>(data_->error);
  }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFile(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `file` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFile` instead "
    "of `ReadFile if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_OpenFile_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_WriteFileAtomically_ParamsDataView {
 public:
  Directory_WriteFileAtomically_ParamsDataView() {}

  Directory_WriteFileAtomically_ParamsDataView(
      internal::Directory_WriteFileAtomically_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
  inline void GetContentsDataView(
      ::mojo_base::mojom::BigStringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContents(UserType* output) {
    
    auto* pointer = data_->contents.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::BigStringDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_WriteFileAtomically_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_WriteFileAtomically_ResponseParamsDataView {
 public:
  Directory_WriteFileAtomically_ResponseParamsDataView() {}

  Directory_WriteFileAtomically_ResponseParamsDataView(
      internal::Directory_WriteFileAtomically_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Directory_WriteFileAtomically_ResponseParams_Data* data_ = nullptr;
};



class Directory_CreateDirectory_ParamsDataView {
 public:
  Directory_CreateDirectory_ParamsDataView() {}

  Directory_CreateDirectory_ParamsDataView(
      internal::Directory_CreateDirectory_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_CreateDirectory_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_CreateDirectory_ResponseParamsDataView {
 public:
  Directory_CreateDirectory_ResponseParamsDataView() {}

  Directory_CreateDirectory_ResponseParamsDataView(
      internal::Directory_CreateDirectory_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }

  ::mojo_base::mojom::FileError error() const {
    return static_cast<::mojo_base::mojom::FileError>(data_->error);
  }
 private:
  internal::Directory_CreateDirectory_ResponseParams_Data* data_ = nullptr;
};



class Directory_DeleteFile_ParamsDataView {
 public:
  Directory_DeleteFile_ParamsDataView() {}

  Directory_DeleteFile_ParamsDataView(
      internal::Directory_DeleteFile_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_DeleteFile_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_DeleteFile_ResponseParamsDataView {
 public:
  Directory_DeleteFile_ResponseParamsDataView() {}

  Directory_DeleteFile_ResponseParamsDataView(
      internal::Directory_DeleteFile_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Directory_DeleteFile_ResponseParams_Data* data_ = nullptr;
};



class Directory_DeletePathRecursively_ParamsDataView {
 public:
  Directory_DeletePathRecursively_ParamsDataView() {}

  Directory_DeletePathRecursively_ParamsDataView(
      internal::Directory_DeletePathRecursively_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_DeletePathRecursively_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_DeletePathRecursively_ResponseParamsDataView {
 public:
  Directory_DeletePathRecursively_ResponseParamsDataView() {}

  Directory_DeletePathRecursively_ResponseParamsDataView(
      internal::Directory_DeletePathRecursively_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Directory_DeletePathRecursively_ResponseParams_Data* data_ = nullptr;
};



class Directory_GetFileInfo_ParamsDataView {
 public:
  Directory_GetFileInfo_ParamsDataView() {}

  Directory_GetFileInfo_ParamsDataView(
      internal::Directory_GetFileInfo_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_GetFileInfo_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_GetFileInfo_ResponseParamsDataView {
 public:
  Directory_GetFileInfo_ResponseParamsDataView() {}

  Directory_GetFileInfo_ResponseParamsDataView(
      internal::Directory_GetFileInfo_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      ::mojo_base::mojom::FileInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileInfoDataView, UserType>(),
    "Attempting to read the optional `info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInfo` instead "
    "of `ReadInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_GetFileInfo_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_GetPathAccess_ParamsDataView {
 public:
  Directory_GetPathAccess_ParamsDataView() {}

  Directory_GetPathAccess_ParamsDataView(
      internal::Directory_GetPathAccess_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_GetPathAccess_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_GetPathAccess_ResponseParamsDataView {
 public:
  Directory_GetPathAccess_ResponseParamsDataView() {}

  Directory_GetPathAccess_ResponseParamsDataView(
      internal::Directory_GetPathAccess_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      PathAccessInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::storage::mojom::PathAccessInfoDataView, UserType>(),
    "Attempting to read the optional `info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInfo` instead "
    "of `ReadInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::storage::mojom::PathAccessInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_GetPathAccess_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_GetMaximumPathComponentLength_ParamsDataView {
 public:
  Directory_GetMaximumPathComponentLength_ParamsDataView() {}

  Directory_GetMaximumPathComponentLength_ParamsDataView(
      internal::Directory_GetMaximumPathComponentLength_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_GetMaximumPathComponentLength_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_GetMaximumPathComponentLength_ResponseParamsDataView {
 public:
  Directory_GetMaximumPathComponentLength_ResponseParamsDataView() {}

  Directory_GetMaximumPathComponentLength_ResponseParamsDataView(
      internal::Directory_GetMaximumPathComponentLength_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  int32_t length() const {
    return data_->length;
  }
 private:
  internal::Directory_GetMaximumPathComponentLength_ResponseParams_Data* data_ = nullptr;
};



class Directory_RenameFile_ParamsDataView {
 public:
  Directory_RenameFile_ParamsDataView() {}

  Directory_RenameFile_ParamsDataView(
      internal::Directory_RenameFile_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOldPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOldPath(UserType* output) {
    
    auto* pointer = data_->old_path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
  inline void GetNewPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNewPath(UserType* output) {
    
    auto* pointer = data_->new_path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_RenameFile_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_RenameFile_ResponseParamsDataView {
 public:
  Directory_RenameFile_ResponseParamsDataView() {}

  Directory_RenameFile_ResponseParamsDataView(
      internal::Directory_RenameFile_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }

  ::mojo_base::mojom::FileError error() const {
    return static_cast<::mojo_base::mojom::FileError>(data_->error);
  }
 private:
  internal::Directory_RenameFile_ResponseParams_Data* data_ = nullptr;
};



class Directory_LockFile_ParamsDataView {
 public:
  Directory_LockFile_ParamsDataView() {}

  Directory_LockFile_ParamsDataView(
      internal::Directory_LockFile_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_LockFile_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_LockFile_ResponseParamsDataView {
 public:
  Directory_LockFile_ResponseParamsDataView() {}

  Directory_LockFile_ResponseParamsDataView(
      internal::Directory_LockFile_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }

  ::mojo_base::mojom::FileError error() const {
    return static_cast<::mojo_base::mojom::FileError>(data_->error);
  }
  template <typename UserType>
  UserType TakeLock() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::storage::mojom::FileLockInterfaceBase>>(
            &data_->lock, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Directory_LockFile_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_SetOpenedFileLength_ParamsDataView {
 public:
  Directory_SetOpenedFileLength_ParamsDataView() {}

  Directory_SetOpenedFileLength_ParamsDataView(
      internal::Directory_SetOpenedFileLength_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFile(UserType* output) {
    
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, context_);
  }
  uint64_t size() const {
    return data_->size;
  }
 private:
  internal::Directory_SetOpenedFileLength_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Directory_SetOpenedFileLength_ResponseParamsDataView {
 public:
  Directory_SetOpenedFileLength_ResponseParamsDataView() {}

  Directory_SetOpenedFileLength_ResponseParamsDataView(
      internal::Directory_SetOpenedFileLength_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFile(UserType* output) {
    
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, context_);
  }
 private:
  internal::Directory_SetOpenedFileLength_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};








inline void Directory_PathExists_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}




inline void Directory_GetEntries_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}


inline void Directory_GetEntries_ResponseParamsDataView::GetEntriesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output) {
  auto pointer = data_->entries.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>(pointer, context_);
}


inline void Directory_OpenFile_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}


inline void Directory_OpenFile_ResponseParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, context_);
}


inline void Directory_WriteFileAtomically_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}
inline void Directory_WriteFileAtomically_ParamsDataView::GetContentsDataView(
    ::mojo_base::mojom::BigStringDataView* output) {
  auto pointer = data_->contents.Get();
  *output = ::mojo_base::mojom::BigStringDataView(pointer, context_);
}




inline void Directory_CreateDirectory_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}




inline void Directory_DeleteFile_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}




inline void Directory_DeletePathRecursively_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}




inline void Directory_GetFileInfo_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}


inline void Directory_GetFileInfo_ResponseParamsDataView::GetInfoDataView(
    ::mojo_base::mojom::FileInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = ::mojo_base::mojom::FileInfoDataView(pointer, context_);
}


inline void Directory_GetPathAccess_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}


inline void Directory_GetPathAccess_ResponseParamsDataView::GetInfoDataView(
    PathAccessInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = PathAccessInfoDataView(pointer, context_);
}


inline void Directory_GetMaximumPathComponentLength_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}




inline void Directory_RenameFile_ParamsDataView::GetOldPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->old_path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}
inline void Directory_RenameFile_ParamsDataView::GetNewPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->new_path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}




inline void Directory_LockFile_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, context_);
}




inline void Directory_SetOpenedFileLength_ParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, context_);
}


inline void Directory_SetOpenedFileLength_ResponseParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace storage

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_PARAMS_DATA_H_