// components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-params-data.h"
namespace paint_preview {
namespace mojom {

std::ostream& operator<<(std::ostream& os, PaintPreviewStatus value) {
  switch(value) {
    case PaintPreviewStatus::kOk:
      return os << "PaintPreviewStatus::kOk";
    case PaintPreviewStatus::kAlreadyCapturing:
      return os << "PaintPreviewStatus::kAlreadyCapturing";
    case PaintPreviewStatus::kCaptureFailed:
      return os << "PaintPreviewStatus::kCaptureFailed";
    case PaintPreviewStatus::kGuidCollision:
      return os << "PaintPreviewStatus::kGuidCollision";
    case PaintPreviewStatus::kFileCreationError:
      return os << "PaintPreviewStatus::kFileCreationError";
    case PaintPreviewStatus::kPartialSuccess:
      return os << "PaintPreviewStatus::kPartialSuccess";
    case PaintPreviewStatus::kFailed:
      return os << "PaintPreviewStatus::kFailed";
    default:
      return os << "Unknown PaintPreviewStatus value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool PaintPreviewCaptureParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaintPreviewCaptureParams_Data* object = static_cast<const PaintPreviewCaptureParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 48 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::paint_preview::mojom::internal::RecordingPersistence_Data
        ::Validate(object->persistence, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->guid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_rect, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip_rect, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

PaintPreviewCaptureParams_Data::PaintPreviewCaptureParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LinkData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LinkData_Data* object = static_cast<const LinkData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  return true;
}

LinkData_Data::LinkData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCaptureResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaintPreviewCaptureResponse_Data* object = static_cast<const PaintPreviewCaptureResponse_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 72 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->embedding_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_id_to_embedding_token, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams content_id_to_embedding_token_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->content_id_to_embedding_token, validation_context,
                                         &content_id_to_embedding_token_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->links, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams links_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->links, validation_context,
                                         &links_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blink_recording_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->blink_recording_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_offsets, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_offsets, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->skp, validation_context))
    return false;

  return true;
}

PaintPreviewCaptureResponse_Data::PaintPreviewCaptureResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewRecorder_CapturePaintPreview_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaintPreviewRecorder_CapturePaintPreview_Params_Data* object = static_cast<const PaintPreviewRecorder_CapturePaintPreview_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

PaintPreviewRecorder_CapturePaintPreview_Params_Data::PaintPreviewRecorder_CapturePaintPreview_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data* object = static_cast<const PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::paint_preview::mojom::internal::PaintPreviewStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace paint_preview