// components/network_hints/common/network_hints.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace network_hints {
namespace mojom {
namespace internal {
class  NetworkHintsHandler_PrefetchDNS_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetworkHintsHandler_PrefetchDNS_Params_Data));
      new (data()) NetworkHintsHandler_PrefetchDNS_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetworkHintsHandler_PrefetchDNS_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetworkHintsHandler_PrefetchDNS_Params_Data>(index_);
    }
    NetworkHintsHandler_PrefetchDNS_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> hostname_list;

 private:
  NetworkHintsHandler_PrefetchDNS_Params_Data();
  ~NetworkHintsHandler_PrefetchDNS_Params_Data() = delete;
};
static_assert(sizeof(NetworkHintsHandler_PrefetchDNS_Params_Data) == 16,
              "Bad sizeof(NetworkHintsHandler_PrefetchDNS_Params_Data)");
class  NetworkHintsHandler_Preconnect_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetworkHintsHandler_Preconnect_Params_Data));
      new (data()) NetworkHintsHandler_Preconnect_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetworkHintsHandler_Preconnect_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetworkHintsHandler_Preconnect_Params_Data>(index_);
    }
    NetworkHintsHandler_Preconnect_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  uint8_t allow_credentials : 1;
  uint8_t padfinal_[7];

 private:
  NetworkHintsHandler_Preconnect_Params_Data();
  ~NetworkHintsHandler_Preconnect_Params_Data() = delete;
};
static_assert(sizeof(NetworkHintsHandler_Preconnect_Params_Data) == 24,
              "Bad sizeof(NetworkHintsHandler_Preconnect_Params_Data)");

}  // namespace internal


class NetworkHintsHandler_PrefetchDNS_ParamsDataView {
 public:
  NetworkHintsHandler_PrefetchDNS_ParamsDataView() {}

  NetworkHintsHandler_PrefetchDNS_ParamsDataView(
      internal::NetworkHintsHandler_PrefetchDNS_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetHostnameListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHostnameList(UserType* output) {
    
    auto* pointer = data_->hostname_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
 private:
  internal::NetworkHintsHandler_PrefetchDNS_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NetworkHintsHandler_Preconnect_ParamsDataView {
 public:
  NetworkHintsHandler_Preconnect_ParamsDataView() {}

  NetworkHintsHandler_Preconnect_ParamsDataView(
      internal::NetworkHintsHandler_Preconnect_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  bool allow_credentials() const {
    return data_->allow_credentials;
  }
 private:
  internal::NetworkHintsHandler_Preconnect_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void NetworkHintsHandler_PrefetchDNS_ParamsDataView::GetHostnameListDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->hostname_list.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}


inline void NetworkHintsHandler_Preconnect_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace network_hints

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_PARAMS_DATA_H_