// cc/mojom/render_frame_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_SHARED_H_
#define CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "cc/mojom/render_frame_metadata.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/selection.mojom-shared.h"
#include "services/viz/public/mojom/compositing/vertical_scroll_direction.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace cc {
namespace mojom {
class RenderFrameMetadataDataView;



}  // namespace mojom
}  // namespace cc

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cc::mojom::RenderFrameMetadataDataView> {
  using Data = ::cc::mojom::internal::RenderFrameMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cc {
namespace mojom {
// Interface base classes. They are used for type safety check.
class RenderFrameMetadataObserverInterfaceBase {};

using RenderFrameMetadataObserverPtrDataView =
    mojo::InterfacePtrDataView<RenderFrameMetadataObserverInterfaceBase>;
using RenderFrameMetadataObserverRequestDataView =
    mojo::InterfaceRequestDataView<RenderFrameMetadataObserverInterfaceBase>;
using RenderFrameMetadataObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderFrameMetadataObserverInterfaceBase>;
using RenderFrameMetadataObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderFrameMetadataObserverInterfaceBase>;
class RenderFrameMetadataObserverClientInterfaceBase {};

using RenderFrameMetadataObserverClientPtrDataView =
    mojo::InterfacePtrDataView<RenderFrameMetadataObserverClientInterfaceBase>;
using RenderFrameMetadataObserverClientRequestDataView =
    mojo::InterfaceRequestDataView<RenderFrameMetadataObserverClientInterfaceBase>;
using RenderFrameMetadataObserverClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderFrameMetadataObserverClientInterfaceBase>;
using RenderFrameMetadataObserverClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderFrameMetadataObserverClientInterfaceBase>;


class RenderFrameMetadataDataView {
 public:
  RenderFrameMetadataDataView() {}

  RenderFrameMetadataDataView(
      internal::RenderFrameMetadata_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t root_background_color() const {
    return data_->root_background_color;
  }
  inline void GetRootScrollOffsetDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRootScrollOffset(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::Vector2dFDataView, UserType>(),
    "Attempting to read the optional `root_scroll_offset` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRootScrollOffset` instead "
    "of `ReadRootScrollOffset if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->root_scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, context_);
  }
  bool is_scroll_offset_at_top() const {
    return data_->is_scroll_offset_at_top;
  }
  inline void GetSelectionDataView(
      ::viz::mojom::SelectionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSelection(UserType* output) {
    
    auto* pointer = data_->selection.Get();
    return mojo::internal::Deserialize<::viz::mojom::SelectionDataView>(
        pointer, output, context_);
  }
  bool is_mobile_optimized() const {
    return data_->is_mobile_optimized;
  }
  bool has_delegated_ink_metadata() const {
    return data_->has_delegated_ink_metadata;
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  inline void GetViewportSizeInPixelsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViewportSizeInPixels(UserType* output) {
    
    auto* pointer = data_->viewport_size_in_pixels.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLocalSurfaceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LocalSurfaceIdDataView, UserType>(),
    "Attempting to read the optional `local_surface_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalSurfaceId` instead "
    "of `ReadLocalSurfaceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, context_);
  }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  float external_page_scale_factor() const {
    return data_->external_page_scale_factor;
  }
  float top_controls_height() const {
    return data_->top_controls_height;
  }
  float top_controls_shown_ratio() const {
    return data_->top_controls_shown_ratio;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNewVerticalScrollDirection(UserType* output) const {
    auto data_value = data_->new_vertical_scroll_direction;
    return mojo::internal::Deserialize<::viz::mojom::VerticalScrollDirection>(
        data_value, output);
  }

  ::viz::mojom::VerticalScrollDirection new_vertical_scroll_direction() const {
    return static_cast<::viz::mojom::VerticalScrollDirection>(data_->new_vertical_scroll_direction);
  }
  float bottom_controls_height() const {
    return data_->bottom_controls_height;
  }
  float bottom_controls_shown_ratio() const {
    return data_->bottom_controls_shown_ratio;
  }
  float top_controls_min_height_offset() const {
    return data_->top_controls_min_height_offset;
  }
  float bottom_controls_min_height_offset() const {
    return data_->bottom_controls_min_height_offset;
  }
  float min_page_scale_factor() const {
    return data_->min_page_scale_factor;
  }
  float max_page_scale_factor() const {
    return data_->max_page_scale_factor;
  }
  bool root_overflow_y_hidden() const {
    return data_->root_overflow_y_hidden;
  }
  inline void GetScrollableViewportSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScrollableViewportSize(UserType* output) {
    
    auto* pointer = data_->scrollable_viewport_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, context_);
  }
  inline void GetRootLayerSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRootLayerSize(UserType* output) {
    
    auto* pointer = data_->root_layer_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, context_);
  }
  bool has_transparent_background() const {
    return data_->has_transparent_background;
  }
 private:
  internal::RenderFrameMetadata_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace cc

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::RenderFrameMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::RenderFrameMetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::cc::mojom::internal::RenderFrameMetadata_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->root_background_color = Traits::root_background_color(input);
    decltype(Traits::root_scroll_offset(input)) in_root_scroll_offset = Traits::root_scroll_offset(input);
    typename decltype((*output)->root_scroll_offset)::BaseType::BufferWriter
        root_scroll_offset_writer;
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_root_scroll_offset, buffer, &root_scroll_offset_writer, context);
    (*output)->root_scroll_offset.Set(
        root_scroll_offset_writer.is_null() ? nullptr : root_scroll_offset_writer.data());
    (*output)->is_scroll_offset_at_top = Traits::is_scroll_offset_at_top(input);
    decltype(Traits::selection(input)) in_selection = Traits::selection(input);
    typename decltype((*output)->selection)::BaseType::BufferWriter
        selection_writer;
    mojo::internal::Serialize<::viz::mojom::SelectionDataView>(
        in_selection, buffer, &selection_writer, context);
    (*output)->selection.Set(
        selection_writer.is_null() ? nullptr : selection_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->selection.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selection in RenderFrameMetadata struct");
    (*output)->is_mobile_optimized = Traits::is_mobile_optimized(input);
    (*output)->has_delegated_ink_metadata = Traits::has_delegated_ink_metadata(input);
    (*output)->device_scale_factor = Traits::device_scale_factor(input);
    decltype(Traits::viewport_size_in_pixels(input)) in_viewport_size_in_pixels = Traits::viewport_size_in_pixels(input);
    typename decltype((*output)->viewport_size_in_pixels)::BaseType::BufferWriter
        viewport_size_in_pixels_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_viewport_size_in_pixels, buffer, &viewport_size_in_pixels_writer, context);
    (*output)->viewport_size_in_pixels.Set(
        viewport_size_in_pixels_writer.is_null() ? nullptr : viewport_size_in_pixels_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->viewport_size_in_pixels.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport_size_in_pixels in RenderFrameMetadata struct");
    decltype(Traits::local_surface_id(input)) in_local_surface_id = Traits::local_surface_id(input);
    typename decltype((*output)->local_surface_id)::BaseType::BufferWriter
        local_surface_id_writer;
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
        in_local_surface_id, buffer, &local_surface_id_writer, context);
    (*output)->local_surface_id.Set(
        local_surface_id_writer.is_null() ? nullptr : local_surface_id_writer.data());
    (*output)->page_scale_factor = Traits::page_scale_factor(input);
    (*output)->external_page_scale_factor = Traits::external_page_scale_factor(input);
    (*output)->top_controls_height = Traits::top_controls_height(input);
    (*output)->top_controls_shown_ratio = Traits::top_controls_shown_ratio(input);
    mojo::internal::Serialize<::viz::mojom::VerticalScrollDirection>(
        Traits::new_vertical_scroll_direction(input), &(*output)->new_vertical_scroll_direction);
    (*output)->bottom_controls_height = Traits::bottom_controls_height(input);
    (*output)->bottom_controls_shown_ratio = Traits::bottom_controls_shown_ratio(input);
    (*output)->top_controls_min_height_offset = Traits::top_controls_min_height_offset(input);
    (*output)->bottom_controls_min_height_offset = Traits::bottom_controls_min_height_offset(input);
    (*output)->min_page_scale_factor = Traits::min_page_scale_factor(input);
    (*output)->max_page_scale_factor = Traits::max_page_scale_factor(input);
    (*output)->root_overflow_y_hidden = Traits::root_overflow_y_hidden(input);
    decltype(Traits::scrollable_viewport_size(input)) in_scrollable_viewport_size = Traits::scrollable_viewport_size(input);
    typename decltype((*output)->scrollable_viewport_size)::BaseType::BufferWriter
        scrollable_viewport_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
        in_scrollable_viewport_size, buffer, &scrollable_viewport_size_writer, context);
    (*output)->scrollable_viewport_size.Set(
        scrollable_viewport_size_writer.is_null() ? nullptr : scrollable_viewport_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->scrollable_viewport_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scrollable_viewport_size in RenderFrameMetadata struct");
    decltype(Traits::root_layer_size(input)) in_root_layer_size = Traits::root_layer_size(input);
    typename decltype((*output)->root_layer_size)::BaseType::BufferWriter
        root_layer_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
        in_root_layer_size, buffer, &root_layer_size_writer, context);
    (*output)->root_layer_size.Set(
        root_layer_size_writer.is_null() ? nullptr : root_layer_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->root_layer_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_layer_size in RenderFrameMetadata struct");
    (*output)->has_transparent_background = Traits::has_transparent_background(input);
  }

  static bool Deserialize(::cc::mojom::internal::RenderFrameMetadata_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cc::mojom::RenderFrameMetadataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cc {
namespace mojom {

inline void RenderFrameMetadataDataView::GetRootScrollOffsetDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->root_scroll_offset.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, context_);
}
inline void RenderFrameMetadataDataView::GetSelectionDataView(
    ::viz::mojom::SelectionDataView* output) {
  auto pointer = data_->selection.Get();
  *output = ::viz::mojom::SelectionDataView(pointer, context_);
}
inline void RenderFrameMetadataDataView::GetViewportSizeInPixelsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->viewport_size_in_pixels.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void RenderFrameMetadataDataView::GetLocalSurfaceIdDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->local_surface_id.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, context_);
}
inline void RenderFrameMetadataDataView::GetScrollableViewportSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->scrollable_viewport_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, context_);
}
inline void RenderFrameMetadataDataView::GetRootLayerSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->root_layer_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace cc

#endif  // CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_SHARED_H_