// Copyright (c) 2022 Proton Technologies AG
//
// This file is part of ProtonMail Bridge.
//
// ProtonMail Bridge is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// ProtonMail Bridge is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with ProtonMail Bridge.  If not, see <https://www.gnu.org/licenses/>.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v3.21.12
// source: bridge.proto

package grpc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Bridge_CheckTokens_FullMethodName                     = "/grpc.Bridge/CheckTokens"
	Bridge_AddLogEntry_FullMethodName                     = "/grpc.Bridge/AddLogEntry"
	Bridge_GuiReady_FullMethodName                        = "/grpc.Bridge/GuiReady"
	Bridge_Quit_FullMethodName                            = "/grpc.Bridge/Quit"
	Bridge_Restart_FullMethodName                         = "/grpc.Bridge/Restart"
	Bridge_ShowOnStartup_FullMethodName                   = "/grpc.Bridge/ShowOnStartup"
	Bridge_SetIsAutostartOn_FullMethodName                = "/grpc.Bridge/SetIsAutostartOn"
	Bridge_IsAutostartOn_FullMethodName                   = "/grpc.Bridge/IsAutostartOn"
	Bridge_SetIsBetaEnabled_FullMethodName                = "/grpc.Bridge/SetIsBetaEnabled"
	Bridge_IsBetaEnabled_FullMethodName                   = "/grpc.Bridge/IsBetaEnabled"
	Bridge_SetIsAllMailVisible_FullMethodName             = "/grpc.Bridge/SetIsAllMailVisible"
	Bridge_IsAllMailVisible_FullMethodName                = "/grpc.Bridge/IsAllMailVisible"
	Bridge_SetIsTelemetryDisabled_FullMethodName          = "/grpc.Bridge/SetIsTelemetryDisabled"
	Bridge_IsTelemetryDisabled_FullMethodName             = "/grpc.Bridge/IsTelemetryDisabled"
	Bridge_GoOs_FullMethodName                            = "/grpc.Bridge/GoOs"
	Bridge_TriggerReset_FullMethodName                    = "/grpc.Bridge/TriggerReset"
	Bridge_Version_FullMethodName                         = "/grpc.Bridge/Version"
	Bridge_LogsPath_FullMethodName                        = "/grpc.Bridge/LogsPath"
	Bridge_LicensePath_FullMethodName                     = "/grpc.Bridge/LicensePath"
	Bridge_ReleaseNotesPageLink_FullMethodName            = "/grpc.Bridge/ReleaseNotesPageLink"
	Bridge_DependencyLicensesLink_FullMethodName          = "/grpc.Bridge/DependencyLicensesLink"
	Bridge_LandingPageLink_FullMethodName                 = "/grpc.Bridge/LandingPageLink"
	Bridge_SetColorSchemeName_FullMethodName              = "/grpc.Bridge/SetColorSchemeName"
	Bridge_ColorSchemeName_FullMethodName                 = "/grpc.Bridge/ColorSchemeName"
	Bridge_CurrentEmailClient_FullMethodName              = "/grpc.Bridge/CurrentEmailClient"
	Bridge_ReportBug_FullMethodName                       = "/grpc.Bridge/ReportBug"
	Bridge_ForceLauncher_FullMethodName                   = "/grpc.Bridge/ForceLauncher"
	Bridge_SetMainExecutable_FullMethodName               = "/grpc.Bridge/SetMainExecutable"
	Bridge_RequestKnowledgeBaseSuggestions_FullMethodName = "/grpc.Bridge/RequestKnowledgeBaseSuggestions"
	Bridge_Login_FullMethodName                           = "/grpc.Bridge/Login"
	Bridge_Login2FA_FullMethodName                        = "/grpc.Bridge/Login2FA"
	Bridge_Login2Passwords_FullMethodName                 = "/grpc.Bridge/Login2Passwords"
	Bridge_LoginAbort_FullMethodName                      = "/grpc.Bridge/LoginAbort"
	Bridge_CheckUpdate_FullMethodName                     = "/grpc.Bridge/CheckUpdate"
	Bridge_InstallUpdate_FullMethodName                   = "/grpc.Bridge/InstallUpdate"
	Bridge_SetIsAutomaticUpdateOn_FullMethodName          = "/grpc.Bridge/SetIsAutomaticUpdateOn"
	Bridge_IsAutomaticUpdateOn_FullMethodName             = "/grpc.Bridge/IsAutomaticUpdateOn"
	Bridge_DiskCachePath_FullMethodName                   = "/grpc.Bridge/DiskCachePath"
	Bridge_SetDiskCachePath_FullMethodName                = "/grpc.Bridge/SetDiskCachePath"
	Bridge_SetIsDoHEnabled_FullMethodName                 = "/grpc.Bridge/SetIsDoHEnabled"
	Bridge_IsDoHEnabled_FullMethodName                    = "/grpc.Bridge/IsDoHEnabled"
	Bridge_MailServerSettings_FullMethodName              = "/grpc.Bridge/MailServerSettings"
	Bridge_SetMailServerSettings_FullMethodName           = "/grpc.Bridge/SetMailServerSettings"
	Bridge_Hostname_FullMethodName                        = "/grpc.Bridge/Hostname"
	Bridge_IsPortFree_FullMethodName                      = "/grpc.Bridge/IsPortFree"
	Bridge_AvailableKeychains_FullMethodName              = "/grpc.Bridge/AvailableKeychains"
	Bridge_SetCurrentKeychain_FullMethodName              = "/grpc.Bridge/SetCurrentKeychain"
	Bridge_CurrentKeychain_FullMethodName                 = "/grpc.Bridge/CurrentKeychain"
	Bridge_GetUserList_FullMethodName                     = "/grpc.Bridge/GetUserList"
	Bridge_GetUser_FullMethodName                         = "/grpc.Bridge/GetUser"
	Bridge_SetUserSplitMode_FullMethodName                = "/grpc.Bridge/SetUserSplitMode"
	Bridge_SendBadEventUserFeedback_FullMethodName        = "/grpc.Bridge/SendBadEventUserFeedback"
	Bridge_LogoutUser_FullMethodName                      = "/grpc.Bridge/LogoutUser"
	Bridge_RemoveUser_FullMethodName                      = "/grpc.Bridge/RemoveUser"
	Bridge_ConfigureUserAppleMail_FullMethodName          = "/grpc.Bridge/ConfigureUserAppleMail"
	Bridge_IsTLSCertificateInstalled_FullMethodName       = "/grpc.Bridge/IsTLSCertificateInstalled"
	Bridge_InstallTLSCertificate_FullMethodName           = "/grpc.Bridge/InstallTLSCertificate"
	Bridge_ExportTLSCertificates_FullMethodName           = "/grpc.Bridge/ExportTLSCertificates"
	Bridge_RunEventStream_FullMethodName                  = "/grpc.Bridge/RunEventStream"
	Bridge_StopEventStream_FullMethodName                 = "/grpc.Bridge/StopEventStream"
	Bridge_TriggerRepair_FullMethodName                   = "/grpc.Bridge/TriggerRepair"
)

// BridgeClient is the client API for Bridge service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BridgeClient interface {
	// App related calls
	CheckTokens(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	AddLogEntry(ctx context.Context, in *AddLogEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	GuiReady(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GuiReadyResponse, error)
	Quit(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	Restart(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	ShowOnStartup(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error)
	SetIsAutostartOn(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	IsAutostartOn(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error)
	SetIsBetaEnabled(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	IsBetaEnabled(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error)
	SetIsAllMailVisible(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	IsAllMailVisible(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error)
	SetIsTelemetryDisabled(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	IsTelemetryDisabled(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error)
	GoOs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	TriggerReset(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	Version(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	LogsPath(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	LicensePath(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	ReleaseNotesPageLink(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	DependencyLicensesLink(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	LandingPageLink(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	SetColorSchemeName(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	ColorSchemeName(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	CurrentEmailClient(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	ReportBug(ctx context.Context, in *ReportBugRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	ForceLauncher(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	SetMainExecutable(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	RequestKnowledgeBaseSuggestions(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// login
	Login(ctx context.Context, in *LoginRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	Login2FA(ctx context.Context, in *LoginRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	Login2Passwords(ctx context.Context, in *LoginRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	LoginAbort(ctx context.Context, in *LoginAbortRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// update
	CheckUpdate(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	InstallUpdate(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	SetIsAutomaticUpdateOn(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	IsAutomaticUpdateOn(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error)
	// cache
	DiskCachePath(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	SetDiskCachePath(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// mail
	SetIsDoHEnabled(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	IsDoHEnabled(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error)
	MailServerSettings(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ImapSmtpSettings, error)
	SetMailServerSettings(ctx context.Context, in *ImapSmtpSettings, opts ...grpc.CallOption) (*emptypb.Empty, error)
	Hostname(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	IsPortFree(ctx context.Context, in *wrapperspb.Int32Value, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error)
	// keychain
	AvailableKeychains(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*AvailableKeychainsResponse, error)
	SetCurrentKeychain(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	CurrentKeychain(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	// User & user list
	GetUserList(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*UserListResponse, error)
	GetUser(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*User, error)
	SetUserSplitMode(ctx context.Context, in *UserSplitModeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	SendBadEventUserFeedback(ctx context.Context, in *UserBadEventFeedbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	LogoutUser(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	RemoveUser(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	ConfigureUserAppleMail(ctx context.Context, in *ConfigureAppleMailRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// TLS certificate related calls
	IsTLSCertificateInstalled(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error)
	InstallTLSCertificate(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	ExportTLSCertificates(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Server -> Client event stream
	RunEventStream(ctx context.Context, in *EventStreamRequest, opts ...grpc.CallOption) (Bridge_RunEventStreamClient, error)
	StopEventStream(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Repair
	TriggerRepair(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type bridgeClient struct {
	cc grpc.ClientConnInterface
}

func NewBridgeClient(cc grpc.ClientConnInterface) BridgeClient {
	return &bridgeClient{cc}
}

func (c *bridgeClient) CheckTokens(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_CheckTokens_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) AddLogEntry(ctx context.Context, in *AddLogEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_AddLogEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) GuiReady(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GuiReadyResponse, error) {
	out := new(GuiReadyResponse)
	err := c.cc.Invoke(ctx, Bridge_GuiReady_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) Quit(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_Quit_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) Restart(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_Restart_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) ShowOnStartup(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error) {
	out := new(wrapperspb.BoolValue)
	err := c.cc.Invoke(ctx, Bridge_ShowOnStartup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetIsAutostartOn(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetIsAutostartOn_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) IsAutostartOn(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error) {
	out := new(wrapperspb.BoolValue)
	err := c.cc.Invoke(ctx, Bridge_IsAutostartOn_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetIsBetaEnabled(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetIsBetaEnabled_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) IsBetaEnabled(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error) {
	out := new(wrapperspb.BoolValue)
	err := c.cc.Invoke(ctx, Bridge_IsBetaEnabled_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetIsAllMailVisible(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetIsAllMailVisible_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) IsAllMailVisible(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error) {
	out := new(wrapperspb.BoolValue)
	err := c.cc.Invoke(ctx, Bridge_IsAllMailVisible_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetIsTelemetryDisabled(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetIsTelemetryDisabled_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) IsTelemetryDisabled(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error) {
	out := new(wrapperspb.BoolValue)
	err := c.cc.Invoke(ctx, Bridge_IsTelemetryDisabled_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) GoOs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_GoOs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) TriggerReset(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_TriggerReset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) Version(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_Version_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) LogsPath(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_LogsPath_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) LicensePath(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_LicensePath_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) ReleaseNotesPageLink(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_ReleaseNotesPageLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) DependencyLicensesLink(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_DependencyLicensesLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) LandingPageLink(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_LandingPageLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetColorSchemeName(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetColorSchemeName_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) ColorSchemeName(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_ColorSchemeName_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) CurrentEmailClient(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_CurrentEmailClient_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) ReportBug(ctx context.Context, in *ReportBugRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_ReportBug_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) ForceLauncher(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_ForceLauncher_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetMainExecutable(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetMainExecutable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) RequestKnowledgeBaseSuggestions(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_RequestKnowledgeBaseSuggestions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) Login(ctx context.Context, in *LoginRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_Login_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) Login2FA(ctx context.Context, in *LoginRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_Login2FA_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) Login2Passwords(ctx context.Context, in *LoginRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_Login2Passwords_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) LoginAbort(ctx context.Context, in *LoginAbortRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_LoginAbort_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) CheckUpdate(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_CheckUpdate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) InstallUpdate(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_InstallUpdate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetIsAutomaticUpdateOn(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetIsAutomaticUpdateOn_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) IsAutomaticUpdateOn(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error) {
	out := new(wrapperspb.BoolValue)
	err := c.cc.Invoke(ctx, Bridge_IsAutomaticUpdateOn_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) DiskCachePath(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_DiskCachePath_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetDiskCachePath(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetDiskCachePath_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetIsDoHEnabled(ctx context.Context, in *wrapperspb.BoolValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetIsDoHEnabled_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) IsDoHEnabled(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error) {
	out := new(wrapperspb.BoolValue)
	err := c.cc.Invoke(ctx, Bridge_IsDoHEnabled_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) MailServerSettings(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ImapSmtpSettings, error) {
	out := new(ImapSmtpSettings)
	err := c.cc.Invoke(ctx, Bridge_MailServerSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetMailServerSettings(ctx context.Context, in *ImapSmtpSettings, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetMailServerSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) Hostname(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_Hostname_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) IsPortFree(ctx context.Context, in *wrapperspb.Int32Value, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error) {
	out := new(wrapperspb.BoolValue)
	err := c.cc.Invoke(ctx, Bridge_IsPortFree_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) AvailableKeychains(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*AvailableKeychainsResponse, error) {
	out := new(AvailableKeychainsResponse)
	err := c.cc.Invoke(ctx, Bridge_AvailableKeychains_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetCurrentKeychain(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetCurrentKeychain_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) CurrentKeychain(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, Bridge_CurrentKeychain_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) GetUserList(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*UserListResponse, error) {
	out := new(UserListResponse)
	err := c.cc.Invoke(ctx, Bridge_GetUserList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) GetUser(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, Bridge_GetUser_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SetUserSplitMode(ctx context.Context, in *UserSplitModeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SetUserSplitMode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) SendBadEventUserFeedback(ctx context.Context, in *UserBadEventFeedbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_SendBadEventUserFeedback_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) LogoutUser(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_LogoutUser_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) RemoveUser(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_RemoveUser_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) ConfigureUserAppleMail(ctx context.Context, in *ConfigureAppleMailRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_ConfigureUserAppleMail_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) IsTLSCertificateInstalled(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*wrapperspb.BoolValue, error) {
	out := new(wrapperspb.BoolValue)
	err := c.cc.Invoke(ctx, Bridge_IsTLSCertificateInstalled_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) InstallTLSCertificate(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_InstallTLSCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) ExportTLSCertificates(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_ExportTLSCertificates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) RunEventStream(ctx context.Context, in *EventStreamRequest, opts ...grpc.CallOption) (Bridge_RunEventStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &Bridge_ServiceDesc.Streams[0], Bridge_RunEventStream_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &bridgeRunEventStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Bridge_RunEventStreamClient interface {
	Recv() (*StreamEvent, error)
	grpc.ClientStream
}

type bridgeRunEventStreamClient struct {
	grpc.ClientStream
}

func (x *bridgeRunEventStreamClient) Recv() (*StreamEvent, error) {
	m := new(StreamEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bridgeClient) StopEventStream(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_StopEventStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bridgeClient) TriggerRepair(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Bridge_TriggerRepair_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BridgeServer is the server API for Bridge service.
// All implementations must embed UnimplementedBridgeServer
// for forward compatibility
type BridgeServer interface {
	// App related calls
	CheckTokens(context.Context, *wrapperspb.StringValue) (*wrapperspb.StringValue, error)
	AddLogEntry(context.Context, *AddLogEntryRequest) (*emptypb.Empty, error)
	GuiReady(context.Context, *emptypb.Empty) (*GuiReadyResponse, error)
	Quit(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	Restart(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	ShowOnStartup(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error)
	SetIsAutostartOn(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error)
	IsAutostartOn(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error)
	SetIsBetaEnabled(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error)
	IsBetaEnabled(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error)
	SetIsAllMailVisible(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error)
	IsAllMailVisible(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error)
	SetIsTelemetryDisabled(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error)
	IsTelemetryDisabled(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error)
	GoOs(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	TriggerReset(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	Version(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	LogsPath(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	LicensePath(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	ReleaseNotesPageLink(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	DependencyLicensesLink(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	LandingPageLink(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	SetColorSchemeName(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	ColorSchemeName(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	CurrentEmailClient(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	ReportBug(context.Context, *ReportBugRequest) (*emptypb.Empty, error)
	ForceLauncher(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	SetMainExecutable(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	RequestKnowledgeBaseSuggestions(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	// login
	Login(context.Context, *LoginRequest) (*emptypb.Empty, error)
	Login2FA(context.Context, *LoginRequest) (*emptypb.Empty, error)
	Login2Passwords(context.Context, *LoginRequest) (*emptypb.Empty, error)
	LoginAbort(context.Context, *LoginAbortRequest) (*emptypb.Empty, error)
	// update
	CheckUpdate(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	InstallUpdate(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	SetIsAutomaticUpdateOn(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error)
	IsAutomaticUpdateOn(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error)
	// cache
	DiskCachePath(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	SetDiskCachePath(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	// mail
	SetIsDoHEnabled(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error)
	IsDoHEnabled(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error)
	MailServerSettings(context.Context, *emptypb.Empty) (*ImapSmtpSettings, error)
	SetMailServerSettings(context.Context, *ImapSmtpSettings) (*emptypb.Empty, error)
	Hostname(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	IsPortFree(context.Context, *wrapperspb.Int32Value) (*wrapperspb.BoolValue, error)
	// keychain
	AvailableKeychains(context.Context, *emptypb.Empty) (*AvailableKeychainsResponse, error)
	SetCurrentKeychain(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	CurrentKeychain(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error)
	// User & user list
	GetUserList(context.Context, *emptypb.Empty) (*UserListResponse, error)
	GetUser(context.Context, *wrapperspb.StringValue) (*User, error)
	SetUserSplitMode(context.Context, *UserSplitModeRequest) (*emptypb.Empty, error)
	SendBadEventUserFeedback(context.Context, *UserBadEventFeedbackRequest) (*emptypb.Empty, error)
	LogoutUser(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	RemoveUser(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	ConfigureUserAppleMail(context.Context, *ConfigureAppleMailRequest) (*emptypb.Empty, error)
	// TLS certificate related calls
	IsTLSCertificateInstalled(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error)
	InstallTLSCertificate(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	ExportTLSCertificates(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	// Server -> Client event stream
	RunEventStream(*EventStreamRequest, Bridge_RunEventStreamServer) error
	StopEventStream(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	// Repair
	TriggerRepair(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	mustEmbedUnimplementedBridgeServer()
}

// UnimplementedBridgeServer must be embedded to have forward compatible implementations.
type UnimplementedBridgeServer struct {
}

func (UnimplementedBridgeServer) CheckTokens(context.Context, *wrapperspb.StringValue) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckTokens not implemented")
}
func (UnimplementedBridgeServer) AddLogEntry(context.Context, *AddLogEntryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddLogEntry not implemented")
}
func (UnimplementedBridgeServer) GuiReady(context.Context, *emptypb.Empty) (*GuiReadyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GuiReady not implemented")
}
func (UnimplementedBridgeServer) Quit(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Quit not implemented")
}
func (UnimplementedBridgeServer) Restart(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Restart not implemented")
}
func (UnimplementedBridgeServer) ShowOnStartup(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ShowOnStartup not implemented")
}
func (UnimplementedBridgeServer) SetIsAutostartOn(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIsAutostartOn not implemented")
}
func (UnimplementedBridgeServer) IsAutostartOn(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsAutostartOn not implemented")
}
func (UnimplementedBridgeServer) SetIsBetaEnabled(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIsBetaEnabled not implemented")
}
func (UnimplementedBridgeServer) IsBetaEnabled(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsBetaEnabled not implemented")
}
func (UnimplementedBridgeServer) SetIsAllMailVisible(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIsAllMailVisible not implemented")
}
func (UnimplementedBridgeServer) IsAllMailVisible(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsAllMailVisible not implemented")
}
func (UnimplementedBridgeServer) SetIsTelemetryDisabled(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIsTelemetryDisabled not implemented")
}
func (UnimplementedBridgeServer) IsTelemetryDisabled(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsTelemetryDisabled not implemented")
}
func (UnimplementedBridgeServer) GoOs(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GoOs not implemented")
}
func (UnimplementedBridgeServer) TriggerReset(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TriggerReset not implemented")
}
func (UnimplementedBridgeServer) Version(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Version not implemented")
}
func (UnimplementedBridgeServer) LogsPath(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LogsPath not implemented")
}
func (UnimplementedBridgeServer) LicensePath(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LicensePath not implemented")
}
func (UnimplementedBridgeServer) ReleaseNotesPageLink(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReleaseNotesPageLink not implemented")
}
func (UnimplementedBridgeServer) DependencyLicensesLink(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DependencyLicensesLink not implemented")
}
func (UnimplementedBridgeServer) LandingPageLink(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LandingPageLink not implemented")
}
func (UnimplementedBridgeServer) SetColorSchemeName(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetColorSchemeName not implemented")
}
func (UnimplementedBridgeServer) ColorSchemeName(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ColorSchemeName not implemented")
}
func (UnimplementedBridgeServer) CurrentEmailClient(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CurrentEmailClient not implemented")
}
func (UnimplementedBridgeServer) ReportBug(context.Context, *ReportBugRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportBug not implemented")
}
func (UnimplementedBridgeServer) ForceLauncher(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForceLauncher not implemented")
}
func (UnimplementedBridgeServer) SetMainExecutable(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMainExecutable not implemented")
}
func (UnimplementedBridgeServer) RequestKnowledgeBaseSuggestions(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RequestKnowledgeBaseSuggestions not implemented")
}
func (UnimplementedBridgeServer) Login(context.Context, *LoginRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Login not implemented")
}
func (UnimplementedBridgeServer) Login2FA(context.Context, *LoginRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Login2FA not implemented")
}
func (UnimplementedBridgeServer) Login2Passwords(context.Context, *LoginRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Login2Passwords not implemented")
}
func (UnimplementedBridgeServer) LoginAbort(context.Context, *LoginAbortRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoginAbort not implemented")
}
func (UnimplementedBridgeServer) CheckUpdate(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckUpdate not implemented")
}
func (UnimplementedBridgeServer) InstallUpdate(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InstallUpdate not implemented")
}
func (UnimplementedBridgeServer) SetIsAutomaticUpdateOn(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIsAutomaticUpdateOn not implemented")
}
func (UnimplementedBridgeServer) IsAutomaticUpdateOn(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsAutomaticUpdateOn not implemented")
}
func (UnimplementedBridgeServer) DiskCachePath(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiskCachePath not implemented")
}
func (UnimplementedBridgeServer) SetDiskCachePath(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDiskCachePath not implemented")
}
func (UnimplementedBridgeServer) SetIsDoHEnabled(context.Context, *wrapperspb.BoolValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIsDoHEnabled not implemented")
}
func (UnimplementedBridgeServer) IsDoHEnabled(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsDoHEnabled not implemented")
}
func (UnimplementedBridgeServer) MailServerSettings(context.Context, *emptypb.Empty) (*ImapSmtpSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MailServerSettings not implemented")
}
func (UnimplementedBridgeServer) SetMailServerSettings(context.Context, *ImapSmtpSettings) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMailServerSettings not implemented")
}
func (UnimplementedBridgeServer) Hostname(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Hostname not implemented")
}
func (UnimplementedBridgeServer) IsPortFree(context.Context, *wrapperspb.Int32Value) (*wrapperspb.BoolValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsPortFree not implemented")
}
func (UnimplementedBridgeServer) AvailableKeychains(context.Context, *emptypb.Empty) (*AvailableKeychainsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AvailableKeychains not implemented")
}
func (UnimplementedBridgeServer) SetCurrentKeychain(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetCurrentKeychain not implemented")
}
func (UnimplementedBridgeServer) CurrentKeychain(context.Context, *emptypb.Empty) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CurrentKeychain not implemented")
}
func (UnimplementedBridgeServer) GetUserList(context.Context, *emptypb.Empty) (*UserListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserList not implemented")
}
func (UnimplementedBridgeServer) GetUser(context.Context, *wrapperspb.StringValue) (*User, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUser not implemented")
}
func (UnimplementedBridgeServer) SetUserSplitMode(context.Context, *UserSplitModeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetUserSplitMode not implemented")
}
func (UnimplementedBridgeServer) SendBadEventUserFeedback(context.Context, *UserBadEventFeedbackRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendBadEventUserFeedback not implemented")
}
func (UnimplementedBridgeServer) LogoutUser(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LogoutUser not implemented")
}
func (UnimplementedBridgeServer) RemoveUser(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveUser not implemented")
}
func (UnimplementedBridgeServer) ConfigureUserAppleMail(context.Context, *ConfigureAppleMailRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureUserAppleMail not implemented")
}
func (UnimplementedBridgeServer) IsTLSCertificateInstalled(context.Context, *emptypb.Empty) (*wrapperspb.BoolValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsTLSCertificateInstalled not implemented")
}
func (UnimplementedBridgeServer) InstallTLSCertificate(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InstallTLSCertificate not implemented")
}
func (UnimplementedBridgeServer) ExportTLSCertificates(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportTLSCertificates not implemented")
}
func (UnimplementedBridgeServer) RunEventStream(*EventStreamRequest, Bridge_RunEventStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method RunEventStream not implemented")
}
func (UnimplementedBridgeServer) StopEventStream(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopEventStream not implemented")
}
func (UnimplementedBridgeServer) TriggerRepair(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TriggerRepair not implemented")
}
func (UnimplementedBridgeServer) mustEmbedUnimplementedBridgeServer() {}

// UnsafeBridgeServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BridgeServer will
// result in compilation errors.
type UnsafeBridgeServer interface {
	mustEmbedUnimplementedBridgeServer()
}

func RegisterBridgeServer(s grpc.ServiceRegistrar, srv BridgeServer) {
	s.RegisterService(&Bridge_ServiceDesc, srv)
}

func _Bridge_CheckTokens_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).CheckTokens(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_CheckTokens_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).CheckTokens(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_AddLogEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddLogEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).AddLogEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_AddLogEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).AddLogEntry(ctx, req.(*AddLogEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_GuiReady_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).GuiReady(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_GuiReady_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).GuiReady(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_Quit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).Quit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_Quit_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).Quit(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_Restart_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).Restart(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_Restart_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).Restart(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_ShowOnStartup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).ShowOnStartup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_ShowOnStartup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).ShowOnStartup(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetIsAutostartOn_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.BoolValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetIsAutostartOn(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetIsAutostartOn_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetIsAutostartOn(ctx, req.(*wrapperspb.BoolValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_IsAutostartOn_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).IsAutostartOn(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_IsAutostartOn_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).IsAutostartOn(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetIsBetaEnabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.BoolValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetIsBetaEnabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetIsBetaEnabled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetIsBetaEnabled(ctx, req.(*wrapperspb.BoolValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_IsBetaEnabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).IsBetaEnabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_IsBetaEnabled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).IsBetaEnabled(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetIsAllMailVisible_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.BoolValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetIsAllMailVisible(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetIsAllMailVisible_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetIsAllMailVisible(ctx, req.(*wrapperspb.BoolValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_IsAllMailVisible_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).IsAllMailVisible(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_IsAllMailVisible_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).IsAllMailVisible(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetIsTelemetryDisabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.BoolValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetIsTelemetryDisabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetIsTelemetryDisabled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetIsTelemetryDisabled(ctx, req.(*wrapperspb.BoolValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_IsTelemetryDisabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).IsTelemetryDisabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_IsTelemetryDisabled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).IsTelemetryDisabled(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_GoOs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).GoOs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_GoOs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).GoOs(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_TriggerReset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).TriggerReset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_TriggerReset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).TriggerReset(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_Version_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).Version(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_Version_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).Version(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_LogsPath_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).LogsPath(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_LogsPath_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).LogsPath(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_LicensePath_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).LicensePath(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_LicensePath_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).LicensePath(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_ReleaseNotesPageLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).ReleaseNotesPageLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_ReleaseNotesPageLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).ReleaseNotesPageLink(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_DependencyLicensesLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).DependencyLicensesLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_DependencyLicensesLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).DependencyLicensesLink(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_LandingPageLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).LandingPageLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_LandingPageLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).LandingPageLink(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetColorSchemeName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetColorSchemeName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetColorSchemeName_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetColorSchemeName(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_ColorSchemeName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).ColorSchemeName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_ColorSchemeName_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).ColorSchemeName(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_CurrentEmailClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).CurrentEmailClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_CurrentEmailClient_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).CurrentEmailClient(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_ReportBug_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportBugRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).ReportBug(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_ReportBug_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).ReportBug(ctx, req.(*ReportBugRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_ForceLauncher_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).ForceLauncher(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_ForceLauncher_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).ForceLauncher(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetMainExecutable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetMainExecutable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetMainExecutable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetMainExecutable(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_RequestKnowledgeBaseSuggestions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).RequestKnowledgeBaseSuggestions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_RequestKnowledgeBaseSuggestions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).RequestKnowledgeBaseSuggestions(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_Login_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoginRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).Login(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_Login_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).Login(ctx, req.(*LoginRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_Login2FA_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoginRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).Login2FA(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_Login2FA_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).Login2FA(ctx, req.(*LoginRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_Login2Passwords_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoginRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).Login2Passwords(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_Login2Passwords_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).Login2Passwords(ctx, req.(*LoginRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_LoginAbort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoginAbortRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).LoginAbort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_LoginAbort_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).LoginAbort(ctx, req.(*LoginAbortRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_CheckUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).CheckUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_CheckUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).CheckUpdate(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_InstallUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).InstallUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_InstallUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).InstallUpdate(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetIsAutomaticUpdateOn_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.BoolValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetIsAutomaticUpdateOn(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetIsAutomaticUpdateOn_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetIsAutomaticUpdateOn(ctx, req.(*wrapperspb.BoolValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_IsAutomaticUpdateOn_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).IsAutomaticUpdateOn(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_IsAutomaticUpdateOn_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).IsAutomaticUpdateOn(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_DiskCachePath_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).DiskCachePath(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_DiskCachePath_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).DiskCachePath(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetDiskCachePath_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetDiskCachePath(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetDiskCachePath_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetDiskCachePath(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetIsDoHEnabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.BoolValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetIsDoHEnabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetIsDoHEnabled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetIsDoHEnabled(ctx, req.(*wrapperspb.BoolValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_IsDoHEnabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).IsDoHEnabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_IsDoHEnabled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).IsDoHEnabled(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_MailServerSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).MailServerSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_MailServerSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).MailServerSettings(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetMailServerSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImapSmtpSettings)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetMailServerSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetMailServerSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetMailServerSettings(ctx, req.(*ImapSmtpSettings))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_Hostname_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).Hostname(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_Hostname_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).Hostname(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_IsPortFree_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.Int32Value)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).IsPortFree(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_IsPortFree_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).IsPortFree(ctx, req.(*wrapperspb.Int32Value))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_AvailableKeychains_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).AvailableKeychains(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_AvailableKeychains_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).AvailableKeychains(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetCurrentKeychain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetCurrentKeychain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetCurrentKeychain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetCurrentKeychain(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_CurrentKeychain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).CurrentKeychain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_CurrentKeychain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).CurrentKeychain(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_GetUserList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).GetUserList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_GetUserList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).GetUserList(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_GetUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).GetUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_GetUser_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).GetUser(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SetUserSplitMode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserSplitModeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SetUserSplitMode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SetUserSplitMode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SetUserSplitMode(ctx, req.(*UserSplitModeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_SendBadEventUserFeedback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserBadEventFeedbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).SendBadEventUserFeedback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_SendBadEventUserFeedback_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).SendBadEventUserFeedback(ctx, req.(*UserBadEventFeedbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_LogoutUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).LogoutUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_LogoutUser_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).LogoutUser(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_RemoveUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).RemoveUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_RemoveUser_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).RemoveUser(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_ConfigureUserAppleMail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureAppleMailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).ConfigureUserAppleMail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_ConfigureUserAppleMail_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).ConfigureUserAppleMail(ctx, req.(*ConfigureAppleMailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_IsTLSCertificateInstalled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).IsTLSCertificateInstalled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_IsTLSCertificateInstalled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).IsTLSCertificateInstalled(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_InstallTLSCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).InstallTLSCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_InstallTLSCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).InstallTLSCertificate(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_ExportTLSCertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).ExportTLSCertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_ExportTLSCertificates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).ExportTLSCertificates(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_RunEventStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(EventStreamRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BridgeServer).RunEventStream(m, &bridgeRunEventStreamServer{stream})
}

type Bridge_RunEventStreamServer interface {
	Send(*StreamEvent) error
	grpc.ServerStream
}

type bridgeRunEventStreamServer struct {
	grpc.ServerStream
}

func (x *bridgeRunEventStreamServer) Send(m *StreamEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _Bridge_StopEventStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).StopEventStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_StopEventStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).StopEventStream(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bridge_TriggerRepair_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BridgeServer).TriggerRepair(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bridge_TriggerRepair_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BridgeServer).TriggerRepair(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

// Bridge_ServiceDesc is the grpc.ServiceDesc for Bridge service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Bridge_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "grpc.Bridge",
	HandlerType: (*BridgeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CheckTokens",
			Handler:    _Bridge_CheckTokens_Handler,
		},
		{
			MethodName: "AddLogEntry",
			Handler:    _Bridge_AddLogEntry_Handler,
		},
		{
			MethodName: "GuiReady",
			Handler:    _Bridge_GuiReady_Handler,
		},
		{
			MethodName: "Quit",
			Handler:    _Bridge_Quit_Handler,
		},
		{
			MethodName: "Restart",
			Handler:    _Bridge_Restart_Handler,
		},
		{
			MethodName: "ShowOnStartup",
			Handler:    _Bridge_ShowOnStartup_Handler,
		},
		{
			MethodName: "SetIsAutostartOn",
			Handler:    _Bridge_SetIsAutostartOn_Handler,
		},
		{
			MethodName: "IsAutostartOn",
			Handler:    _Bridge_IsAutostartOn_Handler,
		},
		{
			MethodName: "SetIsBetaEnabled",
			Handler:    _Bridge_SetIsBetaEnabled_Handler,
		},
		{
			MethodName: "IsBetaEnabled",
			Handler:    _Bridge_IsBetaEnabled_Handler,
		},
		{
			MethodName: "SetIsAllMailVisible",
			Handler:    _Bridge_SetIsAllMailVisible_Handler,
		},
		{
			MethodName: "IsAllMailVisible",
			Handler:    _Bridge_IsAllMailVisible_Handler,
		},
		{
			MethodName: "SetIsTelemetryDisabled",
			Handler:    _Bridge_SetIsTelemetryDisabled_Handler,
		},
		{
			MethodName: "IsTelemetryDisabled",
			Handler:    _Bridge_IsTelemetryDisabled_Handler,
		},
		{
			MethodName: "GoOs",
			Handler:    _Bridge_GoOs_Handler,
		},
		{
			MethodName: "TriggerReset",
			Handler:    _Bridge_TriggerReset_Handler,
		},
		{
			MethodName: "Version",
			Handler:    _Bridge_Version_Handler,
		},
		{
			MethodName: "LogsPath",
			Handler:    _Bridge_LogsPath_Handler,
		},
		{
			MethodName: "LicensePath",
			Handler:    _Bridge_LicensePath_Handler,
		},
		{
			MethodName: "ReleaseNotesPageLink",
			Handler:    _Bridge_ReleaseNotesPageLink_Handler,
		},
		{
			MethodName: "DependencyLicensesLink",
			Handler:    _Bridge_DependencyLicensesLink_Handler,
		},
		{
			MethodName: "LandingPageLink",
			Handler:    _Bridge_LandingPageLink_Handler,
		},
		{
			MethodName: "SetColorSchemeName",
			Handler:    _Bridge_SetColorSchemeName_Handler,
		},
		{
			MethodName: "ColorSchemeName",
			Handler:    _Bridge_ColorSchemeName_Handler,
		},
		{
			MethodName: "CurrentEmailClient",
			Handler:    _Bridge_CurrentEmailClient_Handler,
		},
		{
			MethodName: "ReportBug",
			Handler:    _Bridge_ReportBug_Handler,
		},
		{
			MethodName: "ForceLauncher",
			Handler:    _Bridge_ForceLauncher_Handler,
		},
		{
			MethodName: "SetMainExecutable",
			Handler:    _Bridge_SetMainExecutable_Handler,
		},
		{
			MethodName: "RequestKnowledgeBaseSuggestions",
			Handler:    _Bridge_RequestKnowledgeBaseSuggestions_Handler,
		},
		{
			MethodName: "Login",
			Handler:    _Bridge_Login_Handler,
		},
		{
			MethodName: "Login2FA",
			Handler:    _Bridge_Login2FA_Handler,
		},
		{
			MethodName: "Login2Passwords",
			Handler:    _Bridge_Login2Passwords_Handler,
		},
		{
			MethodName: "LoginAbort",
			Handler:    _Bridge_LoginAbort_Handler,
		},
		{
			MethodName: "CheckUpdate",
			Handler:    _Bridge_CheckUpdate_Handler,
		},
		{
			MethodName: "InstallUpdate",
			Handler:    _Bridge_InstallUpdate_Handler,
		},
		{
			MethodName: "SetIsAutomaticUpdateOn",
			Handler:    _Bridge_SetIsAutomaticUpdateOn_Handler,
		},
		{
			MethodName: "IsAutomaticUpdateOn",
			Handler:    _Bridge_IsAutomaticUpdateOn_Handler,
		},
		{
			MethodName: "DiskCachePath",
			Handler:    _Bridge_DiskCachePath_Handler,
		},
		{
			MethodName: "SetDiskCachePath",
			Handler:    _Bridge_SetDiskCachePath_Handler,
		},
		{
			MethodName: "SetIsDoHEnabled",
			Handler:    _Bridge_SetIsDoHEnabled_Handler,
		},
		{
			MethodName: "IsDoHEnabled",
			Handler:    _Bridge_IsDoHEnabled_Handler,
		},
		{
			MethodName: "MailServerSettings",
			Handler:    _Bridge_MailServerSettings_Handler,
		},
		{
			MethodName: "SetMailServerSettings",
			Handler:    _Bridge_SetMailServerSettings_Handler,
		},
		{
			MethodName: "Hostname",
			Handler:    _Bridge_Hostname_Handler,
		},
		{
			MethodName: "IsPortFree",
			Handler:    _Bridge_IsPortFree_Handler,
		},
		{
			MethodName: "AvailableKeychains",
			Handler:    _Bridge_AvailableKeychains_Handler,
		},
		{
			MethodName: "SetCurrentKeychain",
			Handler:    _Bridge_SetCurrentKeychain_Handler,
		},
		{
			MethodName: "CurrentKeychain",
			Handler:    _Bridge_CurrentKeychain_Handler,
		},
		{
			MethodName: "GetUserList",
			Handler:    _Bridge_GetUserList_Handler,
		},
		{
			MethodName: "GetUser",
			Handler:    _Bridge_GetUser_Handler,
		},
		{
			MethodName: "SetUserSplitMode",
			Handler:    _Bridge_SetUserSplitMode_Handler,
		},
		{
			MethodName: "SendBadEventUserFeedback",
			Handler:    _Bridge_SendBadEventUserFeedback_Handler,
		},
		{
			MethodName: "LogoutUser",
			Handler:    _Bridge_LogoutUser_Handler,
		},
		{
			MethodName: "RemoveUser",
			Handler:    _Bridge_RemoveUser_Handler,
		},
		{
			MethodName: "ConfigureUserAppleMail",
			Handler:    _Bridge_ConfigureUserAppleMail_Handler,
		},
		{
			MethodName: "IsTLSCertificateInstalled",
			Handler:    _Bridge_IsTLSCertificateInstalled_Handler,
		},
		{
			MethodName: "InstallTLSCertificate",
			Handler:    _Bridge_InstallTLSCertificate_Handler,
		},
		{
			MethodName: "ExportTLSCertificates",
			Handler:    _Bridge_ExportTLSCertificates_Handler,
		},
		{
			MethodName: "StopEventStream",
			Handler:    _Bridge_StopEventStream_Handler,
		},
		{
			MethodName: "TriggerRepair",
			Handler:    _Bridge_TriggerRepair_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "RunEventStream",
			Handler:       _Bridge_RunEventStream_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "bridge.proto",
}
