/*
 * Copyright (C) 2024 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

/*
 * Caution!
 * This file generated by the script "utils/lexbor/encoding/multi-byte.pl"!
 * Do not change this file!
 */

#ifndef LEXBOR_ENCODING_MULTI_H
#define LEXBOR_ENCODING_MULTI_H

#ifdef __cplusplus
extern "C" {
#endif

#include "lexbor/encoding/base.h"


LXB_EXTERN lxb_codepoint_t lxb_encoding_multi_big5_map[19782];
LXB_EXTERN lxb_codepoint_t lxb_encoding_multi_euc_kr_map[23750];
LXB_EXTERN lxb_codepoint_t lxb_encoding_multi_gb18030_map[23940];
LXB_EXTERN lxb_codepoint_t lxb_encoding_multi_iso_2022_jp_katakana_map[63];
LXB_EXTERN lxb_codepoint_t lxb_encoding_multi_jis0212_map[7211];
LXB_EXTERN lxb_codepoint_t lxb_encoding_multi_jis0208_map[11104];

LXB_EXTERN uint16_t lxb_encoding_multi_big5_167_1106_map[939];
LXB_EXTERN uint16_t lxb_encoding_multi_big5_8211_40882_map[32671];
LXB_EXTERN uint16_t lxb_encoding_multi_big5_64012_65518_map[1506];
LXB_EXTERN uint16_t lxb_encoding_multi_big5_131210_172369_map[41159];
LXB_EXTERN uint16_t lxb_encoding_multi_big5_194708_194727_map[19];

LXB_EXTERN uint16_t lxb_encoding_multi_euc_kr_161_1106_map[945];
LXB_EXTERN uint16_t lxb_encoding_multi_euc_kr_8213_13278_map[5065];
LXB_EXTERN uint16_t lxb_encoding_multi_euc_kr_19968_55204_map[35236];
LXB_EXTERN uint16_t lxb_encoding_multi_euc_kr_63744_65511_map[1767];

LXB_EXTERN uint16_t lxb_encoding_multi_gb18030_164_1106_map[942];
LXB_EXTERN uint16_t lxb_encoding_multi_gb18030_7743_40892_map[33149];
LXB_EXTERN uint16_t lxb_encoding_multi_gb18030_57344_65510_map[8166];

LXB_EXTERN uint16_t lxb_encoding_multi_iso_2022_jp_katakana_12289_12541_map[252];

LXB_EXTERN uint16_t lxb_encoding_multi_jis0212_161_1120_map[959];
LXB_EXTERN uint16_t lxb_encoding_multi_jis0212_8470_8483_map[13];
LXB_EXTERN uint16_t lxb_encoding_multi_jis0212_19970_40870_map[20900];
LXB_EXTERN uint16_t lxb_encoding_multi_jis0212_65374_65375_map[1];

LXB_EXTERN uint16_t lxb_encoding_multi_jis0208_167_1106_map[939];
LXB_EXTERN uint16_t lxb_encoding_multi_jis0208_8208_13262_map[5054];
LXB_EXTERN uint16_t lxb_encoding_multi_jis0208_19968_40865_map[20897];
LXB_EXTERN uint16_t lxb_encoding_multi_jis0208_63785_65510_map[1725];

lxb_inline uint16_t
lxb_encoding_multi_big5_index(lxb_codepoint_t cp)
{
    if (cp > 0x2F8A7) {
        return UINT16_MAX;
    }

    if (cp < 65518) {
        if (cp >= 167 && cp < 1106) {
            return lxb_encoding_multi_big5_167_1106_map[cp - 167];
        }
        else if (cp >= 8211) {
            if (cp < 40882) {
                return lxb_encoding_multi_big5_8211_40882_map[cp - 8211];
            }
            else if (cp >= 64012) {
                return lxb_encoding_multi_big5_64012_65518_map[cp - 64012];
            }
        }
    }
    else if (cp >= 131210) {
        if (cp < 172369) {
            return lxb_encoding_multi_big5_131210_172369_map[cp - 131210];
        }
        else if (cp >= 194708) {
            if (cp < 194727) {
                return lxb_encoding_multi_big5_194708_194727_map[cp - 194708];
            }
        }
    }

    return UINT16_MAX;
}

lxb_inline uint16_t
lxb_encoding_multi_euc_kr_index(lxb_codepoint_t cp)
{
    if (cp > 0xFFE7) {
        return UINT16_MAX;
    }

    if (cp < 13278) {
        if (cp >= 161 && cp < 1106) {
            return lxb_encoding_multi_euc_kr_161_1106_map[cp - 161];
        }
        else if (cp >= 8213) {
            return lxb_encoding_multi_euc_kr_8213_13278_map[cp - 8213];
        }
    }
    else if (cp >= 19968) {
        if (cp < 55204) {
            return lxb_encoding_multi_euc_kr_19968_55204_map[cp - 19968];
        }
        else if (cp >= 63744) {
            if (cp < 65511) {
                return lxb_encoding_multi_euc_kr_63744_65511_map[cp - 63744];
            }
        }
    }

    return UINT16_MAX;
}

lxb_inline uint16_t
lxb_encoding_multi_gb18030_index(lxb_codepoint_t cp)
{
    if (cp > 0xFFE6) {
        return UINT16_MAX;
    }

    if (cp < 40892) {
        if (cp >= 164 && cp < 1106) {
            return lxb_encoding_multi_gb18030_164_1106_map[cp - 164];
        }
        else if (cp >= 7743) {
            return lxb_encoding_multi_gb18030_7743_40892_map[cp - 7743];
        }
    }
    else if (cp >= 57344) {
        if (cp < 65510) {
            return lxb_encoding_multi_gb18030_57344_65510_map[cp - 57344];
        }
    }

    return UINT16_MAX;
}

lxb_inline uint16_t
lxb_encoding_multi_iso_2022_jp_katakana_index(lxb_codepoint_t cp)
{
    if (cp >= 12289 && cp < 12541) {
        return lxb_encoding_multi_iso_2022_jp_katakana_12289_12541_map[cp - 12289];
    }

    return UINT16_MAX;
}

lxb_inline uint16_t
lxb_encoding_multi_jis0212_index(lxb_codepoint_t cp)
{
    if (cp > 0xFF5F) {
        return UINT16_MAX;
    }

    if (cp < 8483) {
        if (cp >= 161 && cp < 1120) {
            return lxb_encoding_multi_jis0212_161_1120_map[cp - 161];
        }
        else if (cp >= 8470) {
            return lxb_encoding_multi_jis0212_8470_8483_map[cp - 8470];
        }
    }
    else if (cp >= 19970) {
        if (cp < 40870) {
            return lxb_encoding_multi_jis0212_19970_40870_map[cp - 19970];
        }
        else if (cp >= 65374) {
            if (cp < 65375) {
                return lxb_encoding_multi_jis0212_65374_65375_map[cp - 65374];
            }
        }
    }

    return UINT16_MAX;
}

lxb_inline uint16_t
lxb_encoding_multi_jis0208_index(lxb_codepoint_t cp)
{
    if (cp > 0xFFE6) {
        return UINT16_MAX;
    }

    if (cp < 13262) {
        if (cp >= 167 && cp < 1106) {
            return lxb_encoding_multi_jis0208_167_1106_map[cp - 167];
        }
        else if (cp >= 8208) {
            return lxb_encoding_multi_jis0208_8208_13262_map[cp - 8208];
        }
    }
    else if (cp >= 19968) {
        if (cp < 40865) {
            return lxb_encoding_multi_jis0208_19968_40865_map[cp - 19968];
        }
        else if (cp >= 63785) {
            if (cp < 65510) {
                return lxb_encoding_multi_jis0208_63785_65510_map[cp - 63785];
            }
        }
    }

    return UINT16_MAX;
}


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* LEXBOR_ENCODING_MULTI_H */
