/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "phosh-end-session-dialog-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_UINT_UINT_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintUintUintBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_type,
        guint arg_timestamp,
        guint arg_seconds_to_stay_open,
        const gchar *const *arg_inhibitor_object_paths,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintUintUintBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintUintUintBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              g_marshal_value_peek_boxed (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.SessionManager.EndSessionDialog
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PhoshDBusEndSessionDialog
 * @title: PhoshDBusEndSessionDialog
 * @short_description: Generated C code for the org.gnome.SessionManager.EndSessionDialog D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-SessionManager-EndSessionDialog.top_of_page">org.gnome.SessionManager.EndSessionDialog</link> D-Bus interface in C.
 */

enum
{
  PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_LOGOUT,
  PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_REBOOT,
  PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_SHUTDOWN,
  PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_HIBERNATE,
  PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_SUSPEND,
  PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_HYBRID_SLEEP,
  PHOSH_DBUS__END_SESSION_DIALOG_CANCELED,
  PHOSH_DBUS__END_SESSION_DIALOG_CLOSED,
};

static unsigned PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[8] = { 0 };

/* ---- Introspection data for org.gnome.SessionManager.EndSessionDialog ---- */

static const _ExtendedGDBusArgInfo _phosh_dbus_end_session_dialog_method_info_open_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_end_session_dialog_method_info_open_IN_ARG_timestamp =
{
  {
    -1,
    (gchar *) "timestamp",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_end_session_dialog_method_info_open_IN_ARG_seconds_to_stay_open =
{
  {
    -1,
    (gchar *) "seconds_to_stay_open",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_end_session_dialog_method_info_open_IN_ARG_inhibitor_object_paths =
{
  {
    -1,
    (gchar *) "inhibitor_object_paths",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_end_session_dialog_method_info_open_IN_ARG_pointers[] =
{
  &_phosh_dbus_end_session_dialog_method_info_open_IN_ARG_type.parent_struct,
  &_phosh_dbus_end_session_dialog_method_info_open_IN_ARG_timestamp.parent_struct,
  &_phosh_dbus_end_session_dialog_method_info_open_IN_ARG_seconds_to_stay_open.parent_struct,
  &_phosh_dbus_end_session_dialog_method_info_open_IN_ARG_inhibitor_object_paths.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_end_session_dialog_method_info_open =
{
  {
    -1,
    (gchar *) "Open",
    (GDBusArgInfo **) &_phosh_dbus_end_session_dialog_method_info_open_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-open",
  FALSE
};

static const GDBusMethodInfo * const _phosh_dbus_end_session_dialog_method_info_pointers[] =
{
  &_phosh_dbus_end_session_dialog_method_info_open.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_end_session_dialog_signal_info_confirmed_logout =
{
  {
    -1,
    (gchar *) "ConfirmedLogout",
    NULL,
    NULL
  },
  "confirmed-logout"
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_end_session_dialog_signal_info_confirmed_reboot =
{
  {
    -1,
    (gchar *) "ConfirmedReboot",
    NULL,
    NULL
  },
  "confirmed-reboot"
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_end_session_dialog_signal_info_confirmed_shutdown =
{
  {
    -1,
    (gchar *) "ConfirmedShutdown",
    NULL,
    NULL
  },
  "confirmed-shutdown"
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_end_session_dialog_signal_info_confirmed_hibernate =
{
  {
    -1,
    (gchar *) "ConfirmedHibernate",
    NULL,
    NULL
  },
  "confirmed-hibernate"
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_end_session_dialog_signal_info_confirmed_suspend =
{
  {
    -1,
    (gchar *) "ConfirmedSuspend",
    NULL,
    NULL
  },
  "confirmed-suspend"
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_end_session_dialog_signal_info_confirmed_hybrid_sleep =
{
  {
    -1,
    (gchar *) "ConfirmedHybridSleep",
    NULL,
    NULL
  },
  "confirmed-hybrid-sleep"
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_end_session_dialog_signal_info_canceled =
{
  {
    -1,
    (gchar *) "Canceled",
    NULL,
    NULL
  },
  "canceled"
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_end_session_dialog_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const GDBusSignalInfo * const _phosh_dbus_end_session_dialog_signal_info_pointers[] =
{
  &_phosh_dbus_end_session_dialog_signal_info_confirmed_logout.parent_struct,
  &_phosh_dbus_end_session_dialog_signal_info_confirmed_reboot.parent_struct,
  &_phosh_dbus_end_session_dialog_signal_info_confirmed_shutdown.parent_struct,
  &_phosh_dbus_end_session_dialog_signal_info_confirmed_hibernate.parent_struct,
  &_phosh_dbus_end_session_dialog_signal_info_confirmed_suspend.parent_struct,
  &_phosh_dbus_end_session_dialog_signal_info_confirmed_hybrid_sleep.parent_struct,
  &_phosh_dbus_end_session_dialog_signal_info_canceled.parent_struct,
  &_phosh_dbus_end_session_dialog_signal_info_closed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _phosh_dbus_end_session_dialog_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.SessionManager.EndSessionDialog",
    (GDBusMethodInfo **) &_phosh_dbus_end_session_dialog_method_info_pointers,
    (GDBusSignalInfo **) &_phosh_dbus_end_session_dialog_signal_info_pointers,
    NULL,
    NULL
  },
  "end-session-dialog",
};


/**
 * phosh_dbus_end_session_dialog_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-SessionManager-EndSessionDialog.top_of_page">org.gnome.SessionManager.EndSessionDialog</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
phosh_dbus_end_session_dialog_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_phosh_dbus_end_session_dialog_interface_info.parent_struct;
}

/**
 * phosh_dbus_end_session_dialog_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PhoshDBusEndSessionDialog interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
phosh_dbus_end_session_dialog_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
phosh_dbus_end_session_dialog_signal_marshal_confirmed_logout (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_end_session_dialog_signal_marshal_confirmed_reboot (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_end_session_dialog_signal_marshal_confirmed_shutdown (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_end_session_dialog_signal_marshal_confirmed_hibernate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_end_session_dialog_signal_marshal_confirmed_suspend (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_end_session_dialog_signal_marshal_confirmed_hybrid_sleep (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_end_session_dialog_signal_marshal_canceled (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_end_session_dialog_signal_marshal_closed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_end_session_dialog_method_marshal_open (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_UINT_UINT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PhoshDBusEndSessionDialog:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager-EndSessionDialog.top_of_page">org.gnome.SessionManager.EndSessionDialog</link>.
 */

/**
 * PhoshDBusEndSessionDialogIface:
 * @parent_iface: The parent interface.
 * @handle_open: Handler for the #PhoshDBusEndSessionDialog::handle-open signal.
 * @canceled: Handler for the #PhoshDBusEndSessionDialog::canceled signal.
 * @closed: Handler for the #PhoshDBusEndSessionDialog::closed signal.
 * @confirmed_hibernate: Handler for the #PhoshDBusEndSessionDialog::confirmed-hibernate signal.
 * @confirmed_hybrid_sleep: Handler for the #PhoshDBusEndSessionDialog::confirmed-hybrid-sleep signal.
 * @confirmed_logout: Handler for the #PhoshDBusEndSessionDialog::confirmed-logout signal.
 * @confirmed_reboot: Handler for the #PhoshDBusEndSessionDialog::confirmed-reboot signal.
 * @confirmed_shutdown: Handler for the #PhoshDBusEndSessionDialog::confirmed-shutdown signal.
 * @confirmed_suspend: Handler for the #PhoshDBusEndSessionDialog::confirmed-suspend signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager-EndSessionDialog.top_of_page">org.gnome.SessionManager.EndSessionDialog</link>.
 */

typedef PhoshDBusEndSessionDialogIface PhoshDBusEndSessionDialogInterface;
G_DEFINE_INTERFACE (PhoshDBusEndSessionDialog, phosh_dbus_end_session_dialog, G_TYPE_OBJECT)

static void
phosh_dbus_end_session_dialog_default_init (PhoshDBusEndSessionDialogIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PhoshDBusEndSessionDialog::handle-open:
   * @object: A #PhoshDBusEndSessionDialog.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_type: Argument passed by remote caller.
   * @arg_timestamp: Argument passed by remote caller.
   * @arg_seconds_to_stay_open: Argument passed by remote caller.
   * @arg_inhibitor_object_paths: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager-EndSessionDialog.Open">Open()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_end_session_dialog_complete_open() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusEndSessionDialogIface, handle_open),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_end_session_dialog_method_marshal_open,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRV);

  /* GObject signals for received D-Bus signals: */
  /**
   * PhoshDBusEndSessionDialog::confirmed-logout:
   * @object: A #PhoshDBusEndSessionDialog.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedLogout">"ConfirmedLogout"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_LOGOUT] =
    g_signal_new ("confirmed-logout",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusEndSessionDialogIface, confirmed_logout),
      NULL,
      NULL,
      phosh_dbus_end_session_dialog_signal_marshal_confirmed_logout,
      G_TYPE_NONE,
      0);

  /**
   * PhoshDBusEndSessionDialog::confirmed-reboot:
   * @object: A #PhoshDBusEndSessionDialog.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedReboot">"ConfirmedReboot"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_REBOOT] =
    g_signal_new ("confirmed-reboot",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusEndSessionDialogIface, confirmed_reboot),
      NULL,
      NULL,
      phosh_dbus_end_session_dialog_signal_marshal_confirmed_reboot,
      G_TYPE_NONE,
      0);

  /**
   * PhoshDBusEndSessionDialog::confirmed-shutdown:
   * @object: A #PhoshDBusEndSessionDialog.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedShutdown">"ConfirmedShutdown"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_SHUTDOWN] =
    g_signal_new ("confirmed-shutdown",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusEndSessionDialogIface, confirmed_shutdown),
      NULL,
      NULL,
      phosh_dbus_end_session_dialog_signal_marshal_confirmed_shutdown,
      G_TYPE_NONE,
      0);

  /**
   * PhoshDBusEndSessionDialog::confirmed-hibernate:
   * @object: A #PhoshDBusEndSessionDialog.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedHibernate">"ConfirmedHibernate"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_HIBERNATE] =
    g_signal_new ("confirmed-hibernate",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusEndSessionDialogIface, confirmed_hibernate),
      NULL,
      NULL,
      phosh_dbus_end_session_dialog_signal_marshal_confirmed_hibernate,
      G_TYPE_NONE,
      0);

  /**
   * PhoshDBusEndSessionDialog::confirmed-suspend:
   * @object: A #PhoshDBusEndSessionDialog.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedSuspend">"ConfirmedSuspend"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_SUSPEND] =
    g_signal_new ("confirmed-suspend",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusEndSessionDialogIface, confirmed_suspend),
      NULL,
      NULL,
      phosh_dbus_end_session_dialog_signal_marshal_confirmed_suspend,
      G_TYPE_NONE,
      0);

  /**
   * PhoshDBusEndSessionDialog::confirmed-hybrid-sleep:
   * @object: A #PhoshDBusEndSessionDialog.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedHybridSleep">"ConfirmedHybridSleep"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_HYBRID_SLEEP] =
    g_signal_new ("confirmed-hybrid-sleep",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusEndSessionDialogIface, confirmed_hybrid_sleep),
      NULL,
      NULL,
      phosh_dbus_end_session_dialog_signal_marshal_confirmed_hybrid_sleep,
      G_TYPE_NONE,
      0);

  /**
   * PhoshDBusEndSessionDialog::canceled:
   * @object: A #PhoshDBusEndSessionDialog.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.Canceled">"Canceled"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CANCELED] =
    g_signal_new ("canceled",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusEndSessionDialogIface, canceled),
      NULL,
      NULL,
      phosh_dbus_end_session_dialog_signal_marshal_canceled,
      G_TYPE_NONE,
      0);

  /**
   * PhoshDBusEndSessionDialog::closed:
   * @object: A #PhoshDBusEndSessionDialog.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CLOSED] =
    g_signal_new ("closed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusEndSessionDialogIface, closed),
      NULL,
      NULL,
      phosh_dbus_end_session_dialog_signal_marshal_closed,
      G_TYPE_NONE,
      0);

}

/**
 * phosh_dbus_end_session_dialog_emit_confirmed_logout:
 * @object: A #PhoshDBusEndSessionDialog.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedLogout">"ConfirmedLogout"</link> D-Bus signal.
 */
void
phosh_dbus_end_session_dialog_emit_confirmed_logout (
    PhoshDBusEndSessionDialog *object)
{
  g_signal_emit (object, PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_LOGOUT], 0);
}

/**
 * phosh_dbus_end_session_dialog_emit_confirmed_reboot:
 * @object: A #PhoshDBusEndSessionDialog.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedReboot">"ConfirmedReboot"</link> D-Bus signal.
 */
void
phosh_dbus_end_session_dialog_emit_confirmed_reboot (
    PhoshDBusEndSessionDialog *object)
{
  g_signal_emit (object, PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_REBOOT], 0);
}

/**
 * phosh_dbus_end_session_dialog_emit_confirmed_shutdown:
 * @object: A #PhoshDBusEndSessionDialog.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedShutdown">"ConfirmedShutdown"</link> D-Bus signal.
 */
void
phosh_dbus_end_session_dialog_emit_confirmed_shutdown (
    PhoshDBusEndSessionDialog *object)
{
  g_signal_emit (object, PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_SHUTDOWN], 0);
}

/**
 * phosh_dbus_end_session_dialog_emit_confirmed_hibernate:
 * @object: A #PhoshDBusEndSessionDialog.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedHibernate">"ConfirmedHibernate"</link> D-Bus signal.
 */
void
phosh_dbus_end_session_dialog_emit_confirmed_hibernate (
    PhoshDBusEndSessionDialog *object)
{
  g_signal_emit (object, PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_HIBERNATE], 0);
}

/**
 * phosh_dbus_end_session_dialog_emit_confirmed_suspend:
 * @object: A #PhoshDBusEndSessionDialog.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedSuspend">"ConfirmedSuspend"</link> D-Bus signal.
 */
void
phosh_dbus_end_session_dialog_emit_confirmed_suspend (
    PhoshDBusEndSessionDialog *object)
{
  g_signal_emit (object, PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_SUSPEND], 0);
}

/**
 * phosh_dbus_end_session_dialog_emit_confirmed_hybrid_sleep:
 * @object: A #PhoshDBusEndSessionDialog.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.ConfirmedHybridSleep">"ConfirmedHybridSleep"</link> D-Bus signal.
 */
void
phosh_dbus_end_session_dialog_emit_confirmed_hybrid_sleep (
    PhoshDBusEndSessionDialog *object)
{
  g_signal_emit (object, PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CONFIRMED_HYBRID_SLEEP], 0);
}

/**
 * phosh_dbus_end_session_dialog_emit_canceled:
 * @object: A #PhoshDBusEndSessionDialog.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.Canceled">"Canceled"</link> D-Bus signal.
 */
void
phosh_dbus_end_session_dialog_emit_canceled (
    PhoshDBusEndSessionDialog *object)
{
  g_signal_emit (object, PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CANCELED], 0);
}

/**
 * phosh_dbus_end_session_dialog_emit_closed:
 * @object: A #PhoshDBusEndSessionDialog.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager-EndSessionDialog.Closed">"Closed"</link> D-Bus signal.
 */
void
phosh_dbus_end_session_dialog_emit_closed (
    PhoshDBusEndSessionDialog *object)
{
  g_signal_emit (object, PHOSH_DBUS__END_SESSION_DIALOG_SIGNALS[PHOSH_DBUS__END_SESSION_DIALOG_CLOSED], 0);
}

/**
 * phosh_dbus_end_session_dialog_call_open:
 * @proxy: A #PhoshDBusEndSessionDialogProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_timestamp: Argument to pass with the method invocation.
 * @arg_seconds_to_stay_open: Argument to pass with the method invocation.
 * @arg_inhibitor_object_paths: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager-EndSessionDialog.Open">Open()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_end_session_dialog_call_open_finish() to get the result of the operation.
 *
 * See phosh_dbus_end_session_dialog_call_open_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_end_session_dialog_call_open (
    PhoshDBusEndSessionDialog *proxy,
    guint arg_type,
    guint arg_timestamp,
    guint arg_seconds_to_stay_open,
    const gchar *const *arg_inhibitor_object_paths,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Open",
    g_variant_new ("(uuu^ao)",
                   arg_type,
                   arg_timestamp,
                   arg_seconds_to_stay_open,
                   arg_inhibitor_object_paths),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_end_session_dialog_call_open_finish:
 * @proxy: A #PhoshDBusEndSessionDialogProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_end_session_dialog_call_open().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_end_session_dialog_call_open().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_end_session_dialog_call_open_finish (
    PhoshDBusEndSessionDialog *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_end_session_dialog_call_open_sync:
 * @proxy: A #PhoshDBusEndSessionDialogProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_timestamp: Argument to pass with the method invocation.
 * @arg_seconds_to_stay_open: Argument to pass with the method invocation.
 * @arg_inhibitor_object_paths: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager-EndSessionDialog.Open">Open()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_end_session_dialog_call_open() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_end_session_dialog_call_open_sync (
    PhoshDBusEndSessionDialog *proxy,
    guint arg_type,
    guint arg_timestamp,
    guint arg_seconds_to_stay_open,
    const gchar *const *arg_inhibitor_object_paths,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Open",
    g_variant_new ("(uuu^ao)",
                   arg_type,
                   arg_timestamp,
                   arg_seconds_to_stay_open,
                   arg_inhibitor_object_paths),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_end_session_dialog_complete_open:
 * @object: A #PhoshDBusEndSessionDialog.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager-EndSessionDialog.Open">Open()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_end_session_dialog_complete_open (
    PhoshDBusEndSessionDialog *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusEndSessionDialogProxy:
 *
 * The #PhoshDBusEndSessionDialogProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusEndSessionDialogProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusEndSessionDialogProxy.
 */

struct _PhoshDBusEndSessionDialogProxyPrivate
{
  GData *qdata;
};

static void phosh_dbus_end_session_dialog_proxy_iface_init (PhoshDBusEndSessionDialogIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusEndSessionDialogProxy, phosh_dbus_end_session_dialog_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PhoshDBusEndSessionDialogProxy)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_END_SESSION_DIALOG, phosh_dbus_end_session_dialog_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusEndSessionDialogProxy, phosh_dbus_end_session_dialog_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_END_SESSION_DIALOG, phosh_dbus_end_session_dialog_proxy_iface_init))

#endif
static void
phosh_dbus_end_session_dialog_proxy_finalize (GObject *object)
{
  PhoshDBusEndSessionDialogProxy *proxy = PHOSH_DBUS_END_SESSION_DIALOG_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (phosh_dbus_end_session_dialog_proxy_parent_class)->finalize (object);
}

static void
phosh_dbus_end_session_dialog_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_dbus_end_session_dialog_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_dbus_end_session_dialog_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_phosh_dbus_end_session_dialog_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PHOSH_DBUS_TYPE_END_SESSION_DIALOG);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_END_SESSION_DIALOG);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
phosh_dbus_end_session_dialog_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PhoshDBusEndSessionDialogProxy *proxy = PHOSH_DBUS_END_SESSION_DIALOG_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_end_session_dialog_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_end_session_dialog_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
phosh_dbus_end_session_dialog_proxy_init (PhoshDBusEndSessionDialogProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = phosh_dbus_end_session_dialog_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PHOSH_DBUS_TYPE_END_SESSION_DIALOG_PROXY, PhoshDBusEndSessionDialogProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), phosh_dbus_end_session_dialog_interface_info ());
}

static void
phosh_dbus_end_session_dialog_proxy_class_init (PhoshDBusEndSessionDialogProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = phosh_dbus_end_session_dialog_proxy_finalize;
  gobject_class->get_property = phosh_dbus_end_session_dialog_proxy_get_property;
  gobject_class->set_property = phosh_dbus_end_session_dialog_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = phosh_dbus_end_session_dialog_proxy_g_signal;
  proxy_class->g_properties_changed = phosh_dbus_end_session_dialog_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusEndSessionDialogProxyPrivate));
#endif
}

static void
phosh_dbus_end_session_dialog_proxy_iface_init (PhoshDBusEndSessionDialogIface *iface G_GNUC_UNUSED)
{
}

/**
 * phosh_dbus_end_session_dialog_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager-EndSessionDialog.top_of_page">org.gnome.SessionManager.EndSessionDialog</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_end_session_dialog_proxy_new_finish() to get the result of the operation.
 *
 * See phosh_dbus_end_session_dialog_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_end_session_dialog_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_END_SESSION_DIALOG_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager.EndSessionDialog", NULL);
}

/**
 * phosh_dbus_end_session_dialog_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_end_session_dialog_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_end_session_dialog_proxy_new().
 *
 * Returns: (transfer full) (type PhoshDBusEndSessionDialogProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusEndSessionDialog *
phosh_dbus_end_session_dialog_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_END_SESSION_DIALOG (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_end_session_dialog_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager-EndSessionDialog.top_of_page">org.gnome.SessionManager.EndSessionDialog</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_end_session_dialog_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusEndSessionDialogProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusEndSessionDialog *
phosh_dbus_end_session_dialog_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_END_SESSION_DIALOG_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager.EndSessionDialog", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_END_SESSION_DIALOG (ret);
  else
    return NULL;
}


/**
 * phosh_dbus_end_session_dialog_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like phosh_dbus_end_session_dialog_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_end_session_dialog_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See phosh_dbus_end_session_dialog_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_end_session_dialog_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_END_SESSION_DIALOG_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager.EndSessionDialog", NULL);
}

/**
 * phosh_dbus_end_session_dialog_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_end_session_dialog_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_end_session_dialog_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PhoshDBusEndSessionDialogProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusEndSessionDialog *
phosh_dbus_end_session_dialog_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_END_SESSION_DIALOG (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_end_session_dialog_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like phosh_dbus_end_session_dialog_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_end_session_dialog_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusEndSessionDialogProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusEndSessionDialog *
phosh_dbus_end_session_dialog_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_END_SESSION_DIALOG_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager.EndSessionDialog", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_END_SESSION_DIALOG (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusEndSessionDialogSkeleton:
 *
 * The #PhoshDBusEndSessionDialogSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusEndSessionDialogSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusEndSessionDialogSkeleton.
 */

struct _PhoshDBusEndSessionDialogSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_phosh_dbus_end_session_dialog_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PHOSH_DBUS_TYPE_END_SESSION_DIALOG);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_END_SESSION_DIALOG);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_phosh_dbus_end_session_dialog_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_end_session_dialog_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_phosh_dbus_end_session_dialog_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_end_session_dialog_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _phosh_dbus_end_session_dialog_skeleton_vtable =
{
  _phosh_dbus_end_session_dialog_skeleton_handle_method_call,
  _phosh_dbus_end_session_dialog_skeleton_handle_get_property,
  _phosh_dbus_end_session_dialog_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
phosh_dbus_end_session_dialog_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return phosh_dbus_end_session_dialog_interface_info ();
}

static GDBusInterfaceVTable *
phosh_dbus_end_session_dialog_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_phosh_dbus_end_session_dialog_skeleton_vtable;
}

static GVariant *
phosh_dbus_end_session_dialog_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_phosh_dbus_end_session_dialog_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _phosh_dbus_end_session_dialog_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _phosh_dbus_end_session_dialog_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _phosh_dbus_end_session_dialog_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager.EndSessionDialog", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
phosh_dbus_end_session_dialog_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_phosh_dbus_end_session_dialog_on_signal_confirmed_logout (
    PhoshDBusEndSessionDialog *object)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager.EndSessionDialog", "ConfirmedLogout",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_phosh_dbus_end_session_dialog_on_signal_confirmed_reboot (
    PhoshDBusEndSessionDialog *object)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager.EndSessionDialog", "ConfirmedReboot",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_phosh_dbus_end_session_dialog_on_signal_confirmed_shutdown (
    PhoshDBusEndSessionDialog *object)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager.EndSessionDialog", "ConfirmedShutdown",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_phosh_dbus_end_session_dialog_on_signal_confirmed_hibernate (
    PhoshDBusEndSessionDialog *object)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager.EndSessionDialog", "ConfirmedHibernate",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_phosh_dbus_end_session_dialog_on_signal_confirmed_suspend (
    PhoshDBusEndSessionDialog *object)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager.EndSessionDialog", "ConfirmedSuspend",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_phosh_dbus_end_session_dialog_on_signal_confirmed_hybrid_sleep (
    PhoshDBusEndSessionDialog *object)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager.EndSessionDialog", "ConfirmedHybridSleep",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_phosh_dbus_end_session_dialog_on_signal_canceled (
    PhoshDBusEndSessionDialog *object)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager.EndSessionDialog", "Canceled",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_phosh_dbus_end_session_dialog_on_signal_closed (
    PhoshDBusEndSessionDialog *object)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager.EndSessionDialog", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void phosh_dbus_end_session_dialog_skeleton_iface_init (PhoshDBusEndSessionDialogIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusEndSessionDialogSkeleton, phosh_dbus_end_session_dialog_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PhoshDBusEndSessionDialogSkeleton)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_END_SESSION_DIALOG, phosh_dbus_end_session_dialog_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusEndSessionDialogSkeleton, phosh_dbus_end_session_dialog_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_END_SESSION_DIALOG, phosh_dbus_end_session_dialog_skeleton_iface_init))

#endif
static void
phosh_dbus_end_session_dialog_skeleton_finalize (GObject *object)
{
  PhoshDBusEndSessionDialogSkeleton *skeleton = PHOSH_DBUS_END_SESSION_DIALOG_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (phosh_dbus_end_session_dialog_skeleton_parent_class)->finalize (object);
}

static void
phosh_dbus_end_session_dialog_skeleton_init (PhoshDBusEndSessionDialogSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = phosh_dbus_end_session_dialog_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PHOSH_DBUS_TYPE_END_SESSION_DIALOG_SKELETON, PhoshDBusEndSessionDialogSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
phosh_dbus_end_session_dialog_skeleton_class_init (PhoshDBusEndSessionDialogSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = phosh_dbus_end_session_dialog_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = phosh_dbus_end_session_dialog_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = phosh_dbus_end_session_dialog_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = phosh_dbus_end_session_dialog_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = phosh_dbus_end_session_dialog_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusEndSessionDialogSkeletonPrivate));
#endif
}

static void
phosh_dbus_end_session_dialog_skeleton_iface_init (PhoshDBusEndSessionDialogIface *iface)
{
  iface->confirmed_logout = _phosh_dbus_end_session_dialog_on_signal_confirmed_logout;
  iface->confirmed_reboot = _phosh_dbus_end_session_dialog_on_signal_confirmed_reboot;
  iface->confirmed_shutdown = _phosh_dbus_end_session_dialog_on_signal_confirmed_shutdown;
  iface->confirmed_hibernate = _phosh_dbus_end_session_dialog_on_signal_confirmed_hibernate;
  iface->confirmed_suspend = _phosh_dbus_end_session_dialog_on_signal_confirmed_suspend;
  iface->confirmed_hybrid_sleep = _phosh_dbus_end_session_dialog_on_signal_confirmed_hybrid_sleep;
  iface->canceled = _phosh_dbus_end_session_dialog_on_signal_canceled;
  iface->closed = _phosh_dbus_end_session_dialog_on_signal_closed;
}

/**
 * phosh_dbus_end_session_dialog_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager-EndSessionDialog.top_of_page">org.gnome.SessionManager.EndSessionDialog</link>.
 *
 * Returns: (transfer full) (type PhoshDBusEndSessionDialogSkeleton): The skeleton object.
 */
PhoshDBusEndSessionDialog *
phosh_dbus_end_session_dialog_skeleton_new (void)
{
  return PHOSH_DBUS_END_SESSION_DIALOG (g_object_new (PHOSH_DBUS_TYPE_END_SESSION_DIALOG_SKELETON, NULL));
}

