/* Copyright (c) 2004, 2025, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is designed to work with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have either included with
   the program or referenced in the documentation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */
/*
  Do not edit this file, it is automatically generated from:
  </build/percona-server/src/percona-server-8.4.7-7/scripts/firewall/firewall_sp_reload_firewall_group_rules.sql>
*/
const char* firewall_sp_reload_firewall_group_rules[]={
"-- Copyright (c) 2020, 2025, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License, version 2.0,\n"
  "-- as published by the Free Software Foundation.\n"
  "--\n"
  "-- This program is designed to work with certain software (including\n"
  "-- but not limited to OpenSSL) that is licensed under separate terms,\n"
  "-- as designated in a particular file or component or in included license\n"
  "-- documentation.  The authors of MySQL hereby grant you an additional\n"
  "-- permission to link the program and your derivative works with the\n"
  "-- separately licensed software that they have either included with\n"
  "-- the program or referenced in the documentation.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License, version 2.0, for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- Create new variant of sp_reload_firewall_group_rules\n"
  "--\n"
  "-- WARNING: If the .sql files are changed in a patch release, then it is\n"
  "-- possible that the Firewall plugin, after a downgrade, will not work as intended.\n"
  "-- Please try to avoid changes in patch releases.\n"
  "CREATE DEFINER='mysql.sys'@'localhost'\n"
  "  PROCEDURE sp_reload_firewall_group_rules(\n"
  "    IN arg_group_name VARCHAR(288))\n"
  "  SQL SECURITY INVOKER\n"
  "BEGIN\n"
  "  DECLARE result VARCHAR(160);\n"
  "  DECLARE prev_mode VARCHAR(12);\n"
  "  DECLARE prev_user VARCHAR(288);\n"
  "  DECLARE EXIT HANDLER FOR SQLEXCEPTION\n"
  "    BEGIN\n"
  "      IF (@prev_mode IS NOT NULL) THEN\n"
  "        SELECT set_firewall_group_mode(arg_group_name, @prev_mode, IF(@prev_user IS NOT NULL, @prev_user, '')) INTO r"
  "esult;\n"
  "      END IF;\n"
  "      ROLLBACK;\n"
  "      RESIGNAL;\n"
  "    END;\n"
  "  START TRANSACTION;\n"
  "  SET @prev_mode = (SELECT mode FROM performance_schema.firewall_groups WHERE name = arg_group_name);\n"
  "  SET @prev_user = (SELECT userhost FROM performance_schema.firewall_groups WHERE name = arg_group_name);\n"
  "  SELECT set_firewall_group_mode(arg_group_name, \"RESET\") INTO result;\n"
  "  IF result = \"OK\" THEN\n"
  "    INSERT INTO firewall_groups VALUES (arg_group_name, \"OFF\", NULL) ON DUPLICATE KEY UPDATE mode=\"OFF\";\n"
  "    SELECT read_firewall_group_allowlist(arg_group_name,FW.rule) FROM firewall_group_allowlist FW WHERE FW.name=arg_g"
  "roup_name;\n"
  "  ELSE\n"
  "    SELECT result;\n"
  "  END IF;\n"
  "  COMMIT;\n"
  "END\n",
nullptr
};
