// ClientServer wrapper for vtkOpenGLState object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkOpenGLState.h"
#include "vtkSystemIncludes.h"
#include "vtkStdString.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkOpenGLStateClientServerNewCommand(void* /*ctx*/)
{
  return vtkOpenGLState::New();
}


static int vtkOpenGLStateCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkOpenGLState *op = vtkOpenGLState::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkOpenGLState.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkOpenGLState  *temp20;
      {
      temp20 = vtkOpenGLState::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkOpenGLState::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkOpenGLState  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkOpenGLState::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkOpenGLState  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkOpenGLState::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("vtkglClearColor",method) && msg.GetNumberOfArguments(0) == 6)
    {
    float    temp0;
    float    temp1;
    float    temp2;
    float    temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->vtkglClearColor(temp0,temp1,temp2,temp3);
      return 1;
      }
    }
  if (!strcmp("vtkglClearDepth",method) && msg.GetNumberOfArguments(0) == 3)
    {
    double   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglClearDepth(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglDepthFunc",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglDepthFunc(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglDepthMask",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned char     temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglDepthMask(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglColorMask",method) && msg.GetNumberOfArguments(0) == 6)
    {
    unsigned char     temp0;
    unsigned char     temp1;
    unsigned char     temp2;
    unsigned char     temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->vtkglColorMask(temp0,temp1,temp2,temp3);
      return 1;
      }
    }
  if (!strcmp("vtkglViewport",method) && msg.GetNumberOfArguments(0) == 6)
    {
    int      temp0;
    int      temp1;
    int      temp2;
    int      temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->vtkglViewport(temp0,temp1,temp2,temp3);
      return 1;
      }
    }
  if (!strcmp("vtkglScissor",method) && msg.GetNumberOfArguments(0) == 6)
    {
    int      temp0;
    int      temp1;
    int      temp2;
    int      temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->vtkglScissor(temp0,temp1,temp2,temp3);
      return 1;
      }
    }
  if (!strcmp("vtkglEnable",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglEnable(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglDisable",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglDisable(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglBlendFunc",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    unsigned int      temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->vtkglBlendFunc(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("vtkglBlendFuncSeparate",method) && msg.GetNumberOfArguments(0) == 6)
    {
    unsigned int      temp0;
    unsigned int      temp1;
    unsigned int      temp2;
    unsigned int      temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->vtkglBlendFuncSeparate(temp0,temp1,temp2,temp3);
      return 1;
      }
    }
  if (!strcmp("vtkglBlendEquation",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglBlendEquation(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglBlendEquationSeparate",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    unsigned int      temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->vtkglBlendEquationSeparate(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("vtkglCullFace",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglCullFace(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglActiveTexture",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglActiveTexture(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglBindFramebuffer",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    unsigned int      temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->vtkglBindFramebuffer(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("vtkglDrawBuffer",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglDrawBuffer(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglDrawBuffers",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    vtkClientServerStreamDataArg<unsigned int    > temp1(msg, 0, 3);
    if(msg.GetArgument(0, 2, &temp0) &&
      temp1)
      {
      op->vtkglDrawBuffers(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("vtkglReadBuffer",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglReadBuffer(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglPointSize",method) && msg.GetNumberOfArguments(0) == 3)
    {
    float    temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglPointSize(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglLineWidth",method) && msg.GetNumberOfArguments(0) == 3)
    {
    float    temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglLineWidth(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglStencilMaskSeparate",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    unsigned int      temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->vtkglStencilMaskSeparate(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("vtkglStencilMask",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglStencilMask(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglStencilOpSeparate",method) && msg.GetNumberOfArguments(0) == 6)
    {
    unsigned int      temp0;
    unsigned int      temp1;
    unsigned int      temp2;
    unsigned int      temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->vtkglStencilOpSeparate(temp0,temp1,temp2,temp3);
      return 1;
      }
    }
  if (!strcmp("vtkglStencilOp",method) && msg.GetNumberOfArguments(0) == 5)
    {
    unsigned int      temp0;
    unsigned int      temp1;
    unsigned int      temp2;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2))
      {
      op->vtkglStencilOp(temp0,temp1,temp2);
      return 1;
      }
    }
  if (!strcmp("vtkglStencilFuncSeparate",method) && msg.GetNumberOfArguments(0) == 6)
    {
    unsigned int      temp0;
    unsigned int      temp1;
    int      temp2;
    unsigned int      temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->vtkglStencilFuncSeparate(temp0,temp1,temp2,temp3);
      return 1;
      }
    }
  if (!strcmp("vtkglStencilFunc",method) && msg.GetNumberOfArguments(0) == 5)
    {
    unsigned int      temp0;
    int      temp1;
    unsigned int      temp2;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2))
      {
      op->vtkglStencilFunc(temp0,temp1,temp2);
      return 1;
      }
    }
  if (!strcmp("vtkBindFramebuffer",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    vtkOpenGLFramebufferObject  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkOpenGLFramebufferObject"))
      {
      op->vtkBindFramebuffer(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("vtkDrawBuffers",method) && msg.GetNumberOfArguments(0) == 5)
    {
    unsigned int      temp0;
    vtkClientServerStreamDataArg<unsigned int    > temp1(msg, 0, 3);
    vtkOpenGLFramebufferObject  *temp2;
    if(msg.GetArgument(0, 2, &temp0) &&
      temp1 &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 4, &temp2, "vtkOpenGLFramebufferObject"))
      {
      op->vtkDrawBuffers(temp0,temp1,temp2);
      return 1;
      }
    }
  if (!strcmp("vtkReadBuffer",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    vtkOpenGLFramebufferObject  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkOpenGLFramebufferObject"))
      {
      op->vtkReadBuffer(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("vtkglPixelStorei",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    int      temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->vtkglPixelStorei(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("ResetGLClearColorState",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLClearColorState();
      return 1;
      }
    }
  if (!strcmp("ResetGLClearDepthState",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLClearDepthState();
      return 1;
      }
    }
  if (!strcmp("ResetGLDepthFuncState",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLDepthFuncState();
      return 1;
      }
    }
  if (!strcmp("ResetGLDepthMaskState",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLDepthMaskState();
      return 1;
      }
    }
  if (!strcmp("ResetGLColorMaskState",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLColorMaskState();
      return 1;
      }
    }
  if (!strcmp("ResetGLViewportState",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLViewportState();
      return 1;
      }
    }
  if (!strcmp("ResetGLScissorState",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLScissorState();
      return 1;
      }
    }
  if (!strcmp("ResetGLBlendFuncState",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLBlendFuncState();
      return 1;
      }
    }
  if (!strcmp("ResetGLBlendEquationState",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLBlendEquationState();
      return 1;
      }
    }
  if (!strcmp("ResetGLCullFaceState",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLCullFaceState();
      return 1;
      }
    }
  if (!strcmp("ResetGLActiveTexture",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetGLActiveTexture();
      return 1;
      }
    }
  if (!strcmp("vtkglClear",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->vtkglClear(temp0);
      return 1;
      }
    }
  if (!strcmp("vtkglGetBooleanv",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    vtkClientServerStreamDataArg<unsigned char   > temp1(msg, 0, 3);
    if(msg.GetArgument(0, 2, &temp0) &&
      temp1)
      {
      op->vtkglGetBooleanv(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("vtkglGetIntegerv",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    vtkClientServerStreamDataArg<int    > temp1(msg, 0, 3);
    if(msg.GetArgument(0, 2, &temp0) &&
      temp1)
      {
      op->vtkglGetIntegerv(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("vtkglGetDoublev",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    vtkClientServerStreamDataArg<double > temp1(msg, 0, 3);
    if(msg.GetArgument(0, 2, &temp0) &&
      temp1)
      {
      op->vtkglGetDoublev(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("vtkglGetFloatv",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    vtkClientServerStreamDataArg<float  > temp1(msg, 0, 3);
    if(msg.GetArgument(0, 2, &temp0) &&
      temp1)
      {
      op->vtkglGetFloatv(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlendFuncState",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkClientServerStreamDataArg<int    > temp0(msg, 0, 2);
    if(temp0)
      {
      op->GetBlendFuncState(temp0);
      return 1;
      }
    }
  if (!strcmp("GetEnumState",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    bool   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetEnumState(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetEnumState",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    bool   temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetEnumState(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("ResetEnumState",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->ResetEnumState(temp0);
      return 1;
      }
    }
  if (!strcmp("ActivateTexture",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkTextureObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkTextureObject"))
      {
      op->ActivateTexture(temp0);
      return 1;
      }
    }
  if (!strcmp("DeactivateTexture",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkTextureObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkTextureObject"))
      {
      op->DeactivateTexture(temp0);
      return 1;
      }
    }
  if (!strcmp("GetTextureUnitForTexture",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkTextureObject  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkTextureObject"))
      {
      temp20 = (op)->GetTextureUnitForTexture(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("VerifyNoActiveTextures",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->VerifyNoActiveTextures();
      return 1;
      }
    }
  if (!strcmp("PushFramebufferBindings",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PushFramebufferBindings();
      return 1;
      }
    }
  if (!strcmp("PushDrawFramebufferBinding",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PushDrawFramebufferBinding();
      return 1;
      }
    }
  if (!strcmp("PushReadFramebufferBinding",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PushReadFramebufferBinding();
      return 1;
      }
    }
  if (!strcmp("PopFramebufferBindings",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PopFramebufferBindings();
      return 1;
      }
    }
  if (!strcmp("PopDrawFramebufferBinding",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PopDrawFramebufferBinding();
      return 1;
      }
    }
  if (!strcmp("PopReadFramebufferBinding",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PopReadFramebufferBinding();
      return 1;
      }
    }
  if (!strcmp("ResetFramebufferBindings",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetFramebufferBindings();
      return 1;
      }
    }
  if (!strcmp("Initialize",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkOpenGLRenderWindow  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkOpenGLRenderWindow"))
      {
      op->Initialize(temp0);
      return 1;
      }
    }
  if (!strcmp("SetTextureUnitManager",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkTextureUnitManager  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkTextureUnitManager"))
      {
      op->SetTextureUnitManager(temp0);
      return 1;
      }
    }
  if (!strcmp("GetTextureUnitManager",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkTextureUnitManager  *temp20;
      {
      temp20 = (op)->GetTextureUnitManager();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetShaderCache",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkOpenGLShaderCache  *temp20;
      {
      temp20 = (op)->GetShaderCache();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetVBOCache",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkOpenGLVertexBufferObjectCache  *temp20;
      {
      temp20 = (op)->GetVBOCache();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetVBOCache",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkOpenGLVertexBufferObjectCache  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkOpenGLVertexBufferObjectCache"))
      {
      op->SetVBOCache(temp0);
      return 1;
      }
    }
  if (!strcmp("GetDefaultTextureInternalFormat",method) && msg.GetNumberOfArguments(0) == 7)
    {
    int      temp0;
    int      temp1;
    bool   temp2;
    bool   temp3;
    bool   temp4;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3) &&
      msg.GetArgument(0, 6, &temp4))
      {
      temp20 = (op)->GetDefaultTextureInternalFormat(temp0,temp1,temp2,temp3,temp4);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("vtkglBlitFramebuffer",method) && msg.GetNumberOfArguments(0) == 12)
    {
    int      temp0;
    int      temp1;
    int      temp2;
    int      temp3;
    int      temp4;
    int      temp5;
    int      temp6;
    int      temp7;
    unsigned int      temp8;
    unsigned int      temp9;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3) &&
      msg.GetArgument(0, 6, &temp4) &&
      msg.GetArgument(0, 7, &temp5) &&
      msg.GetArgument(0, 8, &temp6) &&
      msg.GetArgument(0, 9, &temp7) &&
      msg.GetArgument(0, 10, &temp8) &&
      msg.GetArgument(0, 11, &temp9))
      {
      op->vtkglBlitFramebuffer(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);
      return 1;
      }
    }
  if (!strcmp("Reset",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->Reset();
      return 1;
      }
    }
  if (!strcmp("Push",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->Push();
      return 1;
      }
    }
  if (!strcmp("Pop",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->Pop();
      return 1;
      }
    }
  if (!strcmp("GetVersion",method) && msg.GetNumberOfArguments(0) == 2)
    {
    const std::string  *temp20;
      {
      temp20 = &(op)->GetVersion();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << *temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetVendor",method) && msg.GetNumberOfArguments(0) == 2)
    {
    const std::string  *temp20;
      {
      temp20 = &(op)->GetVendor();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << *temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetRenderer",method) && msg.GetNumberOfArguments(0) == 2)
    {
    const std::string  *temp20;
      {
      temp20 = &(op)->GetRenderer();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << *temp20 << vtkClientServerStream::End;
      return 1;
      }
    }

  {
    const char* commandName = "vtkObject";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkOpenGLState, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkOpenGLState_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkOpenGLState", vtkOpenGLStateClientServerNewCommand);
    csi->AddCommandFunction("vtkOpenGLState", vtkOpenGLStateCommand);
    }
}
}
