#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkCompositeZPassFS_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkClientServerCompositePass_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkClientServerSynchronizedRenderers_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositedSynchronizedRenderers_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositeRenderManager_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositeRGBAPass_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositeZPass_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompressCompositer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageRenderManager_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParallelRenderManager_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPHardwareSelector_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSynchronizableActors_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSynchronizableAvatars_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSynchronizedRenderers_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSynchronizedRenderWindows_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTreeCompositer_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkRenderingParallelCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkCompositeZPassFS_Init(csi);
  vtkClientServerCompositePass_Init(csi);
  vtkClientServerSynchronizedRenderers_Init(csi);
  vtkCompositedSynchronizedRenderers_Init(csi);
  vtkCompositer_Init(csi);
  vtkCompositeRenderManager_Init(csi);
  vtkCompositeRGBAPass_Init(csi);
  vtkCompositeZPass_Init(csi);
  vtkCompressCompositer_Init(csi);
  vtkImageRenderManager_Init(csi);
  vtkParallelRenderManager_Init(csi);
  vtkPHardwareSelector_Init(csi);
  vtkSynchronizableActors_Init(csi);
  vtkSynchronizableAvatars_Init(csi);
  vtkSynchronizedRenderers_Init(csi);
  vtkSynchronizedRenderWindows_Init(csi);
  vtkTreeCompositer_Init(csi);
}
