// python wrapper for vtkSMProxyProperty
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMProxyProperty.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMProxyProperty(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMProxyProperty_ClassNew(); }

#ifndef DECLARED_PyvtkSMProperty_ClassNew
extern "C" { PyObject *PyvtkSMProperty_ClassNew(); }
#define DECLARED_PyvtkSMProperty_ClassNew
#endif

static PyObject *
PyvtkSMProxyProperty_EnableProxyCreation(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "EnableProxyCreation");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkSMProxyProperty::EnableProxyCreation();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_DisableProxyCreation(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "DisableProxyCreation");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkSMProxyProperty::DisableProxyCreation();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_CanCreateProxy(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CanCreateProxy");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkSMProxyProperty::CanCreateProxy();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMProxyProperty::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMProxyProperty::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMProxyProperty *tempr = vtkSMProxyProperty::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProxyProperty *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMProxyProperty::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMProxyProperty::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMProxyProperty::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_AddProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->AddProxy(temp0);
    }
    else
    {
      op->vtkSMProxyProperty::AddProxy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_SetProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  unsigned int temp0;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->SetProxy(temp0, temp1);
    }
    else
    {
      op->vtkSMProxyProperty::SetProxy(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_RemoveProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->RemoveProxy(temp0);
    }
    else
    {
      op->vtkSMProxyProperty::RemoveProxy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_RemoveAllProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllProxies();
    }
    else
    {
      op->vtkSMProxyProperty::RemoveAllProxies();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_IsProxyAdded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsProxyAdded");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->IsProxyAdded(temp0) :
      op->vtkSMProxyProperty::IsProxyAdded(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_AddUncheckedProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddUncheckedProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->AddUncheckedProxy(temp0);
    }
    else
    {
      op->vtkSMProxyProperty::AddUncheckedProxy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_SetUncheckedProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUncheckedProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  unsigned int temp0;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->SetUncheckedProxy(temp0, temp1);
    }
    else
    {
      op->vtkSMProxyProperty::SetUncheckedProxy(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_RemoveAllUncheckedProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllUncheckedProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllUncheckedProxies();
    }
    else
    {
      op->vtkSMProxyProperty::RemoveAllUncheckedProxies();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_ClearUncheckedElements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearUncheckedElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearUncheckedElements();
    }
    else
    {
      op->vtkSMProxyProperty::ClearUncheckedElements();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_GetNumberOfProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfProxies() :
      op->vtkSMProxyProperty::GetNumberOfProxies());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_GetNumberOfUncheckedProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfUncheckedProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfUncheckedProxies() :
      op->vtkSMProxyProperty::GetNumberOfUncheckedProxies());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_SetNumberOfProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfProxies(temp0);
    }
    else
    {
      op->vtkSMProxyProperty::SetNumberOfProxies(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_SetNumberOfUncheckedProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfUncheckedProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfUncheckedProxies(temp0);
    }
    else
    {
      op->vtkSMProxyProperty::SetNumberOfUncheckedProxies(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_GetProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetProxy(temp0) :
      op->vtkSMProxyProperty::GetProxy(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_GetUncheckedProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUncheckedProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetUncheckedProxy(temp0) :
      op->vtkSMProxyProperty::GetUncheckedProxy(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_Copy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Copy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  vtkSMProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProperty"))
  {
    if (ap.IsBound())
    {
      op->Copy(temp0);
    }
    else
    {
      op->vtkSMProxyProperty::Copy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_UpdateAllInputs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateAllInputs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateAllInputs();
    }
    else
    {
      op->vtkSMProxyProperty::UpdateAllInputs();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_ResetDefaultsToCurrent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetDefaultsToCurrent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetDefaultsToCurrent();
    }
    else
    {
      op->vtkSMProxyProperty::ResetDefaultsToCurrent();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_IsValueDefault(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsValueDefault");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsValueDefault() :
      op->vtkSMProxyProperty::IsValueDefault());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_IsValueDefaultNonRecursive(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsValueDefaultNonRecursive");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsValueDefaultNonRecursive() :
      op->vtkSMProxyProperty::IsValueDefaultNonRecursive());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyProperty_ResetToXMLDefaults(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetToXMLDefaults");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyProperty *op = static_cast<vtkSMProxyProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetToXMLDefaults();
    }
    else
    {
      op->vtkSMProxyProperty::ResetToXMLDefaults();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMProxyProperty_Methods[] = {
  {"EnableProxyCreation", PyvtkSMProxyProperty_EnableProxyCreation, METH_VARARGS,
   "EnableProxyCreation() -> None\nC++: static void EnableProxyCreation()\n\nWhen we load ProxyManager state we want Proxy/InputProperty to be\nable to create the corresponding missing proxy. Although when the\ngoal is to load a state on any standard proxy, we do not want\nthat proxy property be able to create new proxy based on some\nprevious state.\n"},
  {"DisableProxyCreation", PyvtkSMProxyProperty_DisableProxyCreation, METH_VARARGS,
   "DisableProxyCreation() -> None\nC++: static void DisableProxyCreation()\n\n"},
  {"CanCreateProxy", PyvtkSMProxyProperty_CanCreateProxy, METH_VARARGS,
   "CanCreateProxy() -> bool\nC++: static bool CanCreateProxy()\n\n"},
  {"IsTypeOf", PyvtkSMProxyProperty_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMProxyProperty_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMProxyProperty_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMProxyProperty\nC++: static vtkSMProxyProperty *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMProxyProperty_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMProxyProperty\nC++: vtkSMProxyProperty *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMProxyProperty_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMProxyProperty_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"AddProxy", PyvtkSMProxyProperty_AddProxy, METH_VARARGS,
   "AddProxy(self, proxy:vtkSMProxy) -> None\nC++: virtual void AddProxy(vtkSMProxy *proxy)\n\nAdd/remove/set a proxy to the list of proxies. For SetProxy, the\nproperty automatically resizes to accommodate the index\nspecified.\n"},
  {"SetProxy", PyvtkSMProxyProperty_SetProxy, METH_VARARGS,
   "SetProxy(self, idx:int, proxy:vtkSMProxy) -> None\nC++: virtual void SetProxy(unsigned int idx, vtkSMProxy *proxy)\n\n"},
  {"RemoveProxy", PyvtkSMProxyProperty_RemoveProxy, METH_VARARGS,
   "RemoveProxy(self, proxy:vtkSMProxy) -> None\nC++: virtual void RemoveProxy(vtkSMProxy *proxy)\n\n"},
  {"RemoveAllProxies", PyvtkSMProxyProperty_RemoveAllProxies, METH_VARARGS,
   "RemoveAllProxies(self) -> None\nC++: virtual void RemoveAllProxies()\n\n"},
  {"IsProxyAdded", PyvtkSMProxyProperty_IsProxyAdded, METH_VARARGS,
   "IsProxyAdded(self, proxy:vtkSMProxy) -> bool\nC++: bool IsProxyAdded(vtkSMProxy *proxy)\n\nReturns if the given proxy is already added to the property.\n"},
  {"AddUncheckedProxy", PyvtkSMProxyProperty_AddUncheckedProxy, METH_VARARGS,
   "AddUncheckedProxy(self, proxy:vtkSMProxy) -> None\nC++: virtual void AddUncheckedProxy(vtkSMProxy *proxy)\n\nAdd an unchecked proxy. Does not modify the property. Unchecked\nproxies are used by domains when verifying whether a value is\nacceptable. To check if a value is in the domains, you can do the\nfollowing:\n - RemoveAllUncheckedProxies()\n - AddUncheckedProxy(proxy)\n - IsInDomains()\n \n"},
  {"SetUncheckedProxy", PyvtkSMProxyProperty_SetUncheckedProxy, METH_VARARGS,
   "SetUncheckedProxy(self, idx:int, proxy:vtkSMProxy) -> None\nC++: virtual void SetUncheckedProxy(unsigned int idx,\n    vtkSMProxy *proxy)\n\n"},
  {"RemoveAllUncheckedProxies", PyvtkSMProxyProperty_RemoveAllUncheckedProxies, METH_VARARGS,
   "RemoveAllUncheckedProxies(self) -> None\nC++: virtual void RemoveAllUncheckedProxies()\n\nRemoves all unchecked proxies.\n"},
  {"ClearUncheckedElements", PyvtkSMProxyProperty_ClearUncheckedElements, METH_VARARGS,
   "ClearUncheckedElements(self) -> None\nC++: void ClearUncheckedElements() override;\n\nUse this method to clear unchecked values set of this property.\n"},
  {"GetNumberOfProxies", PyvtkSMProxyProperty_GetNumberOfProxies, METH_VARARGS,
   "GetNumberOfProxies(self) -> int\nC++: unsigned int GetNumberOfProxies()\n\nReturns the number of proxies.\n"},
  {"GetNumberOfUncheckedProxies", PyvtkSMProxyProperty_GetNumberOfUncheckedProxies, METH_VARARGS,
   "GetNumberOfUncheckedProxies(self) -> int\nC++: unsigned int GetNumberOfUncheckedProxies()\n\nReturns the number of unchecked proxies.\n"},
  {"SetNumberOfProxies", PyvtkSMProxyProperty_SetNumberOfProxies, METH_VARARGS,
   "SetNumberOfProxies(self, count:int) -> None\nC++: void SetNumberOfProxies(unsigned int count)\n\nSet the number of proxies.\n"},
  {"SetNumberOfUncheckedProxies", PyvtkSMProxyProperty_SetNumberOfUncheckedProxies, METH_VARARGS,
   "SetNumberOfUncheckedProxies(self, count:int) -> None\nC++: void SetNumberOfUncheckedProxies(unsigned int count)\n\n"},
  {"GetProxy", PyvtkSMProxyProperty_GetProxy, METH_VARARGS,
   "GetProxy(self, idx:int) -> vtkSMProxy\nC++: vtkSMProxy *GetProxy(unsigned int idx)\n\nReturn a proxy. No bounds check is performed.\n"},
  {"GetUncheckedProxy", PyvtkSMProxyProperty_GetUncheckedProxy, METH_VARARGS,
   "GetUncheckedProxy(self, idx:int) -> vtkSMProxy\nC++: vtkSMProxy *GetUncheckedProxy(unsigned int idx)\n\nReturn a proxy. No bounds check is performed.\n"},
  {"Copy", PyvtkSMProxyProperty_Copy, METH_VARARGS,
   "Copy(self, src:vtkSMProperty) -> None\nC++: void Copy(vtkSMProperty *src) override;\n\nCopy all property values. This method behaves differently for\nproperties with vtkSMProxyListDomain and those without it. If the\nproperty has a vtkSMProxyListDomain, then the property is acting\nas an enumeration, giving user ability to pick one of the\navailable proxies in the domain, hence a `Copy` request, will\nfind an equivalent proxy on the target's domain and set that as\nthe value of the target property.\n"},
  {"UpdateAllInputs", PyvtkSMProxyProperty_UpdateAllInputs, METH_VARARGS,
   "UpdateAllInputs(self) -> None\nC++: void UpdateAllInputs() override;\n\nUpdate all proxies referred by this property (if any).\n"},
  {"ResetDefaultsToCurrent", PyvtkSMProxyProperty_ResetDefaultsToCurrent, METH_VARARGS,
   "ResetDefaultsToCurrent(self) -> None\nC++: void ResetDefaultsToCurrent()\n\nSet all of the current proxies and ports to be the default ones\n"},
  {"IsValueDefault", PyvtkSMProxyProperty_IsValueDefault, METH_VARARGS,
   "IsValueDefault(self) -> bool\nC++: bool IsValueDefault() override;\n\nCheck if the current proxies and ports match the default ones,\nand that each proxy has default properties as well (which is\nrecursive, since properties of proxy properties can also be proxy\nproperties).\n\nNote: internal properties are ignored. This is so that properties\nsuch as `Input` do not affect `IsValueDefault()`.\n"},
  {"IsValueDefaultNonRecursive", PyvtkSMProxyProperty_IsValueDefaultNonRecursive, METH_VARARGS,
   "IsValueDefaultNonRecursive(self) -> bool\nC++: bool IsValueDefaultNonRecursive()\n\nCheck if the current proxies and ports match the default ones,\nbut do not check that each proxy has default properties. This is\nessentially a non-recursive version of `IsValueDefault()`.\n"},
  {"ResetToXMLDefaults", PyvtkSMProxyProperty_ResetToXMLDefaults, METH_VARARGS,
   "ResetToXMLDefaults(self) -> None\nC++: void ResetToXMLDefaults() override;\n\nFor properties that support specifying defaults in XML\nconfiguration, this method will reset the property value to the\ndefault values specified in the XML. Simply clears the property.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMProxyProperty_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("number_of_proxies"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyProperty_GetNumberOfProxies(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMProxyProperty_SetNumberOfProxies(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMProxyProperty_SetNumberOfProxies(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfProxies/SetNumberOfProxies\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_unchecked_proxies"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyProperty_GetNumberOfUncheckedProxies(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMProxyProperty_SetNumberOfUncheckedProxies(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMProxyProperty_SetNumberOfUncheckedProxies(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfUncheckedProxies/SetNumberOfUncheckedProxies\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMProxyProperty_Doc =
  "vtkSMProxyProperty - property representing pointer(s) to vtkObject(s)\n\n"
  "Superclass: vtkSMProperty\n\n"
  "vtkSMProxyProperty is a concrete sub-class of vtkSMProperty\n"
  "representing pointer(s) to vtkObject(s) (through vtkSMProxy).\n\n"
  "vtkSMProperty::UpdateDomains() is called by vtkSMProperty itself\n"
  "whenever its unchecked values are modified. In case of\n"
  "proxy-properties, the dependent domains typically tend to depend on\n"
  "the data information provided by the source-proxies added to the\n"
  "property. Thus, to ensure that the domains get updated if the data\n"
  "information changes, vtkSMProxyProperty ensures that\n"
  "vtkSMProperty::UpdateDomains() is called whenever any of the added\n"
  "proxies fires the vtkCommand::UpdateDataEvent (which is fired\n"
  "whenever the pipeline us updated through the ServerManager indicating\n"
  "that the data-information last used may have been invalidated).\n\n"
  "Besides the standard set of attributes, the following XML attributes\n"
  "are supported:\n"
  "\\li command : identifies the method to call on the VTK object e.g.\n"
  "AddRepresentation.\n"
  "\\li clean_command : if present, called once before invoking the\n"
  "    method\n"
  "specified by command every time the property value is pushed e.g.\n"
  "RemoveAllRepresentations. If property can take multiple values then\n"
  "the command is called for for each of the values after the clean\n"
  "command for every push.\n"
  "\\li remove_command : an alternative to clean_command where instead of\n"
  "resetting and adding all the values for every push, this simply calls\n"
  "the specified method to remove the vtk-objects no longer referred to\n"
  "e.g. RemoveRepresentation.\n"
  "\\li argument_type : identifies the type for value passed to the\n"
  "    method on the\n"
  "VTK object. Accepted values are \"VTK\", \"SMProxy\" or \"SIProxy\".\n"
  "Default is VTK.\n"
  "\\li null_on_empty : if set to 1, whenever the property's value\n"
  "    changes to\n"
  "empty i.e. it contains no proxies, the command is called on the VTK\n"
  "object with nullptr argument useful when there's no clean_command\n"
  "that can be called on the VTK object to unset the property e.g.\n"
  "SetLookupTable(nullptr).\n"
  "\\li skip_dependency: obsolete and no longer supported. This was\n"
  "    intended for\n"
  "vtkSMRepresentationProxy to distinguish between proxy connections\n"
  "that invalidate representation pipeline (e.g. input) and those that\n"
  "don't (e.g. LookupTable). vtkSMRepresentationProxy now handles this\n"
  "automatically.\n"
  "@sa\n"
  "vtkSMProperty\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMProxyProperty_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMProxyProperty", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMProxyProperty_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMProxyProperty_StaticNew()
{
  return vtkSMProxyProperty::New();
}

PyObject *PyvtkSMProxyProperty_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMProxyProperty_Type, PyvtkSMProxyProperty_Methods,
    "vtkSMProxyProperty",
 &PyvtkSMProxyProperty_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMProperty_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMProxyProperty_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMProxyProperty(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMProxyProperty_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMProxyProperty", o) != 0)
  {
    Py_DECREF(o);
  }

}

