// python wrapper for vtkLogRecorder
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkLogRecorder.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkLogRecorder(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkLogRecorder_ClassNew(); }


static PyObject *
PyvtkLogRecorder_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkLogRecorder::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkLogRecorder::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkLogRecorder *tempr = vtkLogRecorder::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkLogRecorder *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkLogRecorder::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkLogRecorder::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkLogRecorder::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_SetVerbosity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVerbosity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVerbosity(temp0);
    }
    else
    {
      op->vtkLogRecorder::SetVerbosity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_GetVerbosity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVerbosity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetVerbosity() :
      op->vtkLogRecorder::GetVerbosity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_SetRankEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRankEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRankEnabled(temp0);
    }
    else
    {
      op->vtkLogRecorder::SetRankEnabled(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_SetRankDisabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRankDisabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRankDisabled(temp0);
    }
    else
    {
      op->vtkLogRecorder::SetRankDisabled(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_GetLogs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLogs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetLogs() :
      &op->vtkLogRecorder::GetLogs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_GetStartingLog(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStartingLog");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetStartingLog() :
      &op->vtkLogRecorder::GetStartingLog());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_GetMyRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMyRank");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMyRank() :
      op->vtkLogRecorder::GetMyRank());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_ClearLogs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLogs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLogs();
    }
    else
    {
      op->vtkLogRecorder::ClearLogs();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_SetCategoryVerbosity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCategoryVerbosity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetCategoryVerbosity(temp0, temp1);
    }
    else
    {
      op->vtkLogRecorder::SetCategoryVerbosity(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogRecorder_ResetCategoryVerbosities(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCategoryVerbosities");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogRecorder *op = static_cast<vtkLogRecorder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetCategoryVerbosities();
    }
    else
    {
      op->vtkLogRecorder::ResetCategoryVerbosities();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkLogRecorder_Methods[] = {
  {"IsTypeOf", PyvtkLogRecorder_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkLogRecorder_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkLogRecorder_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkLogRecorder\nC++: static vtkLogRecorder *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkLogRecorder_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkLogRecorder\nC++: vtkLogRecorder *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkLogRecorder_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkLogRecorder_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetVerbosity", PyvtkLogRecorder_SetVerbosity, METH_VARARGS,
   "SetVerbosity(self, verbosity:int) -> None\nC++: void SetVerbosity(int verbosity)\n\nSet/get the verbosity of the entries recorded from the log. Any\nmessages with verbosity less than or equal to this verbosity will\nbe recorded.\n"},
  {"GetVerbosity", PyvtkLogRecorder_GetVerbosity, METH_VARARGS,
   "GetVerbosity(self) -> int\nC++: virtual int GetVerbosity()\n\n"},
  {"SetRankEnabled", PyvtkLogRecorder_SetRankEnabled, METH_VARARGS,
   "SetRankEnabled(self, rank:int) -> None\nC++: void SetRankEnabled(int rank)\n\nSet to enable or disable logging, only if the rank parameter is\nequal to the rank that this log recorder is on.\n"},
  {"SetRankDisabled", PyvtkLogRecorder_SetRankDisabled, METH_VARARGS,
   "SetRankDisabled(self, rank:int) -> None\nC++: void SetRankDisabled(int rank)\n\n"},
  {"GetLogs", PyvtkLogRecorder_GetLogs, METH_VARARGS,
   "GetLogs(self) -> str\nC++: const std::string &GetLogs()\n\nGet the recorded logs.\n"},
  {"GetStartingLog", PyvtkLogRecorder_GetStartingLog, METH_VARARGS,
   "GetStartingLog(self) -> str\nC++: const std::string &GetStartingLog()\n\nGet the starting log.\n"},
  {"GetMyRank", PyvtkLogRecorder_GetMyRank, METH_VARARGS,
   "GetMyRank(self) -> int\nC++: virtual int GetMyRank()\n\nGet the rank the log recorder is on.\n"},
  {"ClearLogs", PyvtkLogRecorder_ClearLogs, METH_VARARGS,
   "ClearLogs(self) -> None\nC++: void ClearLogs()\n\nClear any logs recorded.\n"},
  {"SetCategoryVerbosity", PyvtkLogRecorder_SetCategoryVerbosity, METH_VARARGS,
   "SetCategoryVerbosity(self, categoryIndex:int, verbosity:int)\n    -> None\nC++: void SetCategoryVerbosity(int categoryIndex, int verbosity)\n\nSet the verbosity of a ParaView logging category.\n"},
  {"ResetCategoryVerbosities", PyvtkLogRecorder_ResetCategoryVerbosities, METH_VARARGS,
   "ResetCategoryVerbosities(self) -> None\nC++: void ResetCategoryVerbosities()\n\nClear custom verbosities set on all ParaView logging categories.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkLogRecorder_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("verbosity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLogRecorder_GetVerbosity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLogRecorder_SetVerbosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLogRecorder_SetVerbosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetVerbosity/SetVerbosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rank_enabled"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLogRecorder_SetRankEnabled(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLogRecorder_SetRankEnabled(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRankEnabled\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rank_disabled"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLogRecorder_SetRankDisabled(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLogRecorder_SetRankDisabled(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRankDisabled\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("category_verbosity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLogRecorder_SetCategoryVerbosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLogRecorder_SetCategoryVerbosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCategoryVerbosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("logs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLogRecorder_GetLogs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLogs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("starting_log"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLogRecorder_GetStartingLog(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetStartingLog\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("my_rank"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLogRecorder_GetMyRank(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMyRank\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkLogRecorder_Doc =
  "vtkLogRecorder - Record log messages at or below a given verbosity on\na particular ParaView process/rank.\n\n"
  "Superclass: vtkObject\n\n"
  "This class can be used to record log messages at or below a verbosity\n"
  "specified by SetVerbosity(). If the process is run as an MPI job, the\n"
  "log messages from a rank enabled via SetRankEnabled() will be\n"
  "recorded.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkLogRecorder_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsCore.vtkLogRecorder", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkLogRecorder_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkLogRecorder_StaticNew()
{
  return vtkLogRecorder::New();
}

PyObject *PyvtkLogRecorder_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkLogRecorder_Type, PyvtkLogRecorder_Methods,
    "vtkLogRecorder",
 &PyvtkLogRecorder_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkLogRecorder_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkLogRecorder(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkLogRecorder_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkLogRecorder", o) != 0)
  {
    Py_DECREF(o);
  }

}

