#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkPVGL2PSExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVWebExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVX3DExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMCSVExporterProxy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMCSVProxiesInitializationHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMExporterProxy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMGL2PSExporterProxy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMPropArrayListDomain_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMRenderViewExporterProxy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMViewExportHelper_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkRemotingExportCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkPVGL2PSExporter_Init(csi);
  vtkPVWebExporter_Init(csi);
  vtkPVX3DExporter_Init(csi);
  vtkSMCSVExporterProxy_Init(csi);
  vtkSMCSVProxiesInitializationHelper_Init(csi);
  vtkSMExporterProxy_Init(csi);
  vtkSMGL2PSExporterProxy_Init(csi);
  vtkSMPropArrayListDomain_Init(csi);
  vtkSMRenderViewExporterProxy_Init(csi);
  vtkSMViewExportHelper_Init(csi);
}
