// python wrapper for vtkPVExtractHistogram2D
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVExtractHistogram2D.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVExtractHistogram2D(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVExtractHistogram2D_ClassNew(); }


static PyObject *
PyvtkPVExtractHistogram2D_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVExtractHistogram2D::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVExtractHistogram2D::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVExtractHistogram2D *tempr = vtkPVExtractHistogram2D::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVExtractHistogram2D *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVExtractHistogram2D::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVExtractHistogram2D::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVExtractHistogram2D::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkPVExtractHistogram2D::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetComponent0(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent0");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComponent0(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetComponent0(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetComponent0(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent0");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetComponent0() :
      op->vtkPVExtractHistogram2D::GetComponent0());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetComponent1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComponent1(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetComponent1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetComponent1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetComponent1() :
      op->vtkPVExtractHistogram2D::GetComponent1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0, temp1);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetComponent(temp0) :
      op->vtkPVExtractHistogram2D::GetComponent(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetNumberOfBins_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfBins");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfBins(temp0, temp1);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetNumberOfBins(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVExtractHistogram2D_SetNumberOfBins_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfBins");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfBins(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetNumberOfBins(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVExtractHistogram2D_SetNumberOfBins(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVExtractHistogram2D_SetNumberOfBins_s1(self, args);
    case 1:
      return PyvtkPVExtractHistogram2D_SetNumberOfBins_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetNumberOfBins");
  return nullptr;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetNumberOfBins(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfBins");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetNumberOfBins() :
      op->vtkPVExtractHistogram2D::GetNumberOfBins());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetCustomBinRanges0_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomBinRanges0");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetCustomBinRanges0(temp0, temp1);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetCustomBinRanges0(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVExtractHistogram2D_SetCustomBinRanges0_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomBinRanges0");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCustomBinRanges0(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetCustomBinRanges0(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVExtractHistogram2D_SetCustomBinRanges0(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVExtractHistogram2D_SetCustomBinRanges0_s1(self, args);
    case 1:
      return PyvtkPVExtractHistogram2D_SetCustomBinRanges0_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCustomBinRanges0");
  return nullptr;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetCustomBinRanges0(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCustomBinRanges0");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetCustomBinRanges0() :
      op->vtkPVExtractHistogram2D::GetCustomBinRanges0());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetCustomBinRanges1_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomBinRanges1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetCustomBinRanges1(temp0, temp1);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetCustomBinRanges1(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVExtractHistogram2D_SetCustomBinRanges1_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomBinRanges1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCustomBinRanges1(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetCustomBinRanges1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVExtractHistogram2D_SetCustomBinRanges1(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVExtractHistogram2D_SetCustomBinRanges1_s1(self, args);
    case 1:
      return PyvtkPVExtractHistogram2D_SetCustomBinRanges1_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCustomBinRanges1");
  return nullptr;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetCustomBinRanges1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCustomBinRanges1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetCustomBinRanges1() :
      op->vtkPVExtractHistogram2D::GetCustomBinRanges1());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetUseCustomBinRanges0(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseCustomBinRanges0");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseCustomBinRanges0(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetUseCustomBinRanges0(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetUseCustomBinRanges0(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseCustomBinRanges0");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseCustomBinRanges0() :
      op->vtkPVExtractHistogram2D::GetUseCustomBinRanges0());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_UseCustomBinRanges0On(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseCustomBinRanges0On");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseCustomBinRanges0On();
    }
    else
    {
      op->vtkPVExtractHistogram2D::UseCustomBinRanges0On();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_UseCustomBinRanges0Off(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseCustomBinRanges0Off");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseCustomBinRanges0Off();
    }
    else
    {
      op->vtkPVExtractHistogram2D::UseCustomBinRanges0Off();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetUseCustomBinRanges1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseCustomBinRanges1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseCustomBinRanges1(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetUseCustomBinRanges1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetUseCustomBinRanges1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseCustomBinRanges1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseCustomBinRanges1() :
      op->vtkPVExtractHistogram2D::GetUseCustomBinRanges1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_UseCustomBinRanges1On(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseCustomBinRanges1On");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseCustomBinRanges1On();
    }
    else
    {
      op->vtkPVExtractHistogram2D::UseCustomBinRanges1On();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_UseCustomBinRanges1Off(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseCustomBinRanges1Off");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseCustomBinRanges1Off();
    }
    else
    {
      op->vtkPVExtractHistogram2D::UseCustomBinRanges1Off();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetUseGradientForYAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseGradientForYAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseGradientForYAxis(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetUseGradientForYAxis(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetUseGradientForYAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseGradientForYAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseGradientForYAxis() :
      op->vtkPVExtractHistogram2D::GetUseGradientForYAxis());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_UseGradientForYAxisOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseGradientForYAxisOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseGradientForYAxisOn();
    }
    else
    {
      op->vtkPVExtractHistogram2D::UseGradientForYAxisOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_UseGradientForYAxisOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseGradientForYAxisOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseGradientForYAxisOff();
    }
    else
    {
      op->vtkPVExtractHistogram2D::UseGradientForYAxisOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetUseInputRangesForOutputBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseInputRangesForOutputBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseInputRangesForOutputBounds(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetUseInputRangesForOutputBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetUseInputRangesForOutputBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseInputRangesForOutputBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseInputRangesForOutputBounds() :
      op->vtkPVExtractHistogram2D::GetUseInputRangesForOutputBounds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_UseInputRangesForOutputBoundsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseInputRangesForOutputBoundsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseInputRangesForOutputBoundsOn();
    }
    else
    {
      op->vtkPVExtractHistogram2D::UseInputRangesForOutputBoundsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_UseInputRangesForOutputBoundsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseInputRangesForOutputBoundsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseInputRangesForOutputBoundsOff();
    }
    else
    {
      op->vtkPVExtractHistogram2D::UseInputRangesForOutputBoundsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetOutputOrigin_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetOutputOrigin(temp0, temp1);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetOutputOrigin(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVExtractHistogram2D_SetOutputOrigin_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetOutputOrigin(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetOutputOrigin(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVExtractHistogram2D_SetOutputOrigin(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVExtractHistogram2D_SetOutputOrigin_s1(self, args);
    case 1:
      return PyvtkPVExtractHistogram2D_SetOutputOrigin_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetOutputOrigin");
  return nullptr;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetOutputOrigin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetOutputOrigin() :
      op->vtkPVExtractHistogram2D::GetOutputOrigin());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVExtractHistogram2D_SetOutputSpacing_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetOutputSpacing(temp0, temp1);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetOutputSpacing(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVExtractHistogram2D_SetOutputSpacing_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetOutputSpacing(temp0);
    }
    else
    {
      op->vtkPVExtractHistogram2D::SetOutputSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVExtractHistogram2D_SetOutputSpacing(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVExtractHistogram2D_SetOutputSpacing_s1(self, args);
    case 1:
      return PyvtkPVExtractHistogram2D_SetOutputSpacing_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetOutputSpacing");
  return nullptr;
}


static PyObject *
PyvtkPVExtractHistogram2D_GetOutputSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVExtractHistogram2D *op = static_cast<vtkPVExtractHistogram2D *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetOutputSpacing() :
      op->vtkPVExtractHistogram2D::GetOutputSpacing());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVExtractHistogram2D_Methods[] = {
  {"IsTypeOf", PyvtkPVExtractHistogram2D_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVExtractHistogram2D_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVExtractHistogram2D_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVExtractHistogram2D\nC++: static vtkPVExtractHistogram2D *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVExtractHistogram2D_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVExtractHistogram2D\nC++: vtkPVExtractHistogram2D *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVExtractHistogram2D_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVExtractHistogram2D_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetController", PyvtkPVExtractHistogram2D_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: virtual void SetController(vtkMultiProcessController *)\n\nGet/Set the multiprocess controller. If no controller is set,\nsingle process is assumed.\n"},
  {"GetController", PyvtkPVExtractHistogram2D_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {"SetComponent0", PyvtkPVExtractHistogram2D_SetComponent0, METH_VARARGS,
   "SetComponent0(self, _arg:int) -> None\nC++: virtual void SetComponent0(int _arg)\n\nSet/Get the components of interest from the two arrays.\nComponent0 is the component from input array 0 and Component1 is\nthe component from input array\n1. Set the input arrays using SetInputArrayToProcess.\n"},
  {"GetComponent0", PyvtkPVExtractHistogram2D_GetComponent0, METH_VARARGS,
   "GetComponent0(self) -> int\nC++: virtual int GetComponent0()\n\n"},
  {"SetComponent1", PyvtkPVExtractHistogram2D_SetComponent1, METH_VARARGS,
   "SetComponent1(self, _arg:int) -> None\nC++: virtual void SetComponent1(int _arg)\n\n"},
  {"GetComponent1", PyvtkPVExtractHistogram2D_GetComponent1, METH_VARARGS,
   "GetComponent1(self) -> int\nC++: virtual int GetComponent1()\n\n"},
  {"SetComponent", PyvtkPVExtractHistogram2D_SetComponent, METH_VARARGS,
   "SetComponent(self, id:int, val:int) -> None\nC++: void SetComponent(int id, int val)\n\n"},
  {"GetComponent", PyvtkPVExtractHistogram2D_GetComponent, METH_VARARGS,
   "GetComponent(self, id:int) -> int\nC++: int GetComponent(int id)\n\n"},
  {"SetNumberOfBins", PyvtkPVExtractHistogram2D_SetNumberOfBins, METH_VARARGS,
   "SetNumberOfBins(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetNumberOfBins(int _arg1, int _arg2)\nSetNumberOfBins(self, _arg:(int, int)) -> None\nC++: void SetNumberOfBins(const int _arg[2])\n\nSet/get the number of bins to be used per dimension (x,y)\n"},
  {"GetNumberOfBins", PyvtkPVExtractHistogram2D_GetNumberOfBins, METH_VARARGS,
   "GetNumberOfBins(self) -> (int, int)\nC++: virtual int *GetNumberOfBins()\n\n"},
  {"SetCustomBinRanges0", PyvtkPVExtractHistogram2D_SetCustomBinRanges0, METH_VARARGS,
   "SetCustomBinRanges0(self, _arg1:float, _arg2:float) -> None\nC++: virtual void SetCustomBinRanges0(double _arg1, double _arg2)\nSetCustomBinRanges0(self, _arg:(float, float)) -> None\nC++: void SetCustomBinRanges0(const double _arg[2])\n\nSet/Get whether to use custom bin ranges.\n"},
  {"GetCustomBinRanges0", PyvtkPVExtractHistogram2D_GetCustomBinRanges0, METH_VARARGS,
   "GetCustomBinRanges0(self) -> (float, float)\nC++: virtual double *GetCustomBinRanges0()\n\n"},
  {"SetCustomBinRanges1", PyvtkPVExtractHistogram2D_SetCustomBinRanges1, METH_VARARGS,
   "SetCustomBinRanges1(self, _arg1:float, _arg2:float) -> None\nC++: virtual void SetCustomBinRanges1(double _arg1, double _arg2)\nSetCustomBinRanges1(self, _arg:(float, float)) -> None\nC++: void SetCustomBinRanges1(const double _arg[2])\n\n"},
  {"GetCustomBinRanges1", PyvtkPVExtractHistogram2D_GetCustomBinRanges1, METH_VARARGS,
   "GetCustomBinRanges1(self) -> (float, float)\nC++: virtual double *GetCustomBinRanges1()\n\n"},
  {"SetUseCustomBinRanges0", PyvtkPVExtractHistogram2D_SetUseCustomBinRanges0, METH_VARARGS,
   "SetUseCustomBinRanges0(self, _arg:bool) -> None\nC++: virtual void SetUseCustomBinRanges0(bool _arg)\n\n"},
  {"GetUseCustomBinRanges0", PyvtkPVExtractHistogram2D_GetUseCustomBinRanges0, METH_VARARGS,
   "GetUseCustomBinRanges0(self) -> bool\nC++: virtual bool GetUseCustomBinRanges0()\n\n"},
  {"UseCustomBinRanges0On", PyvtkPVExtractHistogram2D_UseCustomBinRanges0On, METH_VARARGS,
   "UseCustomBinRanges0On(self) -> None\nC++: virtual void UseCustomBinRanges0On()\n\n"},
  {"UseCustomBinRanges0Off", PyvtkPVExtractHistogram2D_UseCustomBinRanges0Off, METH_VARARGS,
   "UseCustomBinRanges0Off(self) -> None\nC++: virtual void UseCustomBinRanges0Off()\n\n"},
  {"SetUseCustomBinRanges1", PyvtkPVExtractHistogram2D_SetUseCustomBinRanges1, METH_VARARGS,
   "SetUseCustomBinRanges1(self, _arg:bool) -> None\nC++: virtual void SetUseCustomBinRanges1(bool _arg)\n\n"},
  {"GetUseCustomBinRanges1", PyvtkPVExtractHistogram2D_GetUseCustomBinRanges1, METH_VARARGS,
   "GetUseCustomBinRanges1(self) -> bool\nC++: virtual bool GetUseCustomBinRanges1()\n\n"},
  {"UseCustomBinRanges1On", PyvtkPVExtractHistogram2D_UseCustomBinRanges1On, METH_VARARGS,
   "UseCustomBinRanges1On(self) -> None\nC++: virtual void UseCustomBinRanges1On()\n\n"},
  {"UseCustomBinRanges1Off", PyvtkPVExtractHistogram2D_UseCustomBinRanges1Off, METH_VARARGS,
   "UseCustomBinRanges1Off(self) -> None\nC++: virtual void UseCustomBinRanges1Off()\n\n"},
  {"SetUseGradientForYAxis", PyvtkPVExtractHistogram2D_SetUseGradientForYAxis, METH_VARARGS,
   "SetUseGradientForYAxis(self, _arg:bool) -> None\nC++: virtual void SetUseGradientForYAxis(bool _arg)\n\nSet/Get whether to use the gradient of the scalar array as the\nY-axis of the 2D histogram\n"},
  {"GetUseGradientForYAxis", PyvtkPVExtractHistogram2D_GetUseGradientForYAxis, METH_VARARGS,
   "GetUseGradientForYAxis(self) -> bool\nC++: virtual bool GetUseGradientForYAxis()\n\n"},
  {"UseGradientForYAxisOn", PyvtkPVExtractHistogram2D_UseGradientForYAxisOn, METH_VARARGS,
   "UseGradientForYAxisOn(self) -> None\nC++: virtual void UseGradientForYAxisOn()\n\n"},
  {"UseGradientForYAxisOff", PyvtkPVExtractHistogram2D_UseGradientForYAxisOff, METH_VARARGS,
   "UseGradientForYAxisOff(self) -> None\nC++: virtual void UseGradientForYAxisOff()\n\n"},
  {"SetUseInputRangesForOutputBounds", PyvtkPVExtractHistogram2D_SetUseInputRangesForOutputBounds, METH_VARARGS,
   "SetUseInputRangesForOutputBounds(self, _arg:bool) -> None\nC++: virtual void SetUseInputRangesForOutputBounds(bool _arg)\n\nSet/Get whether the output image bounds are obtained from input\ndata array ranges. This means that if the input data array ranges\nare [r1min, r1max] and [r2min, r2max], the output histogram image\nwould have bounds [r1min, r1max, r2min, r2max, 0, 0], when this\nflag is enabled. The output spacing is determined based on these\nbounds and the number of bins.\n\\sa SetNumberOfBins(), SetOutputSpacing(), SetOutputOrigin()\n"},
  {"GetUseInputRangesForOutputBounds", PyvtkPVExtractHistogram2D_GetUseInputRangesForOutputBounds, METH_VARARGS,
   "GetUseInputRangesForOutputBounds(self) -> bool\nC++: virtual bool GetUseInputRangesForOutputBounds()\n\n"},
  {"UseInputRangesForOutputBoundsOn", PyvtkPVExtractHistogram2D_UseInputRangesForOutputBoundsOn, METH_VARARGS,
   "UseInputRangesForOutputBoundsOn(self) -> None\nC++: virtual void UseInputRangesForOutputBoundsOn()\n\n"},
  {"UseInputRangesForOutputBoundsOff", PyvtkPVExtractHistogram2D_UseInputRangesForOutputBoundsOff, METH_VARARGS,
   "UseInputRangesForOutputBoundsOff(self) -> None\nC++: virtual void UseInputRangesForOutputBoundsOff()\n\n"},
  {"SetOutputOrigin", PyvtkPVExtractHistogram2D_SetOutputOrigin, METH_VARARGS,
   "SetOutputOrigin(self, _arg1:float, _arg2:float) -> None\nC++: virtual void SetOutputOrigin(double _arg1, double _arg2)\nSetOutputOrigin(self, _arg:(float, float)) -> None\nC++: void SetOutputOrigin(const double _arg[2])\n\nSet/Get the output histogram image origin and spacing.\n\note This is only used if UseInputRangesForOutputBounds is\ndisabled.\n\\sa SetUseInputRangesForOutputBounds()\n"},
  {"GetOutputOrigin", PyvtkPVExtractHistogram2D_GetOutputOrigin, METH_VARARGS,
   "GetOutputOrigin(self) -> (float, float)\nC++: virtual double *GetOutputOrigin()\n\n"},
  {"SetOutputSpacing", PyvtkPVExtractHistogram2D_SetOutputSpacing, METH_VARARGS,
   "SetOutputSpacing(self, _arg1:float, _arg2:float) -> None\nC++: virtual void SetOutputSpacing(double _arg1, double _arg2)\nSetOutputSpacing(self, _arg:(float, float)) -> None\nC++: void SetOutputSpacing(const double _arg[2])\n\n"},
  {"GetOutputSpacing", PyvtkPVExtractHistogram2D_GetOutputSpacing, METH_VARARGS,
   "GetOutputSpacing(self) -> (float, float)\nC++: virtual double *GetOutputSpacing()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVExtractHistogram2D_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("component0"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetComponent0(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetComponent0(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetComponent0(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComponent0/SetComponent0\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("component1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetComponent1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetComponent1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetComponent1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComponent1/SetComponent1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("component"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetComponent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetComponent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetComponent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_bin_ranges0"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetCustomBinRanges0(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetCustomBinRanges0(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetCustomBinRanges0(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCustomBinRanges0/SetCustomBinRanges0\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_bin_ranges1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetCustomBinRanges1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetCustomBinRanges1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetCustomBinRanges1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCustomBinRanges1/SetCustomBinRanges1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_custom_bin_ranges0"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetUseCustomBinRanges0(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetUseCustomBinRanges0(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetUseCustomBinRanges0(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseCustomBinRanges0/SetUseCustomBinRanges0\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_custom_bin_ranges1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetUseCustomBinRanges1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetUseCustomBinRanges1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetUseCustomBinRanges1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseCustomBinRanges1/SetUseCustomBinRanges1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_gradient_for_y_axis"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetUseGradientForYAxis(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetUseGradientForYAxis(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetUseGradientForYAxis(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseGradientForYAxis/SetUseGradientForYAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_input_ranges_for_output_bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetUseInputRangesForOutputBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetUseInputRangesForOutputBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetUseInputRangesForOutputBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseInputRangesForOutputBounds/SetUseInputRangesForOutputBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_origin"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetOutputOrigin(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetOutputOrigin(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetOutputOrigin(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputOrigin/SetOutputOrigin\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetOutputSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetOutputSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetOutputSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputSpacing/SetOutputSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_bins"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVExtractHistogram2D_GetNumberOfBins(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVExtractHistogram2D_SetNumberOfBins(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVExtractHistogram2D_SetNumberOfBins(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfBins/SetNumberOfBins\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVExtractHistogram2D_Doc =
  "vtkPVExtractHistogram2D - Extract 2D histogram for a parallel dataset\n\n"
  "Superclass: vtkImageAlgorithm\n\n"
  "vtkPVExtractHistogram2D is a vtkImageAlgorithm subclass for parallel\n"
  "datasets, to extract the 2D histogram. It uses vtkExtractHistogram2D\n"
  "internally and gathers the histogram data on the root node.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVExtractHistogram2D_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsMisc.vtkPVExtractHistogram2D", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVExtractHistogram2D_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVExtractHistogram2D_StaticNew()
{
  return vtkPVExtractHistogram2D::New();
}

PyObject *PyvtkPVExtractHistogram2D_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVExtractHistogram2D_Type, PyvtkPVExtractHistogram2D_Methods,
    "vtkPVExtractHistogram2D",
 &PyvtkPVExtractHistogram2D_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkImageAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVExtractHistogram2D_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVExtractHistogram2D(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVExtractHistogram2D_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVExtractHistogram2D", o) != 0)
  {
    Py_DECREF(o);
  }

}

