// python wrapper for vtkCSVWriter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCSVWriter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCSVWriter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCSVWriter_ClassNew(); }


static PyObject *
PyvtkCSVWriter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCSVWriter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCSVWriter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCSVWriter *tempr = vtkCSVWriter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCSVWriter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCSVWriter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCSVWriter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCSVWriter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkCSVWriter::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetFieldDelimiter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFieldDelimiter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFieldDelimiter(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetFieldDelimiter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetFieldDelimiter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldDelimiter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFieldDelimiter() :
      op->vtkCSVWriter::GetFieldDelimiter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetStringDelimiter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStringDelimiter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStringDelimiter(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetStringDelimiter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetStringDelimiter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStringDelimiter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetStringDelimiter() :
      op->vtkCSVWriter::GetStringDelimiter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkCSVWriter::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetWriteAllTimeSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteAllTimeSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteAllTimeSteps(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetWriteAllTimeSteps(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetWriteAllTimeSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteAllTimeSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWriteAllTimeSteps() :
      op->vtkCSVWriter::GetWriteAllTimeSteps());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_WriteAllTimeStepsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteAllTimeStepsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteAllTimeStepsOn();
    }
    else
    {
      op->vtkCSVWriter::WriteAllTimeStepsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_WriteAllTimeStepsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteAllTimeStepsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteAllTimeStepsOff();
    }
    else
    {
      op->vtkCSVWriter::WriteAllTimeStepsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetWriteAllTimeStepsSeparately(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteAllTimeStepsSeparately");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteAllTimeStepsSeparately(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetWriteAllTimeStepsSeparately(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetWriteAllTimeStepsSeparately(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteAllTimeStepsSeparately");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWriteAllTimeStepsSeparately() :
      op->vtkCSVWriter::GetWriteAllTimeStepsSeparately());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_WriteAllTimeStepsSeparatelyOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteAllTimeStepsSeparatelyOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteAllTimeStepsSeparatelyOn();
    }
    else
    {
      op->vtkCSVWriter::WriteAllTimeStepsSeparatelyOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_WriteAllTimeStepsSeparatelyOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteAllTimeStepsSeparatelyOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteAllTimeStepsSeparatelyOff();
    }
    else
    {
      op->vtkCSVWriter::WriteAllTimeStepsSeparatelyOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetFileNameSuffix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileNameSuffix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileNameSuffix() :
      op->vtkCSVWriter::GetFileNameSuffix());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetFileNameSuffix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileNameSuffix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileNameSuffix(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetFileNameSuffix(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetUseStringDelimiter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseStringDelimiter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseStringDelimiter(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetUseStringDelimiter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetUseStringDelimiter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseStringDelimiter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseStringDelimiter() :
      op->vtkCSVWriter::GetUseStringDelimiter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPrecision(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetPrecisionMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPrecisionMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPrecisionMinValue() :
      op->vtkCSVWriter::GetPrecisionMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetPrecisionMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPrecisionMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPrecisionMaxValue() :
      op->vtkCSVWriter::GetPrecisionMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPrecision() :
      op->vtkCSVWriter::GetPrecision());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetUseScientificNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseScientificNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseScientificNotation(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetUseScientificNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetUseScientificNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseScientificNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseScientificNotation() :
      op->vtkCSVWriter::GetUseScientificNotation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_UseScientificNotationOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseScientificNotationOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseScientificNotationOn();
    }
    else
    {
      op->vtkCSVWriter::UseScientificNotationOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_UseScientificNotationOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseScientificNotationOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseScientificNotationOff();
    }
    else
    {
      op->vtkCSVWriter::UseScientificNotationOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetFieldAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFieldAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFieldAssociation(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetFieldAssociation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetFieldAssociationMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldAssociationMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldAssociationMinValue() :
      op->vtkCSVWriter::GetFieldAssociationMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetFieldAssociationMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldAssociationMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldAssociationMaxValue() :
      op->vtkCSVWriter::GetFieldAssociationMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetFieldAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldAssociation() :
      op->vtkCSVWriter::GetFieldAssociation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetAddMetaData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAddMetaData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAddMetaData(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetAddMetaData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetAddMetaData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAddMetaData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAddMetaData() :
      op->vtkCSVWriter::GetAddMetaData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_AddMetaDataOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddMetaDataOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddMetaDataOn();
    }
    else
    {
      op->vtkCSVWriter::AddMetaDataOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_AddMetaDataOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddMetaDataOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddMetaDataOff();
    }
    else
    {
      op->vtkCSVWriter::AddMetaDataOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetAddTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAddTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAddTime(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetAddTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetAddTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAddTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAddTime() :
      op->vtkCSVWriter::GetAddTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_AddTimeOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddTimeOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddTimeOn();
    }
    else
    {
      op->vtkCSVWriter::AddTimeOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_AddTimeOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddTimeOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddTimeOff();
    }
    else
    {
      op->vtkCSVWriter::AddTimeOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_SetAddTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAddTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAddTimeStep(temp0);
    }
    else
    {
      op->vtkCSVWriter::SetAddTimeStep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetAddTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAddTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAddTimeStep() :
      op->vtkCSVWriter::GetAddTimeStep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_AddTimeStepOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddTimeStepOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddTimeStepOn();
    }
    else
    {
      op->vtkCSVWriter::AddTimeStepOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_AddTimeStepOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddTimeStepOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddTimeStepOff();
    }
    else
    {
      op->vtkCSVWriter::AddTimeStepOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVWriter_GetString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVWriter *op = static_cast<vtkCSVWriter *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetString(temp0) :
      op->vtkCSVWriter::GetString(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCSVWriter_Methods[] = {
  {"IsTypeOf", PyvtkCSVWriter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCSVWriter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCSVWriter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCSVWriter\nC++: static vtkCSVWriter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCSVWriter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCSVWriter\nC++: vtkCSVWriter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCSVWriter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCSVWriter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetController", PyvtkCSVWriter_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: void SetController(vtkMultiProcessController *)\n\nGet/Set the controller to use. By default,\n`vtkMultiProcessController::GetGlobalController` will be used.\n"},
  {"GetController", PyvtkCSVWriter_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {"SetFieldDelimiter", PyvtkCSVWriter_SetFieldDelimiter, METH_VARARGS,
   "SetFieldDelimiter(self, _arg:str) -> None\nC++: virtual void SetFieldDelimiter(const char *_arg)\n\nGet/Set the delimiter use to separate fields (\",\" by default.)\n"},
  {"GetFieldDelimiter", PyvtkCSVWriter_GetFieldDelimiter, METH_VARARGS,
   "GetFieldDelimiter(self) -> str\nC++: virtual char *GetFieldDelimiter()\n\n"},
  {"SetStringDelimiter", PyvtkCSVWriter_SetStringDelimiter, METH_VARARGS,
   "SetStringDelimiter(self, _arg:str) -> None\nC++: virtual void SetStringDelimiter(const char *_arg)\n\nGet/Set the delimiter used for string data, if any eg. double\nquotes(\").\n"},
  {"GetStringDelimiter", PyvtkCSVWriter_GetStringDelimiter, METH_VARARGS,
   "GetStringDelimiter(self) -> str\nC++: virtual char *GetStringDelimiter()\n\n"},
  {"SetFileName", PyvtkCSVWriter_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nGet/Set the filename for the file.\n"},
  {"GetFileName", PyvtkCSVWriter_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"SetWriteAllTimeSteps", PyvtkCSVWriter_SetWriteAllTimeSteps, METH_VARARGS,
   "SetWriteAllTimeSteps(self, _arg:bool) -> None\nC++: virtual void SetWriteAllTimeSteps(bool _arg)\n\nWhen WriteAllTimeSteps is turned ON, the writer is executed once\nfor each timestep available from the reader.\n\nThe Default is OFF.\n"},
  {"GetWriteAllTimeSteps", PyvtkCSVWriter_GetWriteAllTimeSteps, METH_VARARGS,
   "GetWriteAllTimeSteps(self) -> bool\nC++: virtual bool GetWriteAllTimeSteps()\n\n"},
  {"WriteAllTimeStepsOn", PyvtkCSVWriter_WriteAllTimeStepsOn, METH_VARARGS,
   "WriteAllTimeStepsOn(self) -> None\nC++: virtual void WriteAllTimeStepsOn()\n\n"},
  {"WriteAllTimeStepsOff", PyvtkCSVWriter_WriteAllTimeStepsOff, METH_VARARGS,
   "WriteAllTimeStepsOff(self) -> None\nC++: virtual void WriteAllTimeStepsOff()\n\n"},
  {"SetWriteAllTimeStepsSeparately", PyvtkCSVWriter_SetWriteAllTimeStepsSeparately, METH_VARARGS,
   "SetWriteAllTimeStepsSeparately(self, _arg:bool) -> None\nC++: virtual void SetWriteAllTimeStepsSeparately(bool _arg)\n\nWhen WriteAllTimeStepsSeparately is turned ON and\nWriteAllTimeSteps is ON, the writer is executed once for each\ntimestep available from its input, and writes the timesteps to\nseparate files, otherwise, the timesteps are written in one file.\n\nThe Default is OFF.\n"},
  {"GetWriteAllTimeStepsSeparately", PyvtkCSVWriter_GetWriteAllTimeStepsSeparately, METH_VARARGS,
   "GetWriteAllTimeStepsSeparately(self) -> bool\nC++: virtual bool GetWriteAllTimeStepsSeparately()\n\n"},
  {"WriteAllTimeStepsSeparatelyOn", PyvtkCSVWriter_WriteAllTimeStepsSeparatelyOn, METH_VARARGS,
   "WriteAllTimeStepsSeparatelyOn(self) -> None\nC++: virtual void WriteAllTimeStepsSeparatelyOn()\n\n"},
  {"WriteAllTimeStepsSeparatelyOff", PyvtkCSVWriter_WriteAllTimeStepsSeparatelyOff, METH_VARARGS,
   "WriteAllTimeStepsSeparatelyOff(self) -> None\nC++: virtual void WriteAllTimeStepsSeparatelyOff()\n\n"},
  {"GetFileNameSuffix", PyvtkCSVWriter_GetFileNameSuffix, METH_VARARGS,
   "GetFileNameSuffix(self) -> str\nC++: virtual char *GetFileNameSuffix()\n\nProvides an option to pad the time step when writing out time\nseries data. Only allow this format: ABC%.Xd where ABC is an\narbitrary string which may or may not exist and d must exist and\nd must be the last character '.' and X may or may not exist, X\nmust be an integer if it exists. Default is nullptr.\n"},
  {"SetFileNameSuffix", PyvtkCSVWriter_SetFileNameSuffix, METH_VARARGS,
   "SetFileNameSuffix(self, _arg:str) -> None\nC++: virtual void SetFileNameSuffix(const char *_arg)\n\n"},
  {"SetUseStringDelimiter", PyvtkCSVWriter_SetUseStringDelimiter, METH_VARARGS,
   "SetUseStringDelimiter(self, _arg:bool) -> None\nC++: virtual void SetUseStringDelimiter(bool _arg)\n\nGet/Set if StringDelimiter must be used for string data. True by\ndefault.\n"},
  {"GetUseStringDelimiter", PyvtkCSVWriter_GetUseStringDelimiter, METH_VARARGS,
   "GetUseStringDelimiter(self) -> bool\nC++: virtual bool GetUseStringDelimiter()\n\n"},
  {"SetPrecision", PyvtkCSVWriter_SetPrecision, METH_VARARGS,
   "SetPrecision(self, _arg:int) -> None\nC++: virtual void SetPrecision(int _arg)\n\nGet/Set the precision to use for printing numeric values. Default\nis 5.\n"},
  {"GetPrecisionMinValue", PyvtkCSVWriter_GetPrecisionMinValue, METH_VARARGS,
   "GetPrecisionMinValue(self) -> int\nC++: virtual int GetPrecisionMinValue()\n\n"},
  {"GetPrecisionMaxValue", PyvtkCSVWriter_GetPrecisionMaxValue, METH_VARARGS,
   "GetPrecisionMaxValue(self) -> int\nC++: virtual int GetPrecisionMaxValue()\n\n"},
  {"GetPrecision", PyvtkCSVWriter_GetPrecision, METH_VARARGS,
   "GetPrecision(self) -> int\nC++: virtual int GetPrecision()\n\n"},
  {"SetUseScientificNotation", PyvtkCSVWriter_SetUseScientificNotation, METH_VARARGS,
   "SetUseScientificNotation(self, _arg:bool) -> None\nC++: virtual void SetUseScientificNotation(bool _arg)\n\nGet/Set whether scientific notation is used for numeric values.\n"},
  {"GetUseScientificNotation", PyvtkCSVWriter_GetUseScientificNotation, METH_VARARGS,
   "GetUseScientificNotation(self) -> bool\nC++: virtual bool GetUseScientificNotation()\n\n"},
  {"UseScientificNotationOn", PyvtkCSVWriter_UseScientificNotationOn, METH_VARARGS,
   "UseScientificNotationOn(self) -> None\nC++: virtual void UseScientificNotationOn()\n\n"},
  {"UseScientificNotationOff", PyvtkCSVWriter_UseScientificNotationOff, METH_VARARGS,
   "UseScientificNotationOff(self) -> None\nC++: virtual void UseScientificNotationOff()\n\n"},
  {"SetFieldAssociation", PyvtkCSVWriter_SetFieldAssociation, METH_VARARGS,
   "SetFieldAssociation(self, _arg:int) -> None\nC++: virtual void SetFieldAssociation(int _arg)\n\nGet/set the attribute data to write if the input is either a\nvtkDataSet or composite of vtkDataSets. 0 is for point data\n(vtkDataObject::POINT), 1 is for cell data (vtkDataObject::CELL)\nand 2 is for field data (vtkDataObject::FIELD). Default is 0.\n"},
  {"GetFieldAssociationMinValue", PyvtkCSVWriter_GetFieldAssociationMinValue, METH_VARARGS,
   "GetFieldAssociationMinValue(self) -> int\nC++: virtual int GetFieldAssociationMinValue()\n\n"},
  {"GetFieldAssociationMaxValue", PyvtkCSVWriter_GetFieldAssociationMaxValue, METH_VARARGS,
   "GetFieldAssociationMaxValue(self) -> int\nC++: virtual int GetFieldAssociationMaxValue()\n\n"},
  {"GetFieldAssociation", PyvtkCSVWriter_GetFieldAssociation, METH_VARARGS,
   "GetFieldAssociation(self) -> int\nC++: virtual int GetFieldAssociation()\n\n"},
  {"SetAddMetaData", PyvtkCSVWriter_SetAddMetaData, METH_VARARGS,
   "SetAddMetaData(self, _arg:bool) -> None\nC++: virtual void SetAddMetaData(bool _arg)\n\nGet/Set whether to add additional meta-data to the field data\nsuch as point coordinates (when point attributes are selected and\ninput is pointset) or structured coordinates etc. if the input is\neither a vtkDataSet or composite of vtkDataSets.\n"},
  {"GetAddMetaData", PyvtkCSVWriter_GetAddMetaData, METH_VARARGS,
   "GetAddMetaData(self) -> bool\nC++: virtual bool GetAddMetaData()\n\n"},
  {"AddMetaDataOn", PyvtkCSVWriter_AddMetaDataOn, METH_VARARGS,
   "AddMetaDataOn(self) -> None\nC++: virtual void AddMetaDataOn()\n\n"},
  {"AddMetaDataOff", PyvtkCSVWriter_AddMetaDataOff, METH_VARARGS,
   "AddMetaDataOff(self) -> None\nC++: virtual void AddMetaDataOff()\n\n"},
  {"SetAddTime", PyvtkCSVWriter_SetAddTime, METH_VARARGS,
   "SetAddTime(self, _arg:bool) -> None\nC++: virtual void SetAddTime(bool _arg)\n\nWhen set to true (default is false), if the input data set has\ntime, then the time information will be saved under the column\nnamed \"Time\".\n"},
  {"GetAddTime", PyvtkCSVWriter_GetAddTime, METH_VARARGS,
   "GetAddTime(self) -> bool\nC++: virtual bool GetAddTime()\n\n"},
  {"AddTimeOn", PyvtkCSVWriter_AddTimeOn, METH_VARARGS,
   "AddTimeOn(self) -> None\nC++: virtual void AddTimeOn()\n\n"},
  {"AddTimeOff", PyvtkCSVWriter_AddTimeOff, METH_VARARGS,
   "AddTimeOff(self) -> None\nC++: virtual void AddTimeOff()\n\n"},
  {"SetAddTimeStep", PyvtkCSVWriter_SetAddTimeStep, METH_VARARGS,
   "SetAddTimeStep(self, _arg:bool) -> None\nC++: virtual void SetAddTimeStep(bool _arg)\n\nWhen set to true (default is false), if the input data set has\ntime, then the time-step information will be saved under the\ncolumn named \"TimeStep\".\n"},
  {"GetAddTimeStep", PyvtkCSVWriter_GetAddTimeStep, METH_VARARGS,
   "GetAddTimeStep(self) -> bool\nC++: virtual bool GetAddTimeStep()\n\n"},
  {"AddTimeStepOn", PyvtkCSVWriter_AddTimeStepOn, METH_VARARGS,
   "AddTimeStepOn(self) -> None\nC++: virtual void AddTimeStepOn()\n\n"},
  {"AddTimeStepOff", PyvtkCSVWriter_AddTimeStepOff, METH_VARARGS,
   "AddTimeStepOff(self) -> None\nC++: virtual void AddTimeStepOff()\n\n"},
  {"GetString", PyvtkCSVWriter_GetString, METH_VARARGS,
   "GetString(self, string:str) -> str\nC++: std::string GetString(std::string string)\n\nInternal method: decorates the \"string\" with the\n\"StringDelimiter\" if UseStringDelimiter is true.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCSVWriter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_delimiter"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetFieldDelimiter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetFieldDelimiter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetFieldDelimiter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFieldDelimiter/SetFieldDelimiter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("string_delimiter"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetStringDelimiter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetStringDelimiter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetStringDelimiter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStringDelimiter/SetStringDelimiter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_all_time_steps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetWriteAllTimeSteps(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetWriteAllTimeSteps(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetWriteAllTimeSteps(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteAllTimeSteps/SetWriteAllTimeSteps\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_all_time_steps_separately"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetWriteAllTimeStepsSeparately(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetWriteAllTimeStepsSeparately(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetWriteAllTimeStepsSeparately(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteAllTimeStepsSeparately/SetWriteAllTimeStepsSeparately\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name_suffix"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetFileNameSuffix(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetFileNameSuffix(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetFileNameSuffix(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileNameSuffix/SetFileNameSuffix\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_string_delimiter"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetUseStringDelimiter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetUseStringDelimiter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetUseStringDelimiter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseStringDelimiter/SetUseStringDelimiter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("precision"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetPrecision(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPrecision/SetPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_scientific_notation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetUseScientificNotation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetUseScientificNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetUseScientificNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseScientificNotation/SetUseScientificNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_association"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetFieldAssociation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetFieldAssociation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetFieldAssociation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFieldAssociation/SetFieldAssociation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("add_meta_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetAddMetaData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetAddMetaData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetAddMetaData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAddMetaData/SetAddMetaData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("add_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetAddTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetAddTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetAddTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAddTime/SetAddTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("add_time_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVWriter_GetAddTimeStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVWriter_SetAddTimeStep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVWriter_SetAddTimeStep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAddTimeStep/SetAddTimeStep\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCSVWriter_Doc =
  "vtkCSVWriter - CSV writer for vtkTable/vtkDataSet/vtkCompositeDataSet\n\n"
  "Superclass: vtkWriter\n\n"
  "Writes a vtkTable/vtkDataSet/vtkCompositeDataSet as a delimited text\n"
  "file (such as CSV).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCSVWriter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsIOCore.vtkCSVWriter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCSVWriter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkCSVWriter_StaticNew()
{
  return vtkCSVWriter::New();
}

PyObject *PyvtkCSVWriter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCSVWriter_Type, PyvtkCSVWriter_Methods,
    "vtkCSVWriter",
 &PyvtkCSVWriter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkWriter");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCSVWriter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCSVWriter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCSVWriter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCSVWriter", o) != 0)
  {
    Py_DECREF(o);
  }

}

