// python wrapper for vtkCommunicationErrorCatcher
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkCommunicationErrorCatcher.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCommunicationErrorCatcher(PyObject *dict); }

static PyObject *
PyvtkCommunicationErrorCatcher_GetErrorsRaised(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetErrorsRaised");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkCommunicationErrorCatcher *op = static_cast<vtkCommunicationErrorCatcher *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->GetErrorsRaised();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCommunicationErrorCatcher_GetErrorMessages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetErrorMessages");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkCommunicationErrorCatcher *op = static_cast<vtkCommunicationErrorCatcher *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = &op->GetErrorMessages();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCommunicationErrorCatcher_Methods[] = {
  {"GetErrorsRaised", PyvtkCommunicationErrorCatcher_GetErrorsRaised, METH_VARARGS,
   "GetErrorsRaised(self) -> bool\nC++: bool GetErrorsRaised()\n\nGet the status of errors.\n"},
  {"GetErrorMessages", PyvtkCommunicationErrorCatcher_GetErrorMessages, METH_VARARGS,
   "GetErrorMessages(self) -> str\nC++: const std::string &GetErrorMessages()\n\nGet the combined error messages.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCommunicationErrorCatcher_GetSets[] = {
  {
    /*name=*/pystr("errors_raised"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCommunicationErrorCatcher_GetErrorsRaised(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetErrorsRaised\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("error_messages"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCommunicationErrorCatcher_GetErrorMessages(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetErrorMessages\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkCommunicationErrorCatcher_vtkCommunicationErrorCatcher_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkCommunicationErrorCatcher");

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    vtkCommunicationErrorCatcher *op = new vtkCommunicationErrorCatcher(temp0);

    result = PyVTKSpecialObject_New("vtkCommunicationErrorCatcher", op);
  }

  return result;
}

static PyObject *
PyvtkCommunicationErrorCatcher_vtkCommunicationErrorCatcher_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkCommunicationErrorCatcher");

  vtkCommunicator *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCommunicator"))
  {
    vtkCommunicationErrorCatcher *op = new vtkCommunicationErrorCatcher(temp0);

    result = PyVTKSpecialObject_New("vtkCommunicationErrorCatcher", op);
  }

  return result;
}

static PyMethodDef PyvtkCommunicationErrorCatcher_vtkCommunicationErrorCatcher_Methods[] = {
  {"vtkCommunicationErrorCatcher", PyvtkCommunicationErrorCatcher_vtkCommunicationErrorCatcher_s1, METH_VARARGS,
   "@V *vtkMultiProcessController"},
  {"vtkCommunicationErrorCatcher", PyvtkCommunicationErrorCatcher_vtkCommunicationErrorCatcher_s2, METH_VARARGS,
   "@V *vtkCommunicator"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkCommunicationErrorCatcher_vtkCommunicationErrorCatcher(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkCommunicationErrorCatcher_vtkCommunicationErrorCatcher_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkCommunicationErrorCatcher");
  return nullptr;
}


static const char *PyvtkCommunicationErrorCatcher_Doc =

  "vtkCommunicationErrorCatcher(__a:vtkMultiProcessController)\n    -> vtkCommunicationErrorCatcher\nC++: vtkCommunicationErrorCatcher(vtkMultiProcessController *)\nvtkCommunicationErrorCatcher(__a:vtkCommunicator)\n    -> vtkCommunicationErrorCatcher\nC++: vtkCommunicationErrorCatcher(vtkCommunicator *)\n""\n"
  "vtkCommunicationErrorCatcher - helper class to catch errors from\nvtkMultiProcessController and vtkCommunicator.\n\n"
  "vtkCommunicationErrorCatcher is helper class designed to catch errors\n"
  "from vtkCommunicator and vtkCommunicator. This is not a vtkObject and\n"
  "hence is designed to be created on the stack directly for watching\n"
  "error during a set of calls and not over the lifetime of the\n"
  "controller/communicator. For that, simply add your own observers for\n"
  "vtkCommand::ErrorEvent and intercept those. Note that is\n"
  "vtkObject::GlobalWarningDisplay is off, this class will not receive\n"
  "any ErrorEvents and hence will not report any errors that were\n"
  "raised.\n\n";

static PyObject *
PyvtkCommunicationErrorCatcher_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkCommunicationErrorCatcher_vtkCommunicationErrorCatcher(nullptr, args);
}

static void PyvtkCommunicationErrorCatcher_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkCommunicationErrorCatcher *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkCommunicationErrorCatcher_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCommunicationErrorCatcher_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsCore.vtkCommunicationErrorCatcher", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkCommunicationErrorCatcher_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkCommunicationErrorCatcher_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkCommunicationErrorCatcher_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkCommunicationErrorCatcher_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

#ifndef DECLARED_PyvtkCommunicationErrorCatcher_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCommunicationErrorCatcher_TypeNew(); }
#define DECLARED_PyvtkCommunicationErrorCatcher_TypeNew
#endif

PyObject *PyvtkCommunicationErrorCatcher_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkCommunicationErrorCatcher_Type,
    PyvtkCommunicationErrorCatcher_Methods,
    PyvtkCommunicationErrorCatcher_GetSets,
    PyvtkCommunicationErrorCatcher_vtkCommunicationErrorCatcher_Methods,
    nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCommunicationErrorCatcher(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCommunicationErrorCatcher_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkCommunicationErrorCatcher", o) != 0)
  {
    Py_DECREF(o);
  }

}

