/* Themes.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Themes.vala, do not modify */

/*
* Copyright 2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License version 3, as published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define TERMINAL_THEMES_DARK "dark"
#define TERMINAL_THEMES_HIGH_CONTRAST "high-contrast"
#define TERMINAL_THEMES_LIGHT "solarized-light"
#define TERMINAL_THEMES_CUSTOM "custom"
#define TERMINAL_THEMES_PALETTE_SIZE 19
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TERMINAL_TYPE_THEMES (terminal_themes_get_type ())
#define TERMINAL_THEMES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_THEMES, TerminalThemes))
#define TERMINAL_THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_THEMES, TerminalThemesClass))
#define TERMINAL_IS_THEMES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_THEMES))
#define TERMINAL_IS_THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_THEMES))
#define TERMINAL_THEMES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_THEMES, TerminalThemesClass))

typedef struct _TerminalThemes TerminalThemes;
typedef struct _TerminalThemesClass TerminalThemesClass;
typedef struct _TerminalThemesPrivate TerminalThemesPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TerminalParamSpecThemes TerminalParamSpecThemes;

struct _TerminalThemes {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TerminalThemesPrivate * priv;
};

struct _TerminalThemesClass {
	GTypeClass parent_class;
	void (*finalize) (TerminalThemes *self);
};

struct _TerminalParamSpecThemes {
	GParamSpec parent_instance;
};

static gpointer terminal_themes_parent_class = NULL;
VALA_EXTERN GSettings* terminal_application_settings;

VALA_EXTERN gpointer terminal_themes_ref (gpointer instance);
VALA_EXTERN void terminal_themes_unref (gpointer instance);
VALA_EXTERN GParamSpec* terminal_param_spec_themes (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void terminal_value_set_themes (GValue* value,
                                gpointer v_object);
VALA_EXTERN void terminal_value_take_themes (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer terminal_value_get_themes (const GValue* value);
VALA_EXTERN GType terminal_themes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalThemes, terminal_themes_unref)
VALA_EXTERN GdkRGBA* terminal_themes_get_rgba_palette (const gchar* theme,
                                           gint* result_length1);
static gchar** terminal_themes_get_string_palette (const gchar* theme,
                                            gint* result_length1);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add15 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN TerminalThemes* terminal_themes_new (void);
VALA_EXTERN TerminalThemes* terminal_themes_construct (GType object_type);
static void _terminal_themes___lambda4_ (void);
static void __terminal_themes___lambda4__g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self);
static void terminal_themes_finalize (TerminalThemes * obj);
static GType terminal_themes_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

GdkRGBA*
terminal_themes_get_rgba_palette (const gchar* theme,
                                  gint* result_length1)
{
	gchar** string_palette = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint string_palette_length1;
	gint _string_palette_size_;
	gboolean settings_valid = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GdkRGBA* rgba_palette = NULL;
	GdkRGBA* _tmp3_;
	gint rgba_palette_length1;
	gint _rgba_palette_size_;
	GdkRGBA* _tmp26_;
	gint _tmp26__length1;
	GdkRGBA* result;
	g_return_val_if_fail (theme != NULL, NULL);
	_tmp1_ = terminal_themes_get_string_palette (theme, &_tmp0_);
	string_palette = _tmp1_;
	string_palette_length1 = _tmp0_;
	_string_palette_size_ = string_palette_length1;
	_tmp2_ = string_palette;
	_tmp2__length1 = string_palette_length1;
	settings_valid = _tmp2__length1 == TERMINAL_THEMES_PALETTE_SIZE;
	_tmp3_ = g_new0 (GdkRGBA, TERMINAL_THEMES_PALETTE_SIZE);
	rgba_palette = _tmp3_;
	rgba_palette_length1 = TERMINAL_THEMES_PALETTE_SIZE;
	_rgba_palette_size_ = rgba_palette_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GdkRGBA new_color = {0};
				gchar** _tmp6_;
				gint _tmp6__length1;
				const gchar* _tmp7_;
				GdkRGBA* _tmp20_;
				gint _tmp20__length1;
				GdkRGBA _tmp21_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < TERMINAL_THEMES_PALETTE_SIZE)) {
					break;
				}
				memset (&new_color, 0, sizeof (GdkRGBA));
				_tmp6_ = string_palette;
				_tmp6__length1 = string_palette_length1;
				_tmp7_ = _tmp6_[i];
				if (!gdk_rgba_parse (&new_color, _tmp7_)) {
					gchar** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					const gchar* _tmp10_ = NULL;
					GSettings* _tmp11_;
					gchar** fallback_palette = NULL;
					gint _tmp12_ = 0;
					gchar** _tmp13_;
					gint fallback_palette_length1;
					gint _fallback_palette_size_;
					gchar** _tmp14_;
					gint _tmp14__length1;
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					_tmp8_ = string_palette;
					_tmp8__length1 = string_palette_length1;
					_tmp9_ = _tmp8_[i];
					g_critical ("Themes.vala:52: Color %i '%s' is not valid - replacing with default", i, _tmp9_);
					settings_valid = FALSE;
					_tmp11_ = terminal_application_settings;
					if (g_settings_get_boolean (_tmp11_, "prefer-dark-style")) {
						_tmp10_ = TERMINAL_THEMES_DARK;
					} else {
						_tmp10_ = TERMINAL_THEMES_LIGHT;
					}
					_tmp13_ = terminal_themes_get_string_palette (_tmp10_, &_tmp12_);
					fallback_palette = _tmp13_;
					fallback_palette_length1 = _tmp12_;
					_fallback_palette_size_ = fallback_palette_length1;
					_tmp14_ = string_palette;
					_tmp14__length1 = string_palette_length1;
					_tmp15_ = fallback_palette;
					_tmp15__length1 = fallback_palette_length1;
					_tmp16_ = _tmp15_[i];
					_tmp17_ = g_strdup (_tmp16_);
					_g_free0 (_tmp14_[i]);
					_tmp14_[i] = _tmp17_;
					_tmp18_ = fallback_palette;
					_tmp18__length1 = fallback_palette_length1;
					_tmp19_ = _tmp18_[i];
					gdk_rgba_parse (&new_color, _tmp19_);
					fallback_palette = (_vala_array_free (fallback_palette, fallback_palette_length1, (GDestroyNotify) g_free), NULL);
				}
				_tmp20_ = rgba_palette;
				_tmp20__length1 = rgba_palette_length1;
				_tmp21_ = new_color;
				_tmp20_[i] = _tmp21_;
			}
		}
	}
	if (!settings_valid) {
		GSettings* _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = terminal_application_settings;
		_tmp23_ = string_palette;
		_tmp23__length1 = string_palette_length1;
		_tmp24_ = _vala_g_strjoinv (":", _tmp23_, (gint) _tmp23__length1);
		_tmp25_ = _tmp24_;
		g_settings_set_string (_tmp22_, "palette", _tmp25_);
		_g_free0 (_tmp25_);
	}
	_tmp26_ = rgba_palette;
	_tmp26__length1 = rgba_palette_length1;
	if (result_length1) {
		*result_length1 = _tmp26__length1;
	}
	result = _tmp26_;
	string_palette = (_vala_array_free (string_palette, string_palette_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add15 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
terminal_themes_get_string_palette (const gchar* theme,
                                    gint* result_length1)
{
	gchar** string_palette = NULL;
	gchar** _tmp0_;
	gint string_palette_length1;
	gint _string_palette_size_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	gchar** _tmp75_;
	gint _tmp75__length1;
	gchar** result;
	g_return_val_if_fail (theme != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, TERMINAL_THEMES_PALETTE_SIZE + 1);
	string_palette = _tmp0_;
	string_palette_length1 = TERMINAL_THEMES_PALETTE_SIZE;
	_string_palette_size_ = string_palette_length1;
	_tmp1_ = theme;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string (TERMINAL_THEMES_HIGH_CONTRAST)))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar** _tmp23_;
				_tmp4_ = g_strdup ("#073642");
				_tmp5_ = g_strdup ("#dc322f");
				_tmp6_ = g_strdup ("#859900");
				_tmp7_ = g_strdup ("#b58900");
				_tmp8_ = g_strdup ("#268bd2");
				_tmp9_ = g_strdup ("#d33682");
				_tmp10_ = g_strdup ("#2aa198");
				_tmp11_ = g_strdup ("#eee8d5");
				_tmp12_ = g_strdup ("#002b36");
				_tmp13_ = g_strdup ("#dc322f");
				_tmp14_ = g_strdup ("#586e75");
				_tmp15_ = g_strdup ("#657b83");
				_tmp16_ = g_strdup ("#839496");
				_tmp17_ = g_strdup ("#6c71c4");
				_tmp18_ = g_strdup ("#93a1a1");
				_tmp19_ = g_strdup ("#fdf6e3");
				_tmp20_ = g_strdup ("#ffffff");
				_tmp21_ = g_strdup ("#333333");
				_tmp22_ = g_strdup ("#839496");
				_tmp23_ = g_new0 (gchar*, 19 + 1);
				_tmp23_[0] = _tmp4_;
				_tmp23_[1] = _tmp5_;
				_tmp23_[2] = _tmp6_;
				_tmp23_[3] = _tmp7_;
				_tmp23_[4] = _tmp8_;
				_tmp23_[5] = _tmp9_;
				_tmp23_[6] = _tmp10_;
				_tmp23_[7] = _tmp11_;
				_tmp23_[8] = _tmp12_;
				_tmp23_[9] = _tmp13_;
				_tmp23_[10] = _tmp14_;
				_tmp23_[11] = _tmp15_;
				_tmp23_[12] = _tmp16_;
				_tmp23_[13] = _tmp17_;
				_tmp23_[14] = _tmp18_;
				_tmp23_[15] = _tmp19_;
				_tmp23_[16] = _tmp20_;
				_tmp23_[17] = _tmp21_;
				_tmp23_[18] = _tmp22_;
				string_palette = (_vala_array_free (string_palette, string_palette_length1, (GDestroyNotify) g_free), NULL);
				string_palette = _tmp23_;
				string_palette_length1 = 19;
				_string_palette_size_ = string_palette_length1;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string (TERMINAL_THEMES_LIGHT)))) {
		switch (0) {
			default:
			{
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar** _tmp43_;
				_tmp24_ = g_strdup ("#073642");
				_tmp25_ = g_strdup ("#dc322f");
				_tmp26_ = g_strdup ("#859900");
				_tmp27_ = g_strdup ("#b58900");
				_tmp28_ = g_strdup ("#268bd2");
				_tmp29_ = g_strdup ("#d33682");
				_tmp30_ = g_strdup ("#2aa198");
				_tmp31_ = g_strdup ("#eee8d5");
				_tmp32_ = g_strdup ("#002b36");
				_tmp33_ = g_strdup ("#dc322f");
				_tmp34_ = g_strdup ("#586e75");
				_tmp35_ = g_strdup ("#657b83");
				_tmp36_ = g_strdup ("#839496");
				_tmp37_ = g_strdup ("#6c71c4");
				_tmp38_ = g_strdup ("#93a1a1");
				_tmp39_ = g_strdup ("#fdf6e3");
				_tmp40_ = g_strdup ("#FDF6E3");
				_tmp41_ = g_strdup ("#586e75");
				_tmp42_ = g_strdup ("#839496");
				_tmp43_ = g_new0 (gchar*, 19 + 1);
				_tmp43_[0] = _tmp24_;
				_tmp43_[1] = _tmp25_;
				_tmp43_[2] = _tmp26_;
				_tmp43_[3] = _tmp27_;
				_tmp43_[4] = _tmp28_;
				_tmp43_[5] = _tmp29_;
				_tmp43_[6] = _tmp30_;
				_tmp43_[7] = _tmp31_;
				_tmp43_[8] = _tmp32_;
				_tmp43_[9] = _tmp33_;
				_tmp43_[10] = _tmp34_;
				_tmp43_[11] = _tmp35_;
				_tmp43_[12] = _tmp36_;
				_tmp43_[13] = _tmp37_;
				_tmp43_[14] = _tmp38_;
				_tmp43_[15] = _tmp39_;
				_tmp43_[16] = _tmp40_;
				_tmp43_[17] = _tmp41_;
				_tmp43_[18] = _tmp42_;
				string_palette = (_vala_array_free (string_palette, string_palette_length1, (GDestroyNotify) g_free), NULL);
				string_palette = _tmp43_;
				string_palette_length1 = 19;
				_string_palette_size_ = string_palette_length1;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string (TERMINAL_THEMES_DARK)))) {
		switch (0) {
			default:
			{
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar** _tmp63_;
				_tmp44_ = g_strdup ("#073642");
				_tmp45_ = g_strdup ("#dc322f");
				_tmp46_ = g_strdup ("#859900");
				_tmp47_ = g_strdup ("#b58900");
				_tmp48_ = g_strdup ("#268bd2");
				_tmp49_ = g_strdup ("#d33682");
				_tmp50_ = g_strdup ("#2aa198");
				_tmp51_ = g_strdup ("#eee8d5");
				_tmp52_ = g_strdup ("#5e5c64");
				_tmp53_ = g_strdup ("#dc322f");
				_tmp54_ = g_strdup ("#586e75");
				_tmp55_ = g_strdup ("#657b83");
				_tmp56_ = g_strdup ("#839496");
				_tmp57_ = g_strdup ("#6c71c4");
				_tmp58_ = g_strdup ("#93a1a1");
				_tmp59_ = g_strdup ("#fdf6e3");
				_tmp60_ = g_strdup ("#2E2E2E");
				_tmp61_ = g_strdup ("#a5a5a5");
				_tmp62_ = g_strdup ("#839496");
				_tmp63_ = g_new0 (gchar*, 19 + 1);
				_tmp63_[0] = _tmp44_;
				_tmp63_[1] = _tmp45_;
				_tmp63_[2] = _tmp46_;
				_tmp63_[3] = _tmp47_;
				_tmp63_[4] = _tmp48_;
				_tmp63_[5] = _tmp49_;
				_tmp63_[6] = _tmp50_;
				_tmp63_[7] = _tmp51_;
				_tmp63_[8] = _tmp52_;
				_tmp63_[9] = _tmp53_;
				_tmp63_[10] = _tmp54_;
				_tmp63_[11] = _tmp55_;
				_tmp63_[12] = _tmp56_;
				_tmp63_[13] = _tmp57_;
				_tmp63_[14] = _tmp58_;
				_tmp63_[15] = _tmp59_;
				_tmp63_[16] = _tmp60_;
				_tmp63_[17] = _tmp61_;
				_tmp63_[18] = _tmp62_;
				string_palette = (_vala_array_free (string_palette, string_palette_length1, (GDestroyNotify) g_free), NULL);
				string_palette = _tmp63_;
				string_palette_length1 = 19;
				_string_palette_size_ = string_palette_length1;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string (TERMINAL_THEMES_CUSTOM)))) {
		switch (0) {
			default:
			{
				GSettings* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar** _tmp67_;
				gchar** _tmp68_;
				GSettings* _tmp69_;
				gchar* _tmp70_;
				GSettings* _tmp71_;
				gchar* _tmp72_;
				GSettings* _tmp73_;
				gchar* _tmp74_;
				_tmp64_ = terminal_application_settings;
				_tmp65_ = g_settings_get_string (_tmp64_, "palette");
				_tmp66_ = _tmp65_;
				_tmp68_ = _tmp67_ = g_strsplit (_tmp66_, ":", 0);
				string_palette = (_vala_array_free (string_palette, string_palette_length1, (GDestroyNotify) g_free), NULL);
				string_palette = _tmp68_;
				string_palette_length1 = _vala_array_length (_tmp67_);
				_string_palette_size_ = string_palette_length1;
				_g_free0 (_tmp66_);
				_tmp69_ = terminal_application_settings;
				_tmp70_ = g_settings_get_string (_tmp69_, "background");
				_vala_array_add13 (&string_palette, &string_palette_length1, &_string_palette_size_, _tmp70_);
				_tmp71_ = terminal_application_settings;
				_tmp72_ = g_settings_get_string (_tmp71_, "foreground");
				_vala_array_add14 (&string_palette, &string_palette_length1, &_string_palette_size_, _tmp72_);
				_tmp73_ = terminal_application_settings;
				_tmp74_ = g_settings_get_string (_tmp73_, "cursor-color");
				_vala_array_add15 (&string_palette, &string_palette_length1, &_string_palette_size_, _tmp74_);
				break;
			}
		}
	}
	_tmp75_ = string_palette;
	_tmp75__length1 = string_palette_length1;
	if (result_length1) {
		*result_length1 = _tmp75__length1;
	}
	result = _tmp75_;
	return result;
}

TerminalThemes*
terminal_themes_construct (GType object_type)
{
	TerminalThemes* self = NULL;
	self = (TerminalThemes*) g_type_create_instance (object_type);
	return self;
}

TerminalThemes*
terminal_themes_new (void)
{
	return terminal_themes_construct (TERMINAL_TYPE_THEMES);
}

static void
_terminal_themes___lambda4_ (void)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	_tmp0_ = terminal_application_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "theme");
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	g_free (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string (TERMINAL_THEMES_HIGH_CONTRAST)))) {
		switch (0) {
			default:
			{
				GSettings* _tmp5_;
				_tmp5_ = terminal_application_settings;
				g_settings_set_boolean (_tmp5_, "prefer-dark-style", FALSE);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string (TERMINAL_THEMES_LIGHT)))) {
		switch (0) {
			default:
			{
				GSettings* _tmp6_;
				_tmp6_ = terminal_application_settings;
				g_settings_set_boolean (_tmp6_, "prefer-dark-style", FALSE);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string (TERMINAL_THEMES_DARK)))) {
		switch (0) {
			default:
			{
				GSettings* _tmp7_;
				_tmp7_ = terminal_application_settings;
				g_settings_set_boolean (_tmp7_, "prefer-dark-style", TRUE);
				break;
			}
		}
	}
}

static void
__terminal_themes___lambda4__g_settings_changed (GSettings* _sender,
                                                 const gchar* key,
                                                 gpointer self)
{
	_terminal_themes___lambda4_ ();
}

static void
terminal_value_themes_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
terminal_value_themes_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		terminal_themes_unref (value->data[0].v_pointer);
	}
}

static void
terminal_value_themes_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = terminal_themes_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
terminal_value_themes_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
terminal_value_themes_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TerminalThemes * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = terminal_themes_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
terminal_value_themes_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	TerminalThemes ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = terminal_themes_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
terminal_param_spec_themes (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	TerminalParamSpecThemes* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TERMINAL_TYPE_THEMES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
terminal_value_get_themes (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TERMINAL_TYPE_THEMES), NULL);
	return value->data[0].v_pointer;
}

void
terminal_value_set_themes (GValue* value,
                           gpointer v_object)
{
	TerminalThemes * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TERMINAL_TYPE_THEMES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TERMINAL_TYPE_THEMES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		terminal_themes_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		terminal_themes_unref (old);
	}
}

void
terminal_value_take_themes (GValue* value,
                            gpointer v_object)
{
	TerminalThemes * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TERMINAL_TYPE_THEMES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TERMINAL_TYPE_THEMES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		terminal_themes_unref (old);
	}
}

static void
terminal_themes_class_init (TerminalThemesClass * klass,
                            gpointer klass_data)
{
	GSettings* _tmp0_;
	terminal_themes_parent_class = g_type_class_peek_parent (klass);
	((TerminalThemesClass *) klass)->finalize = terminal_themes_finalize;
	_tmp0_ = terminal_application_settings;
	g_signal_connect (_tmp0_, "changed::theme", (GCallback) __terminal_themes___lambda4__g_settings_changed, NULL);
}

static void
terminal_themes_instance_init (TerminalThemes * self,
                               gpointer klass)
{
	self->ref_count = 1;
}

static void
terminal_themes_finalize (TerminalThemes * obj)
{
	TerminalThemes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_TYPE_THEMES, TerminalThemes);
	g_signal_handlers_destroy (self);
}

static GType
terminal_themes_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { terminal_value_themes_init, terminal_value_themes_free_value, terminal_value_themes_copy_value, terminal_value_themes_peek_pointer, "p", terminal_value_themes_collect_value, "p", terminal_value_themes_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TerminalThemesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) terminal_themes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TerminalThemes), 0, (GInstanceInitFunc) terminal_themes_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType terminal_themes_type_id;
	terminal_themes_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TerminalThemes", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return terminal_themes_type_id;
}

GType
terminal_themes_get_type (void)
{
	static volatile gsize terminal_themes_type_id__once = 0;
	if (g_once_init_enter (&terminal_themes_type_id__once)) {
		GType terminal_themes_type_id;
		terminal_themes_type_id = terminal_themes_get_type_once ();
		g_once_init_leave (&terminal_themes_type_id__once, terminal_themes_type_id);
	}
	return terminal_themes_type_id__once;
}

gpointer
terminal_themes_ref (gpointer instance)
{
	TerminalThemes * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
terminal_themes_unref (gpointer instance)
{
	TerminalThemes * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TERMINAL_THEMES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

