/* SearchRowDate.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SearchRowDate.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*               2018 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gtk/gtk.h>
#include <granite.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

#define SEARCH_ROW_DATE_DATE_FORMAT "%x"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEARCH_ROW_DATE_0_PROPERTY,
	SEARCH_ROW_DATE_NUM_PROPERTIES
};
static GParamSpec* search_row_date_properties[SEARCH_ROW_DATE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _search_condition_unref0(var) ((var == NULL) ? NULL : (var = (search_condition_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SearchRowDatePrivate {
	GtkComboBoxText* context;
	GraniteWidgetsDatePicker* datepicker_one;
	GraniteWidgetsDatePicker* datepicker_two;
	GtkLabel* and;
};

static gint SearchRowDate_private_offset;
static gpointer search_row_date_parent_class = NULL;

static void search_row_date_on_changed (SearchRowDate* self);
static void _search_row_date_on_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                        gpointer self);
static void search_row_date_update_datepickers (SearchRowDate* self);
static SearchCondition* search_row_date_real_get_search_condition (SearchRow* base);
static void search_row_date_real_populate (SearchRow* base,
                                    SearchCondition* sc);
static gboolean search_row_date_real_is_complete (SearchRow* base);
static void search_row_date_finalize (GObject * obj);
static GType search_row_date_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
search_row_date_get_instance_private (SearchRowDate* self)
{
	return G_STRUCT_MEMBER_P (self, SearchRowDate_private_offset);
}

static void
_search_row_date_on_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                   gpointer self)
{
	search_row_date_on_changed ((SearchRowDate*) self);
}

SearchRowDate*
search_row_date_construct (GType object_type,
                           SearchRowContainer* parent)
{
	SearchRowDate * self = NULL;
	GtkComboBoxText* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GtkComboBoxText* _tmp2_;
	GtkComboBoxText* _tmp3_;
	GtkComboBoxText* _tmp4_;
	GtkComboBoxText* _tmp5_;
	GtkComboBoxText* _tmp6_;
	GtkComboBoxText* _tmp7_;
	GraniteWidgetsDatePicker* _tmp8_;
	GraniteWidgetsDatePicker* _tmp9_;
	GtkLabel* _tmp10_;
	GtkComboBoxText* _tmp11_;
	GraniteWidgetsDatePicker* _tmp12_;
	GtkLabel* _tmp13_;
	GraniteWidgetsDatePicker* _tmp14_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (SearchRowDate*) g_object_new (object_type, "parent", parent, NULL);
	_tmp0_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	gtk_combo_box_text_append_text (_tmp1_, _ ("is exactly"));
	_tmp2_ = self->priv->context;
	gtk_combo_box_text_append_text (_tmp2_, _ ("is after"));
	_tmp3_ = self->priv->context;
	gtk_combo_box_text_append_text (_tmp3_, _ ("is before"));
	_tmp4_ = self->priv->context;
	gtk_combo_box_text_append_text (_tmp4_, _ ("is between"));
	_tmp5_ = self->priv->context;
	gtk_combo_box_text_append_text (_tmp5_, _ ("is not set"));
	_tmp6_ = self->priv->context;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp6_, 0);
	_tmp7_ = self->priv->context;
	g_signal_connect_object ((GtkComboBox*) _tmp7_, "changed", (GCallback) _search_row_date_on_changed_gtk_combo_box_changed, self, 0);
	_tmp8_ = granite_widgets_date_picker_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->datepicker_one);
	self->priv->datepicker_one = _tmp8_;
	_tmp9_ = granite_widgets_date_picker_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->datepicker_two);
	self->priv->datepicker_two = _tmp9_;
	_tmp10_ = (GtkLabel*) gtk_label_new (_ ("and"));
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->and);
	self->priv->and = _tmp10_;
	_tmp11_ = self->priv->context;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->datepicker_one;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->and;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->datepicker_two;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
	gtk_widget_show_all ((GtkWidget*) self);
	search_row_date_update_datepickers (self);
	return self;
}

SearchRowDate*
search_row_date_new (SearchRowContainer* parent)
{
	return search_row_date_construct (TYPE_SEARCH_ROW_DATE, parent);
}

static void
search_row_date_update_datepickers (SearchRowDate* self)
{
	SearchConditionDateContext c = 0;
	GtkComboBoxText* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	c = (SearchConditionDateContext) gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	if (c == SEARCH_CONDITION_DATE_CONTEXT_BETWEEN) {
		GraniteWidgetsDatePicker* _tmp1_;
		GtkLabel* _tmp2_;
		GraniteWidgetsDatePicker* _tmp3_;
		_tmp1_ = self->priv->datepicker_one;
		gtk_widget_show ((GtkWidget*) _tmp1_);
		_tmp2_ = self->priv->and;
		gtk_widget_show ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->datepicker_two;
		gtk_widget_show ((GtkWidget*) _tmp3_);
	} else {
		if (c == SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET) {
			GraniteWidgetsDatePicker* _tmp4_;
			GtkLabel* _tmp5_;
			GraniteWidgetsDatePicker* _tmp6_;
			_tmp4_ = self->priv->datepicker_one;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
			_tmp5_ = self->priv->and;
			gtk_widget_hide ((GtkWidget*) _tmp5_);
			_tmp6_ = self->priv->datepicker_two;
			gtk_widget_hide ((GtkWidget*) _tmp6_);
		} else {
			GraniteWidgetsDatePicker* _tmp7_;
			GtkLabel* _tmp8_;
			GraniteWidgetsDatePicker* _tmp9_;
			_tmp7_ = self->priv->datepicker_one;
			gtk_widget_show ((GtkWidget*) _tmp7_);
			_tmp8_ = self->priv->and;
			gtk_widget_hide ((GtkWidget*) _tmp8_);
			_tmp9_ = self->priv->datepicker_two;
			gtk_widget_hide ((GtkWidget*) _tmp9_);
		}
	}
}

static SearchCondition*
search_row_date_real_get_search_condition (SearchRow* base)
{
	SearchRowDate * self;
	SearchConditionSearchType search_type = 0;
	SearchRowContainer* _tmp0_;
	SearchRowContainer* _tmp1_;
	SearchConditionDateContext search_context = 0;
	GtkComboBoxText* _tmp2_;
	SearchConditionDate* c = NULL;
	GraniteWidgetsDatePicker* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GraniteWidgetsDatePicker* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	SearchConditionDate* _tmp9_;
	SearchCondition* result;
	self = (SearchRowDate*) base;
	_tmp0_ = search_row_get_parent ((SearchRow*) self);
	_tmp1_ = _tmp0_;
	search_type = search_row_container_get_search_type (_tmp1_);
	_tmp2_ = self->priv->context;
	search_context = (SearchConditionDateContext) gtk_combo_box_get_active ((GtkComboBox*) _tmp2_);
	_tmp3_ = self->priv->datepicker_one;
	_tmp4_ = granite_widgets_date_picker_get_date (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->datepicker_two;
	_tmp7_ = granite_widgets_date_picker_get_date (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = search_condition_date_new (search_type, search_context, _tmp5_, _tmp8_);
	c = _tmp9_;
	result = (SearchCondition*) c;
	return result;
}

static gpointer
_search_condition_ref0 (gpointer self)
{
	return self ? search_condition_ref (self) : NULL;
}

static void
search_row_date_real_populate (SearchRow* base,
                               SearchCondition* sc)
{
	SearchRowDate * self;
	SearchConditionDate* cond = NULL;
	SearchConditionDate* _tmp0_;
	GtkComboBoxText* _tmp1_;
	SearchConditionDateContext _tmp2_;
	SearchConditionDateContext _tmp3_;
	GraniteWidgetsDatePicker* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GraniteWidgetsDatePicker* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	self = (SearchRowDate*) base;
	g_return_if_fail (sc != NULL);
	_tmp0_ = _search_condition_ref0 (IS_SEARCH_CONDITION_DATE (sc) ? ((SearchConditionDate*) sc) : NULL);
	cond = _tmp0_;
	_vala_assert (cond != NULL, "cond != null");
	_tmp1_ = self->priv->context;
	_tmp2_ = search_condition_date_get_context (cond);
	_tmp3_ = _tmp2_;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp1_, (gint) _tmp3_);
	_tmp4_ = self->priv->datepicker_one;
	_tmp5_ = search_condition_date_get_date_one (cond);
	_tmp6_ = _tmp5_;
	granite_widgets_date_picker_set_date (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->datepicker_two;
	_tmp8_ = search_condition_date_get_date_two (cond);
	_tmp9_ = _tmp8_;
	granite_widgets_date_picker_set_date (_tmp7_, _tmp9_);
	search_row_date_update_datepickers (self);
	_search_condition_unref0 (cond);
}

static gboolean
search_row_date_real_is_complete (SearchRow* base)
{
	SearchRowDate * self;
	gboolean result;
	self = (SearchRowDate*) base;
	result = TRUE;
	return result;
}

static void
search_row_date_on_changed (SearchRowDate* self)
{
	SearchRowContainer* _tmp0_;
	SearchRowContainer* _tmp1_;
	SearchRowContainer* _tmp2_;
	SearchRowContainer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = search_row_get_parent ((SearchRow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = search_row_get_parent ((SearchRow*) self);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name (_tmp1_, "changed", _tmp3_);
	search_row_date_update_datepickers (self);
}

static void
search_row_date_class_init (SearchRowDateClass * klass,
                            gpointer klass_data)
{
	search_row_date_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SearchRowDate_private_offset);
	((SearchRowClass *) klass)->get_search_condition = (SearchCondition* (*) (SearchRow*)) search_row_date_real_get_search_condition;
	((SearchRowClass *) klass)->populate = (void (*) (SearchRow*, SearchCondition*)) search_row_date_real_populate;
	((SearchRowClass *) klass)->is_complete = (gboolean (*) (SearchRow*)) search_row_date_real_is_complete;
	G_OBJECT_CLASS (klass)->finalize = search_row_date_finalize;
}

static void
search_row_date_instance_init (SearchRowDate * self,
                               gpointer klass)
{
	self->priv = search_row_date_get_instance_private (self);
}

static void
search_row_date_finalize (GObject * obj)
{
	SearchRowDate * self;
	GtkComboBoxText* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_ROW_DATE, SearchRowDate);
	_tmp0_ = self->priv->context;
	g_signal_parse_name ("changed", gtk_combo_box_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkComboBox*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _search_row_date_on_changed_gtk_combo_box_changed, self);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->datepicker_one);
	_g_object_unref0 (self->priv->datepicker_two);
	_g_object_unref0 (self->priv->and);
	G_OBJECT_CLASS (search_row_date_parent_class)->finalize (obj);
}

static GType
search_row_date_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchRowDateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_row_date_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchRowDate), 0, (GInstanceInitFunc) search_row_date_instance_init, NULL };
	GType search_row_date_type_id;
	search_row_date_type_id = g_type_register_static (TYPE_SEARCH_ROW, "SearchRowDate", &g_define_type_info, 0);
	SearchRowDate_private_offset = g_type_add_instance_private (search_row_date_type_id, sizeof (SearchRowDatePrivate));
	return search_row_date_type_id;
}

GType
search_row_date_get_type (void)
{
	static volatile gsize search_row_date_type_id__once = 0;
	if (g_once_init_enter (&search_row_date_type_id__once)) {
		GType search_row_date_type_id;
		search_row_date_type_id = search_row_date_get_type_once ();
		g_once_init_leave (&search_row_date_type_id__once, search_row_date_type_id);
	}
	return search_row_date_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

