/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.57 from the
 * contents of Store.xs. Do not edit this file, edit Store.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "../nix/src/perl/lib/Nix/Store.xs"
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Prevent a clash between some Perl and libstdc++ macros. */
#undef do_open
#undef do_close

#include "nix/store/derivations.hh"
#include "nix/store/realisation.hh"
#include "nix/store/globals.hh"
#include "nix/store/store-open.hh"
#include "nix/util/posix-source-accessor.hh"
#include "nix/store/export-import.hh"

#include <sodium.h>
#include <nlohmann/json.hpp>

using namespace nix;

static bool libStoreInitialized = false;

struct StoreWrapper {
    ref<Store> store;
};

#line 37 "src/perl/lib/Nix/Store.cc"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

/* simple backcompat versions of the TARGx() macros with no optimisation */
#ifndef TARGi
#  define TARGi(iv, do_taint) sv_setiv_mg(TARG, iv)
#  define TARGu(uv, do_taint) sv_setuv_mg(TARG, uv)
#  define TARGn(nv, do_taint) sv_setnv_mg(TARG, nv)
#endif

#line 188 "src/perl/lib/Nix/Store.cc"
#undef dNOOP // Hack to work around "error: declaration of 'Perl___notused' has a different language linkage" error message on clang.
#define dNOOP

XS_EUPXS(XS_Nix__Store_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	StoreWrapper *	THIS;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::DESTROY() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;

	delete THIS;
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Nix__Store_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_new)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "CLASS, s= nullptr");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	StoreWrapper *	RETVAL;
	char *	s;

	if (items < 2)
	    s = nullptr;
	else {
	    s = (char *)SvPV_nolen(ST(1))
;
	}
#line 58 "../nix/src/perl/lib/Nix/Store.xs"
        static std::shared_ptr<Store> _store;
        try {
            if (!libStoreInitialized) {
                initLibStore();
                libStoreInitialized = true;
            }
            if (items == 1) {
                _store = openStore();
                RETVAL = new StoreWrapper {
                    .store = ref<Store>{_store}
                };
            } else {
                RETVAL = new StoreWrapper {
                    .store = openStore(s)
                };
            }
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 255 "src/perl/lib/Nix/Store.cc"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	sv_setref_pv( RETVALSV, CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Nix__Store_init); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_init)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 83 "../nix/src/perl/lib/Nix/Store.xs"
        if (!libStoreInitialized) {
            initLibStore();
            libStoreInitialized = true;
        }
#line 279 "src/perl/lib/Nix/Store.cc"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Nix__Store_setVerbosity); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_setVerbosity)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "level");
    {
	int	level = (int)SvIV(ST(0))
;
#line 91 "../nix/src/perl/lib/Nix/Store.xs"
        verbosity = (Verbosity) level;
#line 296 "src/perl/lib/Nix/Store.cc"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Nix__Store_isValidPath); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_isValidPath)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, path");
    {
	StoreWrapper *	THIS;
	int	RETVAL;
	dXSTARG;
	char *	path = (char *)SvPV_nolen(ST(1))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::isValidPath() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 97 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            RETVAL = THIS->store->isValidPath(THIS->store->parseStorePath(path));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 330 "src/perl/lib/Nix/Store.cc"
	TARGi((IV)RETVAL, 1);
	ST(0) = TARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Nix__Store_queryReferences); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_queryReferences)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, path");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;
	char *	path = (char *)SvPV_nolen(ST(1))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::queryReferences() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 109 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            for (auto & i : THIS->store->queryPathInfo(THIS->store->parseStorePath(path))->references)
                XPUSHs(sv_2mortal(newSVpv(THIS->store->printStorePath(i).c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 368 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_queryPathHash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_queryPathHash)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, path");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;
	char *	path = (char *)SvPV_nolen(ST(1))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::queryPathHash() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 120 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            auto s = THIS->store->queryPathInfo(THIS->store->parseStorePath(path))->narHash.to_string(HashFormat::Nix32, true);
            XPUSHs(sv_2mortal(newSVpv(s.c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 405 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_queryDeriver); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_queryDeriver)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, path");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;
	char *	path = (char *)SvPV_nolen(ST(1))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::queryDeriver() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 131 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            auto info = THIS->store->queryPathInfo(THIS->store->parseStorePath(path));
            if (!info->deriver) XSRETURN_UNDEF;
            XPUSHs(sv_2mortal(newSVpv(THIS->store->printStorePath(*info->deriver).c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 443 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_queryPathInfo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_queryPathInfo)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, path, base32");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;
	char *	path = (char *)SvPV_nolen(ST(1))
;
	int	base32 = (int)SvIV(ST(2))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::queryPathInfo() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 143 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            auto info = THIS->store->queryPathInfo(THIS->store->parseStorePath(path));
            if (!info->deriver)
                XPUSHs(&PL_sv_undef);
            else
                XPUSHs(sv_2mortal(newSVpv(THIS->store->printStorePath(*info->deriver).c_str(), 0)));
            auto s = info->narHash.to_string(base32 ? HashFormat::Nix32 : HashFormat::Base16, true);
            XPUSHs(sv_2mortal(newSVpv(s.c_str(), 0)));
            mXPUSHi(info->registrationTime);
            mXPUSHi(info->narSize);
            AV * refs = newAV();
            for (auto & i : info->references)
                av_push(refs, newSVpv(THIS->store->printStorePath(i).c_str(), 0));
            XPUSHs(sv_2mortal(newRV((SV *) refs)));
            AV * sigs = newAV();
            for (auto & i : info->sigs)
                av_push(sigs, newSVpv(i.c_str(), 0));
            XPUSHs(sv_2mortal(newRV((SV *) sigs)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 497 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_queryRawRealisation); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_queryRawRealisation)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, outputId");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;
	char *	outputId = (char *)SvPV_nolen(ST(1))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::queryRawRealisation() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 168 "../nix/src/perl/lib/Nix/Store.xs"
      try {
        auto realisation = THIS->store->queryRealisation(DrvOutput::parse(outputId));
        if (realisation)
            XPUSHs(sv_2mortal(newSVpv(static_cast<nlohmann::json>(*realisation).dump().c_str(), 0)));
        else
            XPUSHs(sv_2mortal(newSVpv("", 0)));
      } catch (Error & e) {
        croak("%s", e.what());
      }
#line 537 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_queryPathFromHashPart); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_queryPathFromHashPart)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, hashPart");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;
	char *	hashPart = (char *)SvPV_nolen(ST(1))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::queryPathFromHashPart() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 182 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            auto path = THIS->store->queryPathFromHashPart(hashPart);
            XPUSHs(sv_2mortal(newSVpv(path ? THIS->store->printStorePath(*path).c_str() : "", 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 574 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_computeFSClosure); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_computeFSClosure)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "THIS, flipDirection, includeOutputs, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;
	int	flipDirection = (int)SvIV(ST(1))
;
	int	includeOutputs = (int)SvIV(ST(2))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::computeFSClosure() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 193 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            StorePathSet paths;
            for (int n = 3; n < items; ++n)
                THIS->store->computeFSClosure(THIS->store->parseStorePath(SvPV_nolen(ST(n))), paths, flipDirection, includeOutputs);
            for (auto & i : paths)
                XPUSHs(sv_2mortal(newSVpv(THIS->store->printStorePath(i).c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 616 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_topoSortPaths); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_topoSortPaths)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "THIS, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::topoSortPaths() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 207 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            StorePathSet paths;
            for (int n = 1; n < items; ++n) paths.insert(THIS->store->parseStorePath(SvPV_nolen(ST(n))));
            auto sorted = THIS->store->topoSortPaths(paths);
            for (auto & i : sorted)
                XPUSHs(sv_2mortal(newSVpv(THIS->store->printStorePath(i).c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 654 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_followLinksToStorePath); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_followLinksToStorePath)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, path");
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;
	char *	path = (char *)SvPV_nolen(ST(1))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::followLinksToStorePath() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 221 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            RETVAL = newSVpv(THIS->store->printStorePath(THIS->store->followLinksToStorePath(path)).c_str(), 0);
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 688 "src/perl/lib/Nix/Store.cc"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Nix__Store_exportPaths); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_exportPaths)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "THIS, fd, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	int	fd = (int)SvIV(ST(1))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::exportPaths() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 233 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            StorePathSet paths;
            for (int n = 2; n < items; ++n) paths.insert(THIS->store->parseStorePath(SvPV_nolen(ST(n))));
            FdSink sink(fd);
            exportPaths(*THIS->store, paths, sink);
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 727 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_importPaths); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_importPaths)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, fd, dontCheckSigs");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	int	fd = (int)SvIV(ST(1))
;
	int	dontCheckSigs = (int)SvIV(ST(2))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::importPaths() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 246 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            FdSource source(fd);
            importPaths(*THIS->store, source, dontCheckSigs ? NoCheckSigs : CheckSigs);
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 765 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_hashPath); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_hashPath)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "algo, base32, path");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	RETVAL;
	char *	algo = (char *)SvPV_nolen(ST(0))
;
	int	base32 = (int)SvIV(ST(1))
;
	char *	path = (char *)SvPV_nolen(ST(2))
;
#line 257 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            Hash h = hashPath(
                PosixSourceAccessor::createAtRoot(path),
                FileIngestionMethod::NixArchive, parseHashAlgo(algo)).first;
            auto s = h.to_string(base32 ? HashFormat::Nix32 : HashFormat::Base16, false);
            XPUSHs(sv_2mortal(newSVpv(s.c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 798 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_hashFile); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_hashFile)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "algo, base32, path");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	RETVAL;
	char *	algo = (char *)SvPV_nolen(ST(0))
;
	int	base32 = (int)SvIV(ST(1))
;
	char *	path = (char *)SvPV_nolen(ST(2))
;
#line 270 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            Hash h = hashFile(parseHashAlgo(algo), path);
            auto s = h.to_string(base32 ? HashFormat::Nix32 : HashFormat::Base16, false);
            XPUSHs(sv_2mortal(newSVpv(s.c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 829 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_hashString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_hashString)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "algo, base32, s");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	RETVAL;
	char *	algo = (char *)SvPV_nolen(ST(0))
;
	int	base32 = (int)SvIV(ST(1))
;
	char *	s = (char *)SvPV_nolen(ST(2))
;
#line 281 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            Hash h = hashString(parseHashAlgo(algo), s);
            auto s = h.to_string(base32 ? HashFormat::Nix32 : HashFormat::Base16, false);
            XPUSHs(sv_2mortal(newSVpv(s.c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 860 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_convertHash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_convertHash)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "algo, s, toBase32");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	RETVAL;
	char *	algo = (char *)SvPV_nolen(ST(0))
;
	char *	s = (char *)SvPV_nolen(ST(1))
;
	int	toBase32 = (int)SvIV(ST(2))
;
#line 292 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            auto h = Hash::parseAny(s, parseHashAlgo(algo));
            auto s = h.to_string(toBase32 ? HashFormat::Nix32 : HashFormat::Base16, false);
            XPUSHs(sv_2mortal(newSVpv(s.c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 891 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_signString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_signString)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "secretKey_, msg");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	RETVAL;
	char *	secretKey_ = (char *)SvPV_nolen(ST(0))
;
	char *	msg = (char *)SvPV_nolen(ST(1))
;
#line 303 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            auto sig = SecretKey(secretKey_).signDetached(msg);
            XPUSHs(sv_2mortal(newSVpv(sig.c_str(), sig.size())));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 919 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_checkSignature); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_checkSignature)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "publicKey_, sig_, msg");
    {
	int	RETVAL;
	dXSTARG;
	SV *	publicKey_ = ST(0)
;
	SV *	sig_ = ST(1)
;
	char *	msg = (char *)SvPV_nolen(ST(2))
;
#line 313 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            STRLEN publicKeyLen;
            unsigned char * publicKey = (unsigned char *) SvPV(publicKey_, publicKeyLen);
            if (publicKeyLen != crypto_sign_PUBLICKEYBYTES)
                throw Error("public key is not valid");

            STRLEN sigLen;
            unsigned char * sig = (unsigned char *) SvPV(sig_, sigLen);
            if (sigLen != crypto_sign_BYTES)
                throw Error("signature is not valid");

            RETVAL = crypto_sign_verify_detached(sig, (unsigned char *) msg, strlen(msg), publicKey) == 0;
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 957 "src/perl/lib/Nix/Store.cc"
	TARGi((IV)RETVAL, 1);
	ST(0) = TARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Nix__Store_addToStore); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_addToStore)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "THIS, srcPath, recursive, algo");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;
	char *	srcPath = (char *)SvPV_nolen(ST(1))
;
	int	recursive = (int)SvIV(ST(2))
;
	char *	algo = (char *)SvPV_nolen(ST(3))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::addToStore() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 335 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            auto method = recursive ? ContentAddressMethod::Raw::NixArchive : ContentAddressMethod::Raw::Flat;
            auto path = THIS->store->addToStore(
                std::string(baseNameOf(srcPath)),
                PosixSourceAccessor::createAtRoot(srcPath),
                method, parseHashAlgo(algo));
            XPUSHs(sv_2mortal(newSVpv(THIS->store->printStorePath(path).c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 1003 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_makeFixedOutputPath); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_makeFixedOutputPath)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "THIS, recursive, algo, hash, name");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	SV *	RETVAL;
	int	recursive = (int)SvIV(ST(1))
;
	char *	algo = (char *)SvPV_nolen(ST(2))
;
	char *	hash = (char *)SvPV_nolen(ST(3))
;
	char *	name = (char *)SvPV_nolen(ST(4))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::makeFixedOutputPath() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 350 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            auto h = Hash::parseAny(hash, parseHashAlgo(algo));
            auto method = recursive ? FileIngestionMethod::NixArchive : FileIngestionMethod::Flat;
            auto path = THIS->store->makeFixedOutputPath(name, FixedOutputInfo {
                .method = method,
                .hash = h,
                .references = {},
            });
            XPUSHs(sv_2mortal(newSVpv(THIS->store->printStorePath(path).c_str(), 0)));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 1052 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_derivationFromPath); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_derivationFromPath)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, drvPath");
    {
#line 367 "../nix/src/perl/lib/Nix/Store.xs"
        HV *hash;
#line 1068 "src/perl/lib/Nix/Store.cc"
	StoreWrapper *	THIS;
	SV *	RETVAL;
	char *	drvPath = (char *)SvPV_nolen(ST(1))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::derivationFromPath() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 369 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            Derivation drv = THIS->store->derivationFromPath(THIS->store->parseStorePath(drvPath));
            hash = newHV();

            HV * outputs = newHV();
            for (auto & i : drv.outputsAndOptPaths(*THIS->store)) {
                hv_store(
                    outputs, i.first.c_str(), i.first.size(),
                    !i.second.second
                        ? newSV(0) /* null value */
                        : newSVpv(THIS->store->printStorePath(*i.second.second).c_str(), 0),
                    0);
            }
            hv_stores(hash, "outputs", newRV((SV *) outputs));

            AV * inputDrvs = newAV();
            for (auto & i : drv.inputDrvs.map)
                av_push(inputDrvs, newSVpv(THIS->store->printStorePath(i.first).c_str(), 0)); // !!! ignores i->second
            hv_stores(hash, "inputDrvs", newRV((SV *) inputDrvs));

            AV * inputSrcs = newAV();
            for (auto & i : drv.inputSrcs)
                av_push(inputSrcs, newSVpv(THIS->store->printStorePath(i).c_str(), 0));
            hv_stores(hash, "inputSrcs", newRV((SV *) inputSrcs));

            hv_stores(hash, "platform", newSVpv(drv.platform.c_str(), 0));
            hv_stores(hash, "builder", newSVpv(drv.builder.c_str(), 0));

            AV * args = newAV();
            for (auto & i : drv.args)
                av_push(args, newSVpv(i.c_str(), 0));
            hv_stores(hash, "args", newRV((SV *) args));

            HV * env = newHV();
            for (auto & i : drv.env)
                hv_store(env, i.first.c_str(), i.first.size(), newSVpv(i.second.c_str(), 0), 0);
            hv_stores(hash, "env", newRV((SV *) env));

            RETVAL = newRV_noinc((SV *)hash);
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 1126 "src/perl/lib/Nix/Store.cc"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Nix__Store_addTempRoot); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_addTempRoot)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, storePath");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	StoreWrapper *	THIS;
	char *	storePath = (char *)SvPV_nolen(ST(1))
;

    if ( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
        THIS = (StoreWrapper *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn( "Nix::Store::addTempRoot() -- "
		"THIS not a blessed SV reference");
        XSRETURN_UNDEF;
    }
;
#line 418 "../nix/src/perl/lib/Nix/Store.xs"
        try {
            THIS->store->addTempRoot(THIS->store->parseStorePath(storePath));
        } catch (Error & e) {
            croak("%s", e.what());
        }
#line 1162 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Nix__Store_getStoreDir); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Nix__Store_getStoreDir)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	RETVAL;
#line 427 "../nix/src/perl/lib/Nix/Store.xs"
        XPUSHs(sv_2mortal(newSVpv(settings.nixStore.c_str(), 0)));
#line 1181 "src/perl/lib/Nix/Store.cc"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Nix__Store); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Nix__Store)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("Nix::Store::DESTROY", XS_Nix__Store_DESTROY, file, "$");
        (void)newXSproto_portable("Nix::Store::new", XS_Nix__Store_new, file, "$;$");
        (void)newXSproto_portable("Nix::Store::init", XS_Nix__Store_init, file, "");
        (void)newXSproto_portable("Nix::Store::setVerbosity", XS_Nix__Store_setVerbosity, file, "$");
        (void)newXSproto_portable("Nix::Store::isValidPath", XS_Nix__Store_isValidPath, file, "$$");
        (void)newXSproto_portable("Nix::Store::queryReferences", XS_Nix__Store_queryReferences, file, "$$");
        (void)newXSproto_portable("Nix::Store::queryPathHash", XS_Nix__Store_queryPathHash, file, "$$");
        (void)newXSproto_portable("Nix::Store::queryDeriver", XS_Nix__Store_queryDeriver, file, "$$");
        (void)newXSproto_portable("Nix::Store::queryPathInfo", XS_Nix__Store_queryPathInfo, file, "$$$");
        (void)newXSproto_portable("Nix::Store::queryRawRealisation", XS_Nix__Store_queryRawRealisation, file, "$$");
        (void)newXSproto_portable("Nix::Store::queryPathFromHashPart", XS_Nix__Store_queryPathFromHashPart, file, "$$");
        (void)newXSproto_portable("Nix::Store::computeFSClosure", XS_Nix__Store_computeFSClosure, file, "$$$;@");
        (void)newXSproto_portable("Nix::Store::topoSortPaths", XS_Nix__Store_topoSortPaths, file, "$;@");
        (void)newXSproto_portable("Nix::Store::followLinksToStorePath", XS_Nix__Store_followLinksToStorePath, file, "$$");
        (void)newXSproto_portable("Nix::Store::exportPaths", XS_Nix__Store_exportPaths, file, "$$;@");
        (void)newXSproto_portable("Nix::Store::importPaths", XS_Nix__Store_importPaths, file, "$$$");
        (void)newXSproto_portable("Nix::Store::hashPath", XS_Nix__Store_hashPath, file, "$$$");
        (void)newXSproto_portable("Nix::Store::hashFile", XS_Nix__Store_hashFile, file, "$$$");
        (void)newXSproto_portable("Nix::Store::hashString", XS_Nix__Store_hashString, file, "$$$");
        (void)newXSproto_portable("Nix::Store::convertHash", XS_Nix__Store_convertHash, file, "$$$");
        (void)newXSproto_portable("Nix::Store::signString", XS_Nix__Store_signString, file, "$$");
        (void)newXSproto_portable("Nix::Store::checkSignature", XS_Nix__Store_checkSignature, file, "$$$");
        (void)newXSproto_portable("Nix::Store::addToStore", XS_Nix__Store_addToStore, file, "$$$$");
        (void)newXSproto_portable("Nix::Store::makeFixedOutputPath", XS_Nix__Store_makeFixedOutputPath, file, "$$$$$");
        (void)newXSproto_portable("Nix::Store::derivationFromPath", XS_Nix__Store_derivationFromPath, file, "$$");
        (void)newXSproto_portable("Nix::Store::addTempRoot", XS_Nix__Store_addTempRoot, file, "$$");
        (void)newXSproto_portable("Nix::Store::getStoreDir", XS_Nix__Store_getStoreDir, file, "");
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
