// IWYU pragma: private, include "nvim/path.h"
#define DEFINE_FUNC_ATTRIBUTES
#include "nvim/func_attr.h"
#undef DEFINE_FUNC_ATTRIBUTES
#ifndef DLLEXPORT
#  ifdef MSWIN
#    define DLLEXPORT __declspec(dllexport)
#  else
#    define DLLEXPORT
#  endif
#endif
DLLEXPORT FileComparison path_full_compare(char *const s1, char *const s2, const bool checkname, const bool expandenv) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT char *path_tail(const char *fname) FUNC_ATTR_NONNULL_RET;
DLLEXPORT char *path_tail_with_sep(char *fname) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT const char *invocation_path_tail(const char *invocation, size_t *len) FUNC_ATTR_NONNULL_RET FUNC_ATTR_NONNULL_ARG(1);
DLLEXPORT const char *path_next_component(const char *fname) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT int path_head_length(void);
DLLEXPORT bool is_path_head(const char *path) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT char *get_past_head(const char *path) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool vim_ispathsep(int c);
DLLEXPORT bool vim_ispathsep_nocolon(int c);
DLLEXPORT bool vim_ispathlistsep(int c);
DLLEXPORT void shorten_dir_len(char *str, int trim_len) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void shorten_dir(char *str) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool dir_of_file_exists(char *fname) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT int path_fnamecmp(const char *fname1, const char *fname2) FUNC_ATTR_NONNULL_ALL FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT int path_fnamencmp(const char *const fname1, const char *const fname2, size_t len) FUNC_ATTR_NONNULL_ALL FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT char *concat_fnames(const char *fname1, const char *fname2, bool sep) FUNC_ATTR_NONNULL_ALL FUNC_ATTR_NONNULL_RET;
DLLEXPORT char *concat_fnames_realloc(char *fname1, const char *fname2, bool sep) FUNC_ATTR_NONNULL_ALL FUNC_ATTR_NONNULL_RET;
DLLEXPORT bool add_pathsep(char *p) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT char *FullName_save(const char *fname, bool force) FUNC_ATTR_MALLOC;
DLLEXPORT char *save_abs_path(const char *name) FUNC_ATTR_MALLOC FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool path_has_wildcard(const char *p) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool path_has_exp_wildcard(const char *p) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT const char *gettail_dir(const char *const fname) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL;
DLLEXPORT int gen_expand_wildcards(int num_pat, char **pat, int *num_file, char ***file, int flags);
DLLEXPORT void FreeWild(int count, char **files);
DLLEXPORT void addfile(garray_T *gap, char *f, int flags) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT size_t simplify_filename(char *filename) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool path_has_drive_letter(const char *p) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT int path_is_url(const char *p) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT int path_with_url(const char *fname) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool path_with_extension(const char *path, const char *extension) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool vim_isAbsName(const char *name) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT int vim_FullName(const char *fname, char *buf, size_t len, bool force) FUNC_ATTR_NONNULL_ARG(2);
DLLEXPORT char *fix_fname(const char *fname);
DLLEXPORT void path_fix_case(char *name) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT int after_pathsep(const char *b, const char *p) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool same_directory(char *f1, char *f2);
DLLEXPORT int pathcmp(const char *p, const char *q, int maxlen);
DLLEXPORT char *path_try_shorten_fname(char *full_path);
DLLEXPORT char *path_shorten_fname(char *full_path, char *dir_name);
DLLEXPORT int expand_wildcards_eval(char **pat, int *num_file, char ***file, int flags);
DLLEXPORT int expand_wildcards(int num_pat, char **pat, int *num_files, char ***files, int flags);
DLLEXPORT bool match_suffix(char *fname) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT int path_full_dir_name(char *directory, char *buffer, size_t len) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT int append_path(char *path, const char *to_append, size_t max_len) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool path_is_absolute(const char *fname) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void path_guess_exepath(const char *argv0, char *buf, size_t bufsize) FUNC_ATTR_NONNULL_ALL;
#include "nvim/func_attr.h"
