// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/data"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolLogRecord = sync.Pool{
		New: func() any {
			return &otlplogs.LogRecord{}
		},
	}
)

func NewOrigLogRecord() *otlplogs.LogRecord {
	if !UseProtoPooling.IsEnabled() {
		return &otlplogs.LogRecord{}
	}
	return protoPoolLogRecord.Get().(*otlplogs.LogRecord)
}

func DeleteOrigLogRecord(orig *otlplogs.LogRecord, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteOrigAnyValue(&orig.Body, false)
	for i := range orig.Attributes {
		DeleteOrigKeyValue(&orig.Attributes[i], false)
	}
	DeleteOrigTraceID(&orig.TraceId, false)
	DeleteOrigSpanID(&orig.SpanId, false)

	orig.Reset()
	if nullable {
		protoPoolLogRecord.Put(orig)
	}
}

func CopyOrigLogRecord(dest, src *otlplogs.LogRecord) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.TimeUnixNano = src.TimeUnixNano
	dest.ObservedTimeUnixNano = src.ObservedTimeUnixNano
	dest.SeverityNumber = src.SeverityNumber
	dest.SeverityText = src.SeverityText
	CopyOrigAnyValue(&dest.Body, &src.Body)
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.DroppedAttributesCount = src.DroppedAttributesCount
	dest.Flags = src.Flags
	dest.TraceId = src.TraceId
	dest.SpanId = src.SpanId
	dest.EventName = src.EventName
}

func GenTestOrigLogRecord() *otlplogs.LogRecord {
	orig := NewOrigLogRecord()
	orig.TimeUnixNano = 1234567890
	orig.ObservedTimeUnixNano = 1234567890
	orig.SeverityNumber = otlplogs.SeverityNumber(5)
	orig.SeverityText = "test_severitytext"
	orig.Body = *GenTestOrigAnyValue()
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.DroppedAttributesCount = uint32(13)
	orig.Flags = 1
	orig.TraceId = data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	orig.SpanId = data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})
	orig.EventName = "test_eventname"
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigLogRecord(orig *otlplogs.LogRecord, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.ObservedTimeUnixNano != uint64(0) {
		dest.WriteObjectField("observedTimeUnixNano")
		dest.WriteUint64(orig.ObservedTimeUnixNano)
	}

	if int32(orig.SeverityNumber) != 0 {
		dest.WriteObjectField("severityNumber")
		dest.WriteInt32(int32(orig.SeverityNumber))
	}
	if orig.SeverityText != "" {
		dest.WriteObjectField("severityText")
		dest.WriteString(orig.SeverityText)
	}
	dest.WriteObjectField("body")
	MarshalJSONOrigAnyValue(&orig.Body, dest)
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if orig.TraceId != data.TraceID([16]byte{}) {
		dest.WriteObjectField("traceId")
		MarshalJSONOrigTraceID(&orig.TraceId, dest)
	}
	if orig.SpanId != data.SpanID([8]byte{}) {
		dest.WriteObjectField("spanId")
		MarshalJSONOrigSpanID(&orig.SpanId, dest)
	}
	if orig.EventName != "" {
		dest.WriteObjectField("eventName")
		dest.WriteString(orig.EventName)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigLogRecord unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigLogRecord(orig *otlplogs.LogRecord, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "observedTimeUnixNano", "observed_time_unix_nano":
			orig.ObservedTimeUnixNano = iter.ReadUint64()
		case "severityNumber", "severity_number":
			orig.SeverityNumber = otlplogs.SeverityNumber(iter.ReadEnumValue(otlplogs.SeverityNumber_value))
		case "severityText", "severity_text":
			orig.SeverityText = iter.ReadString()
		case "body":
			UnmarshalJSONOrigAnyValue(&orig.Body, iter)
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
				UnmarshalJSONOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], iter)
			}

		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "flags":
			orig.Flags = iter.ReadUint32()
		case "traceId", "trace_id":
			UnmarshalJSONOrigTraceID(&orig.TraceId, iter)
		case "spanId", "span_id":
			UnmarshalJSONOrigSpanID(&orig.SpanId, iter)
		case "eventName", "event_name":
			orig.EventName = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigLogRecord(orig *otlplogs.LogRecord) int {
	var n int
	var l int
	_ = l
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	if orig.ObservedTimeUnixNano != 0 {
		n += 9
	}
	if orig.SeverityNumber != 0 {
		n += 1 + proto.Sov(uint64(orig.SeverityNumber))
	}
	l = len(orig.SeverityText)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = SizeProtoOrigAnyValue(&orig.Body)
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	if orig.Flags != 0 {
		n += 5
	}
	l = SizeProtoOrigTraceID(&orig.TraceId)
	n += 1 + proto.Sov(uint64(l)) + l
	l = SizeProtoOrigSpanID(&orig.SpanId)
	n += 1 + proto.Sov(uint64(l)) + l
	l = len(orig.EventName)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigLogRecord(orig *otlplogs.LogRecord, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x9
	}
	if orig.ObservedTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.ObservedTimeUnixNano))
		pos--
		buf[pos] = 0x59
	}
	if orig.SeverityNumber != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.SeverityNumber))
		pos--
		buf[pos] = 0x10
	}
	l = len(orig.SeverityText)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SeverityText)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}

	l = MarshalProtoOrigAnyValue(&orig.Body, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x2a

	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x32
	}
	if orig.DroppedAttributesCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x38
	}
	if orig.Flags != 0 {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.Flags))
		pos--
		buf[pos] = 0x45
	}

	l = MarshalProtoOrigTraceID(&orig.TraceId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x4a

	l = MarshalProtoOrigSpanID(&orig.SpanId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x52

	l = len(orig.EventName)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.EventName)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x62
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigLogRecord(orig *otlplogs.LogRecord, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 11:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.ObservedTimeUnixNano = uint64(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityNumber", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.SeverityNumber = otlplogs.SeverityNumber(num)

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityText", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SeverityText = string(buf[startPos:pos])

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigAnyValue(&orig.Body, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 6:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
			err = UnmarshalProtoOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 7:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.DroppedAttributesCount = uint32(num)

		case 8:
			if wireType != proto.WireTypeI32 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint32
			num, pos, err = proto.ConsumeI32(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigTraceID(&orig.TraceId, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 10:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigSpanID(&orig.SpanId, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 12:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field EventName", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.EventName = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
