#include "agx_nir.h"

#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 3
 * transforms:
 *    ('amul', ('amul', 'a', '#b'), '#c') => ('amul', 'a', ('imul', 'b', 'c'))
 *    ('amul', ('ishl', ('u2u64', 'a@32'), '#b(is_ult_32)'), '#c') => ('amul', ('u2u64', 'a'), ('ishl', 'c', 'b'))
 *    ('iadd', 'a', 0) => a
 */


static const nir_search_value_union agx_nir_cleanup_amul_values[] = {
   /* ('amul', ('amul', 'a', '#b'), '#c') => ('amul', 'a', ('imul', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      0, 2,
      { 2, 3 },
      -1,
   } },

   /* replace0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 1,
      { 5, 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      0, 2,
      { 0, 7 },
      -1,
   } },

   /* ('amul', ('ishl', ('u2u64', 'a@32'), '#b(is_ult_32)'), '#c') => ('amul', ('u2u64', 'a'), ('ishl', 'c', 'b')) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 0,
      { 9 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 10, 11 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      0, 1,
      { 12, 13 },
      -1,
   } },

   /* replace1_0_0 -> 9 in the cache */
   /* replace1_0 -> 10 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 15, 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      0, 1,
      { 10, 17 },
      -1,
   } },

   /* ('iadd', 'a', 0) => a */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 19, 20 },
      -1,
   } },

   /* replace2 -> 19 in the cache */

};


static const nir_search_variable_cond agx_nir_cleanup_amul_variable_cond[] = {
   (is_ult_32),
};

static const struct transform agx_nir_cleanup_amul_transforms[] = {
   { ~0, ~0, ~0 }, /* Sentinel */

   { 21, 19, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 4, 8, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 14, 18, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

};

static const struct per_op_table agx_nir_cleanup_amul_pass_op_table[nir_num_search_ops] = {
   [nir_op_amul] = {
      .filter = (const uint16_t []) {
         0,
         1,
         2,
         0,
         0,
         2,
         3,
         2,
      },
      
      .num_filtered_states = 4,
      .table = (const uint16_t []) {
      
         0,
         2,
         0,
         0,
         2,
         2,
         5,
         7,
         0,
         5,
         0,
         0,
         0,
         7,
         0,
         0,
      },
   },
   [nir_op_ishl] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         2,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 3,
      .table = (const uint16_t []) {
      
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         6,
         0,
      },
   },
   [nir_search_op_u2u] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         3,
      },
   },
   [nir_op_iadd] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         0,
         4,
         4,
         4,
      },
   },
};

/* Mapping from state index to offset in transforms (0 being no transforms) */
static const uint16_t agx_nir_cleanup_amul_transform_offsets[] = {
   0,
   0,
   0,
   0,
   1,
   3,
   0,
   5,
};

static const nir_algebraic_table agx_nir_cleanup_amul_table = {
   .transforms = agx_nir_cleanup_amul_transforms,
   .transform_offsets = agx_nir_cleanup_amul_transform_offsets,
   .pass_op_table = agx_nir_cleanup_amul_pass_op_table,
   .values = agx_nir_cleanup_amul_values,
   .expression_cond = NULL,
   .variable_cond = agx_nir_cleanup_amul_variable_cond,
};

bool
agx_nir_cleanup_amul(
   nir_shader *shader
) {
   bool progress = false;
   bool condition_flags[1];
   const nir_shader_compiler_options *options = shader->options;
   const shader_info *info = &shader->info;
   (void) options;
   (void) info;

   STATIC_ASSERT(22 == ARRAY_SIZE(agx_nir_cleanup_amul_values));
   condition_flags[0] = true;

   nir_foreach_function_impl(impl, shader) {
     progress |= nir_algebraic_impl(impl, condition_flags, &agx_nir_cleanup_amul_table);
   }

   return progress;
}


#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 44
 * transforms:
 *    ('iadd', 'a@64', ('amul', 2, ('iadd', '#b(is_upper_half_zero)', ('u2u64', 'c@32')))) => ('ulea_agx', ('ulea_agx', 'a', 'c', 1), ('u2u32', 'b'), 1)
 *    ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('i2i64', 'c@32')), 2)) => ('ilea_agx', ('iadd', 'a', ('ishl', 'b', 1)), 'c', 1)
 *    ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('iadd', 'c@64', ('u2u64', 'd@32'))), 2)) => ('ulea_agx', ('iadd', 'a', ('ishl', ('iadd', 'b', 'c'), 1)), 'd', 1)
 *    ('iadd', 'a@64', ('amul', ('u2u64', 'b@32'), 2)) => ('ulea_agx', 'a', 'b', 1)
 *    ('iadd', 'a@64', ('ishl', ('u2u64', 'b@32'), 1)) => ('ulea_agx', 'a', 'b', 1)
 *    ('iadd', 'a@64', ('amul', ('i2i64', 'b@32'), 2)) => ('ilea_agx', 'a', 'b', 1)
 *    ('iadd', 'a@64', ('ishl', ('i2i64', 'b@32'), 1)) => ('ilea_agx', 'a', 'b', 1)
 *    ('iadd', 'a@64', ('amul', 4, ('iadd', '#b(is_upper_half_zero)', ('u2u64', 'c@32')))) => ('ulea_agx', ('ulea_agx', 'a', 'c', 2), ('u2u32', 'b'), 2)
 *    ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('i2i64', 'c@32')), 4)) => ('ilea_agx', ('iadd', 'a', ('ishl', 'b', 2)), 'c', 2)
 *    ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('iadd', 'c@64', ('u2u64', 'd@32'))), 4)) => ('ulea_agx', ('iadd', 'a', ('ishl', ('iadd', 'b', 'c'), 2)), 'd', 2)
 *    ('iadd', 'a@64', ('amul', ('u2u64', 'b@32'), 4)) => ('ulea_agx', 'a', 'b', 2)
 *    ('iadd', 'a@64', ('ishl', ('u2u64', 'b@32'), 2)) => ('ulea_agx', 'a', 'b', 2)
 *    ('iadd', 'a@64', ('amul', ('i2i64', 'b@32'), 4)) => ('ilea_agx', 'a', 'b', 2)
 *    ('iadd', 'a@64', ('ishl', ('i2i64', 'b@32'), 2)) => ('ilea_agx', 'a', 'b', 2)
 *    ('iadd', 'a@64', ('amul', 8, ('iadd', '#b(is_upper_half_zero)', ('u2u64', 'c@32')))) => ('ulea_agx', ('ulea_agx', 'a', 'c', 3), ('u2u32', 'b'), 3)
 *    ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('i2i64', 'c@32')), 8)) => ('ilea_agx', ('iadd', 'a', ('ishl', 'b', 3)), 'c', 3)
 *    ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('iadd', 'c@64', ('u2u64', 'd@32'))), 8)) => ('ulea_agx', ('iadd', 'a', ('ishl', ('iadd', 'b', 'c'), 3)), 'd', 3)
 *    ('iadd', 'a@64', ('amul', ('u2u64', 'b@32'), 8)) => ('ulea_agx', 'a', 'b', 3)
 *    ('iadd', 'a@64', ('ishl', ('u2u64', 'b@32'), 3)) => ('ulea_agx', 'a', 'b', 3)
 *    ('iadd', 'a@64', ('amul', ('i2i64', 'b@32'), 8)) => ('ilea_agx', 'a', 'b', 3)
 *    ('iadd', 'a@64', ('ishl', ('i2i64', 'b@32'), 3)) => ('ilea_agx', 'a', 'b', 3)
 *    ('iadd', 'a@64', ('amul', 16, ('iadd', '#b(is_upper_half_zero)', ('u2u64', 'c@32')))) => ('ulea_agx', ('ulea_agx', 'a', 'c', 4), ('u2u32', 'b'), 4)
 *    ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('i2i64', 'c@32')), 16)) => ('ilea_agx', ('iadd', 'a', ('ishl', 'b', 4)), 'c', 4)
 *    ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('iadd', 'c@64', ('u2u64', 'd@32'))), 16)) => ('ulea_agx', ('iadd', 'a', ('ishl', ('iadd', 'b', 'c'), 4)), 'd', 4)
 *    ('iadd', 'a@64', ('amul', ('u2u64', 'b@32'), 16)) => ('ulea_agx', 'a', 'b', 4)
 *    ('iadd', 'a@64', ('ishl', ('u2u64', 'b@32'), 4)) => ('ulea_agx', 'a', 'b', 4)
 *    ('iadd', 'a@64', ('amul', ('i2i64', 'b@32'), 16)) => ('ilea_agx', 'a', 'b', 4)
 *    ('iadd', 'a@64', ('ishl', ('i2i64', 'b@32'), 4)) => ('ilea_agx', 'a', 'b', 4)
 *    ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', 16))) => ('ulea_agx', 'a', 'b', 4)
 *    ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', '#c(is_unsigned_multiple_of_16)'))) => ('ulea_agx', 'a', ('imul', 'b', ('ushr', 'c', 4)), 4)
 *    ('iadd', 'a@64', ('u2u64', ('iadd', '#b(is_unsigned_multiple_of_16)', ('amul', 'c@32', '#d(is_unsigned_multiple_of_16)')))) => ('ulea_agx', 'a', ('iadd', ('ishr', 'b', 4), ('amul', 'c@32', ('ishr', 'd', 4))), 4)
 *    ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', 8))) => ('ulea_agx', 'a', 'b', 3)
 *    ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', '#c(is_unsigned_multiple_of_8)'))) => ('ulea_agx', 'a', ('imul', 'b', ('ushr', 'c', 3)), 3)
 *    ('iadd', 'a@64', ('u2u64', ('iadd', '#b(is_unsigned_multiple_of_8)', ('amul', 'c@32', '#d(is_unsigned_multiple_of_8)')))) => ('ulea_agx', 'a', ('iadd', ('ishr', 'b', 3), ('amul', 'c@32', ('ishr', 'd', 3))), 3)
 *    ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', 4))) => ('ulea_agx', 'a', 'b', 2)
 *    ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', '#c(is_unsigned_multiple_of_4)'))) => ('ulea_agx', 'a', ('imul', 'b', ('ushr', 'c', 2)), 2)
 *    ('iadd', 'a@64', ('u2u64', ('iadd', '#b(is_unsigned_multiple_of_4)', ('amul', 'c@32', '#d(is_unsigned_multiple_of_4)')))) => ('ulea_agx', 'a', ('iadd', ('ishr', 'b', 2), ('amul', 'c@32', ('ishr', 'd', 2))), 2)
 *    ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', 2))) => ('ulea_agx', 'a', 'b', 1)
 *    ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', '#c(is_unsigned_multiple_of_2)'))) => ('ulea_agx', 'a', ('imul', 'b', ('ushr', 'c', 1)), 1)
 *    ('iadd', 'a@64', ('u2u64', ('iadd', '#b(is_unsigned_multiple_of_2)', ('amul', 'c@32', '#d(is_unsigned_multiple_of_2)')))) => ('ulea_agx', 'a', ('iadd', ('ishr', 'b', 1), ('amul', 'c@32', ('ishr', 'd', 1))), 1)
 *    ('iadd', 'a', ('u2u64', 'b@32')) => ('ulea_agx', 'a', 'b', 0)
 *    ('iadd', 'a', ('i2i64', 'b@32')) => ('ilea_agx', 'a', 'b', 0)
 *    ('iadd', 'a', ('iadd', ('u2u64', 'b@32'), 'c')) => ('ulea_agx', ('iadd', 'a', 'c'), 'b', 0)
 *    ('iadd', 'a', ('iadd', ('i2i64', 'b@32'), 'c')) => ('ilea_agx', ('iadd', 'a', 'c'), 'b', 0)
 */


static const nir_search_value_union agx_nir_fuse_lea_values[] = {
   /* ('iadd', 'a@64', ('amul', 2, ('iadd', '#b(is_upper_half_zero)', ('u2u64', 'c@32')))) => ('ulea_agx', ('ulea_agx', 'a', 'c', 1), ('u2u32', 'b'), 1) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 1,
      { 2, 4 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 2,
      { 1, 5 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 6 },
      -1,
   } },

   /* replace3_0_0 -> 0 in the cache */
   /* replace3_0_1 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 0, 3, 8 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u32,
      -1, 0,
      { 10 },
      -1,
   } },
   /* replace3_2 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 9, 11, 8 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('i2i64', 'c@32')), 2)) => ('ilea_agx', ('iadd', 'a', ('ishl', 'b', 1)), 'c', 1) */
   /* search4_0 -> 0 in the cache */
   /* search4_1_0_0 -> 10 in the cache */
   /* search4_1_0_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_i2i64,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 1,
      { 10, 13 },
      -1,
   } },
   /* search4_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 2,
      { 14, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 15 },
      -1,
   } },

   /* replace4_0_0 -> 0 in the cache */
   /* replace4_0_1_0 -> 10 in the cache */
   /* replace4_0_1_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 10, 8 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 17 },
      -1,
   } },
   /* replace4_1 -> 3 in the cache */
   /* replace4_2 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 1,
      { 18, 3, 8 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('iadd', 'c@64', ('u2u64', 'd@32'))), 2)) => ('ulea_agx', ('iadd', 'a', ('ishl', ('iadd', 'b', 'c'), 1)), 'd', 1) */
   /* search5_0 -> 0 in the cache */
   /* search5_1_0_0 -> 10 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      3, 1,
      { 20, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 2,
      { 10, 23 },
      -1,
   } },
   /* search5_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 3,
      { 24, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 0, 25 },
      -1,
   } },

   /* replace5_0_0 -> 0 in the cache */
   /* replace5_0_1_0_0 -> 10 in the cache */
   /* replace5_0_1_0_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 10, 20 },
      -1,
   } },
   /* replace5_0_1_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 27, 8 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 28 },
      -1,
   } },
   /* replace5_1 -> 21 in the cache */
   /* replace5_2 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 2,
      { 29, 21, 8 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('u2u64', 'b@32'), 2)) => ('ulea_agx', 'a', 'b', 1) */
   /* search6_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 0,
      { 31 },
      -1,
   } },
   /* search6_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 32, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 33 },
      -1,
   } },

   /* replace6_0 -> 0 in the cache */
   /* replace6_1 -> 31 in the cache */
   /* replace6_2 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 0, 31, 8 },
      -1,
   } },

   /* ('iadd', 'a@64', ('ishl', ('u2u64', 'b@32'), 1)) => ('ulea_agx', 'a', 'b', 1) */
   /* search7_0 -> 0 in the cache */
   /* search7_1_0_0 -> 31 in the cache */
   /* search7_1_0 -> 32 in the cache */
   /* search7_1_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 32, 8 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 36 },
      -1,
   } },

   /* replace7_0 -> 0 in the cache */
   /* replace7_1 -> 31 in the cache */
   /* replace7_2 -> 8 in the cache */
   /* replace7 -> 35 in the cache */

   /* ('iadd', 'a@64', ('amul', ('i2i64', 'b@32'), 2)) => ('ilea_agx', 'a', 'b', 1) */
   /* search8_0 -> 0 in the cache */
   /* search8_1_0_0 -> 31 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_i2i64,
      -1, 0,
      { 31 },
      -1,
   } },
   /* search8_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 38, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 39 },
      -1,
   } },

   /* replace8_0 -> 0 in the cache */
   /* replace8_1 -> 31 in the cache */
   /* replace8_2 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 0,
      { 0, 31, 8 },
      -1,
   } },

   /* ('iadd', 'a@64', ('ishl', ('i2i64', 'b@32'), 1)) => ('ilea_agx', 'a', 'b', 1) */
   /* search9_0 -> 0 in the cache */
   /* search9_1_0_0 -> 31 in the cache */
   /* search9_1_0 -> 38 in the cache */
   /* search9_1_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 38, 8 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 42 },
      -1,
   } },

   /* replace9_0 -> 0 in the cache */
   /* replace9_1 -> 31 in the cache */
   /* replace9_2 -> 8 in the cache */
   /* replace9 -> 41 in the cache */

   /* ('iadd', 'a@64', ('amul', 4, ('iadd', '#b(is_upper_half_zero)', ('u2u64', 'c@32')))) => ('ulea_agx', ('ulea_agx', 'a', 'c', 2), ('u2u32', 'b'), 2) */
   /* search10_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x4ull /* 4 */ },
   } },
   /* search10_1_1_0 -> 2 in the cache */
   /* search10_1_1_1_0 -> 3 in the cache */
   /* search10_1_1_1 -> 4 in the cache */
   /* search10_1_1 -> 5 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 2,
      { 44, 5 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 45 },
      -1,
   } },

   /* replace10_0_0 -> 0 in the cache */
   /* replace10_0_1 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 0, 3, 47 },
      -1,
   } },
   /* replace10_1_0 -> 10 in the cache */
   /* replace10_1 -> 11 in the cache */
   /* replace10_2 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 48, 11, 47 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('i2i64', 'c@32')), 4)) => ('ilea_agx', ('iadd', 'a', ('ishl', 'b', 2)), 'c', 2) */
   /* search11_0 -> 0 in the cache */
   /* search11_1_0_0 -> 10 in the cache */
   /* search11_1_0_1_0 -> 3 in the cache */
   /* search11_1_0_1 -> 13 in the cache */
   /* search11_1_0 -> 14 in the cache */
   /* search11_1_1 -> 44 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 2,
      { 14, 44 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 50 },
      -1,
   } },

   /* replace11_0_0 -> 0 in the cache */
   /* replace11_0_1_0 -> 10 in the cache */
   /* replace11_0_1_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 10, 47 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 52 },
      -1,
   } },
   /* replace11_1 -> 3 in the cache */
   /* replace11_2 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 1,
      { 53, 3, 47 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('iadd', 'c@64', ('u2u64', 'd@32'))), 4)) => ('ulea_agx', ('iadd', 'a', ('ishl', ('iadd', 'b', 'c'), 2)), 'd', 2) */
   /* search12_0 -> 0 in the cache */
   /* search12_1_0_0 -> 10 in the cache */
   /* search12_1_0_1_0 -> 20 in the cache */
   /* search12_1_0_1_1_0 -> 21 in the cache */
   /* search12_1_0_1_1 -> 22 in the cache */
   /* search12_1_0_1 -> 23 in the cache */
   /* search12_1_0 -> 24 in the cache */
   /* search12_1_1 -> 44 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 3,
      { 24, 44 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 0, 55 },
      -1,
   } },

   /* replace12_0_0 -> 0 in the cache */
   /* replace12_0_1_0_0 -> 10 in the cache */
   /* replace12_0_1_0_1 -> 20 in the cache */
   /* replace12_0_1_0 -> 27 in the cache */
   /* replace12_0_1_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 27, 47 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 57 },
      -1,
   } },
   /* replace12_1 -> 21 in the cache */
   /* replace12_2 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 2,
      { 58, 21, 47 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('u2u64', 'b@32'), 4)) => ('ulea_agx', 'a', 'b', 2) */
   /* search13_0 -> 0 in the cache */
   /* search13_1_0_0 -> 31 in the cache */
   /* search13_1_0 -> 32 in the cache */
   /* search13_1_1 -> 44 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 32, 44 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 60 },
      -1,
   } },

   /* replace13_0 -> 0 in the cache */
   /* replace13_1 -> 31 in the cache */
   /* replace13_2 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 0, 31, 47 },
      -1,
   } },

   /* ('iadd', 'a@64', ('ishl', ('u2u64', 'b@32'), 2)) => ('ulea_agx', 'a', 'b', 2) */
   /* search14_0 -> 0 in the cache */
   /* search14_1_0_0 -> 31 in the cache */
   /* search14_1_0 -> 32 in the cache */
   /* search14_1_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 32, 47 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 63 },
      -1,
   } },

   /* replace14_0 -> 0 in the cache */
   /* replace14_1 -> 31 in the cache */
   /* replace14_2 -> 47 in the cache */
   /* replace14 -> 62 in the cache */

   /* ('iadd', 'a@64', ('amul', ('i2i64', 'b@32'), 4)) => ('ilea_agx', 'a', 'b', 2) */
   /* search15_0 -> 0 in the cache */
   /* search15_1_0_0 -> 31 in the cache */
   /* search15_1_0 -> 38 in the cache */
   /* search15_1_1 -> 44 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 38, 44 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 65 },
      -1,
   } },

   /* replace15_0 -> 0 in the cache */
   /* replace15_1 -> 31 in the cache */
   /* replace15_2 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 0,
      { 0, 31, 47 },
      -1,
   } },

   /* ('iadd', 'a@64', ('ishl', ('i2i64', 'b@32'), 2)) => ('ilea_agx', 'a', 'b', 2) */
   /* search16_0 -> 0 in the cache */
   /* search16_1_0_0 -> 31 in the cache */
   /* search16_1_0 -> 38 in the cache */
   /* search16_1_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 38, 47 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 68 },
      -1,
   } },

   /* replace16_0 -> 0 in the cache */
   /* replace16_1 -> 31 in the cache */
   /* replace16_2 -> 47 in the cache */
   /* replace16 -> 67 in the cache */

   /* ('iadd', 'a@64', ('amul', 8, ('iadd', '#b(is_upper_half_zero)', ('u2u64', 'c@32')))) => ('ulea_agx', ('ulea_agx', 'a', 'c', 3), ('u2u32', 'b'), 3) */
   /* search17_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8ull /* 8 */ },
   } },
   /* search17_1_1_0 -> 2 in the cache */
   /* search17_1_1_1_0 -> 3 in the cache */
   /* search17_1_1_1 -> 4 in the cache */
   /* search17_1_1 -> 5 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 2,
      { 70, 5 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 71 },
      -1,
   } },

   /* replace17_0_0 -> 0 in the cache */
   /* replace17_0_1 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3ull /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 0, 3, 73 },
      -1,
   } },
   /* replace17_1_0 -> 10 in the cache */
   /* replace17_1 -> 11 in the cache */
   /* replace17_2 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 74, 11, 73 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('i2i64', 'c@32')), 8)) => ('ilea_agx', ('iadd', 'a', ('ishl', 'b', 3)), 'c', 3) */
   /* search18_0 -> 0 in the cache */
   /* search18_1_0_0 -> 10 in the cache */
   /* search18_1_0_1_0 -> 3 in the cache */
   /* search18_1_0_1 -> 13 in the cache */
   /* search18_1_0 -> 14 in the cache */
   /* search18_1_1 -> 70 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 2,
      { 14, 70 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 76 },
      -1,
   } },

   /* replace18_0_0 -> 0 in the cache */
   /* replace18_0_1_0 -> 10 in the cache */
   /* replace18_0_1_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 10, 73 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 78 },
      -1,
   } },
   /* replace18_1 -> 3 in the cache */
   /* replace18_2 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 1,
      { 79, 3, 73 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('iadd', 'c@64', ('u2u64', 'd@32'))), 8)) => ('ulea_agx', ('iadd', 'a', ('ishl', ('iadd', 'b', 'c'), 3)), 'd', 3) */
   /* search19_0 -> 0 in the cache */
   /* search19_1_0_0 -> 10 in the cache */
   /* search19_1_0_1_0 -> 20 in the cache */
   /* search19_1_0_1_1_0 -> 21 in the cache */
   /* search19_1_0_1_1 -> 22 in the cache */
   /* search19_1_0_1 -> 23 in the cache */
   /* search19_1_0 -> 24 in the cache */
   /* search19_1_1 -> 70 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 3,
      { 24, 70 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 0, 81 },
      -1,
   } },

   /* replace19_0_0 -> 0 in the cache */
   /* replace19_0_1_0_0 -> 10 in the cache */
   /* replace19_0_1_0_1 -> 20 in the cache */
   /* replace19_0_1_0 -> 27 in the cache */
   /* replace19_0_1_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 27, 73 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 83 },
      -1,
   } },
   /* replace19_1 -> 21 in the cache */
   /* replace19_2 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 2,
      { 84, 21, 73 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('u2u64', 'b@32'), 8)) => ('ulea_agx', 'a', 'b', 3) */
   /* search20_0 -> 0 in the cache */
   /* search20_1_0_0 -> 31 in the cache */
   /* search20_1_0 -> 32 in the cache */
   /* search20_1_1 -> 70 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 32, 70 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 86 },
      -1,
   } },

   /* replace20_0 -> 0 in the cache */
   /* replace20_1 -> 31 in the cache */
   /* replace20_2 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 0, 31, 73 },
      -1,
   } },

   /* ('iadd', 'a@64', ('ishl', ('u2u64', 'b@32'), 3)) => ('ulea_agx', 'a', 'b', 3) */
   /* search21_0 -> 0 in the cache */
   /* search21_1_0_0 -> 31 in the cache */
   /* search21_1_0 -> 32 in the cache */
   /* search21_1_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 32, 73 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 89 },
      -1,
   } },

   /* replace21_0 -> 0 in the cache */
   /* replace21_1 -> 31 in the cache */
   /* replace21_2 -> 73 in the cache */
   /* replace21 -> 88 in the cache */

   /* ('iadd', 'a@64', ('amul', ('i2i64', 'b@32'), 8)) => ('ilea_agx', 'a', 'b', 3) */
   /* search22_0 -> 0 in the cache */
   /* search22_1_0_0 -> 31 in the cache */
   /* search22_1_0 -> 38 in the cache */
   /* search22_1_1 -> 70 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 38, 70 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 91 },
      -1,
   } },

   /* replace22_0 -> 0 in the cache */
   /* replace22_1 -> 31 in the cache */
   /* replace22_2 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 0,
      { 0, 31, 73 },
      -1,
   } },

   /* ('iadd', 'a@64', ('ishl', ('i2i64', 'b@32'), 3)) => ('ilea_agx', 'a', 'b', 3) */
   /* search23_0 -> 0 in the cache */
   /* search23_1_0_0 -> 31 in the cache */
   /* search23_1_0 -> 38 in the cache */
   /* search23_1_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 38, 73 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 94 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1 -> 31 in the cache */
   /* replace23_2 -> 73 in the cache */
   /* replace23 -> 93 in the cache */

   /* ('iadd', 'a@64', ('amul', 16, ('iadd', '#b(is_upper_half_zero)', ('u2u64', 'c@32')))) => ('ulea_agx', ('ulea_agx', 'a', 'c', 4), ('u2u32', 'b'), 4) */
   /* search24_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x10ull /* 16 */ },
   } },
   /* search24_1_1_0 -> 2 in the cache */
   /* search24_1_1_1_0 -> 3 in the cache */
   /* search24_1_1_1 -> 4 in the cache */
   /* search24_1_1 -> 5 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 2,
      { 96, 5 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 97 },
      -1,
   } },

   /* replace24_0_0 -> 0 in the cache */
   /* replace24_0_1 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x4ull /* 4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 0, 3, 99 },
      -1,
   } },
   /* replace24_1_0 -> 10 in the cache */
   /* replace24_1 -> 11 in the cache */
   /* replace24_2 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 100, 11, 99 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('i2i64', 'c@32')), 16)) => ('ilea_agx', ('iadd', 'a', ('ishl', 'b', 4)), 'c', 4) */
   /* search25_0 -> 0 in the cache */
   /* search25_1_0_0 -> 10 in the cache */
   /* search25_1_0_1_0 -> 3 in the cache */
   /* search25_1_0_1 -> 13 in the cache */
   /* search25_1_0 -> 14 in the cache */
   /* search25_1_1 -> 96 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 2,
      { 14, 96 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 102 },
      -1,
   } },

   /* replace25_0_0 -> 0 in the cache */
   /* replace25_0_1_0 -> 10 in the cache */
   /* replace25_0_1_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 10, 99 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 104 },
      -1,
   } },
   /* replace25_1 -> 3 in the cache */
   /* replace25_2 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 1,
      { 105, 3, 99 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('iadd', 'b@64', ('iadd', 'c@64', ('u2u64', 'd@32'))), 16)) => ('ulea_agx', ('iadd', 'a', ('ishl', ('iadd', 'b', 'c'), 4)), 'd', 4) */
   /* search26_0 -> 0 in the cache */
   /* search26_1_0_0 -> 10 in the cache */
   /* search26_1_0_1_0 -> 20 in the cache */
   /* search26_1_0_1_1_0 -> 21 in the cache */
   /* search26_1_0_1_1 -> 22 in the cache */
   /* search26_1_0_1 -> 23 in the cache */
   /* search26_1_0 -> 24 in the cache */
   /* search26_1_1 -> 96 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 3,
      { 24, 96 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 0, 107 },
      -1,
   } },

   /* replace26_0_0 -> 0 in the cache */
   /* replace26_0_1_0_0 -> 10 in the cache */
   /* replace26_0_1_0_1 -> 20 in the cache */
   /* replace26_0_1_0 -> 27 in the cache */
   /* replace26_0_1_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 27, 99 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 109 },
      -1,
   } },
   /* replace26_1 -> 21 in the cache */
   /* replace26_2 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 2,
      { 110, 21, 99 },
      -1,
   } },

   /* ('iadd', 'a@64', ('amul', ('u2u64', 'b@32'), 16)) => ('ulea_agx', 'a', 'b', 4) */
   /* search27_0 -> 0 in the cache */
   /* search27_1_0_0 -> 31 in the cache */
   /* search27_1_0 -> 32 in the cache */
   /* search27_1_1 -> 96 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 32, 96 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 112 },
      -1,
   } },

   /* replace27_0 -> 0 in the cache */
   /* replace27_1 -> 31 in the cache */
   /* replace27_2 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 0, 31, 99 },
      -1,
   } },

   /* ('iadd', 'a@64', ('ishl', ('u2u64', 'b@32'), 4)) => ('ulea_agx', 'a', 'b', 4) */
   /* search28_0 -> 0 in the cache */
   /* search28_1_0_0 -> 31 in the cache */
   /* search28_1_0 -> 32 in the cache */
   /* search28_1_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 32, 99 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 115 },
      -1,
   } },

   /* replace28_0 -> 0 in the cache */
   /* replace28_1 -> 31 in the cache */
   /* replace28_2 -> 99 in the cache */
   /* replace28 -> 114 in the cache */

   /* ('iadd', 'a@64', ('amul', ('i2i64', 'b@32'), 16)) => ('ilea_agx', 'a', 'b', 4) */
   /* search29_0 -> 0 in the cache */
   /* search29_1_0_0 -> 31 in the cache */
   /* search29_1_0 -> 38 in the cache */
   /* search29_1_1 -> 96 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 38, 96 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 117 },
      -1,
   } },

   /* replace29_0 -> 0 in the cache */
   /* replace29_1 -> 31 in the cache */
   /* replace29_2 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 0,
      { 0, 31, 99 },
      -1,
   } },

   /* ('iadd', 'a@64', ('ishl', ('i2i64', 'b@32'), 4)) => ('ilea_agx', 'a', 'b', 4) */
   /* search30_0 -> 0 in the cache */
   /* search30_1_0_0 -> 31 in the cache */
   /* search30_1_0 -> 38 in the cache */
   /* search30_1_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 38, 99 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 120 },
      -1,
   } },

   /* replace30_0 -> 0 in the cache */
   /* replace30_1 -> 31 in the cache */
   /* replace30_2 -> 99 in the cache */
   /* replace30 -> 119 in the cache */

   /* ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', 16))) => ('ulea_agx', 'a', 'b', 4) */
   /* search31_0 -> 0 in the cache */
   /* search31_1_0_0 -> 31 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10ull /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 31, 122 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 1,
      { 123 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 124 },
      -1,
   } },

   /* replace31_0 -> 0 in the cache */
   /* replace31_1 -> 31 in the cache */
   /* replace31_2 -> 99 in the cache */
   /* replace31 -> 114 in the cache */

   /* ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', '#c(is_unsigned_multiple_of_16)'))) => ('ulea_agx', 'a', ('imul', 'b', ('ushr', 'c', 4)), 4) */
   /* search32_0 -> 0 in the cache */
   /* search32_1_0_0 -> 31 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 31, 126 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 1,
      { 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 128 },
      -1,
   } },

   /* replace32_0 -> 0 in the cache */
   /* replace32_1_0 -> 31 in the cache */
   /* replace32_1_1_0 -> 3 in the cache */
   /* replace32_1_1_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 3, 99 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 31, 130 },
      -1,
   } },
   /* replace32_2 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 1,
      { 0, 131, 99 },
      -1,
   } },

   /* ('iadd', 'a@64', ('u2u64', ('iadd', '#b(is_unsigned_multiple_of_16)', ('amul', 'c@32', '#d(is_unsigned_multiple_of_16)')))) => ('ulea_agx', 'a', ('iadd', ('ishr', 'b', 4), ('amul', 'c@32', ('ishr', 'd', 4))), 4) */
   /* search33_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search33_1_0_1_0 -> 3 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      2, 1,
      { 3, 134 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 2,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 2,
      { 136 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 137 },
      -1,
   } },

   /* replace33_0 -> 0 in the cache */
   /* replace33_1_0_0 -> 31 in the cache */
   /* replace33_1_0_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 31, 99 },
      -1,
   } },
   /* replace33_1_1_0 -> 3 in the cache */
   /* replace33_1_1_1_0 -> 21 in the cache */
   /* replace33_1_1_1_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 21, 99 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 3, 140 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 139, 141 },
      -1,
   } },
   /* replace33_2 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 2,
      { 0, 142, 99 },
      -1,
   } },

   /* ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', 8))) => ('ulea_agx', 'a', 'b', 3) */
   /* search34_0 -> 0 in the cache */
   /* search34_1_0_0 -> 31 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8ull /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 31, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 1,
      { 145 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 146 },
      -1,
   } },

   /* replace34_0 -> 0 in the cache */
   /* replace34_1 -> 31 in the cache */
   /* replace34_2 -> 73 in the cache */
   /* replace34 -> 88 in the cache */

   /* ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', '#c(is_unsigned_multiple_of_8)'))) => ('ulea_agx', 'a', ('imul', 'b', ('ushr', 'c', 3)), 3) */
   /* search35_0 -> 0 in the cache */
   /* search35_1_0_0 -> 31 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 31, 148 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 1,
      { 149 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 150 },
      -1,
   } },

   /* replace35_0 -> 0 in the cache */
   /* replace35_1_0 -> 31 in the cache */
   /* replace35_1_1_0 -> 3 in the cache */
   /* replace35_1_1_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 3, 73 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 31, 152 },
      -1,
   } },
   /* replace35_2 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 1,
      { 0, 153, 73 },
      -1,
   } },

   /* ('iadd', 'a@64', ('u2u64', ('iadd', '#b(is_unsigned_multiple_of_8)', ('amul', 'c@32', '#d(is_unsigned_multiple_of_8)')))) => ('ulea_agx', 'a', ('iadd', ('ishr', 'b', 3), ('amul', 'c@32', ('ishr', 'd', 3))), 3) */
   /* search36_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search36_1_0_1_0 -> 3 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      2, 1,
      { 3, 156 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 2,
      { 155, 157 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 2,
      { 158 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 159 },
      -1,
   } },

   /* replace36_0 -> 0 in the cache */
   /* replace36_1_0_0 -> 31 in the cache */
   /* replace36_1_0_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 31, 73 },
      -1,
   } },
   /* replace36_1_1_0 -> 3 in the cache */
   /* replace36_1_1_1_0 -> 21 in the cache */
   /* replace36_1_1_1_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 21, 73 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 3, 162 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 161, 163 },
      -1,
   } },
   /* replace36_2 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 2,
      { 0, 164, 73 },
      -1,
   } },

   /* ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', 4))) => ('ulea_agx', 'a', 'b', 2) */
   /* search37_0 -> 0 in the cache */
   /* search37_1_0_0 -> 31 in the cache */
   /* search37_1_0_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 31, 99 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 1,
      { 166 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 167 },
      -1,
   } },

   /* replace37_0 -> 0 in the cache */
   /* replace37_1 -> 31 in the cache */
   /* replace37_2 -> 47 in the cache */
   /* replace37 -> 62 in the cache */

   /* ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', '#c(is_unsigned_multiple_of_4)'))) => ('ulea_agx', 'a', ('imul', 'b', ('ushr', 'c', 2)), 2) */
   /* search38_0 -> 0 in the cache */
   /* search38_1_0_0 -> 31 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 31, 169 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 1,
      { 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 171 },
      -1,
   } },

   /* replace38_0 -> 0 in the cache */
   /* replace38_1_0 -> 31 in the cache */
   /* replace38_1_1_0 -> 3 in the cache */
   /* replace38_1_1_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 3, 47 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 31, 173 },
      -1,
   } },
   /* replace38_2 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 1,
      { 0, 174, 47 },
      -1,
   } },

   /* ('iadd', 'a@64', ('u2u64', ('iadd', '#b(is_unsigned_multiple_of_4)', ('amul', 'c@32', '#d(is_unsigned_multiple_of_4)')))) => ('ulea_agx', 'a', ('iadd', ('ishr', 'b', 2), ('amul', 'c@32', ('ishr', 'd', 2))), 2) */
   /* search39_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search39_1_0_1_0 -> 3 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      2, 1,
      { 3, 177 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 2,
      { 176, 178 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 2,
      { 179 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 180 },
      -1,
   } },

   /* replace39_0 -> 0 in the cache */
   /* replace39_1_0_0 -> 31 in the cache */
   /* replace39_1_0_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 31, 47 },
      -1,
   } },
   /* replace39_1_1_0 -> 3 in the cache */
   /* replace39_1_1_1_0 -> 21 in the cache */
   /* replace39_1_1_1_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 21, 47 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 3, 183 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 182, 184 },
      -1,
   } },
   /* replace39_2 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 2,
      { 0, 185, 47 },
      -1,
   } },

   /* ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', 2))) => ('ulea_agx', 'a', 'b', 1) */
   /* search40_0 -> 0 in the cache */
   /* search40_1_0_0 -> 31 in the cache */
   /* search40_1_0_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 31, 47 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 1,
      { 187 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 188 },
      -1,
   } },

   /* replace40_0 -> 0 in the cache */
   /* replace40_1 -> 31 in the cache */
   /* replace40_2 -> 8 in the cache */
   /* replace40 -> 35 in the cache */

   /* ('iadd', 'a@64', ('u2u64', ('amul', 'b@32', '#c(is_unsigned_multiple_of_2)'))) => ('ulea_agx', 'a', ('imul', 'b', ('ushr', 'c', 1)), 1) */
   /* search41_0 -> 0 in the cache */
   /* search41_1_0_0 -> 31 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 31, 190 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 1,
      { 191 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 192 },
      -1,
   } },

   /* replace41_0 -> 0 in the cache */
   /* replace41_1_0 -> 31 in the cache */
   /* replace41_1_1_0 -> 3 in the cache */
   /* replace41_1_1_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 3, 8 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 31, 194 },
      -1,
   } },
   /* replace41_2 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 1,
      { 0, 195, 8 },
      -1,
   } },

   /* ('iadd', 'a@64', ('u2u64', ('iadd', '#b(is_unsigned_multiple_of_2)', ('amul', 'c@32', '#d(is_unsigned_multiple_of_2)')))) => ('ulea_agx', 'a', ('iadd', ('ishr', 'b', 1), ('amul', 'c@32', ('ishr', 'd', 1))), 1) */
   /* search42_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search42_1_0_1_0 -> 3 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      2, 1,
      { 3, 198 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 2,
      { 197, 199 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 2,
      { 200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 0, 201 },
      -1,
   } },

   /* replace42_0 -> 0 in the cache */
   /* replace42_1_0_0 -> 31 in the cache */
   /* replace42_1_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 31, 8 },
      -1,
   } },
   /* replace42_1_1_0 -> 3 in the cache */
   /* replace42_1_1_1_0 -> 21 in the cache */
   /* replace42_1_1_1_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 21, 8 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      1, 1,
      { 3, 204 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 203, 205 },
      -1,
   } },
   /* replace42_2 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 2,
      { 0, 206, 8 },
      -1,
   } },

   /* ('iadd', 'a', ('u2u64', 'b@32')) => ('ulea_agx', 'a', 'b', 0) */
   /* search43_0 -> 0 in the cache */
   /* search43_1_0 -> 31 in the cache */
   /* search43_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 32 },
      -1,
   } },

   /* replace43_0 -> 0 in the cache */
   /* replace43_1 -> 31 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 0, 31, 209 },
      -1,
   } },

   /* ('iadd', 'a', ('i2i64', 'b@32')) => ('ilea_agx', 'a', 'b', 0) */
   /* search44_0 -> 0 in the cache */
   /* search44_1_0 -> 31 in the cache */
   /* search44_1 -> 38 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 38 },
      -1,
   } },

   /* replace44_0 -> 0 in the cache */
   /* replace44_1 -> 31 in the cache */
   /* replace44_2 -> 209 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 0,
      { 0, 31, 209 },
      -1,
   } },

   /* ('iadd', 'a', ('iadd', ('u2u64', 'b@32'), 'c')) => ('ulea_agx', ('iadd', 'a', 'c'), 'b', 0) */
   /* search45_0 -> 0 in the cache */
   /* search45_1_0_0 -> 31 in the cache */
   /* search45_1_0 -> 32 in the cache */
   /* search45_1_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 32, 20 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 213 },
      -1,
   } },

   /* replace45_0_0 -> 0 in the cache */
   /* replace45_0_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 20 },
      -1,
   } },
   /* replace45_1 -> 31 in the cache */
   /* replace45_2 -> 209 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 1,
      { 215, 31, 209 },
      -1,
   } },

   /* ('iadd', 'a', ('iadd', ('i2i64', 'b@32'), 'c')) => ('ilea_agx', ('iadd', 'a', 'c'), 'b', 0) */
   /* search46_0 -> 0 in the cache */
   /* search46_1_0_0 -> 31 in the cache */
   /* search46_1_0 -> 38 in the cache */
   /* search46_1_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 38, 20 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 217 },
      -1,
   } },

   /* replace46_0_0 -> 0 in the cache */
   /* replace46_0_1 -> 20 in the cache */
   /* replace46_0 -> 215 in the cache */
   /* replace46_1 -> 31 in the cache */
   /* replace46_2 -> 209 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 1,
      { 215, 31, 209 },
      -1,
   } },

};


static const nir_search_variable_cond agx_nir_fuse_lea_variable_cond[] = {
   (is_upper_half_zero),
   (is_unsigned_multiple_of_16),
   (is_unsigned_multiple_of_8),
   (is_unsigned_multiple_of_4),
   (is_unsigned_multiple_of_2),
};

static const struct transform agx_nir_fuse_lea_transforms[] = {
   { ~0, ~0, ~0 }, /* Sentinel */

   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 208, 210, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 61, 62, 0 },
   { 87, 88, 0 },
   { 113, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 40, 41, 0 },
   { 66, 67, 0 },
   { 92, 93, 0 },
   { 118, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 35, 0 },
   { 64, 62, 0 },
   { 90, 88, 0 },
   { 116, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 43, 41, 0 },
   { 69, 67, 0 },
   { 95, 93, 0 },
   { 121, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 61, 62, 0 },
   { 87, 88, 0 },
   { 113, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 40, 41, 0 },
   { 66, 67, 0 },
   { 92, 93, 0 },
   { 118, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 208, 210, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 208, 210, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 208, 210, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 61, 62, 0 },
   { 87, 88, 0 },
   { 113, 114, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 40, 41, 0 },
   { 66, 67, 0 },
   { 92, 93, 0 },
   { 118, 119, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 35, 0 },
   { 64, 62, 0 },
   { 90, 88, 0 },
   { 116, 114, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 43, 41, 0 },
   { 69, 67, 0 },
   { 95, 93, 0 },
   { 121, 119, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 211, 212, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 211, 212, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 211, 212, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 61, 62, 0 },
   { 87, 88, 0 },
   { 113, 114, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 40, 41, 0 },
   { 66, 67, 0 },
   { 92, 93, 0 },
   { 118, 119, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 35, 0 },
   { 64, 62, 0 },
   { 90, 88, 0 },
   { 116, 114, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 43, 41, 0 },
   { 69, 67, 0 },
   { 95, 93, 0 },
   { 121, 119, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 61, 62, 0 },
   { 87, 88, 0 },
   { 113, 114, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 40, 41, 0 },
   { 66, 67, 0 },
   { 92, 93, 0 },
   { 118, 119, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 35, 0 },
   { 64, 62, 0 },
   { 90, 88, 0 },
   { 116, 114, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 43, 41, 0 },
   { 69, 67, 0 },
   { 95, 93, 0 },
   { 121, 119, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 61, 62, 0 },
   { 87, 88, 0 },
   { 113, 114, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 40, 41, 0 },
   { 66, 67, 0 },
   { 92, 93, 0 },
   { 118, 119, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 35, 0 },
   { 64, 62, 0 },
   { 90, 88, 0 },
   { 116, 114, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 43, 41, 0 },
   { 69, 67, 0 },
   { 95, 93, 0 },
   { 121, 119, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 61, 62, 0 },
   { 87, 88, 0 },
   { 113, 114, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 40, 41, 0 },
   { 66, 67, 0 },
   { 92, 93, 0 },
   { 118, 119, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 35, 0 },
   { 64, 62, 0 },
   { 90, 88, 0 },
   { 116, 114, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 43, 41, 0 },
   { 69, 67, 0 },
   { 95, 93, 0 },
   { 121, 119, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 61, 62, 0 },
   { 87, 88, 0 },
   { 113, 114, 0 },
   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 40, 41, 0 },
   { 66, 67, 0 },
   { 92, 93, 0 },
   { 118, 119, 0 },
   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 35, 0 },
   { 64, 62, 0 },
   { 90, 88, 0 },
   { 116, 114, 0 },
   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 43, 41, 0 },
   { 69, 67, 0 },
   { 95, 93, 0 },
   { 121, 119, 0 },
   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 40, 41, 0 },
   { 61, 62, 0 },
   { 66, 67, 0 },
   { 87, 88, 0 },
   { 92, 93, 0 },
   { 113, 114, 0 },
   { 118, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 37, 35, 0 },
   { 61, 62, 0 },
   { 64, 62, 0 },
   { 87, 88, 0 },
   { 90, 88, 0 },
   { 113, 114, 0 },
   { 116, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 43, 41, 0 },
   { 61, 62, 0 },
   { 69, 67, 0 },
   { 87, 88, 0 },
   { 95, 93, 0 },
   { 113, 114, 0 },
   { 121, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 35, 0 },
   { 40, 41, 0 },
   { 64, 62, 0 },
   { 66, 67, 0 },
   { 90, 88, 0 },
   { 92, 93, 0 },
   { 116, 114, 0 },
   { 118, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 40, 41, 0 },
   { 43, 41, 0 },
   { 66, 67, 0 },
   { 69, 67, 0 },
   { 92, 93, 0 },
   { 95, 93, 0 },
   { 118, 119, 0 },
   { 121, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 35, 0 },
   { 43, 41, 0 },
   { 64, 62, 0 },
   { 69, 67, 0 },
   { 90, 88, 0 },
   { 95, 93, 0 },
   { 116, 114, 0 },
   { 121, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 51, 54, 0 },
   { 77, 80, 0 },
   { 103, 106, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 46, 49, 0 },
   { 72, 75, 0 },
   { 98, 101, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 51, 54, 0 },
   { 77, 80, 0 },
   { 103, 106, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 46, 49, 0 },
   { 72, 75, 0 },
   { 98, 101, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 51, 54, 0 },
   { 77, 80, 0 },
   { 103, 106, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 46, 49, 0 },
   { 72, 75, 0 },
   { 98, 101, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 51, 54, 0 },
   { 77, 80, 0 },
   { 103, 106, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 46, 49, 0 },
   { 72, 75, 0 },
   { 98, 101, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 51, 54, 0 },
   { 77, 80, 0 },
   { 103, 106, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 46, 49, 0 },
   { 72, 75, 0 },
   { 98, 101, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 51, 54, 0 },
   { 77, 80, 0 },
   { 103, 106, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 46, 49, 0 },
   { 72, 75, 0 },
   { 98, 101, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 51, 54, 0 },
   { 77, 80, 0 },
   { 103, 106, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 46, 49, 0 },
   { 72, 75, 0 },
   { 98, 101, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 51, 54, 0 },
   { 77, 80, 0 },
   { 103, 106, 0 },
   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 46, 49, 0 },
   { 72, 75, 0 },
   { 98, 101, 0 },
   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 125, 114, 0 },
   { 129, 132, 0 },
   { 138, 143, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 160, 165, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 181, 186, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 34, 35, 0 },
   { 51, 54, 0 },
   { 61, 62, 0 },
   { 77, 80, 0 },
   { 87, 88, 0 },
   { 103, 106, 0 },
   { 113, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 34, 35, 0 },
   { 46, 49, 0 },
   { 61, 62, 0 },
   { 72, 75, 0 },
   { 87, 88, 0 },
   { 98, 101, 0 },
   { 113, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 34, 35, 0 },
   { 61, 62, 0 },
   { 87, 88, 0 },
   { 113, 114, 0 },
   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 40, 41, 0 },
   { 51, 54, 0 },
   { 66, 67, 0 },
   { 77, 80, 0 },
   { 92, 93, 0 },
   { 103, 106, 0 },
   { 118, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 40, 41, 0 },
   { 46, 49, 0 },
   { 66, 67, 0 },
   { 72, 75, 0 },
   { 92, 93, 0 },
   { 98, 101, 0 },
   { 118, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 40, 41, 0 },
   { 66, 67, 0 },
   { 92, 93, 0 },
   { 118, 119, 0 },
   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 37, 35, 0 },
   { 51, 54, 0 },
   { 64, 62, 0 },
   { 77, 80, 0 },
   { 90, 88, 0 },
   { 103, 106, 0 },
   { 116, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 37, 35, 0 },
   { 46, 49, 0 },
   { 64, 62, 0 },
   { 72, 75, 0 },
   { 90, 88, 0 },
   { 98, 101, 0 },
   { 116, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 35, 0 },
   { 64, 62, 0 },
   { 90, 88, 0 },
   { 116, 114, 0 },
   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 43, 41, 0 },
   { 51, 54, 0 },
   { 69, 67, 0 },
   { 77, 80, 0 },
   { 95, 93, 0 },
   { 103, 106, 0 },
   { 121, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 43, 41, 0 },
   { 46, 49, 0 },
   { 69, 67, 0 },
   { 72, 75, 0 },
   { 95, 93, 0 },
   { 98, 101, 0 },
   { 121, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 43, 41, 0 },
   { 69, 67, 0 },
   { 95, 93, 0 },
   { 121, 119, 0 },
   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 16, 19, 0 },
   { 46, 49, 0 },
   { 51, 54, 0 },
   { 72, 75, 0 },
   { 77, 80, 0 },
   { 98, 101, 0 },
   { 103, 106, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 51, 54, 0 },
   { 77, 80, 0 },
   { 103, 106, 0 },
   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 46, 49, 0 },
   { 72, 75, 0 },
   { 98, 101, 0 },
   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 56, 59, 0 },
   { 82, 85, 0 },
   { 108, 111, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 56, 59, 0 },
   { 82, 85, 0 },
   { 108, 111, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 56, 59, 0 },
   { 82, 85, 0 },
   { 108, 111, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 56, 59, 0 },
   { 82, 85, 0 },
   { 108, 111, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 211, 212, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 56, 59, 0 },
   { 82, 85, 0 },
   { 108, 111, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 214, 216, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 56, 59, 0 },
   { 82, 85, 0 },
   { 108, 111, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 56, 59, 0 },
   { 82, 85, 0 },
   { 108, 111, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 214, 216, 0 },
   { 218, 219, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 56, 59, 0 },
   { 82, 85, 0 },
   { 108, 111, 0 },
   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 125, 114, 0 },
   { 129, 132, 0 },
   { 147, 88, 0 },
   { 151, 154, 0 },
   { 168, 62, 0 },
   { 172, 175, 0 },
   { 189, 35, 0 },
   { 193, 196, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 34, 35, 0 },
   { 56, 59, 0 },
   { 61, 62, 0 },
   { 82, 85, 0 },
   { 87, 88, 0 },
   { 108, 111, 0 },
   { 113, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 34, 35, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 61, 62, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 87, 88, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 113, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 40, 41, 0 },
   { 56, 59, 0 },
   { 66, 67, 0 },
   { 82, 85, 0 },
   { 92, 93, 0 },
   { 108, 111, 0 },
   { 118, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 40, 41, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 66, 67, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 92, 93, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 118, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 37, 35, 0 },
   { 56, 59, 0 },
   { 64, 62, 0 },
   { 82, 85, 0 },
   { 90, 88, 0 },
   { 108, 111, 0 },
   { 116, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 37, 35, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 64, 62, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 90, 88, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 116, 114, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 43, 41, 0 },
   { 56, 59, 0 },
   { 69, 67, 0 },
   { 82, 85, 0 },
   { 95, 93, 0 },
   { 108, 111, 0 },
   { 121, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 43, 41, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 69, 67, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 95, 93, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 121, 119, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 26, 30, 0 },
   { 46, 49, 0 },
   { 56, 59, 0 },
   { 72, 75, 0 },
   { 82, 85, 0 },
   { 98, 101, 0 },
   { 108, 111, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 12, 0 },
   { 16, 19, 0 },
   { 26, 30, 0 },
   { 46, 49, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 72, 75, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 98, 101, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 30, 0 },
   { 56, 59, 0 },
   { 82, 85, 0 },
   { 108, 111, 0 },
   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 19, 0 },
   { 26, 30, 0 },
   { 51, 54, 0 },
   { 56, 59, 0 },
   { 77, 80, 0 },
   { 82, 85, 0 },
   { 103, 106, 0 },
   { 108, 111, 0 },
   { 138, 143, 0 },
   { 160, 165, 0 },
   { 181, 186, 0 },
   { 202, 207, 0 },
   { 208, 210, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

};

static const struct per_op_table agx_nir_fuse_lea_pass_op_table[nir_num_search_ops] = {
   [nir_op_iadd] = {
      .filter = (const uint16_t []) {
         0,
         1,
         2,
         3,
         4,
         5,
         6,
         0,
         5,
         7,
         8,
         9,
         10,
         11,
         12,
         0,
         0,
         0,
         5,
         0,
         0,
         0,
         0,
         5,
         0,
         0,
         5,
         5,
         5,
         5,
         5,
         5,
         5,
         6,
         6,
         6,
         7,
         6,
         6,
         6,
         6,
         5,
         0,
         0,
         0,
         0,
         5,
         0,
         0,
         0,
         0,
         5,
         0,
         0,
         0,
         0,
         5,
         5,
         5,
         5,
         0,
         0,
         0,
         0,
         0,
         0,
         13,
         14,
         15,
         16,
         17,
         0,
         0,
         5,
         0,
         0,
         5,
         5,
         5,
         6,
         6,
         7,
         0,
         0,
         5,
         0,
         0,
         5,
         0,
         0,
         5,
         5,
         5,
         5,
         0,
         0,
         5,
         0,
         0,
         5,
         0,
         0,
         5,
         0,
         0,
         5,
         0,
         5,
         5,
         0,
         0,
         0,
         0,
         5,
         5,
         6,
         6,
         0,
         0,
         0,
         0,
         0,
         0,
         5,
         5,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         5,
         5,
      },
      
      .num_filtered_states = 18,
      .table = (const uint16_t []) {
      
         0,
         0,
         0,
         5,
         6,
         15,
         16,
         17,
         18,
         19,
         20,
         21,
         22,
         71,
         72,
         73,
         109,
         110,
         0,
         0,
         7,
         8,
         6,
         15,
         16,
         17,
         23,
         24,
         25,
         21,
         22,
         74,
         75,
         76,
         111,
         112,
         0,
         7,
         0,
         5,
         6,
         15,
         16,
         17,
         18,
         19,
         20,
         21,
         22,
         71,
         72,
         73,
         109,
         110,
         5,
         8,
         5,
         5,
         9,
         26,
         27,
         28,
         18,
         29,
         30,
         31,
         32,
         77,
         78,
         73,
         113,
         114,
         6,
         6,
         6,
         9,
         6,
         33,
         34,
         35,
         36,
         37,
         38,
         39,
         40,
         79,
         80,
         81,
         115,
         116,
         15,
         15,
         15,
         26,
         33,
         15,
         17,
         17,
         41,
         42,
         43,
         44,
         45,
         82,
         83,
         84,
         117,
         118,
         16,
         16,
         16,
         27,
         34,
         17,
         16,
         17,
         46,
         47,
         48,
         49,
         50,
         85,
         86,
         87,
         119,
         120,
         17,
         17,
         17,
         28,
         35,
         17,
         17,
         17,
         51,
         52,
         53,
         54,
         55,
         88,
         89,
         90,
         121,
         122,
         18,
         23,
         18,
         18,
         36,
         41,
         46,
         51,
         18,
         56,
         57,
         58,
         59,
         91,
         92,
         93,
         123,
         124,
         19,
         24,
         19,
         29,
         37,
         42,
         47,
         52,
         56,
         19,
         60,
         61,
         62,
         94,
         95,
         96,
         125,
         126,
         20,
         25,
         20,
         30,
         38,
         43,
         48,
         53,
         57,
         60,
         20,
         63,
         64,
         97,
         98,
         99,
         127,
         128,
         21,
         21,
         21,
         31,
         39,
         44,
         49,
         54,
         58,
         61,
         63,
         21,
         65,
         100,
         101,
         102,
         129,
         130,
         22,
         22,
         22,
         32,
         40,
         45,
         50,
         55,
         59,
         62,
         64,
         65,
         22,
         103,
         104,
         105,
         131,
         132,
         71,
         74,
         71,
         77,
         79,
         82,
         85,
         88,
         91,
         94,
         97,
         100,
         103,
         71,
         106,
         107,
         110,
         110,
         72,
         75,
         72,
         78,
         80,
         83,
         86,
         89,
         92,
         95,
         98,
         101,
         104,
         106,
         72,
         108,
         133,
         134,
         73,
         76,
         73,
         73,
         81,
         84,
         87,
         90,
         93,
         96,
         99,
         102,
         105,
         107,
         108,
         73,
         135,
         136,
         109,
         111,
         109,
         113,
         115,
         117,
         119,
         121,
         123,
         125,
         127,
         129,
         131,
         110,
         133,
         135,
         109,
         110,
         110,
         112,
         110,
         114,
         116,
         118,
         120,
         122,
         124,
         126,
         128,
         130,
         132,
         110,
         134,
         136,
         110,
         110,
      },
   },
   [nir_op_amul] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         2,
         3,
         0,
         4,
         0,
         5,
         4,
         2,
         0,
         0,
         0,
         0,
         6,
         0,
         6,
         0,
         0,
         0,
         0,
         0,
         5,
         0,
         0,
         6,
         0,
         6,
         0,
         0,
         0,
         0,
         7,
         4,
         7,
         4,
         4,
         4,
         4,
         4,
         6,
         6,
         6,
         6,
         6,
         0,
         0,
         0,
         0,
         0,
         6,
         6,
         6,
         6,
         6,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         5,
         0,
         0,
         4,
         4,
         4,
         6,
         6,
         6,
         0,
         0,
         0,
         6,
         6,
         6,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         4,
         4,
         6,
         6,
         0,
         0,
         6,
         6,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 8,
      .table = (const uint16_t []) {
      
         0,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         2,
         2,
         11,
         12,
         66,
         67,
         69,
         70,
         0,
         11,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         12,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         66,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         67,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         69,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         70,
         0,
         0,
         0,
         0,
         0,
         0,
      },
   },
   [nir_search_op_u2u] = {
      .filter = (const uint16_t []) {
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         2,
         0,
         0,
         0,
         1,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         2,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         1,
         1,
         0,
         1,
         1,
         0,
         0,
         0,
         2,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         2,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 3,
      .table = (const uint16_t []) {
      
         3,
         10,
         68,
      },
   },
   [nir_search_op_i2i] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         4,
      },
   },
   [nir_op_ishl] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         2,
         3,
         0,
         0,
         0,
         0,
         0,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 4,
      .table = (const uint16_t []) {
      
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         13,
         0,
         0,
         0,
         14,
         0,
         0,
      },
   },
};

/* Mapping from state index to offset in transforms (0 being no transforms) */
static const uint16_t agx_nir_fuse_lea_transform_offsets[] = {
   0,
   0,
   0,
   0,
   0,
   1,
   3,
   0,
   5,
   7,
   0,
   0,
   0,
   0,
   0,
   10,
   12,
   14,
   17,
   27,
   32,
   37,
   42,
   47,
   57,
   62,
   67,
   70,
   73,
   77,
   83,
   89,
   95,
   101,
   104,
   107,
   111,
   122,
   128,
   134,
   140,
   146,
   157,
   163,
   169,
   175,
   181,
   192,
   198,
   204,
   210,
   216,
   228,
   235,
   242,
   249,
   256,
   270,
   284,
   298,
   312,
   321,
   330,
   339,
   348,
   357,
   0,
   0,
   0,
   0,
   0,
   366,
   371,
   376,
   382,
   387,
   392,
   398,
   404,
   410,
   416,
   422,
   429,
   435,
   441,
   448,
   454,
   460,
   467,
   474,
   481,
   489,
   503,
   517,
   531,
   540,
   549,
   559,
   568,
   577,
   587,
   596,
   605,
   615,
   624,
   633,
   643,
   652,
   662,
   672,
   677,
   686,
   691,
   700,
   706,
   716,
   722,
   732,
   738,
   748,
   754,
   764,
   771,
   782,
   796,
   814,
   823,
   836,
   845,
   858,
   867,
   880,
   889,
   902,
   911,
   924,
   934,
};

static const nir_algebraic_table agx_nir_fuse_lea_table = {
   .transforms = agx_nir_fuse_lea_transforms,
   .transform_offsets = agx_nir_fuse_lea_transform_offsets,
   .pass_op_table = agx_nir_fuse_lea_pass_op_table,
   .values = agx_nir_fuse_lea_values,
   .expression_cond = NULL,
   .variable_cond = agx_nir_fuse_lea_variable_cond,
};

bool
agx_nir_fuse_lea(
   nir_shader *shader
) {
   bool progress = false;
   bool condition_flags[1];
   const nir_shader_compiler_options *options = shader->options;
   const shader_info *info = &shader->info;
   (void) options;
   (void) info;

   STATIC_ASSERT(220 == ARRAY_SIZE(agx_nir_fuse_lea_values));
   condition_flags[0] = true;

   nir_foreach_function_impl(impl, shader) {
     progress |= nir_algebraic_impl(impl, condition_flags, &agx_nir_fuse_lea_table);
   }

   return progress;
}


#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 3
 * transforms:
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('ulea_agx', 'a', 'b', 'c') => ('iadd', 'a', ('ishl', ('u2u64', 'b'), 'c'))
 *    ('ilea_agx', 'a', 'b', 'c') => ('iadd', 'a', ('ishl', ('i2i64', 'b'), 'c'))
 */


static const nir_search_value_union agx_nir_lower_lea_values[] = {
   /* ('amul', 'a', 'b') => ('imul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_amul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace47_0 -> 0 in the cache */
   /* replace47_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ulea_agx', 'a', 'b', 'c') => ('iadd', 'a', ('ishl', ('u2u64', 'b'), 'c')) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ulea_agx,
      -1, 0,
      { 4, 5, 6 },
      -1,
   } },

   /* replace48_0 -> 4 in the cache */
   /* replace48_1_0_0 -> 5 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u64,
      -1, 0,
      { 5 },
      -1,
   } },
   /* replace48_1_1 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 8, 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 4, 9 },
      -1,
   } },

   /* ('ilea_agx', 'a', 'b', 'c') => ('iadd', 'a', ('ishl', ('i2i64', 'b'), 'c')) */
   /* search49_0 -> 4 in the cache */
   /* search49_1 -> 5 in the cache */
   /* search49_2 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilea_agx,
      -1, 0,
      { 4, 5, 6 },
      -1,
   } },

   /* replace49_0 -> 4 in the cache */
   /* replace49_1_0_0 -> 5 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_i2i64,
      -1, 0,
      { 5 },
      -1,
   } },
   /* replace49_1_1 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 12, 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 4, 13 },
      -1,
   } },

};



static const struct transform agx_nir_lower_lea_transforms[] = {
   { ~0, ~0, ~0 }, /* Sentinel */

   { 2, 3, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 10, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 11, 14, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

};

static const struct per_op_table agx_nir_lower_lea_pass_op_table[nir_num_search_ops] = {
   [nir_op_amul] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         2,
      },
   },
   [nir_op_ulea_agx] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         3,
      },
   },
   [nir_op_ilea_agx] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         4,
      },
   },
};

/* Mapping from state index to offset in transforms (0 being no transforms) */
static const uint16_t agx_nir_lower_lea_transform_offsets[] = {
   0,
   0,
   1,
   3,
   5,
};

static const nir_algebraic_table agx_nir_lower_lea_table = {
   .transforms = agx_nir_lower_lea_transforms,
   .transform_offsets = agx_nir_lower_lea_transform_offsets,
   .pass_op_table = agx_nir_lower_lea_pass_op_table,
   .values = agx_nir_lower_lea_values,
   .expression_cond = NULL,
   .variable_cond = NULL,
};

bool
agx_nir_lower_lea(
   nir_shader *shader
) {
   bool progress = false;
   bool condition_flags[1];
   const nir_shader_compiler_options *options = shader->options;
   const shader_info *info = &shader->info;
   (void) options;
   (void) info;

   STATIC_ASSERT(15 == ARRAY_SIZE(agx_nir_lower_lea_values));
   condition_flags[0] = true;

   nir_foreach_function_impl(impl, shader) {
     progress |= nir_algebraic_impl(impl, condition_flags, &agx_nir_lower_lea_table);
   }

   return progress;
}


#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 46
 * transforms:
 *    ('ishl', 'a@8', 'b') => ('ishl', 'a', ('iand', 'b', 7))
 *    ('ishr', 'a@8', 'b') => ('ishr', 'a', ('iand', 'b', 7))
 *    ('ushr', 'a@8', 'b') => ('ushr', 'a', ('iand', 'b', 7))
 *    ('ishl', 'a@16', 'b') => ('ishl', 'a', ('iand', 'b', 15))
 *    ('ishr', 'a@16', 'b') => ('ishr', 'a', ('iand', 'b', 15))
 *    ('ushr', 'a@16', 'b') => ('ushr', 'a', ('iand', 'b', 15))
 *    ('ishl', 'a@32', 'b') => ('ishl', 'a', ('iand', 'b', 31))
 *    ('ishr', 'a@32', 'b') => ('ishr', 'a', ('iand', 'b', 31))
 *    ('ushr', 'a@32', 'b') => ('ushr', 'a', ('iand', 'b', 31))
 *    ('ishl', 'a@64', 'b') => ('ishl', 'a', ('iand', 'b', 63))
 *    ('ishr', 'a@64', 'b') => ('ishr', 'a', ('iand', 'b', 63))
 *    ('ushr', 'a@64', 'b') => ('ushr', 'a', ('iand', 'b', 63))
 *    ('pack_half_2x16_split', 'a', 'b') => ('pack_32_2x16_split', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('pack_32_4x8_split', 'a', 'b', 'c', 'd') => ('pack_32_2x16_split', ('ior', ('u2u16', 'a'), ('ishl', ('u2u16', 'b'), 8)), ('ior', ('u2u16', 'c'), ('ishl', ('u2u16', 'd'), 8)))
 *    ('unpack_half_2x16_split_x', 'a') => ('f2f32', ('unpack_32_2x16_split_x', 'a'))
 *    ('unpack_half_2x16_split_y', 'a') => ('f2f32', ('unpack_32_2x16_split_y', 'a'))
 *    ('extract_u16', 'a@32', 0) => ('u2u32', ('unpack_32_2x16_split_x', 'a'))
 *    ('extract_u16', 'a@32', 1) => ('u2u32', ('unpack_32_2x16_split_y', 'a'))
 *    ('extract_i16', 'a@32', 0) => ('i2i32', ('unpack_32_2x16_split_x', 'a'))
 *    ('extract_i16', 'a@32', 1) => ('i2i32', ('unpack_32_2x16_split_y', 'a'))
 *    ('u2f32', ('u2u32', 'a')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a')) => ('i2f32', 'a')
 *    ('f2u8', 'a') => ('u2u8', ('f2u16', 'a'))
 *    ('f2i8', 'a') => ('i2i8', ('f2i16', 'a'))
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('f2f16_rtz', 'a@32') => ('bcsel', ('flt', ('fabs', 'a'), ('fabs', ('f2f32', ('f2f16_rtne', 'a')))), ('isub', ('f2f16_rtne', 'a'), 1), ('f2f16_rtne', 'a'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits(is_not_const)') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits(is_not_const)') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ubitfield_extract', 'value', 'offset', 0) => 0
 *    ('ibitfield_extract', 'value', 'offset', 0) => 0
 *    ('ibitfield_extract', 'a', 'b', '#bits') => ('ishr', ('ishl', ('ubitfield_extract', 'a', 'b', 'bits'), ('isub', 32, 'bits')), ('isub', 32, 'bits'))
 *    ('b2f16', ('inot', 'a@1')) => ('bcsel', 'a', 0, 1.0)
 *    ('b2f16', 'a@1') => ('bcsel', 'a', 1.0, 0)
 *    ('b2f32', ('inot', 'a@1')) => ('bcsel', 'a', 0, 1.0)
 *    ('b2f32', 'a@1') => ('bcsel', 'a', 1.0, 0)
 *    ('b2i8', ('inot', 'a@1')) => ('bcsel', 'a', 0, 1)
 *    ('b2i8', 'a@1') => ('bcsel', 'a', 1, 0)
 *    ('b2i16', ('inot', 'a@1')) => ('bcsel', 'a', 0, 1)
 *    ('b2i16', 'a@1') => ('bcsel', 'a', 1, 0)
 *    ('b2i32', ('inot', 'a@1')) => ('bcsel', 'a', 0, 1)
 *    ('b2i32', 'a@1') => ('bcsel', 'a', 1, 0)
 *    ('b2b16', ('inot', 'a@1')) => ('bcsel', 'a', 0, -1)
 *    ('b2b16', 'a@1') => ('bcsel', 'a', -1, 0)
 *    ('b2b32', ('inot', 'a@1')) => ('bcsel', 'a', 0, -1)
 *    ('b2b32', 'a@1') => ('bcsel', 'a', -1, 0)
 */


static const nir_search_value_union agx_nir_lower_algebraic_late_values[] = {
   /* ('ishl', 'a@8', 'b') => ('ishl', 'a', ('iand', 'b', 7)) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace50_0 -> 0 in the cache */
   /* replace50_1_0 -> 1 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7ull /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 0, 4 },
      -1,
   } },

   /* ('ishr', 'a@8', 'b') => ('ishr', 'a', ('iand', 'b', 7)) */
   /* search51_0 -> 0 in the cache */
   /* search51_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace51_0 -> 0 in the cache */
   /* replace51_1_0 -> 1 in the cache */
   /* replace51_1_1 -> 3 in the cache */
   /* replace51_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 1,
      { 0, 4 },
      -1,
   } },

   /* ('ushr', 'a@8', 'b') => ('ushr', 'a', ('iand', 'b', 7)) */
   /* search52_0 -> 0 in the cache */
   /* search52_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace52_0 -> 0 in the cache */
   /* replace52_1_0 -> 1 in the cache */
   /* replace52_1_1 -> 3 in the cache */
   /* replace52_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 0, 4 },
      -1,
   } },

   /* ('ishl', 'a@16', 'b') => ('ishl', 'a', ('iand', 'b', 15)) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search53_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 10, 1 },
      -1,
   } },

   /* replace53_0 -> 10 in the cache */
   /* replace53_1_0 -> 1 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfull /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1, 12 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 10, 13 },
      -1,
   } },

   /* ('ishr', 'a@16', 'b') => ('ishr', 'a', ('iand', 'b', 15)) */
   /* search54_0 -> 10 in the cache */
   /* search54_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 10, 1 },
      -1,
   } },

   /* replace54_0 -> 10 in the cache */
   /* replace54_1_0 -> 1 in the cache */
   /* replace54_1_1 -> 12 in the cache */
   /* replace54_1 -> 13 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 1,
      { 10, 13 },
      -1,
   } },

   /* ('ushr', 'a@16', 'b') => ('ushr', 'a', ('iand', 'b', 15)) */
   /* search55_0 -> 10 in the cache */
   /* search55_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 10, 1 },
      -1,
   } },

   /* replace55_0 -> 10 in the cache */
   /* replace55_1_0 -> 1 in the cache */
   /* replace55_1_1 -> 12 in the cache */
   /* replace55_1 -> 13 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 10, 13 },
      -1,
   } },

   /* ('ishl', 'a@32', 'b') => ('ishl', 'a', ('iand', 'b', 31)) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search56_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 19, 1 },
      -1,
   } },

   /* replace56_0 -> 19 in the cache */
   /* replace56_1_0 -> 1 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1full /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1, 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 19, 22 },
      -1,
   } },

   /* ('ishr', 'a@32', 'b') => ('ishr', 'a', ('iand', 'b', 31)) */
   /* search57_0 -> 19 in the cache */
   /* search57_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 19, 1 },
      -1,
   } },

   /* replace57_0 -> 19 in the cache */
   /* replace57_1_0 -> 1 in the cache */
   /* replace57_1_1 -> 21 in the cache */
   /* replace57_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 1,
      { 19, 22 },
      -1,
   } },

   /* ('ushr', 'a@32', 'b') => ('ushr', 'a', ('iand', 'b', 31)) */
   /* search58_0 -> 19 in the cache */
   /* search58_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 19, 1 },
      -1,
   } },

   /* replace58_0 -> 19 in the cache */
   /* replace58_1_0 -> 1 in the cache */
   /* replace58_1_1 -> 21 in the cache */
   /* replace58_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 19, 22 },
      -1,
   } },

   /* ('ishl', 'a@64', 'b') => ('ishl', 'a', ('iand', 'b', 63)) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search59_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 28, 1 },
      -1,
   } },

   /* replace59_0 -> 28 in the cache */
   /* replace59_1_0 -> 1 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3full /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1, 30 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 28, 31 },
      -1,
   } },

   /* ('ishr', 'a@64', 'b') => ('ishr', 'a', ('iand', 'b', 63)) */
   /* search60_0 -> 28 in the cache */
   /* search60_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 28, 1 },
      -1,
   } },

   /* replace60_0 -> 28 in the cache */
   /* replace60_1_0 -> 1 in the cache */
   /* replace60_1_1 -> 30 in the cache */
   /* replace60_1 -> 31 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 1,
      { 28, 31 },
      -1,
   } },

   /* ('ushr', 'a@64', 'b') => ('ushr', 'a', ('iand', 'b', 63)) */
   /* search61_0 -> 28 in the cache */
   /* search61_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 28, 1 },
      -1,
   } },

   /* replace61_0 -> 28 in the cache */
   /* replace61_1_0 -> 1 in the cache */
   /* replace61_1_1 -> 30 in the cache */
   /* replace61_1 -> 31 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 28, 31 },
      -1,
   } },

   /* ('pack_half_2x16_split', 'a', 'b') => ('pack_32_2x16_split', ('f2f16', 'a'), ('f2f16', 'b')) */
   /* search62_0 -> 19 in the cache */
   /* search62_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_pack_half_2x16_split,
      -1, 0,
      { 19, 1 },
      -1,
   } },

   /* replace62_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2f16,
      -1, 0,
      { 19 },
      -1,
   } },
   /* replace62_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2f16,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_pack_32_2x16_split,
      -1, 0,
      { 38, 39 },
      -1,
   } },

   /* ('pack_32_4x8_split', 'a', 'b', 'c', 'd') => ('pack_32_2x16_split', ('ior', ('u2u16', 'a'), ('ishl', ('u2u16', 'b'), 8)), ('ior', ('u2u16', 'c'), ('ishl', ('u2u16', 'd'), 8))) */
   /* search63_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, 8 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 8 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 8 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_pack_32_4x8_split,
      -1, 0,
      { 0, 41, 42, 43 },
      -1,
   } },

   /* replace63_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u16,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace63_0_1_0_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u16,
      -1, 0,
      { 41 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8ull /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 46, 47 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 45, 48 },
      -1,
   } },
   /* replace63_1_0_0 -> 42 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u16,
      -1, 0,
      { 42 },
      -1,
   } },
   /* replace63_1_1_0_0 -> 43 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u16,
      -1, 0,
      { 43 },
      -1,
   } },
   /* replace63_1_1_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 51, 47 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 50, 52 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_pack_32_2x16_split,
      -1, 2,
      { 49, 53 },
      -1,
   } },

   /* ('unpack_half_2x16_split_x', 'a') => ('f2f32', ('unpack_32_2x16_split_x', 'a')) */
   /* search64_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_unpack_half_2x16_split_x,
      -1, 0,
      { 19 },
      -1,
   } },

   /* replace64_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_unpack_32_2x16_split_x,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2f32,
      -1, 0,
      { 56 },
      -1,
   } },

   /* ('unpack_half_2x16_split_y', 'a') => ('f2f32', ('unpack_32_2x16_split_y', 'a')) */
   /* search65_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_unpack_half_2x16_split_y,
      -1, 0,
      { 19 },
      -1,
   } },

   /* replace65_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_unpack_32_2x16_split_y,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2f32,
      -1, 0,
      { 59 },
      -1,
   } },

   /* ('extract_u16', 'a@32', 0) => ('u2u32', ('unpack_32_2x16_split_x', 'a')) */
   /* search66_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extract_u16,
      -1, 0,
      { 19, 61 },
      -1,
   } },

   /* replace66_0_0 -> 19 in the cache */
   /* replace66_0 -> 56 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u32,
      -1, 0,
      { 56 },
      -1,
   } },

   /* ('extract_u16', 'a@32', 1) => ('u2u32', ('unpack_32_2x16_split_y', 'a')) */
   /* search67_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extract_u16,
      -1, 0,
      { 19, 64 },
      -1,
   } },

   /* replace67_0_0 -> 19 in the cache */
   /* replace67_0 -> 59 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u32,
      -1, 0,
      { 59 },
      -1,
   } },

   /* ('extract_i16', 'a@32', 0) => ('i2i32', ('unpack_32_2x16_split_x', 'a')) */
   /* search68_0 -> 19 in the cache */
   /* search68_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extract_i16,
      -1, 0,
      { 19, 61 },
      -1,
   } },

   /* replace68_0_0 -> 19 in the cache */
   /* replace68_0 -> 56 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_i2i32,
      -1, 0,
      { 56 },
      -1,
   } },

   /* ('extract_i16', 'a@32', 1) => ('i2i32', ('unpack_32_2x16_split_y', 'a')) */
   /* search69_0 -> 19 in the cache */
   /* search69_1 -> 64 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extract_i16,
      -1, 0,
      { 19, 64 },
      -1,
   } },

   /* replace69_0_0 -> 19 in the cache */
   /* replace69_0 -> 59 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_i2i32,
      -1, 0,
      { 59 },
      -1,
   } },

   /* ('u2f32', ('u2u32', 'a')) => ('u2f32', 'a') */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u32,
      -1, 0,
      { 71 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2f32,
      -1, 0,
      { 72 },
      -1,
   } },

   /* replace70_0 -> 71 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2f32,
      -1, 0,
      { 71 },
      -1,
   } },

   /* ('i2f32', ('i2i32', 'a')) => ('i2f32', 'a') */
   /* search71_0_0 -> 71 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_i2i32,
      -1, 0,
      { 71 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_i2f32,
      -1, 0,
      { 75 },
      -1,
   } },

   /* replace71_0 -> 71 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_i2f32,
      -1, 0,
      { 71 },
      -1,
   } },

   /* ('f2u8', 'a') => ('u2u8', ('f2u16', 'a')) */
   /* search72_0 -> 71 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2u8,
      -1, 0,
      { 71 },
      -1,
   } },

   /* replace72_0_0 -> 71 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2u16,
      -1, 0,
      { 71 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_u2u8,
      -1, 0,
      { 79 },
      -1,
   } },

   /* ('f2i8', 'a') => ('i2i8', ('f2i16', 'a')) */
   /* search73_0 -> 71 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2i8,
      -1, 0,
      { 71 },
      -1,
   } },

   /* replace73_0_0 -> 71 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2i16,
      -1, 0,
      { 71 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_i2i8,
      -1, 0,
      { 82 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a */
   /* search74_0_0 -> 19 in the cache */
   /* search74_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_pack_64_2x32_split,
      -1, 0,
      { 19, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_unpack_64_2x32_split_x,
      -1, 0,
      { 84 },
      -1,
   } },

   /* replace74 -> 19 in the cache */

   /* ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b */
   /* search75_0_0 -> 19 in the cache */
   /* search75_0_1 -> 1 in the cache */
   /* search75_0 -> 84 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_unpack_64_2x32_split_y,
      -1, 0,
      { 84 },
      -1,
   } },

   /* replace75 -> 1 in the cache */

   /* ('f2f16_rtz', 'a@32') => ('bcsel', ('flt', ('fabs', 'a'), ('fabs', ('f2f32', ('f2f16_rtne', 'a')))), ('isub', ('f2f16_rtne', 'a'), 1), ('f2f16_rtne', 'a')) */
   /* search76_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2f16_rtz,
      -1, 0,
      { 19 },
      -1,
   } },

   /* replace76_0_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 19 },
      -1,
   } },
   /* replace76_0_1_0_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2f16_rtne,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_f2f32,
      -1, 0,
      { 89 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 90 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 88, 91 },
      -1,
   } },
   /* replace76_1_0_0 -> 19 in the cache */
   /* replace76_1_0 -> 89 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 89, 93 },
      -1,
   } },
   /* replace76_2_0 -> 19 in the cache */
   /* replace76_2 -> 89 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 92, 94, 89 },
      -1,
   } },

   /* ('ibitfield_extract', 'value', 'offset', 'bits(is_not_const)') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* value */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* offset */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* bits */
      false,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ibitfield_extract,
      -1, 0,
      { 96, 97, 98 },
      -1,
   } },

   /* replace77_0_0 -> 61 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* bits */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 61, 100 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   /* replace77_2_0_0 -> 96 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20ull /* 32 */ },
   } },
   /* replace77_2_0_1_0_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 103, 100 },
      -1,
   } },
   /* replace77_2_0_1_1 -> 97 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 104, 97 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 96, 105 },
      -1,
   } },
   /* replace77_2_1_0 -> 103 in the cache */
   /* replace77_2_1_1 -> 100 in the cache */
   /* replace77_2_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 106, 104 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 101, 102, 107 },
      -1,
   } },

   /* ('ubitfield_extract', 'value', 'offset', 'bits(is_not_const)') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1))) */
   /* search78_0 -> 96 in the cache */
   /* search78_1 -> 97 in the cache */
   /* search78_2 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 96, 97, 98 },
      -1,
   } },

   /* replace78_0_0 -> 96 in the cache */
   /* replace78_0_1 -> 97 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 96, 97 },
      -1,
   } },
   /* replace78_1_0_0 -> 100 in the cache */
   /* replace78_1_0_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      1, 1,
      { 100, 103 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xffffffffull /* 4294967295 */ },
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   /* replace78_1_2_0_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 113, 100 },
      -1,
   } },
   /* replace78_1_2_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 114, 113 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 111, 112, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 2,
      { 110, 116 },
      -1,
   } },

   /* ('ubitfield_extract', 'value', 'offset', 0) => 0 */
   /* search79_0 -> 96 in the cache */
   /* search79_1 -> 97 in the cache */
   /* search79_2 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 96, 97, 61 },
      -1,
   } },

   /* replace79 -> 102 in the cache */

   /* ('ibitfield_extract', 'value', 'offset', 0) => 0 */
   /* search80_0 -> 96 in the cache */
   /* search80_1 -> 97 in the cache */
   /* search80_2 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ibitfield_extract,
      -1, 0,
      { 96, 97, 61 },
      -1,
   } },

   /* replace80 -> 102 in the cache */

   /* ('ibitfield_extract', 'a', 'b', '#bits') => ('ishr', ('ishl', ('ubitfield_extract', 'a', 'b', 'bits'), ('isub', 32, 'bits')), ('isub', 32, 'bits')) */
   /* search81_0 -> 71 in the cache */
   /* search81_1 -> 1 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* bits */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ibitfield_extract,
      -1, 0,
      { 71, 1, 120 },
      -1,
   } },

   /* replace81_0_0_0 -> 71 in the cache */
   /* replace81_0_0_1 -> 1 in the cache */
   /* replace81_0_0_2 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 71, 1, 100 },
      -1,
   } },
   /* replace81_0_1_0 -> 103 in the cache */
   /* replace81_0_1_1 -> 100 in the cache */
   /* replace81_0_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 122, 104 },
      -1,
   } },
   /* replace81_1_0 -> 103 in the cache */
   /* replace81_1_1 -> 100 in the cache */
   /* replace81_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 123, 104 },
      -1,
   } },

   /* ('b2f16', ('inot', 'a@1')) => ('bcsel', 'a', 0, 1.0) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 125 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2f16,
      -1, 0,
      { 126 },
      -1,
   } },

   /* replace82_0 -> 125 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 128, 129 },
      -1,
   } },

   /* ('b2f16', 'a@1') => ('bcsel', 'a', 1.0, 0) */
   /* search83_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2f16,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace83_0 -> 125 in the cache */
   /* replace83_1 -> 129 in the cache */
   /* replace83_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 129, 128 },
      -1,
   } },

   /* ('b2f32', ('inot', 'a@1')) => ('bcsel', 'a', 0, 1.0) */
   /* search84_0_0 -> 125 in the cache */
   /* search84_0 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2f32,
      -1, 0,
      { 126 },
      -1,
   } },

   /* replace84_0 -> 125 in the cache */
   /* replace84_1 -> 61 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 61, 134 },
      -1,
   } },

   /* ('b2f32', 'a@1') => ('bcsel', 'a', 1.0, 0) */
   /* search85_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2f32,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace85_0 -> 125 in the cache */
   /* replace85_1 -> 134 in the cache */
   /* replace85_2 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 134, 61 },
      -1,
   } },

   /* ('b2i8', ('inot', 'a@1')) => ('bcsel', 'a', 0, 1) */
   /* search86_0_0 -> 125 in the cache */
   /* search86_0 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i8,
      -1, 0,
      { 126 },
      -1,
   } },

   /* replace86_0 -> 125 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 139, 140 },
      -1,
   } },

   /* ('b2i8', 'a@1') => ('bcsel', 'a', 1, 0) */
   /* search87_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i8,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace87_0 -> 125 in the cache */
   /* replace87_1 -> 140 in the cache */
   /* replace87_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 140, 139 },
      -1,
   } },

   /* ('b2i16', ('inot', 'a@1')) => ('bcsel', 'a', 0, 1) */
   /* search88_0_0 -> 125 in the cache */
   /* search88_0 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i16,
      -1, 0,
      { 126 },
      -1,
   } },

   /* replace88_0 -> 125 in the cache */
   /* replace88_1 -> 128 in the cache */
   /* replace88_2 -> 93 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 128, 93 },
      -1,
   } },

   /* ('b2i16', 'a@1') => ('bcsel', 'a', 1, 0) */
   /* search89_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i16,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace89_0 -> 125 in the cache */
   /* replace89_1 -> 93 in the cache */
   /* replace89_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 93, 128 },
      -1,
   } },

   /* ('b2i32', ('inot', 'a@1')) => ('bcsel', 'a', 0, 1) */
   /* search90_0_0 -> 125 in the cache */
   /* search90_0 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i32,
      -1, 0,
      { 126 },
      -1,
   } },

   /* replace90_0 -> 125 in the cache */
   /* replace90_1 -> 61 in the cache */
   /* replace90_2 -> 64 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 61, 64 },
      -1,
   } },

   /* ('b2i32', 'a@1') => ('bcsel', 'a', 1, 0) */
   /* search91_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i32,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace91_0 -> 125 in the cache */
   /* replace91_1 -> 64 in the cache */
   /* replace91_2 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 64, 61 },
      -1,
   } },

   /* ('b2b16', ('inot', 'a@1')) => ('bcsel', 'a', 0, -1) */
   /* search92_0_0 -> 125 in the cache */
   /* search92_0 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2b16,
      -1, 0,
      { 126 },
      -1,
   } },

   /* replace92_0 -> 125 in the cache */
   /* replace92_1 -> 128 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 128, 153 },
      -1,
   } },

   /* ('b2b16', 'a@1') => ('bcsel', 'a', -1, 0) */
   /* search93_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2b16,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace93_0 -> 125 in the cache */
   /* replace93_1 -> 153 in the cache */
   /* replace93_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 153, 128 },
      -1,
   } },

   /* ('b2b32', ('inot', 'a@1')) => ('bcsel', 'a', 0, -1) */
   /* search94_0_0 -> 125 in the cache */
   /* search94_0 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2b32,
      -1, 0,
      { 126 },
      -1,
   } },

   /* replace94_0 -> 125 in the cache */
   /* replace94_1 -> 61 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 61, 158 },
      -1,
   } },

   /* ('b2b32', 'a@1') => ('bcsel', 'a', -1, 0) */
   /* search95_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2b32,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace95_0 -> 125 in the cache */
   /* replace95_1 -> 158 in the cache */
   /* replace95_2 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 125, 158, 61 },
      -1,
   } },

};


static const nir_search_variable_cond agx_nir_lower_algebraic_late_variable_cond[] = {
   (is_not_const),
};

static const struct transform agx_nir_lower_algebraic_late_transforms[] = {
   { ~0, ~0, ~0 }, /* Sentinel */

   { 2, 5, 0 },
   { 11, 14, 0 },
   { 20, 23, 0 },
   { 29, 32, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 6, 7, 0 },
   { 15, 16, 0 },
   { 24, 25, 0 },
   { 33, 34, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 8, 9, 0 },
   { 17, 18, 0 },
   { 26, 27, 0 },
   { 35, 36, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 37, 40, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 44, 54, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 55, 57, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 58, 60, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 62, 63, 0 },
   { 65, 66, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 67, 68, 0 },
   { 69, 70, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 78, 80, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 81, 83, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 87, 95, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 99, 108, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 99, 108, 0 },
   { 119, 102, 0 },
   { 121, 124, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 109, 117, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 109, 117, 0 },
   { 118, 102, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 131, 132, 0 },
   { 136, 137, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 142, 143, 0 },
   { 146, 147, 0 },
   { 150, 151, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 155, 156, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 160, 161, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 73, 74, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 76, 77, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 85, 19, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 86, 1, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 127, 130, 0 },
   { 131, 132, 0 },
   { 133, 135, 0 },
   { 136, 137, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 138, 141, 0 },
   { 142, 143, 0 },
   { 144, 145, 0 },
   { 146, 147, 0 },
   { 148, 149, 0 },
   { 150, 151, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 152, 154, 0 },
   { 155, 156, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 157, 159, 0 },
   { 160, 161, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

};

static const struct per_op_table agx_nir_lower_algebraic_late_pass_op_table[nir_num_search_ops] = {
   [nir_op_ishl] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         2,
      },
   },
   [nir_op_ishr] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         3,
      },
   },
   [nir_op_ushr] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         4,
      },
   },
   [nir_op_pack_half_2x16_split] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         5,
      },
   },
   [nir_op_pack_32_4x8_split] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         6,
      },
   },
   [nir_op_unpack_half_2x16_split_x] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         7,
      },
   },
   [nir_op_unpack_half_2x16_split_y] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         8,
      },
   },
   [nir_op_extract_u16] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         0,
         9,
         0,
         9,
      },
   },
   [nir_op_extract_i16] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         0,
         10,
         0,
         10,
      },
   },
   [nir_search_op_u2f] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         0,
         26,
      },
   },
   [nir_search_op_u2u] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         11,
      },
   },
   [nir_search_op_i2f] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         0,
         27,
      },
   },
   [nir_search_op_i2i] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         12,
      },
   },
   [nir_search_op_f2u] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         13,
      },
   },
   [nir_search_op_f2i] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         14,
      },
   },
   [nir_op_unpack_64_2x32_split_x] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         0,
         28,
      },
   },
   [nir_op_pack_64_2x32_split] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         15,
      },
   },
   [nir_op_unpack_64_2x32_split_y] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         0,
         29,
      },
   },
   [nir_op_f2f16_rtz] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         16,
      },
   },
   [nir_op_ibitfield_extract] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         17,
         18,
         17,
         18,
         17,
         18,
         17,
         18,
      },
   },
   [nir_op_ubitfield_extract] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         19,
         20,
         19,
         20,
         19,
         20,
         19,
         20,
      },
   },
   [nir_search_op_b2f] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         21,
         30,
      },
   },
   [nir_op_inot] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         22,
      },
   },
   [nir_search_op_b2i] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         23,
         31,
      },
   },
   [nir_op_b2b16] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         24,
         32,
      },
   },
   [nir_op_b2b32] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         25,
         33,
      },
   },
};

/* Mapping from state index to offset in transforms (0 being no transforms) */
static const uint16_t agx_nir_lower_algebraic_late_transform_offsets[] = {
   0,
   0,
   1,
   6,
   11,
   16,
   18,
   20,
   22,
   24,
   27,
   0,
   0,
   30,
   32,
   0,
   34,
   36,
   38,
   42,
   44,
   47,
   0,
   50,
   54,
   56,
   58,
   60,
   62,
   64,
   66,
   71,
   78,
   81,
};

static const nir_algebraic_table agx_nir_lower_algebraic_late_table = {
   .transforms = agx_nir_lower_algebraic_late_transforms,
   .transform_offsets = agx_nir_lower_algebraic_late_transform_offsets,
   .pass_op_table = agx_nir_lower_algebraic_late_pass_op_table,
   .values = agx_nir_lower_algebraic_late_values,
   .expression_cond = NULL,
   .variable_cond = agx_nir_lower_algebraic_late_variable_cond,
};

bool
agx_nir_lower_algebraic_late(
   nir_shader *shader
) {
   bool progress = false;
   bool condition_flags[1];
   const nir_shader_compiler_options *options = shader->options;
   const shader_info *info = &shader->info;
   (void) options;
   (void) info;

   STATIC_ASSERT(162 == ARRAY_SIZE(agx_nir_lower_algebraic_late_values));
   condition_flags[0] = true;

   nir_foreach_function_impl(impl, shader) {
     progress |= nir_algebraic_impl(impl, condition_flags, &agx_nir_lower_algebraic_late_table);
   }

   return progress;
}


#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 10
 * transforms:
 *    ('bcsel', ('ior(is_used_once)', ('inot', 'a'), 'b'), 'c', 'd') => ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'c')
 *    ('bcsel', ('ior(is_used_once)', 'a', 'b'), 'c', 'd') => ('bcsel', 'a', 'c', ('bcsel', 'b', 'c', 'd'))
 *    ('bcsel', ('iand(is_used_once)', ('inot', 'a'), 'b'), 'c', 'd') => ('bcsel', 'a', 'd', ('bcsel', 'b', 'c', 'd'))
 *    ('bcsel', ('iand(is_used_once)', 'a', 'b'), 'c', 'd') => ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd')
 *    ('iand', ('inot', 'a@1'), 'b') => ('bcsel', 'a', False, 'b')
 *    ('iand', 'a@1', 'b') => ('bcsel', 'a', 'b', False)
 *    ('ior', ('inot', 'a@1'), 'b') => ('bcsel', 'a', 'b', True)
 *    ('ior', 'a@1', 'b') => ('bcsel', 'a', True, 'b')
 *    ('bcsel', 'a(has_multiple_uses)', ('fneg(is_used_once)', 'b@32'), 'b') => ('ixor', 'b', ('bcsel', 'a', 2147483648, 0))
 *    ('bcsel', 'a(has_multiple_uses)', 'b', ('fneg(is_used_once)', 'b@32')) => ('ixor', 'b', ('bcsel', 'a', 0, 2147483648))
 */


static const nir_search_value_union agx_nir_fuse_selects_values[] = {
   /* ('bcsel', ('ior(is_used_once)', ('inot', 'a'), 'b'), 'c', 'd') => ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'c') */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 0 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 1, 2 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 3, 4, 5 },
      -1,
   } },

   /* replace96_0 -> 0 in the cache */
   /* replace96_1_0 -> 2 in the cache */
   /* replace96_1_1 -> 4 in the cache */
   /* replace96_1_2 -> 5 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 2, 4, 5 },
      -1,
   } },
   /* replace96_2 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 0, 7, 4 },
      -1,
   } },

   /* ('bcsel', ('ior(is_used_once)', 'a', 'b'), 'c', 'd') => ('bcsel', 'a', 'c', ('bcsel', 'b', 'c', 'd')) */
   /* search97_0_0 -> 0 in the cache */
   /* search97_0_1 -> 2 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 0, 2 },
      0,
   } },
   /* search97_1 -> 4 in the cache */
   /* search97_2 -> 5 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 9, 4, 5 },
      -1,
   } },

   /* replace97_0 -> 0 in the cache */
   /* replace97_1 -> 4 in the cache */
   /* replace97_2_0 -> 2 in the cache */
   /* replace97_2_1 -> 4 in the cache */
   /* replace97_2_2 -> 5 in the cache */
   /* replace97_2 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 0, 4, 7 },
      -1,
   } },

   /* ('bcsel', ('iand(is_used_once)', ('inot', 'a'), 'b'), 'c', 'd') => ('bcsel', 'a', 'd', ('bcsel', 'b', 'c', 'd')) */
   /* search98_0_0_0 -> 0 in the cache */
   /* search98_0_0 -> 1 in the cache */
   /* search98_0_1 -> 2 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1, 2 },
      0,
   } },
   /* search98_1 -> 4 in the cache */
   /* search98_2 -> 5 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 12, 4, 5 },
      -1,
   } },

   /* replace98_0 -> 0 in the cache */
   /* replace98_1 -> 5 in the cache */
   /* replace98_2_0 -> 2 in the cache */
   /* replace98_2_1 -> 4 in the cache */
   /* replace98_2_2 -> 5 in the cache */
   /* replace98_2 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 0, 5, 7 },
      -1,
   } },

   /* ('bcsel', ('iand(is_used_once)', 'a', 'b'), 'c', 'd') => ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd') */
   /* search99_0_0 -> 0 in the cache */
   /* search99_0_1 -> 2 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 0, 2 },
      0,
   } },
   /* search99_1 -> 4 in the cache */
   /* search99_2 -> 5 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 15, 4, 5 },
      -1,
   } },

   /* replace99_0 -> 0 in the cache */
   /* replace99_1_0 -> 2 in the cache */
   /* replace99_1_1 -> 4 in the cache */
   /* replace99_1_2 -> 5 in the cache */
   /* replace99_1 -> 7 in the cache */
   /* replace99_2 -> 5 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 0, 7, 5 },
      -1,
   } },

   /* ('iand', ('inot', 'a@1'), 'b') => ('bcsel', 'a', False, 'b') */
   /* search100_0_0 -> 0 in the cache */
   /* search100_0 -> 1 in the cache */
   /* search100_1 -> 2 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1, 2 },
      -1,
   } },

   /* replace100_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },
   /* replace100_2 -> 2 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 0, 19, 2 },
      -1,
   } },

   /* ('iand', 'a@1', 'b') => ('bcsel', 'a', 'b', False) */
   /* search101_0 -> 0 in the cache */
   /* search101_1 -> 2 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 0, 2 },
      -1,
   } },

   /* replace101_0 -> 0 in the cache */
   /* replace101_1 -> 2 in the cache */
   /* replace101_2 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 0, 2, 19 },
      -1,
   } },

   /* ('ior', ('inot', 'a@1'), 'b') => ('bcsel', 'a', 'b', True) */
   /* search102_0_0 -> 0 in the cache */
   /* search102_0 -> 1 in the cache */
   /* search102_1 -> 2 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 1, 2 },
      -1,
   } },

   /* replace102_0 -> 0 in the cache */
   /* replace102_1 -> 2 in the cache */
   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 0, 2, 24 },
      -1,
   } },

   /* ('ior', 'a@1', 'b') => ('bcsel', 'a', True, 'b') */
   /* search103_0 -> 0 in the cache */
   /* search103_1 -> 2 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 0, 2 },
      -1,
   } },

   /* replace103_0 -> 0 in the cache */
   /* replace103_1 -> 24 in the cache */
   /* replace103_2 -> 2 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 0, 24, 2 },
      -1,
   } },

   /* ('bcsel', 'a(has_multiple_uses)', ('fneg(is_used_once)', 'b@32'), 'b') => ('ixor', 'b', ('bcsel', 'a', 2147483648, 0)) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 29 },
      0,
   } },
   /* search104_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 28, 30, 29 },
      -1,
   } },

   /* replace104_0 -> 29 in the cache */
   /* replace104_1_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000ull /* 2147483648 */ },
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 0, 32, 33 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ixor,
      0, 1,
      { 29, 34 },
      -1,
   } },

   /* ('bcsel', 'a(has_multiple_uses)', 'b', ('fneg(is_used_once)', 'b@32')) => ('ixor', 'b', ('bcsel', 'a', 0, 2147483648)) */
   /* search105_0 -> 28 in the cache */
   /* search105_1 -> 29 in the cache */
   /* search105_2_0 -> 29 in the cache */
   /* search105_2 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 28, 29, 30 },
      -1,
   } },

   /* replace105_0 -> 29 in the cache */
   /* replace105_1_0 -> 0 in the cache */
   /* replace105_1_1 -> 33 in the cache */
   /* replace105_1_2 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 0, 33, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ixor,
      0, 1,
      { 29, 37 },
      -1,
   } },

};

static const nir_search_expression_cond agx_nir_fuse_selects_expression_cond[] = {
   is_used_once,
};

static const nir_search_variable_cond agx_nir_fuse_selects_variable_cond[] = {
   (has_multiple_uses),
};

static const struct transform agx_nir_fuse_selects_transforms[] = {
   { ~0, ~0, ~0 }, /* Sentinel */

   { 26, 27, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 21, 22, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 36, 38, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 31, 35, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 31, 35, 0 },
   { 36, 38, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 10, 11, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 10, 11, 0 },
   { 36, 38, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 10, 11, 0 },
   { 31, 35, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 10, 11, 0 },
   { 31, 35, 0 },
   { 36, 38, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 17, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 17, 0 },
   { 36, 38, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 17, 0 },
   { 31, 35, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 16, 17, 0 },
   { 31, 35, 0 },
   { 36, 38, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 23, 25, 0 },
   { 26, 27, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 18, 20, 0 },
   { 21, 22, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 6, 8, 0 },
   { 10, 11, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 6, 8, 0 },
   { 10, 11, 0 },
   { 36, 38, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 6, 8, 0 },
   { 10, 11, 0 },
   { 31, 35, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 6, 8, 0 },
   { 10, 11, 0 },
   { 31, 35, 0 },
   { 36, 38, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 13, 14, 0 },
   { 16, 17, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 13, 14, 0 },
   { 16, 17, 0 },
   { 36, 38, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 13, 14, 0 },
   { 16, 17, 0 },
   { 31, 35, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 13, 14, 0 },
   { 16, 17, 0 },
   { 31, 35, 0 },
   { 36, 38, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

};

static const struct per_op_table agx_nir_fuse_selects_pass_op_table[nir_num_search_ops] = {
   [nir_op_bcsel] = {
      .filter = (const uint16_t []) {
         0,
         0,
         1,
         0,
         2,
         3,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         4,
         5,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 6,
      .table = (const uint16_t []) {
      
         0,
         0,
         0,
         6,
         0,
         0,
         0,
         0,
         0,
         6,
         0,
         0,
         0,
         0,
         0,
         6,
         0,
         0,
         7,
         7,
         7,
         8,
         7,
         7,
         0,
         0,
         0,
         6,
         0,
         0,
         0,
         0,
         0,
         6,
         0,
         0,
         9,
         9,
         9,
         10,
         9,
         9,
         9,
         9,
         9,
         10,
         9,
         9,
         9,
         9,
         9,
         10,
         9,
         9,
         11,
         11,
         11,
         12,
         11,
         11,
         9,
         9,
         9,
         10,
         9,
         9,
         9,
         9,
         9,
         10,
         9,
         9,
         13,
         13,
         13,
         14,
         13,
         13,
         13,
         13,
         13,
         14,
         13,
         13,
         13,
         13,
         13,
         14,
         13,
         13,
         15,
         15,
         15,
         16,
         15,
         15,
         13,
         13,
         13,
         14,
         13,
         13,
         13,
         13,
         13,
         14,
         13,
         13,
         0,
         0,
         0,
         6,
         0,
         0,
         0,
         0,
         0,
         6,
         0,
         0,
         0,
         0,
         0,
         6,
         0,
         0,
         7,
         7,
         7,
         8,
         7,
         7,
         0,
         0,
         0,
         6,
         0,
         0,
         0,
         0,
         0,
         6,
         0,
         0,
         19,
         19,
         19,
         20,
         19,
         19,
         19,
         19,
         19,
         20,
         19,
         19,
         19,
         19,
         19,
         20,
         19,
         19,
         21,
         21,
         21,
         22,
         21,
         21,
         19,
         19,
         19,
         20,
         19,
         19,
         19,
         19,
         19,
         20,
         19,
         19,
         23,
         23,
         23,
         24,
         23,
         23,
         23,
         23,
         23,
         24,
         23,
         23,
         23,
         23,
         23,
         24,
         23,
         23,
         25,
         25,
         25,
         26,
         25,
         25,
         23,
         23,
         23,
         24,
         23,
         23,
         23,
         23,
         23,
         24,
         23,
         23,
      },
   },
   [nir_op_ior] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         2,
         17,
         17,
         17,
      },
   },
   [nir_op_inot] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         3,
      },
   },
   [nir_op_iand] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         4,
         18,
         18,
         18,
      },
   },
   [nir_op_fneg] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         5,
      },
   },
};

/* Mapping from state index to offset in transforms (0 being no transforms) */
static const uint16_t agx_nir_fuse_selects_transform_offsets[] = {
   0,
   0,
   1,
   0,
   3,
   0,
   5,
   7,
   9,
   12,
   14,
   17,
   20,
   24,
   26,
   29,
   32,
   36,
   39,
   42,
   45,
   49,
   53,
   58,
   61,
   65,
   69,
};

static const nir_algebraic_table agx_nir_fuse_selects_table = {
   .transforms = agx_nir_fuse_selects_transforms,
   .transform_offsets = agx_nir_fuse_selects_transform_offsets,
   .pass_op_table = agx_nir_fuse_selects_pass_op_table,
   .values = agx_nir_fuse_selects_values,
   .expression_cond = agx_nir_fuse_selects_expression_cond,
   .variable_cond = agx_nir_fuse_selects_variable_cond,
};

bool
agx_nir_fuse_selects(
   nir_shader *shader
) {
   bool progress = false;
   bool condition_flags[1];
   const nir_shader_compiler_options *options = shader->options;
   const shader_info *info = &shader->info;
   (void) options;
   (void) info;

   STATIC_ASSERT(39 == ARRAY_SIZE(agx_nir_fuse_selects_values));
   condition_flags[0] = true;

   nir_foreach_function_impl(impl, shader) {
     progress |= nir_algebraic_impl(impl, condition_flags, &agx_nir_fuse_selects_table);
   }

   return progress;
}


#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 112
 * transforms:
 *    ('ior', ('ushr', 'a@32', 0), ('ishl', 'b@32', 32)) => ('extr_agx', 'a', 'b', 0, 0)
 *    ('ior', ('ushr', 'a@32', 1), ('ishl', 'b@32', 31)) => ('extr_agx', 'a', 'b', 1, 0)
 *    ('ior', ('ushr', 'a@32', 2), ('ishl', 'b@32', 30)) => ('extr_agx', 'a', 'b', 2, 0)
 *    ('ior', ('ushr', 'a@32', 3), ('ishl', 'b@32', 29)) => ('extr_agx', 'a', 'b', 3, 0)
 *    ('ior', ('ushr', 'a@32', 4), ('ishl', 'b@32', 28)) => ('extr_agx', 'a', 'b', 4, 0)
 *    ('ior', ('ushr', 'a@32', 5), ('ishl', 'b@32', 27)) => ('extr_agx', 'a', 'b', 5, 0)
 *    ('ior', ('ushr', 'a@32', 6), ('ishl', 'b@32', 26)) => ('extr_agx', 'a', 'b', 6, 0)
 *    ('ior', ('ushr', 'a@32', 7), ('ishl', 'b@32', 25)) => ('extr_agx', 'a', 'b', 7, 0)
 *    ('ior', ('ushr', 'a@32', 8), ('ishl', 'b@32', 24)) => ('extr_agx', 'a', 'b', 8, 0)
 *    ('ior', ('ushr', 'a@32', 9), ('ishl', 'b@32', 23)) => ('extr_agx', 'a', 'b', 9, 0)
 *    ('ior', ('ushr', 'a@32', 10), ('ishl', 'b@32', 22)) => ('extr_agx', 'a', 'b', 10, 0)
 *    ('ior', ('ushr', 'a@32', 11), ('ishl', 'b@32', 21)) => ('extr_agx', 'a', 'b', 11, 0)
 *    ('ior', ('ushr', 'a@32', 12), ('ishl', 'b@32', 20)) => ('extr_agx', 'a', 'b', 12, 0)
 *    ('ior', ('ushr', 'a@32', 13), ('ishl', 'b@32', 19)) => ('extr_agx', 'a', 'b', 13, 0)
 *    ('ior', ('ushr', 'a@32', 14), ('ishl', 'b@32', 18)) => ('extr_agx', 'a', 'b', 14, 0)
 *    ('ior', ('ushr', 'a@32', 15), ('ishl', 'b@32', 17)) => ('extr_agx', 'a', 'b', 15, 0)
 *    ('ior', ('ushr', 'a@32', 16), ('ishl', 'b@32', 16)) => ('extr_agx', 'a', 'b', 16, 0)
 *    ('ior', ('ushr', 'a@32', 17), ('ishl', 'b@32', 15)) => ('extr_agx', 'a', 'b', 17, 0)
 *    ('ior', ('ushr', 'a@32', 18), ('ishl', 'b@32', 14)) => ('extr_agx', 'a', 'b', 18, 0)
 *    ('ior', ('ushr', 'a@32', 19), ('ishl', 'b@32', 13)) => ('extr_agx', 'a', 'b', 19, 0)
 *    ('ior', ('ushr', 'a@32', 20), ('ishl', 'b@32', 12)) => ('extr_agx', 'a', 'b', 20, 0)
 *    ('ior', ('ushr', 'a@32', 21), ('ishl', 'b@32', 11)) => ('extr_agx', 'a', 'b', 21, 0)
 *    ('ior', ('ushr', 'a@32', 22), ('ishl', 'b@32', 10)) => ('extr_agx', 'a', 'b', 22, 0)
 *    ('ior', ('ushr', 'a@32', 23), ('ishl', 'b@32', 9)) => ('extr_agx', 'a', 'b', 23, 0)
 *    ('ior', ('ushr', 'a@32', 24), ('ishl', 'b@32', 8)) => ('extr_agx', 'a', 'b', 24, 0)
 *    ('ior', ('ushr', 'a@32', 25), ('ishl', 'b@32', 7)) => ('extr_agx', 'a', 'b', 25, 0)
 *    ('ior', ('ushr', 'a@32', 26), ('ishl', 'b@32', 6)) => ('extr_agx', 'a', 'b', 26, 0)
 *    ('ior', ('ushr', 'a@32', 27), ('ishl', 'b@32', 5)) => ('extr_agx', 'a', 'b', 27, 0)
 *    ('ior', ('ushr', 'a@32', 28), ('ishl', 'b@32', 4)) => ('extr_agx', 'a', 'b', 28, 0)
 *    ('ior', ('ushr', 'a@32', 29), ('ishl', 'b@32', 3)) => ('extr_agx', 'a', 'b', 29, 0)
 *    ('ior', ('ushr', 'a@32', 30), ('ishl', 'b@32', 2)) => ('extr_agx', 'a', 'b', 30, 0)
 *    ('ior', ('ushr', 'a@32', 31), ('ishl', 'b@32', 1)) => ('extr_agx', 'a', 'b', 31, 0)
 *    ('iand', ('ushr', 'a@32', 'b'), 1) => ('ubitfield_extract', 'a', 'b', 1)
 *    ('iand', ('ushr', 'a@32', 'b'), 3) => ('ubitfield_extract', 'a', 'b', 2)
 *    ('iand', ('ushr', 'a@32', 'b'), 7) => ('ubitfield_extract', 'a', 'b', 3)
 *    ('iand', ('ushr', 'a@32', 'b'), 15) => ('ubitfield_extract', 'a', 'b', 4)
 *    ('iand', ('ushr', 'a@32', 'b'), 31) => ('ubitfield_extract', 'a', 'b', 5)
 *    ('iand', ('ushr', 'a@32', 'b'), 63) => ('ubitfield_extract', 'a', 'b', 6)
 *    ('iand', ('ushr', 'a@32', 'b'), 127) => ('ubitfield_extract', 'a', 'b', 7)
 *    ('iand', ('ushr', 'a@32', 'b'), 255) => ('ubitfield_extract', 'a', 'b', 8)
 *    ('iand', ('ushr', 'a@32', 'b'), 511) => ('ubitfield_extract', 'a', 'b', 9)
 *    ('iand', ('ushr', 'a@32', 'b'), 1023) => ('ubitfield_extract', 'a', 'b', 10)
 *    ('iand', ('ushr', 'a@32', 'b'), 2047) => ('ubitfield_extract', 'a', 'b', 11)
 *    ('iand', ('ushr', 'a@32', 'b'), 4095) => ('ubitfield_extract', 'a', 'b', 12)
 *    ('iand', ('ushr', 'a@32', 'b'), 8191) => ('ubitfield_extract', 'a', 'b', 13)
 *    ('iand', ('ushr', 'a@32', 'b'), 16383) => ('ubitfield_extract', 'a', 'b', 14)
 *    ('iand', ('ushr', 'a@32', 'b'), 32767) => ('ubitfield_extract', 'a', 'b', 15)
 *    ('iand', ('ushr', 'a@32', 'b'), 65535) => ('ubitfield_extract', 'a', 'b', 16)
 *    ('iand', ('ushr', 'a@32', 'b'), 131071) => ('ubitfield_extract', 'a', 'b', 17)
 *    ('iand', ('ushr', 'a@32', 'b'), 262143) => ('ubitfield_extract', 'a', 'b', 18)
 *    ('iand', ('ushr', 'a@32', 'b'), 524287) => ('ubitfield_extract', 'a', 'b', 19)
 *    ('iand', ('ushr', 'a@32', 'b'), 1048575) => ('ubitfield_extract', 'a', 'b', 20)
 *    ('iand', ('ushr', 'a@32', 'b'), 2097151) => ('ubitfield_extract', 'a', 'b', 21)
 *    ('iand', ('ushr', 'a@32', 'b'), 4194303) => ('ubitfield_extract', 'a', 'b', 22)
 *    ('iand', ('ushr', 'a@32', 'b'), 8388607) => ('ubitfield_extract', 'a', 'b', 23)
 *    ('iand', ('ushr', 'a@32', 'b'), 16777215) => ('ubitfield_extract', 'a', 'b', 24)
 *    ('iand', ('ushr', 'a@32', 'b'), 33554431) => ('ubitfield_extract', 'a', 'b', 25)
 *    ('iand', ('ushr', 'a@32', 'b'), 67108863) => ('ubitfield_extract', 'a', 'b', 26)
 *    ('iand', ('ushr', 'a@32', 'b'), 134217727) => ('ubitfield_extract', 'a', 'b', 27)
 *    ('iand', ('ushr', 'a@32', 'b'), 268435455) => ('ubitfield_extract', 'a', 'b', 28)
 *    ('iand', ('ushr', 'a@32', 'b'), 536870911) => ('ubitfield_extract', 'a', 'b', 29)
 *    ('iand', ('ushr', 'a@32', 'b'), 1073741823) => ('ubitfield_extract', 'a', 'b', 30)
 *    ('iand', ('ushr', 'a@32', 'b'), 2147483647) => ('ubitfield_extract', 'a', 'b', 31)
 *    ('iadd', ('iadd(is_used_once)', ('imul(is_used_once)', 'a', 'b'), ('imul(is_used_once)', 'c', 'd')), 'e') => ('imadshl_agx', 'a', 'b', ('imadshl_agx', 'c', 'd', 'e', 0), 0)
 *    ('iadd', ('imul(is_used_once)', 'a', 'b'), 'c') => ('imadshl_agx', 'a', 'b', 'c', 0)
 *    ('isub', ('imul(is_used_once)', 'a', 'b'), 'c') => ('imsubshl_agx', 'a', 'b', 'c', 0)
 *    ('iadd', 'a', ('ishl(is_used_once)', 'b', 1)) => ('imadshl_agx', 'a', 1, 'b', 1)
 *    ('isub', 'a', ('ishl(is_used_once)', 'b', 1)) => ('imsubshl_agx', 'a', 1, 'b', 1)
 *    ('ineg', ('ishl(is_used_once)', 'b', 1)) => ('imsubshl_agx', 0, 1, 'b', 1)
 *    ('imadshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 1), 0) => ('imadshl_agx', 'a', 'b', 'c', 1)
 *    ('imsubshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 1), 0) => ('imsubshl_agx', 'a', 'b', 'c', 1)
 *    ('imadshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 1), 0) => ('imadshl_agx', 'a', 'b', 'c', 1)
 *    ('imsubshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 1), 0) => ('imsubshl_agx', 'a', 'b', 'c', 1)
 *    ('imul', 'a', 3) => ('imadshl_agx', 'a', 1, 'a', 1)
 *    ('imul', 'a', -1) => ('imsubshl_agx', 'a', 1, 'a', 1)
 *    ('ineg', ('imul(is_used_once)', 'a', 1)) => ('imsubshl_agx', 'a', 1, 'a', 1)
 *    ('ishl', 'a', 1) => ('imadshl_agx', 0, 1, 'a', 1)
 *    ('iadd', 'a', ('ishl(is_used_once)', 'b', 2)) => ('imadshl_agx', 'a', 1, 'b', 2)
 *    ('isub', 'a', ('ishl(is_used_once)', 'b', 2)) => ('imsubshl_agx', 'a', 1, 'b', 2)
 *    ('ineg', ('ishl(is_used_once)', 'b', 2)) => ('imsubshl_agx', 0, 1, 'b', 2)
 *    ('imadshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 2), 0) => ('imadshl_agx', 'a', 'b', 'c', 2)
 *    ('imsubshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 2), 0) => ('imsubshl_agx', 'a', 'b', 'c', 2)
 *    ('imadshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 2), 0) => ('imadshl_agx', 'a', 'b', 'c', 2)
 *    ('imsubshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 2), 0) => ('imsubshl_agx', 'a', 'b', 'c', 2)
 *    ('imul', 'a', 5) => ('imadshl_agx', 'a', 1, 'a', 2)
 *    ('imul', 'a', -3) => ('imsubshl_agx', 'a', 1, 'a', 2)
 *    ('ineg', ('imul(is_used_once)', 'a', 3)) => ('imsubshl_agx', 'a', 1, 'a', 2)
 *    ('ishl', 'a', 2) => ('imadshl_agx', 0, 1, 'a', 2)
 *    ('iadd', 'a', ('ishl(is_used_once)', 'b', 3)) => ('imadshl_agx', 'a', 1, 'b', 3)
 *    ('isub', 'a', ('ishl(is_used_once)', 'b', 3)) => ('imsubshl_agx', 'a', 1, 'b', 3)
 *    ('ineg', ('ishl(is_used_once)', 'b', 3)) => ('imsubshl_agx', 0, 1, 'b', 3)
 *    ('imadshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 3), 0) => ('imadshl_agx', 'a', 'b', 'c', 3)
 *    ('imsubshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 3), 0) => ('imsubshl_agx', 'a', 'b', 'c', 3)
 *    ('imadshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 3), 0) => ('imadshl_agx', 'a', 'b', 'c', 3)
 *    ('imsubshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 3), 0) => ('imsubshl_agx', 'a', 'b', 'c', 3)
 *    ('imul', 'a', 9) => ('imadshl_agx', 'a', 1, 'a', 3)
 *    ('imul', 'a', -7) => ('imsubshl_agx', 'a', 1, 'a', 3)
 *    ('ineg', ('imul(is_used_once)', 'a', 7)) => ('imsubshl_agx', 'a', 1, 'a', 3)
 *    ('ishl', 'a', 3) => ('imadshl_agx', 0, 1, 'a', 3)
 *    ('iadd', 'a', ('ishl(is_used_once)', 'b', 4)) => ('imadshl_agx', 'a', 1, 'b', 4)
 *    ('isub', 'a', ('ishl(is_used_once)', 'b', 4)) => ('imsubshl_agx', 'a', 1, 'b', 4)
 *    ('ineg', ('ishl(is_used_once)', 'b', 4)) => ('imsubshl_agx', 0, 1, 'b', 4)
 *    ('imadshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 4), 0) => ('imadshl_agx', 'a', 'b', 'c', 4)
 *    ('imsubshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 4), 0) => ('imsubshl_agx', 'a', 'b', 'c', 4)
 *    ('imadshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 4), 0) => ('imadshl_agx', 'a', 'b', 'c', 4)
 *    ('imsubshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 4), 0) => ('imsubshl_agx', 'a', 'b', 'c', 4)
 *    ('imul', 'a', 17) => ('imadshl_agx', 'a', 1, 'a', 4)
 *    ('imul', 'a', -15) => ('imsubshl_agx', 'a', 1, 'a', 4)
 *    ('ineg', ('imul(is_used_once)', 'a', 15)) => ('imsubshl_agx', 'a', 1, 'a', 4)
 *    ('ishl', 'a', 4) => ('imadshl_agx', 0, 1, 'a', 4)
 *    ('iadd', 'a', ('ishl(is_used_once)', 'b', '#c')) => ('imadshl_agx', 'b', ('ishl', 1, 'c'), 'a', 0)
 *    ('ixor', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ixor', 'b', 'd'), ('ixor', 'c', 'd'))
 */


static const nir_search_value_union agx_nir_fuse_algebraic_late_values[] = {
   /* ('ior', ('ushr', 'a@32', 0), ('ishl', 'b@32', 32)) => ('extr_agx', 'a', 'b', 0, 0) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20ull /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 4 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 2, 5 },
      -1,
   } },

   /* replace106_0 -> 0 in the cache */
   /* replace106_1 -> 3 in the cache */
   /* replace106_2 -> 1 in the cache */
   /* replace106_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 1, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 1), ('ishl', 'b@32', 31)) => ('extr_agx', 'a', 'b', 1, 0) */
   /* search107_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 8 },
      -1,
   } },
   /* search107_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1full /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 10 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 9, 11 },
      -1,
   } },

   /* replace107_0 -> 0 in the cache */
   /* replace107_1 -> 3 in the cache */
   /* replace107_2 -> 8 in the cache */
   /* replace107_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 8, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 2), ('ishl', 'b@32', 30)) => ('extr_agx', 'a', 'b', 2, 0) */
   /* search108_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 14 },
      -1,
   } },
   /* search108_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1eull /* 30 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 15, 17 },
      -1,
   } },

   /* replace108_0 -> 0 in the cache */
   /* replace108_1 -> 3 in the cache */
   /* replace108_2 -> 14 in the cache */
   /* replace108_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 14, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 3), ('ishl', 'b@32', 29)) => ('extr_agx', 'a', 'b', 3, 0) */
   /* search109_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3ull /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 20 },
      -1,
   } },
   /* search109_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1dull /* 29 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 21, 23 },
      -1,
   } },

   /* replace109_0 -> 0 in the cache */
   /* replace109_1 -> 3 in the cache */
   /* replace109_2 -> 20 in the cache */
   /* replace109_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 20, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 4), ('ishl', 'b@32', 28)) => ('extr_agx', 'a', 'b', 4, 0) */
   /* search110_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x4ull /* 4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 26 },
      -1,
   } },
   /* search110_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1cull /* 28 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 28 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 27, 29 },
      -1,
   } },

   /* replace110_0 -> 0 in the cache */
   /* replace110_1 -> 3 in the cache */
   /* replace110_2 -> 26 in the cache */
   /* replace110_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 26, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 5), ('ishl', 'b@32', 27)) => ('extr_agx', 'a', 'b', 5, 0) */
   /* search111_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x5ull /* 5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 32 },
      -1,
   } },
   /* search111_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1bull /* 27 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 33, 35 },
      -1,
   } },

   /* replace111_0 -> 0 in the cache */
   /* replace111_1 -> 3 in the cache */
   /* replace111_2 -> 32 in the cache */
   /* replace111_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 32, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 6), ('ishl', 'b@32', 26)) => ('extr_agx', 'a', 'b', 6, 0) */
   /* search112_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x6ull /* 6 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 38 },
      -1,
   } },
   /* search112_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1aull /* 26 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 40 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 39, 41 },
      -1,
   } },

   /* replace112_0 -> 0 in the cache */
   /* replace112_1 -> 3 in the cache */
   /* replace112_2 -> 38 in the cache */
   /* replace112_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 38, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 7), ('ishl', 'b@32', 25)) => ('extr_agx', 'a', 'b', 7, 0) */
   /* search113_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7ull /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 44 },
      -1,
   } },
   /* search113_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x19ull /* 25 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 46 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 45, 47 },
      -1,
   } },

   /* replace113_0 -> 0 in the cache */
   /* replace113_1 -> 3 in the cache */
   /* replace113_2 -> 44 in the cache */
   /* replace113_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 44, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 8), ('ishl', 'b@32', 24)) => ('extr_agx', 'a', 'b', 8, 0) */
   /* search114_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8ull /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 50 },
      -1,
   } },
   /* search114_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18ull /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 52 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 51, 53 },
      -1,
   } },

   /* replace114_0 -> 0 in the cache */
   /* replace114_1 -> 3 in the cache */
   /* replace114_2 -> 50 in the cache */
   /* replace114_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 50, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 9), ('ishl', 'b@32', 23)) => ('extr_agx', 'a', 'b', 9, 0) */
   /* search115_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x9ull /* 9 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 56 },
      -1,
   } },
   /* search115_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x17ull /* 23 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 58 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 57, 59 },
      -1,
   } },

   /* replace115_0 -> 0 in the cache */
   /* replace115_1 -> 3 in the cache */
   /* replace115_2 -> 56 in the cache */
   /* replace115_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 56, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 10), ('ishl', 'b@32', 22)) => ('extr_agx', 'a', 'b', 10, 0) */
   /* search116_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xaull /* 10 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 62 },
      -1,
   } },
   /* search116_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x16ull /* 22 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 64 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 63, 65 },
      -1,
   } },

   /* replace116_0 -> 0 in the cache */
   /* replace116_1 -> 3 in the cache */
   /* replace116_2 -> 62 in the cache */
   /* replace116_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 62, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 11), ('ishl', 'b@32', 21)) => ('extr_agx', 'a', 'b', 11, 0) */
   /* search117_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xbull /* 11 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 68 },
      -1,
   } },
   /* search117_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x15ull /* 21 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 70 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 69, 71 },
      -1,
   } },

   /* replace117_0 -> 0 in the cache */
   /* replace117_1 -> 3 in the cache */
   /* replace117_2 -> 68 in the cache */
   /* replace117_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 68, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 12), ('ishl', 'b@32', 20)) => ('extr_agx', 'a', 'b', 12, 0) */
   /* search118_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xcull /* 12 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 74 },
      -1,
   } },
   /* search118_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x14ull /* 20 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 76 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 75, 77 },
      -1,
   } },

   /* replace118_0 -> 0 in the cache */
   /* replace118_1 -> 3 in the cache */
   /* replace118_2 -> 74 in the cache */
   /* replace118_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 74, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 13), ('ishl', 'b@32', 19)) => ('extr_agx', 'a', 'b', 13, 0) */
   /* search119_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xdull /* 13 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 80 },
      -1,
   } },
   /* search119_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x13ull /* 19 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 82 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 81, 83 },
      -1,
   } },

   /* replace119_0 -> 0 in the cache */
   /* replace119_1 -> 3 in the cache */
   /* replace119_2 -> 80 in the cache */
   /* replace119_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 80, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 14), ('ishl', 'b@32', 18)) => ('extr_agx', 'a', 'b', 14, 0) */
   /* search120_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xeull /* 14 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 86 },
      -1,
   } },
   /* search120_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x12ull /* 18 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 88 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 87, 89 },
      -1,
   } },

   /* replace120_0 -> 0 in the cache */
   /* replace120_1 -> 3 in the cache */
   /* replace120_2 -> 86 in the cache */
   /* replace120_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 86, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 15), ('ishl', 'b@32', 17)) => ('extr_agx', 'a', 'b', 15, 0) */
   /* search121_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfull /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 92 },
      -1,
   } },
   /* search121_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x11ull /* 17 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 94 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 93, 95 },
      -1,
   } },

   /* replace121_0 -> 0 in the cache */
   /* replace121_1 -> 3 in the cache */
   /* replace121_2 -> 92 in the cache */
   /* replace121_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 92, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 16), ('ishl', 'b@32', 16)) => ('extr_agx', 'a', 'b', 16, 0) */
   /* search122_0_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10ull /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 98 },
      -1,
   } },
   /* search122_1_0 -> 3 in the cache */
   /* search122_1_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 99, 100 },
      -1,
   } },

   /* replace122_0 -> 0 in the cache */
   /* replace122_1 -> 3 in the cache */
   /* replace122_2 -> 98 in the cache */
   /* replace122_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 98, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 17), ('ishl', 'b@32', 15)) => ('extr_agx', 'a', 'b', 17, 0) */
   /* search123_0_0 -> 0 in the cache */
   /* search123_0_1 -> 94 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 94 },
      -1,
   } },
   /* search123_1_0 -> 3 in the cache */
   /* search123_1_1 -> 92 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 92 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 103, 104 },
      -1,
   } },

   /* replace123_0 -> 0 in the cache */
   /* replace123_1 -> 3 in the cache */
   /* replace123_2 -> 94 in the cache */
   /* replace123_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 94, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 18), ('ishl', 'b@32', 14)) => ('extr_agx', 'a', 'b', 18, 0) */
   /* search124_0_0 -> 0 in the cache */
   /* search124_0_1 -> 88 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 88 },
      -1,
   } },
   /* search124_1_0 -> 3 in the cache */
   /* search124_1_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 86 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 107, 108 },
      -1,
   } },

   /* replace124_0 -> 0 in the cache */
   /* replace124_1 -> 3 in the cache */
   /* replace124_2 -> 88 in the cache */
   /* replace124_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 88, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 19), ('ishl', 'b@32', 13)) => ('extr_agx', 'a', 'b', 19, 0) */
   /* search125_0_0 -> 0 in the cache */
   /* search125_0_1 -> 82 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 82 },
      -1,
   } },
   /* search125_1_0 -> 3 in the cache */
   /* search125_1_1 -> 80 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 80 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 111, 112 },
      -1,
   } },

   /* replace125_0 -> 0 in the cache */
   /* replace125_1 -> 3 in the cache */
   /* replace125_2 -> 82 in the cache */
   /* replace125_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 82, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 20), ('ishl', 'b@32', 12)) => ('extr_agx', 'a', 'b', 20, 0) */
   /* search126_0_0 -> 0 in the cache */
   /* search126_0_1 -> 76 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 76 },
      -1,
   } },
   /* search126_1_0 -> 3 in the cache */
   /* search126_1_1 -> 74 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 74 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 115, 116 },
      -1,
   } },

   /* replace126_0 -> 0 in the cache */
   /* replace126_1 -> 3 in the cache */
   /* replace126_2 -> 76 in the cache */
   /* replace126_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 76, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 21), ('ishl', 'b@32', 11)) => ('extr_agx', 'a', 'b', 21, 0) */
   /* search127_0_0 -> 0 in the cache */
   /* search127_0_1 -> 70 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 70 },
      -1,
   } },
   /* search127_1_0 -> 3 in the cache */
   /* search127_1_1 -> 68 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 68 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 119, 120 },
      -1,
   } },

   /* replace127_0 -> 0 in the cache */
   /* replace127_1 -> 3 in the cache */
   /* replace127_2 -> 70 in the cache */
   /* replace127_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 70, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 22), ('ishl', 'b@32', 10)) => ('extr_agx', 'a', 'b', 22, 0) */
   /* search128_0_0 -> 0 in the cache */
   /* search128_0_1 -> 64 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 64 },
      -1,
   } },
   /* search128_1_0 -> 3 in the cache */
   /* search128_1_1 -> 62 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 62 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 123, 124 },
      -1,
   } },

   /* replace128_0 -> 0 in the cache */
   /* replace128_1 -> 3 in the cache */
   /* replace128_2 -> 64 in the cache */
   /* replace128_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 64, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 23), ('ishl', 'b@32', 9)) => ('extr_agx', 'a', 'b', 23, 0) */
   /* search129_0_0 -> 0 in the cache */
   /* search129_0_1 -> 58 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 58 },
      -1,
   } },
   /* search129_1_0 -> 3 in the cache */
   /* search129_1_1 -> 56 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 56 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 127, 128 },
      -1,
   } },

   /* replace129_0 -> 0 in the cache */
   /* replace129_1 -> 3 in the cache */
   /* replace129_2 -> 58 in the cache */
   /* replace129_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 58, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 24), ('ishl', 'b@32', 8)) => ('extr_agx', 'a', 'b', 24, 0) */
   /* search130_0_0 -> 0 in the cache */
   /* search130_0_1 -> 52 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 52 },
      -1,
   } },
   /* search130_1_0 -> 3 in the cache */
   /* search130_1_1 -> 50 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 50 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 131, 132 },
      -1,
   } },

   /* replace130_0 -> 0 in the cache */
   /* replace130_1 -> 3 in the cache */
   /* replace130_2 -> 52 in the cache */
   /* replace130_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 52, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 25), ('ishl', 'b@32', 7)) => ('extr_agx', 'a', 'b', 25, 0) */
   /* search131_0_0 -> 0 in the cache */
   /* search131_0_1 -> 46 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 46 },
      -1,
   } },
   /* search131_1_0 -> 3 in the cache */
   /* search131_1_1 -> 44 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 44 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 135, 136 },
      -1,
   } },

   /* replace131_0 -> 0 in the cache */
   /* replace131_1 -> 3 in the cache */
   /* replace131_2 -> 46 in the cache */
   /* replace131_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 46, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 26), ('ishl', 'b@32', 6)) => ('extr_agx', 'a', 'b', 26, 0) */
   /* search132_0_0 -> 0 in the cache */
   /* search132_0_1 -> 40 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 40 },
      -1,
   } },
   /* search132_1_0 -> 3 in the cache */
   /* search132_1_1 -> 38 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 38 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 139, 140 },
      -1,
   } },

   /* replace132_0 -> 0 in the cache */
   /* replace132_1 -> 3 in the cache */
   /* replace132_2 -> 40 in the cache */
   /* replace132_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 40, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 27), ('ishl', 'b@32', 5)) => ('extr_agx', 'a', 'b', 27, 0) */
   /* search133_0_0 -> 0 in the cache */
   /* search133_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 34 },
      -1,
   } },
   /* search133_1_0 -> 3 in the cache */
   /* search133_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 143, 144 },
      -1,
   } },

   /* replace133_0 -> 0 in the cache */
   /* replace133_1 -> 3 in the cache */
   /* replace133_2 -> 34 in the cache */
   /* replace133_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 34, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 28), ('ishl', 'b@32', 4)) => ('extr_agx', 'a', 'b', 28, 0) */
   /* search134_0_0 -> 0 in the cache */
   /* search134_0_1 -> 28 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 28 },
      -1,
   } },
   /* search134_1_0 -> 3 in the cache */
   /* search134_1_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 26 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 147, 148 },
      -1,
   } },

   /* replace134_0 -> 0 in the cache */
   /* replace134_1 -> 3 in the cache */
   /* replace134_2 -> 28 in the cache */
   /* replace134_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 28, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 29), ('ishl', 'b@32', 3)) => ('extr_agx', 'a', 'b', 29, 0) */
   /* search135_0_0 -> 0 in the cache */
   /* search135_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 22 },
      -1,
   } },
   /* search135_1_0 -> 3 in the cache */
   /* search135_1_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 20 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 151, 152 },
      -1,
   } },

   /* replace135_0 -> 0 in the cache */
   /* replace135_1 -> 3 in the cache */
   /* replace135_2 -> 22 in the cache */
   /* replace135_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 22, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 30), ('ishl', 'b@32', 2)) => ('extr_agx', 'a', 'b', 30, 0) */
   /* search136_0_0 -> 0 in the cache */
   /* search136_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 16 },
      -1,
   } },
   /* search136_1_0 -> 3 in the cache */
   /* search136_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 155, 156 },
      -1,
   } },

   /* replace136_0 -> 0 in the cache */
   /* replace136_1 -> 3 in the cache */
   /* replace136_2 -> 16 in the cache */
   /* replace136_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 16, 1 },
      -1,
   } },

   /* ('ior', ('ushr', 'a@32', 31), ('ishl', 'b@32', 1)) => ('extr_agx', 'a', 'b', 31, 0) */
   /* search137_0_0 -> 0 in the cache */
   /* search137_0_1 -> 10 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 10 },
      -1,
   } },
   /* search137_1_0 -> 3 in the cache */
   /* search137_1_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 3, 8 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 159, 160 },
      -1,
   } },

   /* replace137_0 -> 0 in the cache */
   /* replace137_1 -> 3 in the cache */
   /* replace137_2 -> 10 in the cache */
   /* replace137_3 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_extr_agx,
      -1, 0,
      { 0, 3, 10, 1 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 1) => ('ubitfield_extract', 'a', 'b', 1) */
   /* search138_0_0 -> 0 in the cache */
   /* search138_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   /* search138_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 8 },
      -1,
   } },

   /* replace138_0 -> 0 in the cache */
   /* replace138_1 -> 3 in the cache */
   /* replace138_2 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 8 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 3) => ('ubitfield_extract', 'a', 'b', 2) */
   /* search139_0_0 -> 0 in the cache */
   /* search139_0_1 -> 3 in the cache */
   /* search139_0 -> 163 in the cache */
   /* search139_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 20 },
      -1,
   } },

   /* replace139_0 -> 0 in the cache */
   /* replace139_1 -> 3 in the cache */
   /* replace139_2 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 14 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 7) => ('ubitfield_extract', 'a', 'b', 3) */
   /* search140_0_0 -> 0 in the cache */
   /* search140_0_1 -> 3 in the cache */
   /* search140_0 -> 163 in the cache */
   /* search140_1 -> 44 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 44 },
      -1,
   } },

   /* replace140_0 -> 0 in the cache */
   /* replace140_1 -> 3 in the cache */
   /* replace140_2 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 20 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 15) => ('ubitfield_extract', 'a', 'b', 4) */
   /* search141_0_0 -> 0 in the cache */
   /* search141_0_1 -> 3 in the cache */
   /* search141_0 -> 163 in the cache */
   /* search141_1 -> 92 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 92 },
      -1,
   } },

   /* replace141_0 -> 0 in the cache */
   /* replace141_1 -> 3 in the cache */
   /* replace141_2 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 26 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 31) => ('ubitfield_extract', 'a', 'b', 5) */
   /* search142_0_0 -> 0 in the cache */
   /* search142_0_1 -> 3 in the cache */
   /* search142_0 -> 163 in the cache */
   /* search142_1 -> 10 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 10 },
      -1,
   } },

   /* replace142_0 -> 0 in the cache */
   /* replace142_1 -> 3 in the cache */
   /* replace142_2 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 32 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 63) => ('ubitfield_extract', 'a', 'b', 6) */
   /* search143_0_0 -> 0 in the cache */
   /* search143_0_1 -> 3 in the cache */
   /* search143_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3full /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 174 },
      -1,
   } },

   /* replace143_0 -> 0 in the cache */
   /* replace143_1 -> 3 in the cache */
   /* replace143_2 -> 38 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 38 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 127) => ('ubitfield_extract', 'a', 'b', 7) */
   /* search144_0_0 -> 0 in the cache */
   /* search144_0_1 -> 3 in the cache */
   /* search144_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7full /* 127 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 177 },
      -1,
   } },

   /* replace144_0 -> 0 in the cache */
   /* replace144_1 -> 3 in the cache */
   /* replace144_2 -> 44 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 44 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 255) => ('ubitfield_extract', 'a', 'b', 8) */
   /* search145_0_0 -> 0 in the cache */
   /* search145_0_1 -> 3 in the cache */
   /* search145_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 180 },
      -1,
   } },

   /* replace145_0 -> 0 in the cache */
   /* replace145_1 -> 3 in the cache */
   /* replace145_2 -> 50 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 50 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 511) => ('ubitfield_extract', 'a', 'b', 9) */
   /* search146_0_0 -> 0 in the cache */
   /* search146_0_1 -> 3 in the cache */
   /* search146_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ffull /* 511 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 183 },
      -1,
   } },

   /* replace146_0 -> 0 in the cache */
   /* replace146_1 -> 3 in the cache */
   /* replace146_2 -> 56 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 56 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 1023) => ('ubitfield_extract', 'a', 'b', 10) */
   /* search147_0_0 -> 0 in the cache */
   /* search147_0_1 -> 3 in the cache */
   /* search147_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3ffull /* 1023 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 186 },
      -1,
   } },

   /* replace147_0 -> 0 in the cache */
   /* replace147_1 -> 3 in the cache */
   /* replace147_2 -> 62 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 62 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 2047) => ('ubitfield_extract', 'a', 'b', 11) */
   /* search148_0_0 -> 0 in the cache */
   /* search148_0_1 -> 3 in the cache */
   /* search148_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7ffull /* 2047 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 189 },
      -1,
   } },

   /* replace148_0 -> 0 in the cache */
   /* replace148_1 -> 3 in the cache */
   /* replace148_2 -> 68 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 68 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 4095) => ('ubitfield_extract', 'a', 'b', 12) */
   /* search149_0_0 -> 0 in the cache */
   /* search149_0_1 -> 3 in the cache */
   /* search149_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffull /* 4095 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 192 },
      -1,
   } },

   /* replace149_0 -> 0 in the cache */
   /* replace149_1 -> 3 in the cache */
   /* replace149_2 -> 74 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 74 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 8191) => ('ubitfield_extract', 'a', 'b', 13) */
   /* search150_0_0 -> 0 in the cache */
   /* search150_0_1 -> 3 in the cache */
   /* search150_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1fffull /* 8191 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 195 },
      -1,
   } },

   /* replace150_0 -> 0 in the cache */
   /* replace150_1 -> 3 in the cache */
   /* replace150_2 -> 80 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 80 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 16383) => ('ubitfield_extract', 'a', 'b', 14) */
   /* search151_0_0 -> 0 in the cache */
   /* search151_0_1 -> 3 in the cache */
   /* search151_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffull /* 16383 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 198 },
      -1,
   } },

   /* replace151_0 -> 0 in the cache */
   /* replace151_1 -> 3 in the cache */
   /* replace151_2 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 86 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 32767) => ('ubitfield_extract', 'a', 'b', 15) */
   /* search152_0_0 -> 0 in the cache */
   /* search152_0_1 -> 3 in the cache */
   /* search152_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffull /* 32767 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 201 },
      -1,
   } },

   /* replace152_0 -> 0 in the cache */
   /* replace152_1 -> 3 in the cache */
   /* replace152_2 -> 92 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 92 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 65535) => ('ubitfield_extract', 'a', 'b', 16) */
   /* search153_0_0 -> 0 in the cache */
   /* search153_0_1 -> 3 in the cache */
   /* search153_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 204 },
      -1,
   } },

   /* replace153_0 -> 0 in the cache */
   /* replace153_1 -> 3 in the cache */
   /* replace153_2 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 98 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 131071) => ('ubitfield_extract', 'a', 'b', 17) */
   /* search154_0_0 -> 0 in the cache */
   /* search154_0_1 -> 3 in the cache */
   /* search154_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ffffull /* 131071 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 207 },
      -1,
   } },

   /* replace154_0 -> 0 in the cache */
   /* replace154_1 -> 3 in the cache */
   /* replace154_2 -> 94 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 94 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 262143) => ('ubitfield_extract', 'a', 'b', 18) */
   /* search155_0_0 -> 0 in the cache */
   /* search155_0_1 -> 3 in the cache */
   /* search155_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3ffffull /* 262143 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 210 },
      -1,
   } },

   /* replace155_0 -> 0 in the cache */
   /* replace155_1 -> 3 in the cache */
   /* replace155_2 -> 88 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 88 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 524287) => ('ubitfield_extract', 'a', 'b', 19) */
   /* search156_0_0 -> 0 in the cache */
   /* search156_0_1 -> 3 in the cache */
   /* search156_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7ffffull /* 524287 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 213 },
      -1,
   } },

   /* replace156_0 -> 0 in the cache */
   /* replace156_1 -> 3 in the cache */
   /* replace156_2 -> 82 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 82 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 1048575) => ('ubitfield_extract', 'a', 'b', 20) */
   /* search157_0_0 -> 0 in the cache */
   /* search157_0_1 -> 3 in the cache */
   /* search157_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffull /* 1048575 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 216 },
      -1,
   } },

   /* replace157_0 -> 0 in the cache */
   /* replace157_1 -> 3 in the cache */
   /* replace157_2 -> 76 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 76 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 2097151) => ('ubitfield_extract', 'a', 'b', 21) */
   /* search158_0_0 -> 0 in the cache */
   /* search158_0_1 -> 3 in the cache */
   /* search158_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1fffffull /* 2097151 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 219 },
      -1,
   } },

   /* replace158_0 -> 0 in the cache */
   /* replace158_1 -> 3 in the cache */
   /* replace158_2 -> 70 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 70 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 4194303) => ('ubitfield_extract', 'a', 'b', 22) */
   /* search159_0_0 -> 0 in the cache */
   /* search159_0_1 -> 3 in the cache */
   /* search159_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffull /* 4194303 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 222 },
      -1,
   } },

   /* replace159_0 -> 0 in the cache */
   /* replace159_1 -> 3 in the cache */
   /* replace159_2 -> 64 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 64 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 8388607) => ('ubitfield_extract', 'a', 'b', 23) */
   /* search160_0_0 -> 0 in the cache */
   /* search160_0_1 -> 3 in the cache */
   /* search160_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffull /* 8388607 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 225 },
      -1,
   } },

   /* replace160_0 -> 0 in the cache */
   /* replace160_1 -> 3 in the cache */
   /* replace160_2 -> 58 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 58 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 16777215) => ('ubitfield_extract', 'a', 'b', 24) */
   /* search161_0_0 -> 0 in the cache */
   /* search161_0_1 -> 3 in the cache */
   /* search161_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffull /* 16777215 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 228 },
      -1,
   } },

   /* replace161_0 -> 0 in the cache */
   /* replace161_1 -> 3 in the cache */
   /* replace161_2 -> 52 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 52 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 33554431) => ('ubitfield_extract', 'a', 'b', 25) */
   /* search162_0_0 -> 0 in the cache */
   /* search162_0_1 -> 3 in the cache */
   /* search162_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ffffffull /* 33554431 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 231 },
      -1,
   } },

   /* replace162_0 -> 0 in the cache */
   /* replace162_1 -> 3 in the cache */
   /* replace162_2 -> 46 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 46 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 67108863) => ('ubitfield_extract', 'a', 'b', 26) */
   /* search163_0_0 -> 0 in the cache */
   /* search163_0_1 -> 3 in the cache */
   /* search163_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3ffffffull /* 67108863 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 234 },
      -1,
   } },

   /* replace163_0 -> 0 in the cache */
   /* replace163_1 -> 3 in the cache */
   /* replace163_2 -> 40 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 40 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 134217727) => ('ubitfield_extract', 'a', 'b', 27) */
   /* search164_0_0 -> 0 in the cache */
   /* search164_0_1 -> 3 in the cache */
   /* search164_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7ffffffull /* 134217727 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 237 },
      -1,
   } },

   /* replace164_0 -> 0 in the cache */
   /* replace164_1 -> 3 in the cache */
   /* replace164_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 34 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 268435455) => ('ubitfield_extract', 'a', 'b', 28) */
   /* search165_0_0 -> 0 in the cache */
   /* search165_0_1 -> 3 in the cache */
   /* search165_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffull /* 268435455 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 240 },
      -1,
   } },

   /* replace165_0 -> 0 in the cache */
   /* replace165_1 -> 3 in the cache */
   /* replace165_2 -> 28 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 28 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 536870911) => ('ubitfield_extract', 'a', 'b', 29) */
   /* search166_0_0 -> 0 in the cache */
   /* search166_0_1 -> 3 in the cache */
   /* search166_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1fffffffull /* 536870911 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 243 },
      -1,
   } },

   /* replace166_0 -> 0 in the cache */
   /* replace166_1 -> 3 in the cache */
   /* replace166_2 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 22 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 1073741823) => ('ubitfield_extract', 'a', 'b', 30) */
   /* search167_0_0 -> 0 in the cache */
   /* search167_0_1 -> 3 in the cache */
   /* search167_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffffull /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 246 },
      -1,
   } },

   /* replace167_0 -> 0 in the cache */
   /* replace167_1 -> 3 in the cache */
   /* replace167_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 16 },
      -1,
   } },

   /* ('iand', ('ushr', 'a@32', 'b'), 2147483647) => ('ubitfield_extract', 'a', 'b', 31) */
   /* search168_0_0 -> 0 in the cache */
   /* search168_0_1 -> 3 in the cache */
   /* search168_0 -> 163 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffffull /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 163, 249 },
      -1,
   } },

   /* replace168_0 -> 0 in the cache */
   /* replace168_1 -> 3 in the cache */
   /* replace168_2 -> 10 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubitfield_extract,
      -1, 0,
      { 0, 3, 10 },
      -1,
   } },

   /* ('iadd', ('iadd(is_used_once)', ('imul(is_used_once)', 'a', 'b'), ('imul(is_used_once)', 'c', 'd')), 'e') => ('imadshl_agx', 'a', 'b', ('imadshl_agx', 'c', 'd', 'e', 0), 0) */
   { .variable = {
      { nir_search_value_variable, -5 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      2, 1,
      { 252, 253 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 255, 256 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 254, 257 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 258, 259 },
      -1,
   } },

   /* replace169_0 -> 252 in the cache */
   /* replace169_1 -> 253 in the cache */
   /* replace169_2_0 -> 255 in the cache */
   /* replace169_2_1 -> 256 in the cache */
   /* replace169_2_2 -> 259 in the cache */
   { .constant = {
      { nir_search_value_constant, -5 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 255, 256, 259, 261 },
      -1,
   } },
   /* replace169_3 -> 261 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 252, 253, 262, 261 },
      -1,
   } },

   /* ('iadd', ('imul(is_used_once)', 'a', 'b'), 'c') => ('imadshl_agx', 'a', 'b', 'c', 0) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 1,
      { 264, 265 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 266, 267 },
      -1,
   } },

   /* replace170_0 -> 264 in the cache */
   /* replace170_1 -> 265 in the cache */
   /* replace170_2 -> 267 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 267, 269 },
      -1,
   } },

   /* ('isub', ('imul(is_used_once)', 'a', 'b'), 'c') => ('imsubshl_agx', 'a', 'b', 'c', 0) */
   /* search171_0_0 -> 264 in the cache */
   /* search171_0_1 -> 265 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 264, 265 },
      0,
   } },
   /* search171_1 -> 267 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 1,
      { 271, 267 },
      -1,
   } },

   /* replace171_0 -> 264 in the cache */
   /* replace171_1 -> 265 in the cache */
   /* replace171_2 -> 267 in the cache */
   /* replace171_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 267, 269 },
      -1,
   } },

   /* ('iadd', 'a', ('ishl(is_used_once)', 'b', 1)) => ('imadshl_agx', 'a', 1, 'b', 1) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search172_1_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 275, 8 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 274, 276 },
      -1,
   } },

   /* replace172_0 -> 274 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   /* replace172_2 -> 275 in the cache */
   /* replace172_3 -> 278 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 274, 278, 275, 278 },
      -1,
   } },

   /* ('isub', 'a', ('ishl(is_used_once)', 'b', 1)) => ('imsubshl_agx', 'a', 1, 'b', 1) */
   /* search173_0 -> 274 in the cache */
   /* search173_1_0 -> 275 in the cache */
   /* search173_1_1 -> 8 in the cache */
   /* search173_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 274, 276 },
      -1,
   } },

   /* replace173_0 -> 274 in the cache */
   /* replace173_1 -> 278 in the cache */
   /* replace173_2 -> 275 in the cache */
   /* replace173_3 -> 278 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 274, 278, 275, 278 },
      -1,
   } },

   /* ('ineg', ('ishl(is_used_once)', 'b', 1)) => ('imsubshl_agx', 0, 1, 'b', 1) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search174_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 282, 8 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 283 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   /* replace174_2 -> 282 in the cache */
   /* replace174_3 -> 286 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 285, 286, 282, 286 },
      -1,
   } },

   /* ('imadshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 1), 0) => ('imadshl_agx', 'a', 'b', 'c', 1) */
   /* search175_0 -> 264 in the cache */
   /* search175_1 -> 265 in the cache */
   /* search175_2_0 -> 267 in the cache */
   /* search175_2_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 267, 8 },
      0,
   } },
   /* search175_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 288, 269 },
      -1,
   } },

   /* replace175_0 -> 264 in the cache */
   /* replace175_1 -> 265 in the cache */
   /* replace175_2 -> 267 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 267, 290 },
      -1,
   } },

   /* ('imsubshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 1), 0) => ('imsubshl_agx', 'a', 'b', 'c', 1) */
   /* search176_0 -> 264 in the cache */
   /* search176_1 -> 265 in the cache */
   /* search176_2_0 -> 267 in the cache */
   /* search176_2_1 -> 8 in the cache */
   /* search176_2 -> 288 in the cache */
   /* search176_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 288, 269 },
      -1,
   } },

   /* replace176_0 -> 264 in the cache */
   /* replace176_1 -> 265 in the cache */
   /* replace176_2 -> 267 in the cache */
   /* replace176_3 -> 290 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 267, 290 },
      -1,
   } },

   /* ('imadshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 1), 0) => ('imadshl_agx', 'a', 'b', 'c', 1) */
   /* search177_0 -> 264 in the cache */
   /* search177_1 -> 265 in the cache */
   /* search177_2_0 -> 269 in the cache */
   /* search177_2_1 -> 290 in the cache */
   /* search177_2_2 -> 267 in the cache */
   /* search177_2_3 -> 290 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 269, 290, 267, 290 },
      0,
   } },
   /* search177_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 294, 269 },
      -1,
   } },

   /* replace177_0 -> 264 in the cache */
   /* replace177_1 -> 265 in the cache */
   /* replace177_2 -> 267 in the cache */
   /* replace177_3 -> 290 in the cache */
   /* replace177 -> 291 in the cache */

   /* ('imsubshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 1), 0) => ('imsubshl_agx', 'a', 'b', 'c', 1) */
   /* search178_0 -> 264 in the cache */
   /* search178_1 -> 265 in the cache */
   /* search178_2_0 -> 269 in the cache */
   /* search178_2_1 -> 290 in the cache */
   /* search178_2_2 -> 267 in the cache */
   /* search178_2_3 -> 290 in the cache */
   /* search178_2 -> 294 in the cache */
   /* search178_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 294, 269 },
      -1,
   } },

   /* replace178_0 -> 264 in the cache */
   /* replace178_1 -> 265 in the cache */
   /* replace178_2 -> 267 in the cache */
   /* replace178_3 -> 290 in the cache */
   /* replace178 -> 293 in the cache */

   /* ('imul', 'a', 3) => ('imadshl_agx', 'a', 1, 'a', 1) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x3ull /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 298 },
      -1,
   } },

   /* replace179_0 -> 297 in the cache */
   /* replace179_1 -> 286 in the cache */
   /* replace179_2 -> 297 in the cache */
   /* replace179_3 -> 286 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 297, 286, 297, 286 },
      -1,
   } },

   /* ('imul', 'a', -1) => ('imsubshl_agx', 'a', 1, 'a', 1) */
   /* search180_0 -> 297 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 301 },
      -1,
   } },

   /* replace180_0 -> 297 in the cache */
   /* replace180_1 -> 286 in the cache */
   /* replace180_2 -> 297 in the cache */
   /* replace180_3 -> 286 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 297, 286, 297, 286 },
      -1,
   } },

   /* ('ineg', ('imul(is_used_once)', 'a', 1)) => ('imsubshl_agx', 'a', 1, 'a', 1) */
   /* search181_0_0 -> 297 in the cache */
   /* search181_0_1 -> 286 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 286 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 1,
      { 304 },
      -1,
   } },

   /* replace181_0 -> 297 in the cache */
   /* replace181_1 -> 286 in the cache */
   /* replace181_2 -> 297 in the cache */
   /* replace181_3 -> 286 in the cache */
   /* replace181 -> 303 in the cache */

   /* ('ishl', 'a', 1) => ('imadshl_agx', 0, 1, 'a', 1) */
   /* search182_0 -> 297 in the cache */
   /* search182_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 297, 8 },
      -1,
   } },

   /* replace182_0 -> 285 in the cache */
   /* replace182_1 -> 286 in the cache */
   /* replace182_2 -> 297 in the cache */
   /* replace182_3 -> 286 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 285, 286, 297, 286 },
      -1,
   } },

   /* ('iadd', 'a', ('ishl(is_used_once)', 'b', 2)) => ('imadshl_agx', 'a', 1, 'b', 2) */
   /* search183_0 -> 274 in the cache */
   /* search183_1_0 -> 275 in the cache */
   /* search183_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 275, 14 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 274, 308 },
      -1,
   } },

   /* replace183_0 -> 274 in the cache */
   /* replace183_1 -> 278 in the cache */
   /* replace183_2 -> 275 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 274, 278, 275, 310 },
      -1,
   } },

   /* ('isub', 'a', ('ishl(is_used_once)', 'b', 2)) => ('imsubshl_agx', 'a', 1, 'b', 2) */
   /* search184_0 -> 274 in the cache */
   /* search184_1_0 -> 275 in the cache */
   /* search184_1_1 -> 14 in the cache */
   /* search184_1 -> 308 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 274, 308 },
      -1,
   } },

   /* replace184_0 -> 274 in the cache */
   /* replace184_1 -> 278 in the cache */
   /* replace184_2 -> 275 in the cache */
   /* replace184_3 -> 310 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 274, 278, 275, 310 },
      -1,
   } },

   /* ('ineg', ('ishl(is_used_once)', 'b', 2)) => ('imsubshl_agx', 0, 1, 'b', 2) */
   /* search185_0_0 -> 282 in the cache */
   /* search185_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 282, 14 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 314 },
      -1,
   } },

   /* replace185_0 -> 285 in the cache */
   /* replace185_1 -> 286 in the cache */
   /* replace185_2 -> 282 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 285, 286, 282, 316 },
      -1,
   } },

   /* ('imadshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 2), 0) => ('imadshl_agx', 'a', 'b', 'c', 2) */
   /* search186_0 -> 264 in the cache */
   /* search186_1 -> 265 in the cache */
   /* search186_2_0 -> 267 in the cache */
   /* search186_2_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 267, 14 },
      0,
   } },
   /* search186_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 318, 269 },
      -1,
   } },

   /* replace186_0 -> 264 in the cache */
   /* replace186_1 -> 265 in the cache */
   /* replace186_2 -> 267 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 267, 320 },
      -1,
   } },

   /* ('imsubshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 2), 0) => ('imsubshl_agx', 'a', 'b', 'c', 2) */
   /* search187_0 -> 264 in the cache */
   /* search187_1 -> 265 in the cache */
   /* search187_2_0 -> 267 in the cache */
   /* search187_2_1 -> 14 in the cache */
   /* search187_2 -> 318 in the cache */
   /* search187_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 318, 269 },
      -1,
   } },

   /* replace187_0 -> 264 in the cache */
   /* replace187_1 -> 265 in the cache */
   /* replace187_2 -> 267 in the cache */
   /* replace187_3 -> 320 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 267, 320 },
      -1,
   } },

   /* ('imadshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 2), 0) => ('imadshl_agx', 'a', 'b', 'c', 2) */
   /* search188_0 -> 264 in the cache */
   /* search188_1 -> 265 in the cache */
   /* search188_2_0 -> 269 in the cache */
   /* search188_2_1 -> 290 in the cache */
   /* search188_2_2 -> 267 in the cache */
   /* search188_2_3 -> 320 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 269, 290, 267, 320 },
      0,
   } },
   /* search188_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 324, 269 },
      -1,
   } },

   /* replace188_0 -> 264 in the cache */
   /* replace188_1 -> 265 in the cache */
   /* replace188_2 -> 267 in the cache */
   /* replace188_3 -> 320 in the cache */
   /* replace188 -> 321 in the cache */

   /* ('imsubshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 2), 0) => ('imsubshl_agx', 'a', 'b', 'c', 2) */
   /* search189_0 -> 264 in the cache */
   /* search189_1 -> 265 in the cache */
   /* search189_2_0 -> 269 in the cache */
   /* search189_2_1 -> 290 in the cache */
   /* search189_2_2 -> 267 in the cache */
   /* search189_2_3 -> 320 in the cache */
   /* search189_2 -> 324 in the cache */
   /* search189_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 324, 269 },
      -1,
   } },

   /* replace189_0 -> 264 in the cache */
   /* replace189_1 -> 265 in the cache */
   /* replace189_2 -> 267 in the cache */
   /* replace189_3 -> 320 in the cache */
   /* replace189 -> 323 in the cache */

   /* ('imul', 'a', 5) => ('imadshl_agx', 'a', 1, 'a', 2) */
   /* search190_0 -> 297 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x5ull /* 5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 327 },
      -1,
   } },

   /* replace190_0 -> 297 in the cache */
   /* replace190_1 -> 286 in the cache */
   /* replace190_2 -> 297 in the cache */
   /* replace190_3 -> 316 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 297, 286, 297, 316 },
      -1,
   } },

   /* ('imul', 'a', -3) => ('imsubshl_agx', 'a', 1, 'a', 2) */
   /* search191_0 -> 297 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xfffffffffffffffdull /* -3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 330 },
      -1,
   } },

   /* replace191_0 -> 297 in the cache */
   /* replace191_1 -> 286 in the cache */
   /* replace191_2 -> 297 in the cache */
   /* replace191_3 -> 316 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 297, 286, 297, 316 },
      -1,
   } },

   /* ('ineg', ('imul(is_used_once)', 'a', 3)) => ('imsubshl_agx', 'a', 1, 'a', 2) */
   /* search192_0_0 -> 297 in the cache */
   /* search192_0_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 298 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 1,
      { 333 },
      -1,
   } },

   /* replace192_0 -> 297 in the cache */
   /* replace192_1 -> 286 in the cache */
   /* replace192_2 -> 297 in the cache */
   /* replace192_3 -> 316 in the cache */
   /* replace192 -> 332 in the cache */

   /* ('ishl', 'a', 2) => ('imadshl_agx', 0, 1, 'a', 2) */
   /* search193_0 -> 297 in the cache */
   /* search193_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 297, 14 },
      -1,
   } },

   /* replace193_0 -> 285 in the cache */
   /* replace193_1 -> 286 in the cache */
   /* replace193_2 -> 297 in the cache */
   /* replace193_3 -> 316 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 285, 286, 297, 316 },
      -1,
   } },

   /* ('iadd', 'a', ('ishl(is_used_once)', 'b', 3)) => ('imadshl_agx', 'a', 1, 'b', 3) */
   /* search194_0 -> 274 in the cache */
   /* search194_1_0 -> 275 in the cache */
   /* search194_1_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 275, 20 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 274, 337 },
      -1,
   } },

   /* replace194_0 -> 274 in the cache */
   /* replace194_1 -> 278 in the cache */
   /* replace194_2 -> 275 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x3ull /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 274, 278, 275, 339 },
      -1,
   } },

   /* ('isub', 'a', ('ishl(is_used_once)', 'b', 3)) => ('imsubshl_agx', 'a', 1, 'b', 3) */
   /* search195_0 -> 274 in the cache */
   /* search195_1_0 -> 275 in the cache */
   /* search195_1_1 -> 20 in the cache */
   /* search195_1 -> 337 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 274, 337 },
      -1,
   } },

   /* replace195_0 -> 274 in the cache */
   /* replace195_1 -> 278 in the cache */
   /* replace195_2 -> 275 in the cache */
   /* replace195_3 -> 339 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 274, 278, 275, 339 },
      -1,
   } },

   /* ('ineg', ('ishl(is_used_once)', 'b', 3)) => ('imsubshl_agx', 0, 1, 'b', 3) */
   /* search196_0_0 -> 282 in the cache */
   /* search196_0_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 282, 20 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 343 },
      -1,
   } },

   /* replace196_0 -> 285 in the cache */
   /* replace196_1 -> 286 in the cache */
   /* replace196_2 -> 282 in the cache */
   /* replace196_3 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 285, 286, 282, 298 },
      -1,
   } },

   /* ('imadshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 3), 0) => ('imadshl_agx', 'a', 'b', 'c', 3) */
   /* search197_0 -> 264 in the cache */
   /* search197_1 -> 265 in the cache */
   /* search197_2_0 -> 267 in the cache */
   /* search197_2_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 267, 20 },
      0,
   } },
   /* search197_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 346, 269 },
      -1,
   } },

   /* replace197_0 -> 264 in the cache */
   /* replace197_1 -> 265 in the cache */
   /* replace197_2 -> 267 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_int, { 0x3ull /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 267, 348 },
      -1,
   } },

   /* ('imsubshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 3), 0) => ('imsubshl_agx', 'a', 'b', 'c', 3) */
   /* search198_0 -> 264 in the cache */
   /* search198_1 -> 265 in the cache */
   /* search198_2_0 -> 267 in the cache */
   /* search198_2_1 -> 20 in the cache */
   /* search198_2 -> 346 in the cache */
   /* search198_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 346, 269 },
      -1,
   } },

   /* replace198_0 -> 264 in the cache */
   /* replace198_1 -> 265 in the cache */
   /* replace198_2 -> 267 in the cache */
   /* replace198_3 -> 348 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 267, 348 },
      -1,
   } },

   /* ('imadshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 3), 0) => ('imadshl_agx', 'a', 'b', 'c', 3) */
   /* search199_0 -> 264 in the cache */
   /* search199_1 -> 265 in the cache */
   /* search199_2_0 -> 269 in the cache */
   /* search199_2_1 -> 290 in the cache */
   /* search199_2_2 -> 267 in the cache */
   /* search199_2_3 -> 348 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 269, 290, 267, 348 },
      0,
   } },
   /* search199_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 352, 269 },
      -1,
   } },

   /* replace199_0 -> 264 in the cache */
   /* replace199_1 -> 265 in the cache */
   /* replace199_2 -> 267 in the cache */
   /* replace199_3 -> 348 in the cache */
   /* replace199 -> 349 in the cache */

   /* ('imsubshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 3), 0) => ('imsubshl_agx', 'a', 'b', 'c', 3) */
   /* search200_0 -> 264 in the cache */
   /* search200_1 -> 265 in the cache */
   /* search200_2_0 -> 269 in the cache */
   /* search200_2_1 -> 290 in the cache */
   /* search200_2_2 -> 267 in the cache */
   /* search200_2_3 -> 348 in the cache */
   /* search200_2 -> 352 in the cache */
   /* search200_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 352, 269 },
      -1,
   } },

   /* replace200_0 -> 264 in the cache */
   /* replace200_1 -> 265 in the cache */
   /* replace200_2 -> 267 in the cache */
   /* replace200_3 -> 348 in the cache */
   /* replace200 -> 351 in the cache */

   /* ('imul', 'a', 9) => ('imadshl_agx', 'a', 1, 'a', 3) */
   /* search201_0 -> 297 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x9ull /* 9 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 355 },
      -1,
   } },

   /* replace201_0 -> 297 in the cache */
   /* replace201_1 -> 286 in the cache */
   /* replace201_2 -> 297 in the cache */
   /* replace201_3 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 297, 286, 297, 298 },
      -1,
   } },

   /* ('imul', 'a', -7) => ('imsubshl_agx', 'a', 1, 'a', 3) */
   /* search202_0 -> 297 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xfffffffffffffff9ull /* -7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 358 },
      -1,
   } },

   /* replace202_0 -> 297 in the cache */
   /* replace202_1 -> 286 in the cache */
   /* replace202_2 -> 297 in the cache */
   /* replace202_3 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 297, 286, 297, 298 },
      -1,
   } },

   /* ('ineg', ('imul(is_used_once)', 'a', 7)) => ('imsubshl_agx', 'a', 1, 'a', 3) */
   /* search203_0_0 -> 297 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x7ull /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 361 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 1,
      { 362 },
      -1,
   } },

   /* replace203_0 -> 297 in the cache */
   /* replace203_1 -> 286 in the cache */
   /* replace203_2 -> 297 in the cache */
   /* replace203_3 -> 298 in the cache */
   /* replace203 -> 360 in the cache */

   /* ('ishl', 'a', 3) => ('imadshl_agx', 0, 1, 'a', 3) */
   /* search204_0 -> 297 in the cache */
   /* search204_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 297, 20 },
      -1,
   } },

   /* replace204_0 -> 285 in the cache */
   /* replace204_1 -> 286 in the cache */
   /* replace204_2 -> 297 in the cache */
   /* replace204_3 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 285, 286, 297, 298 },
      -1,
   } },

   /* ('iadd', 'a', ('ishl(is_used_once)', 'b', 4)) => ('imadshl_agx', 'a', 1, 'b', 4) */
   /* search205_0 -> 274 in the cache */
   /* search205_1_0 -> 275 in the cache */
   /* search205_1_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 275, 26 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 274, 366 },
      -1,
   } },

   /* replace205_0 -> 274 in the cache */
   /* replace205_1 -> 278 in the cache */
   /* replace205_2 -> 275 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x4ull /* 4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 274, 278, 275, 368 },
      -1,
   } },

   /* ('isub', 'a', ('ishl(is_used_once)', 'b', 4)) => ('imsubshl_agx', 'a', 1, 'b', 4) */
   /* search206_0 -> 274 in the cache */
   /* search206_1_0 -> 275 in the cache */
   /* search206_1_1 -> 26 in the cache */
   /* search206_1 -> 366 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 274, 366 },
      -1,
   } },

   /* replace206_0 -> 274 in the cache */
   /* replace206_1 -> 278 in the cache */
   /* replace206_2 -> 275 in the cache */
   /* replace206_3 -> 368 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 274, 278, 275, 368 },
      -1,
   } },

   /* ('ineg', ('ishl(is_used_once)', 'b', 4)) => ('imsubshl_agx', 0, 1, 'b', 4) */
   /* search207_0_0 -> 282 in the cache */
   /* search207_0_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 282, 26 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 372 },
      -1,
   } },

   /* replace207_0 -> 285 in the cache */
   /* replace207_1 -> 286 in the cache */
   /* replace207_2 -> 282 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x4ull /* 4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 285, 286, 282, 374 },
      -1,
   } },

   /* ('imadshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 4), 0) => ('imadshl_agx', 'a', 'b', 'c', 4) */
   /* search208_0 -> 264 in the cache */
   /* search208_1 -> 265 in the cache */
   /* search208_2_0 -> 267 in the cache */
   /* search208_2_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 267, 26 },
      0,
   } },
   /* search208_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 376, 269 },
      -1,
   } },

   /* replace208_0 -> 264 in the cache */
   /* replace208_1 -> 265 in the cache */
   /* replace208_2 -> 267 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_int, { 0x4ull /* 4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 267, 378 },
      -1,
   } },

   /* ('imsubshl_agx', 'a', 'b', ('ishl(is_used_once)', 'c', 4), 0) => ('imsubshl_agx', 'a', 'b', 'c', 4) */
   /* search209_0 -> 264 in the cache */
   /* search209_1 -> 265 in the cache */
   /* search209_2_0 -> 267 in the cache */
   /* search209_2_1 -> 26 in the cache */
   /* search209_2 -> 376 in the cache */
   /* search209_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 376, 269 },
      -1,
   } },

   /* replace209_0 -> 264 in the cache */
   /* replace209_1 -> 265 in the cache */
   /* replace209_2 -> 267 in the cache */
   /* replace209_3 -> 378 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 267, 378 },
      -1,
   } },

   /* ('imadshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 4), 0) => ('imadshl_agx', 'a', 'b', 'c', 4) */
   /* search210_0 -> 264 in the cache */
   /* search210_1 -> 265 in the cache */
   /* search210_2_0 -> 269 in the cache */
   /* search210_2_1 -> 290 in the cache */
   /* search210_2_2 -> 267 in the cache */
   /* search210_2_3 -> 378 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 269, 290, 267, 378 },
      0,
   } },
   /* search210_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 264, 265, 382, 269 },
      -1,
   } },

   /* replace210_0 -> 264 in the cache */
   /* replace210_1 -> 265 in the cache */
   /* replace210_2 -> 267 in the cache */
   /* replace210_3 -> 378 in the cache */
   /* replace210 -> 379 in the cache */

   /* ('imsubshl_agx', 'a', 'b', ('imadshl_agx(is_used_once)', 0, 1, 'c', 4), 0) => ('imsubshl_agx', 'a', 'b', 'c', 4) */
   /* search211_0 -> 264 in the cache */
   /* search211_1 -> 265 in the cache */
   /* search211_2_0 -> 269 in the cache */
   /* search211_2_1 -> 290 in the cache */
   /* search211_2_2 -> 267 in the cache */
   /* search211_2_3 -> 378 in the cache */
   /* search211_2 -> 382 in the cache */
   /* search211_3 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 264, 265, 382, 269 },
      -1,
   } },

   /* replace211_0 -> 264 in the cache */
   /* replace211_1 -> 265 in the cache */
   /* replace211_2 -> 267 in the cache */
   /* replace211_3 -> 378 in the cache */
   /* replace211 -> 381 in the cache */

   /* ('imul', 'a', 17) => ('imadshl_agx', 'a', 1, 'a', 4) */
   /* search212_0 -> 297 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x11ull /* 17 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 385 },
      -1,
   } },

   /* replace212_0 -> 297 in the cache */
   /* replace212_1 -> 286 in the cache */
   /* replace212_2 -> 297 in the cache */
   /* replace212_3 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 297, 286, 297, 374 },
      -1,
   } },

   /* ('imul', 'a', -15) => ('imsubshl_agx', 'a', 1, 'a', 4) */
   /* search213_0 -> 297 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xfffffffffffffff1ull /* -15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 388 },
      -1,
   } },

   /* replace213_0 -> 297 in the cache */
   /* replace213_1 -> 286 in the cache */
   /* replace213_2 -> 297 in the cache */
   /* replace213_3 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imsubshl_agx,
      -1, 0,
      { 297, 286, 297, 374 },
      -1,
   } },

   /* ('ineg', ('imul(is_used_once)', 'a', 15)) => ('imsubshl_agx', 'a', 1, 'a', 4) */
   /* search214_0_0 -> 297 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xfull /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 297, 391 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 1,
      { 392 },
      -1,
   } },

   /* replace214_0 -> 297 in the cache */
   /* replace214_1 -> 286 in the cache */
   /* replace214_2 -> 297 in the cache */
   /* replace214_3 -> 374 in the cache */
   /* replace214 -> 390 in the cache */

   /* ('ishl', 'a', 4) => ('imadshl_agx', 0, 1, 'a', 4) */
   /* search215_0 -> 297 in the cache */
   /* search215_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 297, 26 },
      -1,
   } },

   /* replace215_0 -> 285 in the cache */
   /* replace215_1 -> 286 in the cache */
   /* replace215_2 -> 297 in the cache */
   /* replace215_3 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 285, 286, 297, 374 },
      -1,
   } },

   /* ('iadd', 'a', ('ishl(is_used_once)', 'b', '#c')) => ('imadshl_agx', 'b', ('ishl', 1, 'c'), 'a', 0) */
   /* search216_0 -> 274 in the cache */
   /* search216_1_0 -> 275 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 275, 396 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 274, 397 },
      -1,
   } },

   /* replace216_0 -> 275 in the cache */
   /* replace216_1_0 -> 278 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 278, 399 },
      -1,
   } },
   /* replace216_2 -> 274 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imadshl_agx,
      -1, 0,
      { 275, 400, 274, 401 },
      -1,
   } },

   /* ('ixor', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ixor', 'b', 'd'), ('ixor', 'c', 'd')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 403, 404, 405 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ixor,
      0, 1,
      { 406, 407 },
      -1,
   } },

   /* replace217_0 -> 403 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ixor,
      0, 1,
      { 409, 410 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace217_2_1 -> 410 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ixor,
      1, 1,
      { 412, 410 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 403, 411, 413 },
      -1,
   } },

};

static const nir_search_expression_cond agx_nir_fuse_algebraic_late_expression_cond[] = {
   is_used_once,
};


static const struct transform agx_nir_fuse_algebraic_late_transforms[] = {
   { ~0, ~0, ~0 }, /* Sentinel */

   { 306, 307, 0 },
   { 335, 336, 0 },
   { 364, 365, 0 },
   { 394, 395, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 299, 300, 0 },
   { 302, 303, 0 },
   { 328, 329, 0 },
   { 331, 332, 0 },
   { 356, 357, 0 },
   { 359, 360, 0 },
   { 386, 387, 0 },
   { 389, 390, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 164, 165, 0 },
   { 166, 167, 0 },
   { 168, 169, 0 },
   { 170, 171, 0 },
   { 172, 173, 0 },
   { 175, 176, 0 },
   { 178, 179, 0 },
   { 181, 182, 0 },
   { 184, 185, 0 },
   { 187, 188, 0 },
   { 190, 191, 0 },
   { 193, 194, 0 },
   { 196, 197, 0 },
   { 199, 200, 0 },
   { 202, 203, 0 },
   { 205, 206, 0 },
   { 208, 209, 0 },
   { 211, 212, 0 },
   { 214, 215, 0 },
   { 217, 218, 0 },
   { 220, 221, 0 },
   { 223, 224, 0 },
   { 226, 227, 0 },
   { 229, 230, 0 },
   { 232, 233, 0 },
   { 235, 236, 0 },
   { 238, 239, 0 },
   { 241, 242, 0 },
   { 244, 245, 0 },
   { 247, 248, 0 },
   { 250, 251, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 6, 7, 0 },
   { 12, 13, 0 },
   { 18, 19, 0 },
   { 24, 25, 0 },
   { 30, 31, 0 },
   { 36, 37, 0 },
   { 42, 43, 0 },
   { 48, 49, 0 },
   { 54, 55, 0 },
   { 60, 61, 0 },
   { 66, 67, 0 },
   { 72, 73, 0 },
   { 78, 79, 0 },
   { 84, 85, 0 },
   { 90, 91, 0 },
   { 96, 97, 0 },
   { 101, 102, 0 },
   { 105, 106, 0 },
   { 109, 110, 0 },
   { 113, 114, 0 },
   { 117, 118, 0 },
   { 121, 122, 0 },
   { 125, 126, 0 },
   { 129, 130, 0 },
   { 133, 134, 0 },
   { 137, 138, 0 },
   { 141, 142, 0 },
   { 145, 146, 0 },
   { 149, 150, 0 },
   { 153, 154, 0 },
   { 157, 158, 0 },
   { 161, 162, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 277, 279, 0 },
   { 309, 311, 0 },
   { 338, 340, 0 },
   { 367, 369, 0 },
   { 398, 402, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 268, 270, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 268, 270, 0 },
   { 277, 279, 0 },
   { 309, 311, 0 },
   { 338, 340, 0 },
   { 367, 369, 0 },
   { 398, 402, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 268, 270, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 280, 281, 0 },
   { 312, 313, 0 },
   { 341, 342, 0 },
   { 370, 371, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 272, 273, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 272, 273, 0 },
   { 280, 281, 0 },
   { 312, 313, 0 },
   { 341, 342, 0 },
   { 370, 371, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 284, 287, 0 },
   { 315, 317, 0 },
   { 344, 345, 0 },
   { 373, 375, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 305, 303, 0 },
   { 334, 332, 0 },
   { 363, 360, 0 },
   { 393, 390, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 289, 291, 0 },
   { 319, 321, 0 },
   { 347, 349, 0 },
   { 377, 379, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 295, 291, 0 },
   { 325, 321, 0 },
   { 353, 349, 0 },
   { 383, 379, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 289, 291, 0 },
   { 319, 321, 0 },
   { 347, 349, 0 },
   { 377, 379, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 295, 291, 0 },
   { 325, 321, 0 },
   { 353, 349, 0 },
   { 383, 379, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 292, 293, 0 },
   { 322, 323, 0 },
   { 350, 351, 0 },
   { 380, 381, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 296, 293, 0 },
   { 326, 323, 0 },
   { 354, 351, 0 },
   { 384, 381, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 408, 414, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 260, 263, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 260, 263, 0 },
   { 277, 279, 0 },
   { 309, 311, 0 },
   { 338, 340, 0 },
   { 367, 369, 0 },
   { 398, 402, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 260, 263, 0 },
   { 268, 270, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

};

static const struct per_op_table agx_nir_fuse_algebraic_late_pass_op_table[nir_num_search_ops] = {
   [nir_op_ior] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         1,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 3,
      .table = (const uint16_t []) {
      
         0,
         0,
         0,
         0,
         0,
         10,
         0,
         10,
         0,
      },
   },
   [nir_op_ushr] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         2,
         3,
         2,
         3,
      },
   },
   [nir_op_ishl] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         0,
         4,
         0,
         4,
      },
   },
   [nir_op_iand] = {
      .filter = (const uint16_t []) {
         0,
         1,
         2,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 3,
      .table = (const uint16_t []) {
      
         0,
         0,
         0,
         0,
         0,
         9,
         0,
         9,
         0,
      },
   },
   [nir_op_iadd] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         1,
         2,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         3,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 4,
      .table = (const uint16_t []) {
      
         0,
         11,
         12,
         27,
         11,
         11,
         13,
         28,
         12,
         13,
         14,
         29,
         27,
         28,
         29,
         27,
      },
   },
   [nir_op_imul] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         5,
         6,
         6,
         6,
      },
   },
   [nir_op_isub] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         1,
         2,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 3,
      .table = (const uint16_t []) {
      
         0,
         15,
         0,
         0,
         15,
         0,
         16,
         17,
         16,
      },
   },
   [nir_op_ineg] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         1,
         0,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 3,
      .table = (const uint16_t []) {
      
         0,
         18,
         19,
      },
   },
   [nir_op_imadshl_agx] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         2,
         0,
         0,
         3,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         3,
         3,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 4,
      .table = (const uint16_t []) {
      
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         7,
         0,
         0,
         0,
         7,
         0,
         0,
         0,
         22,
         0,
         0,
         0,
         23,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         20,
         0,
         0,
         0,
         21,
         0,
         0,
      },
   },
   [nir_op_imsubshl_agx] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         2,
         0,
         0,
         3,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         3,
         3,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 4,
      .table = (const uint16_t []) {
      
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         24,
         0,
         0,
         0,
         25,
         0,
         0,
      },
   },
   [nir_op_ixor] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         2,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 3,
      .table = (const uint16_t []) {
      
         0,
         0,
         0,
         0,
         0,
         26,
         0,
         26,
         0,
      },
   },
   [nir_op_bcsel] = {
      .filter = (const uint16_t []) {
         0,
         1,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         0,
         0,
         0,
         8,
         0,
         0,
         0,
         8,
      },
   },
};

/* Mapping from state index to offset in transforms (0 being no transforms) */
static const uint16_t agx_nir_fuse_algebraic_late_transform_offsets[] = {
   0,
   0,
   0,
   0,
   1,
   0,
   6,
   0,
   0,
   15,
   47,
   80,
   86,
   88,
   95,
   97,
   102,
   104,
   110,
   115,
   120,
   125,
   130,
   135,
   140,
   145,
   150,
   152,
   154,
   161,
};

static const nir_algebraic_table agx_nir_fuse_algebraic_late_table = {
   .transforms = agx_nir_fuse_algebraic_late_transforms,
   .transform_offsets = agx_nir_fuse_algebraic_late_transform_offsets,
   .pass_op_table = agx_nir_fuse_algebraic_late_pass_op_table,
   .values = agx_nir_fuse_algebraic_late_values,
   .expression_cond = agx_nir_fuse_algebraic_late_expression_cond,
   .variable_cond = NULL,
};

bool
agx_nir_fuse_algebraic_late(
   nir_shader *shader
) {
   bool progress = false;
   bool condition_flags[1];
   const nir_shader_compiler_options *options = shader->options;
   const shader_info *info = &shader->info;
   (void) options;
   (void) info;

   STATIC_ASSERT(415 == ARRAY_SIZE(agx_nir_fuse_algebraic_late_values));
   condition_flags[0] = true;

   nir_foreach_function_impl(impl, shader) {
     progress |= nir_algebraic_impl(impl, condition_flags, &agx_nir_fuse_algebraic_late_table);
   }

   return progress;
}

