/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Options for LLDB command line commands.                                    *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: Options.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// Options for alias
#ifdef LLDB_OPTIONS_alias
constexpr static OptionDefinition g_alias_options[] = {
  {LLDB_OPT_SET_ALL, false, "help", 'h', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeHelpText].enum_values, CompletionType::eNoCompletion, eArgTypeHelpText, "Help text for this command"},
  {LLDB_OPT_SET_ALL, false, "long-help", 'H', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeHelpText].enum_values, CompletionType::eNoCompletion, eArgTypeHelpText, "Long help text for this command"},
};
#undef LLDB_OPTIONS_alias
#endif // alias command

// Options for breakpoint access
#ifdef LLDB_OPTIONS_breakpoint_access
constexpr static OptionDefinition g_breakpoint_access_options[] = {
  {LLDB_OPT_SET_3, false, "allow-delete", 'D', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Determines whether the breakpoint can be deleted by name or when all breakpoints are deleted."},
  {LLDB_OPT_SET_2, false, "allow-disable", 'A', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Determines whether the breakpoint can be disabled by name or when all breakpoints are disabled."},
  {LLDB_OPT_SET_1, false, "allow-list", 'L', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Determines whether the breakpoint will show up in break list if not referred to explicitly."},
};
#undef LLDB_OPTIONS_breakpoint_access
#endif // breakpoint access command

// Options for breakpoint clear
#ifdef LLDB_OPTIONS_breakpoint_clear
constexpr static OptionDefinition g_breakpoint_clear_options[] = {
  {LLDB_OPT_SET_1, false, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, eSourceFileCompletion, eArgTypeFilename, "Specify the breakpoint by source location in this particular file."},
  {LLDB_OPT_SET_1, true, "line", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLineNum].enum_values, CompletionType::eNoCompletion, eArgTypeLineNum, "Specify the breakpoint by source location at this particular line."},
};
#undef LLDB_OPTIONS_breakpoint_clear
#endif // breakpoint clear command

// Options for breakpoint command add
#ifdef LLDB_OPTIONS_breakpoint_command_add
constexpr static OptionDefinition g_breakpoint_command_add_options[] = {
  {LLDB_OPT_SET_ALL, false, "dummy-breakpoints", 'D', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Sets Dummy breakpoints - i.e. breakpoints set before a file is provided, which prime new targets."},
  {LLDB_OPT_SET_1, false, "one-liner", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeOneLiner].enum_values, CompletionType::eNoCompletion, eArgTypeOneLiner, "Specify a one-line breakpoint command inline. Be sure to surround it with quotes."},
  {LLDB_OPT_SET_ALL, false, "script-type", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeScriptLang].enum_values, CompletionType::eNoCompletion, eArgTypeScriptLang, "Specify the language for the commands - if none is specified, the lldb command interpreter will be used."},
  {LLDB_OPT_SET_ALL, false, "stop-on-error", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Specify whether breakpoint command execution should terminate on error."},
};
#undef LLDB_OPTIONS_breakpoint_command_add
#endif // breakpoint command add command

// Options for breakpoint command delete
#ifdef LLDB_OPTIONS_breakpoint_command_delete
constexpr static OptionDefinition g_breakpoint_command_delete_options[] = {
  {LLDB_OPT_SET_1, false, "dummy-breakpoints", 'D', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Delete commands from Dummy breakpoints - i.e. breakpoints set before a file is provided, which prime new targets."},
};
#undef LLDB_OPTIONS_breakpoint_command_delete
#endif // breakpoint command delete command

// Options for breakpoint delete
#ifdef LLDB_OPTIONS_breakpoint_delete
constexpr static OptionDefinition g_breakpoint_delete_options[] = {
  {LLDB_OPT_SET_1, false, "disabled", 'd', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Delete all breakpoints which are currently disabled.  When using the disabled option any breakpoints listed on the command line are EXCLUDED from deletion."},
  {LLDB_OPT_SET_1, false, "dummy-breakpoints", 'D', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Delete Dummy breakpoints - i.e. breakpoints set before a file is provided, which prime new targets."},
  {LLDB_OPT_SET_1, false, "force", 'f', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Delete all breakpoints without querying for confirmation."},
};
#undef LLDB_OPTIONS_breakpoint_delete
#endif // breakpoint delete command

// Options for breakpoint dummy
#ifdef LLDB_OPTIONS_breakpoint_dummy
constexpr static OptionDefinition g_breakpoint_dummy_options[] = {
  {LLDB_OPT_SET_1, false, "dummy-breakpoints", 'D', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Act on Dummy breakpoints - i.e. breakpoints set before a file is provided, which prime new targets."},
};
#undef LLDB_OPTIONS_breakpoint_dummy
#endif // breakpoint dummy command

// Options for breakpoint list
#ifdef LLDB_OPTIONS_breakpoint_list
constexpr static OptionDefinition g_breakpoint_list_options[] = {
  {LLDB_OPT_SET_1, false, "brief", 'b', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Give a brief description of the breakpoint (no location info)."},
  {LLDB_OPT_SET_ALL, false, "dummy-breakpoints", 'D', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "List Dummy breakpoints - i.e. breakpoints set before a file is provided, which prime new targets."},
  {LLDB_OPT_SET_2, false, "full", 'f', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Give a full description of the breakpoint and its locations."},
  {LLDB_OPT_SET_ALL, false, "internal", 'i', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show debugger internal breakpoints"},
  {LLDB_OPT_SET_3, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Explain everything we know about the breakpoint (for debugging debugger bugs)."},
};
#undef LLDB_OPTIONS_breakpoint_list
#endif // breakpoint list command

// Options for breakpoint modify
#ifdef LLDB_OPTIONS_breakpoint_modify
constexpr static OptionDefinition g_breakpoint_modify_options[] = {
  {LLDB_OPT_SET_1, false, "auto-continue", 'G', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "The breakpoint will auto-continue after running its commands."},
  {LLDB_OPT_SET_4, false, "command", 'C', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCommand].enum_values, CompletionType::eNoCompletion, eArgTypeCommand, "A command to run when the breakpoint is hit, can be provided more than once, the commands will be run in left-to-right order."},
  {LLDB_OPT_SET_1, false, "condition", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeExpression].enum_values, CompletionType::eNoCompletion, eArgTypeExpression, "The breakpoint stops only if this condition expression evaluates to true."},
  {LLDB_OPT_SET_1, false, "condition-language", 'Y', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "Specifies the Language to use when executing the breakpoint's condition expression."},
  {LLDB_OPT_SET_3, false, "disable", 'd', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Disable the breakpoint."},
  {LLDB_OPT_SET_2, false, "enable", 'e', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Enable the breakpoint."},
  {LLDB_OPT_SET_1, false, "ignore-count", 'i', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCount].enum_values, CompletionType::eNoCompletion, eArgTypeCount, "Set the number of times this breakpoint is skipped before stopping."},
  {LLDB_OPT_SET_1, false, "one-shot", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "The breakpoint is deleted the first time it stop causes a stop."},
  {LLDB_OPT_SET_1, false, "queue-name", 'q', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeQueueName].enum_values, CompletionType::eNoCompletion, eArgTypeQueueName, "The breakpoint stops only for threads in the queue whose name is given by this argument."},
  {LLDB_OPT_SET_1, false, "thread-id", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeThreadID].enum_values, CompletionType::eNoCompletion, eArgTypeThreadID, "The breakpoint stops only for the thread whose TID matches this argument.  The token 'current' resolves to the current thread's ID."},
  {LLDB_OPT_SET_1, false, "thread-index", 'x', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeThreadIndex].enum_values, CompletionType::eNoCompletion, eArgTypeThreadIndex, "The breakpoint stops only for the thread whose index matches this argument."},
  {LLDB_OPT_SET_1, false, "thread-name", 'T', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeThreadName].enum_values, CompletionType::eNoCompletion, eArgTypeThreadName, "The breakpoint stops only for the thread whose thread name matches this argument."},
};
#undef LLDB_OPTIONS_breakpoint_modify
#endif // breakpoint modify command

// Options for breakpoint name
#ifdef LLDB_OPTIONS_breakpoint_name
constexpr static OptionDefinition g_breakpoint_name_options[] = {
  {LLDB_OPT_SET_2, false, "breakpoint-id", 'B', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBreakpointID].enum_values, CompletionType::eNoCompletion, eArgTypeBreakpointID, "Specify a breakpoint ID to use."},
  {LLDB_OPT_SET_3, false, "dummy-breakpoints", 'D', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Operate on Dummy breakpoints - i.e. breakpoints set before a file is provided, which prime new targets."},
  {LLDB_OPT_SET_4, false, "help-string", 'H', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeNone].enum_values, CompletionType::eNoCompletion, eArgTypeNone, "A help string describing the purpose of this name."},
  {LLDB_OPT_SET_1, false, "name", 'N', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBreakpointName].enum_values, CompletionType::eNoCompletion, eArgTypeBreakpointName, "Specifies a breakpoint name to use."},
};
#undef LLDB_OPTIONS_breakpoint_name
#endif // breakpoint name command

// Options for breakpoint read
#ifdef LLDB_OPTIONS_breakpoint_read
constexpr static OptionDefinition g_breakpoint_read_options[] = {
  {LLDB_OPT_SET_ALL, false, "breakpoint-name", 'N', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBreakpointName].enum_values, CompletionType::eNoCompletion, eArgTypeBreakpointName, "Only read in breakpoints with this name."},
  {LLDB_OPT_SET_ALL, true, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, eDiskFileCompletion, eArgTypeFilename, "The file from which to read the breakpoints."},
};
#undef LLDB_OPTIONS_breakpoint_read
#endif // breakpoint read command

// Options for breakpoint set
#ifdef LLDB_OPTIONS_breakpoint_set
constexpr static OptionDefinition g_breakpoint_set_options[] = {
  {LLDB_OPT_SET_2, true, "address", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Set the breakpoint at the specified address.  If the address maps uniquely to a particular binary, then the address will be converted to a \22file\22address, so that the breakpoint will track that binary+offset no matter where the binary eventually loads.  Alternately, if you also specify the module - with the -s option - then the address will be treated as a file address in that module, and resolved accordingly.  Again, this will allow lldb to track that offset on subsequent reloads.  The module need not have been loaded at the time you specify this breakpoint, and will get resolved when the module is loaded."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6 | LLDB_OPT_SET_7 | LLDB_OPT_SET_8 | LLDB_OPT_SET_12, false, "address-slide", 'R', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddress].enum_values, CompletionType::eNoCompletion, eArgTypeAddress, "Add the specified offset to whatever address(es) the breakpoint resolves to. At present this applies the offset directly as given, and doesn't try to align it to instruction boundaries."},
  {LLDB_OPT_SET_9, false, "all-files", 'A', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "All files are searched for source pattern matches."},
  {LLDB_OPT_SET_8, true, "basename", 'b', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFunctionName].enum_values, eSymbolCompletion, eArgTypeFunctionName, "Set the breakpoint by function basename (C++ namespaces and arguments will be ignored).  Can be repeated multiple times to make one breakpoint for multiple symbols."},
  {LLDB_OPT_SET_ALL, false, "breakpoint-name", 'N', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBreakpointName].enum_values, CompletionType::eNoCompletion, eArgTypeBreakpointName, "Adds this to the list of names for this breakpoint."},
  {LLDB_OPT_SET_1, false, "column", 'u', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeColumnNum].enum_values, CompletionType::eNoCompletion, eArgTypeColumnNum, "Specifies the column number on which to set this breakpoint."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6 | LLDB_OPT_SET_7 | LLDB_OPT_SET_8 | LLDB_OPT_SET_9 | LLDB_OPT_SET_11, false, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, eSourceFileCompletion, eArgTypeFilename, "Specifies the source file in which to set this breakpoint.  Note, by default lldb only looks for files that are #included if they use the standard include file extensions.  To set breakpoints on .c/.cpp/.m/.mm files that are #included, set target.inline-breakpoint-strategy to \22always\22."},
  {LLDB_OPT_SET_12, true, "joint-specifier", 'y', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFileLineColumn].enum_values, eSourceFileCompletion, eArgTypeFileLineColumn, "A specifier in the form filename:line[:column] for setting file & line breakpoints."},
  {LLDB_OPT_SET_4, true, "fullname", 'F', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFullName].enum_values, eSymbolCompletion, eArgTypeFullName, "Set the breakpoint by fully qualified function names. For C++ this means namespaces and all arguments, and for Objective-C this means a full function prototype with class and selector.  Can be repeated multiple times to make one breakpoint for multiple names."},
  {LLDB_OPT_SET_7, true, "func-regex", 'r', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeRegularExpression].enum_values, CompletionType::eNoCompletion, eArgTypeRegularExpression, "Set the breakpoint by function name, evaluating a regular-expression to find the function name(s)."},
  {LLDB_OPT_SET_ALL, false, "hardware", 'H', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Require the breakpoint to use hardware breakpoints."},
  {LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6 | LLDB_OPT_SET_7 | LLDB_OPT_SET_8, false, "language", 'L', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "Specifies the Language to use when interpreting the breakpoint's expression (note: currently only implemented for setting breakpoints on identifiers). If not set the target.language setting is used."},
  {LLDB_OPT_SET_10, true, "language-exception", 'E', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "Set the breakpoint on exceptions thrown by the specified language (without options, on throw but not catch.)"},
  {LLDB_OPT_SET_1, true, "line", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLineNum].enum_values, CompletionType::eNoCompletion, eArgTypeLineNum, "Specifies the line number on which to set this breakpoint."},
  {LLDB_OPT_SET_6, true, "method", 'M', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeMethod].enum_values, CompletionType::eNoCompletion, eArgTypeMethod, "Set the breakpoint by C++ method names.  Can be repeated multiple times to make one breakpoint for multiple methods."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_9 | LLDB_OPT_SET_12, false, "move-to-nearest-code", 'm', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Move breakpoints to nearest code. If not set the target.move-to-nearest-code setting is used."},
  {LLDB_OPT_SET_3, true, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFunctionName].enum_values, eSymbolCompletion, eArgTypeFunctionName, "Set the breakpoint by function name.  Can be repeated multiple times to make one breakpoint for multiple names."},
  {LLDB_OPT_SET_10, false, "on-catch", 'h', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Set the breakpoint on exception catcH."},
  {LLDB_OPT_SET_10, false, "on-throw", 'w', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Set the breakpoint on exception throW."},
  {LLDB_OPT_SET_5, true, "selector", 'S', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeSelector].enum_values, CompletionType::eNoCompletion, eArgTypeSelector, "Set the breakpoint by Objective-C selector name.  Can be repeated multiple times to make one breakpoint for multiple Selectors."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6 | LLDB_OPT_SET_7 | LLDB_OPT_SET_8 | LLDB_OPT_SET_9 | LLDB_OPT_SET_11 | LLDB_OPT_SET_12, false, "shlib", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeShlibName].enum_values, eModuleCompletion, eArgTypeShlibName, "Set the breakpoint only in this shared library.  Can repeat this option multiple times to specify multiple shared libraries."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6 | LLDB_OPT_SET_7 | LLDB_OPT_SET_8 | LLDB_OPT_SET_12, false, "skip-prologue", 'K', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "sKip the prologue if the breakpoint is at the beginning of a function. If not set the target.skip-prologue setting is used."},
  {LLDB_OPT_SET_9, true, "source-pattern-regexp", 'p', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeRegularExpression].enum_values, CompletionType::eNoCompletion, eArgTypeRegularExpression, "Set the breakpoint by specifying a regular expression which is matched against the source text in a source file or files specified with the -f can be specified more than once.  If no source files are specified, uses the current \22default source file\22.  If you want to match against all source files, pass the \22--all-files\22 option."},
  {LLDB_OPT_SET_9, false, "source-regexp-function", 'X', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFunctionName].enum_values, eSymbolCompletion, eArgTypeFunctionName, "When used with '-p' limits the source regex to source contained in the named functions.  Can be repeated multiple times."},
};
#undef LLDB_OPTIONS_breakpoint_set
#endif // breakpoint set command

// Options for breakpoint write
#ifdef LLDB_OPTIONS_breakpoint_write
constexpr static OptionDefinition g_breakpoint_write_options[] = {
  {LLDB_OPT_SET_ALL, false, "append", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Append to saved breakpoints file if it exists."},
  {LLDB_OPT_SET_ALL, true, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, eDiskFileCompletion, eArgTypeFilename, "The file into which to write the breakpoints."},
};
#undef LLDB_OPTIONS_breakpoint_write
#endif // breakpoint write command

// Options for container add
#ifdef LLDB_OPTIONS_container_add
constexpr static OptionDefinition g_container_add_options[] = {
  {LLDB_OPT_SET_ALL, false, "help", 'h', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeHelpText].enum_values, CompletionType::eNoCompletion, eArgTypeHelpText, "Help text for this command"},
  {LLDB_OPT_SET_ALL, false, "long-help", 'H', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeHelpText].enum_values, CompletionType::eNoCompletion, eArgTypeHelpText, "Long help text for this command"},
  {LLDB_OPT_SET_1, false, "overwrite", 'o', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Overwrite an existing command at this node."},
};
#undef LLDB_OPTIONS_container_add
#endif // container add command

// Options for diagnostics dump
#ifdef LLDB_OPTIONS_diagnostics_dump
constexpr static OptionDefinition g_diagnostics_dump_options[] = {
  {LLDB_OPT_SET_1, false, "directory", 'd', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePath].enum_values, CompletionType::eNoCompletion, eArgTypePath, "Dump the diagnostics to the given directory."},
};
#undef LLDB_OPTIONS_diagnostics_dump
#endif // diagnostics dump command

// Options for disassemble
#ifdef LLDB_OPTIONS_disassemble
constexpr static OptionDefinition g_disassemble_options[] = {
  {LLDB_OPT_SET_7, false, "address", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Disassemble function containing this address."},
  {LLDB_OPT_SET_ALL, false, "arch", 'A', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeArchitecture].enum_values, CompletionType::eNoCompletion, eArgTypeArchitecture, "Specify the architecture to use from cross disassembly."},
  {LLDB_OPT_SET_ALL, false, "bytes", 'b', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show opcode bytes when disassembling."},
  {LLDB_OPT_SET_ALL, false, "context", 'C', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeNumLines].enum_values, CompletionType::eNoCompletion, eArgTypeNumLines, "Number of context lines of source to show."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_7, false, "count", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeNumLines].enum_values, CompletionType::eNoCompletion, eArgTypeNumLines, "Number of instructions to display."},
  {LLDB_OPT_SET_ALL, false, "cpu", 'X', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCPUName].enum_values, CompletionType::eNoCompletion, eArgTypeCPUName, "Override the CPU for disassembling."},
  {LLDB_OPT_SET_1, false, "end-address", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Address at which to end disassembling."},
  {LLDB_OPT_SET_ALL, false, "features", 'Y', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCPUFeatures].enum_values, CompletionType::eNoCompletion, eArgTypeCPUFeatures, "Specify additional CPU features for disassembling."},
  {LLDB_OPT_SET_ALL, false, "flavor", 'F', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeDisassemblyFlavor].enum_values, CompletionType::eNoCompletion, eArgTypeDisassemblyFlavor, "Name of the disassembly flavor you want to use. Currently the only valid options are default, and for Intel architectures, att and intel."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_7, false, "force", '\x01', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Force disassembly of large functions."},
  {LLDB_OPT_SET_4, false, "frame", 'f', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Disassemble from the start of the current frame's function."},
  {LLDB_OPT_SET_ALL, false, "kind", 'k', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show instruction control flow kind. Refer to the enum `InstructionControlFlowKind` for a list of control flow kind. As an important note, far jumps, far calls and far returns often indicate calls to and from kernel."},
  {LLDB_OPT_SET_6, false, "line", 'l', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Disassemble the current frame's current source line instructions if there is debug line table information, else disassemble around the pc."},
  {LLDB_OPT_SET_ALL, false, "mixed", 'm', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Enable mixed source and assembly display."},
  {LLDB_OPT_SET_3, false, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFunctionName].enum_values, eSymbolCompletion, eArgTypeFunctionName, "Disassemble entire contents of the given function name."},
  {LLDB_OPT_SET_5, false, "pc", 'p', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Disassemble around the current pc."},
  {LLDB_OPT_SET_ALL, false, "plugin", 'P', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePlugin].enum_values, CompletionType::eNoCompletion, eArgTypePlugin, "Name of the disassembler plugin you want to use."},
  {LLDB_OPT_SET_ALL, false, "raw", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Print raw disassembly with no symbol information."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, true, "start-address", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Address at which to start disassembling."},
};
#undef LLDB_OPTIONS_disassemble
#endif // disassemble command

// Options for expression
#ifdef LLDB_OPTIONS_expression
constexpr static OptionDefinition g_expression_options[] = {
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "all-threads", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Should we run all threads if the execution doesn't complete on one thread."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "allow-jit", 'j', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Controls whether the expression can fall back to being JITted if it's not supported by the interpreter (defaults to true)."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "apply-fixits", 'X', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "If true, simple fix-it hints will be automatically applied to the expression."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "debug", 'g', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "When specified, debug the JIT code by setting a breakpoint on the first instruction and forcing breakpoints to not be ignored (-i0) and no unwinding to happen on error (-u0)."},
  {LLDB_OPT_SET_1, false, "description-verbosity", 'v', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeDescriptionVerbosity].enum_values, CompletionType::eNoCompletion, eArgTypeDescriptionVerbosity, "How verbose should the output of this expression be, if the object description is asked for."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "ignore-breakpoints", 'i', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Ignore breakpoint hits while running expressions"},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_3, false, "language", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "Specifies the Language to use when parsing the expression.  If not set the target.language setting is used."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "timeout", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "Timeout value (in microseconds) for running the expression."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "top-level", 'p', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Interpret the expression as a complete translation unit, without injecting it into the local context.  Allows declaration of persistent, top-level entities without a $ prefix."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "unwind-on-error", 'u', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Clean up program state if the expression causes a crash, or raises a signal. Note, unlike gdb hitting a breakpoint is controlled by another option (-i)."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "persistent-result", '\x01', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Persist expression result in a variable for subsequent use. Expression results will be labeled with $-prefixed variables, e.g. $0, $1, etc."},
};
#undef LLDB_OPTIONS_expression
#endif // expression command

// Options for frame diag
#ifdef LLDB_OPTIONS_frame_diag
constexpr static OptionDefinition g_frame_diag_options[] = {
  {LLDB_OPT_SET_1, false, "address", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddress].enum_values, CompletionType::eNoCompletion, eArgTypeAddress, "An address to diagnose."},
  {LLDB_OPT_SET_1, false, "offset", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeOffset].enum_values, CompletionType::eNoCompletion, eArgTypeOffset, "An optional offset.  Requires --register."},
  {LLDB_OPT_SET_1, false, "register", 'r', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeRegisterName].enum_values, CompletionType::eNoCompletion, eArgTypeRegisterName, "A register to diagnose."},
};
#undef LLDB_OPTIONS_frame_diag
#endif // frame diag command

// Options for frame recognizer add
#ifdef LLDB_OPTIONS_frame_recognizer_add
constexpr static OptionDefinition g_frame_recognizer_add_options[] = {
  {LLDB_OPT_SET_ALL, false, "first-instruction-only", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "If true, only apply this recognizer to frames whose PC currently points to the first instruction of the specified function. If false, the recognizer will always be applied, regardless of the current position within the specified function. The implementer should keep in mind that some features, e.g. accessing function argument values via $arg<N>, are not guaranteed to work reliably in this case, so extra care must be taken to make the recognizer operate correctly. Defaults to true."},
  {LLDB_OPT_SET_ALL, false, "function", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, eSymbolCompletion, eArgTypeName, "Name of the function that this recognizer applies to. Can be specified more than once except if -x|--regex is provided."},
  {LLDB_OPT_SET_2, false, "python-class", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePythonClass].enum_values, CompletionType::eNoCompletion, eArgTypePythonClass, "Give the name of a Python class to use for this frame recognizer."},
  {LLDB_OPT_SET_ALL, false, "regex", 'x', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Function name and module name are actually regular expressions."},
  {LLDB_OPT_SET_ALL, false, "shlib", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeShlibName].enum_values, eModuleCompletion, eArgTypeShlibName, "Name of the module or shared library that this recognizer applies to."},
};
#undef LLDB_OPTIONS_frame_recognizer_add
#endif // frame recognizer add command

// Options for frame select
#ifdef LLDB_OPTIONS_frame_select
constexpr static OptionDefinition g_frame_select_options[] = {
  {LLDB_OPT_SET_1, false, "relative", 'r', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeOffset].enum_values, CompletionType::eNoCompletion, eArgTypeOffset, "A relative frame index offset from the current frame index."},
};
#undef LLDB_OPTIONS_frame_select
#endif // frame select command

// Options for help
#ifdef LLDB_OPTIONS_help
constexpr static OptionDefinition g_help_options[] = {
  {LLDB_OPT_SET_ALL, false, "hide-aliases", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Hide aliases in the command list."},
  {LLDB_OPT_SET_ALL, false, "hide-user-commands", 'u', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Hide user-defined commands from the list."},
  {LLDB_OPT_SET_ALL, false, "show-hidden-commands", 'h', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Include commands prefixed with an underscore."},
};
#undef LLDB_OPTIONS_help
#endif // help command

// Options for history
#ifdef LLDB_OPTIONS_history
constexpr static OptionDefinition g_history_options[] = {
  {LLDB_OPT_SET_2, false, "clear", 'C', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Clears the current command history."},
  {LLDB_OPT_SET_1, false, "count", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "How many history commands to print."},
  {LLDB_OPT_SET_1, false, "end-index", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "Index at which to stop printing history commands."},
  {LLDB_OPT_SET_1, false, "start-index", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "Index at which to start printing history commands (or end to mean tail mode)."},
};
#undef LLDB_OPTIONS_history
#endif // history command

// Options for log dump
#ifdef LLDB_OPTIONS_log_dump
constexpr static OptionDefinition g_log_dump_options[] = {
  {LLDB_OPT_SET_1, false, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, CompletionType::eNoCompletion, eArgTypeFilename, "Set the destination file to dump to."},
};
#undef LLDB_OPTIONS_log_dump
#endif // log dump command

// Options for log enable
#ifdef LLDB_OPTIONS_log_enable
constexpr static OptionDefinition g_log_enable_options[] = {
  {LLDB_OPT_SET_1, false, "append", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Append to the log file instead of overwriting."},
  {LLDB_OPT_SET_1, false, "buffer", 'b', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "Set the log to be buffered, using the specified buffer size, if supported by the log handler."},
  {LLDB_OPT_SET_1, false, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, CompletionType::eNoCompletion, eArgTypeFilename, "Set the destination file to log to."},
  {LLDB_OPT_SET_1, false, "file-function", 'F', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Prepend the names of files and function that generate the logs."},
  {LLDB_OPT_SET_1, false, "log-handler", 'h', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLogHandler].enum_values, CompletionType::eNoCompletion, eArgTypeLogHandler, "Specify a log handler which determines where log messages are written."},
  {LLDB_OPT_SET_1, false, "pid-tid", 'p', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Prepend all log lines with the process and thread ID that generates the log line."},
  {LLDB_OPT_SET_1, false, "sequence", 's', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Prepend all log lines with an increasing integer sequence id."},
  {LLDB_OPT_SET_1, false, "stack", 'S', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Append a stack backtrace to each log line."},
  {LLDB_OPT_SET_1, false, "thread-name", 'n', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Prepend all log lines with the thread name for the thread that generates the log line."},
  {LLDB_OPT_SET_1, false, "timestamp", 'T', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Prepend all log lines with a timestamp."},
  {LLDB_OPT_SET_1, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Enable verbose logging."},
};
#undef LLDB_OPTIONS_log_enable
#endif // log enable command

// Options for memory find
#ifdef LLDB_OPTIONS_memory_find
constexpr static OptionDefinition g_memory_find_options[] = {
  {LLDB_OPT_SET_ALL, false, "count", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCount].enum_values, CompletionType::eNoCompletion, eArgTypeCount, "How many times to perform the search."},
  {LLDB_OPT_SET_ALL, false, "dump-offset", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeOffset].enum_values, CompletionType::eNoCompletion, eArgTypeOffset, "When dumping memory for a match, an offset from the match location to start dumping from."},
  {LLDB_OPT_SET_1, true, "expression", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeExpression].enum_values, CompletionType::eNoCompletion, eArgTypeExpression, "Evaluate an expression to obtain a byte pattern."},
  {LLDB_OPT_SET_2, true, "string", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "Use text to find a byte pattern."},
};
#undef LLDB_OPTIONS_memory_find
#endif // memory find command

// Options for memory read
#ifdef LLDB_OPTIONS_memory_read
constexpr static OptionDefinition g_memory_read_options[] = {
  {LLDB_OPT_SET_2, false, "binary", 'b', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "If true, memory will be saved as binary. If false, the memory is saved save as an ASCII dump that uses the format, size, count and number per line settings."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_3, false, "force", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Necessary if reading over target.max-memory-read-size bytes."},
  {LLDB_OPT_SET_4, false, "language", 'x', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "The language of the type to view memory as."},
  {LLDB_OPT_SET_1, false, "num-per-line", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeNumberPerLine].enum_values, CompletionType::eNoCompletion, eArgTypeNumberPerLine, "The number of items per line to display."},
  {LLDB_OPT_SET_3, false, "offset", 'E', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCount].enum_values, CompletionType::eNoCompletion, eArgTypeCount, "How many elements of the specified type to skip before starting to display data."},
  {LLDB_OPT_SET_3 | LLDB_OPT_SET_4, true, "type", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "The name of a type to view memory as."},
};
#undef LLDB_OPTIONS_memory_read
#endif // memory read command

// Options for memory region
#ifdef LLDB_OPTIONS_memory_region
constexpr static OptionDefinition g_memory_region_options[] = {
  {LLDB_OPT_SET_2, true, "all", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show all memory regions. This is equivalent to starting from address 0 and repeating the command. Unmapped areas are included."},
};
#undef LLDB_OPTIONS_memory_region
#endif // memory region command

// Options for memory tag write
#ifdef LLDB_OPTIONS_memory_tag_write
constexpr static OptionDefinition g_memory_tag_write_options[] = {
  {LLDB_OPT_SET_1, false, "end-addr", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Set tags for start address to end-addr, repeating tags as needed to cover the range. (instead of calculating the range from the number of tags given)"},
};
#undef LLDB_OPTIONS_memory_tag_write
#endif // memory tag write command

// Options for memory write
#ifdef LLDB_OPTIONS_memory_write
constexpr static OptionDefinition g_memory_write_options[] = {
  {LLDB_OPT_SET_1, true, "infile", 'i', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, CompletionType::eNoCompletion, eArgTypeFilename, "Write memory using the contents of a file."},
  {LLDB_OPT_SET_1, false, "offset", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeOffset].enum_values, CompletionType::eNoCompletion, eArgTypeOffset, "Start writing bytes from an offset within the input file."},
};
#undef LLDB_OPTIONS_memory_write
#endif // memory write command

// Options for permissions
#ifdef LLDB_OPTIONS_permissions
constexpr static OptionDefinition g_permissions_options[] = {
  {LLDB_OPT_SET_ALL, false, "group-exec", 'X', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allow group to execute."},
  {LLDB_OPT_SET_ALL, false, "group-read", 'R', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allow group to read."},
  {LLDB_OPT_SET_ALL, false, "group-write", 'W', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allow group to write."},
  {LLDB_OPT_SET_ALL, false, "permissions-string", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePermissionsString].enum_values, CompletionType::eNoCompletion, eArgTypePermissionsString, "Give out the string value for permissions (e.g. rwxr-xr--)."},
  {LLDB_OPT_SET_ALL, false, "permissions-value", 'v', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePermissionsNumber].enum_values, CompletionType::eNoCompletion, eArgTypePermissionsNumber, "Give out the numeric value for permissions (e.g. 757)"},
  {LLDB_OPT_SET_ALL, false, "user-exec", 'x', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allow user to execute."},
  {LLDB_OPT_SET_ALL, false, "user-read", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allow user to read."},
  {LLDB_OPT_SET_ALL, false, "user-write", 'w', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allow user to write."},
  {LLDB_OPT_SET_ALL, false, "world-exec", 'e', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allow world to execute."},
  {LLDB_OPT_SET_ALL, false, "world-read", 'd', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allow world to read."},
  {LLDB_OPT_SET_ALL, false, "world-write", 't', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allow world to write."},
};
#undef LLDB_OPTIONS_permissions
#endif // permissions command

// Options for platform fread
#ifdef LLDB_OPTIONS_platform_fread
constexpr static OptionDefinition g_platform_fread_options[] = {
  {LLDB_OPT_SET_1, false, "count", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCount].enum_values, CompletionType::eNoCompletion, eArgTypeCount, "Number of bytes to read from the file."},
  {LLDB_OPT_SET_1, false, "offset", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeIndex].enum_values, CompletionType::eNoCompletion, eArgTypeIndex, "Offset into the file at which to start reading."},
};
#undef LLDB_OPTIONS_platform_fread
#endif // platform fread command

// Options for platform fwrite
#ifdef LLDB_OPTIONS_platform_fwrite
constexpr static OptionDefinition g_platform_fwrite_options[] = {
  {LLDB_OPT_SET_1, false, "data", 'd', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeValue].enum_values, CompletionType::eNoCompletion, eArgTypeValue, "Text to write to the file."},
  {LLDB_OPT_SET_1, false, "offset", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeIndex].enum_values, CompletionType::eNoCompletion, eArgTypeIndex, "Offset into the file at which to start reading."},
};
#undef LLDB_OPTIONS_platform_fwrite
#endif // platform fwrite command

// Options for platform process attach
#ifdef LLDB_OPTIONS_platform_process_attach
constexpr static OptionDefinition g_platform_process_attach_options[] = {
  {LLDB_OPT_SET_2, false, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeProcessName].enum_values, CompletionType::eNoCompletion, eArgTypeProcessName, "The name of the process to attach to."},
  {LLDB_OPT_SET_1, false, "pid", 'p', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePid].enum_values, CompletionType::eNoCompletion, eArgTypePid, "The process ID of an existing process to attach to."},
  {LLDB_OPT_SET_ALL, false, "plugin", 'P', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePlugin].enum_values, CompletionType::eNoCompletion, eArgTypePlugin, "Name of the process plugin you want to use."},
  {LLDB_OPT_SET_2, false, "waitfor", 'w', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Wait for the process with <process-name> to launch."},
};
#undef LLDB_OPTIONS_platform_process_attach
#endif // platform process attach command

// Options for platform process list
#ifdef LLDB_OPTIONS_platform_process_list
constexpr static OptionDefinition g_platform_process_list_options[] = {
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6, false, "all-users", 'x', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show processes matching all user IDs."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6, false, "arch", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeArchitecture].enum_values, CompletionType::eNoCompletion, eArgTypeArchitecture, "Find processes that have a matching architecture."},
  {LLDB_OPT_SET_5, true, "contains", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeProcessName].enum_values, CompletionType::eNoCompletion, eArgTypeProcessName, "Find processes with executable basenames that contain a string."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6, false, "egid", 'G', OptionParser::eRequiredArgument, &posix_validator, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "Find processes that have a matching effective group ID."},
  {LLDB_OPT_SET_3, true, "ends-with", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeProcessName].enum_values, CompletionType::eNoCompletion, eArgTypeProcessName, "Find processes with executable basenames that end with a string."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6, false, "euid", 'U', OptionParser::eRequiredArgument, &posix_validator, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "Find processes that have a matching effective user ID."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6, false, "gid", 'g', OptionParser::eRequiredArgument, &posix_validator, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "Find processes that have a matching group ID."},
  {LLDB_OPT_SET_2, true, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeProcessName].enum_values, CompletionType::eNoCompletion, eArgTypeProcessName, "Find processes with executable basenames that match a string."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6, false, "parent", 'P', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePid].enum_values, CompletionType::eNoCompletion, eArgTypePid, "Find processes that have a matching parent process ID."},
  {LLDB_OPT_SET_1, false, "pid", 'p', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePid].enum_values, CompletionType::eNoCompletion, eArgTypePid, "List the process info for a specific process ID."},
  {LLDB_OPT_SET_6, true, "regex", 'r', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeRegularExpression].enum_values, CompletionType::eNoCompletion, eArgTypeRegularExpression, "Find processes with executable basenames that match a regular expression."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6, false, "show-args", 'A', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show process arguments instead of the process executable basename."},
  {LLDB_OPT_SET_4, true, "starts-with", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeProcessName].enum_values, CompletionType::eNoCompletion, eArgTypeProcessName, "Find processes with executable basenames that start with a string."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6, false, "uid", 'u', OptionParser::eRequiredArgument, &posix_validator, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "Find processes that have a matching user ID."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Enable verbose output."},
};
#undef LLDB_OPTIONS_platform_process_list
#endif // platform process list command

// Options for platform shell
#ifdef LLDB_OPTIONS_platform_shell
constexpr static OptionDefinition g_platform_shell_options[] = {
  {LLDB_OPT_SET_ALL, false, "host", 'h', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Run the commands on the host shell when enabled."},
  {LLDB_OPT_SET_ALL, false, "shell", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePath].enum_values, CompletionType::eNoCompletion, eArgTypePath, "Shell interpreter path. This is the binary used to run the command."},
  {LLDB_OPT_SET_ALL, false, "timeout", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeValue].enum_values, CompletionType::eNoCompletion, eArgTypeValue, "Seconds to wait for the remote host to finish running the command."},
};
#undef LLDB_OPTIONS_platform_shell
#endif // platform shell command

// Options for plugin list
#ifdef LLDB_OPTIONS_plugin_list
constexpr static OptionDefinition g_plugin_list_options[] = {
  {LLDB_OPT_SET_ALL, false, "json", 'j', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Output the plugin list in json format."},
};
#undef LLDB_OPTIONS_plugin_list
#endif // plugin list command

// Options for process attach
#ifdef LLDB_OPTIONS_process_attach
constexpr static OptionDefinition g_process_attach_options[] = {
  {LLDB_OPT_SET_ALL, false, "continue", 'c', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Immediately continue the process once attached."},
  {LLDB_OPT_SET_2, false, "include-existing", 'i', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Include existing processes when doing attach -w."},
  {LLDB_OPT_SET_2, false, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeProcessName].enum_values, CompletionType::eNoCompletion, eArgTypeProcessName, "The name of the process to attach to."},
  {LLDB_OPT_SET_1, false, "pid", 'p', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePid].enum_values, CompletionType::eNoCompletion, eArgTypePid, "The process ID of an existing process to attach to."},
  {LLDB_OPT_SET_ALL, false, "plugin", 'P', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePlugin].enum_values, CompletionType::eNoCompletion, eArgTypePlugin, "Name of the process plugin you want to use."},
  {LLDB_OPT_SET_2, false, "waitfor", 'w', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Wait for the process with <process-name> to launch."},
};
#undef LLDB_OPTIONS_process_attach
#endif // process attach command

// Options for process connect
#ifdef LLDB_OPTIONS_process_connect
constexpr static OptionDefinition g_process_connect_options[] = {
  {LLDB_OPT_SET_ALL, false, "plugin", 'p', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePlugin].enum_values, CompletionType::eNoCompletion, eArgTypePlugin, "Name of the process plugin you want to use."},
};
#undef LLDB_OPTIONS_process_connect
#endif // process connect command

// Options for process continue
#ifdef LLDB_OPTIONS_process_continue
constexpr static OptionDefinition g_process_continue_options[] = {
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "ignore-count", 'i', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "Ignore <N> crossings of the breakpoint (if it exists) for the currently selected thread."},
  {LLDB_OPT_SET_3 | LLDB_OPT_SET_4, false, "continue-to-bkpt", 'b', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBreakpointIDRange].enum_values, CompletionType::eNoCompletion, eArgTypeBreakpointIDRange, "Specify a breakpoint to continue to, temporarily ignoring other breakpoints.  Can be specified more than once.  The continue action will be done synchronously if this option is specified."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_3, false, "forward", 'F', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Set the direction to forward before continuing."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_4, false, "reverse", 'R', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Set the direction to reverse before continuing."},
};
#undef LLDB_OPTIONS_process_continue
#endif // process continue command

// Options for process detach
#ifdef LLDB_OPTIONS_process_detach
constexpr static OptionDefinition g_process_detach_options[] = {
  {LLDB_OPT_SET_1, false, "keep-stopped", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Whether or not the process should be kept stopped on detach (if possible)."},
};
#undef LLDB_OPTIONS_process_detach
#endif // process detach command

// Options for process handle
#ifdef LLDB_OPTIONS_process_handle
constexpr static OptionDefinition g_process_handle_options[] = {
  {LLDB_OPT_SET_2, false, "clear", 'c', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Removes the signals listed from the Target signal handlers"},
  {LLDB_OPT_SET_2, false, "dummy", 'd', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Also clear the values in the dummy target so they won't be inherited by new targets."},
  {LLDB_OPT_SET_1, false, "notify", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Whether or not the debugger should notify the user if the signal is received."},
  {LLDB_OPT_SET_1, false, "target", 't', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show only the signals with behaviors modified in this target"},
  {LLDB_OPT_SET_1, false, "pass", 'p', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Whether or not the signal should be passed to the process."},
  {LLDB_OPT_SET_1, false, "stop", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Whether or not the process should be stopped if the signal is received."},
};
#undef LLDB_OPTIONS_process_handle
#endif // process handle command

// Options for process launch
#ifdef LLDB_OPTIONS_process_launch
constexpr static OptionDefinition g_process_launch_options[] = {
  {LLDB_OPT_SET_ALL, false, "arch", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeArchitecture].enum_values, CompletionType::eNoCompletion, eArgTypeArchitecture, "Set the architecture for the process to launch when ambiguous."},
  {LLDB_OPT_SET_ALL, false, "disable-aslr", 'A', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Set whether to disable address space layout randomization when launching a process."},
  {LLDB_OPT_SET_ALL, false, "environment", 'E', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeNone].enum_values, CompletionType::eNoCompletion, eArgTypeNone, "Specify an environment variable name/value string (--environment NAME=VALUE). Can be specified multiple times for subsequent environment entries."},
  {LLDB_OPT_SET_3, false, "no-stdio", 'n', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Do not set up for terminal I/O to go to running process."},
  {LLDB_OPT_SET_ALL, false, "plugin", 'P', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePlugin].enum_values, CompletionType::eNoCompletion, eArgTypePlugin, "Name of the process plugin you want to use."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_3, false, "shell", 'c', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, CompletionType::eNoCompletion, eArgTypeFilename, "Run the process in a shell (not supported on all platforms)."},
  {LLDB_OPT_SET_4, false, "shell-expand-args", 'X', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Set whether to shell expand arguments to the process when launching."},
  {LLDB_OPT_SET_1, false, "stderr", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, CompletionType::eNoCompletion, eArgTypeFilename, "Redirect stderr for the process to <filename>."},
  {LLDB_OPT_SET_1, false, "stdin", 'i', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, CompletionType::eNoCompletion, eArgTypeFilename, "Redirect stdin for the process to <filename>."},
  {LLDB_OPT_SET_1, false, "stdout", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, CompletionType::eNoCompletion, eArgTypeFilename, "Redirect stdout for the process to <filename>."},
  {LLDB_OPT_SET_ALL, false, "stop-at-entry", 's', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Stop at the entry point of the program when launching a process."},
  {LLDB_OPT_SET_ALL, false, "stop-at-user-entry", 'm', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Stop at the user entry point when launching a process. For C based languages this will be the 'main' function, but this might differ for other languages."},
  {LLDB_OPT_SET_2, false, "tty", 't', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Start the process in a terminal (not supported on all platforms)."},
  {LLDB_OPT_SET_ALL, false, "working-dir", 'w', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeDirectoryName].enum_values, CompletionType::eNoCompletion, eArgTypeDirectoryName, "Set the current working directory to <path> when running the inferior. This option applies only to the current `process launch` invocation. If `target.launch-working-dir` is set and this option is given, the value of this option will be used instead of the setting."},
};
#undef LLDB_OPTIONS_process_launch
#endif // process launch command

// Options for process load
#ifdef LLDB_OPTIONS_process_load
constexpr static OptionDefinition g_process_load_options[] = {
  {LLDB_OPT_SET_ALL, false, "install", 'i', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypePath].enum_values, CompletionType::eNoCompletion, eArgTypePath, "Install the shared library to the target. If specified without an argument then the library will installed in the current working directory."},
};
#undef LLDB_OPTIONS_process_load
#endif // process load command

// Options for process save_core
#ifdef LLDB_OPTIONS_process_save_core
constexpr static OptionDefinition g_process_save_core_options[] = {
  {LLDB_OPT_SET_ALL, false, "plugin-name", 'p', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypePlugin].enum_values, CompletionType::eNoCompletion, eArgTypePlugin, "Specify a plugin name to create the core file. This allows core files to be saved in different formats."},
  {LLDB_OPT_SET_1, false, "style", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeSaveCoreStyle].enum_values, CompletionType::eNoCompletion, eArgTypeSaveCoreStyle, "Request a specific style of corefile to be saved."},
};
#undef LLDB_OPTIONS_process_save_core
#endif // process save_core command

// Options for process status
#ifdef LLDB_OPTIONS_process_status
constexpr static OptionDefinition g_process_status_options[] = {
  {LLDB_OPT_SET_1, false, "dump-modification-id", 'd', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump the state of the ProcessModID of the stopped process."},
  {LLDB_OPT_SET_1, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show verbose process status including extended crash information."},
};
#undef LLDB_OPTIONS_process_status
#endif // process status command

// Options for regex
#ifdef LLDB_OPTIONS_regex
constexpr static OptionDefinition g_regex_options[] = {
  {LLDB_OPT_SET_1, false, "help", 'h', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeNone].enum_values, CompletionType::eNoCompletion, eArgTypeNone, "The help text to display for this command."},
  {LLDB_OPT_SET_1, false, "syntax", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeNone].enum_values, CompletionType::eNoCompletion, eArgTypeNone, "A syntax string showing the typical usage syntax."},
};
#undef LLDB_OPTIONS_regex
#endif // regex command

// Options for register read
#ifdef LLDB_OPTIONS_register_read
constexpr static OptionDefinition g_register_read_options[] = {
  {LLDB_OPT_SET_2, false, "all", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show all register sets."},
  {LLDB_OPT_SET_ALL, false, "alternate", 'A', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display register names using the alternate register name if there is one."},
  {LLDB_OPT_SET_1, false, "set", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeIndex].enum_values, CompletionType::eNoCompletion, eArgTypeIndex, "Specify which register sets to dump by index."},
};
#undef LLDB_OPTIONS_register_read
#endif // register read command

// Options for script add
#ifdef LLDB_OPTIONS_script_add
constexpr static OptionDefinition g_script_add_options[] = {
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3, false, "class", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePythonClass].enum_values, CompletionType::eNoCompletion, eArgTypePythonClass, "Name of the Python class to bind to this command name."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "completion-type", 'C', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCompletionType].enum_values, CompletionType::eNoCompletion, eArgTypeCompletionType, "Specify which completion type the command should use - if none is specified, the command won't use auto-completion."},
  {LLDB_OPT_SET_1, false, "function", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePythonFunction].enum_values, CompletionType::eNoCompletion, eArgTypePythonFunction, "Name of the Python function to bind to this command name."},
  {LLDB_OPT_SET_1, false, "help", 'h', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeHelpText].enum_values, CompletionType::eNoCompletion, eArgTypeHelpText, "The help text to display for this command."},
  {LLDB_OPT_SET_ALL, false, "overwrite", 'o', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Overwrite an existing command at this node."},
  {LLDB_OPT_SET_3, false, "parsed", 'p', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Make a parsed command. The command class will provide the command definition by implementing get_options and get_arguments."},
  {LLDB_OPT_SET_ALL, false, "synchronicity", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeScriptedCommandSynchronicity].enum_values, CompletionType::eNoCompletion, eArgTypeScriptedCommandSynchronicity, "Set the synchronicity of this command's executions with regard to LLDB event system."},
};
#undef LLDB_OPTIONS_script_add
#endif // script add command

// Options for script import
#ifdef LLDB_OPTIONS_script_import
constexpr static OptionDefinition g_script_import_options[] = {
  {LLDB_OPT_SET_1, false, "relative-to-command-file", 'c', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Resolve non-absolute paths relative to the location of the current command file. This argument can only be used when the command is being sourced from a file."},
  {LLDB_OPT_SET_1, false, "allow-reload", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allow the script to be loaded even if it was already loaded before. This argument exists for backwards compatibility, but reloading is always allowed, whether you specify it or not."},
  {LLDB_OPT_SET_1, false, "silent", 's', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "If true don't print any script output while importing."},
};
#undef LLDB_OPTIONS_script_import
#endif // script import command

// Options for scripting extension list
#ifdef LLDB_OPTIONS_scripting_extension_list
constexpr static OptionDefinition g_scripting_extension_list_options[] = {
  {LLDB_OPT_SET_ALL, false, "language", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeScriptLang].enum_values, CompletionType::eNoCompletion, eArgTypeScriptLang, "Specify the scripting  language. If none is specified the default scripting language is used."},
};
#undef LLDB_OPTIONS_scripting_extension_list
#endif // scripting extension list command

// Options for scripting run
#ifdef LLDB_OPTIONS_scripting_run
constexpr static OptionDefinition g_scripting_run_options[] = {
  {LLDB_OPT_SET_ALL, false, "language", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeScriptLang].enum_values, CompletionType::eNoCompletion, eArgTypeScriptLang, "Specify the scripting  language. If none is specific the default scripting language is used."},
};
#undef LLDB_OPTIONS_scripting_run
#endif // scripting run command

// Options for settings clear
#ifdef LLDB_OPTIONS_settings_clear
constexpr static OptionDefinition g_settings_clear_options[] = {
  {LLDB_OPT_SET_ALL, false, "all", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Clear all settings."},
};
#undef LLDB_OPTIONS_settings_clear
#endif // settings clear command

// Options for settings read
#ifdef LLDB_OPTIONS_settings_read
constexpr static OptionDefinition g_settings_read_options[] = {
  {LLDB_OPT_SET_ALL, true, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, eDiskFileCompletion, eArgTypeFilename, "The file from which to read the settings."},
};
#undef LLDB_OPTIONS_settings_read
#endif // settings read command

// Options for settings set
#ifdef LLDB_OPTIONS_settings_set
constexpr static OptionDefinition g_settings_set_options[] = {
  {LLDB_OPT_SET_ALL, false, "exists", 'e', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Set the setting if it exists, but do not cause the command to raise an error if it does not exist."},
  {LLDB_OPT_SET_ALL, false, "force", 'f', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Force an empty value to be accepted as the default."},
  {LLDB_OPT_SET_ALL, false, "global", 'g', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Apply the new value to the global default value."},
};
#undef LLDB_OPTIONS_settings_set
#endif // settings set command

// Options for settings write
#ifdef LLDB_OPTIONS_settings_write
constexpr static OptionDefinition g_settings_write_options[] = {
  {LLDB_OPT_SET_ALL, false, "append", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Append to saved settings file if it exists."},
  {LLDB_OPT_SET_ALL, true, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, eDiskFileCompletion, eArgTypeFilename, "The file into which to write the settings."},
};
#undef LLDB_OPTIONS_settings_write
#endif // settings write command

// Options for source
#ifdef LLDB_OPTIONS_source
constexpr static OptionDefinition g_source_options[] = {
  {LLDB_OPT_SET_ALL, false, "relative-to-command-file", 'C', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Resolve non-absolute paths relative to the location of the current command file. This argument can only be used when the command is being sourced from a file."},
  {LLDB_OPT_SET_ALL, false, "silent-run", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "If true don't echo commands while executing."},
  {LLDB_OPT_SET_ALL, false, "stop-on-continue", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "If true, stop executing commands on continue."},
  {LLDB_OPT_SET_ALL, false, "stop-on-error", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "If true, stop executing commands on error."},
};
#undef LLDB_OPTIONS_source
#endif // source command

// Options for source info
#ifdef LLDB_OPTIONS_source_info
constexpr static OptionDefinition g_source_info_options[] = {
  {LLDB_OPT_SET_3, false, "address", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Lookup the address and display the source information for the corresponding file and line."},
  {LLDB_OPT_SET_ALL, false, "count", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCount].enum_values, CompletionType::eNoCompletion, eArgTypeCount, "The number of line entries to display."},
  {LLDB_OPT_SET_1, false, "end-line", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLineNum].enum_values, CompletionType::eNoCompletion, eArgTypeLineNum, "The line number at which to stop displaying lines."},
  {LLDB_OPT_SET_1, false, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, eSourceFileCompletion, eArgTypeFilename, "The file from which to display source."},
  {LLDB_OPT_SET_1, false, "line", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLineNum].enum_values, CompletionType::eNoCompletion, eArgTypeLineNum, "The line number at which to start the displaying lines."},
  {LLDB_OPT_SET_2, false, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeSymbol].enum_values, eSymbolCompletion, eArgTypeSymbol, "The name of a function whose source to display."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2, false, "shlib", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeShlibName].enum_values, eModuleCompletion, eArgTypeShlibName, "Look up the source in the given module or shared library (can be specified more than once)."},
};
#undef LLDB_OPTIONS_source_info
#endif // source info command

// Options for source list
#ifdef LLDB_OPTIONS_source_list
constexpr static OptionDefinition g_source_list_options[] = {
  {LLDB_OPT_SET_3, false, "address", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Lookup the address and display the source information for the corresponding file and line."},
  {LLDB_OPT_SET_ALL, false, "count", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCount].enum_values, CompletionType::eNoCompletion, eArgTypeCount, "The number of source lines to display."},
  {LLDB_OPT_SET_1, false, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, eSourceFileCompletion, eArgTypeFilename, "The file from which to display source."},
  {LLDB_OPT_SET_5, false, "joint-specifier", 'y', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFileLineColumn].enum_values, eSourceFileCompletion, eArgTypeFileLineColumn, "A specifier in the form filename:line[:column] from which to display source."},
  {LLDB_OPT_SET_1, false, "line", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLineNum].enum_values, CompletionType::eNoCompletion, eArgTypeLineNum, "The line number at which to start the display source."},
  {LLDB_OPT_SET_2, false, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeSymbol].enum_values, eSymbolCompletion, eArgTypeSymbol, "The name of a function whose source to display."},
  {LLDB_OPT_SET_4, false, "reverse", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Reverse the listing to look backwards from the last displayed block of source."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_5, false, "shlib", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeShlibName].enum_values, eModuleCompletion, eArgTypeShlibName, "Look up the source file in the given shared library."},
  {LLDB_OPT_SET_ALL, false, "show-breakpoints", 'b', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show the line table locations from the debug information that indicate valid places to set source level breakpoints."},
};
#undef LLDB_OPTIONS_source_list
#endif // source list command

// Options for statistics dump
#ifdef LLDB_OPTIONS_statistics_dump
constexpr static OptionDefinition g_statistics_dump_options[] = {
  {LLDB_OPT_SET_1, false, "all-targets", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Include statistics for all targets."},
  {LLDB_OPT_SET_1, false, "load-all-debug-info", 'f', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump the total possible debug info statistics. Force loading all the debug information if not yet loaded, and collect statistics with those."},
  {LLDB_OPT_SET_1, false, "modules", 'm', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Dump statistics for the modules, including time and size of various aspects of the module and debug information, type system, path, etc. Defaults to true, unless the '--summary' mode is enabled, in which case this is turned off unless specified. In default mode, if both '--targets' and '--modules' are 'true', a list of module identifiers will be added to the 'targets' section."},
  {LLDB_OPT_SET_1, false, "plugins", 'p', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Dump statistics for known plugins including name, order, and enabled state. Defaults to true for both summary and default mode."},
  {LLDB_OPT_SET_1, false, "summary", 's', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump only high-level summary statistics. Exclude targets, modules, breakpoints etc... details."},
  {LLDB_OPT_SET_1, false, "targets", 'r', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Dump statistics for the targets, including breakpoints, expression evaluations, frame variables, etc. Defaults to true in both default mode and summary mode. In default mode, if both '--targets' and '--modules' are 'true', a list of module identifiers will be added to the 'targets' section."},
  {LLDB_OPT_SET_1, false, "transcript", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "If the setting interpreter.save-transcript is enabled and this option is 'true', include a JSON array with all commands the user and/or scripts executed during a debug session. Defaults to false. "},
};
#undef LLDB_OPTIONS_statistics_dump
#endif // statistics dump command

// Options for target dependents
#ifdef LLDB_OPTIONS_target_dependents
constexpr static OptionDefinition g_target_dependents_options[] = {
  {LLDB_OPT_SET_1, false, "no-dependents", 'd', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeValue].enum_values, CompletionType::eNoCompletion, eArgTypeValue, "Whether or not to load dependents when creating a target. If the option is not specified, the value is implicitly 'default'. If the option is specified but without a value, the value is implicitly 'true'."},
};
#undef LLDB_OPTIONS_target_dependents
#endif // target dependents command

// Options for target modules dump
#ifdef LLDB_OPTIONS_target_modules_dump
constexpr static OptionDefinition g_target_modules_dump_options[] = {
  {LLDB_OPT_SET_ALL, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Enable verbose dump."},
};
#undef LLDB_OPTIONS_target_modules_dump
#endif // target modules dump command

// Options for target modules dump separate debug info
#ifdef LLDB_OPTIONS_target_modules_dump_separate_debug_info
constexpr static OptionDefinition g_target_modules_dump_separate_debug_info_options[] = {
  {LLDB_OPT_SET_1, false, "errors-only", 'e', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Filter to show only debug info files with errors."},
  {LLDB_OPT_SET_1, false, "force-load-all-debug-info", 'f', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Load all debug info files."},
  {LLDB_OPT_SET_1, false, "json", 'j', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Output the details in JSON format."},
};
#undef LLDB_OPTIONS_target_modules_dump_separate_debug_info
#endif // target modules dump separate debug info command

// Options for target modules dump symtab
#ifdef LLDB_OPTIONS_target_modules_dump_symtab
constexpr static OptionDefinition g_target_modules_dump_symtab_options[] = {
  {LLDB_OPT_SET_1, false, "show-mangled-names", 'm', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Do not demangle symbol names before showing them."},
  {LLDB_OPT_SET_1, false, "sort", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeSortOrder].enum_values, CompletionType::eNoCompletion, eArgTypeSortOrder, "Supply a sort order when dumping the symbol table."},
};
#undef LLDB_OPTIONS_target_modules_dump_symtab
#endif // target modules dump symtab command

// Options for target modules list
#ifdef LLDB_OPTIONS_target_modules_list
constexpr static OptionDefinition g_target_modules_list_options[] = {
  {LLDB_OPT_SET_1, false, "address", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Display the image at this address."},
  {LLDB_OPT_SET_1, false, "arch", 'A', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeWidth].enum_values, CompletionType::eNoCompletion, eArgTypeWidth, "Display the architecture when listing images."},
  {LLDB_OPT_SET_1, false, "basename", 'b', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeWidth].enum_values, CompletionType::eNoCompletion, eArgTypeWidth, "Display the basename with optional width for the image object file."},
  {LLDB_OPT_SET_1, false, "directory", 'd', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeWidth].enum_values, CompletionType::eNoCompletion, eArgTypeWidth, "Display the directory with optional width for the image object file."},
  {LLDB_OPT_SET_1, false, "fullpath", 'f', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeWidth].enum_values, CompletionType::eNoCompletion, eArgTypeWidth, "Display the fullpath to the image object file."},
  {LLDB_OPT_SET_1, false, "global", 'g', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display the modules from the global module list, not just the current target."},
  {LLDB_OPT_SET_1, false, "header", 'h', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display the image base address as a load address if debugging, a file address otherwise."},
  {LLDB_OPT_SET_1, false, "mod-time", 'm', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeWidth].enum_values, CompletionType::eNoCompletion, eArgTypeWidth, "Display the modification time with optional width of the module."},
  {LLDB_OPT_SET_1, false, "offset", 'o', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display the image load address offset from the base file address (the slide amount)."},
  {LLDB_OPT_SET_1, false, "pointer", 'p', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeNone].enum_values, CompletionType::eNoCompletion, eArgTypeNone, "Display the module pointer."},
  {LLDB_OPT_SET_1, false, "ref-count", 'r', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeWidth].enum_values, CompletionType::eNoCompletion, eArgTypeWidth, "Display whether the module is still in the the shared module cache (Y/N), and its shared pointer use_count."},
  {LLDB_OPT_SET_1, false, "symfile", 's', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeWidth].enum_values, CompletionType::eNoCompletion, eArgTypeWidth, "Display the fullpath to the image symbol file with optional width."},
  {LLDB_OPT_SET_1, false, "symfile-unique", 'S', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeWidth].enum_values, CompletionType::eNoCompletion, eArgTypeWidth, "Display the symbol file with optional width only if it is different from the executable object file."},
  {LLDB_OPT_SET_1, false, "triple", 't', OptionParser::eOptionalArgument, nullptr, g_argument_table[eArgTypeWidth].enum_values, CompletionType::eNoCompletion, eArgTypeWidth, "Display the triple when listing images."},
  {LLDB_OPT_SET_1, false, "uuid", 'u', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display the UUID when listing images."},
};
#undef LLDB_OPTIONS_target_modules_list
#endif // target modules list command

// Options for target modules lookup
#ifdef LLDB_OPTIONS_target_modules_lookup
constexpr static OptionDefinition g_target_modules_lookup_options[] = {
  {LLDB_OPT_SET_1, true, "address", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Lookup an address in one or more target modules."},
  {LLDB_OPT_SET_ALL, false, "all", 'A', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Print all matches, not just the best match, if a best match is available."},
  {LLDB_OPT_SET_3, true, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, CompletionType::eNoCompletion, eArgTypeFilename, "Lookup a file by fullpath or basename in one or more target modules."},
  {LLDB_OPT_SET_4, true, "function", 'F', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFunctionName].enum_values, CompletionType::eNoCompletion, eArgTypeFunctionName, "Lookup a function by name in the debug symbols in one or more target modules."},
  {LLDB_OPT_SET_3, false, "line", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLineNum].enum_values, CompletionType::eNoCompletion, eArgTypeLineNum, "Lookup a line number in a file (must be used in conjunction with --file)."},
  {LLDB_OPT_SET_5, true, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFunctionOrSymbol].enum_values, CompletionType::eNoCompletion, eArgTypeFunctionOrSymbol, "Lookup a function or symbol by name in one or more target modules."},
  {LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5, false, "no-inlines", 'i', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Ignore inline entries (must be used in conjunction with --file or --function)."},
  {LLDB_OPT_SET_1, false, "offset", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeOffset].enum_values, CompletionType::eNoCompletion, eArgTypeOffset, "When looking up an address subtract <offset> from any addresses before doing the lookup."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5, false, "regex", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "The <name> argument for name lookups are regular expressions."},
  {LLDB_OPT_SET_2, true, "symbol", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeSymbol].enum_values, CompletionType::eNoCompletion, eArgTypeSymbol, "Lookup a symbol by name in the symbol tables in one or more target modules."},
  {LLDB_OPT_SET_6, true, "type", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "Lookup a type by name in the debug symbols in one or more target modules."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_3 | LLDB_OPT_SET_4 | LLDB_OPT_SET_5 | LLDB_OPT_SET_6, false, "show-variable-ranges", '\x01', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump valid ranges of variables (must be used in conjunction with --verbose"},
  {LLDB_OPT_SET_ALL, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Enable verbose lookup information."},
};
#undef LLDB_OPTIONS_target_modules_lookup
#endif // target modules lookup command

// Options for target modules show unwind
#ifdef LLDB_OPTIONS_target_modules_show_unwind
constexpr static OptionDefinition g_target_modules_show_unwind_options[] = {
  {LLDB_OPT_SET_2, false, "address", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Show unwind instructions for a function or symbol containing an address"},
  {LLDB_OPT_SET_ALL, false, "cached", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Show cached unwind information"},
  {LLDB_OPT_SET_1, false, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFunctionName].enum_values, CompletionType::eNoCompletion, eArgTypeFunctionName, "Show unwind instructions for a function or symbol name."},
};
#undef LLDB_OPTIONS_target_modules_show_unwind
#endif // target modules show unwind command

// Options for target stop hook add
#ifdef LLDB_OPTIONS_target_stop_hook_add
constexpr static OptionDefinition g_target_stop_hook_add_options[] = {
  {LLDB_OPT_SET_ALL, false, "at-initial-stop", 'I', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Whether the stop-hook will trigger when lldb  initially gains control of the process.  For a process launch, this initial stop may happen very early on - before the loader has run.  You can use this option if you do not want some stop-hooks to run then.  Defaults to true."},
  {LLDB_OPT_SET_ALL, false, "auto-continue", 'G', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "The stop-hook will auto-continue after running its commands."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_5, false, "classname", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeClassName].enum_values, CompletionType::eNoCompletion, eArgTypeClassName, "Specify the class within which the stop-hook is to be run."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_4, false, "end-line", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLineNum].enum_values, CompletionType::eNoCompletion, eArgTypeLineNum, "Set the end of the line range for which the stop-hook is to be run."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_4, false, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, eSourceFileCompletion, eArgTypeFilename, "Specify the source file within which the stop-hook is to be run."},
  {LLDB_OPT_SET_3 | LLDB_OPT_SET_6, false, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFunctionName].enum_values, eSymbolCompletion, eArgTypeFunctionName, "Set the function name within which the stop hook will be run."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_3, false, "one-liner", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeOneLiner].enum_values, CompletionType::eNoCompletion, eArgTypeOneLiner, "Add a command for the stop hook.  Can be specified more than once, and commands will be run in the order they appear."},
  {LLDB_OPT_SET_ALL, false, "queue-name", 'q', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeQueueName].enum_values, CompletionType::eNoCompletion, eArgTypeQueueName, "The stop hook is run only for threads in the queue whose name is given by this argument."},
  {LLDB_OPT_SET_ALL, false, "shlib", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeShlibName].enum_values, eModuleCompletion, eArgTypeShlibName, "Set the module within which the stop-hook is to be run."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_4, false, "start-line", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLineNum].enum_values, CompletionType::eNoCompletion, eArgTypeLineNum, "Set the start of the line range for which the stop-hook is to be run."},
  {LLDB_OPT_SET_ALL, false, "thread-id", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeThreadID].enum_values, CompletionType::eNoCompletion, eArgTypeThreadID, "The stop hook is run only for the thread whose TID matches this argument."},
  {LLDB_OPT_SET_ALL, false, "thread-index", 'x', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeThreadIndex].enum_values, CompletionType::eNoCompletion, eArgTypeThreadIndex, "The stop hook is run only for the thread whose index matches this argument."},
  {LLDB_OPT_SET_ALL, false, "thread-name", 'T', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeThreadName].enum_values, CompletionType::eNoCompletion, eArgTypeThreadName, "The stop hook is run only for the thread whose thread name matches this argument."},
};
#undef LLDB_OPTIONS_target_stop_hook_add
#endif // target stop hook add command

// Options for thread backtrace
#ifdef LLDB_OPTIONS_thread_backtrace
constexpr static OptionDefinition g_thread_backtrace_options[] = {
  {LLDB_OPT_SET_1, false, "count", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCount].enum_values, CompletionType::eNoCompletion, eArgTypeCount, "How many frames to display (0 for all)"},
  {LLDB_OPT_SET_1, false, "extended", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Show the extended backtrace, if available"},
  {LLDB_OPT_SET_1, false, "start", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFrameIndex].enum_values, CompletionType::eNoCompletion, eArgTypeFrameIndex, "Frame in which to start the backtrace"},
  {LLDB_OPT_SET_1, false, "unfiltered", 'u', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Do not filter out frames according to installed frame recognizers"},
};
#undef LLDB_OPTIONS_thread_backtrace
#endif // thread backtrace command

// Options for thread info
#ifdef LLDB_OPTIONS_thread_info
constexpr static OptionDefinition g_thread_info_options[] = {
  {LLDB_OPT_SET_ALL, false, "backing-thread", 'b', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "If this is an OS plugin thread, query the backing thread instead; has no effect otherwise."},
  {LLDB_OPT_SET_ALL, false, "json", 'j', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display the thread info in JSON format."},
  {LLDB_OPT_SET_ALL, false, "stop-info", 's', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display the extended stop info in JSON format."},
};
#undef LLDB_OPTIONS_thread_info
#endif // thread info command

// Options for thread jump
#ifdef LLDB_OPTIONS_thread_jump
constexpr static OptionDefinition g_thread_jump_options[] = {
  {LLDB_OPT_SET_3, true, "address", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Jumps to a specific address."},
  {LLDB_OPT_SET_2, true, "by", 'b', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeOffset].enum_values, CompletionType::eNoCompletion, eArgTypeOffset, "Jumps by a relative line offset from the current line,can be a positive or negative offset"},
  {LLDB_OPT_SET_1, false, "file", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, eSourceFileCompletion, eArgTypeFilename, "Specifies the source file to jump to."},
  {LLDB_OPT_SET_1 | LLDB_OPT_SET_2 | LLDB_OPT_SET_3, false, "force", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Allows the PC to leave the current function."},
  {LLDB_OPT_SET_1, true, "line", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLineNum].enum_values, CompletionType::eNoCompletion, eArgTypeLineNum, "Specifies the line number to jump to."},
};
#undef LLDB_OPTIONS_thread_jump
#endif // thread jump command

// Options for thread plan list
#ifdef LLDB_OPTIONS_thread_plan_list
constexpr static OptionDefinition g_thread_plan_list_options[] = {
  {LLDB_OPT_SET_1, false, "internal", 'i', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display internal as well as user thread plans"},
  {LLDB_OPT_SET_1, false, "thread-id", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeThreadID].enum_values, CompletionType::eNoCompletion, eArgTypeThreadID, "List the thread plans for this TID, can be specified more than once."},
  {LLDB_OPT_SET_1, false, "unreported", 'u', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display thread plans for unreported threads"},
  {LLDB_OPT_SET_1, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display more information about the thread plans"},
};
#undef LLDB_OPTIONS_thread_plan_list
#endif // thread plan list command

// Options for thread return
#ifdef LLDB_OPTIONS_thread_return
constexpr static OptionDefinition g_thread_return_options[] = {
  {LLDB_OPT_SET_ALL, false, "from-expression", 'x', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Return from the innermost expression evaluation."},
};
#undef LLDB_OPTIONS_thread_return
#endif // thread return command

// Options for thread select
#ifdef LLDB_OPTIONS_thread_select
constexpr static OptionDefinition g_thread_select_options[] = {
  {LLDB_OPT_SET_2, false, "thread-id", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeThreadID].enum_values, eThreadIDCompletion, eArgTypeThreadID, "Provide a thread ID instead of a thread index."},
};
#undef LLDB_OPTIONS_thread_select
#endif // thread select command

// Options for thread step scope
#ifdef LLDB_OPTIONS_thread_step_scope
constexpr static OptionDefinition g_thread_step_scope_options[] = {
  {LLDB_OPT_SET_1, false, "count", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCount].enum_values, CompletionType::eNoCompletion, eArgTypeCount, "How many times to perform the stepping operation - currently only supported for step-inst and next-inst."},
  {LLDB_OPT_SET_1, false, "end-linenumber", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLineNum].enum_values, CompletionType::eNoCompletion, eArgTypeLineNum, "The line at which to stop stepping - defaults to the next line and only supported for step-in and step-over.  You can also pass the string 'block' to step to the end of the current block.  This is particularly use  in conjunction with --step-target to step through a complex calling sequence."},
  {LLDB_OPT_SET_1, false, "run-mode", 'm', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeRunMode].enum_values, CompletionType::eNoCompletion, eArgTypeRunMode, "Determine how to run other threads while stepping the current thread."},
  {LLDB_OPT_SET_1, false, "step-in-avoids-no-debug", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "A boolean value that sets whether stepping into functions will step over functions with no debug information."},
  {LLDB_OPT_SET_1, false, "step-in-target", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFunctionName].enum_values, CompletionType::eNoCompletion, eArgTypeFunctionName, "The name of the directly called function step in should stop at when stepping into."},
  {LLDB_OPT_SET_1, false, "step-out-avoids-no-debug", 'A', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "A boolean value, if true stepping out of functions will continue to step out till it hits a function with debug information."},
  {LLDB_OPT_SET_1, false, "step-over-regexp", 'r', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeRegularExpression].enum_values, CompletionType::eNoCompletion, eArgTypeRegularExpression, "A regular expression that defines function names to not to stop at when stepping in."},
};
#undef LLDB_OPTIONS_thread_step_scope
#endif // thread step scope command

// Options for thread trace dump function calls
#ifdef LLDB_OPTIONS_thread_trace_dump_function_calls
constexpr static OptionDefinition g_thread_trace_dump_function_calls_options[] = {
  {LLDB_OPT_SET_1, false, "file", 'F', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, CompletionType::eNoCompletion, eArgTypeFilename, "Dump the function calls to a file instead of the standard output."},
  {LLDB_OPT_SET_1, false, "json", 'j', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump in simple JSON format."},
  {LLDB_OPT_SET_1, false, "pretty-json", 'J', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump in JSON format but pretty printing the output for easier readability."},
};
#undef LLDB_OPTIONS_thread_trace_dump_function_calls
#endif // thread trace dump function calls command

// Options for thread trace dump info
#ifdef LLDB_OPTIONS_thread_trace_dump_info
constexpr static OptionDefinition g_thread_trace_dump_info_options[] = {
  {LLDB_OPT_SET_1, false, "json", 'j', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump in JSON format."},
  {LLDB_OPT_SET_1, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "show verbose thread trace dump info"},
};
#undef LLDB_OPTIONS_thread_trace_dump_info
#endif // thread trace dump info command

// Options for thread trace dump instructions
#ifdef LLDB_OPTIONS_thread_trace_dump_instructions
constexpr static OptionDefinition g_thread_trace_dump_instructions_options[] = {
  {LLDB_OPT_SET_1, false, "only-events", 'E', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump only the events that happened during the execution of the target. No instructions are dumped."},
  {LLDB_OPT_SET_1, false, "all", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "From the starting point of the trace, dump all instructions available."},
  {LLDB_OPT_SET_1, false, "continue", 'C', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Continue dumping instructions right where the previous invocation of this command was left, or from the beginning if this is the first invocation. The --skip argument is discarded and the other arguments are preserved from the previous invocation when possible."},
  {LLDB_OPT_SET_1, false, "count", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCount].enum_values, CompletionType::eNoCompletion, eArgTypeCount, "The number of instructions to display starting at the most recent instruction, or the oldest if --forwards is provided."},
  {LLDB_OPT_SET_1, false, "file", 'F', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFilename].enum_values, CompletionType::eNoCompletion, eArgTypeFilename, "Dump the instruction to a file instead of the standard output."},
  {LLDB_OPT_SET_1, false, "forwards", 'f', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "If specified, the trace is traversed forwards chronologically starting at the oldest instruction. Otherwise, it starts at the most recent one and the traversal is backwards."},
  {LLDB_OPT_SET_1, false, "id", 'i', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeIndex].enum_values, CompletionType::eNoCompletion, eArgTypeIndex, "Custom starting instruction id from where to start traversing. This id can be provided in decimal or hexadecimal representation."},
  {LLDB_OPT_SET_1, false, "json", 'j', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump in simple JSON format."},
  {LLDB_OPT_SET_1, false, "pretty-json", 'J', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump in JSON format but pretty printing the output for easier readability."},
  {LLDB_OPT_SET_1, false, "raw", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump only instruction address without disassembly nor symbol information."},
  {LLDB_OPT_SET_1, false, "events", 'e', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Dump the events that happened during the execution of the target."},
  {LLDB_OPT_SET_1, false, "kind", 'k', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show instruction control flow kind. Refer to the enum `InstructionControlFlowKind` for a list of control flow kind. As an important note, far jumps, far calls and far returns often indicate calls to and from kernel."},
  {LLDB_OPT_SET_1, false, "time", 't', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "For each trace item, print the corresponding wall clock timestamp if available."},
  {LLDB_OPT_SET_1, false, "skip", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeIndex].enum_values, CompletionType::eNoCompletion, eArgTypeIndex, "How many trace items (instructions, errors and events) to skip from the starting position of the trace before starting the traversal."},
};
#undef LLDB_OPTIONS_thread_trace_dump_instructions
#endif // thread trace dump instructions command

// Options for thread until
#ifdef LLDB_OPTIONS_thread_until
constexpr static OptionDefinition g_thread_until_options[] = {
  {LLDB_OPT_SET_1, false, "address", 'a', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeAddressOrExpression].enum_values, CompletionType::eNoCompletion, eArgTypeAddressOrExpression, "Run until we reach the specified address, or leave the function - can be specified multiple times."},
  {LLDB_OPT_SET_1, false, "frame", 'f', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeFrameIndex].enum_values, CompletionType::eNoCompletion, eArgTypeFrameIndex, "Frame index for until operation - defaults to 0"},
  {LLDB_OPT_SET_1, false, "run-mode", 'm', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeRunMode].enum_values, CompletionType::eNoCompletion, eArgTypeRunMode, "Determine how to run other threads while stepping this one"},
  {LLDB_OPT_SET_1, false, "thread", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeThreadIndex].enum_values, CompletionType::eNoCompletion, eArgTypeThreadIndex, "Thread index for the thread for until operation"},
};
#undef LLDB_OPTIONS_thread_until
#endif // thread until command

// Options for trace dump
#ifdef LLDB_OPTIONS_trace_dump
constexpr static OptionDefinition g_trace_dump_options[] = {
  {LLDB_OPT_SET_1, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show verbose trace information."},
};
#undef LLDB_OPTIONS_trace_dump
#endif // trace dump command

// Options for trace load
#ifdef LLDB_OPTIONS_trace_load
constexpr static OptionDefinition g_trace_load_options[] = {
  {LLDB_OPT_SET_1, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show verbose trace load logging for debugging the plug-in implementation."},
};
#undef LLDB_OPTIONS_trace_load
#endif // trace load command

// Options for trace save
#ifdef LLDB_OPTIONS_trace_save
constexpr static OptionDefinition g_trace_save_options[] = {
  {LLDB_OPT_SET_1, false, "compact", 'c', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Try not to save to disk information irrelevant to the traced processes. Each trace plug-in implements this in a different fashion."},
};
#undef LLDB_OPTIONS_trace_save
#endif // trace save command

// Options for trace schema
#ifdef LLDB_OPTIONS_trace_schema
constexpr static OptionDefinition g_trace_schema_options[] = {
  {LLDB_OPT_SET_1, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Show verbose trace schema logging for debugging the plug-in."},
};
#undef LLDB_OPTIONS_trace_schema
#endif // trace schema command

// Options for type category define
#ifdef LLDB_OPTIONS_type_category_define
constexpr static OptionDefinition g_type_category_define_options[] = {
  {LLDB_OPT_SET_ALL, false, "enabled", 'e', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "If specified, this category will be created enabled."},
  {LLDB_OPT_SET_ALL, false, "language", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "Specify the language that this category is supported for."},
};
#undef LLDB_OPTIONS_type_category_define
#endif // type category define command

// Options for type category disable
#ifdef LLDB_OPTIONS_type_category_disable
constexpr static OptionDefinition g_type_category_disable_options[] = {
  {LLDB_OPT_SET_ALL, false, "language", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "Enable the category for this language."},
};
#undef LLDB_OPTIONS_type_category_disable
#endif // type category disable command

// Options for type category enable
#ifdef LLDB_OPTIONS_type_category_enable
constexpr static OptionDefinition g_type_category_enable_options[] = {
  {LLDB_OPT_SET_ALL, false, "language", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "Enable the category for this language."},
};
#undef LLDB_OPTIONS_type_category_enable
#endif // type category enable command

// Options for type filter add
#ifdef LLDB_OPTIONS_type_filter_add
constexpr static OptionDefinition g_type_filter_add_options[] = {
  {LLDB_OPT_SET_ALL, false, "cascade", 'C', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "If true, cascade through typedef chains."},
  {LLDB_OPT_SET_ALL, false, "category", 'w', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "Add this to the given category instead of the default one."},
  {LLDB_OPT_SET_ALL, false, "child", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeExpressionPath].enum_values, CompletionType::eNoCompletion, eArgTypeExpressionPath, "Include this expression path in the synthetic view."},
  {LLDB_OPT_SET_ALL, false, "regex", 'x', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Type names are actually regular expressions."},
  {LLDB_OPT_SET_ALL, false, "skip-pointers", 'p', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Don't use this format for pointers-to-type objects."},
  {LLDB_OPT_SET_ALL, false, "skip-references", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Don't use this format for references-to-type objects."},
};
#undef LLDB_OPTIONS_type_filter_add
#endif // type filter add command

// Options for type format add
#ifdef LLDB_OPTIONS_type_format_add
constexpr static OptionDefinition g_type_format_add_options[] = {
  {LLDB_OPT_SET_ALL, false, "cascade", 'C', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "If true, cascade through typedef chains."},
  {LLDB_OPT_SET_ALL, false, "category", 'w', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "Add this to the given category instead of the default one."},
  {LLDB_OPT_SET_ALL, false, "regex", 'x', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Type names are actually regular expressions."},
  {LLDB_OPT_SET_ALL, false, "skip-pointers", 'p', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Don't use this format for pointers-to-type objects."},
  {LLDB_OPT_SET_ALL, false, "skip-references", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Don't use this format for references-to-type objects."},
  {LLDB_OPT_SET_2, false, "type", 't', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "Format variables as if they were of this type."},
};
#undef LLDB_OPTIONS_type_format_add
#endif // type format add command

// Options for type formatter clear
#ifdef LLDB_OPTIONS_type_formatter_clear
constexpr static OptionDefinition g_type_formatter_clear_options[] = {
  {LLDB_OPT_SET_ALL, false, "all", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Clear every category."},
};
#undef LLDB_OPTIONS_type_formatter_clear
#endif // type formatter clear command

// Options for type formatter delete
#ifdef LLDB_OPTIONS_type_formatter_delete
constexpr static OptionDefinition g_type_formatter_delete_options[] = {
  {LLDB_OPT_SET_1, false, "all", 'a', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Delete from every category."},
  {LLDB_OPT_SET_2, false, "category", 'w', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "Delete from given category."},
  {LLDB_OPT_SET_3, false, "language", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "Delete from given language's category."},
};
#undef LLDB_OPTIONS_type_formatter_delete
#endif // type formatter delete command

// Options for type formatter list
#ifdef LLDB_OPTIONS_type_formatter_list
constexpr static OptionDefinition g_type_formatter_list_options[] = {
  {LLDB_OPT_SET_1, false, "category-regex", 'w', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "Only show categories matching this filter."},
  {LLDB_OPT_SET_2, false, "language", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "Only show the category for a specific language."},
};
#undef LLDB_OPTIONS_type_formatter_list
#endif // type formatter list command

// Options for type lookup
#ifdef LLDB_OPTIONS_type_lookup
constexpr static OptionDefinition g_type_lookup_options[] = {
  {LLDB_OPT_SET_ALL, false, "language", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeLanguage].enum_values, CompletionType::eNoCompletion, eArgTypeLanguage, "Which language's types should the search scope be"},
  {LLDB_OPT_SET_ALL, false, "show-help", 'h', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Display available help for types"},
};
#undef LLDB_OPTIONS_type_lookup
#endif // type lookup command

// Options for type summary add
#ifdef LLDB_OPTIONS_type_summary_add
constexpr static OptionDefinition g_type_summary_add_options[] = {
  {LLDB_OPT_SET_ALL, false, "cascade", 'C', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "If true, cascade through typedef chains."},
  {LLDB_OPT_SET_ALL, false, "category", 'w', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "Add this to the given category instead of the default one."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3, false, "expand", 'e', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Expand aggregate data types to show children on separate lines."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3, false, "hide-empty", 'h', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Do not expand aggregate data types with no children."},
  {LLDB_OPT_SET_1, true, "inline-children", 'c', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "If true, inline all child values into summary string."},
  {LLDB_OPT_SET_3, false, "input-python", 'P', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Input Python code to use for this type manually."},
  {LLDB_OPT_SET_2 | LLDB_OPT_SET_3, false, "name", 'n', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "A name for this summary string."},
  {LLDB_OPT_SET_ALL, false, "no-value", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Don't show the value, just show the summary, for this type."},
  {LLDB_OPT_SET_1, false, "omit-names", 'O', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "If true, omit value names in the summary display."},
  {LLDB_OPT_SET_ALL, false, "pointer-match-depth", 'd', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeUnsignedInteger].enum_values, CompletionType::eNoCompletion, eArgTypeUnsignedInteger, "Specify the maximum pointer depth that this format can be apply to (default to 1). It's only effective when --skip-pointers is not set."},
  {LLDB_OPT_SET_3, false, "python-function", 'F', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePythonFunction].enum_values, CompletionType::eNoCompletion, eArgTypePythonFunction, "Give the name of a Python function to use for this type."},
  {LLDB_OPT_SET_3, false, "python-script", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePythonScript].enum_values, CompletionType::eNoCompletion, eArgTypePythonScript, "Give a one-liner Python script as part of the command."},
  {LLDB_OPT_SET_ALL, false, "recognizer-function", '\x01', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "The names in the argument list are actually the names of python functions that decide whether to use this summary for any given type. Cannot be specified at the same time as --regex (-x)."},
  {LLDB_OPT_SET_ALL, false, "regex", 'x', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Type names are actually regular expressions."},
  {LLDB_OPT_SET_ALL, false, "skip-pointers", 'p', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Don't use this format for pointers-to-type objects."},
  {LLDB_OPT_SET_ALL, false, "skip-references", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Don't use this format for references-to-type objects."},
  {LLDB_OPT_SET_2, true, "summary-string", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeSummaryString].enum_values, CompletionType::eNoCompletion, eArgTypeSummaryString, "Summary string used to display text and object contents."},
};
#undef LLDB_OPTIONS_type_summary_add
#endif // type summary add command

// Options for type synth add
#ifdef LLDB_OPTIONS_type_synth_add
constexpr static OptionDefinition g_type_synth_add_options[] = {
  {LLDB_OPT_SET_ALL, false, "cascade", 'C', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "If true, cascade through typedef chains."},
  {LLDB_OPT_SET_ALL, false, "category", 'w', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeName].enum_values, CompletionType::eNoCompletion, eArgTypeName, "Add this to the given category instead of the default one."},
  {LLDB_OPT_SET_3, false, "input-python", 'P', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Type Python code to generate a class that provides synthetic children."},
  {LLDB_OPT_SET_2, false, "python-class", 'l', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePythonClass].enum_values, CompletionType::eNoCompletion, eArgTypePythonClass, "Use this Python class to produce synthetic children."},
  {LLDB_OPT_SET_ALL, false, "recognizer-function", '\x01', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "The names in the argument list are actually the names of python functions that decide whether to use this summary for any given type. Cannot be specified at the same time as --regex (-x)."},
  {LLDB_OPT_SET_ALL, false, "regex", 'x', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Type names are actually regular expressions."},
  {LLDB_OPT_SET_ALL, false, "skip-pointers", 'p', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Don't use this format for pointers-to-type objects."},
  {LLDB_OPT_SET_ALL, false, "skip-references", 'r', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Don't use this format for references-to-type objects."},
};
#undef LLDB_OPTIONS_type_synth_add
#endif // type synth add command

// Options for watchpoint command add
#ifdef LLDB_OPTIONS_watchpoint_command_add
constexpr static OptionDefinition g_watchpoint_command_add_options[] = {
  {LLDB_OPT_SET_1, false, "one-liner", 'o', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeOneLiner].enum_values, CompletionType::eNoCompletion, eArgTypeOneLiner, "Specify a one-line watchpoint command inline. Be sure to surround it with quotes."},
  {LLDB_OPT_SET_2, false, "python-function", 'F', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypePythonFunction].enum_values, CompletionType::eNoCompletion, eArgTypePythonFunction, "Give the name of a Python function to run as command for this watchpoint. Be sure to give a module name if appropriate."},
  {LLDB_OPT_SET_ALL, false, "script-type", 's', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeScriptLang].enum_values, CompletionType::eNoCompletion, eArgTypeScriptLang, "Specify the language for the commands - if none is specified, the lldb command interpreter will be used."},
  {LLDB_OPT_SET_ALL, false, "stop-on-error", 'e', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeBoolean].enum_values, CompletionType::eNoCompletion, eArgTypeBoolean, "Specify whether watchpoint command execution should terminate on error."},
};
#undef LLDB_OPTIONS_watchpoint_command_add
#endif // watchpoint command add command

// Options for watchpoint delete
#ifdef LLDB_OPTIONS_watchpoint_delete
constexpr static OptionDefinition g_watchpoint_delete_options[] = {
  {LLDB_OPT_SET_1, false, "force", 'f', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Delete all watchpoints without querying for confirmation."},
};
#undef LLDB_OPTIONS_watchpoint_delete
#endif // watchpoint delete command

// Options for watchpoint ignore
#ifdef LLDB_OPTIONS_watchpoint_ignore
constexpr static OptionDefinition g_watchpoint_ignore_options[] = {
  {LLDB_OPT_SET_ALL, true, "ignore-count", 'i', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeCount].enum_values, CompletionType::eNoCompletion, eArgTypeCount, "Set the number of times this watchpoint is skipped before stopping."},
};
#undef LLDB_OPTIONS_watchpoint_ignore
#endif // watchpoint ignore command

// Options for watchpoint list
#ifdef LLDB_OPTIONS_watchpoint_list
constexpr static OptionDefinition g_watchpoint_list_options[] = {
  {LLDB_OPT_SET_1, false, "brief", 'b', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Give a brief description of the watchpoint (no location info)."},
  {LLDB_OPT_SET_2, false, "full", 'f', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Give a full description of the watchpoint and its locations."},
  {LLDB_OPT_SET_3, false, "verbose", 'v', OptionParser::eNoArgument, nullptr, {}, CompletionType::eNoCompletion, eArgTypeNone, "Explain everything we know about the watchpoint (for debugging debugger bugs)."},
};
#undef LLDB_OPTIONS_watchpoint_list
#endif // watchpoint list command

// Options for watchpoint modify
#ifdef LLDB_OPTIONS_watchpoint_modify
constexpr static OptionDefinition g_watchpoint_modify_options[] = {
  {LLDB_OPT_SET_ALL, false, "condition", 'c', OptionParser::eRequiredArgument, nullptr, g_argument_table[eArgTypeExpression].enum_values, CompletionType::eNoCompletion, eArgTypeExpression, "The watchpoint stops only if this condition expression evaluates to true."},
};
#undef LLDB_OPTIONS_watchpoint_modify
#endif // watchpoint modify command

