/* Zoom.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Zoom.vala, do not modify */

/*
 * Copyright 2022 elementary, Inc. (https://elementary.io)
 * Copyright 2013 Tom Beckmann
 * Copyright 2013 Rico Tzschichholz
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <meta/meta-plugin.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/display.h>
#include <gio/gio.h>
#include <meta/prefs.h>
#include <meta/window.h>
#include <clutter/clutter.h>
#include <meta/keybindings.h>
#include <graphene-gobject.h>
#include <meta/meta-cursor-tracker.h>
#include <string.h>
#include <gdk/gdk.h>

#define GREETER_COMPOSITOR_ZOOM_MIN_ZOOM 1.0f
#define GREETER_COMPOSITOR_ZOOM_MAX_ZOOM 10.0f
#define GREETER_COMPOSITOR_ZOOM_SHORTCUT_DELTA 0.5f
#define GREETER_COMPOSITOR_ZOOM_ANIMATION_DURATION 300
#define GREETER_COMPOSITOR_ZOOM_MOUSE_POLL_TIME ((guint) 50)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_ZOOM (greeter_compositor_zoom_get_type ())
#define GREETER_COMPOSITOR_ZOOM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_ZOOM, GreeterCompositorZoom))
#define GREETER_COMPOSITOR_ZOOM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_ZOOM, GreeterCompositorZoomClass))
#define GREETER_COMPOSITOR_IS_ZOOM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_ZOOM))
#define GREETER_COMPOSITOR_IS_ZOOM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_ZOOM))
#define GREETER_COMPOSITOR_ZOOM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_ZOOM, GreeterCompositorZoomClass))

typedef struct _GreeterCompositorZoom GreeterCompositorZoom;
typedef struct _GreeterCompositorZoomClass GreeterCompositorZoomClass;
typedef struct _GreeterCompositorZoomPrivate GreeterCompositorZoomPrivate;

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;
enum  {
	GREETER_COMPOSITOR_ZOOM_0_PROPERTY,
	GREETER_COMPOSITOR_ZOOM_WM_PROPERTY,
	GREETER_COMPOSITOR_ZOOM_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_zoom_properties[GREETER_COMPOSITOR_ZOOM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block30Data Block30Data;
#define __vala_graphene_point_t_free0(var) ((var == NULL) ? NULL : (var = (_vala_graphene_point_t_free (var), NULL)))

struct _GreeterCompositorZoom {
	GObject parent_instance;
	GreeterCompositorZoomPrivate * priv;
};

struct _GreeterCompositorZoomClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorZoomPrivate {
	GreeterCompositorWindowManager* _wm;
	guint mouse_poll_timer;
	gfloat current_zoom;
	gulong wins_handler_id;
};

struct _Block30Data {
	int _ref_count_;
	GreeterCompositorZoom* self;
	ClutterActor* wins;
};

static gint GreeterCompositorZoom_private_offset;
static gpointer greeter_compositor_zoom_parent_class = NULL;

VALA_EXTERN GType greeter_compositor_zoom_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorZoom, g_object_unref)
VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
VALA_EXTERN GreeterCompositorWindowManager* greeter_compositor_zoom_get_wm (GreeterCompositorZoom* self);
VALA_EXTERN GreeterCompositorZoom* greeter_compositor_zoom_new (GreeterCompositorWindowManager* wm);
VALA_EXTERN GreeterCompositorZoom* greeter_compositor_zoom_construct (GType object_type,
                                                          GreeterCompositorWindowManager* wm);
static void greeter_compositor_zoom_zoom_in (MetaDisplay* display,
                                      MetaWindow* window,
                                      ClutterKeyEvent* event,
                                      MetaKeyBinding* binding,
                                      GreeterCompositorZoom* self);
static void greeter_compositor_zoom_zoom_out (MetaDisplay* display,
                                       MetaWindow* window,
                                       ClutterKeyEvent* event,
                                       MetaKeyBinding* binding,
                                       GreeterCompositorZoom* self);
static void greeter_compositor_zoom_zoom (GreeterCompositorZoom* self,
                                   gfloat delta,
                                   gboolean play_sound,
                                   gboolean animate);
static inline void greeter_compositor_zoom_compute_new_pivot_point (GreeterCompositorZoom* self,
                                                      graphene_point_t* result);
VALA_EXTERN ClutterActor* greeter_compositor_window_manager_get_ui_group (GreeterCompositorWindowManager* self);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static gboolean ___lambda23_ (Block30Data* _data30_);
static void _vala_graphene_point_t_free (graphene_point_t* self);
static gboolean ____lambda23__gsource_func (gpointer self);
static void ____lambda24_ (Block30Data* _data30_);
static void _____lambda24__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                         gpointer self);
static void greeter_compositor_zoom_set_wm (GreeterCompositorZoom* self,
                                     GreeterCompositorWindowManager* value);
static void greeter_compositor_zoom_finalize (GObject * obj);
static GType greeter_compositor_zoom_get_type_once (void);
static void _vala_greeter_compositor_zoom_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_greeter_compositor_zoom_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
greeter_compositor_zoom_get_instance_private (GreeterCompositorZoom* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorZoom_private_offset);
}

GreeterCompositorZoom*
greeter_compositor_zoom_construct (GType object_type,
                                   GreeterCompositorWindowManager* wm)
{
	GreeterCompositorZoom * self = NULL;
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	GSettings* schema = NULL;
	GSettings* _tmp1_;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GreeterCompositorZoom*) g_object_new (object_type, "wm", wm, NULL);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) wm);
	display = _tmp0_;
	_tmp1_ = g_settings_new ("io.elementary.greeter-compositor.keybindings");
	schema = _tmp1_;
	meta_display_add_keybinding (display, "zoom-in", schema, META_KEY_BINDING_NONE, (MetaKeyHandlerFunc) greeter_compositor_zoom_zoom_in, g_object_ref (self), g_object_unref);
	meta_display_add_keybinding (display, "zoom-out", schema, META_KEY_BINDING_NONE, (MetaKeyHandlerFunc) greeter_compositor_zoom_zoom_out, g_object_ref (self), g_object_unref);
	_g_object_unref0 (schema);
	return self;
}

GreeterCompositorZoom*
greeter_compositor_zoom_new (GreeterCompositorWindowManager* wm)
{
	return greeter_compositor_zoom_construct (GREETER_COMPOSITOR_TYPE_ZOOM, wm);
}

static void
greeter_compositor_zoom_zoom_in (MetaDisplay* display,
                                 MetaWindow* window,
                                 ClutterKeyEvent* event,
                                 MetaKeyBinding* binding,
                                 GreeterCompositorZoom* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (event != NULL);
	g_return_if_fail (binding != NULL);
	greeter_compositor_zoom_zoom (self, GREETER_COMPOSITOR_ZOOM_SHORTCUT_DELTA, TRUE, TRUE);
}

static void
greeter_compositor_zoom_zoom_out (MetaDisplay* display,
                                  MetaWindow* window,
                                  ClutterKeyEvent* event,
                                  MetaKeyBinding* binding,
                                  GreeterCompositorZoom* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (event != NULL);
	g_return_if_fail (binding != NULL);
	greeter_compositor_zoom_zoom (self, -GREETER_COMPOSITOR_ZOOM_SHORTCUT_DELTA, TRUE, TRUE);
}

static inline void
greeter_compositor_zoom_compute_new_pivot_point (GreeterCompositorZoom* self,
                                                 graphene_point_t* result)
{
	ClutterActor* wins = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	graphene_point_t coords = {0};
	MetaCursorTracker* tracker = NULL;
	GreeterCompositorWindowManager* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaCursorTracker* _tmp5_;
	graphene_point_t _tmp6_ = {0};
	graphene_point_t new_pivot = {0};
	graphene_point_t _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	graphene_point_t _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	graphene_point_t _tmp13_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = greeter_compositor_window_manager_get_ui_group (_tmp0_);
	_tmp2_ = _tmp1_;
	wins = _tmp2_;
	_tmp3_ = self->priv->_wm;
	_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
	_tmp5_ = meta_cursor_tracker_get_for_display (_tmp4_);
	tracker = _tmp5_;
	meta_cursor_tracker_get_pointer (tracker, &_tmp6_, NULL);
	coords = _tmp6_;
	_tmp7_ = coords;
	_tmp8_ = clutter_actor_get_width (wins);
	_tmp9_ = _tmp8_;
	_tmp10_ = coords;
	_tmp11_ = clutter_actor_get_height (wins);
	_tmp12_ = _tmp11_;
	memset (&_tmp13_, 0, sizeof (graphene_point_t));
	_tmp13_.x = _tmp7_.x / _tmp9_;
	_tmp13_.y = _tmp10_.y / _tmp12_;
	new_pivot = _tmp13_;
	*result = new_pivot;
	return;
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		GreeterCompositorZoom* self;
		self = _data30_->self;
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}

static void
_vala_graphene_point_t_free (graphene_point_t* self)
{
	g_boxed_free (graphene_point_get_type (), self);
}

static gboolean
___lambda23_ (Block30Data* _data30_)
{
	GreeterCompositorZoom* self;
	graphene_point_t new_pivot = {0};
	graphene_point_t _tmp0_ = {0};
	ClutterActor* _tmp1_;
	graphene_point_t* _tmp2_;
	graphene_point_t* _tmp3_;
	graphene_point_t* _tmp4_;
	graphene_point_t _tmp5_;
	gboolean _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	graphene_point_t _tmp11_;
	ClutterActor* _tmp12_;
	gboolean result;
	self = _data30_->self;
	greeter_compositor_zoom_compute_new_pivot_point (self, &_tmp0_);
	new_pivot = _tmp0_;
	_tmp1_ = _data30_->wins;
	g_object_get (_tmp1_, "pivot-point", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = new_pivot;
	_tmp6_ = graphene_point_equal (_tmp4_, &_tmp5_);
	__vala_graphene_point_t_free0 (_tmp4_);
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = _data30_->wins;
	clutter_actor_save_easing_state (_tmp7_);
	_tmp8_ = _data30_->wins;
	clutter_actor_set_easing_mode (_tmp8_, CLUTTER_LINEAR);
	_tmp9_ = _data30_->wins;
	clutter_actor_set_easing_duration (_tmp9_, GREETER_COMPOSITOR_ZOOM_MOUSE_POLL_TIME);
	_tmp10_ = _data30_->wins;
	_tmp11_ = new_pivot;
	g_object_set (_tmp10_, "pivot-point", &_tmp11_, NULL);
	_tmp12_ = _data30_->wins;
	clutter_actor_restore_easing_state (_tmp12_);
	result = TRUE;
	return result;
}

static gboolean
____lambda23__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda23_ (self);
	return result;
}

static void
____lambda24_ (Block30Data* _data30_)
{
	GreeterCompositorZoom* self;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	self = _data30_->self;
	_tmp0_ = _data30_->wins;
	g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->wins_handler_id);
	self->priv->wins_handler_id = (gulong) 0;
	_tmp1_ = _data30_->wins;
	clutter_actor_set_pivot_point (_tmp1_, 0.0f, 0.0f);
}

static void
_____lambda24__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                    gpointer self)
{
	____lambda24_ (self);
}

static void
greeter_compositor_zoom_zoom (GreeterCompositorZoom* self,
                              gfloat delta,
                              gboolean play_sound,
                              gboolean animate)
{
	Block30Data* _data30_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GreeterCompositorWindowManager* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	gint _tmp8_ = 0;
	gint animation_duration = 0;
	ClutterActor* _tmp18_;
	ClutterActor* _tmp19_;
	ClutterActor* _tmp20_;
	ClutterActor* _tmp21_;
	ClutterActor* _tmp22_;
	g_return_if_fail (self != NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_data30_->self = g_object_ref (self);
	if (self->priv->current_zoom <= GREETER_COMPOSITOR_ZOOM_MIN_ZOOM) {
		_tmp1_ = delta < ((gfloat) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->current_zoom >= GREETER_COMPOSITOR_ZOOM_MAX_ZOOM) {
			_tmp2_ = delta >= ((gfloat) 0);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		if (play_sound) {
			gdk_beep ();
		}
		block30_data_unref (_data30_);
		_data30_ = NULL;
		return;
	}
	_tmp3_ = self->priv->_wm;
	_tmp4_ = greeter_compositor_window_manager_get_ui_group (_tmp3_);
	_tmp5_ = _tmp4_;
	_data30_->wins = _tmp5_;
	if (self->priv->mouse_poll_timer == ((guint) 0)) {
		ClutterActor* _tmp6_;
		graphene_point_t _tmp7_ = {0};
		_tmp6_ = _data30_->wins;
		greeter_compositor_zoom_compute_new_pivot_point (self, &_tmp7_);
		g_object_set (_tmp6_, "pivot-point", &_tmp7_, NULL);
		self->priv->mouse_poll_timer = g_timeout_add_full (G_PRIORITY_DEFAULT, GREETER_COMPOSITOR_ZOOM_MOUSE_POLL_TIME, ____lambda23__gsource_func, block30_data_ref (_data30_), block30_data_unref);
	}
	self->priv->current_zoom = self->priv->current_zoom + delta;
	if (animate) {
		_tmp8_ = GREETER_COMPOSITOR_ZOOM_ANIMATION_DURATION;
	} else {
		_tmp8_ = 0;
	}
	animation_duration = _tmp8_;
	if (self->priv->wins_handler_id > ((gulong) 0)) {
		ClutterActor* _tmp9_;
		_tmp9_ = _data30_->wins;
		g_signal_handler_disconnect ((GObject*) _tmp9_, self->priv->wins_handler_id);
		self->priv->wins_handler_id = (gulong) 0;
	}
	if (self->priv->current_zoom <= GREETER_COMPOSITOR_ZOOM_MIN_ZOOM) {
		ClutterActor* _tmp10_;
		ClutterActor* _tmp11_;
		ClutterActor* _tmp12_;
		ClutterActor* _tmp13_;
		ClutterActor* _tmp14_;
		self->priv->current_zoom = GREETER_COMPOSITOR_ZOOM_MIN_ZOOM;
		if (self->priv->mouse_poll_timer > ((guint) 0)) {
			g_source_remove (self->priv->mouse_poll_timer);
			self->priv->mouse_poll_timer = (guint) 0;
		}
		_tmp10_ = _data30_->wins;
		clutter_actor_save_easing_state (_tmp10_);
		_tmp11_ = _data30_->wins;
		clutter_actor_set_easing_mode (_tmp11_, CLUTTER_EASE_OUT_CUBIC);
		_tmp12_ = _data30_->wins;
		clutter_actor_set_easing_duration (_tmp12_, (guint) animation_duration);
		_tmp13_ = _data30_->wins;
		clutter_actor_set_scale (_tmp13_, (gdouble) GREETER_COMPOSITOR_ZOOM_MIN_ZOOM, (gdouble) GREETER_COMPOSITOR_ZOOM_MIN_ZOOM);
		_tmp14_ = _data30_->wins;
		clutter_actor_restore_easing_state (_tmp14_);
		if (animate) {
			ClutterActor* _tmp15_;
			gulong _tmp16_;
			_tmp15_ = _data30_->wins;
			_tmp16_ = g_signal_connect_data (_tmp15_, "transitions-completed", (GCallback) _____lambda24__clutter_actor_transitions_completed, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
			self->priv->wins_handler_id = _tmp16_;
		} else {
			ClutterActor* _tmp17_;
			_tmp17_ = _data30_->wins;
			clutter_actor_set_pivot_point (_tmp17_, 0.0f, 0.0f);
		}
		block30_data_unref (_data30_);
		_data30_ = NULL;
		return;
	}
	_tmp18_ = _data30_->wins;
	clutter_actor_save_easing_state (_tmp18_);
	_tmp19_ = _data30_->wins;
	clutter_actor_set_easing_mode (_tmp19_, CLUTTER_EASE_OUT_CUBIC);
	_tmp20_ = _data30_->wins;
	clutter_actor_set_easing_duration (_tmp20_, (guint) animation_duration);
	_tmp21_ = _data30_->wins;
	clutter_actor_set_scale (_tmp21_, (gdouble) self->priv->current_zoom, (gdouble) self->priv->current_zoom);
	_tmp22_ = _data30_->wins;
	clutter_actor_restore_easing_state (_tmp22_);
	block30_data_unref (_data30_);
	_data30_ = NULL;
}

GreeterCompositorWindowManager*
greeter_compositor_zoom_get_wm (GreeterCompositorZoom* self)
{
	GreeterCompositorWindowManager* result;
	GreeterCompositorWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_compositor_zoom_set_wm (GreeterCompositorZoom* self,
                                GreeterCompositorWindowManager* value)
{
	GreeterCompositorWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_zoom_get_wm (self);
	if (old_value != value) {
		GreeterCompositorWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_zoom_properties[GREETER_COMPOSITOR_ZOOM_WM_PROPERTY]);
	}
}

static void
greeter_compositor_zoom_class_init (GreeterCompositorZoomClass * klass,
                                    gpointer klass_data)
{
	greeter_compositor_zoom_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorZoom_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_zoom_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_zoom_set_property;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_zoom_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_ZOOM_WM_PROPERTY, greeter_compositor_zoom_properties[GREETER_COMPOSITOR_ZOOM_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
greeter_compositor_zoom_instance_init (GreeterCompositorZoom * self,
                                       gpointer klass)
{
	self->priv = greeter_compositor_zoom_get_instance_private (self);
	self->priv->mouse_poll_timer = (guint) 0;
	self->priv->current_zoom = GREETER_COMPOSITOR_ZOOM_MIN_ZOOM;
	self->priv->wins_handler_id = 0UL;
}

static void
greeter_compositor_zoom_finalize (GObject * obj)
{
	GreeterCompositorZoom * self;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* display = NULL;
	GreeterCompositorWindowManager* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_ZOOM, GreeterCompositorZoom);
	_tmp0_ = self->priv->_wm;
	if (_tmp0_ == NULL) {
		goto _return;
	}
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	display = _tmp2_;
	_tmp3_ = display;
	meta_display_remove_keybinding (_tmp3_, "zoom-in");
	_tmp4_ = display;
	meta_display_remove_keybinding (_tmp4_, "zoom-out");
	if (self->priv->mouse_poll_timer > ((guint) 0)) {
		g_source_remove (self->priv->mouse_poll_timer);
		self->priv->mouse_poll_timer = (guint) 0;
	}
	_return:
	_g_object_unref0 (self->priv->_wm);
	G_OBJECT_CLASS (greeter_compositor_zoom_parent_class)->finalize (obj);
}

static GType
greeter_compositor_zoom_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorZoomClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_zoom_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorZoom), 0, (GInstanceInitFunc) greeter_compositor_zoom_instance_init, NULL };
	GType greeter_compositor_zoom_type_id;
	greeter_compositor_zoom_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorZoom", &g_define_type_info, 0);
	GreeterCompositorZoom_private_offset = g_type_add_instance_private (greeter_compositor_zoom_type_id, sizeof (GreeterCompositorZoomPrivate));
	return greeter_compositor_zoom_type_id;
}

GType
greeter_compositor_zoom_get_type (void)
{
	static volatile gsize greeter_compositor_zoom_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_zoom_type_id__once)) {
		GType greeter_compositor_zoom_type_id;
		greeter_compositor_zoom_type_id = greeter_compositor_zoom_get_type_once ();
		g_once_init_leave (&greeter_compositor_zoom_type_id__once, greeter_compositor_zoom_type_id);
	}
	return greeter_compositor_zoom_type_id__once;
}

static void
_vala_greeter_compositor_zoom_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GreeterCompositorZoom * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_ZOOM, GreeterCompositorZoom);
	switch (property_id) {
		case GREETER_COMPOSITOR_ZOOM_WM_PROPERTY:
		g_value_set_object (value, greeter_compositor_zoom_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_zoom_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GreeterCompositorZoom * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_ZOOM, GreeterCompositorZoom);
	switch (property_id) {
		case GREETER_COMPOSITOR_ZOOM_WM_PROPERTY:
		greeter_compositor_zoom_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

