/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/ic_reg_maps/gen_adf4360_regs.py on Mon Oct 13 20:27:01 2025
 **********************************************************************/

#ifndef INCLUDED_ADF4360_REGS_HPP
#define INCLUDED_ADF4360_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <set>
#include <vector>
#include <stdint.h>

class adf4360_regs_t{
public:
    enum core_power_level_t{
        CORE_POWER_LEVEL_5MA = 0,
        CORE_POWER_LEVEL_10MA = 1,
        CORE_POWER_LEVEL_15MA = 2,
        CORE_POWER_LEVEL_20MA = 3
    };
    core_power_level_t core_power_level;
    enum counter_operation_t{
        COUNTER_OPERATION_NORMAL = 0,
        COUNTER_OPERATION_RESET = 1
    };
    counter_operation_t counter_operation;
    enum muxout_control_t{
        MUXOUT_CONTROL_3STATE = 0,
        MUXOUT_CONTROL_DLD = 1,
        MUXOUT_CONTROL_NDIV = 2,
        MUXOUT_CONTROL_DVDD = 3,
        MUXOUT_CONTROL_RDIV = 4,
        MUXOUT_CONTROL_NCHAN_OD_LD = 5,
        MUXOUT_CONTROL_SDO = 6,
        MUXOUT_CONTROL_DGND = 7
    };
    muxout_control_t muxout_control;
    enum phase_detector_polarity_t{
        PHASE_DETECTOR_POLARITY_NEG = 0,
        PHASE_DETECTOR_POLARITY_POS = 1
    };
    phase_detector_polarity_t phase_detector_polarity;
    enum charge_pump_output_t{
        CHARGE_PUMP_OUTPUT_NORMAL = 0,
        CHARGE_PUMP_OUTPUT_3STATE = 1
    };
    charge_pump_output_t charge_pump_output;
    enum cp_gain_0_t{
        CP_GAIN_0_SET1 = 0,
        CP_GAIN_0_SET2 = 1
    };
    cp_gain_0_t cp_gain_0;
    enum mute_till_ld_t{
        MUTE_TILL_LD_DIS = 0,
        MUTE_TILL_LD_ENB = 1
    };
    mute_till_ld_t mute_till_ld;
    enum output_power_level_t{
        OUTPUT_POWER_LEVEL_3_5MA = 0,
        OUTPUT_POWER_LEVEL_5_0MA = 1,
        OUTPUT_POWER_LEVEL_7_5MA = 2,
        OUTPUT_POWER_LEVEL_11_0MA = 3
    };
    output_power_level_t output_power_level;
    enum current_setting1_t{
        CURRENT_SETTING1_0_31MA = 0,
        CURRENT_SETTING1_0_62MA = 1,
        CURRENT_SETTING1_0_93MA = 2,
        CURRENT_SETTING1_1_25MA = 3,
        CURRENT_SETTING1_1_56MA = 4,
        CURRENT_SETTING1_1_87MA = 5,
        CURRENT_SETTING1_2_18MA = 6,
        CURRENT_SETTING1_2_50MA = 7
    };
    current_setting1_t current_setting1;
    enum current_setting2_t{
        CURRENT_SETTING2_0_31MA = 0,
        CURRENT_SETTING2_0_62MA = 1,
        CURRENT_SETTING2_0_93MA = 2,
        CURRENT_SETTING2_1_25MA = 3,
        CURRENT_SETTING2_1_56MA = 4,
        CURRENT_SETTING2_1_87MA = 5,
        CURRENT_SETTING2_2_18MA = 6,
        CURRENT_SETTING2_2_50MA = 7
    };
    current_setting2_t current_setting2;
    enum power_down_t{
        POWER_DOWN_NORMAL_OP = 0,
        POWER_DOWN_ASYNC_PD = 1,
        POWER_DOWN_SYNC_PD = 3
    };
    power_down_t power_down;
    enum prescaler_value_t{
        PRESCALER_VALUE_8_9 = 0,
        PRESCALER_VALUE_16_17 = 1,
        PRESCALER_VALUE_32_33 = 2
    };
    prescaler_value_t prescaler_value;
    uint8_t a_counter;
    uint16_t b_counter;
    enum cp_gain_1_t{
        CP_GAIN_1_SET1 = 0,
        CP_GAIN_1_SET2 = 1
    };
    cp_gain_1_t cp_gain_1;
    enum divide_by_2_output_t{
        DIVIDE_BY_2_OUTPUT_FUND = 0,
        DIVIDE_BY_2_OUTPUT_DIV2 = 1
    };
    divide_by_2_output_t divide_by_2_output;
    enum divide_by_2_prescaler_t{
        DIVIDE_BY_2_PRESCALER_FUND = 0,
        DIVIDE_BY_2_PRESCALER_DIV2 = 1
    };
    divide_by_2_prescaler_t divide_by_2_prescaler;
    uint16_t r_counter;
    enum ablpw_t{
        ABLPW_3_0NS = 0,
        ABLPW_1_3NS = 1,
        ABLPW_6_0NS = 2
    };
    ablpw_t ablpw;
    enum lock_detect_precision_t{
        LOCK_DETECT_PRECISION_3CYCLES = 0,
        LOCK_DETECT_PRECISION_5CYCLES = 1
    };
    lock_detect_precision_t lock_detect_precision;
    uint8_t test_mode_bit;
    enum band_select_clock_div_t{
        BAND_SELECT_CLOCK_DIV_1 = 0,
        BAND_SELECT_CLOCK_DIV_2 = 1,
        BAND_SELECT_CLOCK_DIV_4 = 2,
        BAND_SELECT_CLOCK_DIV_8 = 3
    };
    band_select_clock_div_t band_select_clock_div;

    adf4360_regs_t(void){
        _state = NULL;
        core_power_level = CORE_POWER_LEVEL_5MA;
        counter_operation = COUNTER_OPERATION_NORMAL;
        muxout_control = MUXOUT_CONTROL_3STATE;
        phase_detector_polarity = PHASE_DETECTOR_POLARITY_NEG;
        charge_pump_output = CHARGE_PUMP_OUTPUT_NORMAL;
        cp_gain_0 = CP_GAIN_0_SET1;
        mute_till_ld = MUTE_TILL_LD_DIS;
        output_power_level = OUTPUT_POWER_LEVEL_3_5MA;
        current_setting1 = CURRENT_SETTING1_0_31MA;
        current_setting2 = CURRENT_SETTING2_0_31MA;
        power_down = POWER_DOWN_NORMAL_OP;
        prescaler_value = PRESCALER_VALUE_8_9;
        a_counter = 0;
        b_counter = 0;
        cp_gain_1 = CP_GAIN_1_SET1;
        divide_by_2_output = DIVIDE_BY_2_OUTPUT_FUND;
        divide_by_2_prescaler = DIVIDE_BY_2_PRESCALER_FUND;
        r_counter = 0;
        ablpw = ABLPW_3_0NS;
        lock_detect_precision = LOCK_DETECT_PRECISION_3CYCLES;
        test_mode_bit = 0;
        band_select_clock_div = BAND_SELECT_CLOCK_DIV_1;
    }

    ~adf4360_regs_t(void){
        delete _state;
    }

    enum addr_t{
        ADDR_CONTROL = 0,
        ADDR_NCOUNTER = 2,
        ADDR_RCOUNTER = 1
    };
    
    uint32_t get_reg(addr_t addr){
        uint32_t reg = addr & 0x3;
        switch(addr){
        case 0:
            reg |= (uint32_t(core_power_level) & 0x3) << 2;
            reg |= (uint32_t(counter_operation) & 0x1) << 4;
            reg |= (uint32_t(muxout_control) & 0x7) << 5;
            reg |= (uint32_t(phase_detector_polarity) & 0x1) << 8;
            reg |= (uint32_t(charge_pump_output) & 0x1) << 9;
            reg |= (uint32_t(cp_gain_0) & 0x1) << 10;
            reg |= (uint32_t(mute_till_ld) & 0x1) << 11;
            reg |= (uint32_t(output_power_level) & 0x3) << 12;
            reg |= (uint32_t(current_setting1) & 0x7) << 14;
            reg |= (uint32_t(current_setting2) & 0x7) << 17;
            reg |= (uint32_t(power_down) & 0x3) << 20;
            reg |= (uint32_t(prescaler_value) & 0x3) << 22;
            break;
        case 1:
            reg |= (uint32_t(r_counter) & 0x3fff) << 2;
            reg |= (uint32_t(ablpw) & 0x3) << 16;
            reg |= (uint32_t(lock_detect_precision) & 0x1) << 18;
            reg |= (uint32_t(test_mode_bit) & 0x1) << 19;
            reg |= (uint32_t(band_select_clock_div) & 0x3) << 20;
            break;
        case 2:
            reg |= (uint32_t(a_counter) & 0x1f) << 2;
            reg |= (uint32_t(b_counter) & 0x1fff) << 8;
            reg |= (uint32_t(cp_gain_1) & 0x1) << 21;
            reg |= (uint32_t(divide_by_2_output) & 0x1) << 22;
            reg |= (uint32_t(divide_by_2_prescaler) & 0x1) << 23;
            break;
        }
        return reg;
    }

    void save_state(void){
        if (_state == NULL) _state = new adf4360_regs_t();
        _state->core_power_level = this->core_power_level;
        _state->counter_operation = this->counter_operation;
        _state->muxout_control = this->muxout_control;
        _state->phase_detector_polarity = this->phase_detector_polarity;
        _state->charge_pump_output = this->charge_pump_output;
        _state->cp_gain_0 = this->cp_gain_0;
        _state->mute_till_ld = this->mute_till_ld;
        _state->output_power_level = this->output_power_level;
        _state->current_setting1 = this->current_setting1;
        _state->current_setting2 = this->current_setting2;
        _state->power_down = this->power_down;
        _state->prescaler_value = this->prescaler_value;
        _state->a_counter = this->a_counter;
        _state->b_counter = this->b_counter;
        _state->cp_gain_1 = this->cp_gain_1;
        _state->divide_by_2_output = this->divide_by_2_output;
        _state->divide_by_2_prescaler = this->divide_by_2_prescaler;
        _state->r_counter = this->r_counter;
        _state->ablpw = this->ablpw;
        _state->lock_detect_precision = this->lock_detect_precision;
        _state->test_mode_bit = this->test_mode_bit;
        _state->band_select_clock_div = this->band_select_clock_div;
    }

    core_power_level_t get_state_core_power_level(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->core_power_level;
    }

    counter_operation_t get_state_counter_operation(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->counter_operation;
    }

    muxout_control_t get_state_muxout_control(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->muxout_control;
    }

    phase_detector_polarity_t get_state_phase_detector_polarity(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_detector_polarity;
    }

    charge_pump_output_t get_state_charge_pump_output(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->charge_pump_output;
    }

    cp_gain_0_t get_state_cp_gain_0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cp_gain_0;
    }

    mute_till_ld_t get_state_mute_till_ld(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mute_till_ld;
    }

    output_power_level_t get_state_output_power_level(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->output_power_level;
    }

    current_setting1_t get_state_current_setting1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->current_setting1;
    }

    current_setting2_t get_state_current_setting2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->current_setting2;
    }

    power_down_t get_state_power_down(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down;
    }

    prescaler_value_t get_state_prescaler_value(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->prescaler_value;
    }

    uint8_t get_state_a_counter(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->a_counter;
    }

    uint16_t get_state_b_counter(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->b_counter;
    }

    cp_gain_1_t get_state_cp_gain_1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cp_gain_1;
    }

    divide_by_2_output_t get_state_divide_by_2_output(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divide_by_2_output;
    }

    divide_by_2_prescaler_t get_state_divide_by_2_prescaler(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divide_by_2_prescaler;
    }

    uint16_t get_state_r_counter(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->r_counter;
    }

    ablpw_t get_state_ablpw(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ablpw;
    }

    lock_detect_precision_t get_state_lock_detect_precision(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lock_detect_precision;
    }

    uint8_t get_state_test_mode_bit(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->test_mode_bit;
    }

    band_select_clock_div_t get_state_band_select_clock_div(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->band_select_clock_div;
    }


    template<typename T> std::set<T> get_changed_addrs(bool include_ro = false) {
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if (include_ro || !false) {
            if(_state->core_power_level != this->core_power_level) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->counter_operation != this->counter_operation) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->muxout_control != this->muxout_control) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_detector_polarity != this->phase_detector_polarity) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->charge_pump_output != this->charge_pump_output) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->cp_gain_0 != this->cp_gain_0) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->mute_till_ld != this->mute_till_ld) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->output_power_level != this->output_power_level) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->current_setting1 != this->current_setting1) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->current_setting2 != this->current_setting2) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down != this->power_down) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->prescaler_value != this->prescaler_value) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->a_counter != this->a_counter) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->b_counter != this->b_counter) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->cp_gain_1 != this->cp_gain_1) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->divide_by_2_output != this->divide_by_2_output) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->divide_by_2_prescaler != this->divide_by_2_prescaler) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->r_counter != this->r_counter) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->ablpw != this->ablpw) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->lock_detect_precision != this->lock_detect_precision) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->test_mode_bit != this->test_mode_bit) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->band_select_clock_div != this->band_select_clock_div) {
                addrs.insert(1);
            }
        }
        return addrs;
    }

private:
    adf4360_regs_t *_state;
};

#endif /* INCLUDED_ADF4360_REGS_HPP */
