
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kshortcutseditor_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"
#include "ktoolbar_wrapper.h"

// Argument includes
#include <QString>
#include <kactioncollection.h>
#include <kshortcutseditor.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KShortcutsEditor_Type = nullptr;
static PyTypeObject *Sbk_KShortcutsEditor_TypeF(void)
{
    return _Sbk_KShortcutsEditor_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KShortcutsEditorWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KShortcutsEditorWrapper::KShortcutsEditorWrapper(::KActionCollection * collection, ::QWidget * parent, ::QFlags<KShortcutsEditor::ActionType> actionTypes, ::KShortcutsEditor::LetterShortcuts allowLetterShortcuts) : KShortcutsEditor(collection, parent, actionTypes, allowLetterShortcuts)
{
}

KShortcutsEditorWrapper::KShortcutsEditorWrapper(::QWidget * parent, ::QFlags<KShortcutsEditor::ActionType> actionTypes, ::KShortcutsEditor::LetterShortcuts allowLetterShortcuts) : KShortcutsEditor(parent, actionTypes, allowLetterShortcuts)
{
}

void KShortcutsEditorWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KToolBarWrapper::sbk_o_actionEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KToolBarWrapper::sbk_o_changeEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_childEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KToolBarWrapper::sbk_o_closeEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KShortcutsEditor", funcName, gil, pyOverride, signal);
}

void KShortcutsEditorWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KToolBarWrapper::sbk_o_contextMenuEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_customEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

int KShortcutsEditorWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KToolBarWrapper::sbk_o_devType("KShortcutsEditor", funcName, gil, pyOverride);
}

void KShortcutsEditorWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KShortcutsEditor", funcName, gil, pyOverride, signal);
}

void KShortcutsEditorWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KToolBarWrapper::sbk_o_dragEnterEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragLeaveEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragMoveEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KToolBarWrapper::sbk_o_dropEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KToolBarWrapper::sbk_o_enterEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

bool KShortcutsEditorWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_event("KShortcutsEditor", funcName, gil, pyOverride, event);
}

bool KShortcutsEditorWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_eventFilter("KShortcutsEditor", funcName, gil, pyOverride, watched, event);
}

void KShortcutsEditorWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KToolBarWrapper::sbk_o_focusInEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

bool KShortcutsEditorWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KToolBarWrapper::sbk_o_focusNextPrevChild("KShortcutsEditor", funcName, gil, pyOverride, next);
}

void KShortcutsEditorWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KToolBarWrapper::sbk_o_focusOutEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

bool KShortcutsEditorWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KToolBarWrapper::sbk_o_hasHeightForWidth("KShortcutsEditor", funcName, gil, pyOverride);
}

int KShortcutsEditorWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KToolBarWrapper::sbk_o_heightForWidth("KShortcutsEditor", funcName, gil, pyOverride, arg__1);
}

void KShortcutsEditorWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KToolBarWrapper::sbk_o_hideEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KToolBarWrapper::sbk_o_initPainter("KShortcutsEditor", funcName, gil, pyOverride, painter);
}

void KShortcutsEditorWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KToolBarWrapper::sbk_o_inputMethodEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

::QVariant KShortcutsEditorWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KToolBarWrapper::sbk_o_inputMethodQuery("KShortcutsEditor", funcName, gil, pyOverride, arg__1);
}

void KShortcutsEditorWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KToolBarWrapper::sbk_o_keyPressEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_keyReleaseEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KToolBarWrapper::sbk_o_leaveEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

int KShortcutsEditorWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KToolBarWrapper::sbk_o_metric("KShortcutsEditor", funcName, gil, pyOverride, arg__1);
}

::QSize KShortcutsEditorWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KShortcutsEditor", funcName, gil, pyOverride);
}

void KShortcutsEditorWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseDoubleClickEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseMoveEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KToolBarWrapper::sbk_o_mousePressEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseReleaseEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KToolBarWrapper::sbk_o_moveEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

bool KShortcutsEditorWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KToolBarWrapper::sbk_o_nativeEvent("KShortcutsEditor", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KShortcutsEditorWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KToolBarWrapper::sbk_o_paintEngine("KShortcutsEditor", funcName, gil, pyOverride);
}

void KShortcutsEditorWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KToolBarWrapper::sbk_o_paintEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

::QPaintDevice * KShortcutsEditorWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KToolBarWrapper::sbk_o_redirected("KShortcutsEditor", funcName, gil, pyOverride, offset);
}

void KShortcutsEditorWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KToolBarWrapper::sbk_o_resizeEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KToolBarWrapper::sbk_o_setVisible("KShortcutsEditor", funcName, gil, pyOverride, visible);
}

::QPainter * KShortcutsEditorWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KToolBarWrapper::sbk_o_sharedPainter("KShortcutsEditor", funcName, gil, pyOverride);
}

void KShortcutsEditorWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KToolBarWrapper::sbk_o_showEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

::QSize KShortcutsEditorWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KShortcutsEditor", funcName, gil, pyOverride);
}

void KShortcutsEditorWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KToolBarWrapper::sbk_o_tabletEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_timerEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

void KShortcutsEditorWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutsEditor_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KToolBarWrapper::sbk_o_wheelEvent("KShortcutsEditor", funcName, gil, pyOverride, event);
}

const QMetaObject *KShortcutsEditorWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KShortcutsEditor::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KShortcutsEditorWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KShortcutsEditor::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KShortcutsEditorWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KShortcutsEditorWrapper *>(this));
    }
    return KShortcutsEditor::qt_metacast(_clname);
}

KShortcutsEditorWrapper::~KShortcutsEditorWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KShortcutsEditor_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KShortcutsEditor_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KShortcutsEditor >()))
        return -1;

    KShortcutsEditorWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOOO:KShortcutsEditor", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KShortcutsEditor::KShortcutsEditor(KActionCollection*,QWidget*,QFlags<KShortcutsEditor::ActionType>=,KShortcutsEditor::LetterShortcuts=)
    // 1: KShortcutsEditor::KShortcutsEditor(QWidget*,QFlags<KShortcutsEditor::ActionType>=,KShortcutsEditor::LetterShortcuts=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KShortcutsEditor(QWidget*,QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KShortcutsEditor_ActionType_IDX])))->flagsConverter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // KShortcutsEditor(QWidget*,QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_LetterShortcuts_IDX])))->converter, (pyArgs[2])))) {
                overloadId = 1; // KShortcutsEditor(QWidget*,QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts)
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // KShortcutsEditor(KActionCollection*,QWidget*,QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KShortcutsEditor_ActionType_IDX])))->flagsConverter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // KShortcutsEditor(KActionCollection*,QWidget*,QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_LetterShortcuts_IDX])))->converter, (pyArgs[3])))) {
                overloadId = 0; // KShortcutsEditor(KActionCollection*,QWidget*,QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KShortcutsEditor(KActionCollection *collection, QWidget *parent, QFlags<KShortcutsEditor::ActionType> actionTypes, KShortcutsEditor::LetterShortcuts allowLetterShortcuts)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"actionTypes", 2}, {"allowLetterShortcuts", 3}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KShortcutsEditor_ActionType_IDX])))->flagsConverter, (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_LetterShortcuts_IDX])))->converter, (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KActionCollection *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<KShortcutsEditor::ActionType> cppArg2(KShortcutsEditor::ActionType::AllActions);
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::KShortcutsEditor::LetterShortcuts cppArg3(KShortcutsEditor::LetterShortcuts::LetterShortcutsAllowed);
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KShortcutsEditor(KActionCollection*,QWidget*,QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KShortcutsEditorWrapper(cppArg0, cppArg1, cppArg2, cppArg3);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KShortcutsEditorWrapper(cppArg0, cppArg1, cppArg2, cppArg3);
                }

            }
            break;
        }
        case 1: // KShortcutsEditor(QWidget *parent, QFlags<KShortcutsEditor::ActionType> actionTypes, KShortcutsEditor::LetterShortcuts allowLetterShortcuts)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"actionTypes", 1}, {"allowLetterShortcuts", 2}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KShortcutsEditor_ActionType_IDX])))->flagsConverter, (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_LetterShortcuts_IDX])))->converter, (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<KShortcutsEditor::ActionType> cppArg1(KShortcutsEditor::ActionType::AllActions);
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::KShortcutsEditor::LetterShortcuts cppArg2(KShortcutsEditor::LetterShortcuts::LetterShortcutsAllowed);
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KShortcutsEditor(QWidget*,QFlags<KShortcutsEditor::ActionType>,KShortcutsEditor::LetterShortcuts)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KShortcutsEditorWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KShortcutsEditorWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KShortcutsEditor >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KShortcutsEditorFunc_actionTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsEditor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // actionTypes()const
        QFlags<KShortcutsEditor::ActionType> cppResult = const_cast<const ::KShortcutsEditor *>(cppSelf)->actionTypes();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KShortcutsEditor_ActionType_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KShortcutsEditorFunc_addCollection(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsEditor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addCollection", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);

    if (PyArg_ParseTuple(args, "|OO:addCollection", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KShortcutsEditor::addCollection(KActionCollection*,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addCollection(KActionCollection*,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // addCollection(KActionCollection*,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addCollection", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"title", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addCollection", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KActionCollection *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addCollection(KActionCollection*,QString)
            cppSelf->addCollection(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsEditorFunc_allDefault(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsEditor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // allDefault()
        cppSelf->allDefault();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsEditorFunc_clearCollections(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsEditor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearCollections()
        cppSelf->clearCollections();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsEditorFunc_isModified(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsEditor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isModified()const
        bool cppResult = const_cast<const ::KShortcutsEditor *>(cppSelf)->isModified();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KShortcutsEditorFunc_save(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsEditor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // save()
        cppSelf->save();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsEditorFunc_setActionTypes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsEditor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KShortcutsEditor::setActionTypes(QFlags<KShortcutsEditor::ActionType>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KShortcutsEditor_ActionType_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setActionTypes(QFlags<KShortcutsEditor::ActionType>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setActionTypes", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);

    // Call function/method
    {
        ::QFlags<KShortcutsEditor::ActionType> cppArg0 = QFlags<KShortcutsEditor::ActionType>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setActionTypes(QFlags<KShortcutsEditor::ActionType>)
            cppSelf->setActionTypes(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutsEditorFunc_undo(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutsEditor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // undo()
        cppSelf->undo();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KShortcutsEditor_PropertyStrings[] = {
    "actionTypes::",
    nullptr // Sentinel
};

static const char *Sbk_KShortcutsEditor_EnumFlagInfo[] = {
    "ActionType:IntFlag:ActionTypes",
    "LetterShortcuts:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KShortcutsEditor_methods[] = {
    {"actionTypes", reinterpret_cast<PyCFunction>(Sbk_KShortcutsEditorFunc_actionTypes), METH_NOARGS, nullptr},
    {"addCollection", reinterpret_cast<PyCFunction>(Sbk_KShortcutsEditorFunc_addCollection), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"allDefault", reinterpret_cast<PyCFunction>(Sbk_KShortcutsEditorFunc_allDefault), METH_NOARGS, nullptr},
    {"clearCollections", reinterpret_cast<PyCFunction>(Sbk_KShortcutsEditorFunc_clearCollections), METH_NOARGS, nullptr},
    {"isModified", reinterpret_cast<PyCFunction>(Sbk_KShortcutsEditorFunc_isModified), METH_NOARGS, nullptr},
    {"save", reinterpret_cast<PyCFunction>(Sbk_KShortcutsEditorFunc_save), METH_NOARGS, nullptr},
    {"setActionTypes", reinterpret_cast<PyCFunction>(Sbk_KShortcutsEditorFunc_setActionTypes), METH_O, nullptr},
    {"undo", reinterpret_cast<PyCFunction>(Sbk_KShortcutsEditorFunc_undo), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KShortcutsEditor_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KShortcutsEditor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KShortcutsEditorWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KShortcutsEditor_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KShortcutsEditor_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KShortcutsEditorSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KShortcutsEditor *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KShortcutsEditor_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KShortcutsEditor_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KShortcutsEditor_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KShortcutsEditor_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KShortcutsEditor_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KShortcutsEditor_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KShortcutsEditor_spec = {
    "1:KXmlGui.KShortcutsEditor",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KShortcutsEditor_slots
};

} //extern "C"

static void *Sbk_KShortcutsEditor_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KShortcutsEditor *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KShortcutsEditor *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KShortcutsEditor *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KShortcutsEditor_ActionType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KShortcutsEditor::ActionType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KShortcutsEditor::ActionType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KShortcutsEditor_ActionType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_ActionType_IDX])))
        return Enum_PythonToCpp_KShortcutsEditor_ActionType;
    return {};
}

static PyObject *KShortcutsEditor_ActionType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KShortcutsEditor::ActionType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KShortcutsEditor::ActionType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KShortcutsEditor_ActionType(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KShortcutsEditor::ActionType>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KShortcutsEditor::ActionType> *>(cppOut) = value;

}

static PyObject *KShortcutsEditor_ActionType_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KShortcutsEditor::ActionType> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_ActionType_IDX]), flags.toInt());

}

static void Enum_PythonToCpp_KShortcutsEditor_LetterShortcuts(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KShortcutsEditor::LetterShortcuts>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KShortcutsEditor::LetterShortcuts *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KShortcutsEditor_LetterShortcuts_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_LetterShortcuts_IDX])))
        return Enum_PythonToCpp_KShortcutsEditor_LetterShortcuts;
    return {};
}

static PyObject *KShortcutsEditor_LetterShortcuts_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KShortcutsEditor::LetterShortcuts>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KShortcutsEditor::LetterShortcuts *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KShortcutsEditor_PythonToCpp_KShortcutsEditor_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KShortcutsEditor_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KShortcutsEditor_PythonToCpp_KShortcutsEditor_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KShortcutsEditor_TypeF()))
        return KShortcutsEditor_PythonToCpp_KShortcutsEditor_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KShortcutsEditor_PTR_CppToPython_KShortcutsEditor(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KShortcutsEditor *>(const_cast<void *>(cppIn)), Sbk_KShortcutsEditor_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KShortcutsEditor_SignatureStrings[] = {
    "1:KXmlGui.KShortcutsEditor(self,collection:KXmlGui.KActionCollection,parent:PySide6.QtWidgets.QWidget,actionTypes:KXmlGui.KShortcutsEditor.ActionType=KShortcutsEditor.ActionType.AllActions,allowLetterShortcuts:KXmlGui.KShortcutsEditor.LetterShortcuts=KShortcutsEditor.LetterShortcuts.LetterShortcutsAllowed,*:KeywordOnly=None,actionTypes:KXmlGui.KShortcutsEditor.ActionType=None)",
    "0:KXmlGui.KShortcutsEditor(self,parent:PySide6.QtWidgets.QWidget,actionTypes:KXmlGui.KShortcutsEditor.ActionType=KShortcutsEditor.ActionType.AllActions,allowLetterShortcuts:KXmlGui.KShortcutsEditor.LetterShortcuts=KShortcutsEditor.LetterShortcuts.LetterShortcutsAllowed,*:KeywordOnly=None,actionTypes:KXmlGui.KShortcutsEditor.ActionType=None)",
    "KXmlGui.KShortcutsEditor.actionTypes(self)->KXmlGui.KShortcutsEditor.ActionType",
    "KXmlGui.KShortcutsEditor.addCollection(self,arg__1:KXmlGui.KActionCollection,title:QString=QString())",
    "KXmlGui.KShortcutsEditor.allDefault(self)",
    "KXmlGui.KShortcutsEditor.clearCollections(self)",
    "KXmlGui.KShortcutsEditor.isModified(self)->bool",
    "KXmlGui.KShortcutsEditor.save(self)",
    "KXmlGui.KShortcutsEditor.setActionTypes(self,actionTypes:KXmlGui.KShortcutsEditor.ActionType)",
    "KXmlGui.KShortcutsEditor.undo(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KShortcutsEditor_SignatureByteSize = 270;
static constexpr uint8_t KShortcutsEditor_SignatureBytes[270] = {
    0x78, 0xda, 0xed, 0x93, 0x4d, 0x4b, 0xc4, 0x30, 0x10, 0x86, 0xef, 0xfe, 0x92, 0xad, 0xc4, 0xe0,
    0x5e, 0x3c, 0x14, 0x2a, 0x14, 0x15, 0x0f, 0xf5, 0xab, 0x54, 0xd0, 0xdb, 0x12, 0x9b, 0x69, 0x0d,
    0x8c, 0x99, 0x25, 0x99, 0xba, 0xf4, 0xdf, 0xcb, 0xb6, 0x6b, 0x2b, 0x85, 0xb4, 0xae, 0x67, 0x4f,
    0xc9, 0x30, 0xcf, 0xbc, 0x33, 0x79, 0xc3, 0xac, 0xe3, 0xec, 0xf5, 0x03, 0x6f, 0x1b, 0x23, 0xb3,
    0xe2, 0x9d, 0x1c, 0x97, 0x0d, 0xfb, 0x1b, 0x6d, 0x98, 0xdc, 0xca, 0x03, 0x56, 0xa2, 0x24, 0x44,
    0x28, 0xd9, 0x90, 0x1d, 0xc1, 0xb4, 0x8b, 0xaf, 0x86, 0x8c, 0xd8, 0x2a, 0x07, 0x96, 0xe3, 0xa7,
    0xb6, 0x30, 0x1a, 0x2e, 0x64, 0xce, 0x2f, 0x46, 0xd7, 0xc0, 0x5e, 0xe6, 0xfd, 0x45, 0xa8, 0x8e,
    0x7b, 0x6e, 0xb7, 0xe0, 0x83, 0xfd, 0x64, 0x3a, 0x40, 0xc9, 0x4c, 0x4e, 0xa6, 0x88, 0x7d, 0xe4,
    0x85, 0x42, 0xa4, 0xdd, 0x1d, 0x30, 0x83, 0x1b, 0x0a, 0xc2, 0xfa, 0x13, 0x30, 0x59, 0x02, 0xa6,
    0x71, 0xba, 0xef, 0x06, 0x5a, 0x9c, 0xc6, 0x19, 0xb4, 0x3b, 0x72, 0xfa, 0xd1, 0x62, 0x9b, 0x3c,
    0x90, 0x85, 0xa3, 0xdf, 0xb7, 0x2f, 0x8a, 0x4e, 0xce, 0x17, 0xbc, 0xff, 0xb7, 0xf5, 0x4f, 0xb6,
    0x06, 0xc9, 0x1f, 0x72, 0x9d, 0xc1, 0xd1, 0xd9, 0xe5, 0x2f, 0x54, 0x67, 0xf4, 0xb4, 0x1e, 0x97,
    0xa0, 0xff, 0x32, 0xe5, 0xea, 0xcd, 0x66, 0x3d, 0xb3, 0x2a, 0x6c, 0x18, 0x21, 0xce, 0x0b, 0x76,
    0xc6, 0xd6, 0xc9, 0xe1, 0x5c, 0x45, 0x73, 0x53, 0x23, 0x5e, 0x43, 0xa5, 0x1a, 0xe4, 0x7e, 0xe8,
    0x30, 0x59, 0x22, 0x28, 0x37, 0xf6, 0xf2, 0x4b, 0xbc, 0xf1, 0xf7, 0xa4, 0x4d, 0x65, 0x40, 0x7f,
    0xdb, 0xf1, 0x46, 0x84, 0x61, 0xde, 0xab, 0x4f, 0x58, 0xd2, 0xf4, 0xc0, 0xe9, 0xc4, 0xe6, 0x63,
    0xbf, 0x71, 0x46, 0xbd, 0xb1, 0x9a, 0x0e, 0x13, 0x7c, 0x01, 0x9a, 0xa4, 0xc9, 0xa4
};
#endif

PyTypeObject *init_KShortcutsEditor(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX].type;

    Shiboken::AutoDecRef Sbk_KShortcutsEditor_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KShortcutsEditor_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KShortcutsEditor",
        "KShortcutsEditor*",
        &Sbk_KShortcutsEditor_spec,
        &Shiboken::callCppDestructor< KShortcutsEditor >,
        Sbk_KShortcutsEditor_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KShortcutsEditor_TypeF(); // references _Sbk_KShortcutsEditor_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KShortcutsEditor_SignatureStrings);
#else
    InitSignatureBytes(pyType, KShortcutsEditor_SignatureBytes, KShortcutsEditor_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KShortcutsEditor_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KShortcutsEditor_PythonToCpp_KShortcutsEditor_PTR,
        is_KShortcutsEditor_PythonToCpp_KShortcutsEditor_PTR_Convertible,
        KShortcutsEditor_PTR_CppToPython_KShortcutsEditor);

    Shiboken::Conversions::registerConverterName(converter, "KShortcutsEditor");
    Shiboken::Conversions::registerConverterName(converter, "KShortcutsEditor*");
    Shiboken::Conversions::registerConverterName(converter, "KShortcutsEditor&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KShortcutsEditor).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KShortcutsEditorWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KShortcutsEditor_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KShortcutsEditor_TypeF(), &Sbk_KShortcutsEditorSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KShortcutsEditor_TypeF(), &Sbk_KShortcutsEditor_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KShortcutsEditor_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'ActionType'.
    const char *ActionType_Initializer[] = {
        "WidgetAction",
        "WindowAction",
        "ApplicationAction",
        "GlobalAction",
        "AllActions",
        nullptr};
    // "uint32_t" used instead of "unsigned int"
    constexpr uint32_t ActionType_InitializerValues[] = {
        uint32_t(KShortcutsEditor::ActionType::WidgetAction),      //  0x00000000  0
        uint32_t(KShortcutsEditor::ActionType::WindowAction),      //  0x00000001  1
        uint32_t(KShortcutsEditor::ActionType::ApplicationAction), //  0x00000002  2
        uint32_t(KShortcutsEditor::ActionType::GlobalAction),      //  0x00000004  4
        uint32_t(KShortcutsEditor::ActionType::AllActions)         //  0xffffffff  4294967295
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KShortcutsEditor_TypeF(),
        "1:KXmlGui.KShortcutsEditor.ActionType",
        ActionType_Initializer, ActionType_InitializerValues);
    SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_ActionType_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKXmlGuiTypeStructs[SBK_QFlags_KShortcutsEditor_ActionType_IDX].type =
        EType;
    // Register converter for enum 'KShortcutsEditor::ActionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KShortcutsEditor_ActionType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KShortcutsEditor_ActionType,
            is_Enum_PythonToCpp_KShortcutsEditor_ActionType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KShortcutsEditor::ActionType");
        Shiboken::Conversions::registerConverterAlias(converter, "ActionType");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KShortcutsEditor_ActionType_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KShortcutsEditor_ActionType,
            is_Enum_PythonToCpp_KShortcutsEditor_ActionType_Convertible);
        // Register converter for flag 'QFlags<KShortcutsEditor::ActionType>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KShortcutsEditor::ActionType>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KShortcutsEditor::ActionTypes");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'ActionType' enum/flags.

    // Initialization of enum 'LetterShortcuts'.
    const char *LetterShortcuts_Initializer[] = {
        "LetterShortcutsDisallowed",
        "LetterShortcutsAllowed",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t LetterShortcuts_InitializerValues[] = {
        uint8_t(KShortcutsEditor::LetterShortcuts::LetterShortcutsDisallowed), //  0x00  0
        uint8_t(KShortcutsEditor::LetterShortcuts::LetterShortcutsAllowed)     //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KShortcutsEditor_TypeF(),
        "1:KXmlGui.KShortcutsEditor.LetterShortcuts",
        LetterShortcuts_Initializer, LetterShortcuts_InitializerValues);
    SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_LetterShortcuts_IDX].type = EType;
    // Register converter for enum 'KShortcutsEditor::LetterShortcuts'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KShortcutsEditor_LetterShortcuts_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KShortcutsEditor_LetterShortcuts,
            is_Enum_PythonToCpp_KShortcutsEditor_LetterShortcuts_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KShortcutsEditor::LetterShortcuts");
        Shiboken::Conversions::registerConverterAlias(converter, "LetterShortcuts");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'LetterShortcuts' enum.

    PySide::Signal::registerSignals(pyType, &::KShortcutsEditor::staticMetaObject);
    qRegisterMetaType< ::KShortcutsEditor::ActionType >("KShortcutsEditor::ActionType");
    qRegisterMetaType< ::KShortcutsEditor::LetterShortcuts >("KShortcutsEditor::LetterShortcuts");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KShortcutsEditor::staticMetaObject, sizeof(KShortcutsEditorWrapper));

    return pyType;
}
