// This file was generated by qtwaylandscanner
// source file is kde-output-device-v2.xml

#ifndef QT_WAYLAND_SERVER_KDE_OUTPUT_DEVICE_V2
#define QT_WAYLAND_SERVER_KDE_OUTPUT_DEVICE_V2

#include "wayland-server-core.h"
#include "wayland-kde-output-device-v2-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  kde_output_device_v2
    {
    public:
        kde_output_device_v2(struct ::wl_client *client, int id, int version);
        kde_output_device_v2(struct ::wl_display *display, int version);
        kde_output_device_v2(struct ::wl_resource *resource);
        kde_output_device_v2();

        virtual ~kde_output_device_v2();

        class Resource
        {
        public:
            Resource() : kde_output_device_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            kde_output_device_v2 *kde_output_device_v2_object;
            kde_output_device_v2 *object() { return kde_output_device_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum subpixel {
            subpixel_unknown = 0,
            subpixel_none = 1,
            subpixel_horizontal_rgb = 2,
            subpixel_horizontal_bgr = 3,
            subpixel_vertical_rgb = 4,
            subpixel_vertical_bgr = 5,
        };

        enum transform {
            transform_normal = 0,
            transform_90 = 1,
            transform_180 = 2,
            transform_270 = 3,
            transform_flipped = 4,
            transform_flipped_90 = 5,
            transform_flipped_180 = 6,
            transform_flipped_270 = 7,
        };

        enum capability {
            capability_overscan = 0x1, // if this output_device can use overscan
            capability_vrr = 0x2, // if this outputdevice supports variable refresh rate
            capability_rgb_range = 0x4, // if setting the rgb range is possible
            capability_high_dynamic_range = 0x8, // if this outputdevice supports high dynamic range
            capability_wide_color_gamut = 0x10, // if this outputdevice supports a wide color gamut
            capability_auto_rotate = 0x20, // if this outputdevice supports autorotation
            capability_icc_profile = 0x40, // if this outputdevice supports icc profiles
            capability_brightness = 0x80, // if this outputdevice supports the brightness setting
            capability_built_in_color = 0x100, // if this outputdevice supports the built-in color profile
            capability_ddc_ci = 0x200, // if this outputdevice supports DDC/CI
            capability_max_bits_per_color = 0x400, // if this outputdevice supports setting max bpc
            capability_edr = 0x800, // if this outputdevice supports EDR
            capability_sharpness = 0x1000, // if this outputdevice supports the sharpness setting
        };

        enum vrr_policy {
            vrr_policy_never = 0,
            vrr_policy_always = 1,
            vrr_policy_automatic = 2,
        };

        enum rgb_range {
            rgb_range_automatic = 0,
            rgb_range_full = 1,
            rgb_range_limited = 2,
        };

        enum auto_rotate_policy {
            auto_rotate_policy_never = 0,
            auto_rotate_policy_in_tablet_mode = 1,
            auto_rotate_policy_always = 2,
        };

        enum color_profile_source {
            color_profile_source_sRGB = 0,
            color_profile_source_ICC = 1,
            color_profile_source_EDID = 2,
        };

        enum color_power_tradeoff {
            color_power_tradeoff_efficiency = 0, // prefer efficiency and performance
            color_power_tradeoff_accuracy = 1, // prefer accuracy
        };

        enum edr_policy {
            edr_policy_never = 0,
            edr_policy_always = 1,
        };

        void send_geometry(int32_t x, int32_t y, int32_t physical_width, int32_t physical_height, int32_t subpixel, const QString &make, const QString &model, int32_t transform);
        void send_geometry(struct ::wl_resource *resource, int32_t x, int32_t y, int32_t physical_width, int32_t physical_height, int32_t subpixel, const QString &make, const QString &model, int32_t transform);
        void send_current_mode(struct ::wl_resource *mode);
        void send_current_mode(struct ::wl_resource *resource, struct ::wl_resource *mode);
        void send_mode(struct ::wl_resource *mode);
        void send_mode(struct ::wl_resource *resource, struct ::wl_resource *mode);
        void send_done();
        void send_done(struct ::wl_resource *resource);
        void send_scale(wl_fixed_t factor);
        void send_scale(struct ::wl_resource *resource, wl_fixed_t factor);
        void send_edid(const QString &raw);
        void send_edid(struct ::wl_resource *resource, const QString &raw);
        void send_enabled(int32_t enabled);
        void send_enabled(struct ::wl_resource *resource, int32_t enabled);
        void send_uuid(const QString &uuid);
        void send_uuid(struct ::wl_resource *resource, const QString &uuid);
        void send_serial_number(const QString &serialNumber);
        void send_serial_number(struct ::wl_resource *resource, const QString &serialNumber);
        void send_eisa_id(const QString &eisaId);
        void send_eisa_id(struct ::wl_resource *resource, const QString &eisaId);
        void send_capabilities(uint32_t flags);
        void send_capabilities(struct ::wl_resource *resource, uint32_t flags);
        void send_overscan(uint32_t overscan);
        void send_overscan(struct ::wl_resource *resource, uint32_t overscan);
        void send_vrr_policy(uint32_t vrr_policy);
        void send_vrr_policy(struct ::wl_resource *resource, uint32_t vrr_policy);
        void send_rgb_range(uint32_t rgb_range);
        void send_rgb_range(struct ::wl_resource *resource, uint32_t rgb_range);
        void send_name(const QString &name);
        void send_name(struct ::wl_resource *resource, const QString &name);
        void send_high_dynamic_range(uint32_t hdr_enabled);
        void send_high_dynamic_range(struct ::wl_resource *resource, uint32_t hdr_enabled);
        void send_sdr_brightness(uint32_t sdr_brightness);
        void send_sdr_brightness(struct ::wl_resource *resource, uint32_t sdr_brightness);
        void send_wide_color_gamut(uint32_t wcg_enabled);
        void send_wide_color_gamut(struct ::wl_resource *resource, uint32_t wcg_enabled);
        void send_auto_rotate_policy(uint32_t policy);
        void send_auto_rotate_policy(struct ::wl_resource *resource, uint32_t policy);
        void send_icc_profile_path(const QString &profile_path);
        void send_icc_profile_path(struct ::wl_resource *resource, const QString &profile_path);
        void send_brightness_metadata(uint32_t max_peak_brightness, uint32_t max_frame_average_brightness, uint32_t min_brightness);
        void send_brightness_metadata(struct ::wl_resource *resource, uint32_t max_peak_brightness, uint32_t max_frame_average_brightness, uint32_t min_brightness);
        void send_brightness_overrides(int32_t max_peak_brightness, int32_t max_average_brightness, int32_t min_brightness);
        void send_brightness_overrides(struct ::wl_resource *resource, int32_t max_peak_brightness, int32_t max_average_brightness, int32_t min_brightness);
        void send_sdr_gamut_wideness(uint32_t gamut_wideness);
        void send_sdr_gamut_wideness(struct ::wl_resource *resource, uint32_t gamut_wideness);
        void send_color_profile_source(uint32_t source);
        void send_color_profile_source(struct ::wl_resource *resource, uint32_t source);
        void send_brightness(uint32_t brightness);
        void send_brightness(struct ::wl_resource *resource, uint32_t brightness);
        void send_color_power_tradeoff(uint32_t preference);
        void send_color_power_tradeoff(struct ::wl_resource *resource, uint32_t preference);
        void send_dimming(uint32_t multiplier);
        void send_dimming(struct ::wl_resource *resource, uint32_t multiplier);
        void send_replication_source(const QString &source);
        void send_replication_source(struct ::wl_resource *resource, const QString &source);
        void send_ddc_ci_allowed(uint32_t allowed);
        void send_ddc_ci_allowed(struct ::wl_resource *resource, uint32_t allowed);
        void send_max_bits_per_color(uint32_t max_bpc);
        void send_max_bits_per_color(struct ::wl_resource *resource, uint32_t max_bpc);
        void send_max_bits_per_color_range(uint32_t min_value, uint32_t max_value);
        void send_max_bits_per_color_range(struct ::wl_resource *resource, uint32_t min_value, uint32_t max_value);
        void send_automatic_max_bits_per_color_limit(uint32_t max_bpc_limit);
        void send_automatic_max_bits_per_color_limit(struct ::wl_resource *resource, uint32_t max_bpc_limit);
        void send_edr_policy(uint32_t policy);
        void send_edr_policy(struct ::wl_resource *resource, uint32_t policy);
        void send_sharpness(uint32_t sharpness);
        void send_sharpness(struct ::wl_resource *resource, uint32_t sharpness);

    protected:
        virtual Resource *kde_output_device_v2_allocate();

        virtual void kde_output_device_v2_destroy_global();

        virtual void kde_output_device_v2_bind_resource(Resource *resource);
        virtual void kde_output_device_v2_destroy_resource(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            kde_output_device_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  kde_output_device_mode_v2
    {
    public:
        kde_output_device_mode_v2(struct ::wl_client *client, int id, int version);
        kde_output_device_mode_v2(struct ::wl_display *display, int version);
        kde_output_device_mode_v2(struct ::wl_resource *resource);
        kde_output_device_mode_v2();

        virtual ~kde_output_device_mode_v2();

        class Resource
        {
        public:
            Resource() : kde_output_device_mode_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            kde_output_device_mode_v2 *kde_output_device_mode_v2_object;
            kde_output_device_mode_v2 *object() { return kde_output_device_mode_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_size(int32_t width, int32_t height);
        void send_size(struct ::wl_resource *resource, int32_t width, int32_t height);
        void send_refresh(int32_t refresh);
        void send_refresh(struct ::wl_resource *resource, int32_t refresh);
        void send_preferred();
        void send_preferred(struct ::wl_resource *resource);
        void send_removed();
        void send_removed(struct ::wl_resource *resource);

    protected:
        virtual Resource *kde_output_device_mode_v2_allocate();

        virtual void kde_output_device_mode_v2_destroy_global();

        virtual void kde_output_device_mode_v2_bind_resource(Resource *resource);
        virtual void kde_output_device_mode_v2_destroy_resource(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            kde_output_device_mode_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
