
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kpixmapregionselectorwidget_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <kpixmapregionselectorwidget.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qimage.h>
#include <qmenu.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPixmapRegionSelectorWidget_Type = nullptr;
static PyTypeObject *Sbk_KPixmapRegionSelectorWidget_TypeF(void)
{
    return _Sbk_KPixmapRegionSelectorWidget_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KPixmapRegionSelectorWidgetWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KPixmapRegionSelectorWidgetWrapper::KPixmapRegionSelectorWidgetWrapper(::QWidget * parent) : KPixmapRegionSelectorWidget(parent)
{
}

void KPixmapRegionSelectorWidgetWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, signal);
}

void KPixmapRegionSelectorWidgetWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

::QMenu * KPixmapRegionSelectorWidgetWrapper::createPopupMenu()
{
    static const char *funcName = "createPopupMenu";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPixmapRegionSelectorWidget::createPopupMenu();
    }
    return sbk_o_createPopupMenu("KPixmapRegionSelectorWidget", funcName, gil, pyOverride);
}

::QMenu * KPixmapRegionSelectorWidgetWrapper::sbk_o_createPopupMenu(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QMenu >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMenu *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KPixmapRegionSelectorWidgetWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

int KPixmapRegionSelectorWidgetWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KPixmapRegionSelectorWidget", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorWidgetWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, signal);
}

void KPixmapRegionSelectorWidgetWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

bool KPixmapRegionSelectorWidgetWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

bool KPixmapRegionSelectorWidgetWrapper::eventFilter(::QObject * obj, ::QEvent * ev)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPixmapRegionSelectorWidget::eventFilter(obj, ev);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, obj, ev);
}

void KPixmapRegionSelectorWidgetWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

bool KPixmapRegionSelectorWidgetWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, next);
}

void KPixmapRegionSelectorWidgetWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

bool KPixmapRegionSelectorWidgetWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KPixmapRegionSelectorWidget", funcName, gil, pyOverride);
}

int KPixmapRegionSelectorWidgetWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, arg__1);
}

void KPixmapRegionSelectorWidgetWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, painter);
}

void KPixmapRegionSelectorWidgetWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

::QVariant KPixmapRegionSelectorWidgetWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, arg__1);
}

void KPixmapRegionSelectorWidgetWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

int KPixmapRegionSelectorWidgetWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, arg__1);
}

::QSize KPixmapRegionSelectorWidgetWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KPixmapRegionSelectorWidget", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorWidgetWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

bool KPixmapRegionSelectorWidgetWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KPixmapRegionSelectorWidgetWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KPixmapRegionSelectorWidget", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorWidgetWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

::QPaintDevice * KPixmapRegionSelectorWidgetWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, offset);
}

void KPixmapRegionSelectorWidgetWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, visible);
}

::QPainter * KPixmapRegionSelectorWidgetWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KPixmapRegionSelectorWidget", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorWidgetWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

::QSize KPixmapRegionSelectorWidgetWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KPixmapRegionSelectorWidget", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorWidgetWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorWidgetWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorWidget_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KPixmapRegionSelectorWidget", funcName, gil, pyOverride, event);
}

const QMetaObject *KPixmapRegionSelectorWidgetWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KPixmapRegionSelectorWidget::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KPixmapRegionSelectorWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KPixmapRegionSelectorWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KPixmapRegionSelectorWidgetWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KPixmapRegionSelectorWidgetWrapper *>(this));
    }
    return KPixmapRegionSelectorWidget::qt_metacast(_clname);
}

KPixmapRegionSelectorWidgetWrapper::~KPixmapRegionSelectorWidgetWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KPixmapRegionSelectorWidget_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPixmapRegionSelectorWidget_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPixmapRegionSelectorWidget >()))
        return -1;

    KPixmapRegionSelectorWidgetWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KPixmapRegionSelectorWidget", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPixmapRegionSelectorWidget::KPixmapRegionSelectorWidget(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KPixmapRegionSelectorWidget(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KPixmapRegionSelectorWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KPixmapRegionSelectorWidget(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KPixmapRegionSelectorWidgetWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KPixmapRegionSelectorWidgetWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KPixmapRegionSelectorWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_createPopupMenu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // createPopupMenu()
        QMenu * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KPixmapRegionSelectorWidget::createPopupMenu()
            : cppSelf->createPopupMenu();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KPixmapRegionSelectorWidget::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_pixmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pixmap()const
        QPixmap cppResult = const_cast<const ::KPixmapRegionSelectorWidget *>(cppSelf)->pixmap();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_resetSelection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetSelection()
        cppSelf->resetSelection();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_rotate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPixmapRegionSelectorWidget::rotate(KPixmapRegionSelectorWidget::RotateDirection)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_RotateDirection_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // rotate(KPixmapRegionSelectorWidget::RotateDirection)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "rotate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);

    // Call function/method
    {
        ::KPixmapRegionSelectorWidget::RotateDirection cppArg0{KPixmapRegionSelectorWidget::Rotate90};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // rotate(KPixmapRegionSelectorWidget::RotateDirection)
            cppSelf->rotate(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_rotateClockwise(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // rotateClockwise()
        cppSelf->rotateClockwise();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_rotateCounterclockwise(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // rotateCounterclockwise()
        cppSelf->rotateCounterclockwise();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_selectedImage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectedImage()const
        QImage cppResult = const_cast<const ::KPixmapRegionSelectorWidget *>(cppSelf)->selectedImage();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QImage_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_selectedRegion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectedRegion()const
        QRect cppResult = const_cast<const ::KPixmapRegionSelectorWidget *>(cppSelf)->selectedRegion();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_setFreeSelectionAspectRatio(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setFreeSelectionAspectRatio()
        cppSelf->setFreeSelectionAspectRatio();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_setMaximumWidgetSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setMaximumWidgetSize", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KPixmapRegionSelectorWidget::setMaximumWidgetSize(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setMaximumWidgetSize(int,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setMaximumWidgetSize", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMaximumWidgetSize(int,int)
            cppSelf->setMaximumWidgetSize(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_setPixmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPixmapRegionSelectorWidget::setPixmap(QPixmap)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArg)))) {
        overloadId = 0; // setPixmap(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPixmap", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setPixmap(QPixmap)
            cppSelf->setPixmap(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_setSelectedRegion(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPixmapRegionSelectorWidget::setSelectedRegion(QRect)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArg)))) {
        overloadId = 0; // setSelectedRegion(QRect)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSelectedRegion", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setSelectedRegion(QRect)
            cppSelf->setSelectedRegion(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_setSelectionAspectRatio(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setSelectionAspectRatio", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KPixmapRegionSelectorWidget::setSelectionAspectRatio(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setSelectionAspectRatio(int,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setSelectionAspectRatio", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSelectionAspectRatio(int,int)
            cppSelf->setSelectionAspectRatio(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapRegionSelectorWidgetFunc_unzoomedSelectedRegion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // unzoomedSelectedRegion()const
        QRect cppResult = const_cast<const ::KPixmapRegionSelectorWidget *>(cppSelf)->unzoomedSelectedRegion();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KPixmapRegionSelectorWidget_PropertyStrings[] = {
    "pixmap::",
    nullptr // Sentinel
};

static const char *Sbk_KPixmapRegionSelectorWidget_EnumFlagInfo[] = {
    "RotateDirection:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPixmapRegionSelectorWidget_methods[] = {
    {"createPopupMenu", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_createPopupMenu), METH_NOARGS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_eventFilter), METH_VARARGS, nullptr},
    {"pixmap", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_pixmap), METH_NOARGS, nullptr},
    {"resetSelection", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_resetSelection), METH_NOARGS, nullptr},
    {"rotate", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_rotate), METH_O, nullptr},
    {"rotateClockwise", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_rotateClockwise), METH_NOARGS, nullptr},
    {"rotateCounterclockwise", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_rotateCounterclockwise), METH_NOARGS, nullptr},
    {"selectedImage", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_selectedImage), METH_NOARGS, nullptr},
    {"selectedRegion", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_selectedRegion), METH_NOARGS, nullptr},
    {"setFreeSelectionAspectRatio", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_setFreeSelectionAspectRatio), METH_NOARGS, nullptr},
    {"setMaximumWidgetSize", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_setMaximumWidgetSize), METH_VARARGS, nullptr},
    {"setPixmap", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_setPixmap), METH_O, nullptr},
    {"setSelectedRegion", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_setSelectedRegion), METH_O, nullptr},
    {"setSelectionAspectRatio", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_setSelectionAspectRatio), METH_VARARGS, nullptr},
    {"unzoomedSelectedRegion", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorWidgetFunc_unzoomedSelectedRegion), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KPixmapRegionSelectorWidget_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KPixmapRegionSelectorWidgetWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KPixmapRegionSelectorWidget_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPixmapRegionSelectorWidget_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KPixmapRegionSelectorWidgetSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KPixmapRegionSelectorWidget *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPixmapRegionSelectorWidget_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KPixmapRegionSelectorWidget_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPixmapRegionSelectorWidget_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPixmapRegionSelectorWidget_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPixmapRegionSelectorWidget_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPixmapRegionSelectorWidget_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPixmapRegionSelectorWidget_spec = {
    "1:KWidgetsAddons.KPixmapRegionSelectorWidget",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPixmapRegionSelectorWidget_slots
};

} //extern "C"

static void *Sbk_KPixmapRegionSelectorWidget_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KPixmapRegionSelectorWidget *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KPixmapRegionSelectorWidget *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KPixmapRegionSelectorWidget *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KPixmapRegionSelectorWidget_RotateDirection(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KPixmapRegionSelectorWidget::RotateDirection>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KPixmapRegionSelectorWidget::RotateDirection *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KPixmapRegionSelectorWidget_RotateDirection_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_RotateDirection_IDX])))
        return Enum_PythonToCpp_KPixmapRegionSelectorWidget_RotateDirection;
    return {};
}

static PyObject *KPixmapRegionSelectorWidget_RotateDirection_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KPixmapRegionSelectorWidget::RotateDirection>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KPixmapRegionSelectorWidget::RotateDirection *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPixmapRegionSelectorWidget_PythonToCpp_KPixmapRegionSelectorWidget_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPixmapRegionSelectorWidget_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPixmapRegionSelectorWidget_PythonToCpp_KPixmapRegionSelectorWidget_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPixmapRegionSelectorWidget_TypeF()))
        return KPixmapRegionSelectorWidget_PythonToCpp_KPixmapRegionSelectorWidget_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPixmapRegionSelectorWidget_PTR_CppToPython_KPixmapRegionSelectorWidget(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KPixmapRegionSelectorWidget *>(const_cast<void *>(cppIn)), Sbk_KPixmapRegionSelectorWidget_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPixmapRegionSelectorWidget_SignatureStrings[] = {
    "KWidgetsAddons.KPixmapRegionSelectorWidget(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,pixmap:QPixmap=None)",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.createPopupMenu(self)->PySide6.QtWidgets.QMenu",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.eventFilter(self,obj:PySide6.QtCore.QObject,ev:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.pixmap(self)->PySide6.QtGui.QPixmap",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.resetSelection(self)",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.rotate(self,direction:KWidgetsAddons.KPixmapRegionSelectorWidget.RotateDirection)",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.rotateClockwise(self)",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.rotateCounterclockwise(self)",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.selectedImage(self)->PySide6.QtGui.QImage",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.selectedRegion(self)->PySide6.QtCore.QRect",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.setFreeSelectionAspectRatio(self)",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.setMaximumWidgetSize(self,width:int,height:int)",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.setPixmap(self,pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage])",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.setSelectedRegion(self,rect:PySide6.QtCore.QRect)",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.setSelectionAspectRatio(self,width:int,height:int)",
    "KWidgetsAddons.KPixmapRegionSelectorWidget.unzoomedSelectedRegion(self)->PySide6.QtCore.QRect",
    nullptr}; // Sentinel
#else
static constexpr size_t KPixmapRegionSelectorWidget_SignatureByteSize = 364;
static constexpr uint8_t KPixmapRegionSelectorWidget_SignatureBytes[364] = {
    0x78, 0xda, 0xa5, 0x94, 0x4d, 0x4f, 0xc3, 0x30, 0x0c, 0x86, 0xef, 0xfc, 0x0a, 0x8e, 0x0c, 0x95,
    0x1e, 0x39, 0x54, 0x1a, 0xd2, 0x34, 0x18, 0x42, 0xd5, 0x58, 0x3f, 0x84, 0x38, 0x20, 0x0e, 0x5d,
    0x63, 0xba, 0x8c, 0x34, 0x8e, 0x52, 0x77, 0x5f, 0xbf, 0x9e, 0xb4, 0xd9, 0x00, 0xa9, 0x45, 0x5a,
    0xca, 0xcd, 0xb5, 0xe3, 0xc7, 0xf6, 0x6b, 0xab, 0xe1, 0x2b, 0x67, 0x05, 0x50, 0x35, 0x61, 0x0c,
    0x65, 0xe5, 0x87, 0x11, 0xdf, 0x95, 0x99, 0x4a, 0xa0, 0xe0, 0x28, 0x53, 0x10, 0x90, 0x13, 0x6a,
    0xfb, 0xe4, 0xaa, 0x02, 0xf1, 0xe1, 0xa9, 0x4c, 0x83, 0xa4, 0x20, 0xda, 0xa7, 0x9c, 0xc1, 0xad,
    0x1f, 0xd3, 0x31, 0xdf, 0x8f, 0xad, 0x31, 0x96, 0xb5, 0x10, 0x8a, 0xb4, 0x77, 0x1d, 0x84, 0xb0,
    0xdf, 0xa2, 0x66, 0x0b, 0x29, 0xf6, 0xe3, 0x67, 0x94, 0xe0, 0xa9, 0x96, 0x1d, 0xc4, 0xb6, 0x46,
    0xeb, 0x1b, 0x5d, 0x84, 0x67, 0x37, 0xe0, 0xe7, 0x1a, 0x32, 0x82, 0x08, 0x55, 0xad, 0xe6, 0x20,
    0xeb, 0xb6, 0xa1, 0xd1, 0xcd, 0x5d, 0x4f, 0x2f, 0x4d, 0xd8, 0x85, 0x0c, 0x1b, 0x33, 0xd4, 0x8c,
    0x0b, 0x02, 0x6d, 0xc7, 0xc4, 0xe5, 0xfa, 0xd7, 0x8c, 0x53, 0xd4, 0xe0, 0xc7, 0x8b, 0xe5, 0xda,
    0xe4, 0x78, 0xb0, 0xe9, 0x44, 0x1e, 0x9a, 0x74, 0xd3, 0xc9, 0x12, 0x51, 0xb8, 0x94, 0xb5, 0x82,
    0x74, 0xe7, 0x78, 0xac, 0xb9, 0x7f, 0x54, 0xc9, 0x05, 0xa7, 0xa1, 0x02, 0xb2, 0x3e, 0x13, 0xb4,
    0x58, 0xa7, 0x7c, 0x24, 0xa3, 0xaf, 0x15, 0x80, 0x71, 0x6d, 0x31, 0x81, 0x03, 0x20, 0x69, 0x01,
    0xf7, 0xa7, 0xd4, 0x01, 0xc5, 0xa7, 0x02, 0xf3, 0xcf, 0x2d, 0xaf, 0x60, 0x68, 0xf7, 0x53, 0xac,
    0xa5, 0xd9, 0x62, 0x3e, 0x9c, 0x53, 0xb5, 0x9f, 0xc0, 0x9e, 0xca, 0xac, 0x80, 0x3f, 0x76, 0xd3,
    0xc6, 0x86, 0x40, 0x6d, 0xb0, 0x4b, 0xb5, 0x77, 0x94, 0x98, 0x37, 0x6e, 0x54, 0x9a, 0x69, 0x80,
    0xef, 0x95, 0x4f, 0x2a, 0x65, 0x8c, 0x24, 0x33, 0xf6, 0x90, 0xb9, 0x69, 0x9e, 0xed, 0x78, 0x59,
    0x97, 0xd6, 0x91, 0xf2, 0xc3, 0xf1, 0x16, 0xb6, 0x9c, 0xd1, 0x2a, 0xe0, 0x92, 0xbc, 0x15, 0xf0,
    0x62, 0x45, 0x8d, 0xe9, 0x8a, 0x8e, 0x7e, 0x4e, 0xfd, 0xf4, 0x1f, 0xa0, 0xbd, 0xe2, 0xb2, 0xf0,
    0x5f, 0xa4, 0x49, 0x78, 0xeb, 0x3d, 0x7e, 0xef, 0xb2, 0x4f, 0xf7, 0x77, 0xd7, 0xda, 0x69, 0x57,
    0x7c, 0xaf, 0x39, 0xd1, 0xa0, 0x4f, 0xff, 0x61, 0xf0, 0x1e, 0xf1, 0xff, 0x2f, 0x5b, 0x2d, 0x0f,
    0x88, 0x25, 0xb0, 0xf4, 0xfc, 0xe3, 0xf9, 0x02, 0x29, 0x12, 0x2e, 0x06
};
#endif

PyTypeObject *init_KPixmapRegionSelectorWidget(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX].type;

    Shiboken::AutoDecRef Sbk_KPixmapRegionSelectorWidget_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KPixmapRegionSelectorWidget_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPixmapRegionSelectorWidget",
        "KPixmapRegionSelectorWidget*",
        &Sbk_KPixmapRegionSelectorWidget_spec,
        &Shiboken::callCppDestructor< KPixmapRegionSelectorWidget >,
        Sbk_KPixmapRegionSelectorWidget_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KPixmapRegionSelectorWidget_TypeF(); // references _Sbk_KPixmapRegionSelectorWidget_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPixmapRegionSelectorWidget_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPixmapRegionSelectorWidget_SignatureBytes, KPixmapRegionSelectorWidget_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPixmapRegionSelectorWidget_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPixmapRegionSelectorWidget_PythonToCpp_KPixmapRegionSelectorWidget_PTR,
        is_KPixmapRegionSelectorWidget_PythonToCpp_KPixmapRegionSelectorWidget_PTR_Convertible,
        KPixmapRegionSelectorWidget_PTR_CppToPython_KPixmapRegionSelectorWidget);

    Shiboken::Conversions::registerConverterName(converter, "KPixmapRegionSelectorWidget");
    Shiboken::Conversions::registerConverterName(converter, "KPixmapRegionSelectorWidget*");
    Shiboken::Conversions::registerConverterName(converter, "KPixmapRegionSelectorWidget&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPixmapRegionSelectorWidget).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KPixmapRegionSelectorWidgetWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KPixmapRegionSelectorWidget_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KPixmapRegionSelectorWidget_TypeF(), &Sbk_KPixmapRegionSelectorWidgetSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KPixmapRegionSelectorWidget_TypeF(), &Sbk_KPixmapRegionSelectorWidget_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KPixmapRegionSelectorWidget_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'RotateDirection'.
    const char *RotateDirection_Initializer[] = {
        "Rotate90",
        "Rotate180",
        "Rotate270",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t RotateDirection_InitializerValues[] = {
        uint8_t(KPixmapRegionSelectorWidget::RotateDirection::Rotate90),  //  0x00  0
        uint8_t(KPixmapRegionSelectorWidget::RotateDirection::Rotate180), //  0x01  1
        uint8_t(KPixmapRegionSelectorWidget::RotateDirection::Rotate270)  //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KPixmapRegionSelectorWidget_TypeF(),
        "1:KWidgetsAddons.KPixmapRegionSelectorWidget.RotateDirection",
        RotateDirection_Initializer, RotateDirection_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_RotateDirection_IDX].type = EType;
    // Register converter for enum 'KPixmapRegionSelectorWidget::RotateDirection'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KPixmapRegionSelectorWidget_RotateDirection_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KPixmapRegionSelectorWidget_RotateDirection,
            is_Enum_PythonToCpp_KPixmapRegionSelectorWidget_RotateDirection_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KPixmapRegionSelectorWidget::RotateDirection");
        Shiboken::Conversions::registerConverterAlias(converter, "RotateDirection");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'RotateDirection' enum.

    PySide::Signal::registerSignals(pyType, &::KPixmapRegionSelectorWidget::staticMetaObject);
    qRegisterMetaType< ::KPixmapRegionSelectorWidget::RotateDirection >("KPixmapRegionSelectorWidget::RotateDirection");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KPixmapRegionSelectorWidget::staticMetaObject, sizeof(KPixmapRegionSelectorWidgetWrapper));

    return pyType;
}
