
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "knotifications_python.h"

// main header
#include "knotificationaction_wrapper.h"

// Wrappers providing overrides
#include "knotificationreplyaction_wrapper.h"

// Argument includes
#include <QString>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KNotificationAction_Type = nullptr;
static PyTypeObject *Sbk_KNotificationAction_TypeF(void)
{
    return _Sbk_KNotificationAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KNotificationActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KNotificationActionWrapper::KNotificationActionWrapper(::QObject * parent) : KNotificationAction(parent)
{
}

KNotificationActionWrapper::KNotificationActionWrapper(const ::QString & label) : KNotificationAction(label)
{
}

void KNotificationActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KNotificationReplyActionWrapper::sbk_o_childEvent("KNotificationAction", funcName, gil, pyOverride, event);
}

void KNotificationActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KNotificationReplyActionWrapper::sbk_o_connectNotify("KNotificationAction", funcName, gil, pyOverride, signal);
}

void KNotificationActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KNotificationReplyActionWrapper::sbk_o_customEvent("KNotificationAction", funcName, gil, pyOverride, event);
}

void KNotificationActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KNotificationReplyActionWrapper::sbk_o_connectNotify("KNotificationAction", funcName, gil, pyOverride, signal);
}

bool KNotificationActionWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KNotificationReplyActionWrapper::sbk_o_event("KNotificationAction", funcName, gil, pyOverride, event);
}

bool KNotificationActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KNotificationReplyActionWrapper::sbk_o_eventFilter("KNotificationAction", funcName, gil, pyOverride, watched, event);
}

void KNotificationActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KNotificationReplyActionWrapper::sbk_o_timerEvent("KNotificationAction", funcName, gil, pyOverride, event);
}

const QMetaObject *KNotificationActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KNotificationAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KNotificationActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KNotificationAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KNotificationActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KNotificationActionWrapper *>(this));
    }
    return KNotificationAction::qt_metacast(_clname);
}

KNotificationActionWrapper::~KNotificationActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KNotificationAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KNotificationAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KNotificationAction >()))
        return -1;

    KNotificationActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KNotificationAction", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KNotificationAction::KNotificationAction(QObject*=)
    // 1: KNotificationAction::KNotificationAction(QString)
    if (numArgs == 0) {
        overloadId = 0; // KNotificationAction(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KNotificationAction(QObject*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 1; // KNotificationAction(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KNotificationAction(QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KNotificationAction(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KNotificationActionWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KNotificationActionWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KNotificationAction(const QString &label)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KNotificationAction(QString)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KNotificationActionWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KNotificationActionWrapper(cppArg0);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KNotificationAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KNotificationActionFunc_label(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // label()const
        QString cppResult = const_cast<const ::KNotificationAction *>(cppSelf)->label();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationActionFunc_setLabel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotificationAction::setLabel(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setLabel(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLabel", errInfo, SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLabel(QString)
            cppSelf->setLabel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KNotificationAction_PropertyStrings[] = {
    "label::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KNotificationAction_methods[] = {
    {"label", reinterpret_cast<PyCFunction>(Sbk_KNotificationActionFunc_label), METH_NOARGS, nullptr},
    {"setLabel", reinterpret_cast<PyCFunction>(Sbk_KNotificationActionFunc_setLabel), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KNotificationAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KNotificationAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KNotificationActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KNotificationAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KNotificationAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KNotificationAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KNotificationAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KNotificationAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KNotificationAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KNotificationAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KNotificationAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KNotificationAction_spec = {
    "1:KNotifications.KNotificationAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KNotificationAction_slots
};

} //extern "C"

static void *Sbk_KNotificationAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KNotificationAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KNotificationAction_PythonToCpp_KNotificationAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KNotificationAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KNotificationAction_PythonToCpp_KNotificationAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KNotificationAction_TypeF()))
        return KNotificationAction_PythonToCpp_KNotificationAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KNotificationAction_PTR_CppToPython_KNotificationAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KNotificationAction *>(const_cast<void *>(cppIn)), Sbk_KNotificationAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KNotificationAction_SignatureStrings[] = {
    "1:KNotifications.KNotificationAction(self,parent:PySide6.QtCore.QObject=nullptr,*:KeywordOnly=None,label:QString=None)",
    "0:KNotifications.KNotificationAction(self,label:QString,*:KeywordOnly=None,label:QString=None)",
    "KNotifications.KNotificationAction.label(self)->QString",
    "KNotifications.KNotificationAction.setLabel(self,label:QString)",
    nullptr}; // Sentinel
#else
static constexpr size_t KNotificationAction_SignatureByteSize = 143;
static constexpr uint8_t KNotificationAction_SignatureBytes[143] = {
    0x78, 0xda, 0x33, 0xb4, 0xf2, 0xf6, 0xcb, 0x2f, 0xc9, 0x4c, 0xcb, 0x4c, 0x4e, 0x2c, 0xc9, 0xcc,
    0xcf, 0x2b, 0xd6, 0x43, 0xe1, 0x3a, 0x26, 0x83, 0x48, 0x8d, 0xe2, 0xd4, 0x9c, 0x34, 0x9d, 0x82,
    0xc4, 0xa2, 0xd4, 0xbc, 0x12, 0xab, 0x80, 0xca, 0xe0, 0xcc, 0x94, 0x54, 0x33, 0xbd, 0xc0, 0x12,
    0xe7, 0xfc, 0xa2, 0x54, 0xbd, 0x40, 0xff, 0xa4, 0xac, 0xd4, 0xe4, 0x12, 0xdb, 0xbc, 0xd2, 0x9c,
    0x9c, 0x82, 0x92, 0x22, 0x1d, 0x2d, 0x2b, 0xef, 0xd4, 0xca, 0xf2, 0xfc, 0xa2, 0x14, 0xff, 0xbc,
    0x9c, 0x4a, 0x5b, 0xbf, 0xfc, 0xbc, 0x54, 0x9d, 0x9c, 0xc4, 0xa4, 0xd4, 0x1c, 0xab, 0xc0, 0xe0,
    0x92, 0xa2, 0xcc, 0xbc, 0x74, 0xb0, 0x90, 0x26, 0x97, 0x01, 0xd1, 0xd6, 0xa2, 0xe8, 0x26, 0xd6,
    0x78, 0xc2, 0x86, 0xeb, 0x81, 0xb5, 0x81, 0xad, 0xd0, 0xd4, 0xb5, 0x83, 0xea, 0x26, 0x46, 0x5f,
    0x71, 0x6a, 0x89, 0x0f, 0x5c, 0x2b, 0xaa, 0xe5, 0x9a, 0x5c, 0x00, 0xdf, 0x35, 0x7b, 0x5f
};
#endif

PyTypeObject *init_KNotificationAction(PyObject *module)
{
    if (SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX].type != nullptr)
        return SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KNotificationAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KNotificationAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KNotificationAction",
        "KNotificationAction*",
        &Sbk_KNotificationAction_spec,
        &Shiboken::callCppDestructor< KNotificationAction >,
        Sbk_KNotificationAction_Type_bases.object(),
        0);
    auto *pyType = Sbk_KNotificationAction_TypeF(); // references _Sbk_KNotificationAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KNotificationAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KNotificationAction_SignatureBytes, KNotificationAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KNotificationAction_PropertyStrings);
    SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KNotificationAction_PythonToCpp_KNotificationAction_PTR,
        is_KNotificationAction_PythonToCpp_KNotificationAction_PTR_Convertible,
        KNotificationAction_PTR_CppToPython_KNotificationAction);

    Shiboken::Conversions::registerConverterName(converter, "KNotificationAction");
    Shiboken::Conversions::registerConverterName(converter, "KNotificationAction*");
    Shiboken::Conversions::registerConverterName(converter, "KNotificationAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KNotificationAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KNotificationActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KNotificationAction_TypeF(), &Sbk_KNotificationAction_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KNotificationAction::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KNotificationAction::staticMetaObject, sizeof(KNotificationActionWrapper));

    return pyType;
}
