#ifndef UD_ITAB_H
#define UD_ITAB_H

/* itab.h -- generated by udis86:scripts/ud_itab.py, do no edit */

/* ud_table_type -- lookup table types (see decode.c) */
enum ud_table_type {
    UD_TAB__OPC_TABLE,
    UD_TAB__OPC_SSE,
    UD_TAB__OPC_REG,
    UD_TAB__OPC_RM,
    UD_TAB__OPC_MOD,
    UD_TAB__OPC_MODE,
    UD_TAB__OPC_X87,
    UD_TAB__OPC_ASIZE,
    UD_TAB__OPC_OSIZE,
    UD_TAB__OPC_3DNOW,
    UD_TAB__OPC_VENDOR,
    UD_TAB__OPC_VEX,
    UD_TAB__OPC_VEX_W,
    UD_TAB__OPC_VEX_L
};

/* ud_mnemonic -- mnemonic constants */
enum ud_mnemonic_code {
    UD_Iaaa,
    UD_Iaad,
    UD_Iaam,
    UD_Iaas,
    UD_Iadc,
    UD_Iadcx,
    UD_Iadd,
    UD_Iaddpd,
    UD_Iaddps,
    UD_Iaddsd,
    UD_Iaddss,
    UD_Iaddsubpd,
    UD_Iaddsubps,
    UD_Iadox,
    UD_Iaesdec,
    UD_Iaesdeclast,
    UD_Iaesenc,
    UD_Iaesenclast,
    UD_Iaesimc,
    UD_Iaeskeygenassist,
    UD_Iand,
    UD_Iandn,
    UD_Iandnpd,
    UD_Iandnps,
    UD_Iandpd,
    UD_Iandps,
    UD_Iarpl,
    UD_Ibextr,
    UD_Iblcfill,
    UD_Iblci,
    UD_Iblcic,
    UD_Iblcmsk,
    UD_Iblcs,
    UD_Iblendpd,
    UD_Iblendps,
    UD_Iblendvpd,
    UD_Iblendvps,
    UD_Iblsfill,
    UD_Iblsi,
    UD_Iblsic,
    UD_Iblsmsk,
    UD_Iblsr,
    UD_Ibndcl,
    UD_Ibndcn,
    UD_Ibndcu,
    UD_Ibndldx,
    UD_Ibndmk,
    UD_Ibndmov,
    UD_Ibndstx,
    UD_Ibound,
    UD_Ibsf,
    UD_Ibsr,
    UD_Ibswap,
    UD_Ibt,
    UD_Ibtc,
    UD_Ibtr,
    UD_Ibts,
    UD_Ibzhi,
    UD_Icall,
    UD_Icbw,
    UD_Icdq,
    UD_Icdqe,
    UD_Iclac,
    UD_Iclc,
    UD_Icld,
    UD_Iclflush,
    UD_Iclflushopt,
    UD_Iclgi,
    UD_Icli,
    UD_Iclrssbsy,
    UD_Iclts,
    UD_Icmc,
    UD_Icmova,
    UD_Icmovae,
    UD_Icmovb,
    UD_Icmovbe,
    UD_Icmove,
    UD_Icmovg,
    UD_Icmovge,
    UD_Icmovl,
    UD_Icmovle,
    UD_Icmovne,
    UD_Icmovno,
    UD_Icmovnp,
    UD_Icmovns,
    UD_Icmovo,
    UD_Icmovp,
    UD_Icmovs,
    UD_Icmp,
    UD_Icmpeqpd,
    UD_Icmpeqps,
    UD_Icmpeqsd,
    UD_Icmpeqss,
    UD_Icmplepd,
    UD_Icmpleps,
    UD_Icmplesd,
    UD_Icmpless,
    UD_Icmpltpd,
    UD_Icmpltps,
    UD_Icmpltsd,
    UD_Icmpltss,
    UD_Icmpneqpd,
    UD_Icmpneqps,
    UD_Icmpneqsd,
    UD_Icmpneqss,
    UD_Icmpnlepd,
    UD_Icmpnleps,
    UD_Icmpnlesd,
    UD_Icmpnless,
    UD_Icmpnltpd,
    UD_Icmpnltps,
    UD_Icmpnltsd,
    UD_Icmpnltss,
    UD_Icmpordpd,
    UD_Icmpordps,
    UD_Icmpordsd,
    UD_Icmpordss,
    UD_Icmppd,
    UD_Icmpps,
    UD_Icmpsb,
    UD_Icmpsd,
    UD_Icmpsq,
    UD_Icmpss,
    UD_Icmpsw,
    UD_Icmpunordpd,
    UD_Icmpunordps,
    UD_Icmpunordsd,
    UD_Icmpunordss,
    UD_Icmpxchg,
    UD_Icmpxchg16b,
    UD_Icmpxchg8b,
    UD_Icomisd,
    UD_Icomiss,
    UD_Icpuid,
    UD_Icqo,
    UD_Icrc32,
    UD_Icvtdq2pd,
    UD_Icvtdq2ps,
    UD_Icvtpd2dq,
    UD_Icvtpd2pi,
    UD_Icvtpd2ps,
    UD_Icvtpi2pd,
    UD_Icvtpi2ps,
    UD_Icvtps2dq,
    UD_Icvtps2pd,
    UD_Icvtps2pi,
    UD_Icvtsd2si,
    UD_Icvtsd2ss,
    UD_Icvtsi2sd,
    UD_Icvtsi2ss,
    UD_Icvtss2sd,
    UD_Icvtss2si,
    UD_Icvttpd2dq,
    UD_Icvttpd2pi,
    UD_Icvttps2dq,
    UD_Icvttps2pi,
    UD_Icvttsd2si,
    UD_Icvttss2si,
    UD_Icwd,
    UD_Icwde,
    UD_Idaa,
    UD_Idas,
    UD_Idec,
    UD_Idiv,
    UD_Idivpd,
    UD_Idivps,
    UD_Idivsd,
    UD_Idivss,
    UD_Idppd,
    UD_Idpps,
    UD_Iemms,
    UD_Iencls,
    UD_Ienclu,
    UD_Iendbr32,
    UD_Iendbr64,
    UD_Ienter,
    UD_Iextractps,
    UD_Iextrq,
    UD_If2xm1,
    UD_Ifabs,
    UD_Ifadd,
    UD_Ifaddp,
    UD_Ifbld,
    UD_Ifbstp,
    UD_Ifchs,
    UD_Ifcmovb,
    UD_Ifcmovbe,
    UD_Ifcmove,
    UD_Ifcmovnb,
    UD_Ifcmovnbe,
    UD_Ifcmovne,
    UD_Ifcmovnu,
    UD_Ifcmovu,
    UD_Ifcom,
    UD_Ifcom2,
    UD_Ifcomi,
    UD_Ifcomip,
    UD_Ifcomp,
    UD_Ifcomp3,
    UD_Ifcomp5,
    UD_Ifcompp,
    UD_Ifcos,
    UD_Ifdecstp,
    UD_Ifdiv,
    UD_Ifdivp,
    UD_Ifdivr,
    UD_Ifdivrp,
    UD_Ifemms,
    UD_Iffree,
    UD_Iffreep,
    UD_Ifiadd,
    UD_Ificom,
    UD_Ificomp,
    UD_Ifidiv,
    UD_Ifidivr,
    UD_Ifild,
    UD_Ifimul,
    UD_Ifincstp,
    UD_Ifist,
    UD_Ifistp,
    UD_Ifisttp,
    UD_Ifisub,
    UD_Ifisubr,
    UD_Ifld,
    UD_Ifld1,
    UD_Ifldcw,
    UD_Ifldenv,
    UD_Ifldl2e,
    UD_Ifldl2t,
    UD_Ifldlg2,
    UD_Ifldln2,
    UD_Ifldpi,
    UD_Ifldz,
    UD_Ifmul,
    UD_Ifmulp,
    UD_Ifnclex,
    UD_Ifndisi,
    UD_Ifneni,
    UD_Ifninit,
    UD_Ifnop,
    UD_Ifnsave,
    UD_Ifnsetpm,
    UD_Ifnstcw,
    UD_Ifnstenv,
    UD_Ifnstsw,
    UD_Ifpatan,
    UD_Ifprem,
    UD_Ifprem1,
    UD_Ifptan,
    UD_Ifrndint,
    UD_Ifrstor,
    UD_Ifrstpm,
    UD_Ifscale,
    UD_Ifsin,
    UD_Ifsincos,
    UD_Ifsqrt,
    UD_Ifst,
    UD_Ifstp,
    UD_Ifstp1,
    UD_Ifstp8,
    UD_Ifstp9,
    UD_Ifsub,
    UD_Ifsubp,
    UD_Ifsubr,
    UD_Ifsubrp,
    UD_Iftst,
    UD_Ifucom,
    UD_Ifucomi,
    UD_Ifucomip,
    UD_Ifucomp,
    UD_Ifucompp,
    UD_Ifxam,
    UD_Ifxch,
    UD_Ifxch4,
    UD_Ifxch7,
    UD_Ifxrstor,
    UD_Ifxrstor64,
    UD_Ifxsave,
    UD_Ifxsave64,
    UD_Ifxtract,
    UD_Ifyl2x,
    UD_Ifyl2xp1,
    UD_Igetsec,
    UD_Ihaddpd,
    UD_Ihaddps,
    UD_Ihlt,
    UD_Ihsubpd,
    UD_Ihsubps,
    UD_Iidiv,
    UD_Iimul,
    UD_Iin,
    UD_Iinc,
    UD_Iincsspd,
    UD_Iincsspq,
    UD_Iinsb,
    UD_Iinsd,
    UD_Iinsertps,
    UD_Iinsertq,
    UD_Iinsw,
    UD_Iint,
    UD_Iint1,
    UD_Iint3,
    UD_Iinto,
    UD_Iinvd,
    UD_Iinvept,
    UD_Iinvlpg,
    UD_Iinvlpga,
    UD_Iinvpcid,
    UD_Iinvvpid,
    UD_Iiretd,
    UD_Iiretq,
    UD_Iiretw,
    UD_Ija,
    UD_Ijae,
    UD_Ijb,
    UD_Ijbe,
    UD_Ijcxz,
    UD_Ije,
    UD_Ijecxz,
    UD_Ijg,
    UD_Ijge,
    UD_Ijl,
    UD_Ijle,
    UD_Ijmp,
    UD_Ijne,
    UD_Ijno,
    UD_Ijnp,
    UD_Ijns,
    UD_Ijnz,
    UD_Ijo,
    UD_Ijp,
    UD_Ijrcxz,
    UD_Ijs,
    UD_Ijz,
    UD_Ikaddb,
    UD_Ikaddd,
    UD_Ikaddq,
    UD_Ikaddw,
    UD_Ikandb,
    UD_Ikandd,
    UD_Ikandnb,
    UD_Ikandnd,
    UD_Ikandnq,
    UD_Ikandnw,
    UD_Ikandq,
    UD_Ikandw,
    UD_Ikmovb,
    UD_Ikmovd,
    UD_Ikmovq,
    UD_Ikmovw,
    UD_Iknotb,
    UD_Iknotd,
    UD_Iknotq,
    UD_Iknotw,
    UD_Ikorb,
    UD_Ikord,
    UD_Ikorq,
    UD_Ikortestb,
    UD_Ikortestd,
    UD_Ikortestq,
    UD_Ikortestw,
    UD_Ikorw,
    UD_Ikshiftlb,
    UD_Ikshiftld,
    UD_Ikshiftlq,
    UD_Ikshiftlw,
    UD_Ikshiftrb,
    UD_Ikshiftrd,
    UD_Ikshiftrq,
    UD_Ikshiftrw,
    UD_Iktestb,
    UD_Iktestd,
    UD_Iktestq,
    UD_Iktestw,
    UD_Ikunpckbw,
    UD_Ikunpckdq,
    UD_Ikunpckwd,
    UD_Ikxnorb,
    UD_Ikxnord,
    UD_Ikxnorq,
    UD_Ikxnorw,
    UD_Ikxorb,
    UD_Ikxord,
    UD_Ikxorq,
    UD_Ikxorw,
    UD_Ilahf,
    UD_Ilar,
    UD_Ilddqu,
    UD_Ildmxcsr,
    UD_Ilds,
    UD_Ilea,
    UD_Ileave,
    UD_Iles,
    UD_Ilfence,
    UD_Ilfs,
    UD_Ilgdt,
    UD_Ilgs,
    UD_Ilidt,
    UD_Illdt,
    UD_Ilmsw,
    UD_Ilock,
    UD_Ilodsb,
    UD_Ilodsd,
    UD_Ilodsq,
    UD_Ilodsw,
    UD_Iloop,
    UD_Iloope,
    UD_Iloopne,
    UD_Ilsl,
    UD_Ilss,
    UD_Iltr,
    UD_Ilzcnt,
    UD_Imaskmovdqu,
    UD_Imaskmovq,
    UD_Imaxpd,
    UD_Imaxps,
    UD_Imaxsd,
    UD_Imaxss,
    UD_Imfence,
    UD_Iminpd,
    UD_Iminps,
    UD_Iminsd,
    UD_Iminss,
    UD_Imonitor,
    UD_Imontmul,
    UD_Imov,
    UD_Imovapd,
    UD_Imovaps,
    UD_Imovbe,
    UD_Imovd,
    UD_Imovddup,
    UD_Imovdq2q,
    UD_Imovdqa,
    UD_Imovdqu,
    UD_Imovhlps,
    UD_Imovhpd,
    UD_Imovhps,
    UD_Imovlhps,
    UD_Imovlpd,
    UD_Imovlps,
    UD_Imovmskpd,
    UD_Imovmskps,
    UD_Imovntdq,
    UD_Imovntdqa,
    UD_Imovnti,
    UD_Imovntpd,
    UD_Imovntps,
    UD_Imovntq,
    UD_Imovntsd,
    UD_Imovntss,
    UD_Imovq,
    UD_Imovq2dq,
    UD_Imovsb,
    UD_Imovsd,
    UD_Imovshdup,
    UD_Imovsldup,
    UD_Imovsq,
    UD_Imovss,
    UD_Imovsw,
    UD_Imovsx,
    UD_Imovsxd,
    UD_Imovupd,
    UD_Imovups,
    UD_Imovzx,
    UD_Impsadbw,
    UD_Imul,
    UD_Imulpd,
    UD_Imulps,
    UD_Imulsd,
    UD_Imulss,
    UD_Imulx,
    UD_Imwait,
    UD_Ineg,
    UD_Inop,
    UD_Inot,
    UD_Ior,
    UD_Iorpd,
    UD_Iorps,
    UD_Iout,
    UD_Ioutsb,
    UD_Ioutsd,
    UD_Ioutsw,
    UD_Ipabsb,
    UD_Ipabsd,
    UD_Ipabsw,
    UD_Ipackssdw,
    UD_Ipacksswb,
    UD_Ipackusdw,
    UD_Ipackuswb,
    UD_Ipaddb,
    UD_Ipaddd,
    UD_Ipaddq,
    UD_Ipaddsb,
    UD_Ipaddsw,
    UD_Ipaddusb,
    UD_Ipaddusw,
    UD_Ipaddw,
    UD_Ipalignr,
    UD_Ipand,
    UD_Ipandn,
    UD_Ipavgb,
    UD_Ipavgusb,
    UD_Ipavgw,
    UD_Ipblendvb,
    UD_Ipblendw,
    UD_Ipclmulhqhqdq,
    UD_Ipclmulhqlqdq,
    UD_Ipclmullqhqdq,
    UD_Ipclmullqlqdq,
    UD_Ipclmulqdq,
    UD_Ipcmpeqb,
    UD_Ipcmpeqd,
    UD_Ipcmpeqq,
    UD_Ipcmpeqw,
    UD_Ipcmpestri,
    UD_Ipcmpestrm,
    UD_Ipcmpgtb,
    UD_Ipcmpgtd,
    UD_Ipcmpgtq,
    UD_Ipcmpgtw,
    UD_Ipcmpistri,
    UD_Ipcmpistrm,
    UD_Ipcommit,
    UD_Ipdep,
    UD_Ipext,
    UD_Ipextrb,
    UD_Ipextrd,
    UD_Ipextrq,
    UD_Ipextrw,
    UD_Ipf2id,
    UD_Ipf2iw,
    UD_Ipfacc,
    UD_Ipfadd,
    UD_Ipfcmpeq,
    UD_Ipfcmpge,
    UD_Ipfcmpgt,
    UD_Ipfmax,
    UD_Ipfmin,
    UD_Ipfmul,
    UD_Ipfnacc,
    UD_Ipfpnacc,
    UD_Ipfrcp,
    UD_Ipfrcpit1,
    UD_Ipfrcpit2,
    UD_Ipfrsqit1,
    UD_Ipfrsqrt,
    UD_Ipfsub,
    UD_Ipfsubr,
    UD_Iphaddd,
    UD_Iphaddsw,
    UD_Iphaddw,
    UD_Iphminposuw,
    UD_Iphsubd,
    UD_Iphsubsw,
    UD_Iphsubw,
    UD_Ipi2fd,
    UD_Ipi2fw,
    UD_Ipinsrb,
    UD_Ipinsrd,
    UD_Ipinsrq,
    UD_Ipinsrw,
    UD_Ipmaddubsw,
    UD_Ipmaddwd,
    UD_Ipmaxsb,
    UD_Ipmaxsd,
    UD_Ipmaxsw,
    UD_Ipmaxub,
    UD_Ipmaxud,
    UD_Ipmaxuw,
    UD_Ipminsb,
    UD_Ipminsd,
    UD_Ipminsw,
    UD_Ipminub,
    UD_Ipminud,
    UD_Ipminuw,
    UD_Ipmovmskb,
    UD_Ipmovsxbd,
    UD_Ipmovsxbq,
    UD_Ipmovsxbw,
    UD_Ipmovsxdq,
    UD_Ipmovsxwd,
    UD_Ipmovsxwq,
    UD_Ipmovzxbd,
    UD_Ipmovzxbq,
    UD_Ipmovzxbw,
    UD_Ipmovzxdq,
    UD_Ipmovzxwd,
    UD_Ipmovzxwq,
    UD_Ipmuldq,
    UD_Ipmulhrsw,
    UD_Ipmulhrw,
    UD_Ipmulhuw,
    UD_Ipmulhw,
    UD_Ipmulld,
    UD_Ipmullw,
    UD_Ipmuludq,
    UD_Ipop,
    UD_Ipopa,
    UD_Ipopad,
    UD_Ipopcnt,
    UD_Ipopfd,
    UD_Ipopfq,
    UD_Ipopfw,
    UD_Ipor,
    UD_Iprefetch,
    UD_Iprefetchnta,
    UD_Iprefetcht0,
    UD_Iprefetcht1,
    UD_Iprefetcht2,
    UD_Iprefetchw,
    UD_Iprefetchwt1,
    UD_Ipsadbw,
    UD_Ipshufb,
    UD_Ipshufd,
    UD_Ipshufhw,
    UD_Ipshuflw,
    UD_Ipshufw,
    UD_Ipsignb,
    UD_Ipsignd,
    UD_Ipsignw,
    UD_Ipslld,
    UD_Ipslldq,
    UD_Ipsllq,
    UD_Ipsllw,
    UD_Ipsrad,
    UD_Ipsraw,
    UD_Ipsrld,
    UD_Ipsrldq,
    UD_Ipsrlq,
    UD_Ipsrlw,
    UD_Ipsubb,
    UD_Ipsubd,
    UD_Ipsubq,
    UD_Ipsubsb,
    UD_Ipsubsw,
    UD_Ipsubusb,
    UD_Ipsubusw,
    UD_Ipsubw,
    UD_Ipswapd,
    UD_Iptest,
    UD_Ipunpckhbw,
    UD_Ipunpckhdq,
    UD_Ipunpckhqdq,
    UD_Ipunpckhwd,
    UD_Ipunpcklbw,
    UD_Ipunpckldq,
    UD_Ipunpcklqdq,
    UD_Ipunpcklwd,
    UD_Ipush,
    UD_Ipusha,
    UD_Ipushad,
    UD_Ipushfd,
    UD_Ipushfq,
    UD_Ipushfw,
    UD_Ipxor,
    UD_Ircl,
    UD_Ircpps,
    UD_Ircpss,
    UD_Ircr,
    UD_Irdfsbase,
    UD_Irdgsbase,
    UD_Irdmsr,
    UD_Irdpmc,
    UD_Irdrand,
    UD_Irdseed,
    UD_Irdsspd,
    UD_Irdsspq,
    UD_Irdtsc,
    UD_Irdtscp,
    UD_Irep,
    UD_Irepne,
    UD_Iret,
    UD_Iretf,
    UD_Irol,
    UD_Iror,
    UD_Irorx,
    UD_Iroundpd,
    UD_Iroundps,
    UD_Iroundsd,
    UD_Iroundss,
    UD_Irsm,
    UD_Irsqrtps,
    UD_Irsqrtss,
    UD_Irstorssp,
    UD_Isahf,
    UD_Isalc,
    UD_Isar,
    UD_Isarx,
    UD_Isaveprevssp,
    UD_Isbb,
    UD_Iscasb,
    UD_Iscasd,
    UD_Iscasq,
    UD_Iscasw,
    UD_Iseta,
    UD_Isetae,
    UD_Isetb,
    UD_Isetbe,
    UD_Isete,
    UD_Isetg,
    UD_Isetge,
    UD_Isetl,
    UD_Isetle,
    UD_Isetne,
    UD_Isetno,
    UD_Isetnp,
    UD_Isetns,
    UD_Iseto,
    UD_Isetp,
    UD_Isets,
    UD_Isetssbsy,
    UD_Isfence,
    UD_Isgdt,
    UD_Isha1msg1,
    UD_Isha1msg2,
    UD_Isha1nexte,
    UD_Isha1rnds4,
    UD_Isha256msg1,
    UD_Isha256msg2,
    UD_Isha256rnds2,
    UD_Ishl,
    UD_Ishld,
    UD_Ishlx,
    UD_Ishr,
    UD_Ishrd,
    UD_Ishrx,
    UD_Ishufpd,
    UD_Ishufps,
    UD_Isidt,
    UD_Iskinit,
    UD_Isldt,
    UD_Ismsw,
    UD_Isqrtpd,
    UD_Isqrtps,
    UD_Isqrtsd,
    UD_Isqrtss,
    UD_Istac,
    UD_Istc,
    UD_Istd,
    UD_Istgi,
    UD_Isti,
    UD_Istmxcsr,
    UD_Istosb,
    UD_Istosd,
    UD_Istosq,
    UD_Istosw,
    UD_Istr,
    UD_Isub,
    UD_Isubpd,
    UD_Isubps,
    UD_Isubsd,
    UD_Isubss,
    UD_Iswapgs,
    UD_Isyscall,
    UD_Isysenter,
    UD_Isysexit,
    UD_Isysret,
    UD_It1mskc,
    UD_Itest,
    UD_Itzcnt,
    UD_Itzmsk,
    UD_Iucomisd,
    UD_Iucomiss,
    UD_Iud1,
    UD_Iud2,
    UD_Iunpckhpd,
    UD_Iunpckhps,
    UD_Iunpcklpd,
    UD_Iunpcklps,
    UD_Ivaddpd,
    UD_Ivaddps,
    UD_Ivaddsd,
    UD_Ivaddss,
    UD_Ivaddsubpd,
    UD_Ivaddsubps,
    UD_Ivaesdec,
    UD_Ivaesdeclast,
    UD_Ivaesenc,
    UD_Ivaesenclast,
    UD_Ivaesimc,
    UD_Ivaeskeygenassist,
    UD_Ivandnpd,
    UD_Ivandnps,
    UD_Ivandpd,
    UD_Ivandps,
    UD_Ivblendpd,
    UD_Ivblendps,
    UD_Ivblendvpd,
    UD_Ivblendvps,
    UD_Ivbroadcastf128,
    UD_Ivbroadcasti128,
    UD_Ivbroadcastsd,
    UD_Ivbroadcastss,
    UD_Ivcmpeq_ospd,
    UD_Ivcmpeq_osps,
    UD_Ivcmpeq_ossd,
    UD_Ivcmpeq_osss,
    UD_Ivcmpeq_uqpd,
    UD_Ivcmpeq_uqps,
    UD_Ivcmpeq_uqsd,
    UD_Ivcmpeq_uqss,
    UD_Ivcmpeq_uspd,
    UD_Ivcmpeq_usps,
    UD_Ivcmpeq_ussd,
    UD_Ivcmpeq_usss,
    UD_Ivcmpeqpd,
    UD_Ivcmpeqps,
    UD_Ivcmpeqsd,
    UD_Ivcmpeqss,
    UD_Ivcmpfalse_ospd,
    UD_Ivcmpfalse_osps,
    UD_Ivcmpfalse_ossd,
    UD_Ivcmpfalse_osss,
    UD_Ivcmpfalsepd,
    UD_Ivcmpfalseps,
    UD_Ivcmpfalsesd,
    UD_Ivcmpfalsess,
    UD_Ivcmpge_oqpd,
    UD_Ivcmpge_oqps,
    UD_Ivcmpge_oqsd,
    UD_Ivcmpge_oqss,
    UD_Ivcmpgepd,
    UD_Ivcmpgeps,
    UD_Ivcmpgesd,
    UD_Ivcmpgess,
    UD_Ivcmpgt_oqpd,
    UD_Ivcmpgt_oqps,
    UD_Ivcmpgt_oqsd,
    UD_Ivcmpgt_oqss,
    UD_Ivcmpgtpd,
    UD_Ivcmpgtps,
    UD_Ivcmpgtsd,
    UD_Ivcmpgtss,
    UD_Ivcmple_oqpd,
    UD_Ivcmple_oqps,
    UD_Ivcmple_oqsd,
    UD_Ivcmple_oqss,
    UD_Ivcmplepd,
    UD_Ivcmpleps,
    UD_Ivcmplesd,
    UD_Ivcmpless,
    UD_Ivcmplt_oqpd,
    UD_Ivcmplt_oqps,
    UD_Ivcmplt_oqsd,
    UD_Ivcmplt_oqss,
    UD_Ivcmpltpd,
    UD_Ivcmpltps,
    UD_Ivcmpltsd,
    UD_Ivcmpltss,
    UD_Ivcmpneq_oqpd,
    UD_Ivcmpneq_oqps,
    UD_Ivcmpneq_oqsd,
    UD_Ivcmpneq_oqss,
    UD_Ivcmpneq_ospd,
    UD_Ivcmpneq_osps,
    UD_Ivcmpneq_ossd,
    UD_Ivcmpneq_osss,
    UD_Ivcmpneq_uspd,
    UD_Ivcmpneq_usps,
    UD_Ivcmpneq_ussd,
    UD_Ivcmpneq_usss,
    UD_Ivcmpneqpd,
    UD_Ivcmpneqps,
    UD_Ivcmpneqsd,
    UD_Ivcmpneqss,
    UD_Ivcmpnge_uqpd,
    UD_Ivcmpnge_uqps,
    UD_Ivcmpnge_uqsd,
    UD_Ivcmpnge_uqss,
    UD_Ivcmpngepd,
    UD_Ivcmpngeps,
    UD_Ivcmpngesd,
    UD_Ivcmpngess,
    UD_Ivcmpngt_uqpd,
    UD_Ivcmpngt_uqps,
    UD_Ivcmpngt_uqsd,
    UD_Ivcmpngt_uqss,
    UD_Ivcmpngtpd,
    UD_Ivcmpngtps,
    UD_Ivcmpngtsd,
    UD_Ivcmpngtss,
    UD_Ivcmpnle_uqpd,
    UD_Ivcmpnle_uqps,
    UD_Ivcmpnle_uqsd,
    UD_Ivcmpnle_uqss,
    UD_Ivcmpnlepd,
    UD_Ivcmpnleps,
    UD_Ivcmpnlesd,
    UD_Ivcmpnless,
    UD_Ivcmpnlt_uqpd,
    UD_Ivcmpnlt_uqps,
    UD_Ivcmpnlt_uqsd,
    UD_Ivcmpnlt_uqss,
    UD_Ivcmpnltpd,
    UD_Ivcmpnltps,
    UD_Ivcmpnltsd,
    UD_Ivcmpnltss,
    UD_Ivcmpord_spd,
    UD_Ivcmpord_sps,
    UD_Ivcmpord_ssd,
    UD_Ivcmpord_sss,
    UD_Ivcmpordpd,
    UD_Ivcmpordps,
    UD_Ivcmpordsd,
    UD_Ivcmpordss,
    UD_Ivcmppd,
    UD_Ivcmpps,
    UD_Ivcmpsd,
    UD_Ivcmpss,
    UD_Ivcmptrue_uspd,
    UD_Ivcmptrue_usps,
    UD_Ivcmptrue_ussd,
    UD_Ivcmptrue_usss,
    UD_Ivcmptruepd,
    UD_Ivcmptrueps,
    UD_Ivcmptruesd,
    UD_Ivcmptruess,
    UD_Ivcmpunord_spd,
    UD_Ivcmpunord_sps,
    UD_Ivcmpunord_ssd,
    UD_Ivcmpunord_sss,
    UD_Ivcmpunordpd,
    UD_Ivcmpunordps,
    UD_Ivcmpunordsd,
    UD_Ivcmpunordss,
    UD_Ivcomisd,
    UD_Ivcomiss,
    UD_Ivcvtdq2pd,
    UD_Ivcvtdq2ps,
    UD_Ivcvtpd2dq,
    UD_Ivcvtpd2ps,
    UD_Ivcvtph2ps,
    UD_Ivcvtps2dq,
    UD_Ivcvtps2pd,
    UD_Ivcvtps2ph,
    UD_Ivcvtsd2si,
    UD_Ivcvtsd2ss,
    UD_Ivcvtsi2sd,
    UD_Ivcvtsi2ss,
    UD_Ivcvtss2sd,
    UD_Ivcvtss2si,
    UD_Ivcvttpd2dq,
    UD_Ivcvttps2dq,
    UD_Ivcvttsd2si,
    UD_Ivcvttss2si,
    UD_Ivdivpd,
    UD_Ivdivps,
    UD_Ivdivsd,
    UD_Ivdivss,
    UD_Ivdppd,
    UD_Ivdpps,
    UD_Iverr,
    UD_Iverw,
    UD_Ivextractf128,
    UD_Ivextracti128,
    UD_Ivextractps,
    UD_Ivfmadd132pd,
    UD_Ivfmadd132ps,
    UD_Ivfmadd132sd,
    UD_Ivfmadd132ss,
    UD_Ivfmadd213pd,
    UD_Ivfmadd213ps,
    UD_Ivfmadd213sd,
    UD_Ivfmadd213ss,
    UD_Ivfmadd231pd,
    UD_Ivfmadd231ps,
    UD_Ivfmadd231sd,
    UD_Ivfmadd231ss,
    UD_Ivfmaddpd,
    UD_Ivfmaddps,
    UD_Ivfmaddsd,
    UD_Ivfmaddss,
    UD_Ivfmaddsub132pd,
    UD_Ivfmaddsub132ps,
    UD_Ivfmaddsub213pd,
    UD_Ivfmaddsub213ps,
    UD_Ivfmaddsub231pd,
    UD_Ivfmaddsub231ps,
    UD_Ivfmaddsubpd,
    UD_Ivfmaddsubps,
    UD_Ivfmsub132pd,
    UD_Ivfmsub132ps,
    UD_Ivfmsub132sd,
    UD_Ivfmsub132ss,
    UD_Ivfmsub213pd,
    UD_Ivfmsub213ps,
    UD_Ivfmsub213sd,
    UD_Ivfmsub213ss,
    UD_Ivfmsub231pd,
    UD_Ivfmsub231ps,
    UD_Ivfmsub231sd,
    UD_Ivfmsub231ss,
    UD_Ivfmsubadd132pd,
    UD_Ivfmsubadd132ps,
    UD_Ivfmsubadd213pd,
    UD_Ivfmsubadd213ps,
    UD_Ivfmsubadd231pd,
    UD_Ivfmsubadd231ps,
    UD_Ivfmsubaddpd,
    UD_Ivfmsubaddps,
    UD_Ivfmsubpd,
    UD_Ivfmsubps,
    UD_Ivfmsubsd,
    UD_Ivfmsubss,
    UD_Ivfnmadd132pd,
    UD_Ivfnmadd132ps,
    UD_Ivfnmadd132sd,
    UD_Ivfnmadd132ss,
    UD_Ivfnmadd213pd,
    UD_Ivfnmadd213ps,
    UD_Ivfnmadd213sd,
    UD_Ivfnmadd213ss,
    UD_Ivfnmadd231pd,
    UD_Ivfnmadd231ps,
    UD_Ivfnmadd231sd,
    UD_Ivfnmadd231ss,
    UD_Ivfnmaddpd,
    UD_Ivfnmaddps,
    UD_Ivfnmaddsd,
    UD_Ivfnmaddss,
    UD_Ivfnmsub132pd,
    UD_Ivfnmsub132ps,
    UD_Ivfnmsub132sd,
    UD_Ivfnmsub132ss,
    UD_Ivfnmsub213pd,
    UD_Ivfnmsub213ps,
    UD_Ivfnmsub213sd,
    UD_Ivfnmsub213ss,
    UD_Ivfnmsub231pd,
    UD_Ivfnmsub231ps,
    UD_Ivfnmsub231sd,
    UD_Ivfnmsub231ss,
    UD_Ivfnmsubpd,
    UD_Ivfnmsubps,
    UD_Ivfnmsubsd,
    UD_Ivfnmsubss,
    UD_Ivfrczpd,
    UD_Ivfrczps,
    UD_Ivfrczsd,
    UD_Ivfrczss,
    UD_Ivgatherdpd,
    UD_Ivgatherdps,
    UD_Ivgatherqpd,
    UD_Ivgatherqps,
    UD_Ivhaddpd,
    UD_Ivhaddps,
    UD_Ivhsubpd,
    UD_Ivhsubps,
    UD_Ivinsertf128,
    UD_Ivinserti128,
    UD_Ivinsertps,
    UD_Ivlddqu,
    UD_Ivldmxcsr,
    UD_Ivmaskmovdqu,
    UD_Ivmaskmovpd,
    UD_Ivmaskmovps,
    UD_Ivmaxpd,
    UD_Ivmaxps,
    UD_Ivmaxsd,
    UD_Ivmaxss,
    UD_Ivmcall,
    UD_Ivmclear,
    UD_Ivmfunc,
    UD_Ivminpd,
    UD_Ivminps,
    UD_Ivminsd,
    UD_Ivminss,
    UD_Ivmlaunch,
    UD_Ivmload,
    UD_Ivmmcall,
    UD_Ivmovapd,
    UD_Ivmovaps,
    UD_Ivmovd,
    UD_Ivmovddup,
    UD_Ivmovdqa,
    UD_Ivmovdqu,
    UD_Ivmovhlps,
    UD_Ivmovhpd,
    UD_Ivmovhps,
    UD_Ivmovlhps,
    UD_Ivmovlpd,
    UD_Ivmovlps,
    UD_Ivmovmskpd,
    UD_Ivmovmskps,
    UD_Ivmovntdq,
    UD_Ivmovntdqa,
    UD_Ivmovntpd,
    UD_Ivmovntps,
    UD_Ivmovq,
    UD_Ivmovsd,
    UD_Ivmovshdup,
    UD_Ivmovsldup,
    UD_Ivmovss,
    UD_Ivmovupd,
    UD_Ivmovups,
    UD_Ivmpsadbw,
    UD_Ivmptrld,
    UD_Ivmptrst,
    UD_Ivmread,
    UD_Ivmresume,
    UD_Ivmrun,
    UD_Ivmsave,
    UD_Ivmulpd,
    UD_Ivmulps,
    UD_Ivmulsd,
    UD_Ivmulss,
    UD_Ivmwrite,
    UD_Ivmxoff,
    UD_Ivmxon,
    UD_Ivorpd,
    UD_Ivorps,
    UD_Ivpabsb,
    UD_Ivpabsd,
    UD_Ivpabsw,
    UD_Ivpackssdw,
    UD_Ivpacksswb,
    UD_Ivpackusdw,
    UD_Ivpackuswb,
    UD_Ivpaddb,
    UD_Ivpaddd,
    UD_Ivpaddq,
    UD_Ivpaddsb,
    UD_Ivpaddsw,
    UD_Ivpaddusb,
    UD_Ivpaddusw,
    UD_Ivpaddw,
    UD_Ivpalignr,
    UD_Ivpand,
    UD_Ivpandn,
    UD_Ivpavgb,
    UD_Ivpavgw,
    UD_Ivpblendd,
    UD_Ivpblendvb,
    UD_Ivpblendw,
    UD_Ivpbroadcastb,
    UD_Ivpbroadcastd,
    UD_Ivpbroadcastq,
    UD_Ivpbroadcastw,
    UD_Ivpclmulhqhqdq,
    UD_Ivpclmulhqlqdq,
    UD_Ivpclmullqhqdq,
    UD_Ivpclmullqlqdq,
    UD_Ivpclmulqdq,
    UD_Ivpcmov,
    UD_Ivpcmpeqb,
    UD_Ivpcmpeqd,
    UD_Ivpcmpeqq,
    UD_Ivpcmpeqw,
    UD_Ivpcmpestri,
    UD_Ivpcmpestrm,
    UD_Ivpcmpgtb,
    UD_Ivpcmpgtd,
    UD_Ivpcmpgtq,
    UD_Ivpcmpgtw,
    UD_Ivpcmpistri,
    UD_Ivpcmpistrm,
    UD_Ivpcomb,
    UD_Ivpcomd,
    UD_Ivpcomeqb,
    UD_Ivpcomeqd,
    UD_Ivpcomeqq,
    UD_Ivpcomequb,
    UD_Ivpcomequd,
    UD_Ivpcomequq,
    UD_Ivpcomequw,
    UD_Ivpcomeqw,
    UD_Ivpcomfalseb,
    UD_Ivpcomfalsed,
    UD_Ivpcomfalseq,
    UD_Ivpcomfalseub,
    UD_Ivpcomfalseud,
    UD_Ivpcomfalseuq,
    UD_Ivpcomfalseuw,
    UD_Ivpcomfalsew,
    UD_Ivpcomgeb,
    UD_Ivpcomged,
    UD_Ivpcomgeq,
    UD_Ivpcomgeub,
    UD_Ivpcomgeud,
    UD_Ivpcomgeuq,
    UD_Ivpcomgeuw,
    UD_Ivpcomgew,
    UD_Ivpcomgtb,
    UD_Ivpcomgtd,
    UD_Ivpcomgtq,
    UD_Ivpcomgtub,
    UD_Ivpcomgtud,
    UD_Ivpcomgtuq,
    UD_Ivpcomgtuw,
    UD_Ivpcomgtw,
    UD_Ivpcomleb,
    UD_Ivpcomled,
    UD_Ivpcomleq,
    UD_Ivpcomleub,
    UD_Ivpcomleud,
    UD_Ivpcomleuq,
    UD_Ivpcomleuw,
    UD_Ivpcomlew,
    UD_Ivpcomltb,
    UD_Ivpcomltd,
    UD_Ivpcomltq,
    UD_Ivpcomltub,
    UD_Ivpcomltud,
    UD_Ivpcomltuq,
    UD_Ivpcomltuw,
    UD_Ivpcomltw,
    UD_Ivpcomneqb,
    UD_Ivpcomneqd,
    UD_Ivpcomneqq,
    UD_Ivpcomnequb,
    UD_Ivpcomnequd,
    UD_Ivpcomnequq,
    UD_Ivpcomnequw,
    UD_Ivpcomneqw,
    UD_Ivpcomq,
    UD_Ivpcomtrueb,
    UD_Ivpcomtrued,
    UD_Ivpcomtrueq,
    UD_Ivpcomtrueub,
    UD_Ivpcomtrueud,
    UD_Ivpcomtrueuq,
    UD_Ivpcomtrueuw,
    UD_Ivpcomtruew,
    UD_Ivpcomub,
    UD_Ivpcomud,
    UD_Ivpcomuq,
    UD_Ivpcomuw,
    UD_Ivpcomw,
    UD_Ivperm2f128,
    UD_Ivperm2i128,
    UD_Ivpermd,
    UD_Ivpermilpd,
    UD_Ivpermilps,
    UD_Ivpermpd,
    UD_Ivpermps,
    UD_Ivpermq,
    UD_Ivpextrb,
    UD_Ivpextrd,
    UD_Ivpextrq,
    UD_Ivpextrw,
    UD_Ivpgatherdd,
    UD_Ivpgatherdq,
    UD_Ivpgatherqd,
    UD_Ivpgatherqq,
    UD_Ivphaddbd,
    UD_Ivphaddbq,
    UD_Ivphaddbw,
    UD_Ivphaddd,
    UD_Ivphadddq,
    UD_Ivphaddsw,
    UD_Ivphaddubd,
    UD_Ivphaddubq,
    UD_Ivphaddubw,
    UD_Ivphaddudq,
    UD_Ivphadduwd,
    UD_Ivphadduwq,
    UD_Ivphaddw,
    UD_Ivphaddwd,
    UD_Ivphaddwq,
    UD_Ivphminposuw,
    UD_Ivphsubbw,
    UD_Ivphsubd,
    UD_Ivphsubdq,
    UD_Ivphsubsw,
    UD_Ivphsubw,
    UD_Ivphsubwd,
    UD_Ivpinsrb,
    UD_Ivpinsrd,
    UD_Ivpinsrq,
    UD_Ivpinsrw,
    UD_Ivpmacsdd,
    UD_Ivpmacsdqh,
    UD_Ivpmacsdql,
    UD_Ivpmacssdd,
    UD_Ivpmacssdqh,
    UD_Ivpmacssdql,
    UD_Ivpmacsswd,
    UD_Ivpmacssww,
    UD_Ivpmacswd,
    UD_Ivpmacsww,
    UD_Ivpmadcsswd,
    UD_Ivpmadcswd,
    UD_Ivpmaddubsw,
    UD_Ivpmaddwd,
    UD_Ivpmaskmovd,
    UD_Ivpmaskmovq,
    UD_Ivpmaxsb,
    UD_Ivpmaxsd,
    UD_Ivpmaxsw,
    UD_Ivpmaxub,
    UD_Ivpmaxud,
    UD_Ivpmaxuw,
    UD_Ivpminsb,
    UD_Ivpminsd,
    UD_Ivpminsw,
    UD_Ivpminub,
    UD_Ivpminud,
    UD_Ivpminuw,
    UD_Ivpmovmskb,
    UD_Ivpmovsxbd,
    UD_Ivpmovsxbq,
    UD_Ivpmovsxbw,
    UD_Ivpmovsxdq,
    UD_Ivpmovsxwd,
    UD_Ivpmovsxwq,
    UD_Ivpmovzxbd,
    UD_Ivpmovzxbq,
    UD_Ivpmovzxbw,
    UD_Ivpmovzxdq,
    UD_Ivpmovzxwd,
    UD_Ivpmovzxwq,
    UD_Ivpmuldq,
    UD_Ivpmulhrsw,
    UD_Ivpmulhuw,
    UD_Ivpmulhw,
    UD_Ivpmulld,
    UD_Ivpmullw,
    UD_Ivpmuludq,
    UD_Ivpor,
    UD_Ivpperm,
    UD_Ivprotb,
    UD_Ivprotd,
    UD_Ivprotq,
    UD_Ivprotw,
    UD_Ivpsadbw,
    UD_Ivpshab,
    UD_Ivpshad,
    UD_Ivpshaq,
    UD_Ivpshaw,
    UD_Ivpshlb,
    UD_Ivpshld,
    UD_Ivpshlq,
    UD_Ivpshlw,
    UD_Ivpshufb,
    UD_Ivpshufd,
    UD_Ivpshufhw,
    UD_Ivpshuflw,
    UD_Ivpsignb,
    UD_Ivpsignd,
    UD_Ivpsignw,
    UD_Ivpslld,
    UD_Ivpslldq,
    UD_Ivpsllq,
    UD_Ivpsllvd,
    UD_Ivpsllvq,
    UD_Ivpsllw,
    UD_Ivpsrad,
    UD_Ivpsravd,
    UD_Ivpsraw,
    UD_Ivpsrld,
    UD_Ivpsrldq,
    UD_Ivpsrlq,
    UD_Ivpsrlvd,
    UD_Ivpsrlvq,
    UD_Ivpsrlw,
    UD_Ivpsubb,
    UD_Ivpsubd,
    UD_Ivpsubq,
    UD_Ivpsubsb,
    UD_Ivpsubsw,
    UD_Ivpsubusb,
    UD_Ivpsubusw,
    UD_Ivpsubw,
    UD_Ivptest,
    UD_Ivpunpckhbw,
    UD_Ivpunpckhdq,
    UD_Ivpunpckhqdq,
    UD_Ivpunpckhwd,
    UD_Ivpunpcklbw,
    UD_Ivpunpckldq,
    UD_Ivpunpcklqdq,
    UD_Ivpunpcklwd,
    UD_Ivpxor,
    UD_Ivrcpps,
    UD_Ivrcpss,
    UD_Ivroundpd,
    UD_Ivroundps,
    UD_Ivroundsd,
    UD_Ivroundss,
    UD_Ivrsqrtps,
    UD_Ivrsqrtss,
    UD_Ivshufpd,
    UD_Ivshufps,
    UD_Ivsqrtpd,
    UD_Ivsqrtps,
    UD_Ivsqrtsd,
    UD_Ivsqrtss,
    UD_Ivstmxcsr,
    UD_Ivsubpd,
    UD_Ivsubps,
    UD_Ivsubsd,
    UD_Ivsubss,
    UD_Ivtestpd,
    UD_Ivtestps,
    UD_Ivucomisd,
    UD_Ivucomiss,
    UD_Ivunpckhpd,
    UD_Ivunpckhps,
    UD_Ivunpcklpd,
    UD_Ivunpcklps,
    UD_Ivxorpd,
    UD_Ivxorps,
    UD_Ivzeroall,
    UD_Ivzeroupper,
    UD_Iwait,
    UD_Iwbinvd,
    UD_Iwrfsbase,
    UD_Iwrgsbase,
    UD_Iwrmsr,
    UD_Iwrssd,
    UD_Iwrssq,
    UD_Iwrussd,
    UD_Iwrussq,
    UD_Ixabort,
    UD_Ixadd,
    UD_Ixbegin,
    UD_Ixchg,
    UD_Ixcryptcbc,
    UD_Ixcryptcfb,
    UD_Ixcryptctr,
    UD_Ixcryptecb,
    UD_Ixcryptofb,
    UD_Ixend,
    UD_Ixgetbv,
    UD_Ixlatb,
    UD_Ixor,
    UD_Ixorpd,
    UD_Ixorps,
    UD_Ixrstor,
    UD_Ixrstor64,
    UD_Ixrstors,
    UD_Ixrstors64,
    UD_Ixsave,
    UD_Ixsave64,
    UD_Ixsavec,
    UD_Ixsavec64,
    UD_Ixsaveopt,
    UD_Ixsaveopt64,
    UD_Ixsaves,
    UD_Ixsaves64,
    UD_Ixsetbv,
    UD_Ixsha1,
    UD_Ixsha256,
    UD_Ixstore,
    UD_Ixtest,
    UD_Iinvalid,
    UD_I3dnow,
    UD_Inone,
    UD_Idb,
    UD_Ipause,
    UD_MAX_MNEMONIC_CODE
} UD_ATTR_PACKED;

extern const char * ud_mnemonics_str[];

#endif /* UD_ITAB_H */
