{-# LANGUAGE CPP #-}
{-# LANGUAGE NoRebindableSyntax #-}
{-# OPTIONS_GHC -fno-warn-missing-import-lists #-}
{-# OPTIONS_GHC -w #-}
module Paths_hakyll (
    version,
    getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir,
    getDataFileName, getSysconfDir
  ) where


import qualified Control.Exception as Exception
import qualified Data.List as List
import Data.Version (Version(..))
import System.Environment (getEnv)
import Prelude


#if defined(VERSION_base)

#if MIN_VERSION_base(4,0,0)
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#else
catchIO :: IO a -> (Exception.Exception -> IO a) -> IO a
#endif

#else
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#endif
catchIO = Exception.catch

version :: Version
version = Version [4,16,3,0] []

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = do
  dir <- getDataDir
  return (dir `joinFileName` name)

getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir, getSysconfDir :: IO FilePath



bindir, libdir, dynlibdir, datadir, libexecdir, sysconfdir :: FilePath
bindir     = "/usr/bin"
libdir     = "/usr/lib/ghc-9.4.8/site-local/hakyll-4.16.3.0"
dynlibdir  = "/usr/lib"
datadir    = "/usr/share/haskell-hakyll"
libexecdir = "/usr/libexec/x86_64-linux-ghc-9.4.8/hakyll-4.16.3.0"
sysconfdir = "/usr/etc"

getBinDir     = catchIO (getEnv "hakyll_bindir")     (\_ -> return bindir)
getLibDir     = catchIO (getEnv "hakyll_libdir")     (\_ -> return libdir)
getDynLibDir  = catchIO (getEnv "hakyll_dynlibdir")  (\_ -> return dynlibdir)
getDataDir    = catchIO (getEnv "hakyll_datadir")    (\_ -> return datadir)
getLibexecDir = catchIO (getEnv "hakyll_libexecdir") (\_ -> return libexecdir)
getSysconfDir = catchIO (getEnv "hakyll_sysconfdir") (\_ -> return sysconfdir)




joinFileName :: String -> String -> FilePath
joinFileName ""  fname = fname
joinFileName "." fname = fname
joinFileName dir ""    = dir
joinFileName dir fname
  | isPathSeparator (List.last dir) = dir ++ fname
  | otherwise                       = dir ++ pathSeparator : fname

pathSeparator :: Char
pathSeparator = '/'

isPathSeparator :: Char -> Bool
isPathSeparator c = c == '/'
