{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoLayoutLine@ represents one of the lines resulting from laying
-- out a paragraph via @PangoLayout@.
-- 
-- @PangoLayoutLine@ structures are obtained by calling
-- 'GI.Pango.Objects.Layout.layoutGetLine' and are only valid until the text,
-- attributes, or settings of the parent @PangoLayout@ are modified.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.LayoutLine
    ( 

-- * Exported types
    LayoutLine(..)                          ,
    newZeroLayoutLine                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [indexToX]("GI.Pango.Structs.LayoutLine#g:method:indexToX"), [isParagraphStart]("GI.Pango.Structs.LayoutLine#g:method:isParagraphStart"), [ref]("GI.Pango.Structs.LayoutLine#g:method:ref"), [unref]("GI.Pango.Structs.LayoutLine#g:method:unref"), [xToIndex]("GI.Pango.Structs.LayoutLine#g:method:xToIndex").
-- 
-- ==== Getters
-- [getExtents]("GI.Pango.Structs.LayoutLine#g:method:getExtents"), [getHeight]("GI.Pango.Structs.LayoutLine#g:method:getHeight"), [getLength]("GI.Pango.Structs.LayoutLine#g:method:getLength"), [getPixelExtents]("GI.Pango.Structs.LayoutLine#g:method:getPixelExtents"), [getResolvedDirection]("GI.Pango.Structs.LayoutLine#g:method:getResolvedDirection"), [getStartIndex]("GI.Pango.Structs.LayoutLine#g:method:getStartIndex"), [getXRanges]("GI.Pango.Structs.LayoutLine#g:method:getXRanges").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveLayoutLineMethod                 ,
#endif

-- ** getExtents #method:getExtents#

#if defined(ENABLE_OVERLOADING)
    LayoutLineGetExtentsMethodInfo          ,
#endif
    layoutLineGetExtents                    ,


-- ** getHeight #method:getHeight#

#if defined(ENABLE_OVERLOADING)
    LayoutLineGetHeightMethodInfo           ,
#endif
    layoutLineGetHeight                     ,


-- ** getLength #method:getLength#

#if defined(ENABLE_OVERLOADING)
    LayoutLineGetLengthMethodInfo           ,
#endif
    layoutLineGetLength                     ,


-- ** getPixelExtents #method:getPixelExtents#

#if defined(ENABLE_OVERLOADING)
    LayoutLineGetPixelExtentsMethodInfo     ,
#endif
    layoutLineGetPixelExtents               ,


-- ** getResolvedDirection #method:getResolvedDirection#

#if defined(ENABLE_OVERLOADING)
    LayoutLineGetResolvedDirectionMethodInfo,
#endif
    layoutLineGetResolvedDirection          ,


-- ** getStartIndex #method:getStartIndex#

#if defined(ENABLE_OVERLOADING)
    LayoutLineGetStartIndexMethodInfo       ,
#endif
    layoutLineGetStartIndex                 ,


-- ** getXRanges #method:getXRanges#

#if defined(ENABLE_OVERLOADING)
    LayoutLineGetXRangesMethodInfo          ,
#endif
    layoutLineGetXRanges                    ,


-- ** indexToX #method:indexToX#

#if defined(ENABLE_OVERLOADING)
    LayoutLineIndexToXMethodInfo            ,
#endif
    layoutLineIndexToX                      ,


-- ** isParagraphStart #method:isParagraphStart#

#if defined(ENABLE_OVERLOADING)
    LayoutLineIsParagraphStartMethodInfo    ,
#endif
    layoutLineIsParagraphStart              ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    LayoutLineRefMethodInfo                 ,
#endif
    layoutLineRef                           ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    LayoutLineUnrefMethodInfo               ,
#endif
    layoutLineUnref                         ,


-- ** xToIndex #method:xToIndex#

#if defined(ENABLE_OVERLOADING)
    LayoutLineXToIndexMethodInfo            ,
#endif
    layoutLineXToIndex                      ,




 -- * Properties


-- ** isParagraphStart #attr:isParagraphStart#
-- | @/TRUE/@ if this is the first line of the paragraph

    getLayoutLineIsParagraphStart           ,
#if defined(ENABLE_OVERLOADING)
    layoutLine_isParagraphStart             ,
#endif
    setLayoutLineIsParagraphStart           ,


-- ** layout #attr:layout#
-- | the layout this line belongs to, might be 'P.Nothing'

    clearLayoutLineLayout                   ,
    getLayoutLineLayout                     ,
#if defined(ENABLE_OVERLOADING)
    layoutLine_layout                       ,
#endif
    setLayoutLineLayout                     ,


-- ** length #attr:length#
-- | length of line in bytes

    getLayoutLineLength                     ,
#if defined(ENABLE_OVERLOADING)
    layoutLine_length                       ,
#endif
    setLayoutLineLength                     ,


-- ** resolvedDir #attr:resolvedDir#
-- | @/Resolved/@ PangoDirection of line

    getLayoutLineResolvedDir                ,
#if defined(ENABLE_OVERLOADING)
    layoutLine_resolvedDir                  ,
#endif
    setLayoutLineResolvedDir                ,


-- ** runs #attr:runs#
-- | list of runs in the
--   line, from left to right

    clearLayoutLineRuns                     ,
    getLayoutLineRuns                       ,
#if defined(ENABLE_OVERLOADING)
    layoutLine_runs                         ,
#endif
    setLayoutLineRuns                       ,


-- ** startIndex #attr:startIndex#
-- | start of line as byte index into layout->text

    getLayoutLineStartIndex                 ,
#if defined(ENABLE_OVERLOADING)
    layoutLine_startIndex                   ,
#endif
    setLayoutLineStartIndex                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Objects.Layout as Pango.Layout
import {-# SOURCE #-} qualified GI.Pango.Structs.Analysis as Pango.Analysis
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrIterator as Pango.AttrIterator
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrList as Pango.AttrList
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphItem as Pango.GlyphItem
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphString as Pango.GlyphString
import {-# SOURCE #-} qualified GI.Pango.Structs.Item as Pango.Item
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.LayoutIter as Pango.LayoutIter
import {-# SOURCE #-} qualified GI.Pango.Structs.LogAttr as Pango.LogAttr
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle
import {-# SOURCE #-} qualified GI.Pango.Structs.TabArray as Pango.TabArray

#else
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Objects.Layout as Pango.Layout
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphItem as Pango.GlyphItem
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#endif

-- | Memory-managed wrapper type.
newtype LayoutLine = LayoutLine (SP.ManagedPtr LayoutLine)
    deriving (Eq)

instance SP.ManagedPtrNewtype LayoutLine where
    toManagedPtr (LayoutLine p) = p

foreign import ccall "pango_layout_line_get_type" c_pango_layout_line_get_type :: 
    IO GType

type instance O.ParentTypes LayoutLine = '[]
instance O.HasParentTypes LayoutLine

instance B.Types.TypedObject LayoutLine where
    glibType = c_pango_layout_line_get_type

instance B.Types.GBoxed LayoutLine

-- | Convert t'LayoutLine' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe LayoutLine) where
    gvalueGType_ = c_pango_layout_line_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr LayoutLine)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr LayoutLine)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed LayoutLine ptr
        else return P.Nothing
        
    

-- | Construct a t'LayoutLine' struct initialized to zero.
newZeroLayoutLine :: MonadIO m => m LayoutLine
newZeroLayoutLine = liftIO $ callocBoxedBytes 32 >>= wrapBoxed LayoutLine

instance tag ~ 'AttrSet => Constructible LayoutLine tag where
    new _ attrs = do
        o <- newZeroLayoutLine
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@layout@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' layoutLine #layout
-- @
getLayoutLineLayout :: MonadIO m => LayoutLine -> m (Maybe Pango.Layout.Layout)
getLayoutLineLayout s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr Pango.Layout.Layout)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Pango.Layout.Layout) val'
        return val''
    return result

-- | Set the value of the “@layout@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' layoutLine [ #layout 'Data.GI.Base.Attributes.:=' value ]
-- @
setLayoutLineLayout :: MonadIO m => LayoutLine -> Ptr Pango.Layout.Layout -> m ()
setLayoutLineLayout s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr Pango.Layout.Layout)

-- | Set the value of the “@layout@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #layout
-- @
clearLayoutLineLayout :: MonadIO m => LayoutLine -> m ()
clearLayoutLineLayout s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr Pango.Layout.Layout)

#if defined(ENABLE_OVERLOADING)
data LayoutLineLayoutFieldInfo
instance AttrInfo LayoutLineLayoutFieldInfo where
    type AttrBaseTypeConstraint LayoutLineLayoutFieldInfo = (~) LayoutLine
    type AttrAllowedOps LayoutLineLayoutFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint LayoutLineLayoutFieldInfo = (~) (Ptr Pango.Layout.Layout)
    type AttrTransferTypeConstraint LayoutLineLayoutFieldInfo = (~)(Ptr Pango.Layout.Layout)
    type AttrTransferType LayoutLineLayoutFieldInfo = (Ptr Pango.Layout.Layout)
    type AttrGetType LayoutLineLayoutFieldInfo = Maybe Pango.Layout.Layout
    type AttrLabel LayoutLineLayoutFieldInfo = "layout"
    type AttrOrigin LayoutLineLayoutFieldInfo = LayoutLine
    attrGet = getLayoutLineLayout
    attrSet = setLayoutLineLayout
    attrConstruct = undefined
    attrClear = clearLayoutLineLayout
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layout"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#g:attr:layout"
        })

layoutLine_layout :: AttrLabelProxy "layout"
layoutLine_layout = AttrLabelProxy

#endif


-- | Get the value of the “@start_index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' layoutLine #startIndex
-- @
getLayoutLineStartIndex :: MonadIO m => LayoutLine -> m Int32
getLayoutLineStartIndex s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@start_index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' layoutLine [ #startIndex 'Data.GI.Base.Attributes.:=' value ]
-- @
setLayoutLineStartIndex :: MonadIO m => LayoutLine -> Int32 -> m ()
setLayoutLineStartIndex s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data LayoutLineStartIndexFieldInfo
instance AttrInfo LayoutLineStartIndexFieldInfo where
    type AttrBaseTypeConstraint LayoutLineStartIndexFieldInfo = (~) LayoutLine
    type AttrAllowedOps LayoutLineStartIndexFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LayoutLineStartIndexFieldInfo = (~) Int32
    type AttrTransferTypeConstraint LayoutLineStartIndexFieldInfo = (~)Int32
    type AttrTransferType LayoutLineStartIndexFieldInfo = Int32
    type AttrGetType LayoutLineStartIndexFieldInfo = Int32
    type AttrLabel LayoutLineStartIndexFieldInfo = "start_index"
    type AttrOrigin LayoutLineStartIndexFieldInfo = LayoutLine
    attrGet = getLayoutLineStartIndex
    attrSet = setLayoutLineStartIndex
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.startIndex"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#g:attr:startIndex"
        })

layoutLine_startIndex :: AttrLabelProxy "startIndex"
layoutLine_startIndex = AttrLabelProxy

#endif


-- | Get the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' layoutLine #length
-- @
getLayoutLineLength :: MonadIO m => LayoutLine -> m Int32
getLayoutLineLength s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' layoutLine [ #length 'Data.GI.Base.Attributes.:=' value ]
-- @
setLayoutLineLength :: MonadIO m => LayoutLine -> Int32 -> m ()
setLayoutLineLength s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data LayoutLineLengthFieldInfo
instance AttrInfo LayoutLineLengthFieldInfo where
    type AttrBaseTypeConstraint LayoutLineLengthFieldInfo = (~) LayoutLine
    type AttrAllowedOps LayoutLineLengthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LayoutLineLengthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint LayoutLineLengthFieldInfo = (~)Int32
    type AttrTransferType LayoutLineLengthFieldInfo = Int32
    type AttrGetType LayoutLineLengthFieldInfo = Int32
    type AttrLabel LayoutLineLengthFieldInfo = "length"
    type AttrOrigin LayoutLineLengthFieldInfo = LayoutLine
    attrGet = getLayoutLineLength
    attrSet = setLayoutLineLength
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.length"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#g:attr:length"
        })

layoutLine_length :: AttrLabelProxy "length"
layoutLine_length = AttrLabelProxy

#endif


-- | Get the value of the “@runs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' layoutLine #runs
-- @
getLayoutLineRuns :: MonadIO m => LayoutLine -> m [Pango.GlyphItem.GlyphItem]
getLayoutLineRuns s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr (GSList (Ptr Pango.GlyphItem.GlyphItem)))
    val' <- unpackGSList val
    val'' <- mapM (newBoxed Pango.GlyphItem.GlyphItem) val'
    return val''

-- | Set the value of the “@runs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' layoutLine [ #runs 'Data.GI.Base.Attributes.:=' value ]
-- @
setLayoutLineRuns :: MonadIO m => LayoutLine -> Ptr (GSList (Ptr Pango.GlyphItem.GlyphItem)) -> m ()
setLayoutLineRuns s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr (GSList (Ptr Pango.GlyphItem.GlyphItem)))

-- | Set the value of the “@runs@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #runs
-- @
clearLayoutLineRuns :: MonadIO m => LayoutLine -> m ()
clearLayoutLineRuns s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr (GSList (Ptr Pango.GlyphItem.GlyphItem)))

#if defined(ENABLE_OVERLOADING)
data LayoutLineRunsFieldInfo
instance AttrInfo LayoutLineRunsFieldInfo where
    type AttrBaseTypeConstraint LayoutLineRunsFieldInfo = (~) LayoutLine
    type AttrAllowedOps LayoutLineRunsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint LayoutLineRunsFieldInfo = (~) (Ptr (GSList (Ptr Pango.GlyphItem.GlyphItem)))
    type AttrTransferTypeConstraint LayoutLineRunsFieldInfo = (~)(Ptr (GSList (Ptr Pango.GlyphItem.GlyphItem)))
    type AttrTransferType LayoutLineRunsFieldInfo = (Ptr (GSList (Ptr Pango.GlyphItem.GlyphItem)))
    type AttrGetType LayoutLineRunsFieldInfo = [Pango.GlyphItem.GlyphItem]
    type AttrLabel LayoutLineRunsFieldInfo = "runs"
    type AttrOrigin LayoutLineRunsFieldInfo = LayoutLine
    attrGet = getLayoutLineRuns
    attrSet = setLayoutLineRuns
    attrConstruct = undefined
    attrClear = clearLayoutLineRuns
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.runs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#g:attr:runs"
        })

layoutLine_runs :: AttrLabelProxy "runs"
layoutLine_runs = AttrLabelProxy

#endif


-- | Get the value of the “@is_paragraph_start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' layoutLine #isParagraphStart
-- @
getLayoutLineIsParagraphStart :: MonadIO m => LayoutLine -> m Word32
getLayoutLineIsParagraphStart s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Word32
    return val

-- | Set the value of the “@is_paragraph_start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' layoutLine [ #isParagraphStart 'Data.GI.Base.Attributes.:=' value ]
-- @
setLayoutLineIsParagraphStart :: MonadIO m => LayoutLine -> Word32 -> m ()
setLayoutLineIsParagraphStart s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LayoutLineIsParagraphStartFieldInfo
instance AttrInfo LayoutLineIsParagraphStartFieldInfo where
    type AttrBaseTypeConstraint LayoutLineIsParagraphStartFieldInfo = (~) LayoutLine
    type AttrAllowedOps LayoutLineIsParagraphStartFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LayoutLineIsParagraphStartFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LayoutLineIsParagraphStartFieldInfo = (~)Word32
    type AttrTransferType LayoutLineIsParagraphStartFieldInfo = Word32
    type AttrGetType LayoutLineIsParagraphStartFieldInfo = Word32
    type AttrLabel LayoutLineIsParagraphStartFieldInfo = "is_paragraph_start"
    type AttrOrigin LayoutLineIsParagraphStartFieldInfo = LayoutLine
    attrGet = getLayoutLineIsParagraphStart
    attrSet = setLayoutLineIsParagraphStart
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.isParagraphStart"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#g:attr:isParagraphStart"
        })

layoutLine_isParagraphStart :: AttrLabelProxy "isParagraphStart"
layoutLine_isParagraphStart = AttrLabelProxy

#endif


-- | Get the value of the “@resolved_dir@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' layoutLine #resolvedDir
-- @
getLayoutLineResolvedDir :: MonadIO m => LayoutLine -> m Word32
getLayoutLineResolvedDir s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 28) :: IO Word32
    return val

-- | Set the value of the “@resolved_dir@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' layoutLine [ #resolvedDir 'Data.GI.Base.Attributes.:=' value ]
-- @
setLayoutLineResolvedDir :: MonadIO m => LayoutLine -> Word32 -> m ()
setLayoutLineResolvedDir s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 28) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LayoutLineResolvedDirFieldInfo
instance AttrInfo LayoutLineResolvedDirFieldInfo where
    type AttrBaseTypeConstraint LayoutLineResolvedDirFieldInfo = (~) LayoutLine
    type AttrAllowedOps LayoutLineResolvedDirFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LayoutLineResolvedDirFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LayoutLineResolvedDirFieldInfo = (~)Word32
    type AttrTransferType LayoutLineResolvedDirFieldInfo = Word32
    type AttrGetType LayoutLineResolvedDirFieldInfo = Word32
    type AttrLabel LayoutLineResolvedDirFieldInfo = "resolved_dir"
    type AttrOrigin LayoutLineResolvedDirFieldInfo = LayoutLine
    attrGet = getLayoutLineResolvedDir
    attrSet = setLayoutLineResolvedDir
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.resolvedDir"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#g:attr:resolvedDir"
        })

layoutLine_resolvedDir :: AttrLabelProxy "resolvedDir"
layoutLine_resolvedDir = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList LayoutLine
type instance O.AttributeList LayoutLine = LayoutLineAttributeList
type LayoutLineAttributeList = ('[ '("layout", LayoutLineLayoutFieldInfo), '("startIndex", LayoutLineStartIndexFieldInfo), '("length", LayoutLineLengthFieldInfo), '("runs", LayoutLineRunsFieldInfo), '("isParagraphStart", LayoutLineIsParagraphStartFieldInfo), '("resolvedDir", LayoutLineResolvedDirFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method LayoutLine::get_extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ink_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "rectangle used to store the extents of\n  the glyph string as drawn"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "rectangle used to store the logical\n  extents of the glyph string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_get_extents" pango_layout_line_get_extents :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    Ptr Pango.Rectangle.Rectangle ->        -- ink_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO ()

-- | Computes the logical and ink extents of a layout line.
-- 
-- See 'GI.Pango.Objects.Font.fontGetGlyphExtents' for details
-- about the interpretation of the rectangles.
layoutLineGetExtents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@line@/: a @PangoLayoutLine@
    -> m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))
layoutLineGetExtents line = liftIO $ do
    line' <- unsafeManagedPtrGetPtr line
    inkRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    logicalRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    pango_layout_line_get_extents line' inkRect logicalRect
    inkRect' <- (wrapPtr Pango.Rectangle.Rectangle) inkRect
    logicalRect' <- (wrapPtr Pango.Rectangle.Rectangle) logicalRect
    touchManagedPtr line
    return (inkRect', logicalRect')

#if defined(ENABLE_OVERLOADING)
data LayoutLineGetExtentsMethodInfo
instance (signature ~ (m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))), MonadIO m) => O.OverloadedMethod LayoutLineGetExtentsMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineGetExtents

instance O.OverloadedMethodInfo LayoutLineGetExtentsMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineGetExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineGetExtents"
        })


#endif

-- method LayoutLine::get_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the line height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_get_height" pango_layout_line_get_height :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    Ptr Int32 ->                            -- height : TBasicType TInt
    IO ()

-- | Computes the height of the line, as the maximum of the heights
-- of fonts used in this line.
-- 
-- Note that the actual baseline-to-baseline distance between lines
-- of text is influenced by other factors, such as
-- 'GI.Pango.Objects.Layout.layoutSetSpacing' and
-- 'GI.Pango.Objects.Layout.layoutSetLineSpacing'.
-- 
-- /Since: 1.44/
layoutLineGetHeight ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@line@/: a @PangoLayoutLine@
    -> m (Int32)
layoutLineGetHeight line = liftIO $ do
    line' <- unsafeManagedPtrGetPtr line
    height <- allocMem :: IO (Ptr Int32)
    pango_layout_line_get_height line' height
    height' <- peek height
    touchManagedPtr line
    freeMem height
    return height'

#if defined(ENABLE_OVERLOADING)
data LayoutLineGetHeightMethodInfo
instance (signature ~ (m (Int32)), MonadIO m) => O.OverloadedMethod LayoutLineGetHeightMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineGetHeight

instance O.OverloadedMethodInfo LayoutLineGetHeightMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineGetHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineGetHeight"
        })


#endif

-- method LayoutLine::get_length
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_get_length" pango_layout_line_get_length :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    IO Int32

-- | Returns the length of the line, in bytes.
-- 
-- /Since: 1.50/
layoutLineGetLength ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@line@/: a @PangoLayoutLine@
    -> m Int32
    -- ^ __Returns:__ the length of the line
layoutLineGetLength line = liftIO $ do
    line' <- unsafeManagedPtrGetPtr line
    result <- pango_layout_line_get_length line'
    touchManagedPtr line
    return result

#if defined(ENABLE_OVERLOADING)
data LayoutLineGetLengthMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod LayoutLineGetLengthMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineGetLength

instance O.OverloadedMethodInfo LayoutLineGetLengthMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineGetLength",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineGetLength"
        })


#endif

-- method LayoutLine::get_pixel_extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout_line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ink_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "rectangle used to store the extents of\n  the glyph string as drawn"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "rectangle used to store the logical\n  extents of the glyph string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_get_pixel_extents" pango_layout_line_get_pixel_extents :: 
    Ptr LayoutLine ->                       -- layout_line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    Ptr Pango.Rectangle.Rectangle ->        -- ink_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO ()

-- | Computes the logical and ink extents of /@layoutLine@/ in device units.
-- 
-- This function just calls 'GI.Pango.Structs.LayoutLine.layoutLineGetExtents' followed by
-- two [func/@extentsToPixels@/] calls, rounding /@inkRect@/ and /@logicalRect@/
-- such that the rounded rectangles fully contain the unrounded one (that is,
-- passes them as first argument to [func/@extentsToPixels@/]).
layoutLineGetPixelExtents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@layoutLine@/: a @PangoLayoutLine@
    -> m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))
layoutLineGetPixelExtents layoutLine = liftIO $ do
    layoutLine' <- unsafeManagedPtrGetPtr layoutLine
    inkRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    logicalRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    pango_layout_line_get_pixel_extents layoutLine' inkRect logicalRect
    inkRect' <- (wrapPtr Pango.Rectangle.Rectangle) inkRect
    logicalRect' <- (wrapPtr Pango.Rectangle.Rectangle) logicalRect
    touchManagedPtr layoutLine
    return (inkRect', logicalRect')

#if defined(ENABLE_OVERLOADING)
data LayoutLineGetPixelExtentsMethodInfo
instance (signature ~ (m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))), MonadIO m) => O.OverloadedMethod LayoutLineGetPixelExtentsMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineGetPixelExtents

instance O.OverloadedMethodInfo LayoutLineGetPixelExtentsMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineGetPixelExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineGetPixelExtents"
        })


#endif

-- method LayoutLine::get_resolved_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Direction" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_get_resolved_direction" pango_layout_line_get_resolved_direction :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    IO CUInt

-- | Returns the resolved direction of the line.
-- 
-- /Since: 1.50/
layoutLineGetResolvedDirection ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@line@/: a @PangoLayoutLine@
    -> m Pango.Enums.Direction
    -- ^ __Returns:__ the resolved direction of the line
layoutLineGetResolvedDirection line = liftIO $ do
    line' <- unsafeManagedPtrGetPtr line
    result <- pango_layout_line_get_resolved_direction line'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr line
    return result'

#if defined(ENABLE_OVERLOADING)
data LayoutLineGetResolvedDirectionMethodInfo
instance (signature ~ (m Pango.Enums.Direction), MonadIO m) => O.OverloadedMethod LayoutLineGetResolvedDirectionMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineGetResolvedDirection

instance O.OverloadedMethodInfo LayoutLineGetResolvedDirectionMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineGetResolvedDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineGetResolvedDirection"
        })


#endif

-- method LayoutLine::get_start_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_get_start_index" pango_layout_line_get_start_index :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    IO Int32

-- | Returns the start index of the line, as byte index
-- into the text of the layout.
-- 
-- /Since: 1.50/
layoutLineGetStartIndex ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@line@/: a @PangoLayoutLine@
    -> m Int32
    -- ^ __Returns:__ the start index of the line
layoutLineGetStartIndex line = liftIO $ do
    line' <- unsafeManagedPtrGetPtr line
    result <- pango_layout_line_get_start_index line'
    touchManagedPtr line
    return result

#if defined(ENABLE_OVERLOADING)
data LayoutLineGetStartIndexMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod LayoutLineGetStartIndexMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineGetStartIndex

instance O.OverloadedMethodInfo LayoutLineGetStartIndexMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineGetStartIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineGetStartIndex"
        })


#endif

-- method LayoutLine::get_x_ranges
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_index"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Start byte index of the logical range. If this value\n  is less than the start index for the line, then the first range\n  will extend all the way to the leading edge of the layout. Otherwise,\n  it will start at the leading edge of the first character."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end_index"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Ending byte index of the logical range. If this value is\n  greater than the end index for the line, then the last range will\n  extend all the way to the trailing edge of the layout. Otherwise,\n  it will end at the trailing edge of the last character."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ranges"
--           , argType = TCArray False (-1) 4 (TBasicType TInt)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to\n  store a pointer to an array of ranges. The array will be of length\n  `2*n_ranges`, with each range starting at `(*ranges)[2*n]` and of\n  width `(*ranges)[2*n + 1] - (*ranges)[2*n]`. This array must be freed\n  with g_free(). The coordinates are relative to the layout and are in\n  Pango units."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "n_ranges"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The number of ranges stored in @ranges"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_ranges"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "The number of ranges stored in @ranges"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_get_x_ranges" pango_layout_line_get_x_ranges :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    Int32 ->                                -- start_index : TBasicType TInt
    Int32 ->                                -- end_index : TBasicType TInt
    Ptr (Ptr Int32) ->                      -- ranges : TCArray False (-1) 4 (TBasicType TInt)
    Ptr Int32 ->                            -- n_ranges : TBasicType TInt
    IO ()

-- | Gets a list of visual ranges corresponding to a given logical range.
-- 
-- This list is not necessarily minimal - there may be consecutive
-- ranges which are adjacent. The ranges will be sorted from left to
-- right. The ranges are with respect to the left edge of the entire
-- layout, not with respect to the line.
layoutLineGetXRanges ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@line@/: a @PangoLayoutLine@
    -> Int32
    -- ^ /@startIndex@/: Start byte index of the logical range. If this value
    --   is less than the start index for the line, then the first range
    --   will extend all the way to the leading edge of the layout. Otherwise,
    --   it will start at the leading edge of the first character.
    -> Int32
    -- ^ /@endIndex@/: Ending byte index of the logical range. If this value is
    --   greater than the end index for the line, then the last range will
    --   extend all the way to the trailing edge of the layout. Otherwise,
    --   it will end at the trailing edge of the last character.
    -> m ([Int32])
layoutLineGetXRanges line startIndex endIndex = liftIO $ do
    line' <- unsafeManagedPtrGetPtr line
    ranges <- callocMem :: IO (Ptr (Ptr Int32))
    nRanges <- allocMem :: IO (Ptr Int32)
    pango_layout_line_get_x_ranges line' startIndex endIndex ranges nRanges
    nRanges' <- peek nRanges
    ranges' <- peek ranges
    ranges'' <- (unpackStorableArrayWithLength nRanges') ranges'
    freeMem ranges'
    touchManagedPtr line
    freeMem ranges
    freeMem nRanges
    return ranges''

#if defined(ENABLE_OVERLOADING)
data LayoutLineGetXRangesMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ([Int32])), MonadIO m) => O.OverloadedMethod LayoutLineGetXRangesMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineGetXRanges

instance O.OverloadedMethodInfo LayoutLineGetXRangesMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineGetXRanges",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineGetXRanges"
        })


#endif

-- method LayoutLine::index_to_x
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "byte offset of a grapheme within the layout"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "trailing"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "an integer indicating the edge of the grapheme to retrieve\n  the position of. If > 0, the trailing edge of the grapheme,\n  if 0, the leading of the grapheme"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_pos"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store the x_offset (in Pango units)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_index_to_x" pango_layout_line_index_to_x :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    Int32 ->                                -- index_ : TBasicType TInt
    CInt ->                                 -- trailing : TBasicType TBoolean
    Ptr Int32 ->                            -- x_pos : TBasicType TInt
    IO ()

-- | Converts an index within a line to a X position.
layoutLineIndexToX ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@line@/: a @PangoLayoutLine@
    -> Int32
    -- ^ /@index_@/: byte offset of a grapheme within the layout
    -> Bool
    -- ^ /@trailing@/: an integer indicating the edge of the grapheme to retrieve
    --   the position of. If > 0, the trailing edge of the grapheme,
    --   if 0, the leading of the grapheme
    -> m (Int32)
layoutLineIndexToX line index_ trailing = liftIO $ do
    line' <- unsafeManagedPtrGetPtr line
    let trailing' = (P.fromIntegral . P.fromEnum) trailing
    xPos <- allocMem :: IO (Ptr Int32)
    pango_layout_line_index_to_x line' index_ trailing' xPos
    xPos' <- peek xPos
    touchManagedPtr line
    freeMem xPos
    return xPos'

#if defined(ENABLE_OVERLOADING)
data LayoutLineIndexToXMethodInfo
instance (signature ~ (Int32 -> Bool -> m (Int32)), MonadIO m) => O.OverloadedMethod LayoutLineIndexToXMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineIndexToX

instance O.OverloadedMethodInfo LayoutLineIndexToXMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineIndexToX",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineIndexToX"
        })


#endif

-- method LayoutLine::is_paragraph_start
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_is_paragraph_start" pango_layout_line_is_paragraph_start :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    IO CInt

-- | Returns whether this is the first line of the paragraph.
-- 
-- /Since: 1.50/
layoutLineIsParagraphStart ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@line@/: a @PangoLayoutLine@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if this is the first line
layoutLineIsParagraphStart line = liftIO $ do
    line' <- unsafeManagedPtrGetPtr line
    result <- pango_layout_line_is_paragraph_start line'
    let result' = (/= 0) result
    touchManagedPtr line
    return result'

#if defined(ENABLE_OVERLOADING)
data LayoutLineIsParagraphStartMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod LayoutLineIsParagraphStartMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineIsParagraphStart

instance O.OverloadedMethodInfo LayoutLineIsParagraphStartMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineIsParagraphStart",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineIsParagraphStart"
        })


#endif

-- method LayoutLine::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "LayoutLine" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_ref" pango_layout_line_ref :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    IO (Ptr LayoutLine)

-- | Increase the reference count of a @PangoLayoutLine@ by one.
-- 
-- /Since: 1.10/
layoutLineRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (LayoutLine)
    -- ^ /@line@/: a @PangoLayoutLine@
    -> m (Maybe LayoutLine)
    -- ^ __Returns:__ the line passed in.
layoutLineRef line = liftIO $ do
    maybeLine <- case line of
        Nothing -> return FP.nullPtr
        Just jLine -> do
            jLine' <- unsafeManagedPtrGetPtr jLine
            return jLine'
    result <- pango_layout_line_ref maybeLine
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed LayoutLine) result'
        return result''
    whenJust line touchManagedPtr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data LayoutLineRefMethodInfo
instance (signature ~ (m (Maybe LayoutLine)), MonadIO m) => O.OverloadedMethod LayoutLineRefMethodInfo LayoutLine signature where
    overloadedMethod i = layoutLineRef (Just i)

instance O.OverloadedMethodInfo LayoutLineRefMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineRef"
        })


#endif

-- method LayoutLine::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_unref" pango_layout_line_unref :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    IO ()

-- | Decrease the reference count of a @PangoLayoutLine@ by one.
-- 
-- If the result is zero, the line and all associated memory
-- will be freed.
layoutLineUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@line@/: a @PangoLayoutLine@
    -> m ()
layoutLineUnref line = liftIO $ do
    line' <- unsafeManagedPtrGetPtr line
    pango_layout_line_unref line'
    touchManagedPtr line
    return ()

#if defined(ENABLE_OVERLOADING)
data LayoutLineUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod LayoutLineUnrefMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineUnref

instance O.OverloadedMethodInfo LayoutLineUnrefMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineUnref"
        })


#endif

-- method LayoutLine::x_to_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "line"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutLine" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutLine`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_pos"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the X offset (in Pango units) from the left edge of the line."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store calculated byte index for the grapheme\n  in which the user clicked"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "trailing"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store an integer indicating where in the\n  grapheme the user clicked. It will either be zero, or the number of\n  characters in the grapheme. 0 represents the leading edge of the grapheme."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_line_x_to_index" pango_layout_line_x_to_index :: 
    Ptr LayoutLine ->                       -- line : TInterface (Name {namespace = "Pango", name = "LayoutLine"})
    Int32 ->                                -- x_pos : TBasicType TInt
    Ptr Int32 ->                            -- index_ : TBasicType TInt
    Ptr Int32 ->                            -- trailing : TBasicType TInt
    IO CInt

-- | Converts from x offset to the byte index of the corresponding character
-- within the text of the layout.
-- 
-- If /@xPos@/ is outside the line, /@index_@/ and /@trailing@/ will point to the very
-- first or very last position in the line. This determination is based on the
-- resolved direction of the paragraph; for example, if the resolved direction
-- is right-to-left, then an X position to the right of the line (after it)
-- results in 0 being stored in /@index_@/ and /@trailing@/. An X position to the
-- left of the line results in /@index_@/ pointing to the (logical) last grapheme
-- in the line and /@trailing@/ being set to the number of characters in that
-- grapheme. The reverse is true for a left-to-right line.
layoutLineXToIndex ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutLine
    -- ^ /@line@/: a @PangoLayoutLine@
    -> Int32
    -- ^ /@xPos@/: the X offset (in Pango units) from the left edge of the line.
    -> m ((Bool, Int32, Int32))
    -- ^ __Returns:__ 'P.False' if /@xPos@/ was outside the line, 'P.True' if inside
layoutLineXToIndex line xPos = liftIO $ do
    line' <- unsafeManagedPtrGetPtr line
    index_ <- allocMem :: IO (Ptr Int32)
    trailing <- allocMem :: IO (Ptr Int32)
    result <- pango_layout_line_x_to_index line' xPos index_ trailing
    let result' = (/= 0) result
    index_' <- peek index_
    trailing' <- peek trailing
    touchManagedPtr line
    freeMem index_
    freeMem trailing
    return (result', index_', trailing')

#if defined(ENABLE_OVERLOADING)
data LayoutLineXToIndexMethodInfo
instance (signature ~ (Int32 -> m ((Bool, Int32, Int32))), MonadIO m) => O.OverloadedMethod LayoutLineXToIndexMethodInfo LayoutLine signature where
    overloadedMethod = layoutLineXToIndex

instance O.OverloadedMethodInfo LayoutLineXToIndexMethodInfo LayoutLine where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutLine.layoutLineXToIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutLine.html#v:layoutLineXToIndex"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveLayoutLineMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveLayoutLineMethod "indexToX" o = LayoutLineIndexToXMethodInfo
    ResolveLayoutLineMethod "isParagraphStart" o = LayoutLineIsParagraphStartMethodInfo
    ResolveLayoutLineMethod "ref" o = LayoutLineRefMethodInfo
    ResolveLayoutLineMethod "unref" o = LayoutLineUnrefMethodInfo
    ResolveLayoutLineMethod "xToIndex" o = LayoutLineXToIndexMethodInfo
    ResolveLayoutLineMethod "getExtents" o = LayoutLineGetExtentsMethodInfo
    ResolveLayoutLineMethod "getHeight" o = LayoutLineGetHeightMethodInfo
    ResolveLayoutLineMethod "getLength" o = LayoutLineGetLengthMethodInfo
    ResolveLayoutLineMethod "getPixelExtents" o = LayoutLineGetPixelExtentsMethodInfo
    ResolveLayoutLineMethod "getResolvedDirection" o = LayoutLineGetResolvedDirectionMethodInfo
    ResolveLayoutLineMethod "getStartIndex" o = LayoutLineGetStartIndexMethodInfo
    ResolveLayoutLineMethod "getXRanges" o = LayoutLineGetXRangesMethodInfo
    ResolveLayoutLineMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveLayoutLineMethod t LayoutLine, O.OverloadedMethod info LayoutLine p) => OL.IsLabel t (LayoutLine -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveLayoutLineMethod t LayoutLine, O.OverloadedMethod info LayoutLine p, R.HasField t LayoutLine p) => R.HasField t LayoutLine p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveLayoutLineMethod t LayoutLine, O.OverloadedMethodInfo info LayoutLine) => OL.IsLabel t (O.MethodProxy info LayoutLine) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


