{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Structure representing a name ID in a particular language.
-- 
-- /Since: 2.1.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.OtNameEntryT
    ( 

-- * Exported types
    OtNameEntryT(..)                        ,
    newZeroOtNameEntryT                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveOtNameEntryTMethod               ,
#endif



 -- * Properties


-- ** language #attr:language#
-- | language

    getOtNameEntryTLanguage                 ,
#if defined(ENABLE_OVERLOADING)
    otNameEntryT_language                   ,
#endif


-- ** nameId #attr:nameId#
-- | name ID

    getOtNameEntryTNameId                   ,
#if defined(ENABLE_OVERLOADING)
    otNameEntryT_nameId                     ,
#endif
    setOtNameEntryTNameId                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.LanguageT as HarfBuzz.LanguageT

#else
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.LanguageT as HarfBuzz.LanguageT

#endif

-- | Memory-managed wrapper type.
newtype OtNameEntryT = OtNameEntryT (SP.ManagedPtr OtNameEntryT)
    deriving (Eq)

instance SP.ManagedPtrNewtype OtNameEntryT where
    toManagedPtr (OtNameEntryT p) = p

instance BoxedPtr OtNameEntryT where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr OtNameEntryT)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr OtNameEntryT where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'OtNameEntryT' struct initialized to zero.
newZeroOtNameEntryT :: MonadIO m => m OtNameEntryT
newZeroOtNameEntryT = liftIO $ boxedPtrCalloc >>= wrapPtr OtNameEntryT

instance tag ~ 'AttrSet => Constructible OtNameEntryT tag where
    new _ attrs = do
        o <- newZeroOtNameEntryT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@name_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otNameEntryT #nameId
-- @
getOtNameEntryTNameId :: MonadIO m => OtNameEntryT -> m Word32
getOtNameEntryTNameId s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@name_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otNameEntryT [ #nameId 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtNameEntryTNameId :: MonadIO m => OtNameEntryT -> Word32 -> m ()
setOtNameEntryTNameId s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OtNameEntryTNameIdFieldInfo
instance AttrInfo OtNameEntryTNameIdFieldInfo where
    type AttrBaseTypeConstraint OtNameEntryTNameIdFieldInfo = (~) OtNameEntryT
    type AttrAllowedOps OtNameEntryTNameIdFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtNameEntryTNameIdFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OtNameEntryTNameIdFieldInfo = (~)Word32
    type AttrTransferType OtNameEntryTNameIdFieldInfo = Word32
    type AttrGetType OtNameEntryTNameIdFieldInfo = Word32
    type AttrLabel OtNameEntryTNameIdFieldInfo = "name_id"
    type AttrOrigin OtNameEntryTNameIdFieldInfo = OtNameEntryT
    attrGet = getOtNameEntryTNameId
    attrSet = setOtNameEntryTNameId
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtNameEntryT.nameId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtNameEntryT.html#g:attr:nameId"
        })

otNameEntryT_nameId :: AttrLabelProxy "nameId"
otNameEntryT_nameId = AttrLabelProxy

#endif


-- | Get the value of the “@language@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otNameEntryT #language
-- @
getOtNameEntryTLanguage :: MonadIO m => OtNameEntryT -> m HarfBuzz.LanguageT.LanguageT
getOtNameEntryTLanguage s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 8 :: (Ptr HarfBuzz.LanguageT.LanguageT)
    val' <- (newPtr HarfBuzz.LanguageT.LanguageT) val
    return val'

#if defined(ENABLE_OVERLOADING)
data OtNameEntryTLanguageFieldInfo
instance AttrInfo OtNameEntryTLanguageFieldInfo where
    type AttrBaseTypeConstraint OtNameEntryTLanguageFieldInfo = (~) OtNameEntryT
    type AttrAllowedOps OtNameEntryTLanguageFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint OtNameEntryTLanguageFieldInfo = (~) (Ptr HarfBuzz.LanguageT.LanguageT)
    type AttrTransferTypeConstraint OtNameEntryTLanguageFieldInfo = (~)(Ptr HarfBuzz.LanguageT.LanguageT)
    type AttrTransferType OtNameEntryTLanguageFieldInfo = (Ptr HarfBuzz.LanguageT.LanguageT)
    type AttrGetType OtNameEntryTLanguageFieldInfo = HarfBuzz.LanguageT.LanguageT
    type AttrLabel OtNameEntryTLanguageFieldInfo = "language"
    type AttrOrigin OtNameEntryTLanguageFieldInfo = OtNameEntryT
    attrGet = getOtNameEntryTLanguage
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtNameEntryT.language"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtNameEntryT.html#g:attr:language"
        })

otNameEntryT_language :: AttrLabelProxy "language"
otNameEntryT_language = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OtNameEntryT
type instance O.AttributeList OtNameEntryT = OtNameEntryTAttributeList
type OtNameEntryTAttributeList = ('[ '("nameId", OtNameEntryTNameIdFieldInfo), '("language", OtNameEntryTLanguageFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOtNameEntryTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOtNameEntryTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOtNameEntryTMethod t OtNameEntryT, O.OverloadedMethod info OtNameEntryT p) => OL.IsLabel t (OtNameEntryT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOtNameEntryTMethod t OtNameEntryT, O.OverloadedMethod info OtNameEntryT p, R.HasField t OtNameEntryT p) => R.HasField t OtNameEntryT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOtNameEntryTMethod t OtNameEntryT, O.OverloadedMethodInfo info OtNameEntryT) => OL.IsLabel t (O.MethodProxy info OtNameEntryT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


