{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A struct containing color information for a gradient.
-- 
-- /Since: 7.0.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.ColorLineT
    ( 

-- * Exported types
    ColorLineT(..)                          ,
    newZeroColorLineT                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveColorLineTMethod                 ,
#endif



 -- * Properties


-- ** data #attr:data#
-- | /No description available in the introspection data./

    clearColorLineTData                     ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_data                         ,
#endif
    getColorLineTData                       ,
    setColorLineTData                       ,


-- ** getColorStops #attr:getColorStops#
-- | /No description available in the introspection data./

    clearColorLineTGetColorStops            ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_getColorStops                ,
#endif
    getColorLineTGetColorStops              ,
    setColorLineTGetColorStops              ,


-- ** getColorStopsUserData #attr:getColorStopsUserData#
-- | /No description available in the introspection data./

    clearColorLineTGetColorStopsUserData    ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_getColorStopsUserData        ,
#endif
    getColorLineTGetColorStopsUserData      ,
    setColorLineTGetColorStopsUserData      ,


-- ** getExtend #attr:getExtend#
-- | /No description available in the introspection data./

    clearColorLineTGetExtend                ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_getExtend                    ,
#endif
    getColorLineTGetExtend                  ,
    setColorLineTGetExtend                  ,


-- ** getExtendUserData #attr:getExtendUserData#
-- | /No description available in the introspection data./

    clearColorLineTGetExtendUserData        ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_getExtendUserData            ,
#endif
    getColorLineTGetExtendUserData          ,
    setColorLineTGetExtendUserData          ,


-- ** reserved0 #attr:reserved0#
-- | /No description available in the introspection data./

    clearColorLineTReserved0                ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_reserved0                    ,
#endif
    getColorLineTReserved0                  ,
    setColorLineTReserved0                  ,


-- ** reserved1 #attr:reserved1#
-- | /No description available in the introspection data./

    clearColorLineTReserved1                ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_reserved1                    ,
#endif
    getColorLineTReserved1                  ,
    setColorLineTReserved1                  ,


-- ** reserved2 #attr:reserved2#
-- | /No description available in the introspection data./

    clearColorLineTReserved2                ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_reserved2                    ,
#endif
    getColorLineTReserved2                  ,
    setColorLineTReserved2                  ,


-- ** reserved3 #attr:reserved3#
-- | /No description available in the introspection data./

    clearColorLineTReserved3                ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_reserved3                    ,
#endif
    getColorLineTReserved3                  ,
    setColorLineTReserved3                  ,


-- ** reserved5 #attr:reserved5#
-- | /No description available in the introspection data./

    clearColorLineTReserved5                ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_reserved5                    ,
#endif
    getColorLineTReserved5                  ,
    setColorLineTReserved5                  ,


-- ** reserved6 #attr:reserved6#
-- | /No description available in the introspection data./

    clearColorLineTReserved6                ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_reserved6                    ,
#endif
    getColorLineTReserved6                  ,
    setColorLineTReserved6                  ,


-- ** reserved7 #attr:reserved7#
-- | /No description available in the introspection data./

    clearColorLineTReserved7                ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_reserved7                    ,
#endif
    getColorLineTReserved7                  ,
    setColorLineTReserved7                  ,


-- ** reserved8 #attr:reserved8#
-- | /No description available in the introspection data./

    clearColorLineTReserved8                ,
#if defined(ENABLE_OVERLOADING)
    colorLineT_reserved8                    ,
#endif
    getColorLineTReserved8                  ,
    setColorLineTReserved8                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.HarfBuzz.Callbacks as HarfBuzz.Callbacks

#else
import qualified GI.HarfBuzz.Callbacks as HarfBuzz.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype ColorLineT = ColorLineT (SP.ManagedPtr ColorLineT)
    deriving (Eq)

instance SP.ManagedPtrNewtype ColorLineT where
    toManagedPtr (ColorLineT p) = p

foreign import ccall "hb_gobject_color_line_get_type" c_hb_gobject_color_line_get_type :: 
    IO GType

type instance O.ParentTypes ColorLineT = '[]
instance O.HasParentTypes ColorLineT

instance B.Types.TypedObject ColorLineT where
    glibType = c_hb_gobject_color_line_get_type

instance B.Types.GBoxed ColorLineT

-- | Convert t'ColorLineT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ColorLineT) where
    gvalueGType_ = c_hb_gobject_color_line_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr ColorLineT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr ColorLineT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed ColorLineT ptr
        else return P.Nothing
        
    

-- | Construct a t'ColorLineT' struct initialized to zero.
newZeroColorLineT :: MonadIO m => m ColorLineT
newZeroColorLineT = liftIO $ callocBoxedBytes 104 >>= wrapBoxed ColorLineT

instance tag ~ 'AttrSet => Constructible ColorLineT tag where
    new _ attrs = do
        o <- newZeroColorLineT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #data
-- @
getColorLineTData :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTData s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr ())
    return val

-- | Set the value of the “@data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #data 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTData :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTData s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr ())

-- | Set the value of the “@data@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #data
-- @
clearColorLineTData :: MonadIO m => ColorLineT -> m ()
clearColorLineTData s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTDataFieldInfo
instance AttrInfo ColorLineTDataFieldInfo where
    type AttrBaseTypeConstraint ColorLineTDataFieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTDataFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTDataFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTDataFieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTDataFieldInfo = (Ptr ())
    type AttrGetType ColorLineTDataFieldInfo = Ptr ()
    type AttrLabel ColorLineTDataFieldInfo = "data"
    type AttrOrigin ColorLineTDataFieldInfo = ColorLineT
    attrGet = getColorLineTData
    attrSet = setColorLineTData
    attrConstruct = undefined
    attrClear = clearColorLineTData
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.data"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:data"
        })

colorLineT_data :: AttrLabelProxy "data"
colorLineT_data = AttrLabelProxy

#endif


-- | Get the value of the “@get_color_stops@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #getColorStops
-- @
getColorLineTGetColorStops :: MonadIO m => ColorLineT -> m (Maybe HarfBuzz.Callbacks.ColorLineGetColorStopsFuncT_WithClosures)
getColorLineTGetColorStops s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr HarfBuzz.Callbacks.C_ColorLineGetColorStopsFuncT)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = HarfBuzz.Callbacks.dynamic_ColorLineGetColorStopsFuncT val'
        return val''
    return result

-- | Set the value of the “@get_color_stops@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #getColorStops 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTGetColorStops :: MonadIO m => ColorLineT -> FunPtr HarfBuzz.Callbacks.C_ColorLineGetColorStopsFuncT -> m ()
setColorLineTGetColorStops s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr HarfBuzz.Callbacks.C_ColorLineGetColorStopsFuncT)

-- | Set the value of the “@get_color_stops@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #getColorStops
-- @
clearColorLineTGetColorStops :: MonadIO m => ColorLineT -> m ()
clearColorLineTGetColorStops s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr HarfBuzz.Callbacks.C_ColorLineGetColorStopsFuncT)

#if defined(ENABLE_OVERLOADING)
data ColorLineTGetColorStopsFieldInfo
instance AttrInfo ColorLineTGetColorStopsFieldInfo where
    type AttrBaseTypeConstraint ColorLineTGetColorStopsFieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTGetColorStopsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTGetColorStopsFieldInfo = (~) (FunPtr HarfBuzz.Callbacks.C_ColorLineGetColorStopsFuncT)
    type AttrTransferTypeConstraint ColorLineTGetColorStopsFieldInfo = (~)HarfBuzz.Callbacks.ColorLineGetColorStopsFuncT_WithClosures
    type AttrTransferType ColorLineTGetColorStopsFieldInfo = (FunPtr HarfBuzz.Callbacks.C_ColorLineGetColorStopsFuncT)
    type AttrGetType ColorLineTGetColorStopsFieldInfo = Maybe HarfBuzz.Callbacks.ColorLineGetColorStopsFuncT_WithClosures
    type AttrLabel ColorLineTGetColorStopsFieldInfo = "get_color_stops"
    type AttrOrigin ColorLineTGetColorStopsFieldInfo = ColorLineT
    attrGet = getColorLineTGetColorStops
    attrSet = setColorLineTGetColorStops
    attrConstruct = undefined
    attrClear = clearColorLineTGetColorStops
    attrTransfer _ v = do
        HarfBuzz.Callbacks.mk_ColorLineGetColorStopsFuncT (HarfBuzz.Callbacks.wrap_ColorLineGetColorStopsFuncT Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.getColorStops"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:getColorStops"
        })

colorLineT_getColorStops :: AttrLabelProxy "getColorStops"
colorLineT_getColorStops = AttrLabelProxy

#endif


-- | Get the value of the “@get_color_stops_user_data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #getColorStopsUserData
-- @
getColorLineTGetColorStopsUserData :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTGetColorStopsUserData s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr ())
    return val

-- | Set the value of the “@get_color_stops_user_data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #getColorStopsUserData 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTGetColorStopsUserData :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTGetColorStopsUserData s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr ())

-- | Set the value of the “@get_color_stops_user_data@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #getColorStopsUserData
-- @
clearColorLineTGetColorStopsUserData :: MonadIO m => ColorLineT -> m ()
clearColorLineTGetColorStopsUserData s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTGetColorStopsUserDataFieldInfo
instance AttrInfo ColorLineTGetColorStopsUserDataFieldInfo where
    type AttrBaseTypeConstraint ColorLineTGetColorStopsUserDataFieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTGetColorStopsUserDataFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTGetColorStopsUserDataFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTGetColorStopsUserDataFieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTGetColorStopsUserDataFieldInfo = (Ptr ())
    type AttrGetType ColorLineTGetColorStopsUserDataFieldInfo = Ptr ()
    type AttrLabel ColorLineTGetColorStopsUserDataFieldInfo = "get_color_stops_user_data"
    type AttrOrigin ColorLineTGetColorStopsUserDataFieldInfo = ColorLineT
    attrGet = getColorLineTGetColorStopsUserData
    attrSet = setColorLineTGetColorStopsUserData
    attrConstruct = undefined
    attrClear = clearColorLineTGetColorStopsUserData
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.getColorStopsUserData"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:getColorStopsUserData"
        })

colorLineT_getColorStopsUserData :: AttrLabelProxy "getColorStopsUserData"
colorLineT_getColorStopsUserData = AttrLabelProxy

#endif


-- | Get the value of the “@get_extend@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #getExtend
-- @
getColorLineTGetExtend :: MonadIO m => ColorLineT -> m (Maybe HarfBuzz.Callbacks.ColorLineGetExtendFuncT_WithClosures)
getColorLineTGetExtend s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr HarfBuzz.Callbacks.C_ColorLineGetExtendFuncT)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = HarfBuzz.Callbacks.dynamic_ColorLineGetExtendFuncT val'
        return val''
    return result

-- | Set the value of the “@get_extend@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #getExtend 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTGetExtend :: MonadIO m => ColorLineT -> FunPtr HarfBuzz.Callbacks.C_ColorLineGetExtendFuncT -> m ()
setColorLineTGetExtend s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr HarfBuzz.Callbacks.C_ColorLineGetExtendFuncT)

-- | Set the value of the “@get_extend@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #getExtend
-- @
clearColorLineTGetExtend :: MonadIO m => ColorLineT -> m ()
clearColorLineTGetExtend s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr HarfBuzz.Callbacks.C_ColorLineGetExtendFuncT)

#if defined(ENABLE_OVERLOADING)
data ColorLineTGetExtendFieldInfo
instance AttrInfo ColorLineTGetExtendFieldInfo where
    type AttrBaseTypeConstraint ColorLineTGetExtendFieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTGetExtendFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTGetExtendFieldInfo = (~) (FunPtr HarfBuzz.Callbacks.C_ColorLineGetExtendFuncT)
    type AttrTransferTypeConstraint ColorLineTGetExtendFieldInfo = (~)HarfBuzz.Callbacks.ColorLineGetExtendFuncT_WithClosures
    type AttrTransferType ColorLineTGetExtendFieldInfo = (FunPtr HarfBuzz.Callbacks.C_ColorLineGetExtendFuncT)
    type AttrGetType ColorLineTGetExtendFieldInfo = Maybe HarfBuzz.Callbacks.ColorLineGetExtendFuncT_WithClosures
    type AttrLabel ColorLineTGetExtendFieldInfo = "get_extend"
    type AttrOrigin ColorLineTGetExtendFieldInfo = ColorLineT
    attrGet = getColorLineTGetExtend
    attrSet = setColorLineTGetExtend
    attrConstruct = undefined
    attrClear = clearColorLineTGetExtend
    attrTransfer _ v = do
        HarfBuzz.Callbacks.mk_ColorLineGetExtendFuncT (HarfBuzz.Callbacks.wrap_ColorLineGetExtendFuncT Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.getExtend"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:getExtend"
        })

colorLineT_getExtend :: AttrLabelProxy "getExtend"
colorLineT_getExtend = AttrLabelProxy

#endif


-- | Get the value of the “@get_extend_user_data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #getExtendUserData
-- @
getColorLineTGetExtendUserData :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTGetExtendUserData s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (Ptr ())
    return val

-- | Set the value of the “@get_extend_user_data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #getExtendUserData 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTGetExtendUserData :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTGetExtendUserData s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Ptr ())

-- | Set the value of the “@get_extend_user_data@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #getExtendUserData
-- @
clearColorLineTGetExtendUserData :: MonadIO m => ColorLineT -> m ()
clearColorLineTGetExtendUserData s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTGetExtendUserDataFieldInfo
instance AttrInfo ColorLineTGetExtendUserDataFieldInfo where
    type AttrBaseTypeConstraint ColorLineTGetExtendUserDataFieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTGetExtendUserDataFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTGetExtendUserDataFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTGetExtendUserDataFieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTGetExtendUserDataFieldInfo = (Ptr ())
    type AttrGetType ColorLineTGetExtendUserDataFieldInfo = Ptr ()
    type AttrLabel ColorLineTGetExtendUserDataFieldInfo = "get_extend_user_data"
    type AttrOrigin ColorLineTGetExtendUserDataFieldInfo = ColorLineT
    attrGet = getColorLineTGetExtendUserData
    attrSet = setColorLineTGetExtendUserData
    attrConstruct = undefined
    attrClear = clearColorLineTGetExtendUserData
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.getExtendUserData"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:getExtendUserData"
        })

colorLineT_getExtendUserData :: AttrLabelProxy "getExtendUserData"
colorLineT_getExtendUserData = AttrLabelProxy

#endif


-- | Get the value of the “@reserved0@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #reserved0
-- @
getColorLineTReserved0 :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTReserved0 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (Ptr ())
    return val

-- | Set the value of the “@reserved0@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #reserved0 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTReserved0 :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTReserved0 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: Ptr ())

-- | Set the value of the “@reserved0@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #reserved0
-- @
clearColorLineTReserved0 :: MonadIO m => ColorLineT -> m ()
clearColorLineTReserved0 s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTReserved0FieldInfo
instance AttrInfo ColorLineTReserved0FieldInfo where
    type AttrBaseTypeConstraint ColorLineTReserved0FieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTReserved0FieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTReserved0FieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTReserved0FieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTReserved0FieldInfo = (Ptr ())
    type AttrGetType ColorLineTReserved0FieldInfo = Ptr ()
    type AttrLabel ColorLineTReserved0FieldInfo = "reserved0"
    type AttrOrigin ColorLineTReserved0FieldInfo = ColorLineT
    attrGet = getColorLineTReserved0
    attrSet = setColorLineTReserved0
    attrConstruct = undefined
    attrClear = clearColorLineTReserved0
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.reserved0"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:reserved0"
        })

colorLineT_reserved0 :: AttrLabelProxy "reserved0"
colorLineT_reserved0 = AttrLabelProxy

#endif


-- | Get the value of the “@reserved1@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #reserved1
-- @
getColorLineTReserved1 :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTReserved1 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO (Ptr ())
    return val

-- | Set the value of the “@reserved1@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #reserved1 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTReserved1 :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTReserved1 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: Ptr ())

-- | Set the value of the “@reserved1@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #reserved1
-- @
clearColorLineTReserved1 :: MonadIO m => ColorLineT -> m ()
clearColorLineTReserved1 s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTReserved1FieldInfo
instance AttrInfo ColorLineTReserved1FieldInfo where
    type AttrBaseTypeConstraint ColorLineTReserved1FieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTReserved1FieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTReserved1FieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTReserved1FieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTReserved1FieldInfo = (Ptr ())
    type AttrGetType ColorLineTReserved1FieldInfo = Ptr ()
    type AttrLabel ColorLineTReserved1FieldInfo = "reserved1"
    type AttrOrigin ColorLineTReserved1FieldInfo = ColorLineT
    attrGet = getColorLineTReserved1
    attrSet = setColorLineTReserved1
    attrConstruct = undefined
    attrClear = clearColorLineTReserved1
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.reserved1"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:reserved1"
        })

colorLineT_reserved1 :: AttrLabelProxy "reserved1"
colorLineT_reserved1 = AttrLabelProxy

#endif


-- | Get the value of the “@reserved2@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #reserved2
-- @
getColorLineTReserved2 :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTReserved2 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO (Ptr ())
    return val

-- | Set the value of the “@reserved2@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #reserved2 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTReserved2 :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTReserved2 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: Ptr ())

-- | Set the value of the “@reserved2@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #reserved2
-- @
clearColorLineTReserved2 :: MonadIO m => ColorLineT -> m ()
clearColorLineTReserved2 s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTReserved2FieldInfo
instance AttrInfo ColorLineTReserved2FieldInfo where
    type AttrBaseTypeConstraint ColorLineTReserved2FieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTReserved2FieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTReserved2FieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTReserved2FieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTReserved2FieldInfo = (Ptr ())
    type AttrGetType ColorLineTReserved2FieldInfo = Ptr ()
    type AttrLabel ColorLineTReserved2FieldInfo = "reserved2"
    type AttrOrigin ColorLineTReserved2FieldInfo = ColorLineT
    attrGet = getColorLineTReserved2
    attrSet = setColorLineTReserved2
    attrConstruct = undefined
    attrClear = clearColorLineTReserved2
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.reserved2"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:reserved2"
        })

colorLineT_reserved2 :: AttrLabelProxy "reserved2"
colorLineT_reserved2 = AttrLabelProxy

#endif


-- | Get the value of the “@reserved3@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #reserved3
-- @
getColorLineTReserved3 :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTReserved3 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO (Ptr ())
    return val

-- | Set the value of the “@reserved3@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #reserved3 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTReserved3 :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTReserved3 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (val :: Ptr ())

-- | Set the value of the “@reserved3@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #reserved3
-- @
clearColorLineTReserved3 :: MonadIO m => ColorLineT -> m ()
clearColorLineTReserved3 s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTReserved3FieldInfo
instance AttrInfo ColorLineTReserved3FieldInfo where
    type AttrBaseTypeConstraint ColorLineTReserved3FieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTReserved3FieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTReserved3FieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTReserved3FieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTReserved3FieldInfo = (Ptr ())
    type AttrGetType ColorLineTReserved3FieldInfo = Ptr ()
    type AttrLabel ColorLineTReserved3FieldInfo = "reserved3"
    type AttrOrigin ColorLineTReserved3FieldInfo = ColorLineT
    attrGet = getColorLineTReserved3
    attrSet = setColorLineTReserved3
    attrConstruct = undefined
    attrClear = clearColorLineTReserved3
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.reserved3"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:reserved3"
        })

colorLineT_reserved3 :: AttrLabelProxy "reserved3"
colorLineT_reserved3 = AttrLabelProxy

#endif


-- | Get the value of the “@reserved5@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #reserved5
-- @
getColorLineTReserved5 :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTReserved5 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO (Ptr ())
    return val

-- | Set the value of the “@reserved5@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #reserved5 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTReserved5 :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTReserved5 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 72) (val :: Ptr ())

-- | Set the value of the “@reserved5@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #reserved5
-- @
clearColorLineTReserved5 :: MonadIO m => ColorLineT -> m ()
clearColorLineTReserved5 s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 72) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTReserved5FieldInfo
instance AttrInfo ColorLineTReserved5FieldInfo where
    type AttrBaseTypeConstraint ColorLineTReserved5FieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTReserved5FieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTReserved5FieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTReserved5FieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTReserved5FieldInfo = (Ptr ())
    type AttrGetType ColorLineTReserved5FieldInfo = Ptr ()
    type AttrLabel ColorLineTReserved5FieldInfo = "reserved5"
    type AttrOrigin ColorLineTReserved5FieldInfo = ColorLineT
    attrGet = getColorLineTReserved5
    attrSet = setColorLineTReserved5
    attrConstruct = undefined
    attrClear = clearColorLineTReserved5
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.reserved5"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:reserved5"
        })

colorLineT_reserved5 :: AttrLabelProxy "reserved5"
colorLineT_reserved5 = AttrLabelProxy

#endif


-- | Get the value of the “@reserved6@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #reserved6
-- @
getColorLineTReserved6 :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTReserved6 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 80) :: IO (Ptr ())
    return val

-- | Set the value of the “@reserved6@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #reserved6 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTReserved6 :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTReserved6 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 80) (val :: Ptr ())

-- | Set the value of the “@reserved6@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #reserved6
-- @
clearColorLineTReserved6 :: MonadIO m => ColorLineT -> m ()
clearColorLineTReserved6 s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 80) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTReserved6FieldInfo
instance AttrInfo ColorLineTReserved6FieldInfo where
    type AttrBaseTypeConstraint ColorLineTReserved6FieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTReserved6FieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTReserved6FieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTReserved6FieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTReserved6FieldInfo = (Ptr ())
    type AttrGetType ColorLineTReserved6FieldInfo = Ptr ()
    type AttrLabel ColorLineTReserved6FieldInfo = "reserved6"
    type AttrOrigin ColorLineTReserved6FieldInfo = ColorLineT
    attrGet = getColorLineTReserved6
    attrSet = setColorLineTReserved6
    attrConstruct = undefined
    attrClear = clearColorLineTReserved6
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.reserved6"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:reserved6"
        })

colorLineT_reserved6 :: AttrLabelProxy "reserved6"
colorLineT_reserved6 = AttrLabelProxy

#endif


-- | Get the value of the “@reserved7@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #reserved7
-- @
getColorLineTReserved7 :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTReserved7 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 88) :: IO (Ptr ())
    return val

-- | Set the value of the “@reserved7@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #reserved7 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTReserved7 :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTReserved7 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 88) (val :: Ptr ())

-- | Set the value of the “@reserved7@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #reserved7
-- @
clearColorLineTReserved7 :: MonadIO m => ColorLineT -> m ()
clearColorLineTReserved7 s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 88) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTReserved7FieldInfo
instance AttrInfo ColorLineTReserved7FieldInfo where
    type AttrBaseTypeConstraint ColorLineTReserved7FieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTReserved7FieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTReserved7FieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTReserved7FieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTReserved7FieldInfo = (Ptr ())
    type AttrGetType ColorLineTReserved7FieldInfo = Ptr ()
    type AttrLabel ColorLineTReserved7FieldInfo = "reserved7"
    type AttrOrigin ColorLineTReserved7FieldInfo = ColorLineT
    attrGet = getColorLineTReserved7
    attrSet = setColorLineTReserved7
    attrConstruct = undefined
    attrClear = clearColorLineTReserved7
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.reserved7"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:reserved7"
        })

colorLineT_reserved7 :: AttrLabelProxy "reserved7"
colorLineT_reserved7 = AttrLabelProxy

#endif


-- | Get the value of the “@reserved8@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorLineT #reserved8
-- @
getColorLineTReserved8 :: MonadIO m => ColorLineT -> m (Ptr ())
getColorLineTReserved8 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 96) :: IO (Ptr ())
    return val

-- | Set the value of the “@reserved8@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorLineT [ #reserved8 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorLineTReserved8 :: MonadIO m => ColorLineT -> Ptr () -> m ()
setColorLineTReserved8 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 96) (val :: Ptr ())

-- | Set the value of the “@reserved8@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #reserved8
-- @
clearColorLineTReserved8 :: MonadIO m => ColorLineT -> m ()
clearColorLineTReserved8 s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 96) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ColorLineTReserved8FieldInfo
instance AttrInfo ColorLineTReserved8FieldInfo where
    type AttrBaseTypeConstraint ColorLineTReserved8FieldInfo = (~) ColorLineT
    type AttrAllowedOps ColorLineTReserved8FieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ColorLineTReserved8FieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ColorLineTReserved8FieldInfo = (~)(Ptr ())
    type AttrTransferType ColorLineTReserved8FieldInfo = (Ptr ())
    type AttrGetType ColorLineTReserved8FieldInfo = Ptr ()
    type AttrLabel ColorLineTReserved8FieldInfo = "reserved8"
    type AttrOrigin ColorLineTReserved8FieldInfo = ColorLineT
    attrGet = getColorLineTReserved8
    attrSet = setColorLineTReserved8
    attrConstruct = undefined
    attrClear = clearColorLineTReserved8
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorLineT.reserved8"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorLineT.html#g:attr:reserved8"
        })

colorLineT_reserved8 :: AttrLabelProxy "reserved8"
colorLineT_reserved8 = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ColorLineT
type instance O.AttributeList ColorLineT = ColorLineTAttributeList
type ColorLineTAttributeList = ('[ '("data", ColorLineTDataFieldInfo), '("getColorStops", ColorLineTGetColorStopsFieldInfo), '("getColorStopsUserData", ColorLineTGetColorStopsUserDataFieldInfo), '("getExtend", ColorLineTGetExtendFieldInfo), '("getExtendUserData", ColorLineTGetExtendUserDataFieldInfo), '("reserved0", ColorLineTReserved0FieldInfo), '("reserved1", ColorLineTReserved1FieldInfo), '("reserved2", ColorLineTReserved2FieldInfo), '("reserved3", ColorLineTReserved3FieldInfo), '("reserved5", ColorLineTReserved5FieldInfo), '("reserved6", ColorLineTReserved6FieldInfo), '("reserved7", ColorLineTReserved7FieldInfo), '("reserved8", ColorLineTReserved8FieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveColorLineTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColorLineTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColorLineTMethod t ColorLineT, O.OverloadedMethod info ColorLineT p) => OL.IsLabel t (ColorLineT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColorLineTMethod t ColorLineT, O.OverloadedMethod info ColorLineT p, R.HasField t ColorLineT p) => R.HasField t ColorLineT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColorLineTMethod t ColorLineT, O.OverloadedMethodInfo info ColorLineT) => OL.IsLabel t (O.MethodProxy info ColorLineT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


